(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   7501139,     125605]
NotebookOptionsPosition[   7498942,     125534]
NotebookOutlinePosition[   7499287,     125549]
CellTagsIndexPosition[   7499244,     125546]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myDir", "=", 
  "\"\<E:\\\\Dropbox\\\\Mis_Documentos\\\\My_papers\\\\87Rb133Cs\\\\2019\\\\\
Phil_data_11_02_2019\\\\Phil_data\\\\Fitting_beta_0_90_at_once\\\\beta_0\>\""}\
]], "Input",
 CellChangeTimes->{{3.6935999549200926`*^9, 3.693599957482935*^9}, {
   3.6935999996269164`*^9, 3.693600003029935*^9}, {3.693600057254778*^9, 
   3.6936000774003253`*^9}, 3.693601743489667*^9, {3.693602955722703*^9, 
   3.6936029563293314`*^9}, 3.69730959969602*^9, {3.759169295283514*^9, 
   3.759169310024805*^9}, {3.759169343271761*^9, 3.7591693503780036`*^9}, {
   3.759410207376335*^9, 3.759410223332336*^9}}],

Cell[BoxData["\<\"E:\\\\Dropbox\\\\Mis_Documentos\\\\My_papers\\\\87Rb133Cs\\\
\\2019\\\\Phil_data_11_02_2019\\\\Phil_data\\\\Fitting_beta_0_90_at_once\\\\\
beta_0\"\>"], "Output",
 CellChangeTimes->{3.6936026727666073`*^9, 3.6936029758200607`*^9, 
  3.693773067717843*^9, 3.69377359067001*^9, 3.697311207771617*^9, 
  3.6973112567692127`*^9, 3.697311587862959*^9, 3.759169314250387*^9, 
  3.7591693517366543`*^9, 3.759171180203915*^9, 3.7593495906949606`*^9, 
  3.7594102388578434`*^9, 3.759411004116926*^9, 3.7594190362421455`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "myDir", "]"}]], "Input",
 CellChangeTimes->{{3.6936002658317504`*^9, 3.693600275030756*^9}}],

Cell[BoxData["\<\"E:\\\\Dropbox\\\\Mis_Documentos\\\\My_papers\\\\87Rb133Cs\\\
\\2019\\\\Phil_data_11_02_2019\\\\Phil_data\\\\Fitting_beta_0_90_at_once\\\\\
beta_0\"\>"], "Output",
 CellChangeTimes->{3.693600276111191*^9, 3.69360116693827*^9, 
  3.6936017492651186`*^9, 3.6936026727786274`*^9, 3.6936029758260765`*^9, 
  3.6937730677368555`*^9, 3.693773590691171*^9, 3.697311207791669*^9, 
  3.6973112567752542`*^9, 3.697311587884036*^9, 3.75916931611397*^9, 
  3.7591693533685017`*^9, 3.7591711824593782`*^9, 3.7593495907139378`*^9, 
  3.7594102388777623`*^9, 3.7594110041268997`*^9, 3.7594190362421455`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"ni", "=", " ", 
     RowBox[{"number", " ", "of", " ", "intensities"}]}], "*)"}],
   FontFamily->"DejaVu Serif"], 
  StyleBox["\[IndentingNewLine]",
   FontFamily->"DejaVu Serif"], 
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"nl", "=", " ", 
     RowBox[{"number", " ", "of", " ", "lines"}]}], " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ni", "=", "201"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nl", "=", "96"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.689694059269452*^9, 3.689694064002336*^9}, {
   3.6896941238238187`*^9, 3.689694125569996*^9}, {3.689752559259322*^9, 
   3.689752565733532*^9}, {3.68975264856147*^9, 3.689752649082982*^9}, 
   3.689753162091238*^9, {3.689754062853174*^9, 3.6897541087276444`*^9}, {
   3.6900157454041543`*^9, 3.6900157487158165`*^9}, {3.7591695496920786`*^9, 
   3.759169550010056*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "Reading", " ", "the", " ", "field", " ", "intensities", " ", "and", " ", 
     RowBox[{"lines", ".", " ", "The"}], " ", "resulting", " ", "matrix", 
     " ", "\"\<Linesm\>\"", " ", "has", " ", "dimensions", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ni", ",", 
        RowBox[{"nl", "+", "1"}]}], ")"}], "."}]}], " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Linesm", "=", 
    RowBox[{"Import", "[", "\"\<lines.dat\>\"", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.689693361098621*^9, 3.689693381860359*^9}, {
   3.6896936472062635`*^9, 3.6896937150432987`*^9}, {3.6896937962108545`*^9, 
   3.6896938259203672`*^9}, {3.6896939388836155`*^9, 3.689693952499734*^9}, {
   3.6896940790268393`*^9, 3.6896940896641397`*^9}, {3.689754112229719*^9, 
   3.689754218949134*^9}, {3.6897542998015575`*^9, 3.6897543291615667`*^9}, {
   3.6900224364760056`*^9, 3.6900224367971888`*^9}, {3.690745409621585*^9, 
   3.690745422078593*^9}, 3.690747672621636*^9, 3.6907477236792145`*^9, 
   3.6908273009902678`*^9, 3.6908304203268743`*^9, 3.6936002901183963`*^9, {
   3.6973096109741945`*^9, 3.697309611276761*^9}, {3.6973107957270465`*^9, 
   3.6973107965580835`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"Defining", " ", "the", " ", "transpose", " ", "of", " ", 
     RowBox[{"Linesm", "."}]}], "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Linesmt", "=", 
    RowBox[{"Transpose", "[", "Linesm", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.689752571956673*^9, 3.68975257981761*^9}, {
  3.689754164008151*^9, 3.689754165975405*^9}, {3.6897542271091337`*^9, 
  3.689754253656289*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "vector", " ", "Int", " ", "contains", " ", "the", " ", "ni", 
     " ", "intensities"}], " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{"Linesmt", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.68969396008617*^9, 3.6896939815417056`*^9}, {
   3.6896940285650873`*^9, 3.6896940525016747`*^9}, {3.68969413469508*^9, 
   3.6896941418746924`*^9}, {3.6897524716670623`*^9, 3.6897524720207*^9}, {
   3.689754260684599*^9, 3.6897542860233145`*^9}, 3.68975433731924*^9, {
   3.689754375737059*^9, 3.6897543867579*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", 
   RowBox[{"Plotting", " ", "the", " ", "theoretical", " ", "results"}], " ", 
   "*)"}],
  FontFamily->"DejaVu Serif"]], "Input",
 CellChangeTimes->{{3.689756737827545*^9, 3.6897567492844706`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"Linesmt", "[", 
           RowBox[{"[", "j", "]"}], "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", 
       RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.689754999811388*^9, 3.689755087250305*^9}, {
   3.689755163473254*^9, 3.6897552662597337`*^9}, {3.6897554609536524`*^9, 
   3.6897554837610016`*^9}, {3.6897558075794306`*^9, 3.6897558268551846`*^9}, 
   3.689756171350011*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91g9M1GUYB3B02Bw4WcZM3SRdVMTIUS5jLezVTKPRRNzEjNhgwDDdIItM
YZgkBSwE8xRBROD4L5zAHXfH/ePud+W/nS7LYjotqBQSSqfCkKV17/f2fW9j
7LPf3fs+7/M873O3PCM3OWt2UFDQef+f/M9XfMjQs/Nvv7QmoASx0v8KVX5f
vJhauXYu7c4QF32+xDnq+XbxTMn4ptm0yBUfx4ek/PcX378L/pcezsf7H9JB
e7DeFL2sEPvdp8U+4X973F06dr+o1Caj/lbrF4t3RvaG36aTDgj5b1TtVyKy
s7Nv/UHnfS338w2r/cvkeY036KpyMRWVWnlNxfONCBnS5w3RPRWI94qKr1LI
/F2mc6qEYcPIzEUV7yHsd4GePiQmNlnrz6r4v8X639Glh4Wf8R51Hp1ozosP
cdGLjsj8Xbap8x0RtTU1NRa6/agIN2xIN6nzViO+XjruGPLRrc5fI5/rO+lz
Nfh8m8pHrYw3opneelzWc6hB5acO+TpBj9WJAv8CtSpfJ1CPavrzeuT7sMrf
SexXRQc3oJ4VKp8Nsh+0MtrXgHx9pfLbiPi+pHWNcv+z+1S+G/H+Qjq1SeZr
8R6V/yaZb2c+HalHPLtUPfQi2RoxJ5ee0Mv+a9+h6tOMfsihTc3CGlEynqnq
1SLrV55OF7agf9NU/Vpwvm30ulbsn6Lq2Yp+2kzPa5P50SWp+rZhvffoK21Y
L0HVux33bz1d14741qr6d8j6fPEmndmB/L+h+qED/RFHx3TiPr6q+qMT+X6Z
ftCJ/VaofjmFfoumHadQjxdU/3ShPyLpA13I1zLVT12IZymd2I37s1j1VzfO
v5AONwj/2w0LVL8ZEG8Yfd2Aeoeq/jsdmG9082mcJ1j1Yw/qO4te1YP792iM
/QlvmqFre3A/pmgfnHKffhx4foeO7cXzCToDHhqjdYHnN+kzgecj9HQv9v+V
ju5DfNfo1D7EP0Qf7MP5fqLdfTj/D/S9PuTHR0cakb/z9BYj7u/3dKlR5nuF
RtuM6BcXPWHE/bTTESb0r4VOMmG+mehiE/qxhzaZhL+dJ7voWybZvzs66EX9
8r6MtNDv9iNfTXRhP85bTxv6MV+P08P96JdqeoEZ81JHrzMj3ir6MzPmQQXd
bpbx5ZfR18zo9xJ6ngXxFNOrLYiniM6zIL8FdJMF+dtNX7Gg/z+ln7AiP3l0
nFXep7s76Y+swjsZlbqdrrNivyz6khX7ZdBBA9gvjX5lQM7zsA/ozAE5f/am
0EcHcL7N9LkB9F8SPTMg17cm0jE25DOBTrPh++JtusqG+q6hNRvm32r6gQ3x
v04/b8fvk9forXZ8/62ky+0yP0GxtMOOfomh/7HjfkTRyxzIx3N0sgPzZTl9
wIF6R9BmB9ZbQo85sN5CeokT6z1FJzoRXxhd5ER88+gep8xn9lz6d2dg/tDh
LtyvWfR6F/L3aJTzzYX8PaQ7Xei3Kfq6C/W4R88fxH28Q4tB9NM4vWsQ92mU
bh7EfPiT/mUQ/TJMB7uRnxv0UjfOc5Ve5cZ5fqY3ujGvf6Rz3Jj3l+j9bnw/
XaBr3ZhfZ2mjG/fVS/vw+RA3fROf3+GgH+PzPiv9tAf799OxHuzfSyd4Ar+P
6AwPfs900gUenL+V1nlQTz3d7UH/nqTPeDBPj9O/efD74xg97cH90tFPapjv
VXS0hn6voN/SUP8yOlVDvkrofA3xFtMHNcRbRLdpiLeAdmuYF7vpqxr65RP6
nob5k0eHevH9vZOO9CK/OXS8F/c9i97iRX+l07leud/1D+lSL863ze//AQED
/1A=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91Q9MlGUcB/ArKbezLB3lnyXidIZEaDqNubDHSEWHU8kpTtJ5qQOd83Ka
Jk6RQSHTwEQUREXvFEQ47zoO7i93997mn3a5XCZmNDEXEBpLJ0XMXO/zpe9z
m7jP3vd93uf3e36/3zvBtDVzw/MGg+Ga/k/+z5+xzfLn5p635w5qofguGo1u
Ul4lrObUklw6ZBKlWl9CjrqeK123kRZb5f3GDer+beLTVOPKT+iOHSLTHVe0
Tj3/uaiqrKxcS8fvgT9W6+3D/avpafux3iq1foG8f8xKemkh9r9cva9I6I9v
zqTNXwrbgnsDS9T7Dwj9T/5iuqxEZOsBLVL7OSgifQnZ6bT9kCh6sMw9T+2v
FPGm0TllYrx+g1D7PSz+SsguTaX7D4sp+gtmq/1/LWT+36WLj4j0e7tjZ6p4
ysUM/TedHn1U5MXaFkxV8R1FPpLougqhX143RcV7DJ5MpxyHJ6r4K/F8PH21
UuYvY5zKR5Vos5hTx9JZJ0SqsW3iKJWfasQfS3dXy3w/eFXl6yTO42V61yn5
vMWo8ndansfuoXRMDfIXo/JZIx4uc8c9R0drsP6/vzO/Z3AeA3T5GZzn33T/
GZnvD57Q2WdlPb3wiA6dxXn8QU+y4Pkeutgi10/poh9acF736aVW1H8H3WRF
vfxCjz6H/Nyh95yT+QzcojvOoT5/oD88j/P/nq47j/uj9Eu1YqP+u0aba2V9
vXKZvlkr68Wp0Sl1ON8gXV2H+vbRhgvoNze9/gLiddFXL8jzuOGgk+pl/GYb
XVaP+C7ST+pxvrV01kWsZ6X9F7FeDR3fgHhO0oUN6M9KursB/VNBZzSiHo7Q
9kahp8tWSsfaUK8H6V021F8x3W7D+RTR4pJ8f+d+2npJ5mfHXjrGLuvBkEfP
smMe7qRz7Mj/drrKjnya6agd+91CP7MjP7mqfh2YpxtpkwPxmFQ9O9D/a+nL
sHO1qm8H8ptFJ36Dfliu6h1OWUZ/NXh9sar/weuL6MeD1+erfnDi/Wn0Ctj5
vuoPp9xv8nu014l+SFH94sS8mEnHNcl8nHpH9U8T5ncyXdCE805U/dSE+nqT
7myS55E/UfWXC/Uynl7kQn2+ofrNhfMdTdtcOP/XVP+5UI8j6JHNmK/DVT82
Ix9G+rNmxDtU9Wcz4hlC32lG/xpUv7bg+/W0+3/PaUH/9dPmFtR/H322RfZr
2yP6Zgv200u/6MZ+eugUN+qni97klu8vv09XuzHvOujrbtR3O23wyO/Bvdv0
dA/m/4/0eg/mzw26woP3XaevevC+b+kBjzwfwxU6yYv5FqHXeBFfkC7zYj77
ac2L+nHTT7zIp4ue7MP5O+gsH863kS7x4ftRT/t9yNd5uteHfrTQ8X7082k6
04/5foIu9GN+Hqeb/chHOd3tR30fpscGsN4hOiOA9Q7QewNY7wvaHsB6BfSv
AexvHx3bivrJo+e34vu3k97VivPaTte3oj/NdHsr8reFHh7E9zaXFkHZD+0b
6G1BzE8TbQ1iXq2hbwVRT6vpmBDqdyU9LiTr9cpH9KwQ6mUpvSSE/GTQOSHE
k07vDyGeeXRVCPNwLu0MYd7OoaN4fvNs+jc8H51FP8PzyTPoUWHMl6n0tDDe
/xa9MIz3J9CmMOpxEp0XxjyaQJeHEf84ujGM+MfQl8Ooj9fpu2Gh/80fSfeH
0X/D6REa8j+MTtTwPRlKp2mYH0PobA31bqB3aMjX0y7Oew35+oeu1ZCvPjqk
Yb+P6J807LeXfqyhXnroYRH0byc9KYLvw306NYL83qVXRJDfn+mtEcyz23Rx
BPPzpu7/AFQHCXg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1g1M1GUcB3CWxhZpZaNJb2hJRYyIYjHdoj0lyzRmwspwXdYIibQJsuF8
oUQGgWiCBOQRKC+HnLwcJ3fcG3fc/+4UdV2uGsUsVmiLUMilk8asafd88fuw
2OD22cP/eZ7fy/P877GsvIxNd4SFhZ0N/cpP/uiq/NPa5WdentVqkeGILpvz
BnFhV2SCspYl5P971fhHYknZ5HfKIk/sjjSdVtYK/j8+VigiRtr+mnt+pwhN
F6vmX1okx/OVxR7Mp5y4F/vxqflLREroAeV1pZjPr9YrE2WT6Q7l/HK5n/SA
Wn8f4lGursR8J9V+DohtKRFvn6LNn4vXQhsYUvurkuMjyrnVIikpyaKeTzwk
83mnWn/mkIxn1Vx+apBvN13xBfbrVPHUitC/X7DRUXVCflhVfHWiQa9/8ARt
rEf8JhXvl3I/SV308sNy/uVGFb8ebqfP6JHfVpWPBjGV7og+Smd+Jf6O1d3b
qPLTiPwdpicaRWA6drRO5asJ8dTQO47I/NVWqfwdFaHwtxyg5zeLp3VVr+xT
+WzGep/RwWbMX6Ly2yLjNe6ha1swX5HKdwvi2UnrWtF/hSr/rXLcVEDHtOH5
PFWPNtkPyz6mp9pQ71xVH4Mw5KdUbqKtBhFq35QsVa92Od/kRrqoXdZL/46q
Xzv6IZNOPYb9vanqeQz5SqcXdGD+taq+HeiPNfRwh+yP4lWq3kbsP5VuNMr8
+oWq/3GZT10KnX1chKa7sUL1w3Gsn0zHdyKfSao/OnE+n6Wvd2K+eNUvXYgn
lnZ3od+fUP3TjfP0OF3ajXpGq37qRn8+TKf1YL3Fqr96cD4j6UgT8nGf6jcT
6rmQHjWhX+9S/deLfIXThl5Zz4h5qh/Nsv+qbl267WQzztu/dK5Zno8jM3SD
GfmepoNmxHOVvgnHXqETT6D/LtNZcMIfdO3s+G/00Oz4GD0zOz5Kx/Vh/Dyt
g00/0Af7sP73tNaH++4cfa0P5/1rOsaC+E7T6y2o10m6woL8aLTLgvx56CkL
8uuko63or356nRX3fR9dYhU5OTnjJtpqRT910eNWvE866Kh+nB8DvaZfng9P
M13Uj/uviTb1I149PdaPetbT99twnmvoVBv2e5DebkM/7aeNNtxH5fRPNvFN
MJhWSi+wYz/F9Et21OcTOt+O/O6kW+3I33Z62C7X31VAhzuQn630cgf6fwu9
2YHz/SHd6MB62fQ5B+6f9+kwJ95P79LPO1GPDXS2E/G9Rdc7ke8M+owT/bWW
vuFEPl+n410476vojS7chyvpahf2L2i/C/l6kb7uwnlaQT85gH57gc4cwHl+
jq4cQL8k0O4B5COOvjKA/n+KXurGfMvoDDfmW0KXujHfI7TNjf1F0RNu7O8B
+iEP+mcRneZBvAvpTz34/hFBmz34vhBOX/Qgf/PoyEHU/9bEbb86iPvtH3rH
IN6XM3TnIPr7Oj06iPpepe/xyv7J+ZMWXtynl+gCL/IzThu8iOci/aMX8fxC
z9fQ7z/Tj2rohxE6WcP7e5h+Q0N/fUvn4vlgkN6L5xPO0g0a1j9FWzSs76OD
s+sP0r9ruG9d9E08H2GnF/sQv4VO9KE/eunVPtSzm87yidDfYiO924fzYKBr
fXg/tdA9PpyvJnrIh37S07/6UP96esaHfNXQi/zYbxUd58d+99Mr/dhvOa3z
474upQv96Jdi+qAf92UR3eGf/T5Ea1ivspA+j/XGt9HX/Pi+sZW+O4D4NtMx
AcSXQ6cEUI8P6PUB1OM9Oi+AftTRFQGcr8yQ/wO1PSFN
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw9lg9MlHUYxy+nrsjK6jbNFpKZQ6eNyjk2R/7Spul0iSuldesPmWmuuFiU
ihk6WGomqKhBSPyVA/H4c8dxHHfw3nulUKdpmqSSAgmCWDmHxmxZ9/va93k3
jn32vu/veZ7v831+v/fx5JRl74ywWCztkT/9n5c3Omvt4JUZz9+hhap7g9V5
RfhVdSwcDg+QjWRwv9xfo7LNG47LZJWiVkWuPnk+VS3zRo/qJXelqchvxm/y
/npldS7o7ibHbFQJUR1PdMl6n+l4iy+Q4zar0I1YW6esv0VNzBpMPEdemqme
jVy/SLwsHc9yhmz/XEUe956S+Nuw3klyznYV1VF67bjks0PZss20MLn2S9xv
l/yy1YcJUSuOklfn6PxLheN26eftbeThXWqqLXuuvG/sVvl5eY98T966B+sL
L82F3j+Qx+9FfySfrr2qzJ6w/RjZsQ/xJH/7fujzIzn+K11//AmpPw/xpf62
POj1k+iRr/vZJ5z0tUq3Oo+KfjEFyOc0ub9A3Yy1Zf8seh1APqL/ukLk0yH6
faPff0r6NbJIv//AWdGzCPGFw0VaP1P6HVes8887T84tVtrP4o/hYhUJn/Ar
2Vai9YoSPxklun8dwpNLsd5F6Uep9udb4serpepqojda/Lq0TPunU9hdpl7s
3pDbI/0q13otEL9vLFcRu98S7iqHXy6RXzgI/eW+46COVyj5jKlAPVKfvQL5
i36nK1C/6B/vwPxJ/wocqE/8YamE/uKvlZXQV/zbVol+fUueXoV+GOKPKsxH
gDxUhfx94pdD8IOH7D8Ev7nEP9Wov4acWY18qsVP1ZhXB3nxYcxPufjrMPxY
TLY6sV8Uit+cOv+T+eROJ+Z1v/ivBvrtIZfVYD/IET/Wor87yLPAtm3izzv3
s8j5d+5vEb/WYv1N5NvgFeni3zrk9wk5uQ75fyR+rkN9dvKROtT/vvi7Tvsh
sIY8rR7zvUr8Xo/5TCbvrNf7dewb4v96+Os18vV67V9rksyDC/vLy+TlLvQ3
UebDhf4vIftc2n+DC2VeXNBjPjnajXrnyvy4Uc8c8hY3+j1b5smNfOPJfW74
d6bMVwPm+WnyogY9XxtmyLw1IJ+pZGcD9J8i89cAfSeRH/JAv4kyjx7481Hy
xx7sT+NlPj1ajwwr+ZwH8cbKvDYi3n3k5xoxX/fI/DbC76PJJY2ob4TMcyPm
99+B/3m0F/vp3+R4L/z1F/k9L/QcIhd4cT5fIx/3or+/ky1N0GuA/EwTzuNe
8som+LGHvK9Jn6+uC+S2JszzefKtJujRQZ7uw35xivy6D+udIOf4sF6YbPqw
Xjt5yIf8viNPaUZ+QXJSM/bXFvL2ZtTrI/ub0a9G8h/N0M9FjvFDvxryMj/6
X03O9KMfDrLHr+uzlJP7/TgfiskTAujvAfLiAL5n8smbArqfWfvItQHos5vc
E0A92WRrC+r5gjy/BX7fSl7Xgu+tTHJVC/ycQe7E+7Gfku9vxTyvJ6tWxE8j
p7Yifiq5rBX+/4B8phV+XEseaaD+d8mPGaj/bfIsA+flm+SXDPTTRl5tYP9M
Im82oP8r5HwD52ki2WXg+2gJOWzAT4vIvQb2u/nk2wb0mkceF4Rec8hxQeQ7
m7wwiHzjyclB7G8zyelB7F9x5Nwg5ncG+XAQ+k4lH0G8vifJF4M4vyeRh4Pw
VzT5QVPHuzGBPM3E+TuOPM+EHx4m20z0Yyw5zcR+O4a808R+eje5wsQ8jCIb
Jr4X7iKfNaHHP/08D0zocYt8bwh63CRPDuH79Do5IQS//UleHlKR34xBckoI
83aZvDUE/S5F+D8Qdh/S
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1MlHUcx7FpLXWWjU3LRVrMoaXTcsZa6N+XfJsrcctsu7WiIsstiI1S
NFMH86UUtNME8YUXBVHPg4PjOO7gueea2rpsvUyns4KWhkLlNM2x5br/t32/
BRuDz+55nv/v9/39vt/nxuXkLX3zrpSUlC+Sv/bv/37Wm95Js/79d6GZ4Cl1
Z4pfNllDzz0mdnIs18zQ52+bczX5WWKTZ5K338zS9QXmq0QiIe4qNCW92SFx
ymqcJx671qT65neLzUemorz8QT1/ygb7+WtiZyPuFy8pNk8lf1RvVwnOE+dv
MmuSD/iv3y0mNzf3srhsq1nQXeSdpXo+sfUvnk32bzO3Mjz3zVF9pahXvKLM
nh+Yq3p34HnPkW/vsPoUzlP9O9HPfPLmT80jyYIXqB8v6tf1o3ehX53Xtcv2
c0r11+8GS7/8z+x8os+QM/eY7qJU39Pqv9zqWz6NfLrc2H2YKj0qUN9k8vK9
mPfj0qcS88kg91SaUFpJb7r02ofzx5FX7TdLkxekSb8D6HcMefBBq1fqaOl5
0LyXXLhUcgKfe0dK3yrcP4LsrTK1+VlDh0nvKuh1D9lTDf0HS/9q7PcgcnoN
zvv7KudRAz36yX01Vr/Jf5GX1OL6G+TmWpNch6Jr5NGHTF92KO038tpDqOcK
uesQ9L1MnnsY+3aJXH8YeoqH19n+tur6/DrU/yv5+zrsnziz3p43u4dcWY/9
EKccgR9UzxtHBtZ3+ojdv8yr5CcaTNLe9eKyBvihl/xng0nGQ754+VH4Xxw5
Cj36yGOP2f5WiouPoX5xzzH7vGvixcft+RnS03/c6v+SONUH/cWrfNhv8UUf
9l9sTmA/xbUn0L94sH/g59P9qE+8wm/72S+u8GNfxAn/wPru+DEv8ZRGzFf9
5TQiX8XeRtwvPtlosIbk2404X/pObMJ+ij1NyA/Na3vTwHk6uN6neV9vgv/E
6QH4RfuyLID5aR83B+z8S7vJ4QDq+1F+CWC+F8hpzSZ+M+PiWfmnGfv3HXlj
M+r9Wn5qhl4J8uVmnHda/mqx8+7/nLyoxeZ5bkx+a7H58E2U7GtBfoXlvxbs
c5D8QBD7HJAfg9inE+T3g3hfHJU/g/BrPflCEPtRK7+2Qq8q8oxW5N8++bcV
8y8nV7ciz3bLz63QYyf57hCeVyp/h/C8j8nvhPC8TfJ7CM8rJp8J4Xnr5f82
5PeH5Cfb7PzWr1YetKHfQvLuNsyrQPnQhv15l9zfBv1WKi/CyIO3yK+EkZev
Kz/C2MdXyW4YfvUoT8KY73Ly+Ha7P54XlS/t8Gc2eWs79HleedOOfhaRf2/H
+3qe8ieCfJxDXhqB/2YqjyJW3yHPkoMR5HWm8gn3u9PID0Wxr1OVV1GcP4m8
LorzJyi/otjH8eSfo/Dzo8qzDvSfRp7XgTwYo3zrwDxHkRs64N9U5V0H9L+f
PKITeTxc+deJvLiXXNCJ98sQ5WEn5j+IfLYTet25wnx0UG8/+WEH9d4iT3dQ
7w3yCw788Qd5hYP3dR95gwP/9pArHOj7CzmA89K6yQmcV/QD+ZIDv58n33HQ
31nyqBj6+5Y8JYZ5nCEvjGEeX5JzYvi+cYq8Job3UZzsjcEPDvl4DPsTIZ+M
QY8Q+acY/NhCvh2DfxrJI13sm4880cW+N5DnuJj3YbLHhd9qyIUu9DtA3u7C
H3vJdS72Yw/ZcZHPXvJ5F98PysjXXei9jTwsjvfBFnJ6HPtUQs6KY/83kpfF
MZ915Lw45lNE3hzH+/yDJP8DJJoYkg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1n9MlHUcB/CzSXPIdBYV2SRcrCh/RNKIudG+pEkYJVIq5kWKP0JrA12W
IUtlOI1ZQBF1iMZP+WGeB3ccx3HAc881xUUuF5MySrAkSlatxDn+YN33fb0/
3cbYa8893+f7+fH9PLcwJy9z+x0Wi+VC8E//58daak6m3FiSElKa2p0cPrRC
vFElJCQ4n6WNHHUrzlqaKtd3qvCh+vw0WuWprwcG0p+X7+9RowWRS1+gR/aq
hvzk8DVy/7vKE334RgYdU6j2R9rPZ8p6B1RwO/Uv0/GHVGbwhvWyfpGKtKdu
yaIzitWj1tJnXpHnHVYTaz3RVjr/iNL/suX576vAZNzwa3RZid5fiTjmmLKn
jk7J/Y4P9Petsr4q1fHZN9C5ZUrn8//9liN+ied2OfYr8RsfIZ50+ujHiFfy
mVGh85EqjvoE8a2W+EKWfDdXwrJe/qe4X/Kf9Jl68PCNtS9K/DbEI/vpt6kd
wY/Uo6wK9V1LZx3X+Tso8cRUox9eoserdb5PSvyOEyqYjuZ19L6TKvh4j9RP
fY56S/5m1qD/pJ65NTpfoxvpgRq9n78k//G1qM8muqJW5zPsVcl3LfpN6m2t
0/udK/U16tRzwQJtpmPr4S1Sj5Bz6ImQt0p9GrD+NtrVgOdvl3o1oh/EhY06
v2M7pH6Nuh6XXqdXnlLBdPfkSj1PIZ876Ygm5H+X1LcJ9XuDHmzCeZXrSc16
vWRZv7oZ+Zb9W1rQDxL/thacB+n3/hb0g+R/cSvOq9SzrBX9If1wsxXxSn9l
ndb1KZD+9MFTMj9ivkA8K+li2CLzaDx0PZlOP4Pry6W/zmD9RDrSjvWXSb/Z
9X72Pk4Pw5OLpP/OYv9xdMNZxBcr/ehA/AvpRAfys0D606H7dcN8usqh59/A
vdKvDpy/u+lpB+o7V/q3TdcrIYLOacN5mSX93Ib5FUafa8N5myH93YZ+m/79
Pz/WjninaGs74rlFf9iOfvmHNtqx3z/pv9vRLxN0rBPzbZxe78T3f6WPOnEe
xF4n8jFGTzgxT6/T0S705y90hgv9/zNd5ML5uEa7XDjvo/RYyCN0VAfmw1V6
dQf29xNd2IF8/kjbO9BPw/RIB+rzA32XG/m8Qq90Y159R7/txvweopvd6MfL
9BW3zkfFIB3Rifp9Sz/dqapsNtslOr8T8+gbuq4T/XyRHuxEvw3Qd3rQL1/R
SR7Ec4He5dHz3zxPV+O65Rx90YP30Ze0pQv1MullXegfg97Whfr10pVd2L+P
7g/ZS091IX4PvdiL+910thfru+gyL57fTpte7M9B3/SiHnb64W7U9zSd1Y3z
0EKX4Hp6E+3rRvyN9B/d6Oc6OsaH+VdDZ/rQXyfoYh/2f5x2+3S899vocR/e
15X0/B7db3EVdDrcXE6/16O//1Ap7ehBvo7R13qw3xI6shfz5wi9qhfzu5je
14v1iujWXvTPAXq4F/kqpOf0Yf8FtOpDP79D7+lDPG/RDbg+upu+HLo/j55p
IN9v0gsMPH8nnWgg/h30GgPnfSudayDfm+lDBs5DNl1loB820U4Dv2+y6AED
/bOOvm4gX5n0NNbPX0Pf58f+0ul4v873wTQ6LeRVdE7IK+j9ofsVXeHH+sn0
GT+ev5w+58f+nqKv+jFvnqRv+3Gen6DnmZgXS2Wem+j/RfQKE/PxEZnvJvoh
lt5ron4LZd6b2H803WRi/j8g89/E86Po70PPu0feByZ+j82jZwdQzznyfgjg
PM+mkwOozyx5XwTw+yiMzgug/jPk/RFA/0//tiTlX3rl87s=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1GUcx6lRa+SyFzbMFmqRQ6aNchlb4Z60SRQVska4qAYh4UuBGIpA
KsQlMALUEwJJeX8TzuPl4O644/53bGqN3GqVs9GCVsaCVWPiGFuue763789x
G8c+3HPP83u+3+/v92ddenbS7ruDgoK+9v/o33y9Ml1gLprd9FKA4lVmZuaN
QuFdyv95qLCRrhrq6x8tkM/3KEvc9FI+WWUr0+xO+2FZn6vW+P9wiDyVpwpD
LZc/ke8fUXM77eEHyWuL1IHYkLcPyH7HVMi11pxscnSxsoeb9n0k+5dg/33k
xFLst0fOM+n9rmWSc07oegsy5Pxy1ZYTG5JOrqlA/WlST6W+b/0HZOsXKrXa
l7db6qtGvR+Ss2rUZv9Lzo8+Cf2kvsWT+j7/7pf6T6lvJyYmPiaXnVb+5ZYc
uY9Z11eRS151BvcX/abOaD3jRN+uWlXtW4gUP3LqVJI9/B7xK+ZL5V8+fcff
erXBf6FPyVfqtX7njokeDcr/fryYnHJWjS9Epn4m+jQqvz2xJvJMI/JxQvT6
Suu1UEbOPwc/KkS/81qvwUpycJPWy1wlejbB/xryRBP8PiX6Nmu9njaTzc3w
s1b0btZ6zdaRU1uQv3rRvwX+yOcRrajntPjRivPk/LlW+Cf1JrbBn3LyUJvy
X+/Jz8WvduSphFzUrv1OEH2n2pf78XIH8iX+dXXAvzzyik7oI/2R04nzJD8/
dOrzYiRfMV3QQ/qlsQv6Cwd16++3yvczunX/Z0q/XelGniSPG3tQr3BNz/J6
bvboPG2TvKZcgP7CrgvQ606/96J+yXNpL/QSnulFvuX+CX3oF2Fr3/L8h1qQ
Z+F8C/Ih82jSgnqF1UXkU7jtIvYT/YOtWC+8xarzPymchc9Dj5AbrPi+8IQV
/Sp824r7C0f3o9+E0/u13l3C5n74I3ypH/NIeLFf58MkHDWg/UkTTh3APBKu
Glg+r40B6C08PwD/hSMGkR/h5EHUI3qVDS7X1wm2iP5zg/BD/AwfwnrJS+IQ
9JU8lgwp/Wuv9NMQ6pH5fWMI/su8XmVD3t8nv2qDnu9Iv9nQPylkiw1+vCX9
Z9P9/V0i+eFh7Pe69OMw9osnHxrGfjukP4dR3zbyz8Oob6v06wj0f4G8dQT3
fV76dwR+bCa3jGC+Rks/j0C/jeR77eiXDdLfdvj/FHmvHf22TvrdjnkTTr5q
hz+rpf8d6lZk6sow8rMOzNtHZB44oM9Kcq0D91kh88GB+9xHXnKgn4JlXjjx
fLyL/J4T8/W/vzg/nOifJbLPifl3i3zTifPnyetHcf4/5JRRXX/1LLliFPP5
T7JrFPf/nfz3KO4/RV7rQr5/ISe54Od1cqkLz4sfycMu6P89ecal/O/Hr5JX
uzEfviEnuJGny+Sjbug1Tra6Ua+H/Jsb9brIoWOYB3byjjHkz0bOH0O/95N7
xvTz2N1HnhzD87iH/IAH+naQlQd5bSHnejDvz5PbPMjXWfJPHtyvjhxs4H5m
8uMG7ldD3mIgj5XkNw3Mx3JyloH+MpGLDfRDMbnBwPP3KHnQgB4F5AkDehwm
/2Ggfw6SbxvIWzY5zIu87ydHe+F3FjneC/0yyOle5DONXOhFf7xLNnuRj13k
Pi/+/0wmX/JC7yTyr17o/QZ50Ys8vUZ+yIf/T+PIUT7kfzt5uw/+KHKqD/l7
kZznw/M9hlzlw7x9jtzpg5/PkI3A+k3k64H1UeT5wPr15PvH4f8T5Ihx9OMa
cuw41j9GTg6sDyNnB9aHkssC6x/08//EAAfz
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1HUcxqlZbfTicrbMTaOyImdl0Rxbo36ZM3WskDXTRW+U5ksFWjgT
l2lSxFKgUHnzBQ4EeTmPuwOOl+Pu/peKdVKUipWrbGVOrTlLZ7a57vdcz+Nt
wD67/+/l+/0+z/Pnjty87IVXJyUlHYj/2L/8JI+4znafvv+JBM022YGJRT3i
Baa6quq2PnI41xxfPdbdr++XmMKx7qcGyCbPxPF4SM+vMHFcHSH/XGBmxTeI
av27Ji0tzfc5OWWNub3o9Nx92m+tsffbT566zlxIzSk9oP3XmzNzA9u/IGdt
sDzxS51XhPuK8z/C/jGd/7Gt95qD5LISW89+ccon9r4VQ2TPRhNvz7KvdL9S
czAWy/yavLjMxLdPH9Z9y+35D3xDvlhuSp3zqd/q/p+CD5GLP7P9SDuseirM
iCs/4wh53Gbcf0T1bTaL4p+j5OYtmIfW5281Gckjd+n89Eo7j0uqJ6nK3j+m
/gxW2XlXDaof1Xaer+wlz6/Bfo76U2vPP6H5n6y137ukF882rA+QV22HnjrV
vx04v4M8aqeJ/37frX7uRP9aybGdZnn8gCb1tw56bSBX1KGfdep3ne3X8DZy
Tr3JKXUKqtX/evt8cw15kgv76fliF/q7g3zGZe7LKZ2u/bMa0A8X2d9g75/U
qHk1muj51GO7yGsa7TyDzZpfI/rdQp6xC35p0zx32XqfUz9uaIK+PJpvE/zk
JR9qgl98mncz6le/a5vhhyt+3w0/ye+v7Ya+Nb/B3dB3kDylBf2Vv8taTEN+
RrL8/XcL9CB9zG+1/XLk7/5W6EP+TmnDvKW3DW3Qi/x8sg36l18z2+HvK35s
h57lx7Fu5I/8u8qN/mm/Y27o7Uq+7ME8lUcNe5BHqm+UB/Uq76Z5MC/pebEH
9au/1R7UIz3HPJhHO/myB/Vp3lM7MB/pI7cD9UpPFR2Yl/S3rwP110rfHfb8
kkryZC/6USG9e6HfcvImL87bKP17UX8J+ZwX530oP/jg1w/I83zwx1r5w4f6
Csm9PvR7lfziw31Xkif6sb5A/vFjXu+Q1/vhd7HfDz2+TT7hR96vkL86kdfL
yXM64bd8+a3Trj+dR3Yn+C35L/H8m+QxXdDrG/JjF+a9jLyyC/1cKn92QR9L
yN93IZ9el1+7oYdF5Me60c+F8m838udVcj04NVd+7ka9L5OvDeB99ZL8HcB9
XiAvDdh8CDwvvweghwXkIXyfPl/+78H6eeSHe5AHzyoPenC/bPKWHuyfpXzo
QZ49Tb6U4EzlRS/0NIf8Yi/ep7OUH73I45lkpxd5M0N50ot+TSff04d5Pa58
6cN+GeSSPrz/HlXe9Nn9z6eT/0w8P0350w+9PULO7sf8H1Ie9eM+D5K7+uGf
KcqnxPeTyeODWH+v8iqI9/nd5PeCmOedyq+gwTXIvwRtfTkTlGcD6N948swB
PD9O+TaAem8htwxgfmOUdwPIu9Hkm0LQz43KvxDyJpm8IgS/Xac8DKFfo8hH
Qpj/VcrHMOZx+dT/PCGMfv9Lnha29xn9D/mZMN6XF8iLw+jPX+R1YdznLLk6
jPr+IPsSfIocS/Dv5N8S/Cv5cmK/4+RbIzjvR/LUCO7zA3l2BO/To+TcCPp9
mFwYwfttmFwRQX+HyO2RxP+b5H0R5PMg+SesX7SXfDGC/HXINzvQe4g82UFe
9ZGfdOCvADnHwbw7yQUO9OMlb3JQ3x5yU2K/VnLYwfuumfydAz82ks85yIt6
8vVRzHc7eVIU62vIGVH7PsivJM+LIs82k/OiyPtycnEU+toU5/8AtPQnzg==

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9M1HUYxm+ObEOXy7EyNwkXNXJWLrdybbhvZhnNFrBmtG61qJzZFuhG
I2WlJpOoAA2pIzT+CvLnOLjj/sEdvzumQZ1OF4l/KECTCIiUxIjMuu/z6302
b2O3z+57933f533e58fyzKz0t+ZZLJa+6J9+l1e5zWaLTDz0pEkp6kFrcfg7
8svqepJ1EdnIVPYNIzu+5edvq9rs5FiyylL5E2nePp7frtK98fnk4RwVO1CT
Tba8j98jJ+SpyTTvYbL6UPXMJA2SV+1Wq6Mv3mfsUSM74h5mfal71b35E6fZ
z3A+7jspnL1PPRv9wine/7GKfhw4LVxSqOLsG17/nvV8quu/7Qdhx2f6PvsZ
1lestiXHvnRWeEuJ0m/nWe9+VRyeabggPLtf15f2I+s/gPNDwgWf4/ww+ynV
9Zb+JLzkoD6/i783fFBtjr54f0MZPj/Hfr9Qer6sZ82X6Jfft9ig76Bwrw31
8L6ScpUcO3Af68v4Sp2IRDayvoQK6DsiPFaB+y5Sr0Pw0yXh3MMqaoeJn6nf
15jHqHBMpfbPml+oZyXmMSYcqdR+K/yV+lZhHuPCpVWY/wT1rlLR62cmha3V
ur57pqh/Ne77XTixBvO8wnnU6O/nXBWerNH7UDzN+dRiXn8Iu2qh7zXOqw71
zAjn1el+Rq5zfnVavyt/Cq8/ovdhbpbzPIJ5zAkvrIcf/+Z8Tb4h3F+P8/9w
3g3on1zRAP1vcv5HUT9/701wEu/vParnX8N+VjbCD9SjpBH7+pvwtUboy3lk
NMG/nG9XE/KEfkhoxjzpr73N6Id+HGtGPtDfG1vQTz/91aL7eYf7G2fX8xsg
59qRR9znQTvq4T6rVsx3QLi2FfvJ/YlxIG+4L485UD/3d4sD8+O+lDv0fkS4
HxEH9OU+3HSgX/p/VRv2l/pktqmdUYPQ76Vt0Jt6Hm+DPvTzbBv8RP1XtGPf
6GdrO+bDeRW1Q0/61WjX+2+lP6fbsQ/0Y6IT8/xLeJMT+tOPBU7oTf/5nVov
J/016YTelsn/Od6FvJgnnOpCnsQI73Ehz+cLu8zPyaMu/D6/v6QD+fGv3Pdc
B/qjn/M6oA/7sXdofdbRz8Md8Df3fbEbzzPqud4NfzFv3nNjvpe5n274g/M9
7741rxd6oBfzd60H+UK/ZXtu9We1B3rz+dTvQT98ns33Iq97ud9ezOuY8FYv
8jfEffciTwLCJ/F9q5/778P9buFHfbjfyTzwYT9ahct8mHcT88GH/huE53zo
v5Z54cd+VAq/6sc8DzE//Mhvm3DYD/3LmCd+7McB4Qc64e8i5kun9nf8J8KF
ndBrH/OmE/V+JDzVCb12MX+6UG+ecHoX8jGXedSFfcwRdnfBL9uYT11Kv70r
vDQAfbcyrwLQd7PwBwHkxxvMrwD89ZrwxYC+75tXmGdB9Jch/EwQ/b3IfAui
v1ThxiD253nmXRB5kyJ8Rzf24WnmX7d+XiWvE97eDT3WMg+7occTwme6ocfj
zEcD+bJaeJkBvz/CvDSQpyuFXzCQh0nMTwP63S+828B+LGeeGtj3ZcJOA/5Y
ynw18P/BXcKXDei9mHlrQO9FwneH4KcFzN8Qnte3C6eEkCcxzOMQ5mMR3hmC
/26MSz6HzHwUbgkh32aEj5vnrwoPmeenhGfN8+PCd4Yx/1HhFWHM/5LwU2Gc
HxK2mucvCOeY588KF4Wxv/3C9eb5U8KGef6E8Dnz9/uEp83zx4QX9OB8WDix
B+eDwsk9OO8X3tSDfj3CWeZ5p3BBD/RpjfJ/ke47HQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYxy9DKyQtR4vaIpqsoaNisTH649ondZqOFrCm1q5WjIpsjcuG
M6VCg0JmggYmiMSPAw6E4+AOOI47uB9NcbvcXE7K0QRLsyAzQiMq6j7v63k3
ZAP22vfzfT7P87zfn8/zfSgnP/vVRQaD4VT4V/+Xn+jRpms/TT7yVIQ2KovZ
WDZFfl4Zo0dXXhX25ajRJrP3Fz5/QwWvJ5l+FVb5ylQeuD7N9dvVjSRT+Yzw
eIEKP066wfffRbzfhRMK1dvG6C1/MN4HSuc3J5yyR2W74kv+Yvy9airLFT8v
nFmsUlNTHf9wvxL19MSuSsPUf2z+WNcXzfWGfSoc7s0/hSvKkM8s89mv91vM
fO2fqJLJrPTfmF+5ei38c004rwL5/cx8D6qa6upq9nf2oO5n0w/M/xD4e+HS
T3U9dROspxL9uCgcV4V8uH68CvVeErYeVrG2Da8wvvkzXX/sj8LpR9SqsED/
612t9Sqg3iPV0Id6V9To/Uep99aj8Af1TqjV8dawH1dqoT/1th/T8azs3846
5Mf+qs+RH/WNqldfhkIh6pFXj37+LRyqR/+pb0oD/EF9KxtUOJxtkfBsA/SJ
EjY1wi9LhH2NqO824cQm+OUO4dIm9WB4w6XCU03wz53CmRa1O9Z2cpmw04J8
7xKOa0Z/VggXNiv9L1Z4vBl+u0d4XQv6wefWFviH8WJakT/3N7fCP8z3LHgl
60u34jn7UWuFvuyfoU2f3zFybhvqYT9H2tDPW4ST23GeGa+iHefnVuGZdtTL
fm89jnoWC3uOa/0nyAkd8AfzLe5APOpxpQP13C6c0Yl8yfZO9Jv1x9p0vo9G
C++0wU/kMRv8QD1VF/xKtnRpfYpihKPs0Iv9TrPjvJDz7DreZXKNXe+XQT+E
7OgfeT4Sb7lwSjfWk3O60V9yZTf0IJ/oht/Js93oL/2xugf1k009OC/kAzex
76b10z3ab/eREx3oD/fb7FiYT6kD9wHZ7YD+5CkH8mX98U7UR850Qj/2b68T
/aSeTifOG/W+7NT+mOTzuF7kQ/029cIv5MJe3DfU39aL/fn+eC/0YfwVfbgf
6b91fYhPf+7ow3mlf619OF/0+/k+Fbb3Lp6HmH79/gaelyf7cX/zPJn7F86r
xn7cN5xPZ/vRD867Ja6F8yrdhfPEebnNBT/xfq11Lbx/T7t0fnO8nw0Duh4j
7+/HB+Bv3u+5A5hHvP8PY72X821kAOdrUnhuAPcp502yW9dzhvPoJTf6y3lV
4Ub/vhMOuFX4bxHn3wzez7og/PAg/Pkt59Eg4p8XLhuEn74W9gzC3+eEr0bW
f8X55cF9cEY42wO/nxYu9kDPkHAfeO4U551H+9t8Uvh+L/T4QjjDC/0Dwu97
occw56NX12vwCl/0ol63cOwQ+t8vvH4I8Z2cp0Pwe49w+xC+x7qEx4bg9w7h
ZcPQr43zdxj+ahHePozzZhG2DCN+g/A5vG+s47z2Id+jwg/4cN6OCKf54Ncq
4Wd96Nchzncf/FYuvCfyfL9wTeT9fcKOSPyP+D0Q2f9D4Us+3D9FwvM+6P+e
8L1+3Je7+P3gh547hDf6MV/eEc7x6/vSZRbe7Uc/3xKu9CO/bcKdfvTndeET
WL88V/hCJP7L/B70ww8vCt8dQD9eEF4dQLwtwmsD8MtzwqYAzlOmcEEA/n9G
+ACer9kk3BpAvev5/RnA/bNW+JsA6lHC0wHobxReGsT5fkI4MYj90oSNQR0v
NVV4cxB+fUw4P4j+JfN7N4h5tCrM/wIrfgsR
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9MlWUUxm+mtpA0jRItEZMMCY20iFXYa5qoYwtYM1p3tcic2RZXN5oi
K3UwiUpQiYKQ+CsXhOuFC/cP9w8f926kG7a5sazGJtQyF8w1Jo1cc933+TqP
826M/fad777nPOc5572rCgrz3p9jsVguRv/0f/lEZpKt8VPrNpu0Q2XGXGlZ
Sn5TrbVWhh8RNgrURHGc42E+/0BFHxfFCatC9XeyddFDjD+g8rwJZYuFx4vU
yrLJy4v4/iHlyJq49YBwYomOnxfL7/tURdP5637htKPqSosteB+//5h+bpsn
nFOK8+/leWXqcJwj6x5h23EVrXdsDs//TEXT+3CucFWF0v/mM58v9PdV8jzn
l2oq15vAfFSlqgzP2GOE91apssncDOafdhL6sb7Zk+rSyEg26zdOqf1RwR8U
Lj+t87MuYT3VKpr+BPWM/0rzu9R/HDzB/thr8Jz9tH2N58uEM77B9z/K+mvR
j8eEL9QivwTqUQe9Vwrnf6v7v34V9anXejQ8Lny9XrXaMmOSqNcZ+OMJ4YMN
0H8N9ftO6/NKsvDcRvhvLfVsRD+eEh5p1Hq9kUp9m+DHdcLVTYh/mno36fpy
04Stzcj3GerfDH02CCe1oF6+X94CPXjeVAv6xXxzWtWe6If19bXCr9Qnvk37
u5h6lrTB39R/vE3rVcF523oW8WT7WfiJ/Yttx7wsZ3/b9XMv+zfaDr15XoYd
7ycK19vxPvOzdOD91cK7O3A+67nQofXIfFI4tRP6sj9VnfB3ivDNTsw79co/
h/lbLxw4B3+wH4ldWt8R9qO0S22fKK7eSD91od/PCWd3Y/6ep7+60b8M4TgH
5vEF+s2B+X5JeMyhNkY/m+i/81qvmZeFW8+j/5vpRyfq2SKc7oQfXqU/nTrf
uCzhOif8vZ1+dcLPO4VvO7FPyGk96Mc24YIe+InnVfdgPpnfcA/6wXpme1Av
60/pxf6jXtZe9JP6nuiFXpwXoxf1sH/TvVofF+czyaXqamuX0R+7XNCD+6Dc
pfWdpJ8HXJg37p8pF/zF+yGhD/3jfZBj8kLhY+AG7su+PuhLvtaHerhf4/sx
jwuEd/ZDD8aX9CNf7ltHP/S9cx/1Y/9wvy5xIx/u161upf9xHj92o7+sz+6G
XziPv7i1XrWcx1jP3fO/yQM/cx5tHswn92ezB/Vyf4564E/O43wv/MB5zPBi
/3Ee93nhL+7Lei/8z37/4EW/ud8sPq1XMv2xwYf55Pzt9mm9rj0rXOPT8/x9
OveDD/6m/275tF5HOH+pA7iP6Ne3B+6exyqTXxQOD6A/fP/mAPYH532NH+cx
v3w/+sN9UuHH/cb9E/DDf9zXN/zQl3omBvD7gfswL4D6VnAfBfR5q9lfdwD1
8b69HoD/eF8vD2K/0G/ZQfSD/vwkCD3v/J4Iwn/8/fFrEP6xcJ+F0P9/J//n
bSH07x/hgyHoMSPcGYIe08JjIfjthvDCQfjlT2E1iH7/IXxgEP36Tbh1EPpd
Ff5xEPtlTHiugf79JLzCwH0wKpxuYH9cFn7NgN6XhPca0Pui8FED8zcsXGfg
PgsLuwzcFyHhEQP98Qv/bmDePMK3DcyLS3jpEPzuFE4bQj+7hHcMId4uXGDG
twkfNuObhKuH0P8zwt1D+H1UJzxsxtcIXzXjTwnPmvGVwovDiP9cOCWM+OPC
W8KILxW2mvFHhIvM+BLhE2Hkf0i43YwvEjbCqHe/8M9m/EfC02HouU94QQTx
e4STItD/PeHMCOLfEd4VQb/eEi404/OFyyPo7+tR/g8fddqD
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx5nT1tBZudvUmoiTHJEWRRn9OHtUEjVKoEJcNxuEhvUH5EYz
ZKVOFrESLNQgIn7K8es87gfcHQf3vbuluF01m9PZ2AS3mA1WjUkj16x73tfn
7YgN2Gvf7/M8n1/v9/NdU1iSu29BXFzcxeiv/i8/h022C+nTGzbHaIf6PhLJ
eo68R62unLr0vLBRqN43x+828/kBZbJlTmwSViXKk1D5nuL7B5WlJjS7WXi8
TEX/HtnK9R+qP5Mt970knFihpnM8Tdu438dqotz02Hbh1KPqalvp8A7ufwzx
viycfRzxZPG8ShUfXfCqcOknKteTsCib53+qGurr63OEa6tx3muM5zP1SDSB
14XtnyP/PMZXo/Od2i1cXKv3r9zDeE/q/Ve+KTx3Uu9vszD+L1S0/pl7hau+
VOHZ5LG3mE8d4i8QXnEK8b/N/E4h/iJh62nEv5/5nkH87winf4X4DzD/el3v
BPJoPfq9j/VoQL8KhfO/xv6ML7ER8TK/m414P5/1+kZF25/8hvChJp3vBdZb
fYt5YX8WNqv2UnM8+1ncrMzRAmQKR5p1/80ZrG+Lzucq562uBfXifM61oF6c
Z0sr6rWR9W9FfGnCSW36vLVPsR9tan/052nh6TbMJ9dnt6Nezwi72nHes+xX
B+rF8ys69Ps51NN4h9ZH2QvCGWe1HmoYv/Us8qe+lnSqtLQ054vsb6eKbudh
/pc7oQ/qLd2K51uEG606X+td/XWhHqxnURf6Rz2Odun+WqjH9d36/DT2o7Zb
vx9Hfd7qRn/J+T3QA/Xq70H/dnJ+eqEf8vFe5M/+3+xFf6jnrD7kQ7b36fne
8oqwyYZ5Jx+y6ffTOV9jNtSTrM5h3nYJt5/T/lFAXmhHvckb7SpqL7fJxXbs
Tz9psGOeyRE75onn3Yk9Z/yp/agnnxf2z9+/rl/P3yT3O/8/nuuH/sgpDu2H
EbLFgXqRTzjQb7LhQP7kGQf2YzxJTqxnPfOcWM/4q5x6fTX75XOi3+zndOw5
+5/gUtsnyus4H9ku+CHn6ZgL8XPeXC7Ug/M46UK9yCvc0Dvnd6cb88/5rnDr
80xkmxt6ox7G3ciXelk2AH2SM8CXqK8PBuCfZOsA5pd6/HkA+ZKXDEL/5E2D
8+/L0kHUk9yK5wXky7H15Hs88BdyugfzQL9414N4yY0e6JH8gwf6uHt/e1Fv
8pNe1INc5NX1/YN82ot68vxRL/RMvu2FHsnrffAPrt/rm/9+rQ/zQA75cB79
8pYP9aafrhuC3vi9kj+E7wf6b/UQ7gP6tX8I9aWf/zaE+5Z+n+hH/54QzvVj
flPpR37o43HhgdjzDfQnP75vHhV+cBjzk0K/GobfJAt/NIzz1tG/hnH/Pix8
YxjxraWfjWAe1ghvG4F/rKa/xXiVcPcI6v0Q/W4E/VgpvDSA75Hl9L8A5sck
fDCA+2EZ/TCA/e4XvhLA/C2lPxoq+vfIYuFVBvR1L/3SwP25SHiXgfosoH8a
mId/pv7jowb88m/hBgPn/SXsxH6Ts8IRA/M8I/yLgfv5d+E7sXimhZcH8b34
q3BqEOdNCu8IYv5uCBcGsf914cNB3E9jwnVBzOc14b4g+nlF+HwQev9J+HoQ
9f1ReC6I+kSEHwjhvrsonBJCvt8Jbw0hv5CwJYTzA8JlIejBL3wiBP17hDtD
2k/L3cJG7DyH8LUQ9G8TngnBz3qEF4ehP6twUhj5tQubw3i/RTgvDL9uEi4J
Y/8G4aow5udMlP8FIYLx/g==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1GUcx69GbmHT2dg0N4kmc+isKFqxtrPHl0SMUmgpbZclmflScVIU
ASkQpLESLLSOiHiVA+Q87gXujrvjf3+W0iI3NxfL2YJarAZz5bTMNeue7+33
9Ta4ffbwf35v39/3z31FxQWv3G6xWL6J/+hv+dTN5me/OHf/2gTlqrFrGbYd
5OeVNXmy8wVho0htmi5PIVv2qji6bMKqWAVS6/aTjRJ1bzwAeapUHbAmbydb
3lWunOlyclqlWmlrMG/dd0jHX854mdWq2eFw3MqnRsd/gPlurdXxzpOn6lRB
PCHWZz+svpuYyHuJ8T/E/TuFG+tVl92aXMR8PlLxdK6R3R+reDv+eJn5NeB8
l/CeRqW/djPfY+jXq8LXjyHfPcz/E+SzV/jIp/p++z7W04R69wsvOY7+vMb6
jiP+68LOEyqOGcWs9zPMh5z9udod//B5i0PzDOONO/R9pTxvbNb9u+MN4cIv
dD1NvC+tRed3zwHh31qglxL260vk85ZwWatmZyn79xX6/45wUpuayw+0lrGf
beqvDNvCcuGJNuilgv1t13q9VCnc1K60ng+y3+2Y/yFhW4eqSHGdrWL/O/R9
N6qF0zt1/NT3OY9O5F8rPJc4r+N8utB/sq8L9X3AeXUjn8PCld2YJ3mqW89/
grzhJPIjO0/q+hvId/UgPtneg3kx3gWctzKfbCeY+bc48fesz9KL+mqEd/VC
X+zPeK/OJ4f9W92nsrKyvO9RH32YP/t/tQ/7z3kV9qu4nCOcZ7gfeuK8007h
fuqh9hTm9Sb1hPOz1FfeAPbTTn0N4HnqM8WFflG/ZS7d/wD1fckFvXEf1Wno
mfvcdRr50R+S3NhH+tGjbhUPN11Ifbqxv88JN7sRL596deP+rcI3E+fkzEH4
FbloEPeTmwYxD953ZlDXX/8s9T0IPTD+Kg/6xXObR8V/VxUIH/XoeVh5n+FB
fYx3xaPjrSOne+Ff5G1e7d+TW7gfXuiZHML5dvKcF/tLTvWhnme4Pz7EJ9f4
oCeyzwf9PC0849P92Ule4sf+5glv9qPf5Eo//Jbs8iP+U9w/P95P5LuH4Ceb
uY9D8Evy20Pw/1zuJ9hOvpg438R9HcY+kNcMw29zuL/D6Be5Yxjz28h9Htb7
lkWeF0C/n+R+B1D/BuF9AdxHbgnA/9cLnwtoPVjIliD2Z53ww0Hoay39IIh+
KeETQfjdE/SHIPRHvhFEvWvoFyH4IXlHSJ/PkhtDqI/PmyHsP/lqCPtAXjEC
fTKfwhHcT64fgX6Yf3gEfkC+DF7IetPC0Au5IAx/I9eGMU/GHwrDL630pzD0
+Ljw0gjiPUa/ikC/jwgfjGD+D9G/IvCzB4V/juD+1fSzKOpdKbwxiv/PVtDf
ouj3cuG+KN6PafS7KOa5THjBKPJbSv8bRf2LhUsSnEI/TPAi4e9Hcd8C+qOB
98t84WUG5nkn/dKA380T3pI4T6J/GpjfbcLVBvzmv1nxUwP79a+w18B+/CM8
YWDefwv/aqA/V4Vv4tzxp/DiGPz2snBmTOmvOeHcGPr/u3BRDPsxI1wRw7x/
EW6K4X06JTwQg35/FD4TQ78uCv8UQ/8nha8nzi8ILzJ1PlXnhVeZqP+c8HoT
8b8VtpnIb1y41ITffS181IS+TOEeE/qLChsm9Dki/IOJ/ALCVxLx/MLzx3C/
Rzh9DH7gEraO4b5+4W1j0KNTuBjn1m7hI4nn2+P8PxiyBss=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1HUYx29O2zIWy9GiWqSLFblsLDdGW9RPJRGjQlaIdVkSWtoLJ4Uh
kAJBIikvCughGXAgL8J5cMdxd9zB//63pW3U1mbRi5viprPBqrF05lp1vy97
vpu3ifvs/r/n9zzf5/s8/1uRX5izfZHFYvkm+k//Lx9nxkxpzdyqNQuUqXan
LZ3+nLxFrY5+aoWNfHUjydpwkN/vVEunHX/WCatCfX7zIT5fpKYdttBh4UvF
Khr+kQae34t4jcLLy1U0n1tNjLdf7Yh+jgonVyK/ZsavUt9OTWW1CmdX475j
vK8G+duFbQdUg3m9r433H9ScdEK4sU6VxTkzjjOfQ6inRdh1WEWuJ1mPML8G
MOt5txH5sP7kJlUzuymVet1sUm12+/3U1ziirNEEqoRrj+rzU/tZT7Oa2+Q7
WS4c3wI99rK+FjVTGvfkHuG+VvSjiPUeQ3424dTjasNMafNu1m/HfXz+nF3l
+BKWfEw92tTj1oa1xcJ5J1T0bwXvW94OvT8RvtaO/pVQry9Rf6lwyUldb3EZ
9ftK98fN+hZ3KF9Czeyn1LMD/aEeUx2ov4L6dkKfSuHmTviDet7s1P6KrRa2
dqG/9LvRpfMtZT8SHVpP5wH2w6Gij8/Q/3MOxKPfs7t1/WlfCHu6kR/7H98D
f9P/5T2ot57960G+9E/6KfiB89B3Svcrjn6L6UW/OQ+2XtTDeTjfi37Tr6l9
Ws/3OB/tfdCf82HpRz/p94J+ff4C+Vy/ejjaQMZ7YkDfd5bz2TiA+lnPXwOo
j/rknUb/qGfwtPa//TP6ZxB6sp/Vg8iHfrg2CD/TT1lD0Jd+dA1BP/o5zgk9
PqTfnDr/73cJX3BqvyTspP/OQJ93hLvPaL+b2+lHF+a1QDjFBb/k058u+OMt
4TYX5v9N+tWFeG8I/+uCXlb6dxjz85pw/jDy30I/D6Mfm4W/Hsb9ufT3MPbT
q8IrR1Afn7eOaL2u5gnXj6A/vM8YQTzmMz+C+7dyHtzoD+vLdSOfbZwPN/bp
28IBt+6XjfrNuVEv9U3wqG5b2lLqn+25vT9VHszz+5wnD/rDfl71YJ9wn8WP
Yl9xf20cRbyPOG+jiEe/OEcRj/vq0ijicZ8u8yIe91O6F/Hoxz1exNvH+fQi
Hv37ixf1cv/EjGGeub+eHcM8MZ5tDP2gv7vGMO/M9/wY9KS/7/Ahnw843z7s
A+q3y4d9s4Pz7sM+pV+/893uT4sf/Xtd+Ck/6qdfCvyYt1eEW/3wczb3gx9+
e1H4lh9+yuS+CGA+nxfeGsD7eC33RwDnlbAZwPtjDfdJAH5bJ/zouO6Xj/Hy
xrFPMoTrxrHfeH9wHPdvFP59HL8/NnD/BKEv4+UEkQ/vqw6iP2RvEPqlcz8F
oS/5gRD0Z7ysEPywXnhfCM+TXSGdj4P5Xw7pfbKN+cVNIF/Ws34C58klE9CD
9Q1M4P4XuO8m0L8s4bsn8T5nv9Qk4r8kXDSJevl99yTuY/wfJ6EP81tsYF+w
3ocM6Mn+phj4vfGc8MsG3q/PcH/i/NmnhSsN9DuF+9TA/auF3QbmKZn71YBf
VglfWeCV3LcL/JjwfWGcT+T+DSP+CuHMMO5P4D4O4/fRg8JlYegTz/0cxj64
V3gorKJ/K5ZxX4fRz1jhi2HoH8P9Hcb75U7he0y875Zwn5vQZ5HwOhN+/29W
9ruJ/fOPcLGJffa3cL2p87HcEO5diDcvbJjwyx/CP5vYT3PC8/g+9jfhuyLQ
44pwYkTv87rLwmkR+OGicG4E+v8qXBiBfj8J10bgzx+i/D81thDx
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9I3GUcx49Y/WFRFAdZkBmNsFEhCcN/Lp5qZCtjarW5ulbZttxWebNc
m8rSpWxJm7rd3M45p975W8/75Xl33p3f7/diLbAgiKQQ0qAxUCJGxtgfI5/3
8XmDgo4Xz/P9PM/n/fl83s+eqKqp2HeXzWb7Yf1X/ys//pLl+o7VZ1/M0naV
s+D9p5O8W9n9JR+eEzaq1OOtKz+7uX5APe1sf6lLWNWo5Xq7/wL316rV8lie
R3ipTlXE8lq7+f0xnHdJOL9RHXbk7LrMeF+pBa8r1Stc2Ix4fYx/Qq3/beoX
LmtRmbWCxQGe16oa7P7vud91Uu+3MZ7tG+XIWXiyR7ijTcfv5fn536puj+eR
K8KB0+rV5Xo346l2zXaeV92BdS/v24nvB4VvdSL+EO9/FuePCJ86p9qttZFR
5uPWej43Lpx7XrWulMcmmN956O8XHulSP87Pz08x3wtaD2dQuPiiWpd/JcT8
PUrXPyJ8zaN8LkdOlHp06/t7ZoQrL+E+cerTo8+3EsI3elC/JPW6jPNSwkd7
Uf856ncF9TSFN/WpoqKisEU9+6Dvd8LzfbpfXOTCfuTP/e5+xDOodz/ySQs7
B1B/3s8YwDrvv9mLesRYDy/yoR6rXtSHepX5UN+wcMSH/qfeuYM6/0MB4cZB
1IP1WRrU92li/bYNoX8nWc8h5Eu+bxj5kl3D+H5M+JdhXc/b7K/iEbVenjr2
Y88I6sF+to2q/es/7P+9o4jHeb2WZc7rM2NgzmvHGOLz+3/HEI/zUzkO/Thv
yXE9zw6enz8BvTlPLROoD+f5xoT+foFcOgl9OW+BSfQv87P7Ed/HfvMjHudv
0Y/5Iasp1Id6+aZQz2H2YwD+Q94aQP04r9UB+Be5OwB9OL/zAd3vd7M+d8Ct
5MIg6kWuCkI/zrs7CP8iXw2ivzn/t4LoD/KW0EZ/cIZwP/KZEPRm/xgh7Rel
5JshnE/eHN4Yf2cYevC+p8LQl/kmsO6gXqvZ76l3XgT+x3qVRZAf63sios+/
zv6IRBCf/XM9Aj9gv+VOIx/252vTej4LLnLessz3yZ9lvl9L09DzrPBDUfgB
38NtUd3fa6eFj0Tx/rVxPqPar4pOCv8ehf9/zXmdQbwW4RdmsJ/rrhnk1yw8
MAM/Pc55xnpTo/A9MV3f4nrOdwzz/KXwwRj8uo7zHkM9Phf+Kabf82UX5z+O
+J8JPx+Hvp/QD+LwuwPCXXHc/2P6Qxz9tlf4dhznVdEvElh/X3hPAu/He/SP
BPrhHWErAb0q6ScJ9M/bwk/NQv8K+sss4pUJt81ivt6g38zCf14X/nsW9+d6
flL9V+B8YIdwRRLzwngtSbynPC+ahP+8RX9K6vu27RR+NAU/4f1LU7q/S5jf
8RT6z0n/SsEf9gj/mUL/Uy97GvX5QPiVNOpH/Y6m8R68KzyWRv15/mIa8ajf
/XPI/0363xz8m/nWzkF/6uHD+hr51znE4/5NBt6rcuHHjI312Zplnrcjy9Sv
2oC/837NBvKjnt0G+nuXcNjQeth2018N9Cv1/ctAP1CPOwb0p94Pm/A36ldo
on7Uf7uJ/39Q/yoT+VH/BhP1Yn+7TczjR8KTJurPebhqor/3Cf9hIt/99G8T
968WftDS+pRz3rZY8JODwi9b+P4Q/d2Cf30qXGchP87zGQv51AgPW9DvMP3f
gv/XCv+GeL30i5sW6v+F8L0Z7D/C9yGj/ddL/3FkEP8Y34sM3kv6VU0G70cD
348M3j+9/39GwwFx
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn1o1GUcP8L6Y0lRHKRBa9GIFRVHgeyfxdMLLUPI7Q8zGIFLa2q2czRZ
m+VmDufS7aa32Z1T9/5y2273/rZ7+f1+V3PGFQSSFEIuSARHhLgQ/5Du+Yzv
R3awjQ+/5/c8z/fzdnuuvrF2z0M2m+1y8Uf/lc+znbdqFlZeeXMNbVX/VdT1
pog/Uu8tt7qTgo16ZfdX70rw+V6lf8cFq0aVKO3cH+X6JtVrrU6FBV9vVsXj
EkG+/5WqKrk6Oi+47LAqQucc9zuivB7P5hnBjg6sn+L+R/F8QvD2Y8pfvdw6
yvM69XmVY4KdxzHPOM8/oe97i++7ulXx+CruX3YSfEwLDpxS+dWKaz7er1ff
5/lZwQ0uzM/7O/rUcqvd7xd8t0/P9y/nNU5rfirIR9cZ8BviPG49n4f8bepX
bXb/pQjn68d+5HtqAHxQD+dZzE+9Kr9XB6tKPqSeNg/4pt5LHq1nO/3g8mL+
tOCd58BfhvwMAmcF3xzE+hz5Oq9qi4QYglsuqLpeq9kkfxc1n3WW4A1DuG+e
fA6pnwuFbT8ILgxpfpaJHcPw14+C3cPgf5F8D0OfS4LrRlTR778SGyPwy5Lg
8lE9j/0y9RjF/sQro3q+x3+iPmOYn+dFgO28/6ZxPCcfh4Ht5PP6OPiiPu9M
YP8Hek6oMWdVN/2xcVLz+TD95JwEP/TblUnsR1w5tX794BTyQ2ybVp8WP/Tj
7mnsF6AfpjVfNTz/ZR/8Qn+6fGqlJnGB/rzjgz70584Z9XrxExOcngEf9GfZ
rPabjX48NrvejzdnkU/6cdscntN/gTmt3z36z+4HXw/85tf3K6W/rvnRP9RH
zeu8Z+insXn1YtGgfL4hgOd8f0sAfqB/GwLrz/MGkF/qXcD6Ct7vfkDzfYP6
O4LIN+erD+rz3+L87iD6hv5YDGJ+8nc3iPnpl5dC8DP5rwuhH6hXTwh5o55G
CPNS/9sh9Af9UR7GfvTTjrDWq524K4w8E6fC8BPxSlj3VTVxaQR6EG+PgA/2
59EI/EkciYBP9v+NCPpvkvmKgl/2+/tR6DHEvEXhn0HB/ij87WH+oujnfsFP
xpC/08xjDHz3CD4Ugx7fMZ8x+OmE4D9i8Pdx5jUOPjoFvxHX/XuV2BmHn7h+
JA4+ud+VOPzA8x5JoD9OMd8J5I3325fAPC7mPQG9OM8vCczvZv6T0GNA8GtJ
zE+8O4n5uX4gCb9wv6Wk5rukT/C9JPTuZV+kMA/v+3EKfuc8rhTuy3mtFPJG
Pu6sYfL1wgLWf8t+WcB+HYK7F+DXI+ybBcz7teB/sH5zG/snDT1bBNemod8h
9lEa/H8pOJaGXw+yn9Lgt1Hw0xnoc4B9lUE/7hP8TQbfRw3sr7XnewT/lQH/
n7DPsuB7l+B3s1jP5y1ZnM/3fVnk+zP2XRb/z+wV/FgO8+9n/+XQH58LbsrB
n1+wD3Pwt1Pwbznw08R+NKAv+XnGwPcF+dtiaL1eJb8fGJivlf1pIJ/Uo8PQ
ehWol9dAPqhn2EC+qXfBQL7oh78N+I9+uW+Ab/rpKRPfh/Sbw0R+ugVvNcH3
SfaxCb6ZrzYT/mK+3Cb4Zh7mTPz/wrwsmuCbefrT1HytnmV/m+CbffSEpb8v
w+fY5xb4Pi/4bQt5vMh+t8AP+67Zgh+4vseCHl7BkxbyzvMNC/yfEfy7Bb05
3+21/ZjfR/PIA/kqz4NP8luVRz9Tjx143tkuuDEPP1Lfrjzuo/H/hZA07w==

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlltoXFUYhQeJPsSiKAGrYIwYJJYqxUDJS8r2glop2OTBRhgEQw2pPmQs
RHoJakuDMdhmqtPWmaZpkplkJpNkMvf75ZwzNU3ttLVaGlujbYqN0QQRaSX0
oXj2CnuVsVDCxzln77X/f/1rz9OtHc3v32exWM6Y/+Vf9e+jxsptxeXnX1ql
zaIq8Pr8KfI7Ilnd/eG0Yq1VmI/vnObzHcJja+w9o1h0CJfT+fhZvr9T9Bm3
fSXF1ztF91JTw3l+v1ucK5VKFxTXdMn937vI9T4VlbPuv39QvGGfaDYFXeL6
+7HfZcVbD4j6+vrILPfrFnvNBa8otn0uirfr5q5y/y/k+rY5xfZeeZ7KX6nn
S7HclBy4pjh4EPrnqa8P+m8obrdD/2/Ue1hYzQLcVLxyGPX6nfq/kutX/6G4
52vo/5Pnccjz3r+keO0RYfZrdpHnOwJ9C4p9R8v3tx0T5uvPUF/DNzg/z2Nx
in/rrH2/KJ5xiuesfS//zHq4oP8nxS3H5Xpu1rumX+rZxn4s9kMv+xU8IeuV
ZH93DcBP51i/k9BHv1QMwn8zrOcg9qP/SoPy+6VvWd8h+IF+dAxhPfpxZUie
x/hOsXUY9aEftWEh/9CPtW7Uk3p73KgP9S67ZX/qud5Wj5jfUxUgRz3l51k7
gu/JXSPQT74+Ikz7NVLPq6M4D9k3Cv3kNV7MA9nmFW+YAqjvklfOWx25wQe9
5H6f1PsC2TIG/5G3j6Ee5Jkx8VT30kXut94v581Jtvvl8ybyLT/ygedrGcf7
5Ow49JFrJpAPrN+BCcwzeXFC6vmM/dwyCf/TH8FJ6CdXBaS/rfTDrgDmjf6Z
C2A/+kdMQT/ZM4X68v2KoKyvg+tvDKJf1NcehF95Hlew3C+l1ffpp7tB9P97
+jeE+nBeWkMyT7Zwnhwh9IPzNh3CPDHfVkLIL+bbujDyjvlmDcOf/P5QGH75
kf4Py/nupL5/wsgHnqc2gjzg+d+OoH68H3oiyEtdcToCPTnOSwT9SimujiI/
45yfKOYtrHh/FOed4jxF0Z8JxQtR9Gec8xXDvJDfjMn6P0zuiqH/fsWBGPJs
jPMXw/rkR+PQ4+M8xtFfr+KP46gf2RfHeUYVX41jvRHOawL56FG8KYHnbs5v
Av4YVjycgP+HOM8J+OWk4geSqP8A5zsJv59Q/EES+dvPeU/CXy7F55PIJyfn
P4XzHlP8Ygr1JW9PSX05vn80BX8fZz6kyve/k0K+UO/6NPrJ87ybxn3J89rT
2J/1MdLwD+t5Kw3/sR/PZlB/9rMlg/6w370Z3J+TzJsM/EE//ZVBP0LMnyzy
KKK4OYv8ijKPstBLv8az0JtkPmWhN634iRz0ZplXOejNK/4kJ9ra2hYKzK8c
5pnzcyMHv/L3WFUe9WU+vZZHfe/lWx79Zj7685g35tNcvvz310MF5Pm9+7eA
5+SdBeQd2VMoz7PL/3teoZV//6Qm8+c0eaOGeSO/peE+4n3brsl67yHv01Bv
sgvr1zGfIhr2J5c05A/z9KaG3wv8/q6G/GOePabDH8yzDTrqz/puXn1uMI91
fM9+7dWxPvvr0KGH+Tapw2/0y7QOf9Bf13T4L8j8xv4N9OsjBuaf/l5nwI+c
h1cM9I/5YQU3cb46DfiDzw8ZyEPmkddAnnA9zYB/OH9XDOT/IO8DrBfgfD9Y
xPmYJ7VF7M+8aCziPnbwvihiP7vijiLqe5D3RxH97zX5Pwz1ShA=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVn9InGUcP8L6w0ZRCK0gMxphsUIShv84nmq0FkKbf5SBBMkKqz+0gbEf
Um4oLam8la6dM1Pv3J03vb330/t9773HlrHbamWzLWu6mFlea5kuWzB6n8/x
fI5LmOPD8z7P8/1+fnwfH2xqqX/1FovF8qX5T/6vfhp7jNXV3GNP5tE28ez8
3rICfkmUeba+sqKw3iTx/F9cf11+30ssWkTpjL2VWN8lzN8dxHNtorq62l/Y
v0c4WmtLeX5FO74nFu8W11O1XzwiC+b5B0R9uLzrusLbO0VmtbLxb97XJb9/
ak3h1veEWV7tP7z/feAbClu7xZlstu5f1vOBPG+W69qHqIf7RQ/2875mq3ig
a2lHod5DqIf9rh0Sb9WWvvgn6/9Y7DMJ/UPhg58Is7vK39lPL9ZzCq/vk/tn
uD7XJ14zf7jfdVhIeq6x30/B57LCNUeK+bbYoB/rnbKJfpvtXvZj7ZfYRv4a
jmKdfFQMiOuVjT3ka3EAehT4+qz4vN2Dsj9XwS+fC5OuGtZbMiT7/YL9Ng+B
z18Vzg7Bf1fI77Awr3vzssK9w9J/134i38PC/HzvDwo3jkg+LN+T/xHUO63w
Bjv4OUc97PAPcc6O+7+hPo7i/QEH9DtPvUaln7IzCrePIh8XqN8o+GF9W45J
PyVmqecx6Mt+1jkl33fOUV+n5C88r/C0E3n9mXq70A/5GnAhfwvUfwzfLyq8
cwzn/0Y/jOH8JYU3ulEP/Wd1Iw/034ob+aSeDcfRL/0XPy5M+z5UyPu41Pcc
/dc5LvXpoF8Wx2W91cxb3QT8SKxNwL/0Z5lH5HaEBwt+8wizPA/nw6wHevA+
cQJ5YT2OE9CPuESDv+jXTRr0YT/NmryvnLhfk3x3M99ZTfrjVuKbGvJLvqq8
mB/0e5MX+aAevV7oQf1OeWW9bdR7zYv59KPCj/rAb8HvPviVfvrIB/7oJ92H
eUQ/LftwH/O0wQ++6KcX/OiP9RzEet0vCkexXsq85vL76afyAPaz3+0B7L+q
8IEA7qd/Avl18rcQgB+J1welvo+T/+eC0J+4PYh8UT9PEPOq8B4FoQ/1vjsE
vxJvCYFf4rdDmFf0jyuE/BNfDMEfxOsmsZ948/9w6yTySDwyiXwRTwMv8P7b
wrifuCaM/LKfN8LQk/0PhMEP+TqL7+fpP0tEmL86yP8TEejHfO+MoD/m/3AE
eaG+U5Hi+XEjgjxzvmyMwt/0y8tR9Es/WaPIG/1mRJFX+nElin4vKfxwDH6i
3xti0Iv+7o4hj/R/PIa8cd5ejcl82Dn/K+J4Hzif6+Pgn/O7M473+zuFQ/l1
zvvFOPj7VuH7Esgv34e6BPjm+/FOAnoQawnk4WuFLyfA71ecZ0n0R/xMUt5n
Id6dRJ7PKuxO4u8F4tkk/E18Rwr9EosU8sX7d6UwP1i/I4V62N/5FN5n8lGi
I2/k7369+H3bpOP9pB7P68gj9WvWwQfxfh31XOQ81TF/eb5fL35vszrmP/m8
ohfzeVPHPOH6PWnoT1yVRn3sd1sa/uV6Uxp5JV/70sjjac7ntKxvaUrhiTw+
yXmd/95Q+FIafkhxfufviyt8lwF+I5znBvISUvhpA3z7Od8N8KEp3GaArwnO
e5y31a2w00DenJz/BvLkUviCgbzy+2UDfuf3t2fAr4PvQwZ8Ditcm8H8G+R7
kcH5RxVuyaDfI3w/Mshnn4n/A/OWX9k=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9I3HUYx225VTcrioO2IDMaYaNiFAz/MT7VaC2EnH+sBUeQ1LD+8RoY
y0ltQ8mk0pVbabbU03k6Pb/e7zvvvO99L5qja1TIVkPqHGxIc2stXWa1+n7e
8ryPO5jHi+99ns/zvJ/383z3QG19zWtrioqKTtn/9Ld8fNvnGh2XH31qlXYo
+8+BPL+kHGc9brJZqx52tT+df/66ss+v3Cas6lV3V1cX2dyreSM514D4t/L8
22q/03fyFuGyJuVqt5bWMd67qiZaupa85SCeFzP+IXV/y6XvbxaublbXy13t
a3hfi3rC/twk7H5P2eUk/1uQ+9/H8xvCHW3qubnGzn+Eyz5Qe+wP2fhQDbgr
2/4VVu36fIDn6zqU0xaE8bccRv28f/mwzncn8zM/Rr7Mv/UT1MP6qjtxnvVv
OKLjv0K9ckeULYeXenqPQh/q7f4U/VovXPEZ7iuh/l2oh8+nu3S8csbr6Nbn
Leaz+3OVWSp3sZ6yHu2Pq9Rjvgf9Ihtf6HwaqM++Y/r8LPVRX+p+VDJecS/0
pz51vdCT+mR7VaXj7INr6Yc+5EN9OvvgL+qz3Id4rMfVj/rz/uxHfvTzJk+h
Xq0e1Ede8Gi/N1K/6gHkRw4OqIWd0dLb2a9B+IvcNFj4PDcIPXh+23HMG9l7
HPF5f8mQmmt0PkZ2D8EPzH9mCPWwvgovmPX3eOFn6lM0rOdvO/V7dbhQ3+lh
+In6PzICP7A/HSPQk/1bHEE+RfTLCeTLfidOwB/0Q9ko6ud8NY9iPv+mn0bh
7xXhqjGd/0WyMYZ9w/NOn/o2m63K+82n8C35zPowr8xXjUMP1jcwjnlj/cUG
9hN/v9Uo3Bd1Bu5nPt0G6vtTOGugn38I3zAwb1e5HyagN7l2Avf9Jtw5Ab+R
v57AvJCXJ3Q8B3mzH/pcEXb5sU/IH/kRn2z6tV5Z8jU/+kHeFMB+J+8KIF/e
1xpQb1Y6XiTHA5g38kIA8cilQewX1lsd1Hq1kA8FkT85GET+vwtfDCI+9dwQ
wvwvCT8fwnxR/6YQ5mdZ2Bcq9FMuhP7QP3eHC/u7LYz66d+3wvA//eANo5/0
z7kw9jv9UxKBnzhvT0ZQH+fRHdHz4eP89kcwr5z/mUjhvl4X1fUdy+/zKPzM
829EoRfnvyeK/cX7TkeRT/79G8P8M7/HY8r+eyC/D2LKLifKeo7GoAffB9Mx
+JG8EkM/8/sijny4L16Owz/5/RFHvdTTisOPnNfFOPxCfmgS+bEfuyfhL/ar
bVLnW0FOTMIvfB9dmYQe+fd7AvWTaxLQl/unOYHf0y/hBOolzyfQ/7+E702i
XvqtKqn7dyf5nSTuoz+NJOb7uvD5pNbHQz87p+C3ReFnp1Av/b9vCn66Jjyy
ypyX2dXfc57uSCEe51GlUC/ne28K83BZeCCFeVgQPpNC/F+Fi038fl74PhPz
dUF4q4n7zwu/YGI/5rg/TWXb5dLPwgdN7H8+7zbhF3IA8Vz8fRbxWmaFL+D3
nnPctybm60fhe9LgM9y/aezvGeEdafTjB+7jNN4n3wnvT2s/OU9zP+N59hvh
sdXzp7ivEX/jSeFfVu//ivs7DX0t4bsszHOK+9xC/UnhZyzsgzj3uwX9IsIN
Fv7/EuK+t+BPv/CQhXzHuf/x3DEm/JOF/o3wfWBB31Hh9Rm8L318P2RwnyFc
mUG+vG9XRumvoHB9BvuY+bVm0G+d//+mTh3i
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx1mpa0iaSomWiIGGhO7SItqiPhqFGhXwh9F2a4sZo/6B3GiG
rNRxy1gJ1mmBZPw45IdwHtxx3E/43t1mtFFbRZJGCZZEA5szccyW6z5vet5N
Nri9+H5+PM/7eT/P99YVlRa8fkdMTMxX0V/9KT/2nImKbVc2bZunncpcE57d
Tn5FxY62lGULG0WquLh48lk+f0PF23NeyxFWpeqtrNjRHVy/V+2PLtglPF6u
oscFn+f+d9RERfzmF4STKlV9XV3dizzvPVXgSVyYJ2w6qGbyPSf53Dikvh4e
HuZ5eVWIj/ePW3T8Vxlv2fvKk2iZ/j+/D3T8E08L11breL98kvF8qKLptDwh
7PhIab0yGF8N8tsqXFKrbqSal5oY71G11jL9bbrw3FH9vGYj4/8Y+zcIH/5E
n3/zQeZj1frY1wonHNP6vvwA8zum9Mcq4fbjKlq+9nuZ76dan9zlwpmfIf8l
zL8O+d8tPFSntkZ/llKPen3+gXuEC08gn2XUp0Hrk7xCeKpB+6c8nnp9rjZG
/8F49p1UO6IJraR+X+h6FScIL2jU9zuZT0kj8rtfeLgR+TB/UxP8skbY2oR8
Eql3k9YjNUnY3Aw/r6P+zcoyne+h3ikt0D+Z9WjRfs1aLzyD5xWsV54N+x8S
dtnQP6msVyv8nSZc2Yp+eZj1a0X89Ef2KfhvE+t5CudtFo5rg970V1kb/POI
8Egb8tvCerfDb/RnQzv89Cjr34H7HhPe0wH96O+hDtz/uHB6p4rMpprJtZ3o
P55/vRN6Mb7C07iP+QVO63xX0f9JXcpWllVNfau6oD/rM9UFf7Ceud3w32r6
q1v7azv9FG/HffTjPjvuo3/H7HqeWOLovzOYD3cJ284gv4X0owP3LRLOcGA/
15c4kG+scL0D5y2mXx3oR/bXLQfqz/4y9SA+9lNRD+5jv1p7oA/76WwP8r2P
/u6BXsw/rRd+ZP+Ye+EH9s+RXviR/WL0Yl5S32u9mHfslxQn4mV/7HYi3hT2
hxPznvXzOdGf7I8Zp9ZzjOsTXZgP7K88F+Ylzz/kQv14v8ul9cjn/JvE/lnG
n9CHeDkPdvVhPfOt7NP6xdIv9j74nfNmHM+rqd9yN/ZT32y3ft8kcn697cb9
9Fe7+/Z6XXBDf9Yzrh/vK/rvqX49/6ysf1k/7uc8bp5n+mWkH/Xm80Ue5MPz
Mj04n/e96cF8Ijd44FfyNx7kT47xwg+Mf4sX72fyHi/6j/ken19PPw55EQ/1
uemFH8npPjD1fNWH9dS/1of5TL+GffAP63Xdp6J/D7CeG/zQl/Uu9ON8+qHa
j3lIvwT8t/vnTz/qyfVJAfif9xUE4CfGVxXA+5bxuwOIn/lPBeBX6rk6iPtY
39wg3recN+8GUR/OC0cQ3284Ty4FUX/On/gBPL9T+LkB7I/hfBtA/P/M/Med
A9Dvb+GxAcQ3J7xkEPHfEFaDmHd/Ce8dxPqrwrZB+P2K8LlBrX/mtPACA/H+
IbzGgL5TwhkG9JwUfsnA/LgsXGLAn78KHzQwLyaE6w30yyVhJ85L5vphA/mO
C182MO9+Fr5l4P13QXhlCPN4VNgUwveTEeGdIej5nXBRCPd/L7w/BH9xvTUE
PX8Q7g7hfUg+G0J/nhO+GEJ8vH8O63N/FF4Wxvev88JpYejF+J8J476fhM1h
+GNMuDys9AfzPzLPvwi3ze+/KGyE8X2M+p0Pox+p/7Uw3m/Uf3EE/UD9UyLw
42/CWRHky/rujmDesP6lEfjpd+HDEdyn/fMv+4z1Jw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1HUcx68CKzJNo3woEXswJHXUFdED9jWdT2MFVIjrsmTVqP7gcqOZ
slIHy1gFFlpHqDzKg3Aedwf3wB387m6z2q62tlarscW1ZDTQntARNer3fd8+
7002ca99P9/P9/Pw/nx+rCqrKH75aovF8qX5T/8vP/lp37c9fWHdxiRtV86t
if3PkHepA+nOrc8KG2VqW2J/egnPX1VvmA7IqkI1OhyOnbTfq1bWTBaVCo9V
KtNdgmx5S5m/DvJ+ZpV+f5bxqHe0/51FwjmHlBmunWwcxvvFwoXVyjzOZ/xj
NWqqyH+S8dvf1e9ZGJ/lPR3PHsZTX6vvh3cxnveR73PCrg+UP6PmdRvjq4P9
88Ll9ardnp/2AuM9ivhfFJ45quPJ2MP4P1KvmD/kIx+ruuilLnJhA+pFXnoM
8ZQxv2Nqja3uCXLXcfgj2z9RsUtZNr6f9ynu72b+DvVVPB5nfl84dPy1zL++
UZ8XsF6ln+E+65nZhPhY/4kmZbVaPYWs1wn4e1J430n0r4D1O4X4dginNEMv
21jPZtRvi3C8GfXfzPq2qMtZZgGEG1qQj2K9W7Qelz0ubGtVxaaDfNa/Ff16
TPiuNmWm53yE/WjDPDwsPNWG9/PYn3bk95Cwtx16zGW/OpAPuapDv59KHuvQ
/Rp/UHjzaWUzBUDuOq3M63m0n9+p9LyS7Z045/vfdur4Jsl5XdAn423qQn7M
x9KNfjHfl7pRv0eph2744/naHsTP+/U9uv4LeT7dA33wfukZ1J/1DZ3BOeuf
2Yv7G4Sre+Gf/ZroRT3IBX1aL6Psr6tP6z+6UTjdifpQD/ucyvx9cJPwqBP9
oH7UWeiX5+1nsb94P8UF/dN/rgv7ifGUu/Ae4290YR6ZX9yF/rIecy7Ew3rl
9KMerGdZP+af/Wvoxz5jv8/1oz8PUN/9mA+rcLYb791HvbsxbznCH7oR/3rq
3415WCf8pxv9WMt58GB/ZguXeHR8WWs4Hx6tP/89wkGPzqeBPOVBvWmf4YX/
ezk/XuTD9w57MU+Mz4vzAsY/7tV6tZKXDiA+xr9j4Er/VeC6LGEn7DNWc/4G
EP+dwosHMd+rOI+Del7WrxR+cxD+V3A+k3yb8I9J+2WcV5/Wb+US4Q0+3Y/f
b+H8+qC3dOFWH/RxM+fZh/wWC8/zK4TJ+fZj3ywSfs0Pe95v8iMfvve1H/Vj
PJYA/DHe+wPox3LugwDiu134eADflwzuhwD8ZQrPJv3dwX0RhD/Wd3cQ/u7m
/gjCH/USDcIf9TId1Pr5huerh7DPeL90CPnSf+0Q9jX7FxqCHhnfxSHsM55n
hvD3De8Xh3BOrg6hvrQfDEEv1MNECPqiHpaH8T2jHgrC0Bvr+zbOR2/l/gpD
7+z/z2Hkz/6mD+P9hcJbhtHPG7nfhjHPacI9w5jn67jvwKnzhBeMQF/XcP+N
QI8W4b0jiH9uSvbhCOr9j/B3I9jnfwunGNgvl4VXGNjHfwnnGvi+/iH8lIF5
vihcjvPaSeFDhu7H5xPCjQb2/3lhjwG9/CIcN7Afx4XPG5hH3p+D/fivwksi
6B/fy4ng/QvC2yP4e/A34TLY5zH+A7BPY34NsE9MC/dF8D1lPc4l/c8I/xRB
fWeFZ2Bv/Vd4URT+Wf/sKPTyn/CmKPxfxf0O+1r2sxL2tlTue9hbrxXuTPq/
nvs/6Z/6+SHpfz6/B0n/C4RviKE+N/H7ELtSr/kx+KeeS2Cf4P6piKH+3D9H
YpgfPR//A8oe4WM=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVl21sk1UYhhsz/FGJRLPEaWKdceKYgJXqnB/Fw5iM4ZRt6gCtKM2oQ3+s
ksxMWHQQFueibOhAOyfuo2NlbOVdW9Z2/Xr7NgFMqokJkWhIZCYSEqYxRAzh
h7Hnbs7dlIQtV845z/t83M9zzh50drTsvs1kMn2f+y9/q39LzRHLa3+u2ZCn
BtF7rTnSSt4h3rebt21XrDuFY8C4sYPre8S/lY6BNxSLDjHs8dz7JvfvFZsX
95Vy/XKnaIlYlhXOf4jvkcu7Ram/ftfrtPcx9vO89YCwmy9OkPWD8nyNQ3HT
IfFDNpslX+6F//TH/YnI3Ki8RDZ9KtmxU/Fgv9x/kVz+mdifc+gtxdrnwmaz
BcliAPG+rbh9UOank2w9An/IN4/A/130/wvhcrmuOBX3fSly6a1sYzxDct21
W3HZUZGr13EX4zsqIpbea9zvOwb7tOf+SuR+9pBrvpb1GCKbPMX7z3vk933k
weFi3v4Nvk8uH0H9yVdHED9Z+xb5J3cdFzk5rCWL76R/JnLJqMz3OeanfVR4
3fZ+cnZUrHIM1JKtY9Aj8zs0Bv8K+R7DfrJjHPVn/fRxkQvfTa6YgD/kvgmp
v17qYQm8jNzkFf76xX3UU8gr7f1N/ZVNIn5y96TIfS5R6IdJ6Idcd0LW8z3q
33dCPJAT+DbFy6eQn1dY3ynov0nxhSmZX38j6+2T9X2oQfGID/V/gfU/iXhq
FbedRDzrqQfwrecUr56W+rdxfXAa+59X/M809C6ol1P4Pu3HT6GeG6mfGeSr
TvGhGfTjJuppBvbqFTfOop6MR5tFPjYrLvXLfHq4v8uPeUJ7l/zwh/GL01Iv
FrL3NPqJXKJB/zxfraEfab9dQ/34/WGt2J+sBn3R3/802S8rtlC/c+g/snMO
+X2Rep6DXshnwXbW9yb2B8lVAcT3EvUegH7JhwMyH4tkPYB4yNcD6A/6UxFE
vhlPaxD5ZX76gsgX67sQhH+s/1IQ9bYrtoQwX59h/4Tgb43igyHo6Un2U0jq
/6d1iq+EpD0zuewM8m1TvOUMvsfz3Vivf0qxH+vmp9l/+fP05+55nKfe6+al
/hqp9w+wbmZ8PqxnNyj+dR7zkPpeHkb/Ml/rw7gPqR93GPVlfsfD6H+uXwjj
fuT52yPoV/ZLTQTxMf/vRuA//RvB+jn6/2NEyF+shymKefys4nVR9B/z0xaV
+3uYv2NR6JX5PR+F/8z/rSjq9TjnxQL09pjinQu479ZwfuT5UcVGfv8qzpMF
+Mv1lTHkezXnSwz6p73+GPTF/fEY9El7f8VwXzzC+RMHP6y4JY5+r+A8iqNf
Vyqex/5Onr8ah/+Viu9LYN5XcV4l4C/9+SiBetFfLSH7y1ir+HdwrZXzLIl1
5nNTEueZ764k7D+heDqJ71dz3iXhH+t3Zwr+s74iBT2x/ntT6G/q35uCPqif
n1Pwh/O+RIdeqP/7deSTeqzW0Q/U61Yd9jhP2/Xi+X5Ah/45L4dxfgXnX1Av
nndZHfG+rPgPHffVVs5bHXptVnxPGv3M+9Oahr+vKm5I4/3A968zv5/v3/1p
2Od7dSgNvfD+nk0XvzfPppFfvid+S6OfC++TNOYv3z93GbhP+J6rMpAfvv82
GiL3s+cdzncD9/8exZ0Gvs/1w3mmvSkD86jw/oT9Rr5nfjGgP8ZzPW+f8d+R
wfuUfy9UZDDPWhTbM8gP69GaQT+zfh2Z4vuxL4P6yPn2P5B16cE=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx1mj/iCXq92WtUW0WCNXdmkZ/Th7VBIxyoMKtS7LSy/UipPC
EFmpg0WsRPO0jsiAO+RAOA/uuN8/vve9zWq72tparOYWtuXaoNZcNuYfru/z
Zs+bnWziXny/3+f5fN6f9+fzPPfYm+p33VBUVPSd8U/+r368Tkv3G389uHaB
asT3+XzeTt4mDpr83+xQrNmFv/pi2+t8vltESztntysWTWKV8fMq328Wd3fO
/sjnMy2iZNrjXPz+gNh4sc3E/craRa/b7eZ+4kNhKZm+l2w+jPj4vXZE/Fdh
6yFbOwrXn+mU8e0lOz8S9cYfFvf/WMYbJB/rlvldJZd9IvZZSrZw/8CnhXqI
HplfHeNvPAY9yObjMj8X9Z0/jvd3Mv7PZL537FLcdULYevQrZKtL5K5UXHAo
XnYS+r7J/E7K+KbJvlPCqGfJbub7Od7fo7jyC7mebS/zd0OPtxR/65Z6e96m
Hr3CkDP1juKtX6KeTdSnT5gMwZyK/+xD/vuo11eyHv80K249jefvUr+vhcPh
uPSe4uJ+5NNCPfvF/YYg+xXn+xHf+9R3QBi/D7Uqdg2gXgeo9wD806bYNoj9
ydog/EYu98CPXL/LA38x3jkP9GW+Vm+hfiEv/NPIeg3Jerawnu1D2J/+mRmS
+u1gf1SdQb1fZj3PQP9tipcMy/1uJDuHpT7rtir+aRh6bGG9ffB3g+I+H+r1
Eus/gvXIO0eEYb+KF+mHEbm/5QXFD4zCv/X0xyj8VKf431HkY6VfzoI3K06e
RX2ep3/GZD9VP6e4Ywx+raWfxlCPZxXXjqM/auivcWGEE92k2OQXxusr+H2r
X8zVRU9z/Qt+Wc+ljEecwzxjvN5z0If5FAcK818dkPXvpj6NeJ6ifr0B+Jd6
5wOYF6zHtQDqw3qZJ+B/sv06dk1gfpHPT8BPXG9+AvXjfssnpR6VjM82KfMv
Zb2OTiI+5q8tvM96XJ5EfOTyIPIjNwShP7kriPW5XjwIP5Lngqg3uTRU6Afr
dXwkBH+RQyHoT74UwrwkL5uCXoxn05Ssv5/cjucOsn8K9SfPLLxPf9wWxn7k
qjDmD/20Pwy9yL4w5hH9+WtY6ldEXhKR51Ut/bkmAv/Qv84I6rFR8WAE+VSz
nyOYJxsU3xRFvcmVUez3jOI9Uczb9ez3KOb1OsU/RBHvWvZ/DP4SilfGUM+n
OQ9iOG8tik/FoOdTnA8xxPeE4qvgtsc5L+KI5zHF2+OYF6s5P+Lo30cU63HM
11WcJ3Ho97Di+xKYtw9xviTQ3ysUdyeQj5nzJoF6rVT8dwLrc7+yJPR/VHF9
Us4/H+PtSKLfmE84iXn1JOdTEvOJ+tyZQv3WcF6lMH+p7wcpxM96BFLojyrF
v6cwf1lfUxr9Rj9sSGOe0D+taZxf9NtoGvkvzrt0Yf/ckkH+nG8ig/OG86E5
g37g/PBmpL8Ocb78nEF/ch4VazhfeV7dpSHeVzgvNcTL++BmDfG+xvmp4b7G
8/CwhvnB+1KvBn15fgY16Mv7UF6Df3je/qGhv3jfuaZhvvB8vj2L84X3GXMW
/cTzvCYLP/D+Ys/ie95fDmbhX7IrC73J41ivk3we+wXJv+H9WfL8Qjy8X9yq
o/7k5Tr8y/jW6/Af72c2HfVgvi061icf1dHvzH9YR/zMX9OhL9f/RUe/M//L
OvqXfHMO84Tfl+eQH++TlhzuS6xHQw7zgvVrysGPvB934f2l0g//A9gS6j8=

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9I3GUcx4+w/lhRFEJrkBlJ2FghCcN/jKcftBzS1Mq5uFa7/chtlTfL
5dQ2NSWTmre6Vme21LvNm3O3++39vu/3e7AMriAYjUJIg4YwixgzxD9G3+d9
PG+5CSovvt/v83w+78/783meR21tTfvvsFgsP5q/8r/6ueq2pw/9/eSzBaoT
jwxebzxI3iV82xbX3las2YR8/wCfHxSjLpdrv2LRJl5a7HLu4/vtYsRY8e5V
vNAhciuV8zZ+f0w+rySX94jq6uoQ3xcnxJHaDTu5flUf4uH+Wr9YboydaVXc
MCDjq2U+C4Oi1PzgsGL7J6IpVjb4Lvf/FPu3KXYMi5/y+byd8XwmrCNGR7ti
/+cy34c+YHwj0KNDcatDmPLF+LzqlDD/9vL71VOi2wyI62tfyHjufE/x0Jfi
CXNDxtvglPl2sR4bv0J8rMdCgZm/97TU6yrft38tzHSvU4+ab7DfO8zfhfyp
x5wLejMex6j4r9I6Qn1avpXx/7Cuz5jw2Gs3ML+lMfjnfer1nTDDcVOPzjNS
zxXqJb6X8dd/qLhkXCx2lfo6qee43P++LsX5cdSjm/pOoL49ip0TWO849Z5A
fU4otk5Kv5TxuTYJf3K9Crf0p5XrDbmR30eKl92Ij9zgQT25XtgD/ckbz8r4
9nD/HvAieeEs9OpV/MI5xEv2noPf+hTfMyVMOe1k+xT8Rr4yBX3JNV6p/2P9
ise80IdsOS8OmD/kfeehL3nuNt4yLf10mOyYRvzkm9NSn6fILReE/EdOXYC/
GV/5DPxNHphBvOSlmWI96i8W6+UH/0I9S33Ij9zpgz6sx7xPzqdSsriE/FlP
zyXUl/Uv8aN/6I+tftSD3OpH/x1TPOqHH+jnfOF7+v9W4X32S1UA/XhEsS2A
fmG/OQPQi/14OQA/kVcD0I+8OYj5SLYGMZ+53skg/M3nWhB6sP9vBBEf509F
COtzfjSH0D+cL0MhxMd5lAghPs7nZXy/xvOgLCz7aZjzvSEMPTn/+8PI/y32
Uxh+elPxNbDvDfZXBM+tirdH0M+vs98i8NMuxb4Izqed7L8I9G9W/EAUfn+V
/RhFvzYpPhpFfRvZn1HEs0Px71HMq5fZr7Pol3rFz8xCr+3s31nkX6d4Euzi
8yuzqBe/vysG/bl+TUz69xr3PxRD/oxvLIb9X1H8c0yer9Wvsf/jmBfM/+k4
+q2F8yAuzL+91PN0HPlT77k45uNuxWtx9CPrtSWBfPYo3p1APqy/I4H68Hw3
EugX+udmAvcBnm+PJ4v92JKUej7H82w4iXjo71QS8dD//yQRD/utPAW/8rxq
SuE85Pk0kJLz9t+jiqMpzBOeT0sp3Cd4Pm1KY/5wftSni+fN8XTx/PenUS/O
uz/TmO8fc55lcJ8ZVPxiBn4b4HzLoJ58fzqD85nrzWcw3zgv780iHu4vsuh3
zr/2LPRh/J5s8Xn7axZ6Md8SDfXk/HtYg9+oz1YN/c55uEODv6hnqyb9ZSH3
aZjv1H9UK75PhTTkS84X1mP9/tJwfyHf0tDf5Ad19N/6/NVxvyHX6dCfbNOh
N7/v1mW8vYzPqSNe5ndRh3+ox2Ud8496/aGj36jPqo56MP/7DfiJ+2024Bfy
8wb8xfytBupN7gBvY3wnDdxHyFMG6sP9NAPzivH/ZqB/+P6N2+K5Owc/8nlF
Dvlxvdoc+pX5NeegJ/Nvy2Fer9+vcshH+u9/p84VgQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm9oW1UcLTL9MIeiFOwEa2VFqqiUCaNfKnc6nJOCbT/MCUGwzDL1Q7Nq
ZtfWba2Ny+rWtFvaLVnXrU3atF2bJU3S/E/ee4E5IQrCcEwGtoJj0CoyrJR+
GL57wj0hhbYc7nv3/n7nd86576W2jtZPH6uoqPjR/JX/1c8rFqfh/Ov1vUV0
QPRUBn4YIv5IvLfaXUmstYnG7Xe857j+mTBftxGLDtEar7YTa53Yj3jFJuxr
LQ2l/Y8L8/EviGt6xR2vNXOW+52U+z3+vcL1fXj/DPfvF/mNOstphZsHUI+d
59mF+ffUtwpbTwP38fwzwmzHelLh4UHs9w3rOSvraexROHhOeNzuncdZn1PW
v3ZM4SPDeP9r1jsi0KXCmyPgr5v1n5f87O9V2HFBtLe33+f5zS7hszYOsr6q
UeE0NupY/8oo+O1XeHZMvt8+wH4v4vzvFG64JOt3k68Kt3jT/CGft9zYb5B8
eNAP53HoMvrlPGvGRWD/ajf182Ac542Qryuo/7zCXRMSb3eRv6vQy6jC265J
fnZdIJ/AXu5fKK6znvpJrDsUdgHv4vw3J8V6S3yCfFmm0C+xNiVMeQfIX60X
/JI/B/As91svrpf05sM6z4/4sD/5q5qWeo1Tv73TwvTb2yU/TIsX7Wu/UP/7
ZoQph0+GOc8Zqc9/yOcOP/giP1Y/9Ej+bvvRzxjnPQt9XVJ4fFbuv+rm/Ocw
v8sKH56D369QD3Oyn/CEwq/Ny3pbrlEf8/AH8b/z8PNV6uU65sP309elnu5x
/5qF8vMGFuB3D/W0IP28wX6aFuEP9h9cxH7kqzIgjpoHkt+uIuY87gXQP+cn
boBfztt3Q/xXZ3maetgWRN7Qf3uCyBf69UgQ/dPPniD8Qr8XguCjS+FHQeRN
KR9CWGd+tIXwvo16DmF+Xyl8MwT9fUl9h4T816nwq0vQk5V6X4KfOxQeWhI/
FQoFrmtLcv5bRxV+iPUm7l8bhp54/sEw/MV6HWHon/0kw+CL/a+HcR75qY6g
X/LXHEEenFC4PwK9ke9IBHzQr/cjmA/zvCqK+4Lzez8Kfpl3vVHwRX8Gopg/
824lijykP59dlnr5kPrZtwx9Mn+OLYPfkj+x7mK+/Yb1Fubbjhjep37fikGP
F+nfGM6nH6di8D/9eDsGvumPJ+LIX/qpIY750H+fx6HPKfo9Dn36FP45Dn/N
0P8JzMev8O4E/EV8OCH5dhKPJdAP8a0E8oP7bSUwj2nmRRL+5PkfF7GX+ZHE
86zXSCLfJpknSeQp+3s5hXrZ/6EU+CY/gymZrwb5S6cwf+bJ3yncR8zDmjTq
4Xxa05LPN5inA2nwybxZTmN/5vGDNPRIPTyfgV6Z500ZzIf31YlM+fdMMIN5
U49/ZOBX5lNlFn6int/N4n2ud2WhR+p7Pgs9lfIui+8Bnv9UDnyyPpGD/6nv
zhzOZ3++HPTN/n/Nob/Sfa2BX+r5BQ15TX73aOCL/H+gQU/jzE8NfuM8+/C+
jfeHR8N8+HxYg565X0FDfTz/Tw36pf8eaeiX/nxOL/9eqdfLvzcPYH2L82jT
oQfy3aNjXswbl45+mE+LOu575tlNHfXz+/F3HfNi/m3quB/5/DMG6jvFPDeQ
x7yP3jHk90w1z7cU14ltBu4L1jNkgC/u7zfQD+vRivvxfrqL5zPM84cG8pTr
T+bxPvO9No95EzfmMW/m/cE89MjzOvLl96cjz+/t/wGsCSJz
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1oW1UYx4NUP9ShKAHrwFqxSBWVYmH0S+SowzkpuPWDTgiCZZaqHxoH
HXWbbist2+rWtFvaLVnWtU3apG/Zzft7cu8NrBWiIAyLMnAVHINWkWGl7MMw
5x/Ov8RCW37cc5+3//M8577Q1dv52SMWi+X7yq/8r366u7vvXvnztbeqtF9I
vkz+WPxQLpcnFOtdYvNganKczz8XX9nqP3IpFr0itG/9wUWePyL8DtvwmOI7
fUL+G+X7X4vnhzZ+GlHcdALnnbR3UlhD+z7l+dbT8vxB2tMHwPR3YBDnL9Hf
kOhMNQ4xPscZsX7MGtqJ/xzyZX6jw8JWv/Yi69F0Xj7vdivWLoi2traoh/E5
kY9Xcc8o6nGN8Y7B36Ti7TEZz6NTjP8i4p1WfPaSeNnuNGeYj0vWu9GvuGFc
+js1y/zGEf+c4uCEOF4xGGS+l4XT3ArOK26/Iv5tsT+5yPzdon7N51hSvOqW
8a8tsx4eqecxnj90FfHTfpNX2nMyvnte8V4lYeajXRMet9vNevRPIp+d+l1H
P7H+dVPoH3LPFOpPPcpT6Efq0Tot82u5qtg1jXipx/a0qKSXp3/7jKiUd4t6
6DOIh3o0+6S+bTt6+KR+r1OPTZ/M51kf9fFL/dbJMX9tPRpmYZ96nZhFf+/o
N4t8yHvnpB5/k4NzotK+G+RdAfQH2RGQ+fSRbwWgL7k9CH+MxxtE/ozXMo9+
IR+el/q5mO/qPOaT9Xh1AfqTRxdgj/zPAt6nvUOLtfZzi6gv6920hHpSn8El
UdpqsVO/e0voX+rbsYz+YP9oyzhPtoakvxX2R39I6m8j3w6hfuwncQP7g+y/
gXpz/9Vp6F/yHk3q1UHu0dDvZI9Wu0/KGvyRH2rYH+TWMPIjd4Vrn7vCte/f
DKPfyNth6E3/r0Tk+bfJ9gj2H3kkAj3JegTzw/zvV8+Tm6PoR/KHUewr1vNs
VNb/NjkTrdVjM4p6kBtj6FfqeSAm+7Oeeg/EUA9yLIb+YX/cjUEfckMc/cZ5
fj8Ova9z3uI4Tw7FoSf7704c9tm/Tydq+3lvQt4HPs7D0QT0Zz8HE6gP+dcE
4uG87Upif3Ae30z+b36T8M/9PQNeId9KYl4Cih9LwT65PYX6k7/Acyv3szeF
98k/pkSl3dvJljT2E/mNNOrD++JwGnpz/0+kkQ/vh9U06hVS/CCN/DTuiwz2
T0TxJxncjzHujwzu24RiM4N6JrlPMtjfacUvZWEvy/2Shb284uEs7BW5b7Kw
pyv+C+wwuH9yuJ/5vDOHfPj+YA7zRE7kUP8C91MO9ul/dx77hNyRl/VO5RR/
m0d8ZC0Pe8zn9zzmgWwtiMrfUxnF7xYQH+vRX0A+5IUC+j3FfVfA/Ul+ooj9
wfqKIuYtrvhIEfFHuQ+LyI96/lzEfqDedTr6jd8Pz+m4z9k/e8CN7M8PdPQX
56NHR76cr9M66sP59Ojwz3mM6ugHzltZr71P/9DRD/T3sGqP8TxjYL7IrQb8
8/x+A3ozvi4D+4r+jxvYB9w3LgP3N/fZsoH6c1/erNrnvv7NQD34fbptYD75
ffuUCf8XuM9N7Idhxe+Y2D9nuN9N9MOQ4j6cX+HzERN6nFMcwPm+77j/q/bp
7xcT9eP3+H0T98t5xY+X0M+011zCefqzlbDvB3lflGQ9vhxQ3FtC/53k/YHn
G99U+D+Fjy8w
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVm1om1UYDTL9MYeiBPwAY8UhVaYMC6N/Ktc5nJOCtj/mhCBYplT/NA4q
tRu6jQZrUdPNrC5ZrW2TNmnapvn+/njzRrdOs8m0rk6jttPNSjudo511wvC9
p9wjWmjL4b3vvc9zznnOfe9raWt+6QaTyXTS+JX/1c9SU8qydOnhx9fQDnGv
ffHMJeLnhfFn/+8Kay1ivtP8yB98/oowB7fPX1FYtImn5judy1y/R+w1FlxV
eK5dGMuv/cn335D7Bf9SuGaf3O/Fv7nfW8K+2JQi3nxAOPQV/yr3Pyi8toae
FYWf7RLllVor65mzy/W1rN/2tkhZ7IuLPP8d0bB+1rOgcG8P3r/Aet6V+68/
r3DoPVFXVxf9gfU5sP47hVt7JV+mb1jvIWHwOzCj8OohMeuxNZxh/YfFa0YB
pxTu/kAY5dg+Yz9O0Zyy3HhC4TuPCLfL5SqzvyPQQ1PY3yf3z+fY74fiVKXS
mFa4/qistxpn/y7xsvETUXjaJawGYUHy4Zb8108pvOsYzg+Rn37oGVZ4oR/6
RcnXR6gnpnDHgOTDkiB/H8NfSYXXDaK+FPkcxPkZhSuD8FeW/A5BT/brHBIP
Wh1bC+R7CPUWFbYOS34vky9tGOt1hTd6sD/57fbA358ovOQB38epj1f230l9
Yl65nz5NvUagH/XcNwI9Pqd+I/BvReFto+JqrdXB5/5R7M/9Nvig16fU1yfn
tYn1z/jAF/ut94Nv8tPvRz30g2kM/NEPu8cw///6YQx+p/6bAuBzgv4IoL4x
hZcD0H+UfhlHPSMK58ahL5/XTMh67H6FuyYwrwH6aQL1jCvcOInzJumvSTm/
97M+c1DyW6E/O4LSz+3spxrEevpRTGF/9u+d+p8fQ9CbfG0JoX76sTUEvciv
O4T5pv8qIfiNelwPIW9K9G9Yzv9z9FtLGHlDfZ1hzA/9djyMfuiH1TD4or8e
isCv9I81Ar2YL+9H4Jcv6P8IzmMeXYnAv19yHqLgm/m1Myr9UHeW8xGFf2YV
zkSRz+c4L1H4lfloicGP33N+YuCTeXowhnrnOE8x8MP8vRiT82n+mfMVh37M
66fj0OMXzlsc8/arwkE8v5X5PxeXepuIb09Ab67floCfud/rCdTH8/wJ5PdP
Cn+L53ex3g1J9M9+HktCT/ZrS2I9+RhOgm/yNYP3L5LPm1K4b3i/1ANXqcer
KdT7Nec9Bf99pfDpFPKG+prS6Jf6P5rGfvTH7jTy8LTCfWnoQT9NpzFPzK9r
adwf9OOmDPg5qfALmf/mY28G9zvzU88gb+j35Qz44jw8kMV8M493ZcEP56cn
C32Jc1nkD/Pxtyz2I67JwS/crzkHfnl+Vw7zxXoTOdx37GchJ79vTnDe7s5j
PshPYx55wOdv5nHf8P1QHvWx//N5nMd+zQXMJ/t5soB+eX91FMAf8yZQQJ4y
j6oFnMe8uqWI+plvooh+ifcUMU+8n71FvE98tgh9mJfrNPiX+B5NGH/3M1+3
aPATvwee0cAPcasGvzOfD2jQh98Tbg1+Yp5HNfiNuKKhPub/BQ3+5PfL9bV6
eF/dUcI88H7ZXAL/vF92lOAfPm8pwb+8n/aWMD8+5nMJ88P7bLIEf3uZ18Bb
PQr/WAJ/Q8zvtfMGFb5Nhx4DzHMdedOv8BM69ncz33XUd1Thdrxf7WPerz13
KuzT4ZfDzH8d/u9V+JyOfHbwPtDBF5/fXIbf+f7GMr5vuX9DGd+vPH8n1m9n
fW1Yb2H93Vh/+ZiB/wFgn06H
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlW1Mm1UYhuvc9gMXFw2JaCJiXAwu05CRmP7BHHVxzpAI/NgwISaSSab7
QV2CmRtRt0BEotIpm4I4+SijY1Ba2tIP2vK+b83GlE2nONxEB9MhCsM5QRvU
xZ4bnzupJKS5ct5zzvNxP/e5t7K67PlVNpvtdPpf/8pfYWGhf+nqg4+u0DY1
0eUo+pP8jNqf7TmVEjYq1ZmxseJlrr+g7qmfO/eXsKpWLxVl7fiH3+9R86Xh
ozeEp2rU9L5sD9n2CvaT82qVjoesXlNPpjfwvIIDiIfrxkGF34X/uKROhXPr
d5On6lVVVdUM2fEG1m8Str2pKpqsJbKzUbkcRY2rhPPe0vHn3izsfVvVz5WG
yaoJ+a4W3uVUWRNd18gFh1RZ+sI1wqlDqrWl5c61wsa7qA+54T3kx+9LmpVn
6/Q+3pdzWNenkPFOHUZ+rIf7CM77W9jxPuJjv+wfoJ7sp60F9Wf/R1v0evPv
ws5WlVzKr/hNuPxDlS5X/q/sV5uOb3leeLYN5/0i7P0I/Z4V3ntU598yw/5+
jHr/KLy6HfW6LLyrHetTwmPtyO976qFDPZBu4KRwcwf6eVE41aH7Zb8gXNGp
/sivaJqgfjqhn/PCG7pw37hwQ5eO/6GvhOe7cP454RKXrs/kF8IBl9bX3OfC
Od3QD7m2G/md5Tx0ox/kLcf0fI2dYT+PIT/yuh6VnS442dGD+Lh/vEcVpQVI
trsxz7y/zY34ybbj6Bfj33kc+mN+oyvrXwpv6sV+1sPZCz18LbzYi/liPctP
6PvjrHfsBPTPfuT16fq/zn7V9WF+vqWe+rS+q74TLu5H/uy/tx/r1Ee2B/un
qTcP5ucH4UmP7v/6K9TfAPREPboGoI+fqEcv8qF+H/ainj9Tn16cR723evW8
TZDHvND7nPANrO/gvBT4tN6yrgpX+uAv5Gafzve5BeGTPl0vG+cv5cP55I2D
0MM16n0Q55HfAds5z8Yg/JZ8fVDr577rnAc/6kHe7kd9yQ1+rZet9IuoP9M/
5v2YD3JuAHpf5PwEsJ98MKDPd5ADAdxPngmgH+ScIPTDeJ4Koh7MtzaI/Fk/
TxD9Yf2ngpg38u1DuI/fbxnCe8fzXsb6et7nHkJ/mN/FIfSHvC6k56WG3z8S
wvc8zxGCHnhfZwh+y3jGQ6gH9bQ2jPyoR3sY+VC/L4bxPlDfbWH4AfV/Noz+
019tEfST87M5gnpcoh+sMOftSATzz3kcjaB/5OVIph9viqJf5GejuJ/sjMI/
yFZU73+MvBjF/JLvH4Yfkcv/x43D2E//iA3r8930m4Vh7b9rvqH/xPT+UvpV
WQz6pf/XxZA//W8ohveOfjkbg5/RT++Koz/05+I4/Inrr8aRP/3VG8f8008v
x9FP3p+dQPyM74kE6sH49yagH3JvAv3n95MJ5Mvzbh1BPrxfjeC9Y3x7RlA/
xu8awXv2qfD5EczHKP3RgN+cFL7bgN8n6ZcG9GEKP23g/gT908B9MeEDBuY1
Qj814EchYb+B9zNAfzXwHviErxjIf4B+a2Ce+oXvMNHvPvqviXjJ20zk56Ef
m9jvFd5vQq+D9GcT8+AX7jeh/yD92oSeGP8lE/PP/FIm6jcsfJsFfbEeG63M
ej1uQV8G/d3CfFnCNRb09Qn93kL/2Z8eC/o6Rf+34A+nhS9Y8KvP+B5YmXq4
JQn/pl42JFF/zkNREu8J52V7Ev2i/qqTmfPWkER/tX7/BV/SUvQ=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1Mm1UYhnGyTRmObGmULYoYicFlGqLJwh/MURfnDImMHxOTxmRECdMf
1CUYZETZAhGJDqZsCuLkcxQGXUtLaUsLb9tkYtJNpzjcRAfTIQrDOWEiKtpz
N8/dYBM+rrznPef5uJ+7577CkvyX1iQkJHwW/dF/V33mH3o89s9u1WHJqf33
mvDzaqrc9DDZKFSetOrZFT7fr6pn93jIqkTlJI23k40DKryYOUGeLNVsjp/3
unp6qrzhFuH0CpXvSVvL89Sb6qDJtoucdUjN7fGciMdzWEV/V3K/vCr1aPSz
RniyWhUVFU3fKmx5C++v5flvq3ujCawXrq/V+SfdznjeUQ+a60JJwvZ3VRRL
k4VVHeqzUbi4HueRs47iPK5fOqpezUl6jvsZ76mbmeaU24Rr3ldNjY1bGE9e
A/Ijpx7T74+TJ48hXr5vPa7PSyNbPli9f/aH6mwkEuH7CY2r8x9tRP/WsR5N
up5O1qvgI92f6kTWpxnnsb4zzcq2a6qc/bR/rOpCi1b2q+wE9v+H/f0E9fxL
OLFFP7//T+HiFujrpnCkBfVeoB5adX51vwk3tKqoXKbmhZdaEd+csLkN+f5M
/bTh/GnhjHbo8QfhmnbEPyk81456fCec14H4Lgm7YjwunNqJ9WPCFZ06ftt5
zkMn9HFOeOdJ9PessPUk5uFz4eQuNd5uyflC2NKF+LnfWBfi/VI424r9vhJu
tmK/rzm/3ajnBeEXu6FPxj/ajX5+I7y9R+uz8aJwfQ/yY/4LPdDXt8IFp9CP
CWH/KRVt/3XWL71X77/8vXBVr0JZhGd6Ee+UcG4fnl8RtvfhfbLJhv3ZvzIb
zv9ReMKG+K5Sf6fRD/a/47TuX/YM9WjXejlPveywa/97ZZb6tCO+a8JNduib
+ovYtX88cV14xY54qNcsh86n8nfhQgfmf5F6dqzW/xkH9LtEfTvgN5yXbf3o
F+fJ3I/4OG9H+jEvcX/uh3/QP2/0Ix7Ob4YT8dJP9zoRH+e/xon54nOfE/PL
/eacWo+ZPC/NBX/+m/Pjgp6XhQ+74PfMz+WCHpn/tAv15fynDkDv5Gf+xxUD
0CvZNgD/Ik8O6Pz2kTe7ER95p1vP1yL78xqeO8lWN/REvuRGffl+8iD85Ibw
Y4OoF9kyiPioh7ZB9IM8Nqj1bKF+1nl0fT79lfPtgb+TX/boeHKpv2YP9EB9
nvPAb+iHCV7kQz0/4tX9CPxCP/BCf9T/cS/qy/kY9eK+8JPwshf15Dxt96H/
nLcXfNAT57Peh/pwfkM+1J/zvuBDfS8LPzAEPdAvCoagF/pJLZ6Pk/1DKvq7
kuvnh6A37pfuR/3oN/l++Ae5yo94GY/bj3ljvDP+1X6zNYD+Md/cAPpH/3kj
AP3F/SsAvfC8KzFmvKZhrKd/PjUMv6fflg2j3+SeYeiL6yeGcV9jPTaOoL/M
X43gPOZ3YAT9Yz4dI+gH87kwAj9hvxMN1Jt6uMeAPqifHQb0R709a8C/qM9i
A35BfR8yMG/Uf5MBvXO+nAbmhf4YMVDfP4SvGvBb+uGKofVloh/eFUQ96D9Z
QdSD/rQ7iHrQvwqDut9F9LeDQXw/0P8asD6F96W+IPTC+9QZrPfwPnk5iHnZ
wPsg1u+7Q3hTCPVOEd4Wgp42CT8Zwn16s7AZ650m4VKsr71T+AjWm1OFu2L7
b+X9M7b/3cIXQ4h/C78PQgplE94QRj15XkYY8834csKoD++/e8PoB/MtCUOv
8ftujPX98j834ii/
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYx8nQCknSKNESMcmQ0EiL6Me5T+k0G1vKH0bbrS1mzOoPyI1G
yCodLGIlWGhBZPyUH8J53B3HHdwd3/veZrRdbW0uVmML2iIKNCMwoqLu86bn
3a7bGHvt+/l+Ps/zft7P8/luyi/MfWFZTEzMZ5E//V9+W63VZsKVbY8v0X71
iiXumf/4WRV5XLxK2MhX0wc9yTfz+Ysq0bbv+ZXCqlB9Hg7n3MT1R5UnuWJq
hfBYsdpYMXUwlu+/pkJzaaPXCaeU4fzrud8bev2XXJ95HPtzP+OE0vHfIHyg
XEW2z+b5YxVqvDTRFidc9Bbij+f5b6tradZq5lNTpWz7xheYb8o7yO8WYfu7
+vzwasZXrarNuTTykRq9fpz6ZZ5S9XV1dXw+fwrx38r431O5nuTltwlXvq/j
99zOfGpV3EhLUZJw0mlliRvZvJ75ndZ6jdwh3HFGtRZZqjYw3w9U5HXLRuHs
D/V+V1OYf53er+Uu4eE65JNKPep1fax3C+d9hP23UJ8GxHuP8GQD6plGvT6G
nluFS85qPdbdS/0+0fXZniEc24h4t1HPRnUsIuh24XAj9LuP+jaBM4Vrm7Qf
nrifejepnZHfDmFrM+q/k/o3K/3vAeHUFsRPrmyBfx4Unm7R+ZRmsT6tOO8h
YVcr8iUnteH9bOGyNuj5MOvXhvXkPefUk+OltY+wnudQ70eF49t1fTrIRe14
/pjwpXa8T87uwP7khg70n4X170T9yYc7VUFBwQR5uBP67BLO6EK/cb+aLswH
xjPbhfoy/rzz8Afz951HPalPSjf6ifqWd+M59Z/sxvusX04P6sf62ntQD/oh
0YZ5Qf+U2LCe/hq1oZ/T6b8L+vlZ+rX1AvqJ/o61a7/H0f9ZdvhpM/1pRz03
CdfbEQ/7LWxH/7MfF+3wA/s1sxd6rhPO78X5a+nnXtSD8+FiL/qX82O+F/Xl
fEl3oF6cV1YH5gvn2UkH8uH8Mxx6/iVwPs44tH8Sb2Q/OFFPzttDTuTPeVzp
1PP95eXCA059/ptcP+2E3pzPyS6cz/0PuHR+BeQTLqwnu1zIj+9PuDAvyEl9
yI/nPdWHec74yvowj5cJ2/pwPu+bsT7k+/flf3mNG8//Et7jht4Lwq+64a95
4Q631sN5TfgbN86fE47vR7/9JryrH+f9LlzUj3pz/+Z++OVP4Uv98Nei8AoP
/BzD/vYgP+bzkgfzgfdngye6Pl94ovWL8UbXZ4cX/qGeh73oD+p5xov7lfsP
e9G/PH9haT/GlzEA/Rj/cwPoD+pbA174Q9hcek49Zgf0fJmj3lsGkQ/1zBuE
ftS7ahD3x6ywbxB6zghfGUQ8V4VTfJjfPwvn+nC/XRYu9+l59OmUsNsHfX4S
nvRBz0nh9X58v0wI5/jRL+TX/dDnB2G7H/Hx/e/w/siPwokB1Jvn7w0g/2nh
kgDmB+PtCqBfmc9oAHoy31VDuN9+EVZDmLe/Ch8dgp+pX+sQvgfo76+G4Afq
H2tE+3mDAf+zflngBPr5aayvZf2PGIiX/XfcwP70T72B89m/TgP3Af0XNhA/
/f29Af3o30UDenGerA2ifpx3mUHoz+/X/UHUi9+D+UH4m/PzWBDzivO1Noj5
s0a4J4j7lPP5YhDxcX5/i/cn+H03H4Tf+H232oSf+H2XbkZ/3+02UU/eJ1YT
9z/vm2JT+99PPmlif3K7ifjJhgn/3Cn8tQl/cP+Z/61fGdL5VpBTQ6gH2RJC
P5MPhZA/vzcLQ9CHXBmCP/T9+Q+fZOif
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVn9olGUcP2JFnKJpV07Lc7Zlc6ktrbV+nD3qyIyBbn/YgiNomKz6Y0tY
rDlKZSMb5c46rVvL3O7mbnM7b7tf7/1+7z0wgysIolEIbUEycEiIxvAP6X0+
4/nI7UDl4/u8z/P9fj6f7+d5Nza3Nr57n8Vi+cn8I/9VP4d1unzLja27FtE+
8XOhUKgifkto9p7rmxXWm0Vg72wnseU94ewz2olFq9hs/se99UfEhw7rm9xv
pl3MN2j2p/n+x/K8ej4v65LnfVDJ/T7FeZsUrj4uzL+PVXD/Ezj/CYUPdIvD
5q+M5/Vgf7vCbZ+J2U7btsd5/ueiUbPfv05hV6+sd3oN6/lC1nvuEYWDX2L/
h1lfH/YjbnGJ/yqdfTbWe1pYp73/8v2F06iH++tfCfM4b6nCJ7+W/d5Zy37c
WP+YwqVnUA/rnzkDfdYr7D8rdpi/Dez3G/BDPmq/FT3XG7SN7N+D+sjfFY/Y
YC4gv65+ybeF/Dd9J/sNPEV+BkT+dqWTes8NgE/qG/we6+mvjnOodyv5+wH+
2KZwyXnJ7zXilvOi3+PxPKNwAc8PV5PfQXHUFtj7rMLuQem/3dvJ9yD426Gw
cwj+eo78D4nXZzvdzytc4ZX7/VhDPbzop1bheS/2e5H6+KDHSwqHfZLv2y9T
r2Hw6VC4axj876R+w1L/cqFw3QX4Zxf1vIDz9yi8fATzUEd9R9AP8W+Lz7m+
1i/1O7Zb4QE//MD9LaPQj+cfGoV/XqUfRlEf690yhn6IXWPSP23Et8ZkvT3E
TRfRD3FqCS4bR33E3ePQl3huXJjbO4jrJ4SvzWElDk4gr8ivLYD9iDsCwpSj
kvhqAPn0Cv13Cf0Q+y5h/qlfSRDPiWuCsp409W4JIs+I+4Pgl/4oBHEe/XM3
KCAL/Tsp/VD7gsLNk+if/nNPyn576c/Lk8gL+ncB72v0d9UUzqP/nYuY83Fq
CvVzfvQp9Mf5ujkl9VnJ+awIgQ/m88EQzmM+nwxhvpkPiRDmh/kxH8J+5Qrb
w5g35s+BcHFenwhj3plf4XBxnl1bgksj2I/4jQjmn/t1RXA+nwciqI95OROB
X5inq6PQg3lbF0VeMY8/imLemdf+KPhjnv8Zxbw+ynmNgS/eBztjxfdHW0z2
u3a1wkMx1PcQ5zmG+Vqp8AMa/LaC861h/XKF39ewfhnnXcP+VoV/0aD/g5z/
OPKKeHsc9XL9oTj44f5n48hbnn8ljnlkvXfiko9fVzEvEtCT/b6dEObr7/A+
dCWQL+TPSIBv8nsrIfUO8X7elES+Ua+mJPTm/d6bRD3UP5WEf+m3G0noRz+W
paDHkwo3pnCf837rTuE+pt+jKcwT52Euhfnk/bYuXXyf1aehF+ftkzT64zwG
0+iP8/t3Gnxz3m0Z8M18eC0j/W5jvnRkJJ+zzJ+xjMw7P/PsagZ5xLxckQVf
zHuRxXzwfjiShV7Eviz24/rfs8X3V4kOvXneeh1+Yj01OvpnvfuxvoH9tOi4
D9jvcR16kY9+HXowz0I65p18FnTMG/PrHx16ML/u6vA/9VmTg/+pX3Wu+Pt1
H547qHdzDu/TD0dz8Bfzzp0Df/TPRA5+Zv5dzqFf+u2vHOrn99ZCDt879Ocq
A+uJqwzcb/TzHgPzQ+w00D9x+5L1p4zi7+MRA/5nHuqL5xH/YcC/xDcN+JN4
WR78sr6KPL4f2J8jj3wmHwex3kr+WvPw6737Iw8/ST3+Bzh3xpI=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVn9o1GUcPmL2xxKjGPQDnLMtm2vq6XLO8uxVl3O6cps6V56BQ8esP3YJ
C1OpKY7WKDfrtG4t29zpbnM77/fvH9/7HuiEKwhEMQZtQjJQJCRj+Id07yPv
E5cw5OF9v+/7fJ7P83neW9zS3njgKYPBcC37J/9X/xZ13W1Ydn/ZhieoVvyS
yWSWE78vjhY4a4wKay0SX13J9YNyfx2xaBem/JvDK7j/kAgVdt3l+dMdcr24
nN9/JrbMHCkgLjqGde4XX+B88jEeF43ZA/87/wT4kl/9SXGvIVS4ivd1CWfN
zJEKhS1fivTD0qk3eP9XYqm5d2Olwn09IkvHuYZ8vhb9NttLaxV2fSPsFlPP
m+TXK89/9JbCbX0iW77FRL6nRWtr6531Cs+dlvebBfl/K7LyzhB3fyf1+pj7
663yvvx1Cr94BvqTz/QZ6E2+jrOiV3/oWM16v0e9rL/qByHpUR+DDevUb9Im
KioqvNS3rz/XD80/yvNLiYsGwIf9mh2Q+p8jdv0EPYkPnxOfmPJ383vxM/Tj
fXmD+J5+ahsEX/LPDMrvb7J/xiHoxf5ZhwTKpN5D4p9Scy/1Mp+H39gvDdhK
fUuG5f5nqX/3sDyv822F7w3n9qveLrLjU7VRYZ8dftvEfl1Af6oVPvYEv8P+
XRBy/jYrXH0R9RA7LgpzVnDunz8CvxJbRnLXrwN31LDfDqxvUXjAAX5b2f9R
OU/z6hTeP4r6iCdH4Q/i8jF5v07cNybnw0b89xj8Tdx8CXoTxy7BL9von3HM
C/HJccwv8ew49pNv3QTqI3ZNwI/EBU7wr6XfnNCbeMoJfYnFZfSP2H4Z/SfO
c+XqV+nC+cRtLtm/34j7/4czLswj+/nYBf/TD0Y39Kd/WtyYF/rN6oY/mCdX
3JgX5s+cG/NCv5d5kNecB7NH6vsX5+eUB/3ifGme3Hl/4IFenM8SL/KO89vk
hX7M624v7ntd4YgX/SvjvHhxf6nChT745zXOjw/nL1H4hA/1vsp58iF/SxS+
48P8v8L58qOexQpv9UPfIs6bX+q5nOtOP/jy+2k/3pNihZ8PoL+8rzoAPuT3
aQB5SP6OAO5bqvDvAdTL+ucHUR/1Wh8EH+prCaIe6n8+CD7sz/Ug/Mn+PR3C
e8r8qwqhX+z3RyHJfx/9MBBCP+iXX0OYZ+afIQz96K9VYcwv/bc/jO83KHw2
DH3o18kw/E0/Pwpjnun38gj4cx4+jAi0ifkRyc0DPYK8fpd5EgGf7QovieL3
QQPzJQq9GxXuicr3Ir6TeROF/k0K34+iX83MnxjO+0DhxhjO28M8iuH92atw
IIb6uT6L/RZ+/3Ic7z3Pr4sjr3cr/Hkc780u5lccebFD4dtx6MN6ChLIt3qF
Nydw3nvMtwTqYb6OJeT9rdR3KoG8pP4LkvL8TvZHJKEP+3coCX/w/bIn0V++
LzeSqJfvS54GfZiXCzX8XmE/KzX4m/y2a/Ar+bdp4Mf6jmuoj/X3a8hj9tOr
IX+IM1quXn9q0Jd+eazBv/TTCynkJfUxppAv1Kc2Bf+x3pYUzqceR1O4n++/
NYU84PxMpNAvztcVfN/JefwjhX7z99kc+BRyvp/TMb/8PVamQy/m7yaszzBf
zDreV+Zrh458Y36e0vHeM+9GcF4x803TwYf7b+ngy3x7oCOvmG/PpOEP3l+S
hl7MN1MafmC+NaUxT8y39jTqYb51p+FfWf+/jwvfig==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9o1HUYx0es/lhRFINW0Fo0YonJUFuLOvuYQ52tvK2a0y6rS+3Uaqew
sDlKZUdrlJt1WjeXbbubu83tvN3v3/e970E/4AoCaRRCW5AIGyLiYviHdJ/3
8Xkf14HKi+/383ye5/28n+frY+bOtr13lJWV/Zz/I/9Vv4XuyjXPXHtqY4Ga
xaO2xd+eJu8U+/K/9Yo1s6j0bFlYy+f7xS+5XMs6xaIT54vvHxbZ5TpTg+L5
LhGpti0W7/tY5MN1P6u4pke4rIaK5xjvU7HUGjn3vOL648K22Nq4gfFP4L4X
FBt7ZfyDG3mfDfE2KbZ+JvL1epp4/+fIf7PiwX5RMee8voX5fCG2LnTbmxV7
vxRzTqvhJeY3gPrIlkHE38p8T4m2SPWdjL9yCvkxH+0r5M98+74WR/MC87nR
Lu9LMt+q02Jd/sd486fFgL7sZr7uM1KvauZr/Qb5b1Pc+C30aGH9DpH/69jL
in9yoP5XqMeQjF9nVNxxFveTa4ZL+epw6fve7+T9leQj52S/b22nft+jfnL5
iDDkEyBbRqAXOTeC+OT6UfiR+dpHZX395JVR2Y81ZNOYeNI0oLNebUze30qu
dcp+XqY+fU5xyFCxg7zklH7Jsd9GV6kfAi70g3pXjaN+cs+4+LfONMD+zI/j
PLnpPOaN7D6PfpDvmRBDDoeD8awTpfdfmijNr9GN58x/2I37i/2flH77kbxn
Es+LfpiEn6j36in4m/0cnEL8NsU3p9DPV+mXC+jf64oTF6TfynbQP9Oop0Nx
7zTmexf9NI14byhumZF6WN+kv2bw3KS40iP96Of5Ix7Uw/iXPdC3nf67iPte
U+y6iPxYT7kX+rD+Bq+cZxv1sXiln16k3kNe+Jvzn/PCT+TbXvSzuB9mZX73
sb/mWeRDts9CP/IPs5gP8gqeL5JX+XCe/jD5Suf/pA/3kzVf6f664Sv1T60f
+4j+aPfjeXE+/JgP6hHzS32vkJf82O+cv+qA7PdD1NMYwH4jnwigXvorUHi/
VfGVAO4nVwUx7+zXtiDypf96gti/7K8niPPk+SD0oT8fCEEP+qMphH1Dv34U
Qn/J7hD8QX/9GUK8nZzXMPxGP24IY1/Sz9Yw/Eb/joURj3wpjPro97si+F7t
5nxHsM/fUnwgAj3JwxHo+bbiXyPw2zuc/yj8RF4bRX5m7oMo5p18Jop98C73
QxT9Jd+KYr+SV8dEHpfJu2O4fw/3x/9Yj8GffP9mDPNMfiIOv5E74pgv5tcf
xz4iJ+JS32Os71oc/5+gHjUJMPVqS6Ae6tubgJ7UP5TAPuH7VxPwC+M/nMT3
hvm1JOEX1vdJEv7bx/2VxP0WxX8n0a8D3Gcp1PO+4s0p6PUh91sK379OxVMp
6HWI+y6F/WhVfG8aevG8SEs95xj/cBr+4/2uNOIxv9/T8DfzL9eQL+t7RMP+
of4NmtS/jHpv10r1tGjSH12ch+Oa9OPjnJ8hDXpxHv0a8ue85jR8bzmP/xTi
8fxtDfuA8R/M4HvM++sz0I/9bs7A78zXnIF/WM/RDOaP9dozmAfqMZPBPn6P
+zoj9YjsV/xXBvN8kPs7Az9/oPh+HfWwP6t09IfPN+nwE/tl0uEPxuvS8X1k
v07q+L7uVTyhIx/WoxXi089/4Px17p8bOvrH/XV3FvuGetdmoSf3qaHA3M/t
WfiV+7+zcJ7fl74s4svv4X/tR/yp
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9o1GUcx49Y/WFSFIN+QMtIYknJaCD75+xRl3O20q2Yqy5rl17TVTtX
s7mZzuWlDnWb3qZ3Ltt2N3eb23m/f9/te98DW3AFgSTFIBckgiIhGeIf0j3v
43nDBtt48X2+n+fzeX9+fV8wtzXsfMhgMPxU+JX/1U9l4cd4+9V1RaoV/frd
8rXk94TT4XjmdcWaWch/gs93CYvFcp0s2kR3qffHdTzfLozLrrrWK77WIbw1
i10b+P4+eb6mWvGK/WLTYlfpG7R3UOwpGCBXHJL+ODbSfq943nazvkbx1sOi
IVb28CbeZxMFc16y9Yi0t62W9x8TpkLA5IE+8V+5qX8z/TkubtXHyt5U7Dsh
9fGQRb+0v7pOccsAnpMrBvH+W4rvDcI+WTuF+8lHTyOetxmPHfbITw/hPPna
kLjqshq3KPYMy+cdZOsZxE+uOgs9yQaHzMd98rwD+d5KPZyikJ5mctM5vF9P
fUbEy6b+9e8ovjEiCuUUfJd6fY/4GxV3nkf826jfD4inSXHJKO57n3qOop4+
UJwfhd4fUt8xWS/27YrtY7D3EfUeQ76bFZvGRUHemJn6j6Pedihe6RKFcrXu
ZD5cuN+i+JYL8bQwP27ovUtxyI3zu5mvCej5meL9E7JfLJ8zfxPQ6wvF1ReQ
jzbm8wL03aN4+aT07x8r8zuJeiFfmRS5u+ULfL/KA33IIx5R+NtDNkyhn8g7
ppa+Pz+11P4r09Ifnf4OTOM84/t3Gv4x/qaL8j4D9UldRH9+yvqZEW6rcRn1
PjyD55+wnmagx8eK62ZFrMx2k/n2zcp6epz5LvVCT57v9CL/zPeCF/ZoX1yS
+TzP+92XMI/oX4kP9zHfa3zQk/G1+JAfxu8snmd+876l+j/wLc1nhR96tSs2
++HPV6xnP/Tfq/iyH3p2sr79iHef4lUB9E836z2A+v5G8ckA6vMA6z+Aedyj
+E5A2qvsZT8EMd+/VdwYhH829kcQ/h1RnAgin8fYL0HUS5/ishDuO87+CeG+
k4p7Q9Cvn/0UwvwbVHw9hPhOs7/C6MchxZvDmE/D7Lcw9D+r2BuGv072Xxj1
M6L4yYjUt4dcHZH1aCPvjcB/sici/W0l/xGBffLyKPYpeW0U8+kc+zeKeUQe
j2L+kK9EER/5kRj0pP9VMdQ3eXdM6rPoYL+Dm8m/xKR/v1IPQxz7g/xaHHqd
4TyII//UcziOeMjzcdin/vfjMv99ds6LBPLHfG1PyPvSpzg/EoiH+dWLzwc4
TxLYX6yHl5LYH6yXpiTm6QnFfUnsB9ZXKol6Yv3dTqJ+WZ8rUuj3o4obUtDv
O86jFPLBeo+kkD/2w40U8s9+eTaNech+qktD34OKD6ShL/vRl8Z97Ne/0vJ7
6cUuzrOMtGdiv2/MQF/Og84M9OG8mM5AT86ThQzq90vFj82hXjo4/+aQz68V
t89hPvI+9xzsc778Bl5NLtEwf3j+OQ3xktdoqDfa36IhX+QWDfcxnkMa9CE7
Yb+SHCzao/95Dfkh/61h/pAfaPj+pD5PZeEfuSILe9SnNot6JpuzqB/q2Q1u
Jduz6A/O89ks9CVfxn1p7s8/s/geIN/D+xbuhyd05IO8Shc/5/N5nt+gIz7u
X1ORuX86itzKea9DX+7fSR3xcp9pOvY/993vuK+O3zt3dMTH76NHc9Cb+3Nl
Ds/5fWXMYb9x/zbm0K/c1214rpu4P4rvy++9/wEMEgpU
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn9I3HUYPmL2h0VRCFmQGY2wsUIKhv9cfPpBayE1jczFtZisy22EN8vl
1DY1rznb/LGp2znn/HHq+et2d965u/PO+973YBpYEESjENKgISgjRouxP0b3
eeR9xh148vD58b7v8zzv+7nnK6pKP3/IYrH8mP7T/+Vj6zDvfHfr5Te20B5l
zb7xQhPxPvXT8nLxCcFGhfLuXqur5/ohvX+kVrCqUvU53sUa7q9W6eV/qgWv
1qh31+pyHDx/XDk3Soq+FJzfoFJ3CmyHed9Jlf5u/EJwYRPiHeT9zTq/5QOC
97Yg3n7Gc6o+l+tpm2DHKfWSrePNfYx/Wu93lAnubMP9HzKfMzqflb2CfWdx
3/vMr0PZ7fabxYIrO9V/BbYOrhd2qfT1Vp6/24X9Jcz/nOajm/Faz2v+dn/E
erqV1of55faoNPSUs74e8PWJYE+vjv/4g3ov6HrNTwUXXYR+n7F+l3ot/SF/
Sy4VznNuVJCPvky+yy8hnp389EPPSsHr/eo558Yvh8jXZfBxRHDtAPxEvdUV
5XZYs6sEbxuEf+iPykFVmk6I/lkehH5fk98hvZ51THD3EM5/Q76x7jwu2DYM
fulfYxjxvxW8fSTT760jer2tQfDmCPxQR33cyIf3B91a7zjj547iPubXMKr5
v8f8V0ehz1eC3x5TaTq9rNczhvuOCn50PJMPxzjq5flfsZ7F/ivyID/G7/do
/xQQWybUUWv2x8zn4IRKfzfy/qUJ6E89dk7CH8Sdk/Aj8/t3MjO/8ilg5heb
0v3jYrz8adTPfFumdXwL+Vuf1n4q4XwpngE/5Ns3A/9Rzxxvpl61XvBBPVe2
1k/Sf1dxnvPOfRX1NNOPPvRvi+BdPujvpD996KdTgvt8arMknHeafvWhvjbB
932avyNn6F8/5km74Ao/9Oygn/26/2u6BF/3Q7/z9Lcf+nYL3hHA/CO2BXQ+
Az2C2wPY30v/B1AP8e0A4l1gP8xCj4uCy2bBH3ErcLZLcBT7G4k3Z5EPcV4Q
futj/wT1/A8TNwcxvy6xn4KYN8Q3g/AjcW5Ipdt5jfi9EPTsZ7+FoB+xN4T7
iFdDqJf4yTm8J5fZj3Oo94rgY3OYH0Pszzn4a0TwH1hfdLNfr8H/Y4Jfv4bz
HvYv1rMmBQ9jfXGK/bx1fkbww2HMD64XhaEPzx8O4z7e3x+Gvxj/57Dun1eY
nyWC+TQs+NUI3sNBzoMI+nVAcG8E8518LUWgP/m/h/US6r0zCr3op/1R5E8/
dkahB/1qRlH/Oc6TKPxK/784j35if5TPIx77p20e84n9FZvH+/OD4Fvz8AP7
MT+GfFoFl8ZwP/u5JYb3+XvBczH4hf2/HtP+O8D58Ewc/ubvqeItzHlyIq7f
fzvnjS+u9WtsFPxXHHxxPuUs6PM3OL/eWUB/ENcuoH6+X5MLOM/5t7KA+jgf
H0uAb2KVQL18z6oT+D1A7E6gH4h/S2Ce8P5tBvzCfJ41oBfr2WXAf6z/AwP6
kJ9KA+8b+WwywPeDeWqAL87TWey3Us9lA3ycFfy3gXlAP9w3MJ/pl6eSmM/c
X5jE/KEf9iTRn/RDRRL1M7964GLm351E/qx3Jon5TD6uJ+E/8v1nEr//+J7d
xXkr3+MnzMz3cocJ/fjevmWiP/i+2szM97TGBF+8r93E72vGGzfRr9TTMOEv
5ve7ifePfrqN+HX04yMp1E//bk9BX/JhTUFf9kNZCvywf6pS4IP8tqbQP5r/
/wHsLRi3
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1om1UYDVL9UYdDCTgFa8UhdUwpFkb/VK5TnJOCW3/MCkGwzFL1R+Og
2rV1s7V1W9zadEvrkmVd26Rtmrbpm+/v5E0Cs0IUhGFRCjaCpbAyZGxS9mOY
e17uEQttOdx7n/s85znPue8LHd1tHz9iMpl+rP7K/+rHMla8/+2dV94w0FEx
cvt44jzxByJwpNJnU1jvEOsea8tFrn8i5N9RhUW3eLkacIz7T4m2RN3IuMKb
PeKncrn1Cs+fFv80WPZOKFw/ID5vqV2fZLyzwuV0Oq8q3DgozIEjH7kYf0hU
029wK3xsWFSvu32d942Ipqam8A2FredQzwzvvyDzPexR2G4TXmtL7RzzuSjz
Lc8rrF0S71T6HD7mN4b8/Qp32SV/zcSN47Ke94l3x5E/sX5ZPF89QHz+iqj0
mV8lPuYQteuevxcV3jeB+4k3J8TO8UQdsW9S5m9jftbvRZVOD/Nvvop8vKzf
iXpnFV5zon/ky+4CX+Sz/Rrqu0Z+3HL9Afuz7cZ59k+7LvkZcyjcOyVK9xss
l8nfDdmfJrvCNdPgk3rqmhZSn98pXJ6W/FUukN8Z6OWcwg4Dj5DvGez/RmHL
LOINkv9Zqa9nvlZ4vwf9PsN+eMA313c84G+I/fHi/LDCES/u4/375mS9G8QD
c9Ar92/OyXx6GO+teTlfWd7nm5fz8+hZhfcsiP7qBV+xvwuYr36Fby2A/9Ps
tw/1fqmw24d+EpsWMR+9Cp9cFJ2dnVs8v7Yo6zcz/kE/5n+A+vDL/Z3M554f
/SZ/7UtSzwHmn1kCv6yvfhnzyn4MLwv5j/3aXsb95Kt1Rer5RfKprWBe6F/m
APREPfQamH62YWDqR6ziPP3Nu4p5ot5qNOiRfndIg96JuzT0+5LCLg39o37L
GvyLfvhQk/Nspd4bg+CT/tgRxDxyPhxB8EV8E+s2+uduEPrifB0IgX/OnyUE
vXA+R0Pg9z//DMHvOc93Q7Ifn3He94ehV/rBiTDqneZ8hFEf/SMVhp/RX3bC
qIf+UxcBPwucnwj0T/8aiuC+Jc5TBPUtK7wVQX0BzlcU/GkKvxuFfoOctyj4
CisciCJ+lPOH89mYwk/FwFeC8wj8Q1LhL2LQS5rzGUO9KYV/jyEfnt8Tx32M
/3ocfhHh/MbBT0jh2Tj6w3puxaG3FYUfSyC/Vc53AudZ76cJ6IXx3Anwxft+
TiBf5mNKYp6IX0tinftPJuEvjDeZBF/Mby2JfJnPgyT8kfkeTMGP2M8PgQ/z
fbOnoCe+V8UU9ER93EthXqifl9LQJ9/n9jT6S73Z0qif73kmjXknvpNG/tRr
fQbxidsyyI94OIN+Escy4Id4O4P7iZ/NQq/ErVl87/D+M1m8T8RaFvpn/n9m
oRfWZ87h/Sd+Owc9ko/eHPyVfPlz8ryPfG4Y65yvJ/Kon/yLPPJhf07lwS/X
vXnph1OM92se/eT9NTrqZf7P6fBz1n/IwPSL93TM5xT9U5d8/sLvt0Ed7xH9
yaWDX/pXWIe+6G9lHfNE//vLiEc/fajD3+i3TxcwD/TTxgK+x3j+aAHfN4zf
UcB88f5+7K846c+F//vnCvbb6J83jfj0zz+M+Pz+3DXiUw9PFhGffB4oIj75
frOI/NkPSxHvL/vVg/3N9MtR7N9Lv1zA/i3Oq16EHugfvxXxvUO/vFuEHuiX
j5cwH3G+DyXwT39sKUGv9MMTJeg1o3B3CXrK8f0oQf96Ff8L0FYtcw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1oW2UYDTL9MYeiBNwE68QhdUwZFkb/VF4/cE4Krv0xKxTBMmW6H80G
lbkN3UbDujqbdEs7k2Vd26RNmrZpvr8/7r3RrtNMndZVpWAmOAotQ8Yqsh/D
vKe8p6ZQ0tN77/Oe55zzPDfPdHS2fvCAyWS6Wv2Vn//7OTF++4VX1v7cIxY8
lqZ1/K548+ZRM7HWIYK7b94b4/WPxMYFz9/EorP2una49vlKl7AutzSu1/9U
fFj9Id56XDRVCxKLz0WqzrpMvPMknvex/inhtTT1Eu/tFuYqAeKKFff7Fbac
lnwcxKYzqE9s70X/E+RzVvxT324jDn0pnrYuXycWNlFarW8PKHzALvk/O0W+
/ag/rfC//aKhoSE6Q/7npF5Hwwr3nBc2Y7U+wn4csv4i7988AD6sVxkA30mF
/YPwY73fC3ieejR+JZ9/lNjkxHnUd84pqna9SP/sLuFyOrd4FW67iPqj1MeN
fkYUXnLLfg8OU69LOO+ywkeG5Hn+S9TvMvi7Fd4wLJ5vtxku6gn8qlPh8rD0
M3WB+o6A76DCjhHJ1+mg3iOiNVX34HmF20fBr5/6j4pr5XLZpvA2D/Toox8e
+bz1rMIrHuSrl/54ka8zCse8yONp+jWGPBMfH8P5vL8yJvVr+ELh18dFtf1V
nucfl/rkyWeTD3zs9Ncn+TefU3jeB7/Yf6MffAcUdvuhP/UzTUg/LdR3/wT8
uMg8TEA/+rUjgPwPMR8B6E2/7wYwz8xH2yT6Y35yk0J+rM/7lDhmDl5hHrun
MJ+cr6Upyf995rt5Gn4z/6Fp7JugwuYg6oWYtyD4cZ4Wg+AXY/5mwC+hsHcG
/FLMYwj9phXeFRIrLamhLPMZgp95hV0h6FdkXkMyDxt1he+HMI8G8xuGH18r
3BHGPphlnsPwd07h2TD8/Zb5DmO/fKfw9gjyco15j2Bf/KBwXwR6Xmf+I9Dz
Z4XvRND/L5yHKPJ7Q+F9UXGo+g/inij2+4LCmSj2IfFKFPkirosBs/7eGPzg
+adieJ78YjH0T/63Ypg39rc5jn3L/t+KQ++rnLc49hX1DMbBn3pX4tCLfjye
gL8a5zGBeSso/EkCfuc4nwmp1wni3xPwk3nYlEQ9Pv9yEv0wH5Yk9CUeTWJ/
EM8nMX/ED6WgN+s1ppBPnv8xcAvz6U5Jf4PM7/cp6JHk/KdRj3l/KQ19eP/+
dG3eB9PID/ubS0N/8ruXRh6p344Mzqe+72Xkfuui/vYM/KQ/Rgb5Y97vZvA+
oJ/PZSW/d4jbsphf3t+bhf9XuG+ymLdvFL6drZ23rTnksaRwaw58yLc7h33M
fhI59MN+l3LQg348mcf7jvo05/F+pH6f5eF/hvsrj/1M/f/Mgw/9MRfgV1zh
NwrIH/fXkQL6434LFPC+5PeJxQL2H78/PFKs/T4iitCP31cOF6E/r3uL2A/c
rzeKmFfW26BBT+7bpzTw5fm7NOzDqMJva9jv5H9AAx/2d1KDPuzfpUE/6hPV
ZB7rqF9Zw7xQ3780vA84D/fBx0J/ntBxHv3bqaMf7uc9wLfofwfuP8i8HNPR
H/Pk0LGvmbdpHfPKfM7q6Jf7+g8d81Lm/tbRH/fZY4Z8f+3mvttuwN8fFX7N
wPz8xP1uIG/zCncZ8IP7tW+tHvevz4Dfv3L/rz3P678Z8J/7/Y6Bfljv4RL4
87xtJeSN+7uphH1Jvvtw3WB/nSX4Qz16SsiXnN//AA3iO38=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1MlWUYPjXrB7lajS1zi2ixRq4ci63xh/ZULrOxBfww287aYtqsfkBu
OFRW6jgLWQnW0TpEJhyQw9fxPZ+c7/O+7ymiPFoWSRolmBIFoTF1ROvjfa6z
53KHTdy1533u576v+7qvmwfr6mu33Wqz2b60/sn/1Y9348zuocXHnsqhTeK5
md2FI8QvCQt6vQrrdWJPoXejxvPXROZ66ZRPYVEvCibdDQF+v0PURopuCyk8
3Sg6XS5XmPd3iXbzemlE4eJm4ZiviUQZ7228F1e4bJ94s7JgMsH4+4V1/EpK
4eoWESlyzKf5ngP5GAo3vCPs1oMm3z8gZP2fKdzRJqzPK4mL3xW9DZUF/F57
TzzgmD/D+KJd8uVMKry9Q57X3Mz3EO6znuVD4hErAdavvy/zaQwq3PqBPH+a
/FU7cZ/8rTmM93l/+jD4JH+eI+Ajxno/BL/kq+IjycdV5mtzifLy8gDrGXeB
D/LV0Yl8Mgpv+Rj9/Jz8dIlT2Wx2TOG5LnGj1N4+Tr4+kf168SuFm47KfO/L
kr9PoZ9TCq86JhZqIke/Jp/HUM8ZhbM4L/qO/HbL85kJhZ3duH+WfHfL+PYf
FLb3QN/nyX8P8v9R4RK3rM/xE/vhhh4uKLzgBn/T7E8v3ruocLBXxqu6xH71
QW+XFW7uQ79+Zf/6pN4rflN4w3H093f287h41fpZUHh1P97/g/3th36uKDzR
D76JKzwy/+Siwl0ezA/v2wYwb4y/dUBYv/fOUw8DUh/lzOfRQfA9R30Mot+s
59og5nWWehmS8WysPzEkz7/4hfoZBh/kr2UY+puhnoZRP/muGkE/2Q9tBOc/
K1zoxX32r8mL/kwpPOXN77c4IfO/i7j3BOJTH6s08HNO4Sc0YdH3EPF2DfGp
r04N80ac1cD/pML/atAzcZkPeiSu86H/1K/TB36Ix3zws5v69qHfxOv84J/Y
7sf8Eh/0Q5/Euh/1Ei/5wR9xSSA/n80BWb+b9bUGoD/yFQtI/32D/CwEsD9Y
X1EQfsb71UF8T7w/CH0SB4PIl/Fmg9AP8ZoQ/JbvPx+CnxA3h8AX++sNod/U
w3QI/kd8Txh8UD8bwvl62pk7ZzxPDjOf82H4B+tdPYp5+V7hJ0dl/W30q4ZR
zA/9rAfnBcQTo/CPbxW+PYJ6eV4RwfeM93oO872uCPyF/TsNHCG2RaFffv94
FPkz3tYo5ovvHYmiH8xnPAp/oD+vRKHnb+gXMcnfymmFX47l+31HDPPBfWDG
kM9J+klMWL/3cn88HAd/PN8SBx+M1xbHfuH+SMTBP/NZjMv59DD/4gT0wXpr
E/l8tSTk+zbqMZzI199cAv2jHtYmMY/US1US+4p+9VYSf5/Qz7Qk9Ef/u5iE
3rg/ClP5fvpsCvql/zalwCf3x2AK80n/nkqhPvr9nWnsM+4HkcY+/1PhHWnM
+xL9MI1+XFP4bBp6uEF/1NH/ZYXv18HXCv1Sh9/+rfALOvzsH/qnjnj/Kbwv
F++WK8pPdeiV5wEd/PB+Vkc9jH9ZRz1/0W9z7zPfe438esoM+Bfr3WRAT1fp
xwb0wP25x4C/c186DewD7scRQ/rdevZnzID/sn8XDPgd+7uM+272/25T8jFL
fawzcZ/6ecaEn1JfduD19K9GE/qk/x000X/qtT8Xn3rWTcw7vz9nYj9Rz0sm
9Mnv78hgnukXJRn4H/2hMpM/X5sz0CtxPXA7/aI1A/4k/h/Dgl1J
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1M1HUcxy9DLbSc7ra0LaLFGjlrLDbHP7Rv5iKbW8ofRtvNLWZN6w/I
jUbISh0sYiVYaEFkwB3yIJwH98A93+/uCrFOy0VeGiVYEgWhERhRUfd9s897
k03ca7/v7/t5er8/Px4oLil8cZnJZDqb+qf/l5+HLXVbwtOPPLFE25TZXjAW
IT+vUr8ORoWNYtXU2Lghzuf7VPXkTu+nwqpEvZqf/twgz+9X6UnrjTPCo2XK
Vppfe5bvv67y05MPfiGcWamS1tJQgve9qe5PBTgvnHNIeTOqJ7/k/YfVuUQi
wec7qlSqnhjfH61WYxVm++fCpW+pm9mWuiHGf1u9lPphvvW1KlX+wmfM5x3N
Fczf8S6e831Vp1Lhynj/3nrUy3pyjuL+c8LzR1V8LnuE+Rrv6fy3fyVc8z7q
v8B6GlRdbC77a+H1x9TTYxUNw6zvGPL5RrjzOOq/yHo/QL/JeR/q/ErJpkbM
lzzUiH6R65twP7noI9STZH+aUS95ohnxvmW/Ptb5bLkkXH5CFXozll9m/z6B
3shpLeqA2X7mO/azBf0YEU60oL7v2d9WrY8LPwg3tOr8xq+w362INyZsadP1
PXqV/W/T87D8KJxlhT5+4jysyOea8JRV98v0M+dj0/rPmxB22bQ+X/mF82pX
Uzu9J34VrmzHfZOcXzvqnxLeehL6+I3zPKlyc3Od08KrO/T7Bdc53w5dXzV5
uAP+uMF5d8KPM8LNnbjvD86/C/OdFd7Thf7cpB66EO9P4U3d4Hnqoxv+/Ut4
thv5k4tOoR8LwsFT8Cs5swfz+Vu4qkf3fw15okf7a47nt/di35AdvaiPbLZr
TjJ+uR36I4/Y4R/mr07jPOuzncZ8yWkOPb8M9mOzA36coz4dqJ/9a3Igf/Y3
4YAefxdedMBfnE9OH/zE+RX3af+kc94NfdAP9THYh3jUz3yf3seN1NvGfsyT
+rT0Y3+OCx/px33Ut9GP+umHmX7Ep1+ynNAD/bTLiX1F/9U4tX5foF/9TuiD
fp1y4ntBf2a4oE/et8MFfzPeYRfmQz+6XOgP/Tfugt9Y33o38mX9z7hRD/1Y
6YY/WL/drfWfy/pH3ZgP46/z6Pl2Mr+tHsyT+b/mgX/JnR7cz/OX8bxglH4d
wH4iPz6A+fN86QD2De9rG8B+Zn+HB9Bv9nOFF/Ngv/O8yI/782Uv/ML92+xF
P7ifz+N8Hdnkg154/jGfSv0+yPv2+PQ8zIx/3If8md+QD/5jPQt438R+bvJj
31Bfu/3YB+x/vR965nxifsyD853Fcyvn+1AAeqD+iwLoB/dlbQDfI/onGMC+
oN+mA5gX92FmEP2lfwuD0Cv9XhVEPtwHniDq4T6ZCKJf3Ff3hnDfv9xXIeyP
/4TfCEH/puuyv0LQ/zLhqyHMJ03YHMb3aYXwU2HUe4dweRj9ThfuDkNvq4RH
wujfXcJ3R/D3zBphFdHx89cK749gP6wTtkWw7/j8YgT94ftpBvSzWvg+A3pj
PpsNxGe+zxrQN+vZa8DPrPfQ0n23CTctMfvjNOA/nk8Y2H+875oBfTDe4tL5
O4XvieL8SuGcKPq7XHgbnm+4Xbg4in5yXgeimPci93MU/flHuDeK7xv1MRhF
PtTPleit39v56K16XBvDPqNeN4Jrqe8nY/heUv+WGP7+5L4ri0Gv3JdHYtAj
92lHDP7lPjKW4nH/XIqhHvp9Bu8n6PdVccyPfs+KYz/Q7/lx6Jl+3xXH94F+
L4kjHv1eE4c/td//B60QSqM=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm1M21UYxbvJZmS4N9GxRRnLUJEwJJIsfMFcpxFnSAQ+TEwaE8kkqB+o
SzBzI7otEJHoYMqmIE5eyngZdIWW0pYW2n+TiUk1TslwEx1MhyjIJsJEVLT3
kOcsSALkl97/vfc5z3nOvzsKivNeXG0ymT6L/Or/8vOQuWrPDzO7HlumvSp6
pPnGOPk5leeOLx8TDhRoXnOFn7+kzFVGyXfCqli9mhk98i3XH1AR3HlZeKxE
xdqyXviGz7+ubiaZqy4KJ5Sq9PR0xzD3e1MdjrV9+pVw2lG1vXzqwpfc/5iK
/D1yQTinTD01fij2a55XrqqM+TbuZ3lLjTRbMnme6W31eTgcHhGursT9LvE+
70AP3t/+Ls4b5f2qlNWSGf29cFG1/txETjuhpnPdp7l+4YTW59lb+rynyqdy
M7h/xftgnp9Ts1KvuJPQh/cdO6nrSyK3ncJ6suUDFemvweczPtT3ied5plpl
yxo/xPsM1UJf3re6Dv1jPfkfod/sf0I99qc/Juuhx1Xq9bHWN5v+Onga/f6R
+n0C/a8JRzVAv5+oZ4OuN31SONyA+n6mvo36vMpfhGsaVaT9tinq3Yj9p4XN
TaqwsHDiV+rfpOtfnBFObIa/b7AfzajnN+HpZZ5lf6xY/7uw06r1mSfHtej7
js8Jl7bAz/PsX4vWt/mm8BNn0I8/2M8zWt89C8IxrTj/T/a3FfqTh1vRn0X2
uw39/ku4vg3ryaZ2+PFv4f3tuC95qF3rVfiPcEqHCs0njZKrO3Q9WUvCcx2Y
N3L+WfTzX2HfWfiBnNAJP5DLOnE/8mSnisTPFDm7C3qbrou/ulRdbe1Wcqxt
JR+0IQ/Iozbch6zOoR7ubz2H+SJH2aEnebcdfiQX2aEX662zIy/JYTvuQ16y
o9/UL60b80Uu6Nbra6l/TTfqJZ/vhv/Zv4VunRdu9ju5B+vJ5h70h/443qPr
P0I/BXowL/TbbA/ym35MdGA+6Nd9DuhJrnDg/vS31wF96P9pB/KM8xLvBHOe
cpxYz3k75kSeXec8OeFfzueEU/tlA+c3rhfPc96f7kU/mQelvZg35oWtF/Uy
T8Z64T/mzWaXznvLBOfRpfMwl/n0mgvnMb/aXNCD+XbZtfL9GdOHz8mP9iF/
yJY+/T7yMy+b+tB/7jfchzzgeWvd6D/vk+HGPPG+L7vxfmM99e6V+fmFW9ef
Sj1MHjD1esSzUs/9HuzH/DzlgZ+o/5AH+cH+LHr0vL7C/qV4MQ/s7/NevA/Z
/2ov5p3+MLyYJ/pnzou8o98e6Mf96M/8fuhB/1b2a71r6G9fP/pP/8/0K/2P
85Pggx85X3k+zDvnscyHPOD8uvD5/K188kGfVZIn2/yod7Vwth/v09uE3/DD
z2uYX37otVb4qh9+uJ15NgD/3CH85ADWRzPfBqDfOuGOAex/J/NuAP5ZL7x+
EPOxgfk3CP9sEj4wiOfvErYOIk9ihS8O4vy7haMCyIt7hO8LQI844d0BzNtW
4Wf+93lRAH7i80eXmefVLa/fLOzAfqkbhcMB6MP6rgUwf9RjKQC/UK8tQfQ/
RjgtiO8H1GtvEPNHfQqCeP9Rn8NB+IX61AShD/XoCqLfrOd8EHnPeq8EkS/b
hBeCqO9e4U0G8i1eONlAv7YLP25Azx3CZgP93SlcYqCf9wsfN/D+eVC41cD7
NEk4YOD9kSx8ycD3qRThWQPznSq8LoR8ThNODCHPHhbODOH7CnlfCPPI54tD
0HuXcEUI86TP+w/+wyMD
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlnFMlHUYxy9DKyRNo0RLxCCHRUZaxD/XfpXLbGwBf5htt7aYNao/uNxo
hqzQwSJWgoUWhAYcyIFwHtxxHHDAy3tb0Xa1ublYjU1wSSwIjTwjKur9fW/P
t3GbuM/e3/u8z/N9vs/zvtsLivJfW2Wz2b6x/un/5TeXFzz71/wjT8dovxp3
Oe3/kF9W4Wj6xLKwUaCsv2W2a3L9DfX8VEntLcKqSHPivzx/WOn4fwtPFqs9
1m+J8d9V2ypmL/4hnFKqPPumSqLC6n1lhdv1u3DmMRVMrpi9zvjHVcVsXnBe
OLcc+czxeRWI94uw8wPlqDaLZ/j8D1HPtHBNFfL9ifl8hPyuCHs/1teTp5hf
Ne6/LFxYo+rr6urImSeVPX48lecXT+p6PIxnfKLzz+bzKj/V+g9dZT216mii
Z9/Pwkmn1LeRSIT5T57S+eWxPvdp5DvLej9Tb9vjX/pVOPtzzePUy1aH+6nn
GPjib9SjXj8vh/of/ELn8/UN6tOgdjqqn7kpPNOAfrCf3jPo35/CR85qPVzs
v/pS67WZ/ohrVC1OexX9V9io+7dE/0Ua1evWj/7LbEK+9F9tE/x7q/BiE54X
J+xo1vHj1wgbzcq67LxNOM2FeLcLV7rg13jhORf8Rc5twf0872/R8+Jg/KRW
MJ9f2gr/rRKebIUfWM/ec+pmumM958d9DvlTj4Q2fb2aejnbMJ+c30ttqtqM
usnZbswLucG98n5bO+aD8Q+14zr1HmuH35hPRgf6Rb1rOlbWc6NDWXadov4H
z8N/q4VD56Ev9UnphP+oX3kn/HmH8EynjvfqWuGcLq339QRhb5ey/patE070
YP/cJXzEAz02CE944Ne7ua8uID655QL8s1E4zqvvT+f9WV7Uz/iFMV4vXB87
z3wiXszPncLLXuTL/DO7dT4m6yvoxn4h13ajH/TbV92oj7zYDf9Qr4d64Dey
owfxyCd6oB/1Nnp0Pjb6f6EH802/pvlUvmUg9veAD/rQr5U+3f8o/TPgg1/p
tzkf+sv5T/Zjnrkvcv04z31y3I99tyDs98O/14Sn/dCD+yypF/G4717ohf+4
D0t79fz6+D7w9KIe7r/JXviT+29jAPuKz98bgD7M750A/Mv3kzsAf3Hf/RjA
PLHehD7UTz2e6sP7gHo5+1but+Y+zBv1vYTzLuq/Joh5Y3+yg/AX5+nNIPrN
/jbgfJT9/w7nI/SXrR/vO/pzdz/i08+H+hGf/j+N88mclzGcjyYKL+F85F7h
jAHknyT8ygDib+H+GED8+4VNnE9N5j4ZgD7bhHcMQv/t3C+D0D9VuGoQ9aRx
3wzq98U0eX4Q8/og908I/SbnhzC/5PKQ9stqciCEeWW8mRDmjbxlCPkxn5wh
6EV+bwj1PsD9hfN5rOfKEL4HUrjPhlE/9XhuGN8XW7nfhhGf+nUMK+tvGfWd
GEY/qP+6EX3dton7bwR63yN8eAR6/L8PR7Av2N/vR7Af2N84A/kw/lYD70M+
P8uAnuQXcX7zfdyfBt73zP+YgXpZX30sHvvvM9BP6hMxoD/1vGqs1H/ZgN7s
36ZR5L+D+3cU74N04f1gcyf3cez6w8JHY9czuJ9j13cJd8XiP8p9PYrnPyZ8
eRT57eb+HsU+fVx4g4n693Cfm/geJD+L6yVkh4nvE3KxCX0Y/4SJ7xVyG+LZ
yYaJ7wfm94MJvckLsXwyhdeGMb/ktDCu87w9jPqZz4Ew/PGEcFFY7/O3nuT7
I4z9m2Xxf5KnFlc=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn9M1GUcvilqIWnalWh6YpIhkZFXdrXOXpVFNraQP4q2W1vMGtYfXG40
SlboYBHLwDqtIzLhDjkQzu/94Lif3N33NqPtanNzMRtb1pZzk1Vr0ph/uL7v
c3sfB5uyZ9/P+76fz/M8n8+HbU0tDW8vM5lMPxr/5G/18769eHb130/sK6CD
YtbjtN9L/Ibo1Rd8KxXONIl+t3tjEb8fEcbx7csUFi3imNn/w3LGHxVRS9d7
KxS+1ipe/v0j8yqe/1C+l7pH4bJ28Y7xU8z7PkF8icLVxxF/H+8/gfvXKlzf
ifzW8b0u8VM+n1+vsPNT4a81LuT7nwkD7XpI4b4eYTYCNjCfz+X7ro0Kaydl
fbUPM79eed/tzQo39wmr1RqyMN9TyK9M4cVT4OsR5v+lyC1UzG1XuPsrvPco
63HJ/OseU7j0tPA67cU7Wd9psdPRq1cq7DsjjP87qljv19Bzl8K2b5Dvk6zf
LbpuHoo+pfCMWxjXtVrJR7/4r8LR+7TCjd/Kem4yvmwAfPC+GwPwC9/XvpPn
1zK/trO4n/WI76Xe18sVLjon+XCQn+ZzQvpzq8J54Ne3kN9B6LVJYdegKDYK
LiXfg+CL+jqGkN8D5H8I99Ev5R7E00/dHviZ/pv3QB/2S71XvvcPv4e90GsN
9RqWent4X/sw+L+f+g0jnv6sOS/mD0XPMj/fefBNv5aMSL1srMc5IhqMAPr1
ygj8zvptPvBPfgZ8YqtxAf1rGkX+/H54FHrQ7zOj0k8m4qox6bf9vL9vTPaP
n+/fGoMfiBsv4H3i5AWZ74q7/TUu9agg7hyHP4hvjKMe4roJ8EesTUAPYrMf
/Ud+2vzg/0GF5/yyng7yKS6i/4i9FzEfeL5IwzxhvXs09Av5aNbgH/LZry2d
B3kN+vH7HU3Wt8Dz1YGl9TQFoAfzdQWgB/1wKSD1u0y/LgZQL/1VGUS/cj46
gpin9OsXQfiH8z0TRP2cv/8G0W/E5SH0F/FrIeRL3B2Cfrwvjvi3iOfx3Uds
CeM8cX0Y/c55fyKMfiMOh+E35n8dWCcunUT/sP9emUS+xO2T0Jt8+Ccxf9mf
13A+T7w+gnjyWRMBX+zXDyJL+9cXwT6iHr9G5PzoYT+XTMEf1G/vFPii35xT
uI94CPGz1P/KFPqLflwZxf30iy0KfenPd6PoP/prIIp62d8/R2V9prv9H4P+
xLtj8BP9eziG9zhvzyDewf02E0M9nM+3Y/AvcVUc+XP/vRlHvts4P+LY75z3
ehzvE9+Kox7uxx0J+IO4MYH9xv3Rk0D/cn8mE5h33Dd/JZAv92dZEnw8rnBD
Evxzf3UmkT/3ZySJeVvN+ZQEH7sV3pSS+Vu5L+tS8Af36ccp7CfGayk57y3c
p38U4rlPzdPIn++/NA29mF8bsIP5jyH+MuubmwY/FQqvSct55t7B+ZeGXuTv
aBrx5Neblvx0UK9f0ph/1Lcog/lEf2zJYN7TP3sy6F/iVzOYp/RPc2apX44j
Xud7/Yh3M58Q4p3UN1+4n/r+Wbif9d8p3M+/PzZk4R/yV53FviW/B7PYP9S3
CfG11OsY4i3U15XF+88oPJGFn4gvZaEn43/Lwp/Ei1nMB+J1OuYXz1fq+Pvx
WYUP6NgfNs53Hfo8r3CrDv5f4LzXwZ9d4REd/n+R81+HnkLhqzrm6X7uAx1+
O6Dw6hz4qeF+yKFf9ylsz8EPe7kvcuhv5tOSwzx9jvsjB79J/D//l9Gc
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlm9oW2UUxotUP9ShKAHndF3m6uy6rsZVa/yT+W6r6zorrv0wKwTBMkvV
D42DSu2GutFiLbp0mk1T69Y/6Zp2a3abpGmSJum9NzArREEYDqVgKzgKHQqy
StmHYd4nvA9cAyH8uO+fc57znHOztaW96e27ioqKfsh/5a/6DPj9/tK/d+0t
UL242Rg/v4X8hnCVXB+1K9ZbwFv5/B2sf0yxaBcHl7t827j+mGiKl/aUKV7q
EPntnse5/0ORXSt3b1dsPyHyj11P8LyPRT6+h8sVO06K/HGrZP2UXJ/eofhw
twh4XH0VvK9H/JjLNexU7PlU/Fvuvr+S938mjttC35P7+4Tba3bsYjyfy3y3
VSnWvsB6svAKW6jurScVt/WLUN3ybbLjDOJxKF4/g/ufYvxfSvaSe7+Set29
m/n4EA9541mp1yJ56Sz0qlYcPAf9yZ6vZXzLZOc3wmuulT/N/P2In7zgx35y
/wD0JTd/i/vJ9kEZ3xp5ZVDIn2eo13dW7jwPfbheXBCtra03yMVDsl45ctsQ
/EbODcE/ZMewqM5/yL5hnMd814ehL9k9gvzJ+ohY7rKFqGfZqMzfRu4dlf4u
ZX1ujko/+lnfwwHES79EA9CDfts4Bv/QjyfGxPuuktfp36Ux6E3/115Evdgv
wYuiZ7XRyX7aMG7tP8844mN/XhuXekTYz84g7tuseDCI/B5l/SdwP/nohNjS
s/oz1y9MSP+WcB5UToodbu8+3tc/CX8ynluT8BO5+RLqw/WpS/A3z7NflvFd
533dl2W+ccazUuBHFDdMoX/I2hTmA9kWkvGZ5M4C87zFEOYH7xNXZP2rGE/g
CvqV8RZrqCfzqdGs+rdpOJ/7BzT0B8/PaZiPrMcdTc6POp7vmEY8PK9l2jo/
fdPob87Lq9PwN/2yXlhPP1WEsZ5+c4dxPv14Ogz/0q96GPHQz/+E0Z+cV2UR
2S9B9sORCOY1+603gnrUKE5GoMez7JcI/PGc4tIo+u8F9k8Uer2o+FQU+exh
P0URn1B8Iyrkzz721wz8sV/xIbCzlv02g/4nh2agH3lpBvV/WfGDMcwXcm0M
84H8QQzxkoMx+PmA4t9i6HfyhlnUg7xnFu8jsud/PDKLfMnXZpEP+Z649Xxn
HHqQ342jfxnfYBz1Jv8UR/3IRQnUj7w7AT2pz9EE5gf5XAJ+ot4LCdSXfBu8
xvpUJuX698hvJhHfXs6PJOYD2Uzi/wLrfSuJ+fqS4u1zmEfk5jnoS7/0zWH+
uDhv5qSfu+ivv7C/j/6zp+CP5xU3pfCcfu1OIT+n4lgKetDfKyn4h/7flLa+
3xrSiJfPP0pjvnO/lobevO+PNOJhfLaM9Gsr8zmQQb7MvzODeU79JjOoD/Ve
zEBP1ue+eejD52Ie/uP+Y/PWfgsUnvO+Xwr7qXexLv33CePbrKNfqHeNjn5j
Pq/heRW5rbCf+p/U0V/UY0BHPOSIDr1YjxzYSf5Tx/8V6ntHR/zkhwzEw3o4
DOhDrjes9WwxEA//vxw3UB+yz4DfyVMG/Mr7rhp4XzD+3w34kfmvG7IfGqnf
AybmI/WuMDFfWJ/9JuJh/dwm3vfszw4T/uU8OG2iXgcVj5vQ6xDnvwn/NCj+
1YQ+9Xwf4PzqOsX3Zq3zsSyL+PjclcW84X1HstCT97Vn8X54he+PLObRq3n+
Dxq031s=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn1olHUcP8L6Y0VRDNKgtXLZXGqX1lrR2U9dztnK26o567Icuk6ttoTF
0lFTNlqjOq3TujVtLzd3m9v53Pv73XPPgRVcQRBJMcgFieCoEBfDP6T7fY7f
Rxps48Pze/l+v5+X57m/tb1pz00mk+n7wq/8r37mG6OnKv5evaGI6kXJ+bGO
FcQ7xEqbY2Olwnqr2DJ3sLSKz/eKtra2iw8rLNpFYXtqNdcfEP9W2hyPKHyh
U5R663Y9yv3vi3XyR+HybuHusJQ8zvM+FLmFytlqhc2HReF6bw3PPyKaomV9
Tyls7RXvWkq2P837+uT6NesV7vhI4Fje/7Fcf36DwkcHhMNY8GxiPZ/I9T3P
Kqx9Ku7ru9xYx/occn1lvcL2o8JbN3dtK+s9Jtf/1KDw4jGc/wLr/xz9bFO4
/wtRaOcy11udmA/PW3pc2BxGJ++/cBzzrlXYc0LO4+aN7PdL8UM+3/CMwjVf
iUGXy8X5mFy470mFv3PJ8yxPcB6DotBuDflo+Vrev0A+yofk8yj5uDSE+siH
dhL7eV/XKczHwvl9g/pZ35JhzJt82IdFgZ7l5CM/jHrJn3kE+8mvc0Tq08n7
FkegZ9ZjG5V6st3Qzyj0wn4qxrD+MfIxJvU6t1bh+SKmfq1u1EccdKN/M/ka
l/4xqP/ucej7hh/Gwc8ahWtPo3/6x3Ma+lil8G0T0BP91jGBedCPP09gvivJ
t0eeZyIeKmL62TQJPun33ZPw84PUw6SsL898WDWFepZTH1Oyn4EHFL46Jecx
RtxyBvVyffIM7uf55dOYH+/vnRaHCgN+iHqalv3tZ70NM/A7+9FmhMwv9l/q
lX4JcD5dXuQPn8964XeeJ84iz3if+yz4YH1LNDnPg6y/WoM+iO0a5sf5DGqo
j/3kNem3Zbzvuga/sH6zD3pkva0++Jf8O33oh/o450N+Ul+LPtRPfVb5wRfz
1OZHPfTvZ37kOf2t+8EH/X/FDz/RLxUB+byHfmoOYD/91h9AffRvPIB8pD/n
A9ATcVkQ/qC/rUHolfhIEPcxv4JYv0B8MQg9MA+WhqAv4q0h8MO87g4hn5mX
3hD8u4X+CyEPma93hZEHzN/asNTPHczr98KYL/PaE8Z8GxX+LYz5vEi/RjDf
lxVeH8F8m+nfCPTVovBoBHn5Cv0cQf+vKnxLFPN+jf6Oot/XFd6H5+t20e94
/k+rwj8W9++m/2PY36bw2hj225kHMdy/V+ETMeh3P/MhhvrfVvhaEb/DvIhD
r28pvDMOf+1jfsTRL+8z4nhfs56rcfDHelckgNlPSwL1vqHwQALz38m8ScBf
NoX/SqA+zrc8ibzi/JuSyAfy05uEv8hfOInzyO+lJPKQ/N+TQr5bmVcpzJf6
+SAFP1BfWgp6fk7hP1KYN78nStN4n1Gvm9N4P1PPXWnwS71PpcEvvwdm0zJP
vyW+PYO83Mz8y8CPPP9ABvzQD+4M8pn1/pKBX59nPurwH/1wr/7/eVTr8Afn
tU3H/DhPuw7+tit8WMf8djBPdcyLfAV0+Id85nXMh3z/qWPe1MN1He8T6uXu
rOy/jHoyZzHvPQrXZ9HPm8zjLL7XqP9DWVH420P9O7O4j89nsriP+89loR+e
/3vxfNazmMV8WO+dBvTNfqoM8Ef/bzKQT5yPzcD3MfXaWXz+EvO+uJ98TBjw
F/nSDbwfye+vBr4nyO8VA98vXH9rDnnJ8ypy6J/8WnLQD/ltzkE/5Lc9B/3Q
b/05+E3y+x8touLF
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn1M21UUJQb9A41GQyKaiBgXgwubdVPED+abwzEmuoIfY1oXh9tkm0qH
siBDN+bIHJmDKZsWcQItozDoWlrKr1/011+TqQmamBiJhkQwcTEZUWPELPyx
2HfIPWRNoDl5791377nn3Nd7auurd12XlZX1beZPf8vHVz63uPWvVeuXUIWa
djsTy3ib2jTX3EVs1qrM/8PL63uuxapeeZyl7cv7G1SHteAlnm1U+0tzppfP
v6f+K3TcUiO4oEWlFwodxOqQmmvO9RHbWrF/G+MfUY4Oq5HYflQZ+W2XiWfb
VK6vfMfLgp3HNJ4jzjqudmc+rwjubFc50+6/iQtOqMz2Zodg/8eq2si//lXm
14H6GK+uE/ezPtspvV74ouArp/T6vmrm/wni2wV/9Km6u+1yFdftXTj/guC8
03r/IuPNntb7f+B93jPIh/U7P0N81lPyOfhiPVkuNV9l5DP/b1zqYK7va8br
7MZ+3lfzBfY/T3561HdTU1PM/48e6OE58vWlWpv5VApuOqv5vlRB/r5SGTm4
ywVn96JfT5PPXnW/o+OpDYKnesE/1219uH+j4K4+rY+OTeS7T+tt62bBjn7V
7XLdwXzMfujhWcEr3MhnC/vhRr+qBM+7oUdiuwf6Yf0hD/jh+bwB6J3xWwZ0
/m28f3YA/DwjuOwc8iE/3nPwE+u5aVDfv5p8OQfRf/Lx46DWr7OM/fbCL+Sv
xwt9rGf/h7TfS5XgnUOIt456GEI/SgUXDUPfj1Mfw7jvMcH/Dmu9LJRQL+ex
/ojg+Hmcf5j6GYHfHxJ8dAT9XEM9jYCfBwVXjmIePUB9jcKvqwTn+qCXIurN
Bz0Tz/hQH/erC/r+mdWCPRfAP+Nn+6FXm+BiP9aZT50f55lvtx/5r6Ve/Zin
rO+qH/yzflsAei0WXBu4lq+ugI5XST4vBrQ+732U+g6Ab+KVY7p+i/1wjEE/
7NfJMc1H+RPU/xj8xP7+M6Yy48cgXhGE/qmHl4Ka/9wn6Y8gzlM/0SDqp77m
g6iP+ssPwY/Uqz0Ev1DPR0Lgm3oPheA3+vdSCPOM/skbR785bzaP63pz6MeW
cfiPfvWN6/vOcn7NjqM+zrfbwrr+Es6/srDSX5ynB8Koj/PSG4YeOU9/CUPP
2+nXCczv1wSvm4Bed9C/E+D7dcH9E6hvF/08AX++IfgGA/nsob8N9Huv4L0G
zr9Jvxvwz9uCvzeg33r6P4J5tF/wmgj68Q7nQQR6fVfwmQjybeB8iOh56nIK
XowgX8YviiJfxt8eRb483xnF/YxvRaHPA5wnUcQjvi+G+7m/JoZ5znzbY3iv
eF88Br8znz9jiEc+CuLwJ/mqjkOf+ziP4tA3+Q1jfbqO8ykOPbA/dybA727O
qwT4JP4gofk4zP76E9Ar8W8J1LeT82wS/iHeOAm+iJsmoWfi4UnkRzwzifeC
8W9OYj+xSkKfzK8hiXqIPUncx/p+SuL3CevPNhGferzLRD/IV/ESJp9bTMwv
8l1nwm9vCW414R/2p9vE/exfEPsN6m3KxPxjv3830V/q4aqJ+Ue93J4C/1y3
peBfnq9IgR/eV7uEmd/BFPrBerpSyJfroyn4jecvptBfxv81hflG/V9JQX/M
71YLfqLeV1p4D5oEb7Dgj2bOdwt8tghutPD78H3Oewt6OCR40MI8beX8t8Dv
h4J/tvDet/E9sNCfY4JvTGP+H+f7kMZ73i64NI339gTfizT4Oym4Po351Mn3
I43+6fX/ARRNAN0=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9o1GUcx4+w/lhSFAdZ0FokscRECuT+WTyVtAwht2qbdVm78lpa7VzN
5rbUrS3n0t2pm3Zzzm13293mdt7v33f73vfAFlxBEEkx6BYkgqNCXIh/SPe8
x/MWB3K8eZ7v83w+78/r83l80tJcu/seg8HwQ+mf/FV/S+3GTZZ/nn1xVW0T
+ZXKxQ+od4raeHnvbqU1i3i+9PcR1z/G/ialRTP27+H+FiHP/0TpYqvYV1V2
+VN+f0D4qpfam5Wu6BTLNfHyfTzvkHjGbNdblN7cJS67bFWf8/xu4bZV9duU
3tEjnui99jPPL/aKYafz0b1K244Io6+6kfEajopSOC7m5+gXVqv1Cv2oOCbs
+krl+0r7j8t167uMzy7+qzTbqZscuG8X4z0h8xmlvgld/h7jPyleXWofpO47
Jf27l/ftGMR91OuGZP4Z6uKQkD+NSntPy3yeoradET8WCgXeb/pO+lPDeA1O
5Mf7F5yyHrd4vmNYlOxfoW44i3yoK0bAA/XVEVlvH8/zn5P+PEjdNgr/GY84
L/1yMp41Y6i3mX6OgZd3lC6Mgbe36e841ncqPTguOoy+7xvo97jMz1uvtHkC
fNbR/wn5ff1bSq93wb83WQ+XKG2/Vqv0sgv5vsH6uOEX94fdiJ/nr5sEn4yn
cxL+M/7iJHhhvlunpD9L9MM7dbefaz2yHq136utBP7Bff/HI+8rIs8mLfrAq
PeJF/e7wPy3z28t+/XAa+bFfF6bB12dKb5wBT+xXxwzqx369MYP6sj8bLqD/
W5VOX4Bf+8nPLOrVpnTPLPqhnTzNgv9OpbfPIb6D5GsO8R1W2uhDfF3kzYf4
vlZ60Yd8e8nfRVEqh+mI0u6L6L+j5NEPvvqV3uLHvDhGPv2ox4DSw35Z/5cc
5NUv8zGeVPq2H/U9RX4DMp/QkNKWAPg8Q54D4MWp9KUA+DxLvgPozxGlNwTh
5yh5D8LPMaUHgvBzgvwHkb9b6etB8DPFfgih3zxK14Vw3jT7IwTevUonQ5if
3L8cQnw8rzwMPcn+CeN83t8dlvHEXeynMN4HxnsljHk1zv6K4P7zSr8WkfXf
zvw7I5iX9McXwfylf8WIKJXTRn8fjqLf6P/WKOrF+uyPgo9B9mcU57G+v+P7
Taz/2hg0+XghhvjJjy2G78nXRAz+97GfYzK+f8nrfXHwSJ5NcfhF3vfEUZ9D
7Pc48vtK6Z/i8KeD/Z8ATweUfi4h5M+XnAcJ1OcLpU8nwDP7dyEBPrn/1qpm
P29MIn7qXUn4x/scScxHrutJvKc87wbWy7j+dArzjN83pJAv8+lPYZ4z33QK
/tKPv1OoJ+dFRRrvQ7fStWn41cN5lMa8+UbpaBrzi/Piahr8cV48lkE+33Je
ZeD3caUPZuCfnfMrA3/Jy58ZxHOC8ywLzfVXspg//L4ti/zJ10xW1u8w71vM
ot/J2wPzcj5UMz4xj/eH/LXMo3/Jn3se/cB8f8W6lX6s0ZAP+XxcA4/kc4sG
Hujv69rd/jdBN7I+XRr4Zv2GNbxvnP8hDfOc70NBQ7zk4y8NPJOf2zivnu/P
Izn4Tb05h/nH/dty8JPnWXKoN3nryCF/8jaYA4+Mby4Hf/k+Xcph/jC/P1bv
Y7/ezGH+05+HdPBG/jbo8JP+vqzjfWE9zDreO9arVUe+rOeADn9Yb4+O94p8
aDr6izz9puP/B+TtOu43cb7dn0e+fL/W5/Gecj5W5cET52NdHvzz++Y8/OX5
fTivRq7/D+HIE7I=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVm1om1UYDaL+qENRAtbBasUiVaYMC6N/Ilcd6qTg1h9zQhBau5FtSrNp
ZtfW2c6FdXVr0i3tlqzr2iZt0rTN8tUs33nzBuaEKAjDohS0gmOwojJWKfsh
5p5wz1gLbTnce5/7POc5z7nvC+2drfseMRgM31d+5X/149DXAo6/X32zinaK
Ja/VdJb4I/Gy2aEPKqy1S/zWANcPiKampphdYdEpTDVLL37D/UeEz2oa7FP4
d5tI1tnvfMXzxxCvR+H6XuFxu91djPe1qFny/mNTeFu/2F/5+YLxT4jWZN1j
RxXedVLIer7kfXbRYwy9e0xh6ylRgSvdvP+0qPzp61XYOSh+KJdbiOvPoB7u
D58VleP3GV84ZPzvmJ/FiXo/Z77DiHdY4fVh5NvJ/M9JvnOfKjxwXtZrPch6
XLjfonDtiIxX3sf6RmQ+3Z8oHBiV/WhqY70XxGFTzYfEzRdl/W3EBvfD6zfc
D593esTz9js/tSu89xL47SA/Y7h/v8K3x+T+3cw3fBn5s56ucfB3iPxdQfzP
FH50Qu73kh/LBOKTv/IE+HzA7yTik3/XpKjIdY16WJ8EX9STeUqs7k6Os5/a
FPhmvxu80Mtx9sMr9fgc9bvqhX772R8f+ke9x33i30azg/NQOw2+TyncOy1W
uo2vnWb/pqX+DN8qvGMG+Z5hP2eQ75DCm/zy/kNO9tcvKnQ3n1P4ph/xXOx3
APFGFB4LIL8L7P8s+u9WuGMW9V6iHmZFaa1xeUzhrUHM5zj1EUS/JxS+F4S+
p6iXOfiDV+HsnIxnnqZ+5qGHGYVPziO/APU0L96rEBZUuGVBxrfPUV8LmOd5
hY0hyVddiHoLgZ+rCi+HpH4bw9TfVZwn9gG3RajHMPROvD0MPyS2bFj3hKEn
4nIY+RD/F4ZeeN+2CPRG3B5Bv5ivq7pOfD2C86xvPQI9Eb8ShV4WqPco+kE8
FIV/ki8tinjk825U8v8UcUMM+iD/e2LyvtAs5yMm9dbH/ekY9MD7VmOYT+Zf
F8d8st5dcdmfJPk5EZfxDFHOUxzxiG/FwTdx7SLyjSn8/iLyIe5dxH3EIWBb
nPOH/YZFhZ9JQH/EOxLoJ/HRBOLx/gCwjfX8Wl1n/ZuuYZ38vHEN7xn1bQW2
Uv9T1XXOy83q+qTCjyexzvlrTiI+5/NgEvV4OO9JOT8uzvuPSeiFfmBIyf4u
0T9eT6F++ktHCvNA/xlNoR/0pxsp3M/vg/vYv8Lvg61p9Jf+93Ea80DsTEMf
xPqG/ffS8A/GeymD+umfezPwE/rnYEbq+xbzy2agB+b/Vwbzz/rqs6h/WOHW
LPg6Tz/Kol7ylcC6kXzezqL+UYU35+BP3N+SQzz68fEc5pPxwzm8d+T/jw3Y
mIff8/w7ebzPvK8rj35fVDiYx/cI/Xw5j37Sz58sYJ4v0/8K4P+KwkcKeN/o
574C+Kef/1wAnz76owZ/on63aOCH+t6u4f2gX3ygYX45DxYN+ua89Gv4/qRf
eDT5PVVDf4hp+F7g/JU18Ml5/lMDXwn6rQb/Tyr8bBF+mKb/FuG3GYV3FvG+
5ejHRfhlQeGe6vk8/bmI/vP8QhH88b7rRcwP8/mtCD7oR+tF9IP1Pa1Djw/8
XMd5+vXbOuKTT7MOvfkVtunoJ9/XIR18sX/+6n72V9PxPUU/+UXHfNJP7urQ
F/3kiRL8jfpvKGGdejSV0C+u7ymh39RnZwl6YbyBEuqR+vwfDTce5Q==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9I3GUcxyWsP2wUhdAKMqMIixWSEP5jPNWoFkLOP2rBESRrWPtDNzDW
NjYVbc62nW7qdu7m1Dv1PPW837/v/N73yixuxWjNGtK02BpMKqKF9Ef0fd7H
5z080OPF9/s8z+fH+/N+7smmlsYP7ykpKfna+tPf8snfqVo598fzrxRph1p2
tWbOkt9T7ta63iFho0k9a7O/OsjnH6ly3xtrZ4RViyqzNjjN9/ereEX37T7h
1Ta1r67sXTvXf6rWDpb7TgpXHlY2u3nnc+53VD9/oVe4ugPre7h/J877TLih
S1n/27t4Xje4U7j1mLLCPdjO84+rPdbniHBfrxp2OB4lV55QNTU1oaPC/pPq
UqFQ38H47Mif+zf36fjbeH51v65fGePb6Nf7O44x/tPKSrfquHDPGdV9e2ec
+TYMoN4nhLcO6vMLrNfqoHrCWsB6eoZ0Pf48xXzPKqu/NnLtOcTL9SUO1Ie8
5ND9ryP3Das3rQaQd51XjfGKe+/2y7n5+S3n5vX+C/r9bvKBEV3vm2R1Ucfz
AeMrHd0cf/Mo6sX8CqPoP/VUPabqypaf6hceGNP5lFB/G2PYj2wbhx6pV2Mc
ehsQftqFflHvPS7oj/Ow7sL5nJcGN/JzCIfdul/mMPs1gXo5hQ9PQD8X2L8J
5DcivH0S8V5kPyfVIatAY8JbpnS+rnH2dwrxuoWvTGEeJthvj453eVLY6cF+
HvZ/GnqbFt49DT3OUA/Tan1nfGRWeJtX/VNle9BHfXjhD/PCf3tR/wD1MoN4
gsLpGegvRP3Moh4R4a5Zfb4nSj3Nol8x4fo57J+gvuZQb3K5D/VIUm8+5M/n
Kz7MC1nN47y4sHt+83mlfvSf/JIf8834mv26nl8x/mG/rlcFueDX8baHhf/z
o7/Mvzqgz9tLbgrgOes1EIC+yIsB6J28EdD5XGa9nwvq/tjJtiD0Sj4VRH/J
RhD1Iv8VxDz4OQ8hxEN+J7T5eU8I+ub6ZAj5k9dD0Bu5Igz/JTeEUT/m0xnG
PLBe4TDqw3rfDMNf2K+tEfgP+/1WBP6S4rxFoC+yL4J68P3VCPyHeng4ivXs
9/Yo6sXzP4lCz2RPkdnva1HEy/i3xHC/sL8vx3Ae822NwZ9Zj/EY4mN9r8Sg
V87XfXHkw/mrjaO+c8Ifx3FfcF6dcdSL8/xtkb2c/wSY8/9iAuvpD7uLPCU8
lMB59JOlBOKj3/ybQD70o21J5O8Sfj+JetG/+pLK+t9OfzOT0O8o/SQJv6Mf
PpOCX9Evd6VwH9JPe1PwF/ptOgW9nhf+PQW9kyvTmCf6dWNa719LP+9Ko970
+2ga/eN9cCsNf+HzxzLwS+5Xn4EeGM+RDPZn/P4M5of5/pLBfqxHeRb5s36v
Z+E/rPeBLPrB/niz+P3Cfq5k4Wfs9wML8EvqQy3o+RmgnvYvIF7qz70AfVCv
V/F+OfVdamB/6v9xA/vf9UsD88z5ettA/zmPzQbizwh3GPCPBfqpgf4ZwiED
/Tbprwbq84XwDQP+ski/NaDPJeFHcqgPuRrs+FJ4Rw755enHOeiR5x/K6d+D
NTn6c07pL74/l0N8jGexuD/juZ7DPPD8jeJ+3wg/ZEIPBfq5CX+/JPyaCX19
R3830a/Lwm0m9PU9/d6E3n8QnjKhr6v0fxP1+1H4JxP6usb7wMT8rwjfn8f9
/zPvhzzm7bpwXR6/59d4X+R1fdp/FW7JY55u8P7Io9+/Wfw/y7wpFQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlm1om1UUx4NUP8yhKAWnYJ04pI4pw8Lol8pVhzoZuPaDTgiCZcrUD42D
ytyKurFiLbqkW9otXdb1JX1v07w170mf54l2nWTTYV3dqK6drk5anU4rxQ/D
3H84/xS28uM+99xz/ud/z+2j9Q11b91hs9nOFf7p3/KzUhvvOnXzyWeLtEM5
rdVKL/l1pdfJRr3Sv05z/R11Pp/fSVYNqi5e0Uw29qmadXN95IVGHX+otP9D
9dLiATd5Y5MqbH+vFO9j5EPeekg90rx8sZTPYVXuf/FN8q4jKrdaOc96FprV
E3bnc2THpzivk+d/hu89wq5W9W+l/V7yxs9V83Jt9UnhwBf6e/sJ5udUdqfV
2CG816V8jprWdubbBv3cwmttqqqqKnyc+R/T+uWPCbcc1/Uvt7Eet+r0eB4k
b2iH3i7W1456nMJDHaiH644TyJfxq09inefbPFhnvjPgedbj6tR617L+3aeQ
b0kfr5rrc9RQ3xte1Md+BE7r+iu6hPd3QZ8z1O+M1m+1W7isG/n0Us9uHT/T
J5zvhh791LcH+g8Iu3uQ3yD17tH+e2xY2N6rCnZ0jFD/XsQfFd7Up/175zj7
0acOFgzmF17BevME++PD/oBwxKfj/xlkv/pRf1i4qR/xIuxfP/w+Kbx9APpE
2c8B3J+Y8PpB6BtnfwdxfkJ4dlD73Uqy30NYTwl7h7A/zf4PI35GeM8w6svS
D8Pq7cLPlPCWEdwHg/4YgV6m8D8jur6z5N2jiGcJp0f1+VU5+mcM+ZCPjMHP
/P7GGO4P4+0c1/d9kecHxhGfXO5HPPJ+P/Tl/nm/Kvz/CeOrCehF9k2gHuZT
FkB88rYA7t+X9GcA8+Ur4c4AzpumXwPI56zw7eL+Gfo3CD3I9UHMH7I7iHq5
fzqIfpHXgrgv5M0h5E+2h/A98zkawnlkIwR/MP9bIfSXvCmMec16Xw0jP3JL
GPVSn2QY8ajnSlj7eR25IgL/sx+7IugH+3U4Ar3ot0gE84h+XML3NvKGSdwv
+vflSeRPfzeB41z3T+L94PrCJPTjfbk/inp4v7ZHMS94/z6IYr6U7mcU84fr
V6KYN9y/Pob8yc/E9Pzy8L46Yni/eH5vDO8d7+tsDPUy37vi6v3CAeTqOPRi
fe/GEZ/6eOPwL/W8EEe+1NuWwP1mP55OIB/2a0+R2d+O4vfs/0wC+tAv/yVU
wa4H6K8tSe0XJ/34RhJ+pL9dSfjlnLCVhF5fc54kUX9e+PEU9DnP+ZLC+3RB
uDUFP33DeZOCPt8K/5HS+S9d5PxJwz/fCdeltb6vzXIepaHn98LRNPK7xPlU
3P+D8EMZ6HOZ8yqD868If5RBPfOcXxnMgx+Fr2Uw737iPMvifbwq/EIW3y9y
vmVxP68Jj2Rx/3/hvMuif9eF75mC/kucf0Xm+r4p9I/7fVPQ+2fhS1Ooh+eX
GXpely8IP2xAP+a/zYDfWO8rBvpDPfYauG/U75CB+UB9Ow3MD/YjbMAv7F/e
gN7s93XEt9Eftw34j356wFSFdJ8ibzWhF/21w0R/ub/exPxg/IMm4vF8t4nz
6Z9xE+8B/TJt4u+VOeGrJvrJetdMzBPqcZ+FflKvzRb0op7PW5hX1NtuYZ6z
/40W5jP7d9SC39nfQQvv3a+c/xb8/ZvwZQv9WuZ7YOF+/S58dw5+uMn3IQf9
/hKuyeG9usX3Ioe/Z/8Wbshh/pJbcvCT5v8B/ClAoA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1MlWUYx88a9sGcrcYWukm0WCNnzcnm+IK7SxfZ2EI+mG1nbTFzlB84
uuHwZaYOFrEMLLQOkfFylCPC8by/cQ7neZ6jiHp8jcQXSvCFSCgdgRG61nP/
3f1nhw3Ofpz7ue/r+l//67qfV8oqSj95xmKxnDF/5af6mT/Y/vDygzfeekpr
xc5MV9HP5A9FvTHtHFCslYl3R3ZkXuX3nwqHrbBuULGoEKXh7HnXuX6r5Job
iocr5fr5Q3x+u9yv8VfFObvkeXm3uN/nomZ8XXhY8fK94mXzH7e5/z5hbj9+
R3FJNeK5x/NqhBnum78rtn0hzL97xnj+l2KT+UNuqEvnnK+Etd6oJLv3iya7
3U4W9eJ8KpUilzcgvz8Y7wHES545IApNwcnaN8JVNDJLrv0W6+8zn0aRn5/v
I2cdFI/yrM+PM7+DMv/NZOch8boZMNn2Heo1objge5GczrOSLXbkQ+63y/qf
Jjc0QV/yhh+kfpY/qU9zOo81p693/4h4yFWHoT9Z/IR6kzNaUG/GX94i888n
p1pk/vXUY3mr2GIKSv0aW+G/Ob1bxcS6cDbrY20D0w9aG+o1qji3XZj2H7nL
erTD//TXBL7/mP4rceC8EcV+B+pL/2YdQfy/Kd51BPnR/8PggpuK1xxFvdk/
zqPQ55riBR2oF/vP1oH4f1E80CH9tIP9W+BEPdjfzU7Ef4n1Pwb9LijeeAz+
O08/gC+fU7ysE/45S390Cjk/+hVPdaL/TtMvx5F/n+LYccRzkv7pkvsNJRVX
d6Hf+P1YF/I7pbi4G34ju7vR31yf6YK/uF+VC/UhD7ngR4P+OwG/83vHCezH
/TPcqD/jXwnOY77lbrnf2+QmN/Qjp9xS3w/I/7nRj2foXw/8TD3LPLK+i1L0
s0fG42I9+jxy3hRfpL89Uq9p1nOpV/r78BX63Yv1nN9fe1Ev+kXzQi/O70kv
/EO/5foQL3m9D3pyfa0P9eR+UR/8zPMmfJhv9F+2H/5n/CV+zC/mt8+P/qTf
/H7Uh/qNPl3PemQFMA9Z//cCqJfOfguIwXZbYUKxKwB/kocD6AeufzEIv9IP
a4LIl37YFkS/8HxnEPVhfDeC0JP1XBBC/VnPVSH4h/1mC0Ef6tEWQr9Rr4EQ
/Mp6PhtG/nP9HYZe1PuzMOIjN4cxL1ifC2HkO3d/R5Av67kignxZ740RzEPy
oYjUM8751B+B33i/z+L5Gs6zZVHEy3n3URT9wfu+IQq/cD4aUeTD+TkVRTy8
/1/rkffzKHlDD/zB+VvXg/nL+RzrwTzh/P4L64s433NimC98XyiNYT9ydQzP
834IxtCfvD/GYvAbeXEc9eV9UxxHf5N3x6Hn3PtEHP3F++p2HPOHnNkr83mV
/E4v+p3PV/VCf3Jnb/p9N4T1lYxvYQJ+Yj4ikR7v1gT6g+c5EjiP9+3VRPr7
Q4YGvXj/L9FQzweclxrq8VDx+xryneT81HDe34r3akJ+THOeaoj/kWKfhnnz
D+erhve1fxXf06DvLOethnifKH5Jx/x5zPmrw09cv1aH3uQyXc5LG/ffqeN9
b4bzGfsVkLt1zAPG16ejv8i3dOjPfGZ0xEd+wUD+5KUG3geox2oD/US2GvAL
udLAPJnivDcQL7nDQD3ImoF+JV83oCd5Es8Xk59LIh9ybhJ+Ixcm0a/k9Uno
Ta5I4n2f+dUmoa/U738IRVKU
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9MlHUcxy9DKyRNuxX2g3CwRq4aq83xD+1bucrGlvKH0nZrixWj+gNy
o5myQgeLWAkWWhAZP+VAOA/ugOO4g+eeW4h1WhZJGiVYGgUpEWdERT3f9+3z
3mAD9trzfT7fz+f9+fVszC3IfnGFzWY7af3q//Lzamb8zmtXH3g0RlvV5B67
a578rKqtqdnwh7CRqzLjx5p+5/OX1H2OysdmhVWB0v+u8vwuFY6mjf8mPFGk
7imbPjPD919XeXl5l6eFk4vVU5YDZPWmsruefP5X4fR96lQkEvmF9vdre9vJ
20qV5d7sFO8rQzzkwrdwP9n2tnJUmkW0X1WhZrb7kuhf8jtqr911gv6739X2
CxmfqsR56pFfBftz9Peg1qOEei4cVA9bP9TbeA/x/ylc/r7Wu+YvxlON+P4W
Tjyksn1JK/9lfIeU5U5wSdh5GPHYZiXeD3DfCuGMD5UvqWz6emFbjao0o86V
wiM12p+8G4SranW+U24SzvlI52MyXji5Tsd/JEF4qk7n27FG2P0x/L1ZePcR
nOf76hNlhZdxo3BcPfSjP/n10Jv+RurVtTTH2uuE0xt0fB7GX92A+/+h3g24
f1HY0ajv81Fvo1Hr8UpUOLUJ8bLey5sQL+t7Bs+brjA/zfCP9eJtRj+wnhJb
0D+st+IWZZlbvMT8tcD+j8JbjiL+SebzKOrvgnBCK+r/e9Zzq7L6d+w74dFW
5PeccIYTen0rXOeE3mdZ/23wf1T4hTbo85XwSJtqLsyMPyN8fzvq4wv2Szvu
PyU8D94ZEc45hvr+TDhwTNurOMn+6oBeI8KlHfD3hPBUB/T6VDirUz+vJLs7
4d+wsN2lrL8l5N0u6Esed+l+yaR9dRz+kJuPQ19ynFtBBuHNbj1PHiTnu6EX
46l16/ezPheOuHE/9Vhy63j2nOZ86EJ9fCmc2wV71Lu6C3p+LTzcBT2Yr4Uu
9BPzuakbejLfju7l9XCgG/qxXoxu1Bt5rhvxkVM92p55XniHB/OJ9ss96B/e
7/egHujfTIzpf5IX/rC+tnkx78n7vehfxu/1Yr5Rn8te1C85sQf5Yj0+3QN9
ycU90IPs6kF/kyd6ML/J63v1PEwjb+lFPsmv9ep5UkZ29i6//3zsffqX0Kfj
qyY/0re8nwpjz8mNffCPeoyCm6jfKh/i+4b97YN/Y8Iv+/A+813n0/sgyvyd
xvnIOPu/H/Z/EH6oH/tjgvOgH/YvCh/uh14/cT7gfJTzbBHnIz9zXvhRn9zP
z/lhn/u9yg/73K+mH/5zv87jfJTz994B2Od+zRmA/9yvFQPQh/s1gPNZC8JX
cD6F+yA5gH7ifs0OoB+4X0sD2I//CfcGlPW3hPtnKoD+5H66I4j8c39lBfV5
G/fpG0H0A/edO4jvE+7Di0HUF/epfXD5Pn1iEPv8Fu7TQdTTeuH2QcybW4XH
B6EPn68ZwvcY31dDyOda4V1D6Gfu6+Yh7J/VwmeHcD/9jTOgD+O528D8YLyb
DcwP6vGMgf0Rx/1uYP5Rv30G/KO+tbDn4veMx0C/MB8RA3px/1+KMfO3FDvP
74HbQ7DP5+lgB+1tjT3nfbkhfH/y+2lvCPuM/laHoBfj6wzh+3OV8HAI9Uh9
LoTwPUL9FkKYx9R3nQk9qP8mE/oy/4+by/PvMJGfdcJFJuqR+T9gwl+7cKsJ
f24TNkzs20ThcybqZYPwnIl5e6fw6jD64y7h1DDymSScGVb6X7LwjjD2xUbh
gjD8TxEuj9lLtfh/ay4yaA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcxy8DKyRNuxItEZMMSe2SxahFPZYLbWwBf5htt7aYNao/uNxo
hqzUwSJWgkUWRAYcyIFwHtwBd8cdfO9uM9uorc3FapRgxWiQkokjKuqe9+3z
dnebstee5/s8nx/v9+f73VRcWvTyMpPJ9FX0n/4rv8ly846/r2zfFaO96rDZ
mfcP+QUVmc+w/itsFCtvatXrS1x/VTnzJsv/E1alKvr/EdOc7D+oiqIP3CQ8
UQZeJmx6C/tvFk6rUNbacFmCsHpHvRL9JQpbjqqNVTOFy3n+MRXFnFuECypV
Y0PDult5X5VKGrPPkW3v6vy+vI33v6f3NyQJ19WoaPovrWA876vcpLHNycKu
D/T6JFnV4vnbhUvqUL+VjPcE7icvnFB7JsvrVzH+D5Wu/x3C1R+prdECkAvq
1dejo/mrhVM+1vl/S54AF64RdpzE82TbJyor+rtTOOdT3E82NSA+8vkGNWa3
5ZpZj0b0l7z/M3U9w7qKnNYUH890E/TB/Fyfq9lCbyrzOXQK9eN+9YVeP8X7
E5pR/7tYz2bVZsutIY82Ix6ypSV+f30L4icvtCBesrUV8TJ+o1Wv15LT7fH5
V9sRL+ObtUOf5II2redEsgdcxfqntOt4F5lvRTv0fKN/7fH93n1a98dMdpyG
/1jP5A70j3qydUDP1N+FDl3/Geozx6HwmHCTA/Wgvk2dYOr/QCfyoT/Od+p8
5+mvbV3qjagh6L+6LhVddtCf17ri/bv/DPxJfwfOQG+cB2nd2l92zovKbviH
82S6W9drivMnvwf953xy9Wh9JHF+mZ3o51/Ch5xYXxAed6I/1zmvziK/a8Jt
Z6GnP4UTXKjvH8LZLvh1TrjEhfsuCze6UP9Z4VE8nzcjvORCvr8JW3rRn2nh
4l70e0q4vlfrMfiL8Lle+Oln4YVe+GNSOLMP500IW8FHfhI+3gd9/ch53of+
kK/2Qe/jwulunEfe50a+3F/thl8uCvtj+xnPrBv6viSc6kG8zKfAo/X0PPM9
5sG8ZT08HvSH9Zry4DzWM6Uffvhd+Nl++OuKcEU/8mP/nP3QO/s70Y982f81
A3peuqmP3QOIl/p5cwD6WBR2YH8W9fgD9ifx/Zg8iPOp5ycGdTxe6t82iHrS
H62D8e+7C4OoL/233Iv+0Z85XviD/n3NC73c8Ls3fl5848V85nwx+XQ9n+K8
2unD+5Pz74APfuX8POmDH9ZyPvgwv9cJL/rg/3s4L/zQ/wbhF/3Q70bODz/O
TxMO+9Hf+zhP/Ig/XXjLEOqzhfNlCH7MEK4Zgl62ct4Mod4PCl8e0vfZtnP+
BFDPh4SLAkr/4XplAPMuU3ggoO9z8r7pAPrHeNYHcT7jzQ9C38zn7SDqzXxd
QegzVfhSEHq6V9g8DF4v/Mwwnk/h+3QY598t3DWM+rN/48PIn/1bOYJ42T81
gnqyfwdHoDf2r20E9WH/vhvBfGO8CQb6xXw2GPgeYr7ZMd4s/JyB81ifEgP1
JB81MP/uF240MA9YX7eB/jzA7wED8ZB/jTH7s2TE62FtCP6nHiwh1H+b8N4Q
/MH+F4cwr3cIHw7Bb9RLfQj9eVi4J4R5sVP4XAj+zxK+GEL/HuH3SQjvz2zh
1WHUJ0c4M4z31aPCT4fxPfEYv2fC6PfjwmXg+Vzh47H1J4U7Ys8rfv+EMe92
CX8fxnzj/qu4P5HnrYjAj7w/PQI/M97c2Drz2xdBv5h/aQTnW/h9FYE+db3/
BwP82jU=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy+HVqdp2pVoiahkSGiki7EW7qOSiNIE/rDabm0xYxR/QG40
Q1boZBkrwUILouKnHAjnwR3HAXfwve9tRhu1tblYjRXYNAumRGJERd3nbc+b
cRvcXvt87/t5P8/zfp7PZ0N2ftYriywWy5fhP/0tn8aCZOuKya277lCaCnPZ
cvKLKtk6vIlsZKv1pePf3Mf1V9W+saJKsspX1uGGArJxRNmcqS+TRwsXsuVN
5UwdKyJHF+v9Gubf97YKTceOkBOOq3JzOnZezwkV/l9CzjipfFGl4+TRUuzH
+AreUTk5Odfm431X2cvNwvuFK8rU7Vj7ipXU854qHc/0kV3v69/nrKK+cjWR
6Yt6QDi3AnrJCWcQj0145gzy8yD1f6C22Mt3PyR86kNVXVW1ZjXjqdT6psmR
Z5H/SMZ3Vo0V2ZxrhB3ntP7ytYz3I52PvIeFkz5WXw0NpT/C+KtUVvgBrg9W
od58X0W11mdS3wufaH9YqT+6RtffRr5eo8LhJZNdnyL/5KOfod5k9Tn8Ro6o
hX5ybi30MP6hWtSP8SfUIX7GW1mH/DK+mTq1I/yJErbX6/1n1zP/9VpvYINw
TAPyvZH1aED+yBMNyAefz2jU/rOQPY3wZzTr1YT6cr/iJnUsnBDqGW1CvtYJ
p5zH76nfcR75Zn2WNet8jrE+Bc2In/m43Aw/M19JDu3fJNavxqHzM0k/Wlr0
fg769XCLej3Z+jz9Pdii/bGY/o9vxfPsn4pW+In9dqsV/beMfrkAfy0V9l+A
v630Txv03yN8sg1676af2lCfxcLp7chnBP3VjvVFwjYnfn8X/eaE3n9v/s8j
Tvh1TlhdhB//Fm68qOMfnhWOcME/fwonunS9S/4QznXp+IemhatdmB+3hIew
nj4lPHfn95PCCR2I/4Zwdgf6e0K4sgP1+lX4Ugfq8YvwTAfi+Vk4rhP5vSps
78T6T8KnO+GnMWGjE/3wg/BUJ/qLHONGP44KH3LDr1eET7lRb76/1633r+L+
E274nfqiPOiv68IZHtSH8Z3wwH+M3+OBXubnmgf1vikc2YV+/014fxfmxe/C
xV2Yx6yHswvx3BYe7YK+GeFVXl0fC+uf4tX1d/8l/IYX8+AfYYcX+9Ff33ux
n4X92o3zkf7c2a3rm0n/FnQjviXC9d1azxf0/+Vu+OVe4SU+5J/9lORD/dhv
r/mgl/1Y40N+eL597dN+28b+tvSgfuz/7T3wI+fvYazncZ6c68F84vwZ7IFf
OH9nse7g/IrvxXnJefdS78L5WNGL/Tk/Taw7NnGeYD3vUeHNfdD/GOdLH/oj
VrisD/HHcd70YR7GC9/ow3zYxvnjx/ueEM7yw78JnEd+zIMnhb1+zLPtnE9+
9Dd5bQD14fPp4ADf/1YA/cn9XYGF+q4EMN+p39aP83OL8N5+9D/jPdqPebFZ
uLUf+zFfI/3wY4zw8gHcV8hqAP3AfB8ZQD7IjQMLz8NvB1AvcoSh9BefX2cg
fnKigfi430ED+aLeXAP9w3iOG/Az4602EN/jwm4D/tjK+wD2L2F+rxo6Xjvz
P2dgfu8QXh1Evz3F+0MQ+U4UTgvivpcknB1E/z4tfCwIPz7D+0YQ59FO4fYg
6quELwWRv13CPwZxXuzh/SSI++GzwitNnEepwnEm5mGa8B4T9TnA+4yJePcL
F5qYZ/uET5vot73CzSb0cH/DRP52C39nIj8pwlMm+oH6lobwPuqLCcFv3C85
hPlGPYdCmA/Umx/Cfs/xfhWCHw+G+T8Pi+vn
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn9M1GUcvrXqD2q1GltYEzGpkKmRt4xaZ69KIo4SsBDrsrzQUGtcbjRD
VuhgESvBQgsiA+6QA+G8Xxz3+773vc1su9raXKzGFrTl3GSNOW3MP1zf97m9
z7rb4Hj2ft/Pj+fzPJ8vq23NdQfuMplMPxk/8vt/n/YVS+u3ZP+sEmutPVsf
I94r6kKF96xUWLPJc72Q54fkeWeRwqIZ9x/n80eF/CpWeL5FzDrs8Sd4/2Ph
rlxofUrhojbReb22fC3jfSqMdLdKFS47IRZa893rGP+kMNIf2aBwTYew5M2u
KWO+TpG+VTL3jML2z8SOhdY+M/N/Ln7OZKqfVbi3G/0+x3q+QL3lCnu+FKuM
Ap9nfT2yng18vqkX9xmv7LR8/teNCi+fFgP9/f2sT/sK8Vh/19fCabfksb+a
PuQnHwVnxEHjQ77mz4h/S6wPkk/XWfBD/u3foD/Op/xbydd1ztPUD76IL/fL
edwm7h2Q9zOcd8N34G8V+RkUH1ry9jD+tUHUv5p8fS/MZrOf+Ng51MP6xA/g
h/juIehnDfkcEou1oXPEmSGRbxRIXDYMvqmvvmHkJ14ehn74vHUEfBJrI9AP
cbEDeibucqBe8rvokP3nk/8aJ/RVonDAKfl0UK8Fo4jPebaNSj7MnPf8KPh+
WuGK8/AX9eo6L+fbQ73ePwa+qS/7GOZH/V0Zw3yp13KX9FPoBYUHXejvRc5/
HP1tVrhxXOpzhaAexqXerm5ReN0E5rmN+pgQxu/2lxW+OYF4ldTLBcSrUjh2
AfF2Uj+TiFetcMck4r1KPU0iXo3C1VNSD4V11NcU+t2tcL4b/b5OvbmlHrr3
KDznBn97qb+LwpBHyZsKOy9CL1bq0SOO57t/3KfwJg/0/w716YEfbQoPeLC/
GqlXD/R5UOE7Hpl/9j3q1yvzuw4pbPPK/C1HqGevzF/5gcKXvPA38bIXfnhf
4VIf+Ca2+uT5fsY75QPfh6l/H/RMfMOHfcx6iv3CkPNSk8L1fuiZuCt7zn4i
ftwnXvRjPxEXBuAP8lETkH60EJ8MwE8H6KcA+CC+GkA84oJp8Ee+d04jHnHb
NOb3rsLuaeiJeD57zvk9HIQ/iSuCmPd+hT8Kgm/O3xWEHon/CGJeb9OvM9Ab
9bM5i9+if2dQL/U2MoP+qMcrM6iPer03BP4b6O8Q9Fqv8OGQnIed+h8MYb/S
H7+EsC/oH1MY+qC/NobRL/3XGM7159kw6qF/L4fxftih8O3s+Xbuiwj2bYXC
+yKY11bujwj8yX2jR9Af99HNCN4H3FdPRqFv7rOGKPzP/dcdRT7ux1g0d3/+
E5X6snK/FsVy929dDPd53hETxu923g/GMF/GvxbD+4b5H42DD+7f6jj4ZL2f
xDF/9uOJQz/s96849uNL3GcJ8MX9uz2B+XL/Hktg33D/TiTQD/mfS+B9wvk8
kATfnJ9I4v8PzvdoEvxy/s4k9L5L4d+SqKeW+1FDPdTXSg31UH+bNMmfift3
lwZ+qN8mDfy8ofAJDfOhHwY07Gf6x498S/RXBvlC9OffGvYP8Z1sPPrzkRT8
zftlKfBFP1bh3M/8thTu04/HU/Ab/diXgj7Yz1Qq14+XsvfJx5/Z+ORrOfs8
+XxIR7/0Y6mOfcV5bNMRj/Oy6ni/vKJwi4558flTOvhhvDEdfqD/NR1+e03h
33X4jfXf0KEH9ndfOrf/4jTmSX4saex38lmfRn3kuzkN/ZPfrjTqk/H+A/wE
76Q=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn1MlWUcvWvWH+RqtbulbREt18hZY7U1+sAelUSMEqgQ62ZBaKQVV4pC
IAOCSUzhUqhdIuXjIheE6/3g43LvBd773i1po7Y2l6uxJW05Nl1jThvzD9f7
nLvfabAJOz7P+/x+z/mdc973kdKKwn132Gy2n6x/+q/82H05JW8sP7EliXJV
u3nT+zrxHpW4mb7wmmCjVDmsDYVc/wC4QLCqwP587q9UizV23y7Bl6vUfuvn
VT5/WHmcWSmvCE6rU11ut/tlnvel2mEdsFNwRoOuV7WD5zeqWrvvwnbB+U04
7yXWa1bNVwsytwl2HtX9Obaw/tcqnNp88EXBrlaVcqnfmcV+jqHf5wX7j2P9
OfbXrrJSLj36guBylzpk/Qefz+jQ/bTy/JUOpY9nfeMbXf/qVsEt36prBeHT
2bxPp/p5fj6P91t3QvlyFm/l8H4ndP3+XMHek1gndp7S80wnX5nf4T48z+bW
/IRZb86t66eSL1cX+mG/xd+rp60fRX669XlXNgte6tbrId7f/wOeJz/Vp6Ev
8qnOgC/yuaYH9YnLe8Dfs4Lne6AH4oxezed0puDOXuwnXumFXogdfZqfGmKj
D/0Rb+hXlh8WiVv6MS/Wu9YPPRPne7DOfsc80D/xugH1b7qjnfetG4D+yMfl
AfBJvrLP4v7k03tW+2E99bN2EOvk3zmI5zmfi4PqYWug1FOmV1m/6znPbi/m
w3nbhrSel+mXsiH4hfqaGwKf1M+mYdyP+nIN4/70641h8JlHvZyDH+n32Dnw
zzxIG0F95kXTCPzIfFkagb6YP3mjWGde+UfxfJFguw/nF1NvPtR/U/CCD/ny
FvV3Xs/zybcFe84jT/ZSj36th5J3BT/jh79KqE8/zntPcJcffOyjXvH84n7B
t/2q0LpAOfUbQP0DgksD8MNB6jmA/R8J/jEAPVRQ3wHMwyl4YxB6q6Teg+jn
U8FtQfBVRf0H4cfPBV8PQp+H6YcQ/FYruCik82i+jv4Iob8jgiMh1KunX0Lg
q0Fw6hj09xX9M4Y8bRbcOAY+jtJPWF9uEXwF675W+msczx8TvHMcz7fRb1hf
bhfsG0f9DvovuU58/4Syftdzf/aEvt+dxwV/NgE/sL43uc7+/kg+z/usncT5
jYI3T0JP5Mc5CT6/ENw3CT+T74uT0Fe14LvC4JPzywxjXp8IPhBGnlMP3WGt
h3s/FvxLGPlPfdmmkJ/U41NTmDf1WjYFv1HfJ5P76Ye55H765VZyP/21KaIe
twKYftwbQX7Rr64I/Ep/m5HV3w83ItqPOcyPx6KYH/OmOIr3G/OoNQp98P0W
i0KPzLt/ovAj8zIthrxivhbGMF/mcVMM82F+T8TgF+b7Ugz6J35wGv1yf960
5qeTeX9kenW++7H/Auv/NQ39sD/7jOZvK/N7+8zq75vqGeQF7zs8g/6Y1wsz
4JffT/fM4v3AfFaz+H4hv5Wz0Bfz2YP9v/L77rdZnM95rTFwf+bxQwb0uJt5
aUDPewTvMqBH6qPcQL47BDcY0Av11GVgPtRbyMD7vJT5amBexH8n+6Febxv4
fmIePxBHfr7P/I1DD9R/bhz6+T+P46j3oeDaOOZBP3XGcR/6bTSOeRxiXsfx
fUZ//hlHXtG/K3Hok/l7n4k8Yf5uNMF/jeBtJvhg/jpM6IF5UWUi/5gXbabu
ZzfrDZrQA98Phon++D75PVmP972e7Id83J3A9wH525AAP2WCs7Ae5vuxKKGs
3/XvCK5IoB+utySgDz2v/wBLVwDx
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1sU2UYbYz6YxKNpolg4pyRmEnUNC4h+zPzikZEp2xTx9AKUkcdoK5M
h2ObsM1VxoStgw7tmLitHesGlH5/t7ttE5xJNSEhEs0SwcRlCcQQ4szCD2Lf
07wnKQklh3vv+zzPec459z5pam3YfY9Op/u58Ff+q/40RMvv237ruZeKaIuQ
v+8Rbwd+X2HNJOT9Rl7fI1yWmrIPFBatYszhWLeD97eJ4exK5U6Fr7WLq05L
zYd8/qB4wnqjfpfCFd0iWm7dZ+J5h+X5gx8pbOgV1zv1nmae3yefv7xb4bp+
4dl8/Y6Z9ayipuzqUy0KW46Im/XRcmLdUbG/cAOftw2K/yqNw6xXcUz8ks/X
sj/vcczLecSw6NJ7fiIfLTY8T/4MI/L8bU0Kr46Aj0b2fwJ8vqPwwEk5/416
zmMXuZXKxa0Krx1Fv29yvlGhLwz8hsLuU+CT2PId+KhVuPp7yYfzLc7vwHx1
Ci84ROHyLda3jcl9Ot5WuOm0KBxf/S75Gcd57H95HPvl/d4fSufpOIP9sZ74
EXxxvnsnsG/21zIh+XJz3vyEMJvNS5zHMCn530xsn5Tz5Dn/6qScv5PYOFXK
jzaF+YnXO6E/4gEn+iW+6RSvFf6D9epc4Ic46AI/7HftNPgk7p6W/KQ437Vp
8Mf5XzmL88iP+6zU6xnyt2ZGVFVVBRq43xnogXxfmYGeuJ9qN/ZBvY27wcc2
7n8W+qU+m2cxH/W7MAs+6P9n58Av9W6bk/w8T7//O4f+6Y+mc+iH/kmeE8bh
bDv9XXEe+qDf+s/L/Zrpx2XgJfq59gKu079e4KU9Cus96Hcf9eaR9VY+UXjR
Iwq/PZ9Rfxel/h6yKOy6CL73U49ezPe5whu94pnCgV9Qn170TzzmlfuP8v68
V/Jpb1P4rhf1eb7BBz5Y3+TDflqpZx/8wX4v+dAPr6/6UJ/Pb/BDX6xn9ON5
9jfkl3mx6wD175d6qupQ+LYf++qkHwLQV5fCjQH48Sv6I4B+DyscD8BPvfRL
AHn7tcLlQeyjn/4JQn/fKNwXhH4G6Kcg9jmo8FIQej5Gf4Wg1yGFXw9BD8P0
Wwj7GFHYEwIfJ+m/EPgnfiQM/47Sj2Fctyt8IIz5eb87jPfPCYX/CMPvrLcm
An0RvxhB/tvo3wjqsd+pCPKM81yJIK+OK3x/VL4PjJy/Ogo/fKvw3mgpX+NF
fFThX6OyPwv51cUw3xGFX4hhn9xHc0wUfnusCp+KSX1Yub+FGPKa+70Tg977
mBdx+Il62BFHnvYwP+LQK/WTjYPPQ8yTOPRNvT2dgD6JmxJ4v3crPJiQ/txE
vSYT4Id6/ieB/R9k/iShD+q/IQn9fMk8SuJ7hjichL7pn+Uk+GhX+LFUaT7U
piR/OuJDuL6J+eBN4Xn69a8U/MB80KehH+JX0/ieoN870uCXeTCXRv/Mi8U0
8oL4wXns+1Pm3zzmZz62zeN7gfnpmoffiH/D9c69zEcN7yPm7+Ma9sV83qiB
P+KtGub/mPmpIY+Y770azmf+j2nQF7/3Alrp91legz94/W8N8/K8u3i+jPUf
zeB7if0aMtAf59uSQf6QH1MGfJHfrgzqcR/2TOn74UIG9aiHSxnsg3r5s1iP
elst1qM+H86iHvW8IYt69MPLWfRP/Ruz8Devt2eRJ/TXUBZ+oR9ncN5l+lXL
Qj/09+/F85gHt4vnMT8eyOE85s36HM5jHtXk8D3D/GrMIW+Yd6056Il5OZAD
XzJf/we6egxl
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9InHUcx4+Q/rBYFEIWZEURFmtIB8N/Lr7VaC2E0j82V9eo22buR+ks
l1PbTvOas+ad2+l2zjn11DtPvZ13p95Pfe45WAuuIBhJMWgGjcARY7SQ/TF6
vm/5vscz2I0Xz/N8P7/en/d3zzsaavY/ZLFYfjT+yn/VnxV/o63r9qtvbNAO
4VqrrvyGvFuEt6/e61CsOcR/5Xa3k88P4PlxxaJBvGx3v/k1328SxUaANsU3
moXx6zzG74+Bv1L8XLtIlLkONfO8E6KtJLz9C8UVHWLQ53vqCM/vFHV1dTc/
V/x+l3Drd4OHGc8ln9cdVNx4UhyxFe86wPinRI0RkM89PcJIN3uI+Xwv7MaB
PC9yWqy2lmxhPOFGvg2K6z04j1zRh359pni9T+bv4/naGeTLfLrPIv6nrMcr
nnWt/bJfcWm/7OftvayvX7xjJORQHByQ39s+Zr3n0P89iivPy/zDdtbvQ30f
KL7qEz8VClW72Y9BvL9Lce0Fcas6UbaT/RkS+bvl18l/D0k9tNayXxcxL57f
Miz1lfiQ/buEeXykuGgE9THf+hH0k/UURhCf9VaMCqvVGmM/vKPQH/u1Por+
1Sm2jwlDTp/Us/9jcn5r7P+LftmPZs6n2w99c/63/ML4dT7Q27hAmxXHwU7q
s3QC3zcpbp/APL7k/CagX+p92yT6wX0ITkr9/9Ci+NGArNfayvkGoCfu17UA
4rVz3kE5Hzv3cyiIfp3g/KfEeKOtmPu9bwrvd1IPU9An/WBzCPOhX3hC2Idv
Ff8bwj6cpF6m5byGuxVnptH/U9TPDPrF97tmoDcX9TSD/jB+1SziMb/ILL6n
H5WEoUfW2xKGf9CProelPnT2S1zGc/Zz/DK+Z7+LIjif89gaQfyj1GcE8yIP
RtAfvl+IyP720O/uR4SteOUFxq+Yw75zXo4587y8c5gn53VlDvPmvNbnzH79
ShT5cz72KPLnfHqjiM95aFHoi/O4E8X8vuM+xKR/PXZa8c4Y9NPL/Yihfo/i
VAx+0sd9iSH+WcVlcejJy/2Jw7/6FXfG4V/keBx6Id+Mo5/k0nn0j/zuPPpF
bsdz24Di8DzOY/wb8+bzn1gwx9+2IPO3nFN8dEHmX36e+wkOkn9fgD583NdF
+B359UX4Dd9vXEQ88tgi9M941/B9JfnhhMx3lfVUJuQ8/eSDCfgleSgBPyb/
nMB9RLYkkR/5tSTmR96XxH4w/kAS9ZKvJuHHzP9e0tyPzSnUx/r3pKBPsieF
fAYV6ynEu0A/ScGfhhS/lJZ6WyHXptGvi4p70tDHMP0mDT1fUvxPWt4H1SP0
nwzyG1Vck8H8xuhHGdTnV7yQwT6M058y0MeE4qez6B+5Kot5TSo+npX3ayFA
/8pin4KK/8zKffBO0c+WkH9I8dtL8P9p+tsS/IYcWoLfztDvNt6fVbxpGfHI
Yhn3c1hx0zL8hzy+jPuQ/Osy/j9FLtKwD+RnNPP5WzXMj/zexvvMr37jOfPv
0KBH1j+I86zsT0yDntnPggY/5Dz+0qAnzu++hv3mvJ/MoV7qoyKHeNTbjpxZ
r44c9MV9aMvBr+gf3hzmQ7+bzZn98UoOeqCf/oHzttBv13PIj/78uI78H/i5
jvx4v72l43uyXUf/eB826+b7slfHfcf7NKBDH7xvNV0Yv07m85uO+TPfO4hf
Sf9/JI/63bwf8tAf/d+Wh77P8L7Im/2+IW/2p+486pd+8T8G6Rip
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1om2UUhoNMf9ShKAWnYJxYpA6V4kD6J/KowzkZ2PbHnBAEyxzT/Wg2
rXZt3drauK5ua7ul3dJ1Xdv0I/3K8v3d5M0b7TrN1MGwKANXwTFYkTGclP4Y
5rnDuWGBtly873Oec+5zzp0+X99Q98lDFovlcvFH/5XPam3ceurOK2+WaIey
lS2/0Ef+UP1XaX+8V9ioV+W+7Ssn+fxTNeh2u08Iqwa17HHYjvP9g6ql3Hep
W/hGo3rJ3vPWMZ4/pFaay31HhTe3qnGHrexbxjuinnPeru0UrmpX7640uzoY
vwPx24RrOlXZsufOYd7n1O+Xfy3sOKrve7WF9x9DPoeEe7vVAVvZB18xn+O6
3o8bhf0ndHzH58yvRxXlaD4gvK8X9TiYbx/y4fO1PrW1+OF54xTOfyHcdRr1
8L4aF/JnPpv61d7ip4n19et4IebvHYB+rM9xBvm3ClefVUU549TD4kb8I8JL
btRHPXsH1ZVCodAuvPsc9PuG+gyhH+zPrSFl7zHvOanXeZW/V2lnf5uGUV8X
9bsAPTgfG0ZUcR6Hv6OeI6iH81UYgV6cv6pRFbc6b/cIu0ZxH+d3bVTPz1XO
t31M37/dRf3HdP/NfuEKj9an+gz74YG+Z4VXPah/kP0ZR7/PCYfHVbH8yvPs
14Rm77Bw6wTOj7B/YN+o8LZJ6OFhPyfRr3HhjVPoxxj7O6WKv9sY79oU8ud9
1V6t1zrzG/JCfzf7P439Zb17ptF/6rE0jX04LfzyDPaF+vbOYN+p/78lZr92
z0Jv9jM9i35w/zfPIT/2v3NO5/M0/ePWHOphvJ3ziMf+++eRH+8v94HpV00+
+Afzve7Dec6Duoh+sL7xi/A7zscGP/yO/Lof/aI++/x6/vYPCA/69fxaqWfB
D73J9/3YX85TVQD7Qq4HN7I/roCuZ5m8GEC+5LUA9o/ntwRVXdz6MNke1PvT
zftPBqEv2Qhivpn/3SD8glwRwvvkXSG9X9dZf1cI58nJEPaXvBrC/JOtYXy/
MF5NGHown44w5oH5h8OIx3pvgq3kTZEH638vovQfcmsE+vM+X0T3t4d8I4L7
mN+T0Qf3f1sU9ZG/jMIvGN8bhb70gz+iyJe8Mab3YYH5vhHDfPK5I4b+k8di
2Efu67UY5nVI+JE46qO/VMcRn/wZnrdx/4fiOH9B+Oc4+km/sCTw/UR+LQF/
oR/tSaB++s1AAvnRn5YSqJ/+tJ6AP0/QL5KY50nhj0o8Rf8osVfYTCL/afpJ
EvFnhF9MQd9Z+ksK+c0Jd6eQ/zz9JoXvB5/wPyl8n/jpP2n4bUC4Lo3vjyD9
KI37Q8LRNPw4TH9KQ7+I8DML8P8Y/WoB+xQXPryg59+ToH/h+UpS+K/S+TT9
LAM/XhB+J4P7M/S3DOoxhGcymK8c/S6D/TOFH8tifr6n/2Xx/g/CB7PQc5F+
mIUfLgn/lkU+l+mPBvz8R+FnDehZoF8amJcrwu8buP8X+qcB//xVuN2AP1yl
n5bi8f0Q7qtlvIKBeftJ+G+8H2J+9/F8/ZLwUznUy/qqctgf6rEDbMvTj3Pw
D+rZkkO+1NuVgx9lhedz2s9usl+LOfgF+/lnDvml6N8lZv+fMDG/nI8tJvyB
8/O2CT3IdlP7vZPz1mhi3qP0exPzR54qPee8GqbuRxv5dxPzR76L8yuc90fz
mCdyRR7nybY87iPvyut6dpIb8vj/gdyVhz9p/h8ovSBd
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm1olWUYxw9hfTBpFINW0FoksUJDEmRfFrclmTFo7kMtOAQNk5UftoSF
6SiVjWxUZ9acnTnn3nf2dnbe31+e85zSWUd7Ww7N0lmNlauWOVkWo+f+H67/
8ICOH89z7vu6/tf/uq7zUE1d1au32Wy209Y//Vc+N0rtBRML6zfnaZua3x4p
XuGXVKF76ytko0a9Ub56euX5a8ruMBs8wqpONV/dXubl+7txnk/4cgPYz++/
pTZan4BwSSPuC/K8d/T7XSHhDQdUpLj5apjnH1SP2h1PRYUrm5TDXHTFeF+z
enZmb2FCuP5dZeXrSPL+91R/ffnqtHBrC54bjOd91eF03mcKez5AvFnG54Ae
5NpWfV7Lp4z3sNpnJfSZ8NJhfX7BScb/kc53hnzoYzXdV588xXzalHV836Rw
0RHEd5r5HVFVliCfC7vawV8w36OIJydc9onWo+0M83fi/LPCk05dv8iX1KMD
+X0lXH1MWa8vfE19OqHvt8Jznaj/FPU6jnp+J7ynC/Xhc3UC3/9GeFW3sv7f
z/tru1Fvxp/rVtnFUjvz3dCj9T1Fvdp6cP+K3j24j/Wz98J/rK/RCz3oh7V9
qE+c9eiDfhHh+fxz+rGyH9+nnwP9OJ/+LxpQVnput3DjAPw6xvoN6HwuDgtv
GVSWHfYOsZ6DOG9AeM2Q9kf5IOs7hPz5/tSQOpPLVfC8MhfqNyLc6VI7rQ/v
tw2jnuPCO4ahP/t7chj9wXzWjeh+cLKfW0d0fo+zf6+PYB5Qj+pRHU+O30+M
4n3Oi5IxnEd9msZwH+OZA7eMCleMQ3/m4xmHf13ChW7oSz32uOEf6nfRjff7
6b8J6NEn3D+B/u6lHz24r0d4k0fX5+YJ+tMD/bqEOzw6/8Xj9KtH9+Pt5GWP
vv/hTvrXqx60DHtMuMaL/u6gn72I3yl80qvr+SKfL3nhL/JjPsRHtvvQDzz/
Qx/yJRs+6Eu+5kM9yGv9t/ILfsRHPuTX+deTY37MO/I83i8gFwfgV8ZXGcD3
yQcDeJ8cCOB+8iy+v5X6FQUx73j+c0Hd76XUqzGIeXFU2B3U9fW3s/+CWo9Z
8j0hnM/3t4TgR573Zgj9ynhcIewn3n8hhHoyvjVhzDf648kwvk//1IfhR/qr
N6zrvYt+nAqjfvTvHRGl/9DfZRHoSf+/HsE8Wun3CPJnv5+NQB/2my0Kv7Lf
n4jq/jHZrzui8Af7uT0K/3E/T0bhZ+7jm1H0A+fluhjO4z5+OQb/cB+3xhBf
StiMIT7O5+sx+Dkj/Egc+XLfVsfhD877ljj8zX2QiEM/7ss/4uhH7seSBOYj
90tVAvuC+7ApgXnM/RdKYL5yX80l8PuA++z+JPqV+64iiX0+Lfx2Evmf5/xK
Yj9+L3wlifnzA+dZCv67JPxMCv65zPmWQv9fER5JaX/s/5nzLgU/zgrflcZ9
ZJWG3nx/dxp+mOE8TKN+vP9cGv5ifKsM9C/jf8CAPsxvk4F8mP/zBvxCfWoN
7Df+fjhgoB78fdFhoB/53G/g9wn1zhmI/5zwLwb8wPuWDcwTxnNvBn6+wPmb
UZBJeFsG9WZ+NRno8aPwPnAD9W/L3KrXeP75T5zX+efU91L+fOq/lL9/Tvhu
E/X7lfPcRL1/E37axH6b53w3Uf/fhRtM6Pkn572Jei0ID5nQ4xrnP9jxt/B5
vF+4yH2A87puCN+Zhd5L3A9Z1OMf4fIs6vUv90UW8f8nXJeFX5a5P7Lwt+2v
9Zv/B1+2Q7g=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn1I3GUcP2L2h0VRCK0gM4qw2MZICP+5eFajWght/lEGEkwqrP7wGhhr
G7WNSUsqXd1WZzfny+n5ev7Oe/He73e/K+fqtlqt2ZY1Xc0MZW1Dy6RW93yO
7ycUVD7c4/f5Pp+X79d76xqqX7rBZrOdyH/r3/J1T9P8ts+vrN9UQFtUdqm8
9jPi51X+x96sYLNOPVjbYln8/BXV5nLdSawa1B/ltS0Znt+hFrZFSomnG9Xu
Et9xk3//pvI47M3EZXtUie/J7cTqbaX7I964T71uL36O2Nyviie7HcRbD+j7
2omnm3S9GWLHOypfrpL92N7FeeLW5tXvKXsPnxMb76uZXSU+8qFaNB+Pkb/6
Vs3f1Dj7PaTydDVOCF4+pJ7KF/iC/X+o+4l8KfjgR3j/Sb7Hqfkp/krw2sOq
oqIi8DXfdxjnvxHcd0Tzf+sZvvdj6PWd4MpP0M8k3+9SLdZS+TnBEy7wdZ58
tOl+nVOCaz5VJ3O5qp/Ij1u9nP/i53Nurddp1jOOqrw8dt63sx16nyV/x/B+
fr6mQ9eb/Z58duA97CfXgXo/kN/O1fc7O+G/H8l3p9bTxc9ru1T+eSusZ3bB
X+z3/m7ozX4OdoMP8rfQDX+Q360e8EH+gx5dfxf1Wduj7HmDnhK8p0efz+Wo
X4/27xX6YXMv/HGCevbCr8cF3+yF/+k3hxf30Y9nvLiPfq7sw31pwe4+rf9S
kvr3Q/+E4Bf74acY/dAP/iKC1w3A32H6Y0Dfd19I8OKA1idJXDMIfscEJwbB
J+uVDcGPvO/AEPRmP3NDeA/7rRoGH3yPMQy/Md8lPhUpbXqNed3pU9WR0iLO
sykf9CV/agR+Ir+eEc3vJPO6xkB/1OcRA/pQv3oDfmV+2wydzwqezxnQh/Wu
G/D7//PBD/3ZX50ffFJPpx/8Uc9xP/rh+5f98Dv5eWgUfMXp91HMi6jgD0ah
D/UwR1frda1wPsA8BFDPL/jZAO4bYT4CmL/DgmMB5GGQeQlg/vcLLg1qfeZ7
mZ8g7vMI3h9EvS7mKQh/dgieDUKfo8xXCPwRPx2CvseYtxD46xTsCyG/rD8d
wvtY//Yw5jn/fnMYeWH9N8Lgy818htE/8fmw9ltTO/M6hn3K+o+O6f2xgfc7
xuBPvr8L56d6mGec93kF3xhBffJZGcE8IN+vRlCferhxvoh6ncL5SYP5j6L+
qOCHo6gf5DyIoj7zfgTnNzC/EzhfxPyuRNE//bcuhvr05wsx1Kd/W2Pgh/62
YsgP/b8Yw/5jXh+IY34wPzVx8M98NcexX5i/BM5vZ14vxzE/OI/LEpg3nNfV
CeT5NOdRAnp/KzicwD7kPphLYN5wX9yVhH+4T6qS8Bv31VtJ+JX7yEji/yHu
04tJ+Hea8yyFvF8U/EQK+fqF8y2FeTEreCCF/fYr510K9eYE35JGnohVGvOP
53ek0f8lzsM07v9Z8Nk05u0M56MJftnv3SbqX+C8LGC+75nCee7nehP1yMc+
U+V/7iVuK5wnDpjohzhnYp4SXzLBB+tfN+EP4jsyqMd+NmbgZ/a7JYP5zvfU
ZeA/vnd3BnpSD2cGfiI/w4X61Gcc513k80IG+aBey5nVetxmIR+/cZ5b8Oe8
4Mct+G+B893CfL0suNFC3n7nvLfQ31XBXgt+u8b5byHfi4LPWfD/EveBhf31
p+CbsuDjL+6HLPy1ItieRX7/5r7I4r5/BDdkwc+/3B9ZzFfb1fWb/gMeLVGk

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx6/SWsSs3DW1JmIxRwyLxdb4h/apXGRjS/hDaWNtsWpWf3C5
0QpdoYNFrAQLrSMi5A44fh3H/b7j7rj7XqHVaVkmZZRgSRRUaOgYa9Z93ux5
u9j09tr3831+vp/n+9lcVV3+3PUmk+mz9D/9K38nUqnSUwtbH16h7ao4Y+Ke
b8hPKWfJ9PJp4XiV2tQwd+oMn7+gmo3Lju+EVbWaLwtmneX5PaphrqzoB+Gp
GrXX7CyZ5PuvqZeLM3b9KJy9T6UfP/MT7b0BPidcsF89n/6bov0DeD4tvKMe
9s7TXwP8/SxseRPx/EL/byHeC8ItTUr/zDCet1Xycu4k2fWOKiws9PzK+JpV
eTCrYVZ4d4uuT9lvjPeQarNaN/wuvHQI9sjxd9Xj07Wtc8KN7yHeeebTqvOZ
IK8/jPfJU4dVun8psuMI+kG2vK/9W2m/6APEw/hMVvhnfset6kpu5a2sT0sb
8mN9Kz5UlWkH7E92u7JbijPYj9l2dW/6AM+7PtL1rGP9X+1QEzZLMeutPoY/
8qpO6Ivnd3fCP/uZ6oQ+ab/gqJquNTupj1bwfYxv6Sj6Ra7sQj15Pt6lMiZs
C4w/x6b9raa/RhviYzzztv/XZ4cdemH8Xjv6Q17fjX6wvvu6oU/qZ6pbpdOb
I2/rgZ6pJ0cP8iNn9qI+ZEsv+k8+3Yt+k4scqDe53aH1H6Q/Ux/yIT/bp/v3
yDU99Ol8KplPfj/iv6aPfthnfRb7tZ7MrF/FAOrB+kYGoDfWP3sQ77M/9YM6
/2nuh9lBvX9quT9Kh6A37hfXEOxx/5id8D9BvTl1fs3fCk860V/uMzWs+2/5
Wtg+DH18RT26sC++FH7QBX8nqE8X9EVuc2H+eT7lQj/JV11avzaeLxhBvl8I
V41gPj+nnkewD44Lj4/o+asZp75x3vqJcJ5b1zNqUO9u1D8ufNCN+Y1R/270
Pyp8ya31mjvKefBADyHhnR70P8D58KB+PuGwR/enycN58UD/I8JZXuh1mPPj
RTxDwge8mO9BzpMX/vqFZ7zI18H58unvwUyP8BM+6Kmb8+ZDvW3CTp/SP+Qp
H/pnF17rx/eF9rb50Q/6e8WP+Ps4n35tr25A+KwfemE+mQHMt1P4oQDicXF+
A5gvt3BXAPr1cp4D8Mf63hjEPmT9i4LIl/15MYh6hjnvQeQXET4Z1PG8xP6b
Qug39fFACHpMcB+E9PexIyl8JIR4P+V+CKE+x4SXQ5gf6jU/jHmhnp8OYz5S
3B9h6O+ksBFGvpyXxTD0xPvJllH9vJT3k4pR7APOdxOep3g/ieB5E/fDnyvv
c39kR+Cf+6Y8gvd5H6nH82buK38E8fP7MxtBv7j/7owif+7H0ij0yn36ehT1
4z52RXH/4H3gfBR65vfaHMP8/CH8WAz74C/utxji5/P+GPzT3mQM3wt+79eM
YZ7Iagz3O/KeMeRP//Yx6JX2z4xh/9D/qjjqeVF4Yxz5/M19GYceF4WfjOv4
j13h/sT5jiXh/XHsk2XuU5wv+UfYs2L/Kvcrzi/8K3xhxf51F2Xfrti/QXhd
AvZXCxckYP8m4e0J2L9ZuCqB+DOE9yZQn0zhVpzvWCM8hPM1twmP43zpWuFz
Cew3s/BSAvW/Q/h2A/1aJ5xnoP8bhB81VPr/uruEKw30c6NwjYH7zybhgwa+
d5uFew18D+4WjhvYDznC3xuYly3Clwzsw1zhW5LYN3nCOUnoP1+4OIl9t1V4
ZxL3wfuFq5OoN583JlEPbe8/LY9MvA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy9DW0iadqXWRJzMESO7cmv3z7VPP5bZ2EL+UNpu/cHUUf3B
5UYzdKUOFrESrNOCyEQO+aGcB3ccB9xx3/uymW3UqpFMRwmWREGGBMZYUd/P
+/a8Gbcpe+3z63k/z/t57jYXFufvW2az2b6y/um/8vHvGC0dnHrsmSTtVK7U
oYYfyK+oQ3b/l1eEjUIVSS+fGOL6ayo/kr78qrAqVtb/R65x/wH1pit1z7Dw
SInabn1+4vm3lc/jSh0Rzjis7FZAo7zvXVU+sSvys7DjqLqT5a66yfuPqf3W
51fhvDL14mipd5zvlet4bL8Je95TljwP2fY+3iNXV6qvBwZyf2c8H+B9cuBD
Nbkrkj7B+Kqgl1xUrfUOkR0ndD63TArPnUC8ZOMjfd9pcsXH6lF3lUnO8+p4
p8jrT6rampqaP6jvpI7PeUu4+ZTOz2qy5xPo5Xnnp4ifbKuBPsZ7GewkV9ci
Puov+Az1Z74y6qCPPF6n43+W+Q98rv2zg/U5eBr3jzF/Xygr/fPklDOIh+eL
zuj1Ur4/gHUn43fU4zzz4a1XltzYn8x3PepzW9h9FvH9xfyDTXJmA/SSKxqU
tVxCnmxYej7PB3+RQz7t7+A069Wo+mez3OTDjfq+WcYz0qj9X0l+/hzqR24+
p/urfEo4rQl+oD5Pk9pkJYQ82KSs65tZf2cz9jM/dc16PYtsa0F8zOfeFuRr
0Q8t6CfmP6cV82GxX5LMes20Yj/rXXAe97G+0fN4j/2bcUGNltq3/SJcdgHx
3qCfsO7nPMhtw3nOi0Ab8n9d2O5Hf/xIv/lxP+fPsB/14XxSF7HO+eW7CD2c
bykB1IPz76kA+onzsiiA+fi9cG1Av7/hO/oV+6e+FV7AfVXc72jHPOR9he2Y
H5y/3nb4n/Fcakf/Mt65dviXerI7MF+o192B+cp5e7wD+pkvowPzmfmd7kA+
OW8zg/AT67M7CL+xnhVB9B/r3RNc6o/J5H76KT2E/YvzLbTUr8dC2E+/h0KI
h/0zFoIf2G/rO+GHWeGXOqH3b/ZbJ+bJnLC/E/mZZ/91ol7/CK8No57/sh/D
yP9/wm+F0T933Zb+DOv3h5cJXwujvinCaV2YFyuEn+5C/98j7OmC/nuFz3ZB
z0rhwS747z7hFRHUe5WwM4L47hd+PQI/rxWui2i9Yw8IfxPBfHtQ2NaNfK8T
frIb+SbvBR95SPhUN+Y/z1/uhj7yfHK/XTinB37g+6/2oH6Mrzq5vkbY7MF5
6pnp0fPctVp4ay/0MB8FvdCfJlzZi35LFY72wt/M761e5Jv5z4jivuXC+VE9
v+ysX1kU+WR9w1HEYxMeT/KC+OPhGPqZfsqNoV/pt3diyC/9GIjBP/TvjdhS
f9v7kA9+H7zQp/P/Buf9wT58v7JfWvvwe4bzfbgPfmT/rYpD/+Lvlzju5/4D
cfiP9/vi0MP3r8TRX4wvxcB7M8IbDfTbHc5LA+9T78sG4mc+igz4h/k6aqAf
mc9aA/Vk/wUN9Cf7b8CAf+4WvmnAD6znggF/s97rEuhf+sGRwO9X9tvOBOpB
PxUmMC/Zb4cS0EN/ehOYJ/RzWwJ+oP8vJeAn9s/1BPSwv+YS0LNBeI2J/nxE
ONuEno3Cz5nQs0nYbcKfm4VLTOjZInzchJ5M4SYT9dkqbJjQkyV81UR9soWn
TdQnR3hlP+qzTTizH/PscWFXv/79PPCE8O5+fF86hItxvobrFThfst3i/wEj
ZiXY
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9MlHUcxy9DKyRTo0RLPJUMSYu6Iv659q1cZHML+UNpu7XFrFH9weVG
M2WVDhaxCiy0ICTkhxwI18Edd8dxB889txltV5ubq9XYgraIBjM0MKKynu+7
fd6M2JS99nyf5/v5vt/v7+fD1pKyohdX2Gy2L61/+rf8HEv3Fvw8u/vx/2iv
CmdWTU+Sn1PO1G/byEaJ8hZMHF16/rJ6yfohqzL9/qtL6w8r6/+3yePlqtac
9yy9/4ZKzGePke0Ver/trEe9pazt3eTc4+qrZDJJNk6oiaPp908JF1Yqa7nz
F+5XpZ62FkwLu9/B+Wa4/7tqp6vWvCxcV6MaGxoaZlnPezjPVWHf+3r9E3Os
r1av33hNuLRO1zv7O+s9qSx9v/hDeOEkvv8n6/9QWdvP83n1R9CH7xfW6/Pu
mxfOOIX6Wc/4KejLej2n1Zaq6Ys8j/tjZdn7wq/C+Z9ovybJtgb4x/dHG/T6
CXJdo/7e/ivCxZ8qC8NkexPOz3qmmuDXkl5noC/5SLMqCmeu/I36fQY9ySkt
Wo9ycmmLmtkfbiYnW7S/MXLuWZyXXH8WeSIv/I9dreo1K2BkoxX1UN+sNuSL
fla3qWvZrtoF4Zk2/f7BRfrTruvL/Es40A59/6ZfHTqf3n+EKzpwvhuuiH8d
yOuNwnvOoZ6Vwp5zqGeVcFon/L5J2N0J/ciXOrU/+eR8D+olN3mQL7KtC/ft
ZuFDXcgrebRLtbudNbcI7+pGXlKF67qRr9XCc93wP024+Dz0u1U4eh7+rRG2
9+h+snibcGUPzrNOeKoH92W98L5e3K/bhX29ON8dwule5O1O4SNe9IcM4TEv
+tlGYfU5/LtLuB3cfLdwig/PM4XzfHh/i3CpD9/fKtzow/3YJpz0aT0LsoSv
+5DHe4Rz+9Bf7hUu6YP/O4Xr+3D+HOELffCfzxf60N+yhXP6oe8OYVc/8sb9
PsBzJ+sx+nF/twtf7dd+p7L+LD+Y5zvgx3q7cLUf36MeET/8p14zfuVwOPyb
hTMD+B65MID11PtEAPeHfgQC0Ic8GdDnt5EzBuDHJuFnBtCvyBUD2I/sxfOL
9H98YHke1gcx38h7gtovF/n1IPJJ9gThP/n7IPQhp4WwP/mxEPLOPLpD6Ofk
1hDyQb4UQp7Jq8Kol5wfRh7Ir4QxL8hNYeSD/HUY93sD7/8g9CU/NLi83kOD
2J/6nR6EPvRrdFD766Dfi/jeNPOwK4J6mZ/nI9CTeauLQC/m04zg+8znXAT9
iu/vGEL/5n7FQ8gD66kZWu5HFOsPsh9cHtL3q4r9wx5FPtcKF0Ux/9ivKqPQ
j/0tGMV9Zn+ciqJe9utNMdz/FexXMfjN/v9mDPnhfPDF9PfrOU9+jEE/zv/0
YeSZ8+mpYfi3NE+HoT/ncfcw/p7g87Fh1MO/V9aMIC+cb2oE9XC+HR6B/6yn
fQT3hX+vfDOCell/igE/eb7NBuYJ51uegfNQj2cN6J3C/mmgP3G+HTfQT6hv
o4F+yHnjNzAP6UfSQD306ycD84jz5Lqh85PNebIhjvnBeZIbhz7pwnvj0Id5
KYkvv0/H4sgD70N9HPeV/ag3jryyv13Afm7ehx+wXz7zvBDH+Xgf1pk4H/Of
Y6L/s58/aWL+st+7TOSd86HcRN7uY783kZfdwp0m5vED7P8m/HtQ+DsTejk4
D0zk6WHh1QnMlzzOhwT6A9mZQL18/0ACepDLEtD3Ec6PBPZ/1OJ/AYBZAjI=

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVg1M1GUcvpxZoWXalWiJOMnIoZlXRB9nr2kiRolUiuvmkpAy27jcaKau
1MEiVoF1fkBEfMqHcN5xHxx3h/zvf1vRRm1tLlZjC9pybrhmLhpzZd37XL+n
wXbcnr3/9/fx/J7n97/lxWWFe2dZLJZvEh/9LX815lRm6u+rNyRRnrKnjK74
H+9ShaG0m4mNYvXtyMjIIp7vU44as5xYlSn9RWwcUCmjrc57BI+XqwcTF+7m
/Xf1+VWr4PQjyEes3tfxpxYKXnsM+Rcw/nGd7+idggsq1JXtobT5zFepcePt
gp0foL55zP+hjpefIri2WuevvJX1fKT5aJ0j2POxstlsvtmsr0YlyuucJfiN
WrVl4pDLwnpPqES4/Teu/oenT6jKye05fwk2PgU/fwuu+kwdtrpz/xFc4EI/
N0m81JPgi/nGT+rnv2Y9nafQL+t1nkZ89pNzBvHZr6VO1dfVLSYfw3WIT75q
6zEv8ln0Ofoj/+kN6O8uwZcbVCKdnfP1fKGft1IPBxtVaWnpJepJfan5CC0R
PLtJtTnt1feRzyYVn8p0pAkeacK8lpLfZpzfK9jVrNy5E4cWC55uxnyY39Gi
Eu1PsD6jBXqn3jJacZ96q2pFvdTXlVZ9fw/5KGiDPsmXvw38k8/Udn2/dK7g
I+1qWaJh8j/ejvpvE7zprPoz01HDeXWexTxuETyvQ8+rjufODtTDeBc7dL+Z
zJ/TObO+hs6Z87R0gW/Os6RLvW1P2cl5DneBH/KV1Y166Ofabj3vQc7zj27E
4zyLziEe5xk9h3icZ3oP4i0TXNGD+pZTTz3gY4Xg/F7wdT/11asS8lrzgGCr
W8/veib15sa+WCV4zA3+sqi/89DvGsFt5+HPtdSjR/eTsk5wtkfnH7NRnx7k
f1RwvQfz5fkI7lc/LPiGB/U8RP16wQfzF3uxf1ify4t+WP9XXr1/bDyf9iLe
asGr+tAP4zv6UD/zf9IHP7Afow9+ekTwNdyfZD8ZPvD/mOAdPuR/nP7wgY8n
BId9KvH/6FP0iw96XC84za/5+f5p+scPv20QfNyP5zfST8nnNwm+5Ef8zfRX
AM9vEbw1oPU2mke/BcDnc4LdAcz3efovAH+/IHhhEPutgH4MYl8WCn4niHm8
SH8G9fzdLwv+KQh97qRf+6Fv4vX98Cufd/Zjfozf0g9+mf9iP+phvXNCiLeV
/g6hPvb/Zgj6fpZ+D2Gezwj+LoT+Ff0/AD7tgtcNwH+cZwnOLTmCTw1gv1Mf
wwOYH/V0fQDvR+ovKwx+qdfdYbxvqOfaMPRH/5phzHsl90kY/qGfV0bQL+8X
RVAf41dHsI/oh2gE9bGe3yLgl35Ij4JP1l8YxTzph4oo/JQtOBiF3sjH5Sj6
ox+WDOL3wpPcV4OYN/l9bxDvc+rfg/MJzuMXnDdyXtYL0BP1v/kC7lP/B3E+
liu4G+eN1P9Y8j71f8cQ7lNPagj3qf8DOG+k/tqGUD/1+cMQ9tVL3I8G+qee
lxrYL9R7tgH+dgneZmBfvsL9aYB/h+BjBvSzm/vUwO/LVwX7DOi3mPvVgB9f
E/yrgfnv5b414P/XBS+KQT/7uH9j2I/7BefFoL+3uI9j6I/nh2PYh7zvAp7P
+L0x9FvCfR0DH3sE/5yMz/6m8fwk+Vhg4n1dxH2exOR3o4nnOQ+HiX23TXC5
Cf/mc9+b0CP10GGCD+rHMDFf7tsfzZn74ZqJ32/U79w48lPvGXH4k36wx/G+
5/7YEYde+D4oi2PejFcVx7y0H/4FRy7pbA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn9M1GUcZk37g1ytdlvUFmJSoaFjVkYr7BVJxCgBi7Auywsv1IqTRhmy
UgeLWAkmWkdo8ksOhPOOO7gf3MH3vreZbVdbW4vV2JK2GBuuldPG/MN173P7
PI3b4Pbwfb+fH8/zfD4vq2y1FXtvS0tL+z75o7/lc9jiLn7rn3WbU6hEHSxI
f6WaeJcKZjYf2CvYsKmK5B/sfL5PbZtt6HhbsKpVsw0WN7FRp/7NsbYRX6lX
zQvl+cRpH6k284aL8bIald1un2M+9YlKn+79m/XkHVUrmxd+Yr3GMdXnKGi1
CS5r0vFy9jBfM+p5Q7DjU/T3OvN/hnyvCm5v1fkcVaznc6W/KgV7vkA/O1lf
m7paHswsF1zTjnwvst4Tao21rbBU8OIJnX+6hPV/iXzFgltO6n7Sn2M/HSp5
vLdQcMYppfVS7O+U1mehQLDrNPR4mv1+hfxPCc7/WlmTBG1k/07U+7jgy07o
vYF8dOrn6/MEV32D99eRny5dz3ePCp7vUp1Op3MN+Tqj3MWzDY8IPnRWxW/k
WB8if9+qHxKJ0tWCl51DvavIZwqvFJw4h3qyyG+39uPyBwV3dINfxlvshr+Y
z9qztB6jB3yy3uxeXf997KelF/zmCr7aq5JyRddTnz74gfz4+9Af+cvoR73k
t7Ff57/5BPXr1/0nnhRcdB78US/XeehBPVcMYH6ot2MA/T8r+OcBzAf9ke/S
/jxL/3S5EK+I+g8i3lbB1YOIt41+GEQ8+jV3CPGepz+G9PzYXxB8fUg9lvzs
oF8uoN8ywZEL8CfnJWtY+3s1zzcNg1/Oy/ywSsqzZ7vg0hHN912szzMC/3Fe
LG7sgy30mxvzvlnwjBv1kS91EXqTz76LmD/yvcwDPqjHRo+u30K9ajzwF/Xs
9MBffJ7wwN98/5YH+4Lx87zYb88ItnnR/yb62Qt/Uc9LXvBBPRe96Id6rh1F
vdTTOop54H45Pop5/3//jKrk7yPU89qo1rucemb7lupT6cP8U88WH/ivEBz2
wR8vcV582G/cn5l+zDP3a5kf/HP/HvNj3l7jPPnBB/f1nB/+4T7PGIP/uO+3
j+nzBbwfGsfgF94nbpyf431zZUzzOUt8z7jur573TdG4giyCPxjH/cf8LuDl
rO83nD/CflYEkH+X4E0B8MXnjgD8YhXcE8C+2M15DqA+5rs9iP3AfvOD8Bf7
3R9EPey3Kwj+2N+PQehRw/kP4Tzv4w0h+IPvV4dwnnycDsEfzHc5hP1Jfm6G
4E/WlxuGXm8K3h1e2k97GPGIzbDenzPs/3oYfBM/PIF+iasmlvLVOoH7nzgy
Ab8R/zWBfoizInp+fMQVEejFepoi0JN4PAK+2M98BHoQ3x+F/9h/aRTzTfxx
FPnIlyeK+OTzj+jS/78sk4hHPbZOoj/qeWgS80P9hiaxn6jvTArvE3znFPB+
7r8pvH9AcN0U5v0d7sMUflfwL1PI/x73o4HntYIfMBDfwX1pYP8T7zBw3x3k
/jSwr+sEH03Fe5/71MD+I/YZWk+TOGHAr8R/4nkh8S0D/DL+vTHwy/x5wNOs
vySmz6exP1sM/iU+HMP9zn46YtjnjD8Sw35h/ksx1Fcv+PcY/Pch93cM9fL5
3Sb2OeOtNRGf9W0x4T/qYzUxT9S73sS80y/HTdRPvw2Y2Jf0s5HKx/3zqwm9
uJ+vmeD7ZcF3xMEn9312HP7k/VAQx/u8Tyrj8Dvv69o48vO+bonDf/o++w9s
WOKX
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVnFMlGUcvjXrD2u1GlvWFtFyjZw1VpvjH9pbmYpRAhWiXTZvSKgVJ4Wh
kAlxE8ngUCDBE4EDORDOg7uDu+MOvvtuM9uutjaXq7klbTk3WCunzflH63uf
2+9hsLHbs+973/f3e57n97zfM47q0j332Wy2H6x//St/ldbfnn9eeDWDCtXC
4awXK4l3qKddiz8TGw5Vn+Xf/BGf71VLJZE+YlWtrnqdiSq+X6Os1xf2Cr5e
q0oj2ffv5/pD6mXr72PBOQ3qQMHqq3yuvlL2drOW6/Ma1b+59kd4ntGkrNe9
FYKLm5VrsSTfwfNcut7vPxTsPKbrzd7F84/relx2we5WZdFxYyfrOaH7Kdgh
OPCt6u3p6dnO+tp1fXfeE1zl1vVvf5f1dqjnrRdKBd/twH4lrP8knm8T3HIK
699mP53Kou9ekeA1Xbq/yJvsr0sNOQtatwr2dSuLDmch+/0OeIvg/NN4fzP7
74FemwRf7gG/xO5eff7hNwSXn1H6hzjHA/43Cr7p0fxVEgfO6v5eI67rgz7E
6pz6MZ0uIl7VD72Jq/pRH3G6X/P/BM/PG0A/xJ0DK+u/O6AseXzE9kHwy/6N
QexHftZ6oT9xixf+IZ9LXu3XIPkuHtLz4qceoSE8X9ZrGOvfEtwwjP2p7/Vh
1FsseON58EV/+M6Df/rnoRHw8Q71HcE80X9XRtBfGfX2oT761ePDefSzbRT+
oN8rRlXqTu619+mHUejzgeD1Y9Cbz91jaot1APe7PQY9eH75BY1Xcx7iF8AH
+8kZ1/W083nz+Mr6b45jXssFF02Av+V5nEB/rCfLD/+w3jo//Mb5v+ZX+mc3
/XcR88e8GLqIPGCerAog75h/GwLoh/lWFdD8pJlPvQH0w/xK43nRJ4L/y6yv
pn8nwYdTsGMS59fQz5Pww+eCL02i/oP09yTy4AvB66ag5yH6fUr7P7decNsU
9G2g/zPvHxF8awp5/SXnIajxbuKyoLLKW+T6lqCu5yhxLIjziJeCyHOenx3S
fukkLg5hPettCqFf9hPCc1ut4BshzBf5WRNG3pC/rWHw+ynnLQx/UA9/GHos
30dh8Ec9H5uGfvs4j9Pon/fTwWn4ifv7pnEez/8N7y8c4LzOYP/PBL8yg/lg
P84Z+JX6Ds6AH/Z3JbOe+z8Q0Xr9zfPzI7g/6a99EezPfj0R3E/s9yesd7Jf
WxR6sd+Xoqif6yuiuO+4f3dUfw+U0L+Xo+if/d6LYp5Y//oY8ov97YqhXvrX
HYOfqLcZQ77QD7dj2q92+uW5WeQN/Vg+i/mjf1tnMT9HmTezuG+bBP81Cz6+
Zv7E4Q+X4NI4/HSMeRRH/hwXPB3H91Ar8ykOvk8IfjKB89qYVwno1S74SAL9
dTC/EuDzlOA/Ekr/dDHP5lBft+BNc8jH08y3ObzfK3hsDvufYd7NYZ7OCn54
Hvr2Mf/moU+/4Jp53A+DzMN5fN95Bf8yD78MMx+NlfgpA3px/QYD688J3mbg
e8bD/DS0/vtZf6OB+4z99Rrgm3wEDeQJ+Uobut9nTwr+00Ceupm3BvxB/h9P
wn/EeUnwS/0Kk+CHejuSqId+qE/ivGbmcxJ50Ch4Ion7gn68lETe0L+/Z3Ad
8zuznn5/1ISefH+diXlinr5uwm/c327CP/R7rYnvGfq9zUQ/9PuIie8h+t0w
kQfs71cT9bD/W5l6vhH8YAr8kq+1KeQl/V6Qgj/Jf1kK80N9qlOYd+rXkkKe
a33/B5D7+dI=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdVn1I3HUcPsL6w0ajOMiCbJGEjRXSYPiP8a1GayHk/GMVHKOZu9xb3iyX
U9vUtDnb9NzObWc3p96p59vtXr0X787f/Q7WgisIRlIM0qARTKLGDNkfo9/3
Ob7PuASVh+/b5/M8z+e5e6GusfbAIyaT6XvjV/5XP8eqipdP/PPKG3m0W6zt
iZW2EH8ojD8dxxXW6iQ2NXP9oNw/8pnColFk18stTdzfJJbdtqpjCq80A9t4
/oToubOn8lOFt7Tj/FHedwrvcb2iU9TGSnu4rnWJAX29nLimWxjLd47wvR7x
Qy6XI7adFm1m33fEpjPC7Nu1SmzvE/+WWzbzvi1nC+vxn5P1px7WNyC2Gz+s
r8GO9Yf1DgqD3/cbFd4YlPU/yv618+Jly4BO3HtBvj9Avmocsp/D5LNkSDxv
EEa+V4bk+Tc/V9h7EZj62C7JfndRv8rLqOcL9u8UxUbB1PuGU7yz2uqgH+zD
6KdV4Q++Bb9t5MclDPu8+KXCf7okn/tPkq8r8McphVtGhNVqvd1B/q6Cvy6F
i0ah71fkc1TWu9ytcG5UrLaaX/2a/I4Jj62q77TCjjHU10u+x6T+1X0KW8bl
e6FvyP+4GHY6nzmncJkbfiDudUt+/ub5NTf8yPtrPPBLj8JhD/zIfkomwD/7
b5+Q/Vvbqd8E6iffOyflPMSol3cSfFHvTVOol/6wTUFP+u0m1p2HqbdX+vdW
g8IuL+qzUv9p2U/HxwrXT4Pvj+iHacznPoW3zcAPxPYZrHP/vRnwu59+mYW+
vD85i/7q6Z85+JX1dM9hXj+hn+YwfwcVrp6Hvofor3nUz/k1+6R/zeSjxSf9
4uP83fLBD+RPXMN9nC/PNejBeSryw2/UY4dfzt9PnJ8GvzDGt5n6DfuRn5yP
nB95Q70f5PdzPioC2M95qAug/076OYD66KfrAVlfMfFGAPxz/9Yg5pn3WYLg
m/7rD8KvxFoQ88567gbhV54vCwljHO7z/r0h6R8v57M3hDxnPYkQ/MnzayHU
z3woDaMe8lMTRl4Qd2G9kjgcxn3Et8Pon7gkgjwlfjdSuN4eKTzvixTevxKB
v4ifWkD+Eu9cgB7Ex7G+mXp6F1A/8a95zLzcFMX9zNfXo5h/+skWxX76aTyK
+uinm9HCfh6LIZ/4XmUMfFK/QzH4l/y7Yvj8oH4/xsAH9TLF0R/xa3Gcp771
WK9m/l6MY76YdzfiyCfi+3HkA/N5WwJ5xHzel5B+amV+2hPg44zCegKfb8zb
ewn4kXn90iLy4izzJY+Z132L2N/PvFnEfQMK/7UIvu3MnyTmcVDh2iT0P888
SiLPLii8kEQ+OphPSQFaFH42hby4xLxK4b3LCp9MgQ8n8yuFfB5W+PcU8sDF
PEuDnysKv52G3iPMtzT8OKrwTBp6jzHv0sircYWfWMK8eph/S8jHCYWblvD5
MMU8BPZ6Ff55CfNGXKSBn0mFnwPezvUdGvZz/T0N33fczE8NecV6OzX4/Srz
VEM+kY+Qhn7JV06T/HeQ7z808El9HmjQg3o+nYHe9EMF8Dr9sjsDf3O97n/7
2zJ4n/5xZPAe8XwG80Q/Xc+v8/3fMvAL69vIQI8hhZ/U8f2Hftqq4zz7e0vH
fvrHokMf8tGsY77JV78O/uifKR31k18tv07//KLDf/TLXR3+oF6PZ/E+/VKW
hb+ob1UW/qP+e7PQf0bhxqz8vuie5edHFvM7b+D/AKFSEOA=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1InWUYllj9sFEUQivIjEZYrJCC8I/x9EFrMUj9UQskSJb0AXmyTjm1
Tc3TnG07uqnbcc6px8+jHs+3r+fzPe+ptuKszzVb22gGjYESFTPEH6PzXIf7
GgkqF+9z7ve+rvu6r+c8WFtf/eYtBQUFX+d+9X/58W5f3tj392PP5NEOZRQ7
Vj4hfk2dzWazzYLNWlVRuOTew+dv6/PvfixY1SuntVZq5/kGVZR7QYPgK3b1
b2mN08bP71GZtdKaesElLWq1yhh6j/X24TxxWZt6pMZp8bzZrnJwjfUqO9ST
uZ+b73Ogvw8E2/ar5aYi74d8/wGVo/MX++3uwufJp+SgyrXf1CjYdwjvJ3/l
1P3dSX3e6tZ832hhvz26XpB6rveoaqP4VuptHgH/VsGdR3G+jXx6Uf9TwVv6
wKeD/PpUc5H3tEPwVD/030++x6Bfp+Dy4+B7gPxd6v2Kwlc/F3zGBX4HqceA
1uvxw4J3nVADLpfLSX0GwadH8LVBPQ/7Eep1UtXV1V09KrhxCHz7qN8p9YBj
5Yd+wZuGNZ/tx6nnsFpy2xIuwdlh5VipKj9BfUeg16Dg3hFd/xLPr49ofkus
XzMKzH7MUZzvFrzVrfk4yLfTDb3Id9WN/sm3cgz7Qb6hMd1vRS/nNQ6/kW/L
uN6fh45xfuPqxeWmXvJ9fkKN2SoKBzjPCfiPfDdPoh/ytU3Cb0OCz02in1Oc
9xT0GhE8OIX9HeX8pzG/McG7p1FvnH6Yhv8mBG/zwF883+3BvFjvugf+HKZf
ZrDP7C8+g3mz/5JZzb+I/DpmoS/nd20W+lGvnXPQh/P0zWk9bNS7yAu/cR6N
XvDhvC7ln3Oeah76ct5j89rf9x6iH33YL+7HUz6c76I/fXpfnuU+DfigF/ct
68O8PhN8wwe/cV/L/NCD+1zrhz+5771+lfvbSvyVH/vIz6/7ka+s/2gAfuL7
awLaDzvZ7+GArlfA/TYDyAc+/ycA//PzW4PQl/VfCWI+7LcziPxgP9Eg/MT8
WQ1iP1mvOITP832VIZxnP+0h7a8p6h8KoX/O62oIfiPeEoYfef6lMPTnvFrC
0J/v94ahN/lcCev9MMjn7gj82s59jGi/dTGfP4og3/ZyPyPaT3XM+18jqEe8
eUHXK2b+P72AesS2BcyD9UYX4C/ic/nnvC9uMzAv4nIDecL+3jGQ38SDBvxP
Pt8ayAPyLViEXtTjiUXsB+e3exF86O9+nHfevC9wvo76bywi/zifbVHsN/fv
9Si+X3A/u6Pol/trRXG/cL+vR+E/5uPDMcyf+bgrBn2ZJ10xfB84ybyJ/T8P
/4wh/5iHJXHo7RZcHdf+qGL+dcThr0nBkTjmMc18imNfPYLvSyCvZplXCeyT
V/DeBPzvY34l8H0jIPj3BOYRYp4lMY+w4BeSuA8XmG9J+JHYk0S9CPMuCb+z
3h0p8Asy/1LQh/00pMBnjnmYwrzI73wK9Yk3mZgH8f0m/DXFvAQ2qNfL+ecz
zM/8c+rVZqI+9Rowoee84KCJefiZryb2lfr9YSK/yfeGiTykfvekcX9Qr7I0
5mMI3pHGfKPM4zT8ERPcnIa/4sxnYHtS8FwaeZNiXgPb0oJ/yz+3mN/5518I
vstC/S+Z58D204Kfs3Q/G2eY75but/UbwXYL/LLMewv7elbwpAV9vmP+W9iH
7wVfsHC//Mj7wILffhJ8ewbz/pn3QwZ+OS+4IoM8+IX3RQZ8LgiuzyD/LvL+
yKCfyzn8H5/RKGk=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlm9oW1UYxoN0fqiiKAGnYK04pIpKcTD6JXLU4ZwU3PpBKwTBMkd1H1oH
k9oV3UaLtWxLu6XdkmVd26RNmrZp/ufm/80NblUyRSxTZ2WNf0pxRVSclH0Y
3vOE80gDbfhx7jnnfZ/3fZ+bxzu62t69y2KxfGH+yW/18XXb6sf+evbFGu0V
H9jq33SS3xJXK5XKGcV6h6j/zts9wvX3xFFraM+wYtElHhu4ud/B5w+Ljf3a
+GnFq0eEw7jVRLZ8JM/785Tixj5hNx8gi0/ETvPD55uPC5u5gayfEE/ZHS/x
vn39ok1r2MZ4VgeE1jBwk9z9Ke77P/7PxL9N9vvPKh4ewnnMv/GkMPUZGlUc
PiXKt5pWqJdwCFMO23nFncMyv4CL8Y7IeJ+4oHhzBHp4GP8Z6DGuePCszDd2
ifk4oe+k4u2juH+K+Y2K0J5qr09xYEy4Xa6HZ5jvORlf3q+45bwwj3tnlvm7
ZH71c4qXXMIsnzZPPdzioPkJKW6/gPPD1Mcj47sSUbzukXofilKvi7J/WhcV
94yjnjxfXJJ6NDCeugnEw/g7J2R+t5lvZQL1pD7NkzKfKvV0Topqr/U56rkJ
DvF5+xTWqacODvH8HV6sU89BL+oxrXjDK/VpoZ77fNA3oDjuQ/8EWa9pzA/1
7ZvGfC2wftOIn/runoF+1Dcwg/yp771+2d8DMdbXj3nh+rIf+lDvlgCY93lq
zHgss5gH6n9gFvcxv6VZ6MN6PBPEfVwfDqK/uf+f4Nb82+cwH7wvN4f6sv6N
85hncv887ievzwv5xfhbF1AProcX0I9kawj14X09IcTHeFZC0Jv1EouYH+bj
W8R9zLcuDL9jP+wKo57sl84w+pf95A6jfuy3Shh+cFHxnTDml37QHIEebsUd
EcwH/cQZgZ/Sby5HcD79aTMi4z1Gf346Kv3MQb+zR8Wr1V4n/fJ0jU+y/6OY
d/rt31HkSz/dEYM/0S/fiEE/3jcYg58xnkwM/c14N2LyPivzaYij3uc4P3HE
S389EUc96MfxOPyK96/F0a/Mb3sC+xnPawnML+PpS8CfeH4ogfN4/2oC/cz4
HkxivliP3UnET3/5MIl8Wc9AEv3Fel9Pot4TnNcU9GO/vJDCfi/nN4Xz6S9T
KdzP/ltOIV/2590a9OW8tWiYB/b3+9rW+fJost/snJ+vNOhPv7Gkpb+v0S+e
T6Of6ScH0vBv+vlYGv1B/1lK4/0YV3w7LefRlaBfZMBJxW9nUK8U/SOD8zTF
RgbvuzT9JIN8MoqfzMJvye1Z5JdVPJSFv5FzWdQ7p/iP2n5yYw6/F/KK23KY
P3J/Dn5GTubgL+T1HOpHfiQPf+D5rXnMK/njPPRmfOE8zif/nBfm/2PMz1pA
v1CPVwrQk3r1FDDPXA8WkB95pcbU/76ivM9g/UQR8896Hy5CD75/fEXowX65
VkR92F91Os6j3z6qb32/7dLRv9z/uo768/xOHeezv47r8EfG59bRX+ynmA79
2T8VHfWmHr/p0Iv63anFQ/0fKuH3XoH+W0K9ior3ljB/JfpxCfUpKz6K9W2f
05+xblxWvFDbv0S/LkGvLxXfqO2v0L+xfuWq4gcM6PM1/dyA/3+j+GUD/fYt
/d2AXsuKjxiY72v0ewO/375X7Dfgj9fp/wb870fFPxjol5/4PjCQzw3F95Th
B1W+H8qI5xfFtjLi+ZXvizLiWVPcVca8r/P9UUY9fzf5P/+iOZY=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1sk1UYrTr8MYlGs0Qwcc5ozDRqFk3M/sxclYgYErf9QEwaExdYJvxY
JZmZQHSQLeKibuhAOwZsa7d1X6Xr99fa932rMLSg6GSCUzYiiBkqLkDmomjv
aZ5j2mRdTt733vs855zn3N5f11i7+WabzXY896f/y+dENrt+9M/Hnsmjdcrt
qGofI35Fzbgck+OCjTpVPOO64uXz11VV8cwDPsGqUen9Jvj+NmXvsJr8guea
1OWa6KEA17+F/YOCy3aqzLXy2RD3e0d5184vhwVX7FLXy+13RLn/bpwfE1zd
qp7MfeI8r03vX5UQ7HhX7Sjxrk3y/PeAJwV3tgOnWM/76mF7x7Npwb4PVNtC
TaXB+jpwvim4oRP1Wax3r+7/GvHSXvVGbkGG9X+k6w18JnjPx+D/c/bTpfmw
HxW8ap/KbVd+jP3tU9HStgViz341v73EO8V+P9F6OYgrP0U/3N/mVN1O52rW
N+WEvuy/s1vrmSV/Gw/o8z3kv6wH9VKvSz0q991CfX0HoQefNx9CvdRTHS7c
r6hX5eh/jfo19Gq/lFKvbC/8Qb0q+nT9TurT1af5fZl6LOH5avJt78d68m30
Yz35fdCF88nXHhf64/PLLvTH9dVu8Ev+gm6spz9WDaj7coYhnzsH4Ef2Mzeg
9Xqc/a4ZRL3kwzOozy8mXyuHFI6hvkPqhdwG5Hd6SPvRxfcrPfAr9+vxaH8f
47zYhuEv6rtpGPqzvqlhVZsTjPU/OgI92F/nCPxLvq+OYP7J98ZRXV8X+UmO
Ig/4ftkYnnO/1jHMC/W8NAZ/EK8fx3n/z+M45o3rS7zwP3GzF/rxvFmv7mcF
sTqC/OF+7iPan1vZb5EP/NNvT/mQX+SrwYd5pH7dvkI/Z33QMyL4hg98Uq+K
CVVfX3+R81I3Ab2Yl10TeJ/5enQC+jF/l/B8BfP5ET/mjXlu90PfYcEf+rV/
Wobofz/8PyB40Q/+XJyHgK4n2id4QwB8HeZ85PFBwfH8+wc4LwHo5RRcGtTz
cIq4Ogj9+f5uPK/hfsEg9OV5F/PrezlfIazvF/xiCPPv5ryFwP+gYG8I88/+
50LQk/zcFcb8kr81YehLft8MF95/njD6oz5nw/q+2k79VkaQt5zXpyOF8+yI
oB/6oz8CPTif0xHUQ7/dGkVe0I+VUcwL/bolqs+z6P+eKPzP+TsZBT/ML1sM
88x8eyJWeJ9sikHP44L3x+DHL5kPMeh1QvByfr+vmBdx7Pe14Ffj2O8b5kcc
+00LtuKo7zTzJI779XvBDyXA/xnmSwL9/iC4PaH90vEj8yYB/s4J/j0B/uaZ
P0n4Z05wbRJ+4PrWJOb5rOBwEvMxw3xKoh/Wf88k8Cnm1STm46Tgt/OY/Pny
mPfN+Tzm/VySAqZ+z6cK86o5hfOY1yMp5Bf9Mpsq/H1zexr6cL1Kwz/0y7Y0
7nue507jPqFfTqdV7ruFfikyoBfrv9cAv18wLw3kU1bwS4bWY55+aTBQP/2y
y4B+5K/bQD/fCg4YmKfvmK8G5pt6XDDQD/1yw0A/1O9uE/3MMn9N9POT4HUm
+qEf6kz0c17wDhPz+zPz2UQ/FwSPm9DnF+a1CX/9Kvicid8LC8xvE/r8JvhO
C/r8wTy38Pv3iuDnLOTFIvPdgh+vCm6yME/XmfcW/L8keMjC/bLM/Lfw++Fv
wWcszOs/vA8s3Df/Cr4tg/m4aVHuhwzy7hbBVRncPzbBGzLgn/s3ZqDnX7w/
MvCHrvc/70ZQ5g==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy9DKzRJd0utiVjkiKyx2Bz/0D79WGZjS/jDamNtMWNUf3C5
0UhdqYNFrAQLLYgIBOSHch7ccXw57uB73yvEOi3LooySsyQKMiUxRkXd5309
bwYbsNe+z/fzeZ738/48n+/6vMKc5xbZbLaT0V/9X37ihxsdP1y598EYbVH6
73ny06qmurqabOapaHjmKJ8/r/Lz88fIqlA9FtlZFWH8DrXL7tx8QXi0SOVW
WNNk2ysqiq0/CiftVi9lxj/5E9d7DflcFE7bi3iyuQ/rjwlvLVGh6ZQR8mip
MhJLX/xZ2PG65gmy7Q0Vff3ZceHKcr3eCXLSm2oy20j8Rdj1FuLJqgL1Mr6g
EvnP53tA67eG9c4cQH7U23xbZUYb8J1w2TvI9xvWU6VKJ7IzvhJefVDlGImL
v2B9B9W60okzp4VbD+l86z5lve/q/uSfFM54D/l8wvqr1d3RhpCHqrE/36+s
UU2OzPiw8FPvY31yUq2K7LTfd0p4vFbna5BdHyB/5ldcp9LT091k9aGu/87P
hOPq1bWU3ApyQb2KynOZHK5Hvz+nvg3wJ7mqQfuriDzToPMv5365h9Ev5m/G
mPUnN4KH2I9G5Mfnk43wO/XZ2qTrd7JeT5PO18F8Vzej/jPCu5uxPnm0GXqT
HzmyML71iHJujsyynmUt0I/saNF+yiWfbVH6HzmjdaGeta3qVDgcZr62NqzP
era3Yf95P7Tp9fZQj43t2v+RQfqjXfsv+2Phq7HnIfrlKPT6SNh/FOvx/aRj
8CPXLzkGP56gn2LM+KwO1M/9XB3oP9e3O9F/7l/s1O8/ZAmPOKEHWR2HXxnf
dBzzievFubReWdx/kwv9Zn4FLswHnq8a10I/hcF2+m0O8XXUP61Tz7MU9iev
E/nM+7kT+/O8D3ZCzy/p707oyfmQ2oV8hun3Lj2vA5wn+7swv87R/12YJyPC
U12Yr9/zPLixP+f/Njf04bwvc6MezjefG+eT83syFs95mOjBvOP83eqBfzhP
93l0PbYJnicP9J4UHvPA75d4vrp1PxMuCz/eDb9c4Xnrhh/+EHZ2Q+9pnr9u
zONrwiu98McMz6MX/pkVftmL8/IXz6cX+f0jfM6Lefsvz2sP+nHd1P/8QI++
H4YXCTt6sF+c8OEe6LdE+GwP9LhReIkBf9wknGGgvqXCLxiYxzcL1xq475YL
nzag/y3Ctl7E8/n9vZhfXG87nju5/6Fe+G+x8FAv6rteeLYX/bQJb/Tp/PdQ
n2d88Bf1rPTh/vpT2PLBL1c5T3w4P1PCG/qQ7++cL33Qi/4o71t4P/v7oA+/
By71ab+Xzn9v+KEvOcePfOjfEj/8zfe9fujD+37cD3/8KnxbAPkyn6wA9PpN
+NUA+sf8XQHcT/TrhQD8Tb/a+1Ev/fpoP/KlXsX9yJd+be9Hf6nvSD/q/1t4
+QD0muP8G0D/2K8dA7hv6demAZwn9vfrAcw39j/OxP11g/BaE9+H9OcmE3rQ
T0+Y0GOZcAHiA/TfXhPngf6sQXz+SmG3ifvJLhxGfMKtwhdN3D+rhOcQb6wR
XhXE+rcLpwXhl7XCW4JYf51wHuIT1gvvQnzkDuEqxBvJwh2x9TcIDwaRf4rw
+SD0SRWeCeI+u0d4hYV8GJ9qYf+7hB+2oBfzybWgf6JwkQW9Wd/+WDz1aLGQ
D/UzLXzfrRD+1sJ55/yYsnCe44WXhuAPzqfkEPxAf2SGEE9/bAvBv/RHYQj3
Df1RFoKeev3/AHtaLng=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy/DflyUaVdiJVGYIaGRFLEW7pNaRGML+MNsY20xa1R/QG40
QlbpYBErwUILJOOnnCjnwR3HHd7B3fc2wzotiySLEiyJgn7IwMgadZ/37Xlv
sAF77fv9fj7P836e9/P53JlfmPv8IpPJdCL8q//LT3A2IS9xeu2jEcpUrUXp
5nvIz6iKyRx3vLA/X70Q/onj8xdVfV3dipXCqlDtsNg+WcH3tytbxljpLcKj
xWqs1LLuJn7/mrKEX1giHFemnhgrrY3mem/o9TKuFU7eqde7vJjr71IpKSmO
RcLZ5codW/HyfxdlvwqVbh6O/1e46C0VzndkTtj0to6/bla4pkq9km5+elo4
7h0dj+UPYfu76o6KydOTwqoa8f4iXFCDeMjJe6AfeW6PqjZmrWT/eyr8901y
5ftqTV71RnJ2rdZ7fEI4Zq8yD7cUkUf3Qr+fha379P4p5KIP8P64cNqH6lJC
XvUF5l8H/kl4sA71+pF61KuToVDWeeGt+9EfY9SnQdfTdk54ogHx/0C9PlLh
7X0jwiUHdP4J31G/j5H/WeGoRr1faJh6NmK/M8KhRq1n2hD1bdL1zPtSuLYJ
enxBvZvUVI479rRwXrOuXw7Z34z9yata9PsHyJUtqB95qgX9Tc5uXcjOVp2/
QY5pQz+Qy9r0fqavWL82fM98Nh9EPZiv9aAKL1dMPaLbwV+zvu2In+sNteN7
7pdmRb99LtxghV/JpkPo31PC2w6pXHfsYvLgIfj9pHBSB+oZYn90oD7kmQ74
9TP2y2HE+6mw9zD8doL9cwT6DAqXR5jPJ46gXlwvq1P7e5L72Tv1/lWM12JD
f7H+JbaF9RmxYT5QL3UU8VPP1qPoZ+ofZUf/fyOcatd++pP9WmCHfuznervW
J/179qsd/Ug/zNu1vhWj7N8uzEP6K78L84X+q+2CH+nX412YZ/T3XBf8wnmQ
2A29f2W/d6P/p4R3d+P939j/kfc536a7sf5F+sGBeDgPtzgQzwz94YDel4T7
HHp+Dv9FvziQ79/CsU749x/6x4n5xvm8ywk95+knJ/rJJPN93Knjnb1COKYH
/X2l8JM9mAc8H8p6tB+WXC1s64E/r+F51IP8zcLLXMiH589mF86L64VfdcFf
PK+sLsS3VPhbF86nZcLRvehni/CGXviJ52FRL+oTI9zcC/14fg71Yr/bhK9y
6/q0kNPc2I/fv+RGv3L9BjfmGc/bU27ofSPPX4/uz+cY73oP4mG82zzI/2bh
fR7UZ7nwoAf+ZLyXPdCb8SX1oX9uF362D/nECtf0IV7eJ4w++PEu4Rk8D/H+
sfoY/H638NZj+J73lSo8N68R9uJ5iPeb3yPfJ/G+4cX364RzvfDrfcLlXvQ7
n7u88Ota4Qkv+vFe4Vt90Iv7ZfmwHuN53af0P7Ldh3mRIHzeB32Zj6V/4X3s
8X7Uf7VwST/uK+QOPI8nj/SjHuQbBjD/yWoAfiRvH4AfyK0DmJ/kMwO4XzCe
KD/6m7zSDz8wn1Q/5iX5KT/mK/Mv8ENf6rXTj3yoZ70f+rBeDj/ipf6hyHPW
54If/cj6zWP/omTh5QHoez/vkwHkt144M4D6PCCcH8B95kHhHQH0T6pwbQD5
PCTcGcC84/vHsX4G1z8XWZ/xzSEeC/NbasCfzC/RwHnL9zcZC+PPM3CepQgX
Gwvj3W2g3oyv3UA90nh/NpD/w8JnDcyLR4SnDfTDBuHrgvCLEl4VRL9tFE4P
Yh5tEt4ShP8fEy4MYl5nCFcGoVdmmP8HKWEXGA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYxy/DWsQsjRJrIiYZGhpJ2fUD+6ikYiyBirDd2mTWrP7gcqOR
slIHy1gJJloQGXAgP4Tz4A64O+7ge3eb2na1tblIown9YCzohyaOUVH3eV/P
e+M2uL1238/n+zzv9/M8n8/ywqK8V+aZTKYvIn/6Wz5DNqv/iatrNkYpS43u
i1+bQd6pJnPdJzcIG4VKfyn+/poKTaVYNgqrIr3evonP71WxQ7Y/NguPFKuM
2KEVT3P922qVpXLTFuGkUvVlOJy9lfu9q8oncs3bhNMOKvvW0RmycQjxZQnn
lKltkQC4fqRcvZkR+2KmsPU9VVtTU8N4Te/r+IeZX1UF4nuS8XygXo18HhN2
fIj81jO+SmWpDE6lC++pQj4PMd6jqsmaUbFWePoo3vcA4/9IRZanrBI+fEzn
t28l86lWy8onvl4hnHAczy9nfse1HwcShVtPqPjIBvcw348RzxJh8yc6P9td
zL9GXU+x3BYvfL4G719IPWqVO7F8YoFwwafwO4761Gl9h24RHq/T8ebeTL0+
Q/wxwiUn4cc86ve51nfs3yv/c0y91rP4H+E99Vq/2L+Ew/WIf1o4rQH5XReu
bsB+fwpPN+h6qL4ibGnE878LG42op0nhZJuuN/cvwodt0GNceNKG9WPCOU3Q
7ydhVxPePyqc0KyfD14WLm1G/N8LjzTr9ZXfCWeegp8XhVtPQa9vheNadL0n
XhK2tsAfrr/QotLT053c39yK/fj+ula1XxeIsKkN/fKj8O421A/zOd+Geme+
qe1z9ahqx37U61o79qOeBaex36/CvtPYj/ondWA/+lPWgf6nf+Mdul+XTAln
d0Jf+u3ohF+sh3i7yosIMiNcYod+fwsP29E/s8LqDPqX9dd0Rudz7gapzxgH
5sWNwusdmAfz2e8OzCfWe60D9cp+CDvQ77HCsw7kz/5J64I/7K/CLvTP7cLV
XZhHi4TPdiHeOzhPuhDvncKruxHvYmFLt66PN9j/R7pRv5wPRjf8Wip8tRv6
cp4kO6FvknC+E/V6L+eVU/u7K1nYi+fNnF+TTuiRIpzogh6cdzku1Cvn4SEX
/Fsj7MLzlgeFx1w4nzhfE3r08/M5f7f3YB49LFzaM3de2/F8uZnzswf9+Kjw
ol4dT/ojwpm9yH+d8FtgcxrnbfR3xnspup75xPVhf+a/oQ96Ux9rH/znfG/s
g/7U+0If+ot+3OQG0y+zW683LRN+3T3Xrzq3Pn+t9OsrN+qffpk86M/7hNd5
cJ7eL7zbg/6hXyc8iJ/5nffofg2nCs945p53qV7UG/V62Yt4qWeVV+n7B/0L
ejEPqP81L/SmPyv7Uf/0r6AfepMr+lGP9NvXD/1ZD7/1Y97z/Uk+PM96yvNh
njPeMh/OL/7e68N5wnjHfdCH8d7tx7xivNl+1Dvje8cPfR/n+ejH+3nf+MGP
fud9JH4A9fCU8JYB7V8r7y8lA/CX96v2AejB+9XwAPLl/WrBIPTm/UkNoh+2
C+8dRH1lCzcNQo9nhb8ZhB47OB8NzJtc4aUG8nmO89JAPi8I7zBwXuVzfhro
/wLhgwb8f4nz1IC+O4Wd0f24PhzdL0/45+h+jG/WwH2C+SwOoJ54X0wLQB/q
lYXf3by/Fgawnvrvj66nX9UBnMe8H3YGEC/5bADzh35fDqB/uH46oCL/D/C+
vTCI+zL9Xx3EecP79uYg+pX+W8C76H8xnh/jffcI9rPS/5Yg8uX92AiiX6nH
xSDq9xmeB0HoSf1uDaE+WA/JIbyPemeEUE+sh/wQ/GI9FGH9ued5foRwPmk/
/wOMfuog
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn9Mm1UUbQz6R100miaiiYhxMbhMQyRZiLHzbcMxJjpA3ZjW6Sqr3abS
oZ2MkU0mzZDMAcqmZTiBllEYdP0JbfnRr1+TiUk1MVkkGhLFxGVJiTHLZsj+
WOw75J1ZEiAn7/vuu/eec8/9Hrc21u27y2Aw/JD7lf/Vj79y6VbD9ac3raIq
sVwbK7IR7xY/ZjIZnmtW0aXfLLHyfL/I/fn0bYVFo3jMlf3ZwuebEO8Nhf9w
iliR6+Auvn9EuLK1sdcULm6V8Qx1jHdcHDX5K3coXNomvA5zZzXjn0B+VQrX
tIt/Syz3b+d9LplPLbHjpMiF20ts+Fw8ZenaTNzdKSy5Ahmv+JSoyyVMHPhC
GBc8/2xjfl3y/mpie7foc7vdlcy3R9hstqtbFV7pEUstpmeItS/RvxcV7vhK
pG+WLFawnl7UT1x4Ruarb2F9Z8Qhs3EXse8s+kfs+FoseByzmxUu/wb5ERvc
6CfxvFv2r4u4u0+UlZWFievPSf6yxMX9Mr6Z913rF+Zcg4gD30r8BPNvPo94
xOI75M/6CwbAH/tjH5DnC8SZAdk//53+DoptSy297H/vIOohXyuDqIf8WoZQ
/0vs/xD0Rz2t9aD/L5MPj4xnpP6WPdBLDfnxQh+1Cke80CP1Wzgs73uY+m4d
lvpyvk7+hjEvOxWuuCD7U1ZPPi/I+Tm/W+E1I+jPm+R3BPrhvF0ZEXKe3yLf
PtzH+ez34fwd8j+K9znPDaOynrs57/Oj6O8+hdePgc/3qI8x9M+u8I0xzMMB
6uUi9H9Q4ZmLuO8D6mcc/tCocPs49OqgnsYlH5Ymhasn5PuGj6mvCelHPqfC
Jj/m/RPqzY96mxVe9EOfLdTfJfT3iMLeS+CLzxcEoJfDCm8IwP94nz0g5/P7
jxTuC8DfmG8mgPoOKXw7IP1nifWWBjFP7Ic1iHjsV28Q+e5X+HJQ1tPC/q8E
US/5WRdCfu9S76F8vk+HoM891H8I9VE/10OSLxv9em0YfkU97gzDH6nfjjD4
f1XhBM6dnIflMPTM+SmKoF7OW00E/ed8noigHs5zJIL86Q9XI/n+UhiFP25S
eHsUetvIeYtCb88r7I9KPZue4/xF4T/ED06iXj5fMYl5YLzDk/CjFzifeN7P
+3/D8y7mt2YK+mX+G6cQn/7lmEJ8+tUQnl9kP65MwS/Zr3ti8LdXON8xxKcf
HYih3/SffjxvpP/8FMP+Il+GOOaHfD0bRzzy1RDHPNAPz8bz85uPgw/ydSsu
4zvo1+sT+ftrTwL+cWe/JOBnQmE9kd/vG6uYfDw5nc9f/TT6Q9w5jfv5/Mw0
+s14f09Df+SveAb1k7+6Gcwv+WvHeQn5m8R5lvVdW32f9T8yi/fZn+pZvE/+
juE8y34GcO5jv/9cfZ98mOaQP/naOgf+yGfzHOrn/hibw/xxXhfn5HyWc57v
S2KeuD9EEn7LfdGUFIb/f895k9h3exX+JQk+6C8FGvyK++JRDfuW348bNOiH
eIeG+rlv7Bru531tGvRNP+rTcD9xGOdG+ldGw/7k+3/hPjfzva3he4/5PpQC
H/TL0hT6yfyqUvn7zJpCP7jPjqag5/fpzyno90OFJ1KYD/r75RTmg/7/ewr8
cl+s4L5y7pMHdHmfgftrnQ6/5j7aomMfc39ZdMxrq8JOHfUdo9/r8OvjCo/o
6Hcb/V9Hvz9T+Fcd/uviPtCxv04qfG8a/HVwP6Shv06FzWn06xT3RRrfA6cV
bkxDD93cH2nsw54c/g+6x/fm
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVV21om1UYDVL9UYeiFJyCtWKRKlOKwuifylWHc1JwK9h1Gj8Wt7kPtVm1
s2vrttbGbdUt6ZZ2S9Z1bZOuaddmab6/8+YN6IQoCMOhFGwFx2BDZKxS9mP4
3hPuCX2hLYf3vfc+z3nOc57bpy1tzTvvM5lMPxk/8q96vNbGyr23X3i1hDaJ
ymse6yfE20R3lX8jsWbB+918v0fc2hIf3aOwaBNP2W7+yv20diH3/1ThxQ7x
nNn+2mdcf1D4Ny51fa5wTY+w68t1xOKwWOqq8nN9fa8wwtm+j/v3iZ+LxSae
t7kf8TGeRZvY31h5jfFaj4rmeLWtHP/x1fk4BpAPcc33iJ/7BU7I+HzlfO3C
bNc7eP5uh9hlPIyvfhD5Mf6VQWGE42H+2in5/XXme+y0MMJptDIfJ77fr/Da
IfGmQcgXzG9I/Fdntn+psG8Y7w8w3zPI5yuFG86Kl43nIPN3Sf6KXQpfcQmD
nn095MMt93/4kMKt5+T60GHyM4J69Cp8YwR8fUO+zst8Mv0Kd46C72/J3wWZ
3zPHFK4YE4XluoXj5HNM5uP8TuHiGOp9gvyO4zy7ws5xqdcfHeR7HPU+pbB5
Avpzkv8J+f7+YYVrPVh/hvXwyP0HXArf8uD8c6yPF/ycVzjshd5GWa9J8D+m
cM8k9DHB+k1C716FN1yUelqeZD0vIj6+XzOF/cdZ3yno8YLCV6eE8fsI42nw
ST7NjHfEB30xH9M0+Ge+O6aRzxD1MC33M51WeN2M1PNd8uso4ZMK35lBvKxP
6yXokfVLX0K+rG/NLPg8qnD/LPrJRj3NQv/UU9Oc1NsS9RaYQ/xHFK7yYz31
2umHvqnnBb/0kxe7qb/L0q+28L33Mvgnrgis7o/1AcTTSX0GwDf7zR0A3+zH
YkAY2ze0K3wvAD7Y3/Xz8Df2v2UeeqU/OOehF/rHD/Oy/lvpLyslTP95Poh+
pD+Zg+CDfnYyKNwul6vs50Hkt0vh20H0E3FtCPzsVLglBL3tYH+EoBfiZAh8
fMx+CUEfFoWrw8iPeHNYxvM4cV9Y8hXfzn4KI3/i62HUm3htBP75kcJvRbCe
uCcC/yD2R+DHxIsR+B3xo9HVeEMUfkV8IIr4iX1R6IH4jyj8g3hNDPkTvxKD
/zJ+awz1IZ6ISX/Sia/GcN6HCj8Qx/r32d9x9MO7Cu+NYx60st/j8LsWhX8p
ff8O+z8BvrYq/FIC67fRDxLg/z2FhxPwD55/JQE9M767CcnfTea7Lol8WN8P
ktAf9eJIgl/qTU/ivkG93klK/6ymvp9NoT+p/9YU9M9+GUiBH/ZTOgV9tSn8
T0qAdvpPWp7/L3FzGvxw3vanMY/Yv9E0/Jfz90YJs9+fyOD7DvpVBvqkPxzK
IH7O40AG/cZ5/FcG+dJvqrLgm371Rhb+Qn/qzELPXys8k4Ue6X8LWfgt5/VD
OfQr14sc4qGfteeQD+P35jDvmf9vOfQT+azQ0C/0pyc16I3+s16Df7Ceb2vQ
S/m+pIEv1rNXw7xkPd0a9MfzQhryYX2KGurH+P7WEC/rcU8DP+T/sTziY771
ecwr8r0pDz8k35Y88iW/3XnwTz6defgR59FcHvXuo1/n4e+8//yZR7/z/rOS
R315/3lERzwD9HMd8XB+vq6jfzhfzTr8nvefDh38DNLvdfDD+8+Ujn4v339w
no33n99xXtNZzgMd9XIr/GAB/cH7RG0B84D3jcYC+pn3kZYC8uN9pa2A/Dyc
HwX8vyDvN/8Des0SMw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm9oW1UcDVL9MIeiBJwD68QhdUwZDka/VK46rJOCaz/ohCCsbrPblGbV
zq4tW1sb19Wtabe0W2LXtU26pGn7+vL/T/Pn5QVmhSgI4lAKroKj0CIyNhn7
MMw94R5YoJTDe+/e3++c8zv3vtTc2nT4MYvF8mP5T/5Xv93lX8+d196qoH3C
qtUfPE38sXhvtdParbDRLF50rP9yis+PirpNN71fKyxahc9eN9jO99tEU7La
8aXCt9qFx+12n+D3p7Beq8LbuoVjvTFJLM4IrX71gV3hXb3iptde18b1+x5d
f3+/+KlUKn3F/Rxyv+dPKmw/K46Uf6zXcg77dSg8PCjr39TJes6Djy6F9Qt4
n3wIJ/ghXy3DokyH/QzrHUE95Pf+iCi//nof678o/quxOb9ReOCSsDnNe/3s
xyWK92ps3yq8ZVR0WbUfzrK/Uax3TuHAmNhoTE4Mst/L6Oe8wrVXJJ+dF9i/
W5TpWx9SeNmN/YbJhwf6jCh84Hu5f/0l8jMuXi0X7FJ4bRz6jJGvq+DrssId
E0L6zU3+rkkc8ShcNYl+xsnnJJ5fVbgEvPsa+Z3C+pMKu6aw/zT5nkJ9XoVt
06h/hvxPo7/rCm/3ov8A9fBKv9yeVXjDC33nqI9PyH8LCkd90FOjXjP4fl7h
7hnZnxakfjNYj/vtvY76WU8AOOtXeLMffmc9dr+sv5H1/OqX/b7N9WsD4kR5
QPn9eED6q539W2bhX/JzaPZRPpdn4f8JhXcGZX9PU5/hIPilnneDWJ96H5iD
nqMKZ+bgt4v0zzz4oN/658EH/bg2L+uppX8bFmT/j9Pf+gL04zxYNfjfQb9p
WI/ztaJB/176bxH5wHn1LUJPznOVjvr4fI8OPvh9iw7+uL5Hx3xyfku6XK+H
8/tQh38H6N8Q+OD8NoeQp9/RzyHsx3m9EUK9Tvo7BH3J346wrMdFfm1h+IPz
ORSGfpxPIwy/UJ87YeQz53t7BP7l/H8YEeV4quF+AxHMC/VKR5D/1GsjAv6o
V3UUfmH/+6Oon/z0ReV6K+QvWsHMy9tR6M083RLDfFCv92OyvgDzuTuGeWGe
azHwyby/FYMePB+ejUN/nh9749CT59XJOOab51MgLvO94QuF/4gjb49zXhOo
r0XhNxOYjyOc34TU++VDCk8nwMdBznMCejcr/EQS+U1cm5T9rBIfS0LvTznv
SdRP/HMS9XI/Swp8Er+RAj+HmQcpnL/EYyn4g/Uvp5BXnyn8IAU/E+9MYx7Z
/ydp2d9HR5kfafR3TGEzjX6I76bhH/L5ypLUp+dz5ssSzlfyP7iE+aE+mcr7
1O+fJezP+8K2DPKJ95WmDPKF94P+DPxHv8QzOI/op7UM/EC/bc3ifkE/NmTB
D/16Oou8oJ/1LPhifvyVhV7ML2sO/DHf3s1hfc5PRw568/1gDvtx/ZUc+GF+
PZWHnqxH5DHPfL8tj3lmPb488oTz+Fse63G/KgN+Z30vGPAX69tjgB/m2wcG
/M08aDFkf9XMi15D8nGceecxcB4xXyKV/Zg/JQP1Mp/+NqAP8+9h5X3m33MF
+Jt5t6uA+WQe7iugnivM4wL8w/OtC9+v8r7iKuA84Xm4UIBfeV+5UYC/eV/5
s7Iez9f7BXk+/Tul8DMm+uF5vMME3z6F3zGR17wf2Ez0y/O93YSevB8MmZgH
3gf8JurhfcQwoS/vL7+bOB8WeR4AO3WFnyzieZjnA7AzonBd5XmM50URfPD9
1iLymOsPFDGPsp7/ASILGgg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVm1InWUYlrB+WBSFkAWZ0QgbFZIw/GM8fdBaCDl/LINDkJRY++FpYNgm
paLN2ebHdnQ7zjn1HD1+Hs/398d73lPO1dlqEUkhNIOGMImQLWQ/Rue55L7g
CL6Hi/d97ue+r/u6r+d5rqm14ZMHioqKrub/9a/8rTusyc6dl1/fQ4eU++Dm
8S7iD9SJUveVbsFGk/qv0vJYD99/qp7tvX24V7BqVe9sHrd9w++P6fc3Tgq+
2Yb1p7j+Sx3/YL/gig6Vf3Z+y3hfq+rqav9pwVVdqrm5+dYZxu/W+5UOCq7v
Ufl6aoe4X6/+vnlYsPWkclpr+89y/1Nq0Lw7d07wUD/qtTGf0yqf3uaIYM8Z
ZckvGGV+gzpeyQXBLUPIx858h9X24Uj5mODdYb1f5UXmfxZ4XHDfOeBLrMeG
9ROCy0YQ/zLrG1ENkfIHJwXPjaqSdce/xNbz6vPakvUpwTUXVL5dkWnWb1dj
drvdIXjNrtdbneRjTL1oGXxjRnDjRfRvlvyMIz7x1jjiucjXJehjTnD7BPia
J3+XkQ9x8aTm+6MF8jmJ+hYF5yZVfjsHcdWUXl+zJNg2hf4R706pa7lc3bJg
y7TGOWJjGvpzC97nQD7EfQ7wvyJ426Hyz07ieifqJw44dX7PE5fNYL1HcMeM
yrfPTXxzBnomfmsW/HrZz1mt/2riR1yF+VhdiMd6f3Vp/p9ifTVziM96xucK
9y+aB3+M//E89EW8Nl+Y30sLmBfioQXMF/GdBawnblwEn8w3sYh+EFcsqezd
yg3m17Ok+XyfeGupsF91y+CD2LOs+Rpk/aVuxKM+2t3gi3jDDT1SX2oFfkf9
OVfgX9RrsQd6o54P7GHqvcUDvXM+xjzQB+cn59H5WDhf9z2Yb85flVdFyntv
c16bvIjP+bZ5wRfnf9WLftAvdr3aj9roJ/t9up579B+LD+/pTwM++Bn9y/CB
3/OCd3zgk+v3+bE/4x/xQ5/0pz4//J35xfzgj/Vs+9FP1lsegD7JT30A+ZC/
7kAh34GA5uco+3MrgP6zn2VB1Mv+vxvUfmVSPx1B+D316A6i/z7OXxD5BAQ/
EUI+Qc5jCPMSFvxFCHxGOZ8h+GNc8B8h8JPkvIbhDynBr4VRn8H5DcNvTcHT
YZxf33Gew/DLVcEPRRDvCuc7gnhXBX8WQbwfOe8R5HdN8PUI8vuJ8x/FvPws
+NUo6v2FfhAFPzcEj+J7y3X6QxT95n73otDDGv0iBv9m/h/G4DdZ+kcM/kE+
zBj0R/7u4PtITPALceTLfjTG0X/2rz+OfNnfRBx6od/8E4ffUy8VCdRDfTUk
oDfOd08C/sD5DSV0Pb3U91YC+uI8PJ1E/jzv6/Yw5+urJL7n/cKTRDzeT/5K
qvyzc4B+lkI/eR96OwX98f7UnoKe+X4hBX/h/WgjpeMV8X70aBr64f1IpXG/
4n3oWLowP2ca5zH94rc09Ek/KTbg96z3GQP3D/rFAQPnMfl5z9B+PEF/azHA
L+8nXQbqId9jhtbjK/QHvwE90R9yBvRAv/7bgF7o7/eNwvPhyQz6S3+oymA+
6A+HMjgvqJ+mDO57fsEnMtA3/cGWwXlIPS5n0E/6w2oG+qI//JmB/qnv3Qzm
MS34cRPnAedhvwk/oz+8aYI/+oPFhB44X20m+OP8DZjg7wfBLhN+wfeGiX5/
L/h37H+U++2YmBfm93AW+krwfMhCX6y3Not+kJ8jWfhDSHBrFvMZ4fmRRT16
/f8RpTpE
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln1Mm1UUxutkGhnZdGniRyJiXAwu0xBNFv7BXHVRZ0h0/KEzaZZIJpn6
B3UJBhlRtow4iQrTbgriBArjY9D1A/pdePtWGYvdDHEON9HBdIiCc7IxEZXY
+zTnadoEml/e23PPfc5zzn3vLa8se3mVxWI5mfrT3/JpaW6+87uFBx9L01ZV
kjtx3znyi6rRXCw8L2yUg7/n81ewflJYVSod7weu363KgvmrfxSeqlIVFRUz
ZMubasJpj10QLqhVnfaShinGe1vtsbqemhYu2qtStEw29un9mi8KP7cf+fzE
/erV/LbgEbL9HaW/fub+76p76ue2kZsadL715IL38Huy+/1sVo06Xh15VxPy
JRcdVKlwc9x/6aCyNZpVZONDlVgsnGT+Bz6CvpnzOJAfz3vHIZUK/xL1mTqk
TiWTpdSv57DOL5/62j9Wr6cEYX2KP8H+mfo1Q0/We6xZ5/sa/dDUos9z4qzw
9k91fXK/pT6t6gFb4+PfCM+26vpWjFOvz3T8mq+Fq49A31PU73PwV8I5bcjv
JPVsw3lPCCfbsN+X1Lcd500IO9pV7oTzikG92/V6c1jY1gF/Ral/B/QNC29w
wr9B1sOJ+gwJzztRfx/r04n8PMKDnaifm/Xq0vnYybVdarrG6uL6qS7t/xLG
23JUXS+0rRtkPY+qp6drHFyf1416k+3dOj8b+Ux3dj7FPdnc2oPzki29qI9X
eGcv/Mv9x3r1/la/8KY+HW86QH/04Twh4Wt9iBehX44h35hw9Bj0HaF/+jEP
WK/9/SqVXtCkn/rhjy+ESwe0n18Ypb8G0O9jwlaX9s8i/VPtgn/pr0kX9Mz4
7zj8Sn92Htf7F9O/OW74nf7e7IYfztCfbpyf/dHiVqn/deyfpBt6c36uuLPn
ZZEH+XJelnuQL/vZ4YHf2P+jHvgpM0886IdLwhu9qNcv9LsX82dW+AMv5u1v
9L9X+61xXnjBCz0usx980OOK8PM++HOB/eGDH64Kh7E+uMh+8aHf/hLOH4Qf
/2b/DKpHUp9/hPcNQu//2E9YP70iPIP1PstV6a8hxF8l/MwQ4ucI16afrxZ2
DeE+ulF4agh+Zbz1fswP7r/FDz2Y3xt+zNMl9qcf/XJd+Lwf+VGPvAD8/qfw
owH4g/raA/D/nHBHAPF+ZT8HtF+cM8I3BfXvM/dXcRD9QH+8GtTzp4fzvzWI
+c55fzqI+Jn7PYT6078Ph3A++n1nCPrQ74dD6GeuHwuprPeH5RD8xvibwvAb
998RRj3o96Yw5hf9boZ1Pz3E81wL47z0+/0R3U/jPP/2SLY+DRHcH/R7NILz
0u+XI8iXfi+IIt/fhcuiyPcPzqMo9GH9/FH4i/WdjaI/6Pe7YvAv/V4aw7yg
X96KYV4sc37FMN/+Fb4YQz3pd+sw9KA/nxyGHvR79TDqRT/3DaP+9Psk1tfd
LLx2BPPoFmE1gvtqjfDuEfglT7gT68fXCp/F+p5bhXMMxF8vfLeB+FbhzQbq
wefPGjj/OuFdBvqb++01MF9yhVsM3I/M32dk93fSgH43CF8y4Afqt2Lg/mf/
3h7PrkdRHP3O+m2NQ1/WtzyOfDj/9sThH/rFEcf7B/01EMd85/wdTTP9eiG9
nv5eSsdjv95mYn6zXzaamFfsrydM1If9aDMxP3hfVZmo12nOexN+5v3XnY6X
5Pw3oT/vw3Mm5jfvwwXk42D8NQm8H3I+bEigv/g+WJLAeSd4XySQL/OvTMCv
vA8PJDAv9X34P9SOPTg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9MFGQYx2+GVmiSRomWiEmGDI20iH5gr8o0iqawpraxtpgxqj8gNxop
K3WwjJVgoQaRAYdyIJwHd3A/OO5nIa7T5TLJokKbREFWhGZU1L1f9nxdt8Ht
s3t/Pd/n+zzvuzi3IPuFaQaD4WT4T3/LJ3glIeeW35evmaIMFdlv/HU2+VmV
7Ygtu1XYl6tGsxyxc/n7i6rfWNhzm7AqUK+kRW65neO3q5yKwJU7hAeL1BMX
dlTFcP5ralX4s0A4rkQtKhs5cyfXe0PPL1oonLxbz49exPX36PnWOOFNpepU
KJR5N/crU3l5eUNLhAvfVOH/u+7h/m9hPrmyXC0Lb8j5cW/jPNzP8o6KNm+4
cBfPV4H45gvnV2q9ps/jefermurq+dHC1/ar8PFXzOH531U7wwtS773vKZ2P
mYynCvHfJBxzQF1NyKmYzvgO6PXM04RNB3X8oX/HJN5DKpy+kb+FU9/X86Mm
hA3VqmwkK/UP4b5q7D8uXFmjGgvTyn8T3voB9LosHFcLfUeEh2sR74/Clg+R
jyHh4sPw0/fC6iPoPSgcUQf9vhXOr4M+XwuH6nCeL4WT67Xf+r8QrqpXYVzy
ufC1euj3mXBOA/Q5JexrUOH0JXwqHG/E+fqE9xoR3yfCo0bEExTe1Kj1c/iE
bY1YzyMcc0TrUd0tXHIE+juFB8EVXcLpR+E3m7DpqN4/j7/PalJh+03Ymd8m
zOd6Z5sQP/dLNaE+3cK1JtQnz2doRr17hbc1Q18//dCM9RhvUgvW+5j+aIFf
eoXHW3C+E/TLMcR/Uth9DH6j3nGtyF9IuLQV+TpNP7XCT8xfZhv0PkN/tWF/
5jvarPQX/VBs1uc3nhMeMMNP9I86jvjPCzceR3+i3yIsOt60b4RTLPDDdX9a
oBf9W2NBP7tIv1r0+Qbo98mp8Zfo33aM/0E4tx3jh+nndoz/Sbi3HfqN0t/t
6Ec/Cyd2wA+/0O8dOD/rd18H+sEY/d+B/LDexzrg76usByvyyf6w2Yp+8yfr
wwr9/xJ2WeHvf1gvVtT3pHCsTetdaGB/s8Ff7F97bPDDDcI2G+Jnvxuy6fXW
3sh+2In+y/74ZCf2J5d0Qq8ZwuZOvV4kfx/shH43C8/tgr/Yf9O7oCfvx1e7
UI9R7LcYn8p+/hXGR/E+nGWHX9j/V9tRP7wPC+3/vw8b7Do/L/M+PGtHvLxv
ZjhQD7HCqQ74l/fTSw7t7xOLhWsd+r4+zPvvtAP1df3+cyLf9wqvdCIfy4S3
OZH/ROGDTvSnJOE+p+53phXCE070z2ThJBf8sVL4ORf8/gDvWxfykSIccCEf
DwmPu5CPh4WXdkOvR4W3dkOvNOHybuj1uLC7G3qtEb7cDb+s5f3uxn2QLpzt
Rr9YL1zqxvnIXW7Eu0542I1+wvUX9KB+Vwtn9uB8jwm/3oP9GY8FXMR4L079
Tn2iPZhP/dZ7sP59wsUe5G+5cIsH9zPzNeDBeylBeLYX9cf8Ky/8wvfOdi/e
d3xPNXqxP99f57xYn/6M8MEffO8s9KEe+P5L8eE+pN83+pT+ot/zfah3vp92
Y7yJ778ajN/F/a0Yv4V+D/nwnqLfL/nwfqDfJ33QK154nh/nX8r3mR/9hfpk
+LX/nqd+uX7EQ7/v9KO+6fcqP+qb+Wjzo77vF+71w6+rhL/zQ88H+R70w6/M
/5wA/Ep/JAZQ348IrwsgX/RTTgB+pd+KAjofO5TwvoCu1yz6vSmAfNDvvgDy
QX+fD0CvDcJjAeiVITwzCL2eEo4PQq+nhdOCuG82Cm8Own9ZwgVB3D/ZfO8G
Ec8zYf4PaK0Lqw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx1nT/rhMpt0SLRHTGZoaaRn9OPv4IxGjBCp/NLIgNBQXp0Wh
UIpBIqVAonVEBtwhP4TzTuC4wzv43ve2su1qa2uxGlvSlmPDtVbSXH+07vO+
Pe/yNievfb7fz+fzPM/7/TzfhQUlubtvS0hI+Dr2T///v9/R5/9csS7+Z6Zy
Z4wfziHvVNdz/OeeEzYK1KjTHnqG63vVAZtldLOwKlGWUefvT/P5g8plt1k2
CF8t1fslK75/SK2O/WzCKRVqaV7d+se53xG9//ZHhdMq1Z7Y72Huf0zl1Zml
DwlnV6lcf3L1Sp5XrTaPH258QNh+XMWu60zl+Sf0uvV+4fraW9dTPlKx5ZXL
hD0nNbu5n6pTdeZU6grhonqcx/PTGpCPB4VvNqjqyZx03tf4WMWuW7xKuOY0
7r+a8TTq/NUy3qQzej/7I4zvjCq3ujPWCHeeVX+l5iUyX/ZP1DfRaJSc/in2
S2f8Drz/mPAVB+rF/Nc3ob7kHZ8h/ieYn2bE+6TwRLPSemI9PZ9DT2uFy85h
/Snm7wu8Tz1Ma9F66FvHfLbg/PXC0RbcbyPz2wq9UG+NrYhvE/PdivczhPPa
UK9M5r8N+d4ivNip9XWN+q5x6vxlPSt83Qn90w/ZLugjW7jfpffvpH+S2rWe
FtFfFe1Yf4H1a8f724Q3ntf68G9nPc+jPjuFZ3QgnpdY3w7oJ0/4+w4dz/Rd
rHcn/PuKcHOnvr8tn/XvUpGp1LEC4cIu1KeQeujC/fcIL++Gnl6nPrrhv73C
N7rh72Lq5QLqsV84eEHH8xWfT+nBfblfVQ/qyfMnevA+75vVqxZUT37H+Dy9
OI/xW93IB/NV5ka9mN8xN/zO/KuL8BPr5bqI+FjfaR7UJ0t4jUf7q476KfLo
+KeotyaPipUrn/qMerAf9fyPB/6n/tO88BP9U+BFPPRboxf+oH+/9MLf9P9N
L/LD/rHsEvKZRr1fQj3Zn06BE9i/jPg6+90f8fUl9EMf/LFIeBt4+kL6ow/n
JwsPgS330i99yNdc4eR+3H8O/dOP+KzCx8DW2fRTfD1R+Fp8/U76awDrFuEt
A/AXuWIA9Zgh7Mbz1pn03wDqw/1n+5CPWfSjD/W6S/htH/o579vpw3l3C//k
w3lJ9OuganI45s4TXjsI/d5D/w4if/OF2wbh9wX08yDqwXzf7kd/uI/+9sN/
i4X3+aFX1q/Zr/0wyfn2rR/3XUr/B3Bf6mFVAPqjXgoD6A+cZ2cDOh4H9XUl
gPlM/f0dQH45r5YPIV7qddcQ9EA91w+hv3L+mFhP5Hy5gfUo/bHkMvLFebLj
Mt7n/KjFuoXzIoj1KL8/fou/z3mREsT7nA+5QeSD3zNVQeiB7AsiXs6LieCt
/WFeCP5g/8gK6f3Gtwq/F0L92G88IeiX8+GXEPrXi+xnw+iHnAebhlGf//rb
MPoP50H3MOJlPxyLr78sPHME9+M8UCPQ56vCB0fwPcZ+6xpBfjgffhjB/V5j
fzRQT/br+Qbi281+aSB+zo+teD6xiP3TQHycB5UG9LyP/dSAXjlP+gzMZ86T
qIH59Ibwrzgvv4T9FutOu/CcMPxwgP03jHjfFM4M43vlLfbjMOZVqXB5GPl6
h/0Z+xWXCfeGMW8OsV+H4Ydy4Z/jz1ewf8f3f1d4lol4jrCfm+i/R4U3mIi/
kv3dRL94X7jUxDypYr83cf4Hwh0m4jvO/h/fr0b4R1P7NaeW88DU9TE/FL4j
gnyd5HyIIL+nhG0R5Kee8yICvzUIl0Sgv9OcHxHcpzHG/wJNyuDN
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9I3GUcx4+o/rBRFEIryIpGWKyQhNE/xpOzOZc1tZqurlVml9sqb5bL
1LZcWiZrdzbdppmpp7vT6e2833fe6fe+B7XAgmA0CiEXNIRJRG0x9sfonrd8
3scJKi++932e5/P+vD/v5x6sb6p56yaLxfJD5lf/l58DJXm1L/772NPrVKHy
veUXs7xbPWJ1lO4SNurVWnV0pJbP96rMx6/XCasmpdd7mZ9vViV5F1yvCK+0
qPTVQutuvv+Rfv4Q13ugA+txf3VY2Wy2SzXCRZ3gKq5/BJ9/XriqSznMq4XP
cb9uldne/qyw/XN1f/flnyu4/xeaq7cLO3uVNbPANp7nqMo8jj4j7PtSr+8p
4/kcKrN8cqtwo1Ppf+SiPr1eS6nwtT7USza+UjXRglvIPcdzn1f16/rayBsH
1H+F1ju4/sqA1vsC2XNC/bi0tMTz2U+qaEH3ZZ7/yVPqYlv+4+Wsf1Dv3836
zw1qvf6mPs4h/f5+6lf3NfSppD7DasJe0kv9V4ehP/vj+0a153u/rxZuHUE/
XqB+32o/FbwkfPMo+kO/NY7ifPTX0qjWu4T+KhrDeeiv/jFVXFwceJV6j2G/
14St46j/Deo/jnrrhTe58H4D++FC/2zCay7s38j+TKB/+4SDE6h3P/s1qfvl
eFe4YxL+b2L/JtHvA8Jlp9GvZvbzNPz3gfAGN/Q4yP66db8rW4XPu9XQ4OA9
bey3B/PSLjzsQX0fs/9TqI/cMIX55vvnplDPh8Kbp6EXz+Ocxvl53ivTmH/W
V3cGfnxHOHEGfn6P/plBP+zCXTPQl3qszuSuVzmL96mnbxb5Qr3zvZiHvfSb
V23PbMB+LeN5LfupzmKe2e+Js+jnm/SjT+tno1+2+LA+/dToQ37sER5af26l
X9ffpz9v+LB+1r9z2J/+rp+DP5iH/XPoJ+fhu7ncfL42B39wnh71688PMi+t
fviF83fMD/2y+elXmb+f7BT+xw+/cp43BXR/vMzTXQHUx/nvCej5zyPHA9ov
5cyLtYDWv3+HcEEQ/ma+VAWhH/lIUN83JvMoGIQfyJfWnzO/NobQT/KOEPzJ
/O4IQQ+yN4R5Ia+EkKfku8Koj3lZFkb95INh5B3ZE8b8kH8Lo9/kDZFcfiqC
PCLbI9CfPB7BecnnI6iXfGsU9WXzPIr54/n3RbEfeTiK85N/iur9LNn8j+Xq
90QM9xm5IYb1qf+JGPqZvS9i0I/9uw52kDfH4V/2f08cfic74+gv/WLGtf+X
yVfi0If+engeeUE/1s3j8+TeeZyP/k3MY336+695fF/I3l8J5CHPU5PIracr
gfzi8zCeO/j+agL+5X73JpE3nK/KJPzE+TuURH85r74k5p333x9J3Iec//wF
zDvzYdsC8o750bqA+pkv0wvIe+bP8gL0Zj7dvgg9X2f+LWJ/3n/Ni1qP4mwe
LkIP5uUvi1j/beajAX8yb+8zUB/zeIuB+WBe7zQwf8zzRgPfF5j3nYY+n+V9
5qmB+njfBAz0i/ffkoF+8P7704D/eX/dwPlKO4TvTqE/h5i/Kax/WLgiBX07
mccpfP/5VLg9BX26mc8p+Okz4dkU9OhhXqeQF73Cv6fgl6PM7xTm45jwnSb0
dTDPTcxvn/BWE3oeZ76bqG9AuMVEHp9k3pvw3ylht4n7fYj5j/1sw8K/mqhv
hPeBiX6MCt+WxveBMd4PacybS7gkDT9N8r5Io79u4aY0vq95eH+kkTfTGf4f
YEP7tQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn9InVUYvoT1xxpBIbSC2aIRNlZIwfAf41SjtRCmVtPVbTXbzG2Vd5bL
qW1q2pxtU7c723Vu87fXO7273l/eH179vu/CMrgFwSgKoRk0hElEtZD9MfrO
c3mfSFB5ON85532f93mf9zxeWVO27x6Hw/GN/av/y89SQ67/3b+efiGLtquq
qqqbe4h3qZXSWN57go1K1Zjr/7qS6/tV+na+k/tVjXJ2Wbff5ve1Sp//luAb
dUr/47rjiDpUtKZ8t+ANTcre7n2H5x3DeTy/oEXfv433G63qn3xnF+MradPn
/biX97Uj/irBruM6v6r3ef8JZX8+XC24uxP572c8J/X6EwcFB04h3w8YX5d6
ZanB/aHg6m7w8xHj7VH+bUt3agSv9uj88g8x/jPIv1Zwx1nNT/PHzMeN+D4R
vO4czq9jfudULK/91mHB3l5VFsu7t575foX8jwguPK/ab5UWNjB/D/hsFLzg
QTxN5KMPfH0muOKCvu/gUfLTr+zwXMcEL/fretU1k6+LWG8RXH8J+1vJ32Vl
X7/nc8E5A+oxO8A28jmg7O1F7YIzA6jHF+R3UI24itYcF+weBB/Eq4PqKTug
DsHOIdXn8XhOkP8hxNMpeOMw+PmS9RjW9XCcFLwyjPOIS0ZQr1OCwyPYf5r1
GkU8xE2juL+L9RvV573YLXjrmOZjidg7pvW2yP1rx3Ee43ONo97M5/q4Pv8R
8lPoRTzkt9+L+rI+jgm9v5312zsB/lmvhQmt3waub/ZB/9RDtw/xUz9/+9Rz
9g/1VnEFev9U8GwWU78bJrU/PEO9t00iX/bH8iT6m+vFU9Ar9wem0F/Uf65f
3x+i/uv9qC/1vujH/dS3ugq+mc/IVd0vl5hvTgD5ko8tAfBLPqsD8BvqtQ/r
HvKfwXo59Xc3u596K5hGvqxn5TTup57c0+gP6uXaNOLvob6noYczgjcFkb+b
eg+if4lPBxHvWeo/iPoR/xnE/TxvYwj+y/t2hvA9cUdI2X+bqddESOstxnhX
QvBT6jcvjH4lLgmjn5lvaxh6YH+Fw9AT+bmZXSd/6yLwN+r/1Qj6gXw3RVBf
1sMfAT/0kxsR6Jv1eyj6/37ZGgW/rP/hKOrL/vFmv6defo7q/vmeelo7A/1Q
b8/PIB7q0ZVdZ78MzahvM5kM++X6DPKnvu+LoR84Dwpj4Jfz40AM37N/+mPw
Y86f72KYx5xXjjji4Xx7No76HKAfxKE3zsfeOOrPeboQh19w3t6JQ++cz5sT
wJzfuxP4nvO+OwF/dwq2ErjvTfpJAvWsEPxkEvG+QX9Jop6vCe5Mop6l9Jsk
7tsh+Peknte5JfSfWfQfcdks+OH+tlll/20uExzF907etzyL+r8u+NEU9Mj4
ilOIf6fgoyn0E3EghfqVC/41hXiYb+4c8C7BL2cx+amfQ3+TP98c+CO/i3N6
/v7B99QD8+CL7zs1D33w/VQ7j3rsox/O6/wdfC/9MI/3B/WQY2i9dFIv6w3w
zffRFgN88z20w0D81GO1gfcN9dpiIB/6fZ+Bfqffhwzwx37IGDreFP3+NwPz
jP1119D9VMz+e9iE//L9UmDiPPbvdhP9y36vNPEepR80mjif/uE2oQe+N6ZM
6IF+dM1E/vSvX0z4Cf1t1QSf9MMHLfgv/XSTBT3Tj1+y0E//+bsFfnoF11no
3/P0ewv68gget8DXBfq/BT+7KPgnC3q4zHlggb9Bwfenoa9hzoc09D0quCiN
+o5xXqQxD7yCa9J4L/s4P9J4H07a+F8d3A6S
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlgtM1WUYxqm0GjkrRzNrohVzxLQsl7EW7osso2wqa2TbWVtMDe0CsnB4
KS9BIlMBxQuIyk1BlOOBczgckMv//M8SayfXnVms1JXZtBupY66s8z3teVxn
Y+y3/3fe732f93nf/7kvOzdz8Y1xcXEfxf7sf34mFV9YsOzPaU/9RxlmdYJ3
4HXxK+ZBT1n6YrKTbSKXkz2L9HypubggtE/PTa5J8M45s0Tn801a/OADOeTT
BSZ+sCFvqb6/0sSuD+n+yWtMZihx9JuKt9YsT4t/+S3y9PWmzL3c/LbibzD2
Xx55fhHOL9d9xebMqgRvPjlvo2nMS4t/R/dvMktinwJyeSnqX6F8Ntv7kgvJ
vi3mSrKnbKXyKzOe2IFV5Jxy6LNG+VYg3rvkkQozI/ZZq/y3Qb915JLtNv7t
G1RPpa1v3fvku3dY/X4vUn07kP8H5Oad9v6hjap3F/TYRE7dbT6JRqOlqr/K
5jdnM/kEeGCL9KhG/8vIC/dYdsulTw2ebyOfB7vbpddexN9BLtyH+3dKv/3G
+m83eVStzXewSnrWWj+9toccrTWhxOILNdK3zupfsI9cWQc/1ErvOvSrjuyp
t3onNkj/evijkZzUYGL2TDuofjTY5w/p+cUG6KN48xuh/35yoBH+3at+HYBf
q8lrDsDvu9S/A/a+3kry7IPQp0L9BM8Vj2lCfepHXhPiqX9fNkEP9Te12T5P
LSHXNOP78kvcIdwnfy06BD+ulx/AiXo+teX//itvQf6Kd6kFeuu+hYcxD8qn
5zD0VL6TjyCfreSiI8hH9Z0/gnxU/9xW7I/r/mqF/+SvBK95LnaB9C30Yt7k
ryEv+is2R6GPuPEo8rvuR5+prqqaIJ7pQ77iHB/8qvuqfei3OOpDvuJrPuQj
nt5m/XNO85DdZvOvFFe2IT/x8TY7L5+p3pE2zIc4pR3zIT952k1sHa/S97e2
Qy/l77RjH8qfw+2Ir3lL8tv6q+TnLD/uk99L/NBL89Dtxz6s17z4sQ80P4kB
e1+p5mt+APupmbwhgPdFi+YpAL8dJp8LwG+tmq8OxDtKfr4D8do0bx2I5yd7
O5BfQPPXgfyC5HFB+DekeQyi3m7yiiDq7dF8BuGHPvI3QejXr3nthH/D5Fmd
8ENE89uJfnxIru+Efwc0z53wxwnyzSHM+8ea7xDqj5KXhTBvJzXvIeT7Kflk
CPl+rvnvQr5fkB/tsno1fKV90AX/DJJ3dmEfndJ+6MJ++JZ8tQv6DmlfdGNf
fkd+tRt+Oq390Q09zpLdbujxg/YJzk84R55yDP7+SfvlGPr3M7n0GOJf0L7B
+Td+If+K8+m/af/0IP4f5MwexB/WPupB/EvkIM5XXdF+6kH+I+R7evG+u6p9
1Yv4f5Hf64Wf/9b+wvmBf8hne+GXGy5xn/Vhn99EfrYP+o8mF/bB37eQW/ps
v67eSh7qQ3/jyWP7sZ/GkE2/9cO6seT8fszPHeTGfvhnHPnrfrzfEsijHPze
u4s80YE/x5NnOpinCeR5Dt6X95JzHOzjieT1DvSaRK52oNdkst+BXveTow70
SiL/6MCvU8jXHPy+SCaPD+P3XAp5ehj1TCVnhPH7aRo5O2z3tf9h8uow6nmE
XBlGPTPIrWHU8xj5eBj1PE7+Pox6UskjYbzvniDf6WL+niSnuOjPLPLTLvpj
yB4X75N0coGLfT6bvNXF/niG3ORif84hOy78nEE+5cLPL5CHXfjtRfJtEfht
HjkpYvOLW0BOi+B9mEnOikC/l8i5EeiXRS6JQL+FMf4X8IYTKA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlg9MlVUYxqm0GjkrR1NrIiZzxLQollELdzKmUTSFFmLdWZER6Qpyo5Gy
UgfLWAkooBAScPn/53r5d7kX7oXvfrch1rWyTNKo1KXRoHIEjrGy7nnY87LF
BuzHPd85533e530+VqRmJL12Y1BQ0MnAt/7Nr4u7Q2yn/lrzxCzFq/FEZ+hX
wltVkjM072uykapCbBsvnpbP31DRga9vySpDWQrMrDOyfpfS+39HvpCl3o4N
Hj4rz7+rAtuPDZPDclTwsPXq97Lf+zjvHDlqn8obS3Sel/3347wfyJtz1VOB
A0fkvDxVXlZWJpz5gQpsNyMc9KHeL+ZHcmG+Wh74g3DYR+o+S8F6YfvH6lqE
5XZhVYD6ZL/0QlVgTkUIRxXp83bL/aaLtL6Vc/c/pAJyWKW+A4dV4OdeqX9z
Me4n+iwp0fc7PadniTrl9yeI3o2l+vzGb6TeI9BT+hdz9H/9LUP/pP9DZWrY
mhn7hehRjs9PklM+0XouPSH6VGD/z8ijFfp5jyl6HUM9Bjm7Evv3i36f4vk+
8rwq6OMSPavUnoABesj+KvilS/StVrWZsfkd5OJq6G8Xvat1/8w2sqVG++mV
FtG/Bn5oJIdbtX+K66UfVvRXeNwKfa3Sn1pwFblrlo9Jv+rwfDk5pw79Oir9
q9P+nSohx9Wj/sPSz3roV0Re0AB/H5L+NsA/wmca9Hn3y/Mxjbp/ncIV4Ohi
6X8T7iu8vQn9lfsMNeF84dXNKi0t7YpwYTP6WUqebIZ+wiktmF9hdwv6c0T8
06r3SxPObcW8Co+26v6fEE5og1+E7W2YR9EzxKb1WCmcbcN9hUdsyA/phzoO
/1SQa48r31SEpVL8aIee0t+1dp2H82vEn3bkmfih3A4968SvdujXQL5uR740
iX/bcV/xY2o7/Ngqfm7XfvHbyINYb53zdzvyT/wf2QF/yXxYOjDvDvLBDvhN
5snAer/M2wTWV8o8hndifw85uRP7D8h8dOL+XnIv1k/J/I9jvV/yIbQL9x+U
+elCPg6R93dBn89lnrB+pZ98BetnJK+WdCMPJc+e7ob+8n7K6Yb+8n6ydet+
bZnLz270V/J1kQP9lTyOc2g/jEhev+PAPEm+Nzrgn5/I5x3Ilwsyrz3I70vk
dT2Y319kfnuQZ5fJNT3Iq19lnnswD7+Rb3Zq/2eOyXw7kY+/k3c4odefMu9O
6HWV/KUTek3I/Lug1yT5IRfe99ckD1yYh2lyqQv5MSP54NL1B/9NnnFh3v6R
vOjF++Bf8rZe5MMNk8yPXtRzE9nsRT3zyZO98O8t5FV9qOdWckof6gkm5/ch
bxeQ3X2oZyH5jz7Ucwc5zI3+LCInuZEnIeRcN/pzF9nhRn8Wk0fdmJel5Ls9
mJd7yAke+HkZ+T0P8m852e6B31aQL3ngt3vJIf3Iq3Dyhn59v4JV5Ox+fb+d
EeTmfvy/Ekke6Yd+q8kLB6DfGrIagH4PkHcNQL8HybUD0C+afHYA/n6YPM+A
fo+Qlxnw96PktQby+jHyJgN5/jg53UAerCPvM1Tg515FLjcwr+vJnQb8F0f2
G+jXBvJlA/7bSL5uoF/x5MVe9OsZcpQX/XqWHO9FvzaRU73Ih0TyHi/2SyIX
e6Hnc+Q2L/R4njw4u38y+Wd87txCnvbqeoO2ku804f8XyJEm+v0i+UkT/rCQ
LSb8tI2cZSJPXyIfNJG/L5MbTORDKtmYXf8q+ZwJP2wnT5ioP418mw959zo5
3If5SCfH+vB+2EFO9sFPO8kZPvjjTfIBH85/K8D/AWBSOEU=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9MlHUYx2+ObKmzMproCnWaI0MjLaI/2M8/EzGaf2pG7eaClDRXkAtH
yEodLGIlWmhBZCogf8TjjjuOu+OA994rxHW5XCRllGBplmSGYESLut+Xvs/W
bbfbZ+/7/p7n+T7f53lvVnrmuk3jLBbLyfBX//Kzsi838ty1+UvGKFnZkvpy
e4WfURkZGRf7yEa6mlFwee0Pcn2LuttabP5IVplqUfhzUe7fporNoZqfyL3Z
qn+tJ/pnef41VVZaWvoLeWae0vn0y3lvqOsx1uJfyXG7NN/8m5y/G9evktfk
4/kBiVeA86+Rs95UiRO6Zw9J/Ld0vs7r5L1Fup6lw5LP2+qV8AN/ku3vKE90
wda/JL9itc4TfcPf5M17dX0HRyXffSosl0euD+9DviOS/7sq0paU9ge58D19
f8Kg1FOCen4nR+3X8S+LHr37ob/oV3MA8UXvrPfRT+lPwgfon/TTUop+fU/u
LIW+34oeZYjXTU79UH0eCoW6RJ9yFU7Pdpp8qRz1nRK9PlLh9LI/I+ccVMGh
GGun6Pcx9P6UHHFI+yXGFD0Pof52cuiQ0j9+0fewmtBdcdVDLjms9exrEr0P
63pPN5KtR6BXg+h/BP2pJ8+pgB9qpR8VqLea3F+Bfsn1NZW6vqE6sqtSVWYl
Fsl5UVXwu42cV4XzJX5vlT4/xUFefhTzJvnWHEX/XORJ1dDDLf2txnnN5K5q
nOeVftegfz5yeY32a4HoZ6nFPLSRN9ZCH9G7s1bnkxEgx9bB70HxR51+vuIT
8mCd2hEWqEP8cgzxT5D9x+CPk+KfevhP/JFfj3kLiZ/qUb/4KeU48v1C/HUc
/RH/Rdq0H7K+FL/Z9PxP+4rcY0N9Z8R/DZjnr8mVDdD3rPjRjvtlHuLtuP87
8acd58v+LBu7X/ZnyI58zpNH7fCDzGOcA/lfIKc7UK/Mb4kD8yD7ssMBfWTe
hx3wm+zLeY3YH1fE743QX/blnkbsQ9knRiP8IvtxoFHpH9mPc5z/34/rnfCD
7MdCJ+qXfeZzoh7Zj/1Ofd5O2X/RLuT3j8yPC/lZBv/j3S74aRzZ5dL1Ph1B
vujCfhpPjmrSfjtxI3lVE+LdRM5rQryJZFsT9sUkcm8T3k+TyVPcmO9byMvd
qG8Kebsb++Q2co0bfr6dfNYN/08lT2qGntPIi5tV2A6t08lZzej3HeQjzZiH
aHJXM/KdQR7vwb6dRU7wwI+zyS96MB93kcs92Idzyac8eD/EkC1e1DuPvNCr
/V8ivNGLfgof8EL/e8idXvRHeMQLPYVjfag/lrzBh3jCe33on7DpQ7/mkwd9
qFd4bgvmYQE5tQXXhYta8Py9ZH8Lzhe+0oL4ceSZfuR3H3mdH/4TzvfjfbmQ
7B67fxH5kh/vD+HprXjf3U9OaUU+D5Bfb9X9HhG2tyK/ePL5Vszng+TINuyP
BPKKNszrQ+ScNl3/gofJdW3YX4+Qe9qQ76Pkye3wk7Bqhz8SydvasV8WkyvH
+DHymTFW5AgDvIR8p4HzlpLjDcz3MvJqA/UvJ2824KcV5F0G+ptELjPw/2Al
2Ynz05LJIUPXt3MV+YKB/j1OHjXg3xTy1ADiP0GOCyDeanJyAH5eQ04PYL+u
Je8AT3iSXBJAvU+Rjwcw3+vJHQH0M5V8LoB+PkseDqCfVvKtJvLZQJ5n4n37
HHmZqf8/9aSRrSb89zw528T8biLvMRHvBXK1iXhbyIaJfbGV/I0Jv7xEHhiL
9zJ5YhDxsshzgoi3jZwYxD56lbw+iH24nZwZRLwccmEQ8XLD/C+SHxdW
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1HUYx6nQGlqWsQSbREmGhkZeGf3APiqJGE2hEqzrh4xIc42LhaVQ
IoNSyg4V0UNEfnMgnAd3HAfcwfe+t5Vt1NbmcjW3pC3nBmutQWv+0brPmz3v
DTfPvfb99TzP+/28Pz5cUJz73u1RUVHfR/7qf+XPaqt985aZtZvmKEtN5/gT
FHm3cmVO3npB2ChQH6XHXH2W1/cpi8Xi2SCsilW7Lb3GwvtLVKwrc0+q8PVS
VT2Vk7aWzx9U/yRbl6wRTixXRUVFN1bxfYfV1TZbcKVw6hF9vz2R76/U9xet
EN5Zpe9PX87vVeP9y4RtX+L99/P7x3Q9/nuFa2vw/rtZz9eoP0bYfRz138n6
7LrfmGjhvbX6/sko1nsC9ZD/PYHrt7H+kyrXn1B9h/DRU8puziYvYD916qHq
qZ8WCsedVpHfirvY32k1eSh2Hetz1qvwbPK1Rez3zPx+0s4qrfcS9u+Avuz/
sgN6LuU8GlSkvP2xwvnnUN8DnE8j+uF8bzaqiD3a4jmv85jfg8KfNsFf1Etd
wPMJwtHNeJ767m2Gvo8ITzSj3yTOt0VFbv/rUeG6Fuj5GOfdgnmtFra2qrLI
Bx/n/FvhD/oxqQ3zW0c92lAP/Tvdhnmspz7t8MNTwt52recC7kNcB/R7Rri8
Q/ffxP253oH3PS+c0Yn3pVPPTrzvReHFXdg/7qetC/VtFr7Spax2szSDejuh
91bhRqfaFhngNurfjflnCRd2Q/+X6Ydu+PMV4ZQe/f28HfRHD/yQIzzTAz/l
0i8X1Q8TExOvCQcuov9d9E+v1s+WL1zVi3rfoJ96sa/k7D7ozfvdfdi/POFY
l57HytfpN5f+fvarwtdcur5DrFddgl/YT/sl1M9+o92oJ1t4g1s1OByO7fSn
G/dzng1u+D2TfnVDr5eE/wPnUZ/UfviN+hX0Yx6b6Od+9Ee9v+2HPhvp737s
B/2yZgD9M6+tA9pfU88JfzOAPKX/jAH0kyb894CK/FbQr0ke+Il+3jXHT3M/
PLif/h/xaH/VMf+nPaiX+5LgRb9Pcn+88CO50qv3JYf75vXCL08I3/Dq789y
P+MGMU/y9kGtl8l9Lh9E/pJd4GAK928Q/iAv9WEfmA8ZPviffMCH/CE7ffAn
z69ffdhH8uIh6EneOAQ/kW1D0IvcOgS9yVeG4C/m10I/+ien+edf/8CPvODz
jX7kLflHP+ZBjhqGX8nrh3E/51E4DL04v/ph+IV6XB7G/KnfLVyPp/4pI/A/
/fH2CJ6nn2pxPY/+M3E9nn6dmXue+bhqFM/T7/mjuj4r87FmFPVzfwKj8/fr
T1xv4v4lBtA/8zE3AD24z1UB6Mt89AV03jmZjzcDyG/mxfKg9ruFeZIdhF47
hT8PIm+Yj+4g8oj5+HsQ/mA+xo5BT+bd1jF9fn23m/k2hvP9TeGeMezPW8y7
MczzHeF7xjGPd5l/4/BrgXDJOPopZB6Ow+9Fwj+Po5/3mY8G9mmf8AoD+7Kf
eWngvP1QeIeB87aY+WlAX5vwEQP6lDBPDeTbx8IeA/UcYL4aqOcT4T/m6jnI
vJ2rp0x4WQj7/hnzN4T5HBbOCmH/K5jHIehdKVwWwj5XMZ9D2KcvhPtC0Oso
8xrfmzgm/Bu+5/iK+Y3v7TkufJ+J89TOPDfRX63wFhP9nWS+m/j/dp1wqYl9
qmfem9iHs8JdJs4DB/PfRD6fE/7FVJHfivM8D0zM64LwojDm1cLzIYx5tQqn
h7U+rnaeF2H4u1O4OAw/OHl+hJH/PRH+H5lS6v4=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9M1HUYxpnTWlg5HStzhTqtEJEIjTA7+yIqYiyBFlm7LEmLrMVFo1TM
lEGhpUgiCREBB/L/PO6O4w447t8ia+Ry/WGWFbhiLOyfSTHWWPd92PNu3Qbs
s/vye9/v+z7Pc7c0Ozdz96ywsLBPQz/6L1/G0sBExrVVSTOUql4xhD++TfgJ
tSJ0II3sy1bF4xmJW+X9F9SQ2eRJIatc9fngYNomOZ+nXJHF4xvIw/nqSoar
Rsn/71PPhV7ryUsO6HobHpTnvalWh14PkOMO63qGRHl+oYqwpOxMIKcXKUP4
kHmN1CtWma7IOavJprc1F98r9Y+okf0RsXHkE0eVnkes9PMu+l9Fth7D84RV
qSoINRBDzjmh+7WvlH7LMA/hyTLVYDKEC/vew/OjySUnUV84vVzfZ5mcX3hK
v58vPHxKz29UuLlCha5vkn5M76uqysrbpN/E0yo4EXVJOKwS/cp9z1ViP/fI
PKrAMp/tH+h5WWR+S6r1/QbjyWPVypIyMiXztn6I/d1H3luj398v+1If6fl9
cj95di3uu1bmWYt9yf4Ha/X9/lgn862Dfgzk8jrcT/Q0CTaK3oz1Wi8jSTL/
ej3/F5PJy82Y/0bZh1nv6+hm8hUz+tsi+2mA/lPJjgbUe1j21Yh5iH8ONGKe
j8j+GqGfdPLGM7if+LH5jN5f5aPkG5tw/jHZbxOen0X+qkmF2m/eLvtuhj+e
JFc3qy2hBRpl/y3Y31PkXS2Y99Oihxb4bSc5phX1skUfrToPXLvI11r1/SJ3
i17a4JdnyX1tuN8zop926HcHuagd+5H+xtr/329aB/wi/Vo7MH/pN8Ki/o4y
lkq/ey3Qh9S/ZEF+SX/qrD4/73lyw1nUzxE9WnG/PeQEK/TwkujTivm+TK7C
+UST6BXnw/PI0zg/8qrotxPPzydnd+L5r4ueO/H8feQBnE8sEH13ov83yNE2
zPOg6N2G+RwiH7fpeZYXiv5t0H8R+aoN+fuW+MGO/CghZ9mxvyPiDzv8+w65
xw59HxO/2JFXpeRIB/KwTPzjgJ9Okgsd0Fe5+MmhFhePX6ggjzqg79Piry7o
tYq8tQv+qxa/dSF/asiWLuyjVvzXhXnVkRc4MS+z+NGJeTWSX3NiXk3iTyf8
2EL+1gn9t4lfu5En7eT13biPRfzbjftYyfXdKvT7kE383I37OMjXuXAfp/jb
hf27yHtcuI9b/O7C53cv+bwLeeIR/7uxHy853o39+CUP3Lq/qCC5wq37C/tY
8sGNvB0gT7nxeXJO8qIHfvyMvKMHfhyU/OiB3s6TAz3Q2xeSJz2Y3wXyXb2Y
35eSL72Y39fko73Qw5DkTS/md5H8Wy/8853kTx/y5XtyZh/y5QfJoz7oe5js
7MP3i8uST334PPuJvMiD70+jklce7GuMfNAD/f0i+eXBvsbJlz3Y16+SZ/3w
0+/kzf3Y15+Sb/16Hhl/kVv78X1mQvKuH/X+Id/sRf5MSv55ofcpcp4X+vhX
8tCLetPkb7zQR9gE89EHfcwi3+FD3s8mJ/hQbw55mw/1rifn+OCvG8iHffj+
Mpdc5UO9m8j2mXrzyIMz9eaTf56pt4A87UO+RpBv9aPeLeQ4P+otJKf6UW8R
OduPereTC/yoF0ku96PeYnKHH/dbSh7wY57LyD/O1LuTPDlT727y/ADqrSBH
B1BvJTk5gHoxZGMA9WLJ+QHUiyMfD2B/8eSmAPSyhuwLQC8J5IsB6CWRfDUA
fa4lzw1Cn+vIy4PQp4FsCMIPD5GzgvBDEjk3CD8kk0uCyK9NIf4P9GQYPQ==

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9MVXUYxqnINXI6i6b2g6iYQzMiaUQt7KuWaHNL+EO0yIrSUFcghSGY
AkEiKT/0il5C5KdcEK6Xe/lxL/cC514a4cKay2k5llHTLJlzDMxoWff70PNu
sCn77JzzPe/7vM/zHh5LTk3YdGdAQMBp/z/9mz/bY4MuJI4/tWyKVqvReGfI
BuENarP/53WykayioqIcb8j1LUr//yZZpapHC67Fb5T705X/+Lq3yD9nKGvc
yOTb8vxO3J9MDt2lRrKCre/KeXtUfVps0CZyZK5yhhRs2yzn56kzQ0ND75PX
5uvnI7bI+wrUqpEs01Zy2l68f5u8f58Ktsa98wG5tAjnfSj17Ff+8mLSyLYD
qsQ3Ydku9ZWoCrN5/kfklFJdb9HHUm8Z9NlBvlWmkkp8GZ9I/Qd1P9cyyYWH
UE+W9GNS/RPhw9nkeYeVf16Jn0p/4Au7yZZy6Jkj/R7RfDaXHHMU1z+T/s14
Pp88aNbvS/pc9KjQ9YzsJa//En7YJ/pUov4i8tVK9Ldf9DqG/ovJmVXQp0T0
Ow79ysiB1fDLQdGzWvstykQeqlYL/S84LPrWQI8jZFONru/KUdG7Rs87q4Kc
VKuy/Q2ZRf9adaEuraecHFY3/X2FdfCj1DcKjpD619bjuvTbDo4QPeY1aP84
Rb9dDbr+5QUyvwbMJ4/88gnoK/OznIB+Mt+ZjTqfVeKHtEact5N8rlH55bsh
foux4H7xY6UF80+X+Tepm+FJs8Xf7zWhHsnDYJOej1nysrgZ+ZN8lTZr/WIl
f+PNmL/kc/1J6JlC9pzU1yfk+dAW6CPn57dgXvL+qy04P5W8phV6SP5srXqe
X0s/wdbp+cu0ol/RY9gKv0ne1Cn4W/SrP4V8i76BNvQjeYu2oZ494k8b9pPk
q8I2fZ5DNugv+bptg36Sr8g27JdCcnKbSnCG3C3+MbXhvC/IA20474D4u03P
O038uMiO+sSvSXbM9xC52I59Iv427PCv+H/MDv0lP2EOvQ/XSH7WOfB9qJR8
OOC3Y+RuB/J5XPLiwP6tIYe0w991kp929N9AzmuHno2Sp3bUayFfaUe9zZKv
Dq1XQQv51Q7sA6vkrUPPM9xGtnbAP3bJXwf0dZDv68T8OySPndCji7yjE35y
ST479b56wk2+iPsnPZLXLpzfS17ahf1mSH67cL6PXIv747+SPHeh/gHyDCfq
H5R8O3H+afJWJ+r/RvKO+3POkL91Qp/vJP8u7Kuz5CUu+O972Qcu6H+OXO7C
9/+87AcX8vYDedKF79dF2RfdmO8weWO39kPwT7I/uvH9uET2dcM/I7JPurF/
fiUvcMPvl2W/uOHP38hFbszjd9k3bszjD/J1N/Qalf3jgZ+ukxM88NMN2Uce
fA/HyJ0e9DMu+8mDfN0kP9iD78+fsq960M9f5N096Odv2V892C//kH/pQT//
yj7rxfzvmPifV/Zi/neRM3sxn0Bycy/mM4M83KvrK7mHPKsP+Qsiqz58P2aS
0/uwH2eR6/uwr2eTz/fh76M55EADfruf/IgB/R4gRxvQby75NQP6zSenGNDv
IXKuAT88TK4wsN9DyA4D+y+UPGQgP4+TLxvwdxj5toHvzwLyXC/2Szg50ot5
LSSv9mJeT5KTp64vJmd7oX8E2eSFXk+TW73oL5I84EX/z5Av4fmcJeRbXugX
RZ7jw99jz5IX+ZDHaPIKH85/jpzkw/ckhpzhgz7Pk4t98McL5EYf8vci2cD7
EmPJP+K6aSl5bKqel8j39mP/LyOH9cNPy8mx/fDfCvK6fuj1Cjm1H/5eSS7E
eVVxfv4PRooQtA==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlX1M1WUUx2+FrqFp2i1fSsQgQ9KiWIy1cE9qEUVTWCPaWFvMmOUfkBuN
lBU6WMZKsNACEYHL+8vlwr3ABe6F+9IQ62ZZJGk0wRXRYM4RFGONus/3dr7M
2IB99nt+zznne77n/LakZya/cbvBYLjg/9X/5eftuOCRb2Z3PBOgBFXkmYu4
RH5V2UMKDn4n7EpX/uOm7/n8TfW1z+cbFlaZKiMjY+IHnj8Eviw8lq10vBG+
/64aP2w0/ygcmqvPZ1zhfe+rZHvIsqvCUUeV/28e2XVMbS6YukTel6/M8eML
5LGCWznrA3XEaD5PNnyIeOTiQtzH+KEfqT8j0laTLR+r5/0JM19VpPxy3GR9
B4pVWWlpKeuPOqmmk+wh1Gf+pM7n8JKen6iCqST7t8LHP0X8i6ynBHr5hNef
UiOmLOeXrO+UzqdkSLjhtD7/yiDr/UzVZMUFfyEc+7mKjo62ull/qe5f4oDw
UKnyzkWMOqhHGfTpFU49o/0w1U19yvG8U3iyXBn9BXZQr7PIxyKcUwH9W6nf
OV1/bLNwUKX2X0MD9azUem6oE/ZVaj8UmKhvlUrzv1ApXFKFfCqodxX0OyOc
Vo1+llP/avj5rHC4CfmcYz9M8Dfvnzbh/mr2p0b70VAjbKtB/2vZr1qtd3S9
cG4t7mN9Y7WYrybhPXXwewv7WYf8qNfKerUtrWhXG/tbD72p73C9zieP+sc2
6PfDbMLlDfp9D/tlaEQ97Of+Rvilh35oxHyy/9ubtD+TlvzRBP2dwrNNqJ9+
Sm1GvvSboxn+8dA/LbofRfRnfgv0p38nW1DfeeHEVp1f4QX6qxX6fiVsNOM8
5yXHjPOcp1Ez7ue8qTac576raUM+3G9BFj1vcZznGAvyX5p3C+rlPiizaH/H
c5/4LNg/PwkvWuDvn+nfdj1vadeE09uh/zj93I55vy482K73TdYv9Hc79suE
cGQH9sdv9HsH5uV34RMdqH+K/u/A/poWnumA325wHqyY35vCKVbMzwznwwo/
/SHca8V+m+O8WNGfv4RDbPgezHN+bDr/igXhYzbE+5vzZEO8ReEJG/bHP5yv
TuX/m3fb3H/8Qifqu0M4txP+DBI2d8LPy4XHOuH/O4XXdmFegoX3dGEfrhB+
pwv9vku4oQv5rha+2oX9erfwym74gbyzG/XzfFY39je5OnCePNyNfUBebkf9
q4Rj7ciH/JYd/iCX2zGv5It26EM29Gg9HiU/0YPvP3n///h0z63vD/Xg+0Fe
6IGe5O29mD/ya7343pGLezFPZE8v4rHeWTw/SN7aB33JqX3Qh/oW9ul5fp3s
6IM/yTf6cP8a4VAH9CcnOzB/a4XzHZgfchd42T3Ckw7sC/JGJ+bRKJzoRL7k
95zQ615hixP1k687cd99wsZ+7J91ws/14zw5px/zul64qR/1bxAexfOwjcKr
BuA/shpAfvcLHxpAvQ8I1wzA35uEL+N8dIhwkAvzuVl4kwv7hBzjwvc3VHiv
C/3YInzAhfgPCh91YT+GCZe5sB/Cha0u+P0hYV+Atwr/Gjj/sPCiC/pECK9z
I9424Sg39mukcIIb+/MR4XQ37t8hfMSt90n2Y8IlOJ/0uHCrG/MULTzohl+e
FL7mxvcmRng+ED9WeI0H8Z4SjvQg3tPCuz3wz07hNA/8rISzPYi3S/iEB/F2
C9d7EO9ZYVcgXrzwFQ/2R4LwTCDei8IrvIj3knC4F/H2Csd5EW+fcIoX8ZKF
M72I97LwcS/qS/Hzvz4LFZs=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9M1GUcx28t+4NcTbsSLRGLDA2NtIx+nD2iiRglUCm2mwvSUmtx0ag8
mSHBVDJBO7XDi4BDQYTz4O6487iD731vK9uozc3pbGxJW85N1lqL5vyjdc/7
9nlv3qbutef7/Hp/3p/348Kq6vLtd1kslp9Sf/S/8lvQdPPic9NLV6epWE2V
RbKeJW9R9hazdrmwUaWS07kTT3F8p0rNL1sqrKoxvoTf1yhf0aQzV/harZp0
Wpct4vzdSv+dI5xdpzKueP9ayPW+wHi2cP4+tSL1y+L6DerfXHvLI8KljWp9
aoOHuV+T2mP1/ThX2LFf7+/L5P4H1c/j4+NzhFubVZvbPZecfUiz+yFh/9e4
L1m1qBQWkHe03jmef0Sfx0W+dQT34frGUZyffOAbtdjeUsjzlbr0+P08f+Yx
redt8rU0zxPuPY7vqYfjBM43X7jgW62vg/pZ3Ho8skD4ghvzqX9rG75/VLji
pPrYlnHlMerj0fqVPC58wwO9WV//dxhn/T9v1/pcXEz9vldWX1Hlk8J3d2i/
TedRzw7os0x4vAP+yae+nVjvaWFXJ/y6gnp33ulnexfqvZL6d8GfBcI5Xqz/
Auvh1eebfFF4yot62lifbtzvZeFgt+p22DJWs16ndD3NQuG6U7r+9WtZP4wX
rhNeexr+WM96nsb8YuGZPao8ktX0Kuvbo/Uuek34Ug/qt5H17oU+pcKeXvi5
nPU/A/3fFN52BvffRD+kxzcL5/WpVHly36I/+lAvrvdPH/TlfhVn9fe9rwvH
zmp9mkvon37Ua4NwY796L/Xj/W/0Y3/qUzIApn7+AZWS4wPqa/Whnop+86Fe
q4QnfPD7S/TfOdSX9e4+h/x4nn70o77Mx5V++JF+2uFH3tFvbX7kE/NyPP09
/fqfH3rRz/mDuC/zs2oQ52E/uMCVzNMfBpGP7Kdbg/DDE8JLhpRuT/affQj1
YL4eHoL/2L/GkEq1t439/TfGLez/nAD8w3zYFEB+Mj8OBHA/5ks0gPWZP1MB
1Jd5nBVEfZhXpUGcn3nWEIQ/mX/BoD5fnPl4Paj1us48zQwhr8kbQjqfNj/I
fgvp/m+3CvtC0P8B9l8IeU2ePQx/zGY/DkNP8qfDWG8W+zM9Tv51GP1HnhmG
/py/Kgz/8zyOMPqX5+8Kaz1m8P6Xwuh/6nNPBPpSz4II6kf9d0XwHrA+HozH
+X7+gnEn6205j/eB/lh+HvOZ59swHqG/jmPcyfy+kJ5Pv95Oz2d+50Uxn37f
GsV89kNrFOdnv5hR+O8Z5kkU92e/LRqBX9iPFSPIT/ZrM8ZnMK9jI9Cf/f7n
CPzKPMiOof7Mi/IY+p950hjDe7dGeDgGf77CfIqhP4uE58XhB+Z1SRx+Zb7t
jaN/mH/+ON5X5uPvcejJ/LSOQs8y4XWj0OMN5tso/MQ87htFXjGvJ0Zxny3C
940hr95m/o3p83rtwjVjyKOtzMMxvAfvCF8eQ/9UMh8N+Otd4fkG6rOdeWng
PO8LbzRwnp3MTwPn2SW8z8B5PmSeGsj3j4QDBvLVwXw14Jca4T8M/P/jE+at
gXrXCs9JIB8+Y/4mUK/dwsUJvd9NJ/M4ofcL1AnvSej96vcynxPo33rhgQTu
18C8TuB+Xwr/lsB72MT8TqD++4VnmeiHg8xzE37+SniNiTw+xHw3kUeHhWtN
1K+VeW9Cr6PCPSb0cjH/TfTHMeGrJt7LE3wPTPjbLXxvEn44yfchCX96hG1J
6N/O9yKJ9TqEq5NYr4vvR3q97hT/DxC55MY=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1MVXUYxqnINXKWRVNrkpVzxLQsl1kL98+cZOJEaqJ1syQ11Aq0NL+m
aDKVTNBQA1ERUBDlevHycblc4NxzS3NhX3NajmbUNEvnHBMyW9b9P/U83Q3Z
z3vOef/v+z7Pc3ggMzt9zs0xMTHHoz/2Nz/3512cOqlnxLP/0kSTHHe6IlU8
w3hTuq5PJjuZxl4/Rd/PM13L471pZJNtKnOS49J1/SITSMhb8CL5x8XmREdH
x0u6f5m9/5Fp5CErzfNdy4sy9LzVqD+dPHKNifemzHpZz1+L571CTltnoscb
86rq5ZkCt6d6JjlnvSkpLh70uupvtOfNn0UuzDf21xs6zybjKXAXzyb7PrL9
XJyj8xXgPG+SswpNpCexM0vn3WIWJsdlzCdfA59eoPNvxTzfJm/42PI376if
InyfQx64DfcvVH/gjHfJ1dtR/z31u8PMjX6WkMd8gvO/r/6L0d8y8ufF6H+F
5lGC+awkT99p9xO/SvMphV5Wky+UYp9rNK9d5nRFTuta8tLd6Ged5rfHzq8r
jxxbhvOs1zzLTHog4daN5I4yu7/ifM13rxkV/WwiF+2F/j7UvPei/w1kT7lZ
Ee89pnpOOc77AXloBfSXq31UYB7q91KFibabo/mkVdrnn19Krq+08/do3gP3
YR/az0qw5//97cP92vf4/Xj+W9rnftSXfvpWoX/pLacKepceT1ZBH5nad7W9
P1d6L61Gv/JDzAHMX/6ZfcBcmhrYPUN6OGD30SM/Dq8xD0f/Q98X1kAfuv9q
DfQo/00/aPXx0Gvk0EHb3xWdZ8gh6EPnXXfI9CZ6CuS3C4cwr7nk1FqcX/7y
1SIf5pHjvcgD+WupF/3IX51e5FG29HfY1k/WPioP2/p3aF+xPsxHfhrts/MO
aL9ZPvSv/Zf4cN7l0qsP55V/bvigZ+lpZB32Jf9k1iFP5Z+iOuxP+jyK6zOk
32t1Nt8S5ZekI9CL/OI5gufLL5uP4Pnyi4PrczeTu3F9RqH84Mf5t5Kn+XH+
IvnDD31vIwf91o/+HfKLH/MpJifUIy93yj/10O8u8tp6zH+P/FQPf5SRz9dD
f+XyVwP8UEl+oQH+2S+/NVi/p1STvQ1WDwk18l8D9HOQfFcj8rdWfmzE++Mw
eUmj7T+vTv5sxL795DON6KdBfm1CP03ksU3oJyD/NqGfILm8Cf2E5Ocm5GEb
uU/A6jvVkb8D2L9Lnh/A/j+V3wPYz2fkLwPQ7zH5vxl+O05+vBn++EJ50GzP
N+4EeXsz5veV8qEZ8/uafL0Z8/tWeRGE3k6SZwahh1PKjyD08B3ZDcKPZ5Qn
QbyvO8nDWpBHPyhfWuD3s+T8FuyrS3nTgn39TL7cgnrnlD8h1PuFnB7C++1X
5VEIefUbuTGEepeUTyHUu0y+txX1riivWlGvm7yqFfq4qvxqRb1e8k+tqPe7
8qwN9f4gT2hDvT+Vb22o9xe5pg31/lbetaG/m3r/437tmOctZNOOecaSF7Wj
Xh9yZTvq3UY+1Y56ceRYB/X6kgc7qNePPNpBvTvJUxzU60/OcqCXu8lrHOjl
HnKJA70MIPsdvM8HkTsc6PM+8jkH+hxMvuFAnwnkAWHk4RDyyDDy6kHyxDD8
MJScGYYfhpFXhJEnieSiMPyXRK4NIx+Hk4+G8f4YQT4bxvvuUfK1MPz+GLm/
C7+PIie5+HvpCfJzLvL4SbLHxd87T5EXu8iXp8mbXeTLM+QqF+/DsWTHNdF/
cw35exd5No7c7UKv48m3R6DXCeShEeg1hZwcgX4mkqdFoJ9J5OwI9DOZvCGC
fU6J8j/YJBjg
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9MlGUcx6nINbSYjpXWRCpmaOqYldEa7oksIlkpK/8s5ophYa4kF4Vi
hg5SKQQREBCVv/JHOA7uOA64g/feW4p1VhaTLCpwaZTMmYkxVtY9X/r+WLfB
7bP3fZ/39/t+v7/nufuTtiRsvDUgIOC0/09/87MgMS+mb2zxU5MUpwaqU92n
hderR/yfz8lGkiorLS31yfVNyhmaffkMWW1Rw9tDlnwp929V70QHrf2KPJSm
Xvd/zsrz29S87MurvyaH7VDP+Rf4Rtb7UK9nEY7cpW5EJAb3y/q7UZ/wqiw8
LzyU/f/nU/co/SUcsE8lOENvl/fn5yi/HqbUG/aJygixxEo/1lz9/rypfvOw
vuiTkq9GVzuPin6RB1SQX9BT5PEDKjpo4MFPpf4CvM8k7z2ozvh88Yb0U6jZ
5ybPLtL+RHdLf0V6vWonub4Y/Tmk30PKOxaRaCNHlaBeq/Rfivst5L5SvP+E
6FEGv+vJ6w5r/y7Vij7l8LuaPFKuLLHD2ytEryNav1NHyOlH4c9h0e+Y8sv7
Wgk5sEL7aSsSPSvgz0GyrwJ5yhd9K9FPLrmwEu8THq9E/3nkxCrll3tMnjeq
4GcBObxa+S9HFIof1fBH6hmtRr2HxJ8a3e+E1G+vgV5l4let8sc7qpy8o1bX
PyB6DNXqetKOkVcchz6V4udx/byzijyjDv3XiL91eL/40V+H/NWJ3/W6/pgG
cnk9/GsU/xtUTWp0ThM5uQHzNJWHBtTbQl7UqPOS2Sr5aIRekq/rjXqez9ol
LyeQB8mj6wTyL3kNa0K+O8lZTdBD8j3ShPsl//HNuL9H8tWM9WVeQiyoR+Yp
3YL6veRBi85TtsyfakG/Mp81LdrfYdkPA63Ix2fkZVboKftfilXP91XZD8qs
mEfZL3xW+CX73U0r8jy1n7XCX9mvklr1frr5nOS5VfsZ+i35ZCv0PS/5bkU/
35MXtmF/+EHy3ob6fiTvb0N9Q5L/NszHBfK1NuTvZ5kHG+bpInmNDf7/IvNh
Q75/JXfZ8L7fZF5s2o/6UXKoHfNzRebHrudlzlXybjv6+13myY58/kG+ZIf+
YzJf7bqegD/Jz7dDz3GZt3bkaYJsacd+9ZfMXzvOr7/Jsxyo9x+ZRwfqveXG
f/yeA37cRq53aP0GA8nfOTD/08gzOuD/HeTlHdA3iJzagX6nk6s6kLc7yf24
vjqYPM2J828mOcqJeZhFfhPX80LI5bgefzf5C6fWM2g2OaATz88hL+3E8/eR
k3E9fi65GNeD55H7OlF/GHli8vkHyIu6UH84eUMX+p9Pzu/CfD5ENrug3wLy
9S7k82Hy/G7ov5i8rhvzuoSc0418R5Jd3ZinpeQr3fD/UXKYC3l9jJzgwvnz
ODnLhf3lCbLDhfl6kjziwjxHk+91Y16Wk+Pd0EORd7qhRwzZ6kb+V5AvuJGn
Z8ghPegnlvxsD/qJI6f3oJ+V5MYenG/x5MEe/J57gXxXL/aLVWTVC38TyFt7
4c9L5Jpe1PMy+Vwv6llLDjRQz3ryXAP76SvkZQbOp0TyiwbO0w3kFAPz/Sp5
lwF9kshlBvRJJtsMnF8byT4D5/8b5IsG5n0T+SbeF7OZfI8H+X+LHOlBft8m
x3lwfqaSkzz4vbqVnOFBf++SCz3oL43c7IH/75NPeuD/NvJPHuQ5gzzuwfn2
AXmmiTzuJC804V8m+WkT/u0mJ5rQK4ucZmI+PiLvN7G/7SHXmcj3PrJhKv//
zI/J503kIZd8zYT+eeTpXuifTw73Yr0CcrQX6xWS13ixXjF5ixfrlZD3Tq5X
6ud/ATgCIZ4=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9MlHUYx09FMjSSxBALxDRGDBVjKpW4n3+KKFbKmumimmSOrAXaqAQz
ZFhEKZKgQkT8lT/CeXDHcRwHvHe3NBe5ak7LbEZNc8mcY6JmE3t/3/o+rduA
fbj33uf3PM/3+31vdkZW2qvjLRbLcfNH/+UrwXzdf23e8n8oRW1JCno+XHi9
SnNF7rqXbGSoh9JLfNPk/dfUtZj0u0PIKkuZb+cEy/VbNY9OJv+So68vuVM+
v019MziYegc5arvadWlN4kS53/tqlvmPCeT4nSop6HT9OLl/gdLnt5BXF6qG
7KSg26Ost0uZ5WPGyNkfqieHcstukS0fob7w3uL/c9QnOK+wbTfuL/dTJfq8
LuHMvbi/1I8vxeflfDdK9Xma/zv/pyrUmjw0nly0Tw3lhs4PkH7KdL1imceM
cswzUOZZrsxxZE8iN+/XfEXmm31Amb/zZf6JB/X5Qu+S+Vfo+dllX19VYP9T
yXsrlXm8m7LfdZ/h/LL/qCrlH41Jn06+WAU9hJFtn6u8UOuxGeR3q3GembLf
L5R5/CTRX0AN6kWQM2v0+32zyIM1+Pxs0UOtvn/yHHJZLeo/KPOu1f2cjian
16nhNa7qGJl/ndpkvmLJc+uhpzjZR72uZ5lPHq7X+hhcIPtpwP0Wkh0NyrTL
6wmyr0b0t4i8vRH6WSL7a9TzO5tIXnVI79/6qOzzEPpdSp7ShP0sk/02Qd+K
fLIJ81su+27W/vluJbmqGf55XPbfoq/PTSZvbIHfUkQPLfr6OU+T41px/1TR
Ryvu/wz5aiv0sVr0chjnTyN7DuP8z4l+2qD3teTCNp03E9eJntown/Xk1Hb4
7QXRVzv89SI51Ip9vix6s+q8WrGBfNaqKisqwl8R/R2BXzaSG45gv5tEjzbM
K5O82IZ+Nos+bejnDXKlDfp5U/Rqw76zyWM2fb4LW0S/HcjTt8gZHfp8FTmi
5w7k6Tvkox3Ip22i7w7sP48c24n5vSd670S+7CDv6cT88kX/ncirAvJIJ/Kk
UPxgR70PyGvtqFck/rDreViKyW479vWx+MWOervJkQ7UKxH/OFCvlFzgQL19
4icH6pWTLzjQ3wHxVxfqHSQ/1YV6leK3LtSrIlu7UK9a/NeFejXke5yoVyd+
dKJeA/ltJ+bZKP50Ip+ayGec2F+L+LUb+ztMXtYNf7WLf7uh/yPkum7kV4f4
uVvnyaVOcqALeeoQf7ugTyd5s0vvI98lfnchn93kEy48Xz3i/x48D/rJD/fA
DwOSBz3wg5e8vwf+9ks+9OD59CX5Zg/8d0zywg3/HSe/5NZ5Gfm15IcbeTJI
9rmR1yckT9x4Pn1Lju7FPr+XfOnFPk+Si3uxz1OSN73Y5w/ky73Y5xnJHw/2
+RM5zQM//ix55EG+nyM7PcjLIcknD/z/G3lmH/x/XvKqD/P9nbyjD/O9KPnV
h/n+Qf61D/Mdljzrx3wvk5/ox3yvSL71Y74j5NZ+zPeq5F0/5jtKDh6AX65L
/g3AL3+Stw5gvn9JHg5gvrfIpwag39uSjwb0O+76vxxhIO8mkBcbyLsA8rMG
9BtIzjSg30nknYYyf+cHkSsNvZ8NU8h2A8/TYPKggTyfSj5v4PtRCHnMgJ6m
kcO80NN0crwXz48wcooX/YaTM7zQ033kPC/0FEEu80JPs8jtXvQbRT7qhZ4e
IJ/zQk9zyTe86DeaHOKDX2PIsT74NZa80od+48jpPvQ7j5zjw/N4AXmPD/0u
JDf50G8C2fDh+8oi8o8+fJ9aQh7xod9HyJP96Pcx8lw//LOUnORHv8vIa/3o
V5Gz/PDPCnKRH/2uMvlvy38NEw==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw9lg9MlHUcxsmZK60sxzJrIhUzNHVOymwO+mn4hyT/UJHOy5JIRXNcTAwB
ExkkkQraoUGk4oH8Uc7j/nEcx3H3XjNd2L9ZzmKlNY2FszIkZsu630PP9za4
ffbe+/t9v8/3eX7v+3BGdtobI6Kios5E/vQ3P6X9K7xzB6fPG6YUVVNdPSFR
eJWyLbqUn0QOZqjwjfjeZ+R6ljpvNSfOI6tslTj6vHW+/D5HDcabxiaTL+Yq
U4WRu0Du36aiIxssJMcWqkmRghbLejv0+l0p5Jk71aX86BlLZP1i7JdKXl6i
Fkd+sFT2K1X15sTyZWTzLqW/Vsj+76G/NHJlua7vxgtSz24VWd78Etm+R3lj
SvvTpb4KzZtWkjdU4voqqXcfrq8mD4H7TVL/fqy/hlz2AfZ/VfqxoL615Aeq
VJo35vbXpb8q9JdJbjqA/tdJvwfV1RXeQ+vJcz6EflnSf7XS899IPl2tCiID
eVP0qFFvRQTeTF75kVoX+WSLPrWo10zuq0U9OaLXx/DTFnLeIb2/LVf0O6ym
mCrmv00eeQT+yhM9j0CffHLPEb3+6ELRtw7z30621MGPO0TvOtRfRDYdxXrF
ov9RrFdCjrOqSDtNpTIPK/TYRb5q1f1fKZP51Ot5lJaTXfW6nkd3y7wadH/G
HnJhA/SrkPk1YJ77yMnHsP9+mecxdbanJ9VCvqtR1/97lcy3Uc/bcpB8rlHP
c061zLsJ+aoh1zah3lqZfzP8cIic2Qy9DosfmlXkf1EdeVqLri/eKv5o0Xn9
qp480AK/HhO/HIceTWT/cfy+WfxzAr8/Ti45gfVbxU8nUI+NnNqK+u3ir1bU
7yBH29CvU/xm0+dPhZvca4M/2sV/J5FHL7n+JPLiEz/aob+fPNuu9YgKiD/t
KiEhwdlNrrHr/deGxK925DFMvmXXfvr0E/FvG/o/Rc5oQz+nxc9t8NsZ8qk2
nafqz8TfbajvLHmqA376QvzuQL6/JO91wP9fi/8d0Psc+boD+ftG8uCEv86T
053Y74Lkw4n9vif7nDiveyUvTpz3P5BjXOjvouTHBf0vkYtdyPPPkieXrsd0
mXzFhfPkF8mXG37qIz/nxrx/lby5kd+rZJsb9V6T/LmRz9/I4zx6vkV/SB49
yNOf5K0enHcDkk8P5j9I/s4DfYckr+3o9yY5qR35/Vvyi+u2f8hH2/G8+Ffy
3I753PbX/zzKC71GkOd4cV6MJG/E9U2jyLW4Hn8H+fPh++8kR3Xg/jHkWR24
/25yZgfqH0s+gOv995JP47ptHPlmB/qPJk/zaX0S7iev8UG/8eRKH/w5gWz4
kIeHyAM+5HUieXKnnk/UJPLKTswvllzeifPhEbK/E36NI1/rxPvIZHKsH/55
jJzmR76mkEv88N/jZI9fnw8x08l9fuRzBvnBLug5k5zaBT1mkd/pgp+eINu7
dL83nyT/1IV+niJHB/A8fZq8MIB+5pLzAjhfEsktAeQ3idwbQJ4U+Z5uzHc+
WXVjvsnknG7MZwG5vht5XkT+thv6ppBHBlHPEvLEIOp5njw7iPN4KXlZEPos
J28IQp808s4g9HmRXBPEvNPJTuzX8zK5B/tZVpEvBzGv1eRbQTx/XiGPDyF/
a8gzQ/Dfa+SUEPrLIGeE0F8muSCE82cd2RJCf+vJrSHkIYt8KoTzbxP5xxDe
dzaTh0J4/8gm32fgeWcmTzUwvxzyswb02kI2GdBrKznXwPmWR95rwN/byI0G
nm8F5KCB95Ht5AsG8rqDfN2A/jvJY8LQv5gcF0ZeSsiJYaz3Ljk9jPXKyNlh
rFdOLhte7/0I/wdTYBv8
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw9lA1M1HUchzHTHDkzdk7NiTkZI0aOvFm0Rv0y59tsCi1f1s0VM2a6Btoo
U2fKIF9K0UQTJENe5P047o7j7riX/93NFyY6c8yMdEpOTWWMMaRTp3a/T32+
bo49Q+/+/2ef5zszJy/78+fi4uK6Yn/1T/6xlIQfBEdef/8/WqxmFN//LSS8
WpnNZkeEbOSokRRLySn5/Rcq/vfq/DNklafOd3cv7ZJ/v0nFPj7lHPlGgarJ
z4w/L///W5Wbm3v7AvnVbWqryXrmonzedyoz9gWXyOk7VbY7sbhHPr9QmawL
P7tMXl6kYo+TeUW+r1j1Z7kTe8n5u5R1Yd+jP+X796jIg5Sr18gH9qri+1nu
6/I8P6rysrKyPrJtn4r5Krgpz1eifWXdIq87oH2Z78jzHtS+XrpLjh7Uvgbv
yfP/pH1195N3H1J9W0zWAXmfUu1r7yB5ymHtK3dI3u+w9rVwmFx/RPuaNSLv
+7P2NSZKzjiqffU9lPcvU6/FXugx+WyZ9nX8ifgo1762PCOvOqZ9WUb9Qz8V
2lfGaPLfFdrX1DFk2y/a14Ox5M3H1cbYA44jq1+xr3jy85XY13jyukrsawK5
uxL7mkhOP6F9zU4gl57Avkzk6AkVm8v9SWRLFfY1mWxUYV9TyUnV2Nc08u5q
7Gs6ub9a+5o3g7y8BvuaSXbWKP1jFnlKLfaVRN5Wq/fpTybfqMW+UsjzT2Jf
qeT6k9rXyjTy+DrsazY5v04tiglIJ/fUYV9vkDPq0bOZXFGPfc0lxzVgX2+R
1zZoXxveJp9twL7eIac1oudM8oFG7Os98nAjelbkVU3Y1zyyrwm+58t+mrWv
HQvIRc3Y1yLZUzN6XkJe2oJ9LZV9taDnD8kmK/a1TPZmRc9Z5KtW7av0I9lf
K/b1MbmmFT2vlD3asK/V5Ddt6PkT2acN+7KQy23oeY3s1aZ91X9KfmqD7xzZ
bxt6XkvOacO+cmXPbeh5Hfl0G/a1Xvbdhp43kFPt2NeXsnc7es4j77ej542y
fzt8f0UesqPnAunBgX19Q17hQM+bpQ8H9rWF7HWg523SiwM9bycnOuF7h/Tj
RM+F5EInfBdJT070/D35thP72iV9taPnPeQl7djXD9JbO3reR7a2o+cS6a8d
vg+SE1zo+ZD06ILvw+SvXej5iPTpwr6Okntd6Llceu1AzxXkdzvQ83HptwM9
V5KrOuC7SnruQM/V5LFu+K6Vvt3ouY683g3fDdK7Gz03kS+40XOL9O9Bz63k
OR703Cb3wAPfdvIRD3p2yn3wwLeL/Mijfe1wy73wwreXvMaLnn1yP7zwHSCH
veg5KPfEi55D5ORO+I7IfelEz6fIezvh+4zcm0703EUe6ITvc3J/fOj5PDnb
B98X5B750PNFsssH35fkPvnQcw/5FT96viz3yg/fV8jb/ei5V+6XH76vkv/y
o+drcs8C8H2dvCCAnvvkvgXg+ya5MYCeb8m9C8D3HfKEIO7nXbl/QfR8j7wp
CN/9cg+D6HmAfDkI34NyHw30PESebsD3sNxLAz2PkJcZ8B2V+2ngfj4k7zTg
+7HcUwP38wnZYaDnZ3JfDfgeFf2fbxnoeTT5qQHfY8iTQ9pX3Avk9BB8jyMv
DuF+xpNzQvA9nrw1hPs5gVwagu+J5JYQ7mcC+XQIvk3k6yH4nkSOhtDzZPLL
YfieSk4No+dp5A/C8D2dbAnjfs4gF4TheyZ5fxj3cxa5LgzfSWQjjPuZTP4j
DN8p5KEwfKeSX4zAdxo5KQLfs8mZEfhOJ6+IwPcccl4E99NM3h2B77kx/hdu
Xxi+
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxNlg9M1GUYx8mRa1g5HSutiVTOIckkcYTV5RuaQlIEM4TCSoZEWgNNDJES
HaaSASaaICryR/4Ix8HBcRx33N3vGuZC13+nYyU1jSX9MzRmy7r3S99nscHx
2fv7ve/zPN/v87z3QEZO8rpJAQEBZ/y/+vN/P0Xz/ox4auLfeJWVlXUlXDhN
nR0cTJhP9mSoXVeT7BGy/royBZ1/aAFZ5agbYellkfL8JmVeMXzzEfKlPGUP
2bUhSt7fqnzXw4YWkUML1Wz/AdGy33Y1L73MeJQcuUOfH7NY9t+poqKirI+R
ny9WZcb1sCfkvF06vjoTOXe3Gk2yhyyR8/dqPqbI5SWqqrJyZqzEs09z5VKy
5QOsPy3xleH95eTscuwfJ/Hux/nx5PH9iG+lxP8h4k8g7zmA/J6TfCqQfyJ5
xkHokST5HVQb/Qckk5sOaf2yVkm+Hyn/8b+9QI45rLTeqyX/Sq3X1DTyJ5XI
50WpR5WOLyqdnHoE8ayR+lTr81e/Qh6p1vpefVXqdRTnZZDzj6m44YLgTKnf
ceVH8zpyYI3eP/Y1qWcN/JFNHqxR/uPz1kt9TyD+N8gVJ7Dfm1LvE2pbsHlF
Djm9Fv7OlfrXIr5N5Dl10G+z6FGnztfluvLIo3U6nvS3RZ96/X7AVnJXPepX
IHo1IJ9CcmGD8ocz/I7o16CS/QXbTl52Ev7YIXqe1HoP7iTf2aj1zC0WfRvh
x/fIXzUi3t2idxP8sJdc3aTqc01B74v+zfDfPnJmM/IrFT806/huLyfPb0F9
94s/WqD/AfJYC54/KH45hecPkZ2nsP9h8U8rnq8iF7ciniPip1Zdr7VHyQlt
0Pu4+KsN+daQg82YL7XiNzPqU08eMqOeDeK/dj2fChrJ9e2of7P40QL/tZCj
LZhvreJPC/Q1k6ss6Ld28asF/d9BvmVBvazi3w7o0U3O6EB/2cTPHfC7nTzQ
gfgc4u8OxNdHDu/U/VXhEr93wv9ucmmn0h9e8X8n5rlBvtYJf30s/WDFfB8g
p1hx3mnpDyvOO0N2WDGfPpV+sULfs+SQLuR3TvqnC/X/jLyzC/PmC+mnLsyT
L8lXunT+TV9Lf3XDH+fJz3Sjfy9Iv3Uj3otkczfiHZL+68Z98y15ug3+uiT9
aINfhslbbOjXH6Q/bdD/MvmiDfX9Ufq1B/4cIT/Zo9eLfpL+xbpplFzbg/vy
Z+nnHujzK3myHfX6XfrbjvviD/J6u/bL9THpd6zbb5DPYT1vXPq/F+/fJC/s
xfl/yTzAuv1v8iGsF/wj86EX8d82/h/fnHh/Enm+A/kHkl92IP/J5HIH6ncH
2XDAL0HkMYf27+kp5Ll9ul9K7iKn9sFvU8klfdBvGtnZh/txOvmXPtznweRQ
J+bRPeRkJ/wzg1zsxH0xk2xzwn/3k0ec6JdZ5Ptc8O9scoILeoSS33WhHg+S
LS74aQ75exf6dS45uB/5hJGX9yOfeeT8fuTzMLmlH/0QQR7qx7xYQL7bjfkU
SVZuzNuF5E1u6LuIXO+GPtHkb9yYVzHkQI/un88Xk2d5EM/j5GgP4jGREz2I
Zwk524N4FHmHB36LJVd5UJ9lZKsHei8nD3rwfSKOfNmDfo8n38J5TSvJ93qh
17PkSC/8n0iO98J/SeQML/o/mbzNi/mxilzhRX4p5DYv8kslD3ihfxr5Oy/0
f4k87oWf15CnGRPfp8jhBvy4lrzUwDzMIKcb0C+TnGco/9+iLHKpgXplkxsN
3IfryR4D30c2kC8YE9+fyNcM+CGHPMUHf24kz/Gh/m+RTT7st5mc4kP9t5Bz
fJg/+eQ9PvirwM//ApTCFhI=
      "]]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979775.4985},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10000.}, {979885.1, 982077.13}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.689755823605915*^9, 3.6897558273554907`*^9}, 
   3.689756172466976*^9, 3.6897669543144293`*^9, 3.6897670051609583`*^9, 
   3.6897751931461725`*^9, 3.6897775977032304`*^9, 3.6897791742715883`*^9, 
   3.689862058052161*^9, 3.689862211107356*^9, 3.689862776301096*^9, 
   3.6898631173113155`*^9, 3.689863193335797*^9, 3.689871274334096*^9, 
   3.689964133678257*^9, 3.690015751752061*^9, 3.6900158161647635`*^9, 
   3.6900223427863827`*^9, 3.690022453339677*^9, 3.6900268864790974`*^9, 
   3.6900279198098726`*^9, 3.6900346913500757`*^9, 3.690746395413887*^9, 
   3.6907464471151657`*^9, {3.6907477156760283`*^9, 3.690747737296307*^9}, 
   3.6908273322058153`*^9, 3.6908304659437456`*^9, 3.690830797644388*^9, 
   3.6936011674312963`*^9, 3.6936017495215673`*^9, 3.693602673155058*^9, 
   3.6936029761026573`*^9, 3.6937730683223925`*^9, 3.6937735909703903`*^9, 
   3.6973112082405233`*^9, 3.6973112570525804`*^9, 3.69731158818089*^9, 
   3.759169562694585*^9, 3.7591712102828846`*^9, 3.7593495913492737`*^9, 
   3.759410239518339*^9, 3.7594110044590125`*^9, 3.759419036571587*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P1", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Linesmt", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2", ",", 
        RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.6897563694622307`*^9, 3.689756387670404*^9}, {
   3.689756446931783*^9, 3.689756448760599*^9}, {3.6897582592374463`*^9, 
   3.6897582599405603`*^9}, {3.6900347042932234`*^9, 3.690034713926163*^9}, 
   3.690746444579601*^9, {3.6937734051374702`*^9, 3.6937734358784947`*^9}, {
   3.6937735004785967`*^9, 3.6937735397440205`*^9}, {3.759169582653611*^9, 
   3.7591696330239077`*^9}, {3.7591712253765883`*^9, 3.759171245343167*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91g9M1GUYB3B02Bw4WcZM3SRdVMTIUS5jLezVTKPRRNzEjNhgwDDdIItM
YZgkBSwE8xRBROD4L5zAHXfH/ePud+W/nS7LYjotqBQSSqfCkKV17/f2fW9j
7LPf3fs+7/M873O3PCM3OWt2UFDQef+f/M9XfMjQs/Nvv7QmoASx0v8KVX5f
vJhauXYu7c4QF32+xDnq+XbxTMn4ptm0yBUfx4ek/PcX378L/pcezsf7H9JB
e7DeFL2sEPvdp8U+4X973F06dr+o1Caj/lbrF4t3RvaG36aTDgj5b1TtVyKy
s7Nv/UHnfS338w2r/cvkeY036KpyMRWVWnlNxfONCBnS5w3RPRWI94qKr1LI
/F2mc6qEYcPIzEUV7yHsd4GePiQmNlnrz6r4v8X639Glh4Wf8R51Hp1ozosP
cdGLjsj8Xbap8x0RtTU1NRa6/agIN2xIN6nzViO+XjruGPLRrc5fI5/rO+lz
Nfh8m8pHrYw3opneelzWc6hB5acO+TpBj9WJAv8CtSpfJ1CPavrzeuT7sMrf
SexXRQc3oJ4VKp8Nsh+0MtrXgHx9pfLbiPi+pHWNcv+z+1S+G/H+Qjq1SeZr
8R6V/yaZb2c+HalHPLtUPfQi2RoxJ5ee0Mv+a9+h6tOMfsihTc3CGlEynqnq
1SLrV55OF7agf9NU/Vpwvm30ulbsn6Lq2Yp+2kzPa5P50SWp+rZhvffoK21Y
L0HVux33bz1d14741qr6d8j6fPEmndmB/L+h+qED/RFHx3TiPr6q+qMT+X6Z
ftCJ/VaofjmFfoumHadQjxdU/3ShPyLpA13I1zLVT12IZymd2I37s1j1VzfO
v5AONwj/2w0LVL8ZEG8Yfd2Aeoeq/jsdmG9082mcJ1j1Yw/qO4te1YP792iM
/QlvmqFre3A/pmgfnHKffhx4foeO7cXzCToDHhqjdYHnN+kzgecj9HQv9v+V
ju5DfNfo1D7EP0Qf7MP5fqLdfTj/D/S9PuTHR0cakb/z9BYj7u/3dKlR5nuF
RtuM6BcXPWHE/bTTESb0r4VOMmG+mehiE/qxhzaZhL+dJ7voWybZvzs66EX9
8r6MtNDv9iNfTXRhP85bTxv6MV+P08P96JdqeoEZ81JHrzMj3ir6MzPmQQXd
bpbx5ZfR18zo9xJ6ngXxFNOrLYiniM6zIL8FdJMF+dtNX7Gg/z+ln7AiP3l0
nFXep7s76Y+swjsZlbqdrrNivyz6khX7ZdBBA9gvjX5lQM7zsA/ozAE5f/am
0EcHcL7N9LkB9F8SPTMg17cm0jE25DOBTrPh++JtusqG+q6hNRvm32r6gQ3x
v04/b8fvk9forXZ8/62ky+0yP0GxtMOOfomh/7HjfkTRyxzIx3N0sgPzZTl9
wIF6R9BmB9ZbQo85sN5CeokT6z1FJzoRXxhd5ER88+gep8xn9lz6d2dg/tDh
LtyvWfR6F/L3aJTzzYX8PaQ7Xei3Kfq6C/W4R88fxH28Q4tB9NM4vWsQ92mU
bh7EfPiT/mUQ/TJMB7uRnxv0UjfOc5Ve5cZ5fqY3ujGvf6Rz3Jj3l+j9bnw/
XaBr3ZhfZ2mjG/fVS/vw+RA3fROf3+GgH+PzPiv9tAf799OxHuzfSyd4Ar+P
6AwPfs900gUenL+V1nlQTz3d7UH/nqTPeDBPj9O/efD74xg97cH90tFPapjv
VXS0hn6voN/SUP8yOlVDvkrofA3xFtMHNcRbRLdpiLeAdmuYF7vpqxr65RP6
nob5k0eHevH9vZOO9CK/OXS8F/c9i97iRX+l07leud/1D+lSL863ze//AQED
/1A=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw91Q9MlGUcB/ArKbezLB3lnyXidIZEaDqNubDHSEWHU8kpTtJ5qQOd83Ka
Jk6RQSHTwEQUREXvFEQ47zoO7i93997mn3a5XCZmNDEXEBpLJ0XMXO/zpe9z
m7jP3vd93uf3e36/3zvBtDVzw/MGg+Ga/k/+z5+xzfLn5p635w5qofguGo1u
Ul4lrObUklw6ZBKlWl9CjrqeK123kRZb5f3GDer+beLTVOPKT+iOHSLTHVe0
Tj3/uaiqrKxcS8fvgT9W6+3D/avpafux3iq1foG8f8xKemkh9r9cva9I6I9v
zqTNXwrbgnsDS9T7Dwj9T/5iuqxEZOsBLVL7OSgifQnZ6bT9kCh6sMw9T+2v
FPGm0TllYrx+g1D7PSz+SsguTaX7D4sp+gtmq/1/LWT+36WLj4j0e7tjZ6p4
ysUM/TedHn1U5MXaFkxV8R1FPpLougqhX143RcV7DJ5MpxyHJ6r4K/F8PH21
UuYvY5zKR5Vos5hTx9JZJ0SqsW3iKJWfasQfS3dXy3w/eFXl6yTO42V61yn5
vMWo8ndansfuoXRMDfIXo/JZIx4uc8c9R0drsP6/vzO/Z3AeA3T5GZzn33T/
GZnvD57Q2WdlPb3wiA6dxXn8QU+y4Pkeutgi10/poh9acF736aVW1H8H3WRF
vfxCjz6H/Nyh95yT+QzcojvOoT5/oD88j/P/nq47j/uj9Eu1YqP+u0aba2V9
vXKZvlkr68Wp0Sl1ON8gXV2H+vbRhgvoNze9/gLiddFXL8jzuOGgk+pl/GYb
XVaP+C7ST+pxvrV01kWsZ6X9F7FeDR3fgHhO0oUN6M9KursB/VNBZzSiHo7Q
9kahp8tWSsfaUK8H6V021F8x3W7D+RTR4pJ8f+d+2npJ5mfHXjrGLuvBkEfP
smMe7qRz7Mj/drrKjnya6agd+91CP7MjP7mqfh2YpxtpkwPxmFQ9O9D/a+nL
sHO1qm8H8ptFJ36Dfliu6h1OWUZ/NXh9sar/weuL6MeD1+erfnDi/Wn0Ctj5
vuoPp9xv8nu014l+SFH94sS8mEnHNcl8nHpH9U8T5ncyXdCE805U/dSE+nqT
7myS55E/UfWXC/Uynl7kQn2+ofrNhfMdTdtcOP/XVP+5UI8j6JHNmK/DVT82
Ix9G+rNmxDtU9Wcz4hlC32lG/xpUv7bg+/W0+3/PaUH/9dPmFtR/H322RfZr
2yP6Zgv200u/6MZ+eugUN+qni97klu8vv09XuzHvOujrbtR3O23wyO/Bvdv0
dA/m/4/0eg/mzw26woP3XaevevC+b+kBjzwfwxU6yYv5FqHXeBFfkC7zYj77
ac2L+nHTT7zIp4ue7MP5O+gsH863kS7x4ftRT/t9yNd5uteHfrTQ8X7082k6
04/5foIu9GN+Hqeb/chHOd3tR30fpscGsN4hOiOA9Q7QewNY7wvaHsB6BfSv
AexvHx3bivrJo+e34vu3k97VivPaTte3oj/NdHsr8reFHh7E9zaXFkHZD+0b
6G1BzE8TbQ1iXq2hbwVRT6vpmBDqdyU9LiTr9cpH9KwQ6mUpvSSE/GTQOSHE
k07vDyGeeXRVCPNwLu0MYd7OoaN4fvNs+jc8H51FP8PzyTPoUWHMl6n0tDDe
/xa9MIz3J9CmMOpxEp0XxjyaQJeHEf84ujGM+MfQl8Ooj9fpu2Gh/80fSfeH
0X/D6REa8j+MTtTwPRlKp2mYH0PobA31bqB3aMjX0y7Oew35+oeu1ZCvPjqk
Yb+P6J807LeXfqyhXnroYRH0byc9KYLvw306NYL83qVXRJDfn+mtEcyz23Rx
BPPzpu7/AFQHCXg=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxV1g1M1GUcB3CWxhZpZaNJb2hJRYyIYjHdoj0lyzRmwspwXdYIibQJsuF8
oUQGgWiCBOQRKC+HnLwcJ3fcG3fc/+4UdV2uGsUsVmiLUMilk8asafd88fuw
2OD22cP/eZ7fy/P877GsvIxNd4SFhZ0N/cpP/uiq/NPa5WdentVqkeGILpvz
BnFhV2SCspYl5P971fhHYknZ5HfKIk/sjjSdVtYK/j8+VigiRtr+mnt+pwhN
F6vmX1okx/OVxR7Mp5y4F/vxqflLREroAeV1pZjPr9YrE2WT6Q7l/HK5n/SA
Wn8f4lGursR8J9V+DohtKRFvn6LNn4vXQhsYUvurkuMjyrnVIikpyaKeTzwk
83mnWn/mkIxn1Vx+apBvN13xBfbrVPHUitC/X7DRUXVCflhVfHWiQa9/8ARt
rEf8JhXvl3I/SV308sNy/uVGFb8ebqfP6JHfVpWPBjGV7og+Smd+Jf6O1d3b
qPLTiPwdpicaRWA6drRO5asJ8dTQO47I/NVWqfwdFaHwtxyg5zeLp3VVr+xT
+WzGep/RwWbMX6Ly2yLjNe6ha1swX5HKdwvi2UnrWtF/hSr/rXLcVEDHtOH5
PFWPNtkPyz6mp9pQ71xVH4Mw5KdUbqKtBhFq35QsVa92Od/kRrqoXdZL/46q
Xzv6IZNOPYb9vanqeQz5SqcXdGD+taq+HeiPNfRwh+yP4lWq3kbsP5VuNMr8
+oWq/3GZT10KnX1chKa7sUL1w3Gsn0zHdyKfSao/OnE+n6Wvd2K+eNUvXYgn
lnZ3od+fUP3TjfP0OF3ajXpGq37qRn8+TKf1YL3Fqr96cD4j6UgT8nGf6jcT
6rmQHjWhX+9S/deLfIXThl5Zz4h5qh/Nsv+qbl267WQzztu/dK5Zno8jM3SD
GfmepoNmxHOVvgnHXqETT6D/LtNZcMIfdO3s+G/00Oz4GD0zOz5Kx/Vh/Dyt
g00/0Af7sP73tNaH++4cfa0P5/1rOsaC+E7T6y2o10m6woL8aLTLgvx56CkL
8uuko63or356nRX3fR9dYhU5OTnjJtpqRT910eNWvE866Kh+nB8DvaZfng9P
M13Uj/uviTb1I149PdaPetbT99twnmvoVBv2e5DebkM/7aeNNtxH5fRPNvFN
MJhWSi+wYz/F9Et21OcTOt+O/O6kW+3I33Z62C7X31VAhzuQn630cgf6fwu9
2YHz/SHd6MB62fQ5B+6f9+kwJ95P79LPO1GPDXS2E/G9Rdc7ke8M+owT/bWW
vuFEPl+n410476vojS7chyvpahf2L2i/C/l6kb7uwnlaQT85gH57gc4cwHl+
jq4cQL8k0O4B5COOvjKA/n+KXurGfMvoDDfmW0KXujHfI7TNjf1F0RNu7O8B
+iEP+mcRneZBvAvpTz34/hFBmz34vhBOX/Qgf/PoyEHU/9bEbb86iPvtH3rH
IN6XM3TnIPr7Oj06iPpepe/xyv7J+ZMWXtynl+gCL/IzThu8iOci/aMX8fxC
z9fQ7z/Tj2rohxE6WcP7e5h+Q0N/fUvn4vlgkN6L5xPO0g0a1j9FWzSs76OD
s+sP0r9ruG9d9E08H2GnF/sQv4VO9KE/eunVPtSzm87yidDfYiO924fzYKBr
fXg/tdA9PpyvJnrIh37S07/6UP96esaHfNXQi/zYbxUd58d+99Mr/dhvOa3z
474upQv96Jdi+qAf92UR3eGf/T5Ea1ivspA+j/XGt9HX/Pi+sZW+O4D4NtMx
AcSXQ6cEUI8P6PUB1OM9Oi+AftTRFQGcr8yQ/wO1PSFN
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw9lg9MlHUYxy+nrsjK6jbNFpKZQ6eNyjk2R/7Spul0iSuldesPmWmuuFiU
ihk6WGomqKhBSPyVA/H4c8dxHHfw3nulUKdpmqSSAgmCWDmHxmxZ9/va93k3
jn32vu/veZ7v831+v/fx5JRl74ywWCztkT/9n5c3Omvt4JUZz9+hhap7g9V5
RfhVdSwcDg+QjWRwv9xfo7LNG47LZJWiVkWuPnk+VS3zRo/qJXelqchvxm/y
/npldS7o7ibHbFQJUR1PdMl6n+l4iy+Q4zar0I1YW6esv0VNzBpMPEdemqme
jVy/SLwsHc9yhmz/XEUe956S+Nuw3klyznYV1VF67bjks0PZss20MLn2S9xv
l/yy1YcJUSuOklfn6PxLheN26eftbeThXWqqLXuuvG/sVvl5eY98T966B+sL
L82F3j+Qx+9FfySfrr2qzJ6w/RjZsQ/xJH/7fujzIzn+K11//AmpPw/xpf62
POj1k+iRr/vZJ5z0tUq3Oo+KfjEFyOc0ub9A3Yy1Zf8seh1APqL/ukLk0yH6
faPff0r6NbJIv//AWdGzCPGFw0VaP1P6HVes8887T84tVtrP4o/hYhUJn/Ar
2Vai9YoSPxklun8dwpNLsd5F6Uep9udb4serpepqojda/Lq0TPunU9hdpl7s
3pDbI/0q13otEL9vLFcRu98S7iqHXy6RXzgI/eW+46COVyj5jKlAPVKfvQL5
i36nK1C/6B/vwPxJ/wocqE/8YamE/uKvlZXQV/zbVol+fUueXoV+GOKPKsxH
gDxUhfx94pdD8IOH7D8Ev7nEP9Wov4acWY18qsVP1ZhXB3nxYcxPufjrMPxY
TLY6sV8Uit+cOv+T+eROJ+Z1v/ivBvrtIZfVYD/IET/Wor87yLPAtm3izzv3
s8j5d+5vEb/WYv1N5NvgFeni3zrk9wk5uQ75fyR+rkN9dvKROtT/vvi7Tvsh
sIY8rR7zvUr8Xo/5TCbvrNf7dewb4v96+Os18vV67V9rksyDC/vLy+TlLvQ3
UebDhf4vIftc2n+DC2VeXNBjPjnajXrnyvy4Uc8c8hY3+j1b5smNfOPJfW74
d6bMVwPm+WnyogY9XxtmyLw1IJ+pZGcD9J8i89cAfSeRH/JAv4kyjx7481Hy
xx7sT+NlPj1ajwwr+ZwH8cbKvDYi3n3k5xoxX/fI/DbC76PJJY2ob4TMcyPm
99+B/3m0F/vp3+R4L/z1F/k9L/QcIhd4cT5fIx/3or+/ky1N0GuA/EwTzuNe
8som+LGHvK9Jn6+uC+S2JszzefKtJujRQZ7uw35xivy6D+udIOf4sF6YbPqw
Xjt5yIf8viNPaUZ+QXJSM/bXFvL2ZtTrI/ub0a9G8h/N0M9FjvFDvxryMj/6
X03O9KMfDrLHr+uzlJP7/TgfiskTAujvAfLiAL5n8smbArqfWfvItQHos5vc
E0A92WRrC+r5gjy/BX7fSl7Xgu+tTHJVC/ycQe7E+7Gfku9vxTyvJ6tWxE8j
p7Yifiq5rBX+/4B8phV+XEseaaD+d8mPGaj/bfIsA+flm+SXDPTTRl5tYP9M
Im82oP8r5HwD52ki2WXg+2gJOWzAT4vIvQb2u/nk2wb0mkceF4Rec8hxQeQ7
m7wwiHzjyclB7G8zyelB7F9x5Nwg5ncG+XAQ+k4lH0G8vifJF4M4vyeRh4Pw
VzT5QVPHuzGBPM3E+TuOPM+EHx4m20z0Yyw5zcR+O4a808R+eje5wsQ8jCIb
Jr4X7iKfNaHHP/08D0zocYt8bwh63CRPDuH79Do5IQS//UleHlKR34xBckoI
83aZvDUE/S5F+D8Qdh/S
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1MlHUcx7FpLXWWjU3LRVrMoaXTcsZa6N+XfJsrcctsu7WiIsstiI1S
NFMH86UUtNME8YUXBVHPg4PjOO7gueea2rpsvUyns4KWhkLlNM2x5br/t32/
BRuDz+55nv/v9/39vt/nxuXkLX3zrpSUlC+Sv/bv/37Wm95Js/79d6GZ4Cl1
Z4pfNllDzz0mdnIs18zQ52+bczX5WWKTZ5K338zS9QXmq0QiIe4qNCW92SFx
ymqcJx671qT65neLzUemorz8QT1/ygb7+WtiZyPuFy8pNk8lf1RvVwnOE+dv
MmuSD/iv3y0mNzf3srhsq1nQXeSdpXo+sfUvnk32bzO3Mjz3zVF9pahXvKLM
nh+Yq3p34HnPkW/vsPoUzlP9O9HPfPLmT80jyYIXqB8v6tf1o3ehX53Xtcv2
c0r11+8GS7/8z+x8os+QM/eY7qJU39Pqv9zqWz6NfLrc2H2YKj0qUN9k8vK9
mPfj0qcS88kg91SaUFpJb7r02ofzx5FX7TdLkxekSb8D6HcMefBBq1fqaOl5
0LyXXLhUcgKfe0dK3yrcP4LsrTK1+VlDh0nvKuh1D9lTDf0HS/9q7PcgcnoN
zvv7KudRAz36yX01Vr/Jf5GX1OL6G+TmWpNch6Jr5NGHTF92KO038tpDqOcK
uesQ9L1MnnsY+3aJXH8YeoqH19n+tur6/DrU/yv5+zrsnziz3p43u4dcWY/9
EKccgR9UzxtHBtZ3+ojdv8yr5CcaTNLe9eKyBvihl/xng0nGQ754+VH4Xxw5
Cj36yGOP2f5WiouPoX5xzzH7vGvixcft+RnS03/c6v+SONUH/cWrfNhv8UUf
9l9sTmA/xbUn0L94sH/g59P9qE+8wm/72S+u8GNfxAn/wPru+DEv8ZRGzFf9
5TQiX8XeRtwvPtlosIbk2404X/pObMJ+ij1NyA/Na3vTwHk6uN6neV9vgv/E
6QH4RfuyLID5aR83B+z8S7vJ4QDq+1F+CWC+F8hpzSZ+M+PiWfmnGfv3HXlj
M+r9Wn5qhl4J8uVmnHda/mqx8+7/nLyoxeZ5bkx+a7H58E2U7GtBfoXlvxbs
c5D8QBD7HJAfg9inE+T3g3hfHJU/g/BrPflCEPtRK7+2Qq8q8oxW5N8++bcV
8y8nV7ciz3bLz63QYyf57hCeVyp/h/C8j8nvhPC8TfJ7CM8rJp8J4Xnr5f82
5PeH5Cfb7PzWr1YetKHfQvLuNsyrQPnQhv15l9zfBv1WKi/CyIO3yK+EkZev
Kz/C2MdXyW4YfvUoT8KY73Ly+Ha7P54XlS/t8Gc2eWs79HleedOOfhaRf2/H
+3qe8ieCfJxDXhqB/2YqjyJW3yHPkoMR5HWm8gn3u9PID0Wxr1OVV1GcP4m8
LorzJyi/otjH8eSfo/Dzo8qzDvSfRp7XgTwYo3zrwDxHkRs64N9U5V0H9L+f
PKITeTxc+deJvLiXXNCJ98sQ5WEn5j+IfLYTet25wnx0UG8/+WEH9d4iT3dQ
7w3yCw788Qd5hYP3dR95gwP/9pArHOj7CzmA89K6yQmcV/QD+ZIDv58n33HQ
31nyqBj6+5Y8JYZ5nCEvjGEeX5JzYvi+cYq8Job3UZzsjcEPDvl4DPsTIZ+M
QY8Q+acY/NhCvh2DfxrJI13sm4880cW+N5DnuJj3YbLHhd9qyIUu9DtA3u7C
H3vJdS72Yw/ZcZHPXvJ5F98PysjXXei9jTwsjvfBFnJ6HPtUQs6KY/83kpfF
MZ915Lw45lNE3hzH+/yDJP8DJJoYkg==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxF1n9MlHUcB/CzSXPIdBYV2SRcrCh/RNKIudG+pEkYJVIq5kWKP0JrA12W
IUtlOI1ZQBF1iMZP+WGeB3ccx3HAc881xUUuF5MySrAkSlatxDn+YN33fb0/
3cbYa8893+f7+fH9PLcwJy9z+x0Wi+VC8E//58daak6m3FiSElKa2p0cPrRC
vFElJCQ4n6WNHHUrzlqaKtd3qvCh+vw0WuWprwcG0p+X7+9RowWRS1+gR/aq
hvzk8DVy/7vKE334RgYdU6j2R9rPZ8p6B1RwO/Uv0/GHVGbwhvWyfpGKtKdu
yaIzitWj1tJnXpHnHVYTaz3RVjr/iNL/suX576vAZNzwa3RZid5fiTjmmLKn
jk7J/Y4P9Petsr4q1fHZN9C5ZUrn8//9liN+ied2OfYr8RsfIZ50+ujHiFfy
mVGh85EqjvoE8a2W+EKWfDdXwrJe/qe4X/Kf9Jl68PCNtS9K/DbEI/vpt6kd
wY/Uo6wK9V1LZx3X+Tso8cRUox9eoserdb5PSvyOEyqYjuZ19L6TKvh4j9RP
fY56S/5m1qD/pJ65NTpfoxvpgRq9n78k//G1qM8muqJW5zPsVcl3LfpN6m2t
0/udK/U16tRzwQJtpmPr4S1Sj5Bz6ImQt0p9GrD+NtrVgOdvl3o1oh/EhY06
v2M7pH6Nuh6XXqdXnlLBdPfkSj1PIZ876Ygm5H+X1LcJ9XuDHmzCeZXrSc16
vWRZv7oZ+Zb9W1rQDxL/thacB+n3/hb0g+R/cSvOq9SzrBX9If1wsxXxSn9l
ndb1KZD+9MFTMj9ivkA8K+li2CLzaDx0PZlOP4Pry6W/zmD9RDrSjvWXSb/Z
9X72Pk4Pw5OLpP/OYv9xdMNZxBcr/ehA/AvpRAfys0D606H7dcN8usqh59/A
vdKvDpy/u+lpB+o7V/q3TdcrIYLOacN5mSX93Ib5FUafa8N5myH93YZ+m/79
Pz/WjninaGs74rlFf9iOfvmHNtqx3z/pv9vRLxN0rBPzbZxe78T3f6WPOnEe
xF4n8jFGTzgxT6/T0S705y90hgv9/zNd5ML5uEa7XDjvo/RYyCN0VAfmw1V6
dQf29xNd2IF8/kjbO9BPw/RIB+rzA32XG/m8Qq90Y159R7/txvweopvd6MfL
9BW3zkfFIB3Rifp9Sz/dqapsNtslOr8T8+gbuq4T/XyRHuxEvw3Qd3rQL1/R
SR7Ec4He5dHz3zxPV+O65Rx90YP30Ze0pQv1MullXegfg97Whfr10pVd2L+P
7g/ZS091IX4PvdiL+910thfru+gyL57fTpte7M9B3/SiHnb64W7U9zSd1Y3z
0EKX4Hp6E+3rRvyN9B/d6Oc6OsaH+VdDZ/rQXyfoYh/2f5x2+3S899vocR/e
15X0/B7db3EVdDrcXE6/16O//1Ap7ehBvo7R13qw3xI6shfz5wi9qhfzu5je
14v1iujWXvTPAXq4F/kqpOf0Yf8FtOpDP79D7+lDPG/RDbg+upu+HLo/j55p
IN9v0gsMPH8nnWgg/h30GgPnfSudayDfm+lDBs5DNl1loB820U4Dv2+y6AED
/bOOvm4gX5n0NNbPX0Pf58f+0ul4v873wTQ6LeRVdE7IK+j9ofsVXeHH+sn0
GT+ev5w+58f+nqKv+jFvnqRv+3Gen6DnmZgXS2Wem+j/RfQKE/PxEZnvJvoh
lt5ron4LZd6b2H803WRi/j8g89/E86Po70PPu0feByZ+j82jZwdQzznyfgjg
PM+mkwOozyx5XwTw+yiMzgug/jPk/RFA/0//tiTlX3rl87s=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1GUcx6lRa+SyFzbMFmqRQ6aNchlb4Z60SRQVska4qAYh4UuBGIpA
KsQlMALUEwJJeX8TzuPl4O644/53bGqN3GqVs9GCVsaCVWPiGFuue763789x
G8c+3HPP83u+3+/v92ddenbS7ruDgoK+9v/o33y9Ml1gLprd9FKA4lVmZuaN
QuFdyv95qLCRrhrq6x8tkM/3KEvc9FI+WWUr0+xO+2FZn6vW+P9wiDyVpwpD
LZc/ke8fUXM77eEHyWuL1IHYkLcPyH7HVMi11pxscnSxsoeb9n0k+5dg/33k
xFLst0fOM+n9rmWSc07oegsy5Pxy1ZYTG5JOrqlA/WlST6W+b/0HZOsXKrXa
l7db6qtGvR+Ss2rUZv9Lzo8+Cf2kvsWT+j7/7pf6T6lvJyYmPiaXnVb+5ZYc
uY9Z11eRS151BvcX/abOaD3jRN+uWlXtW4gUP3LqVJI9/B7xK+ZL5V8+fcff
erXBf6FPyVfqtX7njokeDcr/fryYnHJWjS9Epn4m+jQqvz2xJvJMI/JxQvT6
Suu1UEbOPwc/KkS/81qvwUpycJPWy1wlejbB/xryRBP8PiX6Nmu9njaTzc3w
s1b0btZ6zdaRU1uQv3rRvwX+yOcRrajntPjRivPk/LlW+Cf1JrbBn3LyUJvy
X+/Jz8WvduSphFzUrv1OEH2n2pf78XIH8iX+dXXAvzzyik7oI/2R04nzJD8/
dOrzYiRfMV3QQ/qlsQv6Cwd16++3yvczunX/Z0q/XelGniSPG3tQr3BNz/J6
bvboPG2TvKZcgP7CrgvQ606/96J+yXNpL/QSnulFvuX+CX3oF2Fr3/L8h1qQ
Z+F8C/Ih82jSgnqF1UXkU7jtIvYT/YOtWC+8xarzPymchc9Dj5AbrPi+8IQV
/Sp824r7C0f3o9+E0/u13l3C5n74I3ypH/NIeLFf58MkHDWg/UkTTh3APBKu
Glg+r40B6C08PwD/hSMGkR/h5EHUI3qVDS7X1wm2iP5zg/BD/AwfwnrJS+IQ
9JU8lgwp/Wuv9NMQ6pH5fWMI/su8XmVD3t8nv2qDnu9Iv9nQPylkiw1+vCX9
Z9P9/V0i+eFh7Pe69OMw9osnHxrGfjukP4dR3zbyz8Oob6v06wj0f4G8dQT3
fV76dwR+bCa3jGC+Rks/j0C/jeR77eiXDdLfdvj/FHmvHf22TvrdjnkTTr5q
hz+rpf8d6lZk6sow8rMOzNtHZB44oM9Kcq0D91kh88GB+9xHXnKgn4JlXjjx
fLyL/J4T8/W/vzg/nOifJbLPifl3i3zTifPnyetHcf4/5JRRXX/1LLliFPP5
T7JrFPf/nfz3KO4/RV7rQr5/ISe54Od1cqkLz4sfycMu6P89ecal/O/Hr5JX
uzEfviEnuJGny+Sjbug1Tra6Ua+H/Jsb9brIoWOYB3byjjHkz0bOH0O/95N7
xvTz2N1HnhzD87iH/IAH+naQlQd5bSHnejDvz5PbPMjXWfJPHtyvjhxs4H5m
8uMG7ldD3mIgj5XkNw3Mx3JyloH+MpGLDfRDMbnBwPP3KHnQgB4F5AkDehwm
/2Ggfw6SbxvIWzY5zIu87ydHe+F3FjneC/0yyOle5DONXOhFf7xLNnuRj13k
Pi/+/0wmX/JC7yTyr17o/QZ50Ys8vUZ+yIf/T+PIUT7kfzt5uw/+KHKqD/l7
kZznw/M9hlzlw7x9jtzpg5/PkI3A+k3k64H1UeT5wPr15PvH4f8T5Ihx9OMa
cuw41j9GTg6sDyNnB9aHkssC6x/08//EAAfz
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1HUcxqlZbfTicrbMTaOyImdl0Rxbo36ZM3WskDXTRW+U5ksFWjgT
l2lSxFKgUHnzBQ4EeTmPuwOOl+Pu/peKdVKUipWrbGVOrTlLZ7a57vdcz+Nt
wD67/+/l+/0+z/Pnjty87IVXJyUlHYj/2L/8JI+4znafvv+JBM022YGJRT3i
Baa6quq2PnI41xxfPdbdr++XmMKx7qcGyCbPxPF4SM+vMHFcHSH/XGBmxTeI
av27Ji0tzfc5OWWNub3o9Nx92m+tsffbT566zlxIzSk9oP3XmzNzA9u/IGdt
sDzxS51XhPuK8z/C/jGd/7Gt95qD5LISW89+ccon9r4VQ2TPRhNvz7KvdL9S
czAWy/yavLjMxLdPH9Z9y+35D3xDvlhuSp3zqd/q/p+CD5GLP7P9SDuseirM
iCs/4wh53Gbcf0T1bTaL4p+j5OYtmIfW5281Gckjd+n89Eo7j0uqJ6nK3j+m
/gxW2XlXDaof1Xaer+wlz6/Bfo76U2vPP6H5n6y137ukF882rA+QV22HnjrV
vx04v4M8aqeJ/37frX7uRP9aybGdZnn8gCb1tw56bSBX1KGfdep3ne3X8DZy
Tr3JKXUKqtX/evt8cw15kgv76fliF/q7g3zGZe7LKZ2u/bMa0A8X2d9g75/U
qHk1muj51GO7yGsa7TyDzZpfI/rdQp6xC35p0zx32XqfUz9uaIK+PJpvE/zk
JR9qgl98mncz6le/a5vhhyt+3w0/ye+v7Ya+Nb/B3dB3kDylBf2Vv8taTEN+
RrL8/XcL9CB9zG+1/XLk7/5W6EP+TmnDvKW3DW3Qi/x8sg36l18z2+HvK35s
h57lx7Fu5I/8u8qN/mm/Y27o7Uq+7ME8lUcNe5BHqm+UB/Uq76Z5MC/pebEH
9au/1R7UIz3HPJhHO/myB/Vp3lM7MB/pI7cD9UpPFR2Yl/S3rwP110rfHfb8
kkryZC/6USG9e6HfcvImL87bKP17UX8J+ZwX530oP/jg1w/I83zwx1r5w4f6
Csm9PvR7lfziw31Xkif6sb5A/vFjXu+Q1/vhd7HfDz2+TT7hR96vkL86kdfL
yXM64bd8+a3Trj+dR3Yn+C35L/H8m+QxXdDrG/JjF+a9jLyyC/1cKn92QR9L
yN93IZ9el1+7oYdF5Me60c+F8m838udVcj04NVd+7ka9L5OvDeB99ZL8HcB9
XiAvDdh8CDwvvweghwXkIXyfPl/+78H6eeSHe5AHzyoPenC/bPKWHuyfpXzo
QZ49Tb6U4EzlRS/0NIf8Yi/ep7OUH73I45lkpxd5M0N50ot+TSff04d5Pa58
6cN+GeSSPrz/HlXe9Nn9z6eT/0w8P0350w+9PULO7sf8H1Ie9eM+D5K7+uGf
KcqnxPeTyeODWH+v8iqI9/nd5PeCmOedyq+gwTXIvwRtfTkTlGcD6N948swB
PD9O+TaAem8htwxgfmOUdwPIu9Hkm0LQz43KvxDyJpm8IgS/Xac8DKFfo8hH
Qpj/VcrHMOZx+dT/PCGMfv9Lnha29xn9D/mZMN6XF8iLw+jPX+R1YdznLLk6
jPr+IPsSfIocS/Dv5N8S/Cv5cmK/4+RbIzjvR/LUCO7zA3l2BO/To+TcCPp9
mFwYwfttmFwRQX+HyO2RxP+b5H0R5PMg+SesX7SXfDGC/HXINzvQe4g82UFe
9ZGfdOCvADnHwbw7yQUO9OMlb3JQ3x5yU2K/VnLYwfuumfydAz82ks85yIt6
8vVRzHc7eVIU62vIGVH7PsivJM+LIs82k/OiyPtycnEU+toU5/8AtPQnzg==

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9M1HUYxm+ObEOXy7EyNwkXNXJWLrdybbhvZhnNFrBmtG61qJzZFuhG
I2WlJpOoAA2pIzT+CvLnOLjj/sEdvzumQZ1OF4l/KECTCIiUxIjMuu/z6302
b2O3z+57933f533e58fyzKz0t+ZZLJa+6J9+l1e5zWaLTDz0pEkp6kFrcfg7
8svqepJ1EdnIVPYNIzu+5edvq9rs5FiyylL5E2nePp7frtK98fnk4RwVO1CT
Tba8j98jJ+SpyTTvYbL6UPXMJA2SV+1Wq6Mv3mfsUSM74h5mfal71b35E6fZ
z3A+7jspnL1PPRv9wine/7GKfhw4LVxSqOLsG17/nvV8quu/7Qdhx2f6PvsZ
1lestiXHvnRWeEuJ0m/nWe9+VRyeabggPLtf15f2I+s/gPNDwgWf4/ww+ynV
9Zb+JLzkoD6/i783fFBtjr54f0MZPj/Hfr9Qer6sZ82X6Jfft9ig76Bwrw31
8L6ScpUcO3Af68v4Sp2IRDayvoQK6DsiPFaB+y5Sr0Pw0yXh3MMqaoeJn6nf
15jHqHBMpfbPml+oZyXmMSYcqdR+K/yV+lZhHuPCpVWY/wT1rlLR62cmha3V
ur57pqh/Ne77XTixBvO8wnnU6O/nXBWerNH7UDzN+dRiXn8Iu2qh7zXOqw71
zAjn1el+Rq5zfnVavyt/Cq8/ovdhbpbzPIJ5zAkvrIcf/+Z8Tb4h3F+P8/9w
3g3on1zRAP1vcv5HUT9/701wEu/vParnX8N+VjbCD9SjpBH7+pvwtUboy3lk
NMG/nG9XE/KEfkhoxjzpr73N6Id+HGtGPtDfG1vQTz/91aL7eYf7G2fX8xsg
59qRR9znQTvq4T6rVsx3QLi2FfvJ/YlxIG+4L485UD/3d4sD8+O+lDv0fkS4
HxEH9OU+3HSgX/p/VRv2l/pktqmdUYPQ76Vt0Jt6Hm+DPvTzbBv8RP1XtGPf
6GdrO+bDeRW1Q0/61WjX+2+lP6fbsQ/0Y6IT8/xLeJMT+tOPBU7oTf/5nVov
J/016YTelsn/Od6FvJgnnOpCnsQI73Ehz+cLu8zPyaMu/D6/v6QD+fGv3Pdc
B/qjn/M6oA/7sXdofdbRz8Md8Df3fbEbzzPqud4NfzFv3nNjvpe5n274g/M9
7741rxd6oBfzd60H+UK/ZXtu9We1B3rz+dTvQT98ns33Iq97ud9ezOuY8FYv
8jfEffciTwLCJ/F9q5/778P9buFHfbjfyTzwYT9ahct8mHcT88GH/huE53zo
v5Z54cd+VAq/6sc8DzE//Mhvm3DYD/3LmCd+7McB4Qc64e8i5kun9nf8J8KF
ndBrH/OmE/V+JDzVCb12MX+6UG+ecHoX8jGXedSFfcwRdnfBL9uYT11Kv70r
vDQAfbcyrwLQd7PwBwHkxxvMrwD89ZrwxYC+75tXmGdB9Jch/EwQ/b3IfAui
v1ThxiD253nmXRB5kyJ8Rzf24WnmX7d+XiWvE97eDT3WMg+7occTwme6ocfj
zEcD+bJaeJkBvz/CvDSQpyuFXzCQh0nMTwP63S+828B+LGeeGtj3ZcJOA/5Y
ynw18P/BXcKXDei9mHlrQO9FwneH4KcFzN8Qnte3C6eEkCcxzOMQ5mMR3hmC
/26MSz6HzHwUbgkh32aEj5vnrwoPmeenhGfN8+PCd4Yx/1HhFWHM/5LwU2Gc
HxK2mucvCOeY588KF4Wxv/3C9eb5U8KGef6E8Dnz9/uEp83zx4QX9OB8WDix
B+eDwsk9OO8X3tSDfj3CWeZ5p3BBD/RpjfJ/ke47HQ==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1HUYxy9DKyQtR4vaIpqsoaNisTH649ondZqOFrCm1q5WjIpsjcuG
M6VCg0JmggYmiMSPAw6E4+AOOI47uB9NcbvcXE7K0QRLsyAzQiMq6j7v63k3
ZAP22vfzfT7P87zfn8/zfSgnP/vVRQaD4VT4V/+Xn+jRpms/TT7yVIQ2KovZ
WDZFfl4Zo0dXXhX25ajRJrP3Fz5/QwWvJ5l+FVb5ylQeuD7N9dvVjSRT+Yzw
eIEKP066wfffRbzfhRMK1dvG6C1/MN4HSuc3J5yyR2W74kv+Yvy9airLFT8v
nFmsUlNTHf9wvxL19MSuSsPUf2z+WNcXzfWGfSoc7s0/hSvKkM8s89mv91vM
fO2fqJLJrPTfmF+5ei38c004rwL5/cx8D6qa6upq9nf2oO5n0w/M/xD4e+HS
T3U9dROspxL9uCgcV4V8uH68CvVeErYeVrG2Da8wvvkzXX/sj8LpR9SqsED/
612t9Sqg3iPV0Id6V9To/Uep99aj8Af1TqjV8dawH1dqoT/1th/T8azs3846
5Mf+qs+RH/WNqldfhkIh6pFXj37+LRyqR/+pb0oD/EF9KxtUOJxtkfBsA/SJ
EjY1wi9LhH2NqO824cQm+OUO4dIm9WB4w6XCU03wz53CmRa1O9Z2cpmw04J8
7xKOa0Z/VggXNiv9L1Z4vBl+u0d4XQv6wefWFviH8WJakT/3N7fCP8z3LHgl
60u34jn7UWuFvuyfoU2f3zFybhvqYT9H2tDPW4ST23GeGa+iHefnVuGZdtTL
fm89jnoWC3uOa/0nyAkd8AfzLe5APOpxpQP13C6c0Yl8yfZO9Jv1x9p0vo9G
C++0wU/kMRv8QD1VF/xKtnRpfYpihKPs0Iv9TrPjvJDz7DreZXKNXe+XQT+E
7OgfeT4Sb7lwSjfWk3O60V9yZTf0IJ/oht/Js93oL/2xugf1k009OC/kAzex
76b10z3ab/eREx3oD/fb7FiYT6kD9wHZ7YD+5CkH8mX98U7UR850Qj/2b68T
/aSeTifOG/W+7NT+mOTzuF7kQ/029cIv5MJe3DfU39aL/fn+eC/0YfwVfbgf
6b91fYhPf+7ow3mlf619OF/0+/k+Fbb3Lp6HmH79/gaelyf7cX/zPJn7F86r
xn7cN5xPZ/vRD867Ja6F8yrdhfPEebnNBT/xfq11Lbx/T7t0fnO8nw0Duh4j
7+/HB+Bv3u+5A5hHvP8PY72X821kAOdrUnhuAPcp502yW9dzhvPoJTf6y3lV
4Ub/vhMOuFX4bxHn3wzez7og/PAg/Pkt59Eg4p8XLhuEn74W9gzC3+eEr0bW
f8X55cF9cEY42wO/nxYu9kDPkHAfeO4U551H+9t8Uvh+L/T4QjjDC/0Dwu97
occw56NX12vwCl/0ol63cOwQ+t8vvH4I8Z2cp0Pwe49w+xC+x7qEx4bg9w7h
ZcPQr43zdxj+ahHePozzZhG2DCN+g/A5vG+s47z2Id+jwg/4cN6OCKf54Ncq
4Wd96Nchzncf/FYuvCfyfL9wTeT9fcKOSPyP+D0Q2f9D4Us+3D9FwvM+6P+e
8L1+3Je7+P3gh547hDf6MV/eEc7x6/vSZRbe7Uc/3xKu9CO/bcKdfvTndeET
WL88V/hCJP7L/B70ww8vCt8dQD9eEF4dQLwtwmsD8MtzwqYAzlOmcEEA/n9G
+ACer9kk3BpAvev5/RnA/bNW+JsA6lHC0wHobxReGsT5fkI4MYj90oSNQR0v
NVV4cxB+fUw4P4j+JfN7N4h5tCrM/wIrfgsR
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg9MlWUUxm+mtpA0jRItEZMMCY20iFXYa5qoYwtYM1p3tcic2RZXN5oi
K3UwiUpQiYKQ+CsXhOuFC/cP9w8f926kG7a5sazGJtQyF8w1Jo1cc933+TqP
826M/fad777nPOc5572rCgrz3p9jsVguRv/0f/lEZpKt8VPrNpu0Q2XGXGlZ
Sn5TrbVWhh8RNgrURHGc42E+/0BFHxfFCatC9XeyddFDjD+g8rwJZYuFx4vU
yrLJy4v4/iHlyJq49YBwYomOnxfL7/tURdP5637htKPqSosteB+//5h+bpsn
nFOK8+/leWXqcJwj6x5h23EVrXdsDs//TEXT+3CucFWF0v/mM58v9PdV8jzn
l2oq15vAfFSlqgzP2GOE91apssncDOafdhL6sb7Zk+rSyEg26zdOqf1RwR8U
Lj+t87MuYT3VKpr+BPWM/0rzu9R/HDzB/thr8Jz9tH2N58uEM77B9z/K+mvR
j8eEL9QivwTqUQe9Vwrnf6v7v34V9anXejQ8Lny9XrXaMmOSqNcZ+OMJ4YMN
0H8N9ftO6/NKsvDcRvhvLfVsRD+eEh5p1Hq9kUp9m+DHdcLVTYh/mno36fpy
04Stzcj3GerfDH02CCe1oF6+X94CPXjeVAv6xXxzWtWe6If19bXCr9Qnvk37
u5h6lrTB39R/vE3rVcF523oW8WT7WfiJ/Yttx7wsZ3/b9XMv+zfaDr15XoYd
7ycK19vxPvOzdOD91cK7O3A+67nQofXIfFI4tRP6sj9VnfB3ivDNTsw79co/
h/lbLxw4B3+wH4ldWt8R9qO0S22fKK7eSD91od/PCWd3Y/6ep7+60b8M4TgH
5vEF+s2B+X5JeMyhNkY/m+i/81qvmZeFW8+j/5vpRyfq2SKc7oQfXqU/nTrf
uCzhOif8vZ1+dcLPO4VvO7FPyGk96Mc24YIe+InnVfdgPpnfcA/6wXpme1Av
60/pxf6jXtZe9JP6nuiFXpwXoxf1sH/TvVofF+czyaXqamuX0R+7XNCD+6Dc
pfWdpJ8HXJg37p8pF/zF+yGhD/3jfZBj8kLhY+AG7su+PuhLvtaHerhf4/sx
jwuEd/ZDD8aX9CNf7ltHP/S9cx/1Y/9wvy5xIx/u161upf9xHj92o7+sz+6G
XziPv7i1XrWcx1jP3fO/yQM/cx5tHswn92ezB/Vyf4564E/O43wv/MB5zPBi
/3Ee93nhL+7Lei/8z37/4EW/ud8sPq1XMv2xwYf55Pzt9mm9rj0rXOPT8/x9
OveDD/6m/275tF5HOH+pA7iP6Ne3B+6exyqTXxQOD6A/fP/mAPYH532NH+cx
v3w/+sN9UuHH/cb9E/DDf9zXN/zQl3omBvD7gfswL4D6VnAfBfR5q9lfdwD1
8b69HoD/eF8vD2K/0G/ZQfSD/vwkCD3v/J4Iwn/8/fFrEP6xcJ+F0P9/J//n
bSH07x/hgyHoMSPcGYIe08JjIfjthvDCQfjlT2E1iH7/IXxgEP36Tbh1EPpd
Ff5xEPtlTHiugf79JLzCwH0wKpxuYH9cFn7NgN6XhPca0Pui8FED8zcsXGfg
PgsLuwzcFyHhEQP98Qv/bmDePMK3DcyLS3jpEPzuFE4bQj+7hHcMId4uXGDG
twkfNuObhKuH0P8zwt1D+H1UJzxsxtcIXzXjTwnPmvGVwovDiP9cOCWM+OPC
W8KILxW2mvFHhIvM+BLhE2Hkf0i43YwvEjbCqHe/8M9m/EfC02HouU94QQTx
e4STItD/PeHMCOLfEd4VQb/eEi404/OFyyPo7+tR/g8fddqD
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdln9M1GUcx5nT1tBZudvUmoiTHJEWRRn9OHtUEjVKoEJcNxuEhvUH5EYz
ZKVOFrESLNQgIn7K8es87gfcHQf3vbuluF01m9PZ2AS3mA1WjUkj16x73tfn
7YgN2Gvf7/M8n1/v9/NdU1iSu29BXFzcxeiv/i8/h022C+nTGzbHaIf6PhLJ
eo68R62unLr0vLBRqN43x+828/kBZbJlTmwSViXKk1D5nuL7B5WlJjS7WXi8
TEX/HtnK9R+qP5Mt970knFihpnM8Tdu438dqotz02Hbh1KPqalvp8A7ufwzx
viycfRzxZPG8ShUfXfCqcOknKteTsCib53+qGurr63OEa6tx3muM5zP1SDSB
14XtnyP/PMZXo/Od2i1cXKv3r9zDeE/q/Ve+KTx3Uu9vszD+L1S0/pl7hau+
VOHZ5LG3mE8d4i8QXnEK8b/N/E4h/iJh62nEv5/5nkH87winf4X4DzD/el3v
BPJoPfq9j/VoQL8KhfO/xv6ML7ER8TK/m414P5/1+kZF25/8hvChJp3vBdZb
fYt5YX8WNqv2UnM8+1ncrMzRAmQKR5p1/80ZrG+Lzucq562uBfXifM61oF6c
Z0sr6rWR9W9FfGnCSW36vLVPsR9tan/052nh6TbMJ9dnt6Nezwi72nHes+xX
B+rF8ys69Ps51NN4h9ZH2QvCGWe1HmoYv/Us8qe+lnSqtLQ054vsb6eKbudh
/pc7oQ/qLd2K51uEG606X+td/XWhHqxnURf6Rz2Odun+WqjH9d36/DT2o7Zb
vx9Hfd7qRn/J+T3QA/Xq70H/dnJ+eqEf8vFe5M/+3+xFf6jnrD7kQ7b36fne
8oqwyYZ5Jx+y6ffTOV9jNtSTrM5h3nYJt5/T/lFAXmhHvckb7SpqL7fJxXbs
Tz9psGOeyRE75onn3Yk9Z/yp/agnnxf2z9+/rl/P3yT3O/8/nuuH/sgpDu2H
EbLFgXqRTzjQb7LhQP7kGQf2YzxJTqxnPfOcWM/4q5x6fTX75XOi3+zndOw5
+5/gUtsnyus4H9ku+CHn6ZgL8XPeXC7Ug/M46UK9yCvc0Dvnd6cb88/5rnDr
80xkmxt6ox7G3ciXelk2AH2SM8CXqK8PBuCfZOsA5pd6/HkA+ZKXDEL/5E2D
8+/L0kHUk9yK5wXky7H15Hs88BdyugfzQL9414N4yY0e6JH8gwf6uHt/e1Fv
8pNe1INc5NX1/YN82ot68vxRL/RMvu2FHsnrffAPrt/rm/9+rQ/zQA75cB79
8pYP9aafrhuC3vi9kj+E7wf6b/UQ7gP6tX8I9aWf/zaE+5Z+n+hH/54QzvVj
flPpR37o43HhgdjzDfQnP75vHhV+cBjzk0K/GobfJAt/NIzz1tG/hnH/Pix8
YxjxraWfjWAe1ghvG4F/rKa/xXiVcPcI6v0Q/W4E/VgpvDSA75Hl9L8A5sck
fDCA+2EZ/TCA/e4XvhLA/C2lPxoq+vfIYuFVBvR1L/3SwP25SHiXgfosoH8a
mId/pv7jowb88m/hBgPn/SXsxH6Ts8IRA/M8I/yLgfv5d+E7sXimhZcH8b34
q3BqEOdNCu8IYv5uCBcGsf914cNB3E9jwnVBzOc14b4g+nlF+HwQev9J+HoQ
9f1ReC6I+kSEHwjhvrsonBJCvt8Jbw0hv5CwJYTzA8JlIejBL3wiBP17hDtD
2k/L3cJG7DyH8LUQ9G8TngnBz3qEF4ehP6twUhj5tQubw3i/RTgvDL9uEi4J
Y/8G4aow5udMlP8FIYLx/g==
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxFlg1M1GUcx69GbmHT2dg0N4kmc+isKFqxtrPHl0SMUmgpbZclmflScVIU
ASkQpLESLLSOiHiVA+Q87gXujrvjf3+W0iI3NxfL2YJarAZz5bTMNeue7+33
9Ta4ffbwf35v39/3z31FxQWv3G6xWL6J/+hv+dTN5me/OHf/2gTlqrFrGbYd
5OeVNXmy8wVho0htmi5PIVv2qji6bMKqWAVS6/aTjRJ1bzwAeapUHbAmbydb
3lWunOlyclqlWmlrMG/dd0jHX854mdWq2eFw3MqnRsd/gPlurdXxzpOn6lRB
PCHWZz+svpuYyHuJ8T/E/TuFG+tVl92aXMR8PlLxdK6R3R+reDv+eJn5NeB8
l/CeRqW/djPfY+jXq8LXjyHfPcz/E+SzV/jIp/p++z7W04R69wsvOY7+vMb6
jiP+68LOEyqOGcWs9zPMh5z9udod//B5i0PzDOONO/R9pTxvbNb9u+MN4cIv
dD1NvC+tRed3zwHh31qglxL260vk85ZwWatmZyn79xX6/45wUpuayw+0lrGf
beqvDNvCcuGJNuilgv1t13q9VCnc1K60ng+y3+2Y/yFhW4eqSHGdrWL/O/R9
N6qF0zt1/NT3OY9O5F8rPJc4r+N8utB/sq8L9X3AeXUjn8PCld2YJ3mqW89/
grzhJPIjO0/q+hvId/UgPtneg3kx3gWctzKfbCeY+bc48fesz9KL+mqEd/VC
X+zPeK/OJ4f9W92nsrKyvO9RH32YP/t/tQ/7z3kV9qu4nCOcZ7gfeuK8007h
fuqh9hTm9Sb1hPOz1FfeAPbTTn0N4HnqM8WFflG/ZS7d/wD1fckFvXEf1Wno
mfvcdRr50R+S3NhH+tGjbhUPN11Ifbqxv88JN7sRL596deP+rcI3E+fkzEH4
FbloEPeTmwYxD953ZlDXX/8s9T0IPTD+Kg/6xXObR8V/VxUIH/XoeVh5n+FB
fYx3xaPjrSOne+Ff5G1e7d+TW7gfXuiZHML5dvKcF/tLTvWhnme4Pz7EJ9f4
oCeyzwf9PC0849P92Ule4sf+5glv9qPf5Eo//Jbs8iP+U9w/P95P5LuH4Ceb
uY9D8Evy20Pw/1zuJ9hOvpg438R9HcY+kNcMw29zuL/D6Be5Yxjz28h9Htb7
lkWeF0C/n+R+B1D/BuF9AdxHbgnA/9cLnwtoPVjIliD2Z53ww0Hoay39IIh+
KeETQfjdE/SHIPRHvhFEvWvoFyH4IXlHSJ/PkhtDqI/PmyHsP/lqCPtAXjEC
fTKfwhHcT64fgX6Yf3gEfkC+DF7IetPC0Au5IAx/I9eGMU/GHwrDL630pzD0
+Ljw0gjiPUa/ikC/jwgfjGD+D9G/IvCzB4V/juD+1fSzKOpdKbwxiv/PVtDf
ouj3cuG+KN6PafS7KOa5THjBKPJbSv8bRf2LhUsSnEI/TPAi4e9Hcd8C+qOB
98t84WUG5nkn/dKA380T3pI4T6J/GpjfbcLVBvzmv1nxUwP79a+w18B+/CM8
YWDefwv/aqA/V4Vv4tzxp/DiGPz2snBmTOmvOeHcGPr/u3BRDPsxI1wRw7x/
EW6K4X06JTwQg35/FD4TQ78uCv8UQ/8nha8nzi8ILzJ1PlXnhVeZqP+c8HoT
8b8VtpnIb1y41ITffS181IS+TOEeE/qLChsm9Dki/IOJ/ALCVxLx/MLzx3C/
Rzh9DH7gEraO4b5+4W1j0KNTuBjn1m7hI4nn2+P8PxiyBss=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVlg1M1HUYx29O2zIWy9GiWqSLFblsLDdGW9RPJRGjQlaIdVkSWtoLJ4Uh
kAJBIikvCughGXAgL8J5cMdxd9zB//63pW3U1mbRi5viprPBqrF05lp1vy97
vpu3ifvs/r/n9zzf5/s8/1uRX5izfZHFYvkm+k//Lx9nxkxpzdyqNQuUqXan
LZ3+nLxFrY5+aoWNfHUjydpwkN/vVEunHX/WCatCfX7zIT5fpKYdttBh4UvF
Khr+kQae34t4jcLLy1U0n1tNjLdf7Yh+jgonVyK/ZsavUt9OTWW1CmdX475j
vK8G+duFbQdUg3m9r433H9ScdEK4sU6VxTkzjjOfQ6inRdh1WEWuJ1mPML8G
MOt5txH5sP7kJlUzuymVet1sUm12+/3U1ziirNEEqoRrj+rzU/tZT7Oa2+Q7
WS4c3wI99rK+FjVTGvfkHuG+VvSjiPUeQ3424dTjasNMafNu1m/HfXz+nF3l
+BKWfEw92tTj1oa1xcJ5J1T0bwXvW94OvT8RvtaO/pVQry9Rf6lwyUldb3EZ
9ftK98fN+hZ3KF9Czeyn1LMD/aEeUx2ov4L6dkKfSuHmTviDet7s1P6KrRa2
dqG/9LvRpfMtZT8SHVpP5wH2w6Gij8/Q/3MOxKPfs7t1/WlfCHu6kR/7H98D
f9P/5T2ot57960G+9E/6KfiB89B3Svcrjn6L6UW/OQ+2XtTDeTjfi37Tr6l9
Ws/3OB/tfdCf82HpRz/p94J+ff4C+Vy/ejjaQMZ7YkDfd5bz2TiA+lnPXwOo
j/rknUb/qGfwtPa//TP6ZxB6sp/Vg8iHfrg2CD/TT1lD0Jd+dA1BP/o5zgk9
PqTfnDr/73cJX3BqvyTspP/OQJ93hLvPaL+b2+lHF+a1QDjFBb/k058u+OMt
4TYX5v9N+tWFeG8I/+uCXlb6dxjz85pw/jDy30I/D6Mfm4W/Hsb9ufT3MPbT
q8IrR1Afn7eOaL2u5gnXj6A/vM8YQTzmMz+C+7dyHtzoD+vLdSOfbZwPN/bp
28IBt+6XjfrNuVEv9U3wqG5b2lLqn+25vT9VHszz+5wnD/rDfl71YJ9wn8WP
Yl9xf20cRbyPOG+jiEe/OEcRj/vq0ijicZ8u8yIe91O6F/Hoxz1exNvH+fQi
Hv37ixf1cv/EjGGeub+eHcM8MZ5tDP2gv7vGMO/M9/wY9KS/7/Ahnw843z7s
A+q3y4d9s4Pz7sM+pV+/893uT4sf/Xtd+Ck/6qdfCvyYt1eEW/3wczb3gx9+
e1H4lh9+yuS+CGA+nxfeGsD7eC33RwDnlbAZwPtjDfdJAH5bJ/zouO6Xj/Hy
xrFPMoTrxrHfeH9wHPdvFP59HL8/NnD/BKEv4+UEkQ/vqw6iP2RvEPqlcz8F
oS/5gRD0Z7ysEPywXnhfCM+TXSGdj4P5Xw7pfbKN+cVNIF/Ws34C58klE9CD
9Q1M4P4XuO8m0L8s4bsn8T5nv9Qk4r8kXDSJevl99yTuY/wfJ6EP81tsYF+w
3ocM6Mn+phj4vfGc8MsG3q/PcH/i/NmnhSsN9DuF+9TA/auF3QbmKZn71YBf
VglfWeCV3LcL/JjwfWGcT+T+DSP+CuHMMO5P4D4O4/fRg8JlYegTz/0cxj64
V3gorKJ/K5ZxX4fRz1jhi2HoH8P9Hcb75U7he0y875Zwn5vQZ5HwOhN+/29W
9ruJ/fOPcLGJffa3cL2p87HcEO5diDcvbJjwyx/CP5vYT3PC8/g+9jfhuyLQ
44pwYkTv87rLwmkR+OGicG4E+v8qXBiBfj8J10bgzx+i/D81thDx
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVln9I3GUcx49Y/WFRFAdZkBmNsFEhCcN/Lp5qZCtjarW5ulbZttxWebNc
m8rSpWxJm7rd3M45p975W8/75Xl33p3f7/diLbAgiKQQ0qAxUCJGxtgfI5/3
8XmDgo4Xz/P9PM/n/fl83s+eqKqp2HeXzWb7Yf1X/ys//pLl+o7VZ1/M0naV
s+D9p5O8W9n9JR+eEzaq1OOtKz+7uX5APe1sf6lLWNWo5Xq7/wL316rV8lie
R3ipTlXE8lq7+f0xnHdJOL9RHXbk7LrMeF+pBa8r1Stc2Ix4fYx/Qq3/beoX
LmtRmbWCxQGe16oa7P7vud91Uu+3MZ7tG+XIWXiyR7ijTcfv5fn536puj+eR
K8KB0+rV5Xo346l2zXaeV92BdS/v24nvB4VvdSL+EO9/FuePCJ86p9qttZFR
5uPWej43Lpx7XrWulMcmmN956O8XHulSP87Pz08x3wtaD2dQuPiiWpd/JcT8
PUrXPyJ8zaN8LkdOlHp06/t7ZoQrL+E+cerTo8+3EsI3elC/JPW6jPNSwkd7
Uf856ncF9TSFN/WpoqKisEU9+6Dvd8LzfbpfXOTCfuTP/e5+xDOodz/ySQs7
B1B/3s8YwDrvv9mLesRYDy/yoR6rXtSHepX5UN+wcMSH/qfeuYM6/0MB4cZB
1IP1WRrU92li/bYNoX8nWc8h5Eu+bxj5kl3D+H5M+JdhXc/b7K/iEbVenjr2
Y88I6sF+to2q/es/7P+9o4jHeb2WZc7rM2NgzmvHGOLz+3/HEI/zUzkO/Thv
yXE9zw6enz8BvTlPLROoD+f5xoT+foFcOgl9OW+BSfQv87P7Ed/HfvMjHudv
0Y/5Iasp1Id6+aZQz2H2YwD+Q94aQP04r9UB+Be5OwB9OL/zAd3vd7M+d8Ct
5MIg6kWuCkI/zrs7CP8iXw2ivzn/t4LoD/KW0EZ/cIZwP/KZEPRm/xgh7Rel
5JshnE/eHN4Yf2cYevC+p8LQl/kmsO6gXqvZ76l3XgT+x3qVRZAf63sios+/
zv6IRBCf/XM9Aj9gv+VOIx/252vTej4LLnLessz3yZ9lvl9L09DzrPBDUfgB
38NtUd3fa6eFj0Tx/rVxPqPar4pOCv8ehf9/zXmdQbwW4RdmsJ/rrhnk1yw8
MAM/Pc55xnpTo/A9MV3f4nrOdwzz/KXwwRj8uo7zHkM9Phf+Kabf82UX5z+O
+J8JPx+Hvp/QD+LwuwPCXXHc/2P6Qxz9tlf4dhznVdEvElh/X3hPAu/He/SP
BPrhHWErAb0q6ScJ9M/bwk/NQv8K+sss4pUJt81ivt6g38zCf14X/nsW9+d6
flL9V+B8YIdwRRLzwngtSbynPC+ahP+8RX9K6vu27RR+NAU/4f1LU7q/S5jf
8RT6z0n/SsEf9gj/mUL/Uy97GvX5QPiVNOpH/Y6m8R68KzyWRv15/mIa8ajf
/XPI/0363xz8m/nWzkF/6uHD+hr51znE4/5NBt6rcuHHjI312Zplnrcjy9Sv
2oC/837NBvKjnt0G+nuXcNjQeth2018N9Cv1/ctAP1CPOwb0p94Pm/A36ldo
on7Uf7uJ/39Q/yoT+VH/BhP1Yn+7TczjR8KTJurPebhqor/3Cf9hIt/99G8T
968WftDS+pRz3rZY8JODwi9b+P4Q/d2Cf30qXGchP87zGQv51AgPW9DvMP3f
gv/XCv+GeL30i5sW6v+F8L0Z7D/C9yGj/ddL/3FkEP8Y34sM3kv6VU0G70cD
348M3j+9/39GwwFx
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxVVn1o1GUcP8L6Y0lRHKRBa9GIFRVHgeyfxdMLLUPI7Q8zGIFLa2q2czRZ
m+VmDufS7aa32Z1T9/5y2273/rZ7+f1+V3PGFQSSFEIuSARHhLgQ/5Du+Yzv
R3awjQ+/5/c8z/fzdnuuvrF2z0M2m+1y8Uf/lc+znbdqFlZeeXMNbVX/VdT1
pog/Uu8tt7qTgo16ZfdX70rw+V6lf8cFq0aVKO3cH+X6JtVrrU6FBV9vVsXj
EkG+/5WqKrk6Oi+47LAqQucc9zuivB7P5hnBjg6sn+L+R/F8QvD2Y8pfvdw6
yvM69XmVY4KdxzHPOM8/oe97i++7ulXx+CruX3YSfEwLDpxS+dWKaz7er1ff
5/lZwQ0uzM/7O/rUcqvd7xd8t0/P9y/nNU5rfirIR9cZ8BviPG49n4f8bepX
bXb/pQjn68d+5HtqAHxQD+dZzE+9Kr9XB6tKPqSeNg/4pt5LHq1nO/3g8mL+
tOCd58BfhvwMAmcF3xzE+hz5Oq9qi4QYglsuqLpeq9kkfxc1n3WW4A1DuG+e
fA6pnwuFbT8ILgxpfpaJHcPw14+C3cPgf5F8D0OfS4LrRlTR778SGyPwy5Lg
8lE9j/0y9RjF/sQro3q+x3+iPmOYn+dFgO28/6ZxPCcfh4Ht5PP6OPiiPu9M
YP8Hek6oMWdVN/2xcVLz+TD95JwEP/TblUnsR1w5tX794BTyQ2ybVp8WP/Tj
7mnsF6AfpjVfNTz/ZR/8Qn+6fGqlJnGB/rzjgz70584Z9XrxExOcngEf9GfZ
rPabjX48NrvejzdnkU/6cdscntN/gTmt3z36z+4HXw/85tf3K6W/rvnRP9RH
zeu8Z+insXn1YtGgfL4hgOd8f0sAfqB/GwLrz/MGkF/qXcD6Ct7vfkDzfYP6
O4LIN+erD+rz3+L87iD6hv5YDGJ+8nc3iPnpl5dC8DP5rwuhH6hXTwh5o55G
CPNS/9sh9Af9UR7GfvTTjrDWq524K4w8E6fC8BPxSlj3VTVxaQR6EG+PgA/2
59EI/EkciYBP9v+NCPpvkvmKgl/2+/tR6DHEvEXhn0HB/ij87WH+oujnfsFP
xpC/08xjDHz3CD4Ugx7fMZ8x+OmE4D9i8Pdx5jUOPjoFvxHX/XuV2BmHn7h+
JA4+ud+VOPzA8x5JoD9OMd8J5I3325fAPC7mPQG9OM8vCczvZv6T0GNA8GtJ
zE+8O4n5uX4gCb9wv6Wk5rukT/C9JPTuZV+kMA/v+3EKfuc8rhTuy3mtFPJG
Pu6sYfL1wgLWf8t+WcB+HYK7F+DXI+ybBcz7teB/sH5zG/snDT1bBNemod8h
9lEa/H8pOJaGXw+yn9Lgt1Hw0xnoc4B9lUE/7hP8TQbfRw3sr7XnewT/lQH/
n7DPsuB7l+B3s1jP5y1ZnM/3fVnk+zP2XRb/z+wV/FgO8+9n/+XQH58LbsrB
n1+wD3Pwt1Pwbznw08R+NKAv+XnGwPcF+dtiaL1eJb8fGJivlf1pIJ/Uo8PQ
ehWol9dAPqhn2EC+qXfBQL7oh78N+I9+uW+Ab/rpKRPfh/Sbw0R+ugVvNcH3
SfaxCb6ZrzYT/mK+3Cb4Zh7mTPz/wrwsmuCbefrT1HytnmV/m+CbffSEpb8v
w+fY5xb4Pi/4bQt5vMh+t8AP+67Zgh+4vseCHl7BkxbyzvMNC/yfEfy7Bb05
3+21/ZjfR/PIA/kqz4NP8luVRz9Tjx143tkuuDEPP1Lfrjzuo/H/hZA07w==

      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdlltoXFUYhQeJPsSiKAGrYIwYJJYqxUDJS8r2glop2OTBRhgEQw2pPmQs
RHoJakuDMdhmqtPWmaZpkplkJpNkMvf75ZwzNU3ttLVaGlujbYqN0QQRaSX0
oXj2CnuVsVDCxzln77X/f/1rz9OtHc3v32exWM6Y/+Vf9e+jxsptxeXnX1ql
zaIq8Pr8KfI7Ilnd/eG0Yq1VmI/vnObzHcJja+w9o1h0CJfT+fhZvr9T9Bm3
fSXF1ztF91JTw3l+v1ucK5VKFxTXdMn937vI9T4VlbPuv39QvGGfaDYFXeL6
+7HfZcVbD4j6+vrILPfrFnvNBa8otn0uirfr5q5y/y/k+rY5xfZeeZ7KX6nn
S7HclBy4pjh4EPrnqa8P+m8obrdD/2/Ue1hYzQLcVLxyGPX6nfq/kutX/6G4
52vo/5Pnccjz3r+keO0RYfZrdpHnOwJ9C4p9R8v3tx0T5uvPUF/DNzg/z2Nx
in/rrH2/KJ5xiuesfS//zHq4oP8nxS3H5Xpu1rumX+rZxn4s9kMv+xU8IeuV
ZH93DcBP51i/k9BHv1QMwn8zrOcg9qP/SoPy+6VvWd8h+IF+dAxhPfpxZUie
x/hOsXUY9aEftWEh/9CPtW7Uk3p73KgP9S67ZX/qud5Wj5jfUxUgRz3l51k7
gu/JXSPQT74+Ikz7NVLPq6M4D9k3Cv3kNV7MA9nmFW+YAqjvklfOWx25wQe9
5H6f1PsC2TIG/5G3j6Ee5Jkx8VT30kXut94v581Jtvvl8ybyLT/ygedrGcf7
5Ow49JFrJpAPrN+BCcwzeXFC6vmM/dwyCf/TH8FJ6CdXBaS/rfTDrgDmjf6Z
C2A/+kdMQT/ZM4X68v2KoKyvg+tvDKJf1NcehF95Hlew3C+l1ffpp7tB9P97
+jeE+nBeWkMyT7Zwnhwh9IPzNh3CPDHfVkLIL+bbujDyjvlmDcOf/P5QGH75
kf4Py/nupL5/wsgHnqc2gjzg+d+OoH68H3oiyEtdcToCPTnOSwT9SimujiI/
45yfKOYtrHh/FOed4jxF0Z8JxQtR9Gec8xXDvJDfjMn6P0zuiqH/fsWBGPJs
jPMXw/rkR+PQ4+M8xtFfr+KP46gf2RfHeUYVX41jvRHOawL56FG8KYHnbs5v
Av4YVjycgP+HOM8J+OWk4geSqP8A5zsJv59Q/EES+dvPeU/CXy7F55PIJyfn
P4XzHlP8Ygr1JW9PSX05vn80BX8fZz6kyve/k0K+UO/6NPrJ87ybxn3J89rT
2J/1MdLwD+t5Kw3/sR/PZlB/9rMlg/6w370Z3J+TzJsM/EE//ZVBP0LMnyzy
KKK4OYv8ijKPstBLv8az0JtkPmWhN634iRz0ZplXOejNK/4kJ9ra2hYKzK8c
5pnzcyMHv/L3WFUe9WU+vZZHfe/lWx79Zj7685g35tNcvvz310MF5Pm9+7eA
5+SdBeQd2VMoz7PL/3teoZV//6Qm8+c0eaOGeSO/peE+4n3brsl67yHv01Bv
sgvr1zGfIhr2J5c05A/z9KaG3wv8/q6G/GOePabDH8yzDTrqz/puXn1uMI91
fM9+7dWxPvvr0KGH+Tapw2/0y7QOf9Bf13T4L8j8xv4N9OsjBuaf/l5nwI+c
h1cM9I/5YQU3cb46DfiDzw8ZyEPmkddAnnA9zYB/OH9XDOT/IO8DrBfgfD9Y
xPmYJ7VF7M+8aCziPnbwvihiP7vijiLqe5D3RxH97zX5Pwz1ShA=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[{{1182.5242718458123`, 980600.}, {1200., 980599.64}, {1250., 
      980598.58}, {1300., 980598.14}, {1350., 980598.92}, {1400., 980599.7}, {
      1419.2307692330653`, 980600.}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQPXGZZvYpn/kOQCbDhze6jiCagWWBQ7XIuuNvYPyM
BQ7yra8DX8L4ZxY4iKxzf/gUxjdY6LBDrjX7EYw/ZaED1/XFH+7B+D8WOgCV
V92G8WMWge27AeMfWOQQBDTgCoyvsthhSYEt10UYv2Oxg2ZMvxOc/2Yx2P5L
MH7AElT9W5Y49B/6qnENxpdY6nD2zJkz12H8mqUg9xXchPEfLHWYNXOmJNx9
LsscgNJ778D4K5Y5pAEB3D88yx2+acTwP4DxC5Y7AINnx0MY/8pykPsSH8P4
FivA/oGH15wVDsbGxpufwfgMK8HqX8D4KSvB5r+C8U+sBJv/GsbXWQV2z1sY
f8IqB4+HVSLvgXzFnQY8h4+tgscnALkRpN4=
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/eiwUobF9w0OQCbDhze6jiCa4d8Gh0JbruvvYXyD
jQ7XFxfYvoHxkzY69B/6uuIFjD9lo8M3jRj+pzD+sY0OMf2HSh/C+D82Ohz+
qnHnLoyvtckBaLzybRg/ZpODyDr3h3dg/L5NDrNmzpx5D8Y/sAnknvAHMP6n
TWD7HsH4Kpsdzp45c+YxjB+22WFJgW0X3D0dYHmf5zD+LrA810sY/w1E/ysY
X24LWD/cvwFbwPrfAfnpm18s8m7YAg8vACwfeEA=
      "]], LineBox[CompressedData["
1:eJxV009oE0EUBvBF9BJBEQKiYFUUjaIiBsRL4KlgFQvaHMRDEAwqgodWQZEU
RMGA9GA9VDEVCtJAS6GlEAjZJJvdnUWtGKv1T2M1UlNpqaRWESviQdx54Xtg
IGx+zGbmvW9mNsbbomeXGIZx1P/qZ/b41ivxpznyfxrf53fu109jLEfB4eba
N9gw9fj1BXiPSen2SOArfMakaK4pWYfvmRTrUotf4FFTz3d6Dv5j0vpkfXwW
3pGnSl97ZAY+ladwOJz5DN/Jkz9daBpWeaolgsOf4J95StZb903BWwr0vFwu
f4RPFijgL1CFOws035pr+gAXC3QxEqhMwgsF8tn3Dt5QJD+ORAWOFumc/5mA
bxbJWwzF3sLZxvgbeK7I+b2G11q6n4FXcIvFeY/D1yzd3y7xiKXz7nwJT1uc
7ws4WOL+xIdKvJ/iqyXqSaVSY/BgiTr8BcXVkt6/ZeIVNvcrJlvn2SLrX7J1
Ppuk/rTN9Uh/E7ae/4nksdTRefdKfuscrlfy3uvQtljXAdmPY46ud43s33mH
8xDfcLie93CPQ/7xuyDzZxw+j5J/2aHDtUS35Dnj/J/nX4d+hWIrZXy1y/sv
3u1yfdLvEZfPr4zHXb3/Vcmrw9X7P/sM7nZ1ffVReKjhR/DjxvsKnnL5PNjw
78Z6RXiV4nxNeLvi+5KFDyrOOwPHFOcxAl9WnNcQfJvnax6E+xXft37YUXyf
BuBJxfdV3v+h+LzL+8s9zjcNb/Y4z4dwxNP/t3rhEx7P/wBu87jf+/Atj+/n
Xd//ABJdppU=
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[{{4419.444444437258, 980600.}, {4450., 980599.89}, {4500., 
      980599.74}, {4550., 980599.62}, {4600., 980599.52}, {4650., 
      980599.45}, {4700., 980599.41}, {4750., 980599.39}, {4800., 980599.4}, {
      4850., 980599.43}, {4900., 980599.49}, {4950., 980599.57}, {5000., 
      980599.67}, {5050., 980599.79}, {5100., 980599.93}, {5123.333333330746, 
      980600.}}], LineBox[CompressedData["
1:eJw90k8oBHEUB/DJn8sqpbbkQInkT0opt62HhFKyB6c5KZPbSrmsk8OWHOzF
Zffgslsku2TJprb5zW9EMoS0i+RfrcT6kyInmXnbd6am33z6/ea9N+9N/VjA
P16iKEqbfTtrU/Csr7pUJ/tR+Sy0dzurUqlTixqWHzDpVBhJL73DUzp5crHJ
NziuU6d9FeCsTpqmPb3AZYLPP8O1gsLyeyUPdwkyv5tvHuFhQf50Xfk9PCEo
XRd6vYVnBdnhMu5+VJDPk2twneJ4qnve4nihGzjP52PX8J+gh6A3eQlXG+ws
3GFQNBKJXMCDBiX7H4Ln8JhBx5Y1dArPGDRgBziBF3nfOoITxfcP4X2OX3MA
3xXz78G/BvdXwlXScUqHWyV/fwbulfTTrIZ3YVVy/3bgaenMt2cbXpAUn/TN
b8LLkutdhwXvexLwleT5rcJfkvu7BleYzvy1JNxocr4N2GdyvW6+UZP/vy04
YJLXbpBb35zJ83bq/wd/L/Ch
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw90j9IAlEcB/AjarEpEKIhIWq4giAIouXgFw0WCKFDLU5C4qYNLQpFgxAN
ubjo0JJQiy4tbvf+QC3X0h/NssxKKzSIwAiC7L0nv3dwvPvAu/v9ft93Y6Fo
YL3PMAxT3HKN/Ha721s2iEfjsz29IFcjZ0MwxTof6JINyZZ/voXuJ5CLWXvv
6FECbX/R84aeI2C5yodN9AqBbCYz0kBHCASKnuQzeocA75jVOjpLYKkeTz+h
T9T3xvV+h8C54/ge0Q0ColzsHv1H4NsMpm7RwxTEOMdl9AyFSTHgFXqZQjgc
bl6gQ1TVv0QnKCTcBa/en6Zyftc1Ok9lP472KZV5HJTQNar60/V/1H7fDXqI
way4KugppvLS/S8yVe8OHWQyv4EqepOp89Pz7/f8gD7qvV9DEybnc+v8Kkzm
Y+r8vxiIdi2d/yCHDcu1pvOf4FDw1uMvaIurefX5rnKZ15k+/yhX/9Mreper
evL/+QflwuVo
      "]]}, 
    {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
     LineBox[{{8318.978102190526, 980600.}, {8350., 980599.15}, {8400., 
      980597.77}, {8450., 980596.39}, {8500., 980594.98}, {8550., 980594.2}, {
      8600., 980595.12}, {8650., 980596.03}, {8700., 980596.95}, {8750., 
      980597.86}, {8800., 980598.77}, {8850., 980599.69}, {8866.847826089226, 
      980600.}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{786., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6897563887750354`*^9, 3.689756449665071*^9, 3.6897582610699196`*^9, 
   3.689766954480882*^9, 3.6897670053324084`*^9, 3.6897751933186035`*^9, 
   3.689777597871731*^9, 3.68977917443981*^9, 3.689862059998275*^9, 
   3.689862211286889*^9, 3.6898627764710503`*^9, 3.6898631174798193`*^9, 
   3.689863193509366*^9, 3.6898712745055513`*^9, 3.6899641338481593`*^9, 
   3.6900157519175625`*^9, 3.690015816337257*^9, 3.6900223441777835`*^9, 
   3.6900224535824347`*^9, 3.6900268866390233`*^9, 3.6900279199733067`*^9, {
   3.6900347061928215`*^9, 3.6900347154102683`*^9}, 3.690746395589407*^9, 
   3.6907464472926407`*^9, {3.6907477170092745`*^9, 3.6907477374798307`*^9}, 
   3.6908273323753276`*^9, 3.6908304661142316`*^9, 3.690830797819889*^9, 
   3.693601167599778*^9, 3.6936017496850014`*^9, 3.693602673321005*^9, 
   3.693602976282175*^9, 3.693773068486101*^9, {3.6937734282675753`*^9, 
   3.6937734368799596`*^9}, {3.693773501911315*^9, 3.6937735173517513`*^9}, 
   3.6937735592153625`*^9, 3.6937735911392264`*^9, 3.6973112084210215`*^9, 
   3.6973112572352867`*^9, 3.6973115883634157`*^9, {3.759169573345361*^9, 
   3.7591696337975955`*^9}, {3.7591712136690483`*^9, 3.7591712465719357`*^9}, 
   3.759349591549721*^9, 3.7594102397247868`*^9, 3.75941100466147*^9, 
   3.759419036774638*^9}]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", 
   RowBox[{"Plotting", " ", "the", " ", "experimental", " ", "data"}], " ", 
   "*)"}],
  FontFamily->"DejaVu Serif"]], "Input",
 CellChangeTimes->{{3.6897567537802124`*^9, 3.6897567636844306`*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.6897578179773455`*^9, 3.689757817980341*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P2", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.000000", ",", "980231.540"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.000000", ",", "980384.250"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1132.314140", ",", "980195.520"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1035.258643", ",", "980199.300"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2264.628281", ",", "980159.500"}], " ", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2264.628281", ",", "980424.340"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3396.942421", ",", "980122.720"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4852.774887", ",", "980076.040"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4852.774887", ",", "980477.260"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8087.958145", ",", "979953.000"}], " ", "}"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.689757585999817*^9, 3.6897575917459784`*^9}, {
   3.689757886597496*^9, 3.6897582658466754`*^9}, {3.690015782400165*^9, 
   3.690015782803361*^9}, {3.690034720006461*^9, 3.6900347204742064`*^9}, 
   3.6907464263075123`*^9, 3.6973096398888464`*^9, 3.6973106315501456`*^9, {
   3.6973115267541857`*^9, 3.697311526851513*^9}, {3.759169685981502*^9, 
   3.7591696883297825`*^9}, {3.759169776476486*^9, 3.759169956205823*^9}, {
   3.7591700100346127`*^9, 3.759170025304873*^9}, {3.7591704201994023`*^9, 
   3.759170562093877*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       GraphicsBox[
        {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
         CircleBox[{0, 0}]},
        ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{0., 980384.25}}, {{
      1132.31414, 980195.52}}, {{1035.258643, 980199.3}}, {{2264.628281, 
      980159.5}}, {{2264.628281, 980424.34}}, {{3396.942421, 980122.72}}, {{
      4852.774887, 980076.04}}, {{4852.774887, 980477.26}}, {{8087.958145, 
      979953.}}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.7591700265438137`*^9, {3.7591704215257387`*^9, 3.7591704688416705`*^9}, {
   3.759170513751878*^9, 3.7591705629705353`*^9}, 3.759171256086399*^9, 
   3.7593495916574345`*^9, 3.7594102398324986`*^9, 3.7594110047033844`*^9, 
   3.759419036831129*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Merging", " ", "the", " ", "two", " ", "former", " ", "plots"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6897583017759314`*^9, 3.689758322098931*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"P1", ",", "P2"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.6897582701715727`*^9, 3.689758280789153*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw91g9M1GUYB3B02Bw4WcZM3SRdVMTIUS5jLezVTKPRRNzEjNhgwDDdIItM
YZgkBSwE8xRBROD4L5zAHXfH/ePud+W/nS7LYjotqBQSSqfCkKV17/f2fW9j
7LPf3fs+7/M873O3PCM3OWt2UFDQef+f/M9XfMjQs/Nvv7QmoASx0v8KVX5f
vJhauXYu7c4QF32+xDnq+XbxTMn4ptm0yBUfx4ek/PcX378L/pcezsf7H9JB
e7DeFL2sEPvdp8U+4X973F06dr+o1Caj/lbrF4t3RvaG36aTDgj5b1TtVyKy
s7Nv/UHnfS338w2r/cvkeY036KpyMRWVWnlNxfONCBnS5w3RPRWI94qKr1LI
/F2mc6qEYcPIzEUV7yHsd4GePiQmNlnrz6r4v8X639Glh4Wf8R51Hp1ozosP
cdGLjsj8Xbap8x0RtTU1NRa6/agIN2xIN6nzViO+XjruGPLRrc5fI5/rO+lz
Nfh8m8pHrYw3opneelzWc6hB5acO+TpBj9WJAv8CtSpfJ1CPavrzeuT7sMrf
SexXRQc3oJ4VKp8Nsh+0MtrXgHx9pfLbiPi+pHWNcv+z+1S+G/H+Qjq1SeZr
8R6V/yaZb2c+HalHPLtUPfQi2RoxJ5ee0Mv+a9+h6tOMfsihTc3CGlEynqnq
1SLrV55OF7agf9NU/Vpwvm30ulbsn6Lq2Yp+2kzPa5P50SWp+rZhvffoK21Y
L0HVux33bz1d14741qr6d8j6fPEmndmB/L+h+qED/RFHx3TiPr6q+qMT+X6Z
ftCJ/VaofjmFfoumHadQjxdU/3ShPyLpA13I1zLVT12IZymd2I37s1j1VzfO
v5AONwj/2w0LVL8ZEG8Yfd2Aeoeq/jsdmG9082mcJ1j1Yw/qO4te1YP792iM
/QlvmqFre3A/pmgfnHKffhx4foeO7cXzCToDHhqjdYHnN+kzgecj9HQv9v+V
ju5DfNfo1D7EP0Qf7MP5fqLdfTj/D/S9PuTHR0cakb/z9BYj7u/3dKlR5nuF
RtuM6BcXPWHE/bTTESb0r4VOMmG+mehiE/qxhzaZhL+dJ7voWybZvzs66EX9
8r6MtNDv9iNfTXRhP85bTxv6MV+P08P96JdqeoEZ81JHrzMj3ir6MzPmQQXd
bpbx5ZfR18zo9xJ6ngXxFNOrLYiniM6zIL8FdJMF+dtNX7Gg/z+ln7AiP3l0
nFXep7s76Y+swjsZlbqdrrNivyz6khX7ZdBBA9gvjX5lQM7zsA/ozAE5f/am
0EcHcL7N9LkB9F8SPTMg17cm0jE25DOBTrPh++JtusqG+q6hNRvm32r6gQ3x
v04/b8fvk9forXZ8/62ky+0yP0GxtMOOfomh/7HjfkTRyxzIx3N0sgPzZTl9
wIF6R9BmB9ZbQo85sN5CeokT6z1FJzoRXxhd5ER88+gep8xn9lz6d2dg/tDh
LtyvWfR6F/L3aJTzzYX8PaQ7Xei3Kfq6C/W4R88fxH28Q4tB9NM4vWsQ92mU
bh7EfPiT/mUQ/TJMB7uRnxv0UjfOc5Ve5cZ5fqY3ujGvf6Rz3Jj3l+j9bnw/
XaBr3ZhfZ2mjG/fVS/vw+RA3fROf3+GgH+PzPiv9tAf799OxHuzfSyd4Ar+P
6AwPfs900gUenL+V1nlQTz3d7UH/nqTPeDBPj9O/efD74xg97cH90tFPapjv
VXS0hn6voN/SUP8yOlVDvkrofA3xFtMHNcRbRLdpiLeAdmuYF7vpqxr65RP6
nob5k0eHevH9vZOO9CK/OXS8F/c9i97iRX+l07leud/1D+lSL863ze//AQED
/1A=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw91Q9MlGUcB/ArKbezLB3lnyXidIZEaDqNubDHSEWHU8kpTtJ5qQOd83Ka
Jk6RQSHTwEQUREXvFEQ47zoO7i93997mn3a5XCZmNDEXEBpLJ0XMXO/zpe9z
m7jP3vd93uf3e36/3zvBtDVzw/MGg+Ga/k/+z5+xzfLn5p635w5qofguGo1u
Ul4lrObUklw6ZBKlWl9CjrqeK123kRZb5f3GDer+beLTVOPKT+iOHSLTHVe0
Tj3/uaiqrKxcS8fvgT9W6+3D/avpafux3iq1foG8f8xKemkh9r9cva9I6I9v
zqTNXwrbgnsDS9T7Dwj9T/5iuqxEZOsBLVL7OSgifQnZ6bT9kCh6sMw9T+2v
FPGm0TllYrx+g1D7PSz+SsguTaX7D4sp+gtmq/1/LWT+36WLj4j0e7tjZ6p4
ysUM/TedHn1U5MXaFkxV8R1FPpLougqhX143RcV7DJ5MpxyHJ6r4K/F8PH21
UuYvY5zKR5Vos5hTx9JZJ0SqsW3iKJWfasQfS3dXy3w/eFXl6yTO42V61yn5
vMWo8ndansfuoXRMDfIXo/JZIx4uc8c9R0drsP6/vzO/Z3AeA3T5GZzn33T/
GZnvD57Q2WdlPb3wiA6dxXn8QU+y4Pkeutgi10/poh9acF736aVW1H8H3WRF
vfxCjz6H/Nyh95yT+QzcojvOoT5/oD88j/P/nq47j/uj9Eu1YqP+u0aba2V9
vXKZvlkr68Wp0Sl1ON8gXV2H+vbRhgvoNze9/gLiddFXL8jzuOGgk+pl/GYb
XVaP+C7ST+pxvrV01kWsZ6X9F7FeDR3fgHhO0oUN6M9KursB/VNBZzSiHo7Q
9kahp8tWSsfaUK8H6V021F8x3W7D+RTR4pJ8f+d+2npJ5mfHXjrGLuvBkEfP
smMe7qRz7Mj/drrKjnya6agd+91CP7MjP7mqfh2YpxtpkwPxmFQ9O9D/a+nL
sHO1qm8H8ptFJ36Dfliu6h1OWUZ/NXh9sar/weuL6MeD1+erfnDi/Wn0Ctj5
vuoPp9xv8nu014l+SFH94sS8mEnHNcl8nHpH9U8T5ncyXdCE805U/dSE+nqT
7myS55E/UfWXC/Uynl7kQn2+ofrNhfMdTdtcOP/XVP+5UI8j6JHNmK/DVT82
Ix9G+rNmxDtU9Wcz4hlC32lG/xpUv7bg+/W0+3/PaUH/9dPmFtR/H322RfZr
2yP6Zgv200u/6MZ+eugUN+qni97klu8vv09XuzHvOujrbtR3O23wyO/Bvdv0
dA/m/4/0eg/mzw26woP3XaevevC+b+kBjzwfwxU6yYv5FqHXeBFfkC7zYj77
ac2L+nHTT7zIp4ue7MP5O+gsH863kS7x4ftRT/t9yNd5uteHfrTQ8X7082k6
04/5foIu9GN+Hqeb/chHOd3tR30fpscGsN4hOiOA9Q7QewNY7wvaHsB6BfSv
AexvHx3bivrJo+e34vu3k97VivPaTte3oj/NdHsr8reFHh7E9zaXFkHZD+0b
6G1BzE8TbQ1iXq2hbwVRT6vpmBDqdyU9LiTr9cpH9KwQ6mUpvSSE/GTQOSHE
k07vDyGeeXRVCPNwLu0MYd7OoaN4fvNs+jc8H51FP8PzyTPoUWHMl6n0tDDe
/xa9MIz3J9CmMOpxEp0XxjyaQJeHEf84ujGM+MfQl8Ooj9fpu2Gh/80fSfeH
0X/D6REa8j+MTtTwPRlKp2mYH0PobA31bqB3aMjX0y7Oew35+oeu1ZCvPjqk
Yb+P6J807LeXfqyhXnroYRH0byc9KYLvw306NYL83qVXRJDfn+mtEcyz23Rx
BPPzpu7/AFQHCXg=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1g1M1GUcB3CWxhZpZaNJb2hJRYyIYjHdoj0lyzRmwspwXdYIibQJsuF8
oUQGgWiCBOQRKC+HnLwcJ3fcG3fc/+4UdV2uGsUsVmiLUMilk8asafd88fuw
2OD22cP/eZ7fy/P877GsvIxNd4SFhZ0N/cpP/uiq/NPa5WdentVqkeGILpvz
BnFhV2SCspYl5P971fhHYknZ5HfKIk/sjjSdVtYK/j8+VigiRtr+mnt+pwhN
F6vmX1okx/OVxR7Mp5y4F/vxqflLREroAeV1pZjPr9YrE2WT6Q7l/HK5n/SA
Wn8f4lGursR8J9V+DohtKRFvn6LNn4vXQhsYUvurkuMjyrnVIikpyaKeTzwk
83mnWn/mkIxn1Vx+apBvN13xBfbrVPHUitC/X7DRUXVCflhVfHWiQa9/8ARt
rEf8JhXvl3I/SV308sNy/uVGFb8ebqfP6JHfVpWPBjGV7og+Smd+Jf6O1d3b
qPLTiPwdpicaRWA6drRO5asJ8dTQO47I/NVWqfwdFaHwtxyg5zeLp3VVr+xT
+WzGep/RwWbMX6Ly2yLjNe6ha1swX5HKdwvi2UnrWtF/hSr/rXLcVEDHtOH5
PFWPNtkPyz6mp9pQ71xVH4Mw5KdUbqKtBhFq35QsVa92Od/kRrqoXdZL/46q
Xzv6IZNOPYb9vanqeQz5SqcXdGD+taq+HeiPNfRwh+yP4lWq3kbsP5VuNMr8
+oWq/3GZT10KnX1chKa7sUL1w3Gsn0zHdyKfSao/OnE+n6Wvd2K+eNUvXYgn
lnZ3od+fUP3TjfP0OF3ajXpGq37qRn8+TKf1YL3Fqr96cD4j6UgT8nGf6jcT
6rmQHjWhX+9S/deLfIXThl5Zz4h5qh/Nsv+qbl267WQzztu/dK5Zno8jM3SD
GfmepoNmxHOVvgnHXqETT6D/LtNZcMIfdO3s+G/00Oz4GD0zOz5Kx/Vh/Dyt
g00/0Af7sP73tNaH++4cfa0P5/1rOsaC+E7T6y2o10m6woL8aLTLgvx56CkL
8uuko63or356nRX3fR9dYhU5OTnjJtpqRT910eNWvE866Kh+nB8DvaZfng9P
M13Uj/uviTb1I149PdaPetbT99twnmvoVBv2e5DebkM/7aeNNtxH5fRPNvFN
MJhWSi+wYz/F9Et21OcTOt+O/O6kW+3I33Z62C7X31VAhzuQn630cgf6fwu9
2YHz/SHd6MB62fQ5B+6f9+kwJ95P79LPO1GPDXS2E/G9Rdc7ke8M+owT/bWW
vuFEPl+n410476vojS7chyvpahf2L2i/C/l6kb7uwnlaQT85gH57gc4cwHl+
jq4cQL8k0O4B5COOvjKA/n+KXurGfMvoDDfmW0KXujHfI7TNjf1F0RNu7O8B
+iEP+mcRneZBvAvpTz34/hFBmz34vhBOX/Qgf/PoyEHU/9bEbb86iPvtH3rH
IN6XM3TnIPr7Oj06iPpepe/xyv7J+ZMWXtynl+gCL/IzThu8iOci/aMX8fxC
z9fQ7z/Tj2rohxE6WcP7e5h+Q0N/fUvn4vlgkN6L5xPO0g0a1j9FWzSs76OD
s+sP0r9ruG9d9E08H2GnF/sQv4VO9KE/eunVPtSzm87yidDfYiO924fzYKBr
fXg/tdA9PpyvJnrIh37S07/6UP96esaHfNXQi/zYbxUd58d+99Mr/dhvOa3z
474upQv96Jdi+qAf92UR3eGf/T5Ea1ivspA+j/XGt9HX/Pi+sZW+O4D4NtMx
AcSXQ6cEUI8P6PUB1OM9Oi+AftTRFQGcr8yQ/wO1PSFN
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw9lg9MlHUYxy+nrsjK6jbNFpKZQ6eNyjk2R/7Spul0iSuldesPmWmuuFiU
ihk6WGomqKhBSPyVA/H4c8dxHHfw3nulUKdpmqSSAgmCWDmHxmxZ9/va93k3
jn32vu/veZ7v831+v/fx5JRl74ywWCztkT/9n5c3Omvt4JUZz9+hhap7g9V5
RfhVdSwcDg+QjWRwv9xfo7LNG47LZJWiVkWuPnk+VS3zRo/qJXelqchvxm/y
/npldS7o7ibHbFQJUR1PdMl6n+l4iy+Q4zar0I1YW6esv0VNzBpMPEdemqme
jVy/SLwsHc9yhmz/XEUe956S+Nuw3klyznYV1VF67bjks0PZss20MLn2S9xv
l/yy1YcJUSuOklfn6PxLheN26eftbeThXWqqLXuuvG/sVvl5eY98T966B+sL
L82F3j+Qx+9FfySfrr2qzJ6w/RjZsQ/xJH/7fujzIzn+K11//AmpPw/xpf62
POj1k+iRr/vZJ5z0tUq3Oo+KfjEFyOc0ub9A3Yy1Zf8seh1APqL/ukLk0yH6
faPff0r6NbJIv//AWdGzCPGFw0VaP1P6HVes8887T84tVtrP4o/hYhUJn/Ar
2Vai9YoSPxklun8dwpNLsd5F6Uep9udb4serpepqojda/Lq0TPunU9hdpl7s
3pDbI/0q13otEL9vLFcRu98S7iqHXy6RXzgI/eW+46COVyj5jKlAPVKfvQL5
i36nK1C/6B/vwPxJ/wocqE/8YamE/uKvlZXQV/zbVol+fUueXoV+GOKPKsxH
gDxUhfx94pdD8IOH7D8Ev7nEP9Wov4acWY18qsVP1ZhXB3nxYcxPufjrMPxY
TLY6sV8Uit+cOv+T+eROJ+Z1v/ivBvrtIZfVYD/IET/Wor87yLPAtm3izzv3
s8j5d+5vEb/WYv1N5NvgFeni3zrk9wk5uQ75fyR+rkN9dvKROtT/vvi7Tvsh
sIY8rR7zvUr8Xo/5TCbvrNf7dewb4v96+Os18vV67V9rksyDC/vLy+TlLvQ3
UebDhf4vIftc2n+DC2VeXNBjPjnajXrnyvy4Uc8c8hY3+j1b5smNfOPJfW74
d6bMVwPm+WnyogY9XxtmyLw1IJ+pZGcD9J8i89cAfSeRH/JAv4kyjx7481Hy
xx7sT+NlPj1ajwwr+ZwH8cbKvDYi3n3k5xoxX/fI/DbC76PJJY2ob4TMcyPm
99+B/3m0F/vp3+R4L/z1F/k9L/QcIhd4cT5fIx/3or+/ky1N0GuA/EwTzuNe
8som+LGHvK9Jn6+uC+S2JszzefKtJujRQZ7uw35xivy6D+udIOf4sF6YbPqw
Xjt5yIf8viNPaUZ+QXJSM/bXFvL2ZtTrI/ub0a9G8h/N0M9FjvFDvxryMj/6
X03O9KMfDrLHr+uzlJP7/TgfiskTAujvAfLiAL5n8smbArqfWfvItQHos5vc
E0A92WRrC+r5gjy/BX7fSl7Xgu+tTHJVC/ycQe7E+7Gfku9vxTyvJ6tWxE8j
p7Yifiq5rBX+/4B8phV+XEseaaD+d8mPGaj/bfIsA+flm+SXDPTTRl5tYP9M
Im82oP8r5HwD52ki2WXg+2gJOWzAT4vIvQb2u/nk2wb0mkceF4Rec8hxQeQ7
m7wwiHzjyclB7G8zyelB7F9x5Nwg5ncG+XAQ+k4lH0G8vifJF4M4vyeRh4Pw
VzT5QVPHuzGBPM3E+TuOPM+EHx4m20z0Yyw5zcR+O4a808R+eje5wsQ8jCIb
Jr4X7iKfNaHHP/08D0zocYt8bwh63CRPDuH79Do5IQS//UleHlKR34xBckoI
83aZvDUE/S5F+D8Qdh/S
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1MlHUcx7FpLXWWjU3LRVrMoaXTcsZa6N+XfJsrcctsu7WiIsstiI1S
NFMH86UUtNME8YUXBVHPg4PjOO7gueea2rpsvUyns4KWhkLlNM2x5br/t32/
BRuDz+55nv/v9/39vt/nxuXkLX3zrpSUlC+Sv/bv/37Wm95Js/79d6GZ4Cl1
Z4pfNllDzz0mdnIs18zQ52+bczX5WWKTZ5K338zS9QXmq0QiIe4qNCW92SFx
ymqcJx671qT65neLzUemorz8QT1/ygb7+WtiZyPuFy8pNk8lf1RvVwnOE+dv
MmuSD/iv3y0mNzf3srhsq1nQXeSdpXo+sfUvnk32bzO3Mjz3zVF9pahXvKLM
nh+Yq3p34HnPkW/vsPoUzlP9O9HPfPLmT80jyYIXqB8v6tf1o3ehX53Xtcv2
c0r11+8GS7/8z+x8os+QM/eY7qJU39Pqv9zqWz6NfLrc2H2YKj0qUN9k8vK9
mPfj0qcS88kg91SaUFpJb7r02ofzx5FX7TdLkxekSb8D6HcMefBBq1fqaOl5
0LyXXLhUcgKfe0dK3yrcP4LsrTK1+VlDh0nvKuh1D9lTDf0HS/9q7PcgcnoN
zvv7KudRAz36yX01Vr/Jf5GX1OL6G+TmWpNch6Jr5NGHTF92KO038tpDqOcK
uesQ9L1MnnsY+3aJXH8YeoqH19n+tur6/DrU/yv5+zrsnziz3p43u4dcWY/9
EKccgR9UzxtHBtZ3+ojdv8yr5CcaTNLe9eKyBvihl/xng0nGQ754+VH4Xxw5
Cj36yGOP2f5WiouPoX5xzzH7vGvixcft+RnS03/c6v+SONUH/cWrfNhv8UUf
9l9sTmA/xbUn0L94sH/g59P9qE+8wm/72S+u8GNfxAn/wPru+DEv8ZRGzFf9
5TQiX8XeRtwvPtlosIbk2404X/pObMJ+ij1NyA/Na3vTwHk6uN6neV9vgv/E
6QH4RfuyLID5aR83B+z8S7vJ4QDq+1F+CWC+F8hpzSZ+M+PiWfmnGfv3HXlj
M+r9Wn5qhl4J8uVmnHda/mqx8+7/nLyoxeZ5bkx+a7H58E2U7GtBfoXlvxbs
c5D8QBD7HJAfg9inE+T3g3hfHJU/g/BrPflCEPtRK7+2Qq8q8oxW5N8++bcV
8y8nV7ciz3bLz63QYyf57hCeVyp/h/C8j8nvhPC8TfJ7CM8rJp8J4Xnr5f82
5PeH5Cfb7PzWr1YetKHfQvLuNsyrQPnQhv15l9zfBv1WKi/CyIO3yK+EkZev
Kz/C2MdXyW4YfvUoT8KY73Ly+Ha7P54XlS/t8Gc2eWs79HleedOOfhaRf2/H
+3qe8ieCfJxDXhqB/2YqjyJW3yHPkoMR5HWm8gn3u9PID0Wxr1OVV1GcP4m8
LorzJyi/otjH8eSfo/Dzo8qzDvSfRp7XgTwYo3zrwDxHkRs64N9U5V0H9L+f
PKITeTxc+deJvLiXXNCJ98sQ5WEn5j+IfLYTet25wnx0UG8/+WEH9d4iT3dQ
7w3yCw788Qd5hYP3dR95gwP/9pArHOj7CzmA89K6yQmcV/QD+ZIDv58n33HQ
31nyqBj6+5Y8JYZ5nCEvjGEeX5JzYvi+cYq8Job3UZzsjcEPDvl4DPsTIZ+M
QY8Q+acY/NhCvh2DfxrJI13sm4880cW+N5DnuJj3YbLHhd9qyIUu9DtA3u7C
H3vJdS72Yw/ZcZHPXvJ5F98PysjXXei9jTwsjvfBFnJ6HPtUQs6KY/83kpfF
MZ915Lw45lNE3hzH+/yDJP8DJJoYkg==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF1n9MlHUcB/CzSXPIdBYV2SRcrCh/RNKIudG+pEkYJVIq5kWKP0JrA12W
IUtlOI1ZQBF1iMZP+WGeB3ccx3HAc881xUUuF5MySrAkSlatxDn+YN33fb0/
3cbYa8893+f7+fH9PLcwJy9z+x0Wi+VC8E//58daak6m3FiSElKa2p0cPrRC
vFElJCQ4n6WNHHUrzlqaKtd3qvCh+vw0WuWprwcG0p+X7+9RowWRS1+gR/aq
hvzk8DVy/7vKE334RgYdU6j2R9rPZ8p6B1RwO/Uv0/GHVGbwhvWyfpGKtKdu
yaIzitWj1tJnXpHnHVYTaz3RVjr/iNL/suX576vAZNzwa3RZid5fiTjmmLKn
jk7J/Y4P9Petsr4q1fHZN9C5ZUrn8//9liN+ied2OfYr8RsfIZ50+ujHiFfy
mVGh85EqjvoE8a2W+EKWfDdXwrJe/qe4X/Kf9Jl68PCNtS9K/DbEI/vpt6kd
wY/Uo6wK9V1LZx3X+Tso8cRUox9eoserdb5PSvyOEyqYjuZ19L6TKvh4j9RP
fY56S/5m1qD/pJ65NTpfoxvpgRq9n78k//G1qM8muqJW5zPsVcl3LfpN6m2t
0/udK/U16tRzwQJtpmPr4S1Sj5Bz6ImQt0p9GrD+NtrVgOdvl3o1oh/EhY06
v2M7pH6Nuh6XXqdXnlLBdPfkSj1PIZ876Ygm5H+X1LcJ9XuDHmzCeZXrSc16
vWRZv7oZ+Zb9W1rQDxL/thacB+n3/hb0g+R/cSvOq9SzrBX9If1wsxXxSn9l
ndb1KZD+9MFTMj9ivkA8K+li2CLzaDx0PZlOP4Pry6W/zmD9RDrSjvWXSb/Z
9X72Pk4Pw5OLpP/OYv9xdMNZxBcr/ehA/AvpRAfys0D606H7dcN8usqh59/A
vdKvDpy/u+lpB+o7V/q3TdcrIYLOacN5mSX93Ib5FUafa8N5myH93YZ+m/79
Pz/WjninaGs74rlFf9iOfvmHNtqx3z/pv9vRLxN0rBPzbZxe78T3f6WPOnEe
xF4n8jFGTzgxT6/T0S705y90hgv9/zNd5ML5uEa7XDjvo/RYyCN0VAfmw1V6
dQf29xNd2IF8/kjbO9BPw/RIB+rzA32XG/m8Qq90Y159R7/txvweopvd6MfL
9BW3zkfFIB3Rifp9Sz/dqapsNtslOr8T8+gbuq4T/XyRHuxEvw3Qd3rQL1/R
SR7Ec4He5dHz3zxPV+O65Rx90YP30Ze0pQv1MullXegfg97Whfr10pVd2L+P
7g/ZS091IX4PvdiL+910thfru+gyL57fTpte7M9B3/SiHnb64W7U9zSd1Y3z
0EKX4Hp6E+3rRvyN9B/d6Oc6OsaH+VdDZ/rQXyfoYh/2f5x2+3S899vocR/e
15X0/B7db3EVdDrcXE6/16O//1Ap7ehBvo7R13qw3xI6shfz5wi9qhfzu5je
14v1iujWXvTPAXq4F/kqpOf0Yf8FtOpDP79D7+lDPG/RDbg+upu+HLo/j55p
IN9v0gsMPH8nnWgg/h30GgPnfSudayDfm+lDBs5DNl1loB820U4Dv2+y6AED
/bOOvm4gX5n0NNbPX0Pf58f+0ul4v873wTQ6LeRVdE7IK+j9ofsVXeHH+sn0
GT+ev5w+58f+nqKv+jFvnqRv+3Gen6DnmZgXS2Wem+j/RfQKE/PxEZnvJvoh
lt5ron4LZd6b2H803WRi/j8g89/E86Po70PPu0feByZ+j82jZwdQzznyfgjg
PM+mkwOozyx5XwTw+yiMzgug/jPk/RFA/0//tiTlX3rl87s=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1M1GUcx6lRa+SyFzbMFmqRQ6aNchlb4Z60SRQVska4qAYh4UuBGIpA
KsQlMALUEwJJeX8TzuPl4O644/53bGqN3GqVs9GCVsaCVWPiGFuue763789x
G8c+3HPP83u+3+/v92ddenbS7ruDgoK+9v/o33y9Ml1gLprd9FKA4lVmZuaN
QuFdyv95qLCRrhrq6x8tkM/3KEvc9FI+WWUr0+xO+2FZn6vW+P9wiDyVpwpD
LZc/ke8fUXM77eEHyWuL1IHYkLcPyH7HVMi11pxscnSxsoeb9n0k+5dg/33k
xFLst0fOM+n9rmWSc07oegsy5Pxy1ZYTG5JOrqlA/WlST6W+b/0HZOsXKrXa
l7db6qtGvR+Ss2rUZv9Lzo8+Cf2kvsWT+j7/7pf6T6lvJyYmPiaXnVb+5ZYc
uY9Z11eRS151BvcX/abOaD3jRN+uWlXtW4gUP3LqVJI9/B7xK+ZL5V8+fcff
erXBf6FPyVfqtX7njokeDcr/fryYnHJWjS9Epn4m+jQqvz2xJvJMI/JxQvT6
Suu1UEbOPwc/KkS/81qvwUpycJPWy1wlejbB/xryRBP8PiX6Nmu9njaTzc3w
s1b0btZ6zdaRU1uQv3rRvwX+yOcRrajntPjRivPk/LlW+Cf1JrbBn3LyUJvy
X+/Jz8WvduSphFzUrv1OEH2n2pf78XIH8iX+dXXAvzzyik7oI/2R04nzJD8/
dOrzYiRfMV3QQ/qlsQv6Cwd16++3yvczunX/Z0q/XelGniSPG3tQr3BNz/J6
bvboPG2TvKZcgP7CrgvQ606/96J+yXNpL/QSnulFvuX+CX3oF2Fr3/L8h1qQ
Z+F8C/Ih82jSgnqF1UXkU7jtIvYT/YOtWC+8xarzPymchc9Dj5AbrPi+8IQV
/Sp824r7C0f3o9+E0/u13l3C5n74I3ypH/NIeLFf58MkHDWg/UkTTh3APBKu
Glg+r40B6C08PwD/hSMGkR/h5EHUI3qVDS7X1wm2iP5zg/BD/AwfwnrJS+IQ
9JU8lgwp/Wuv9NMQ6pH5fWMI/su8XmVD3t8nv2qDnu9Iv9nQPylkiw1+vCX9
Z9P9/V0i+eFh7Pe69OMw9osnHxrGfjukP4dR3zbyz8Oob6v06wj0f4G8dQT3
fV76dwR+bCa3jGC+Rks/j0C/jeR77eiXDdLfdvj/FHmvHf22TvrdjnkTTr5q
hz+rpf8d6lZk6sow8rMOzNtHZB44oM9Kcq0D91kh88GB+9xHXnKgn4JlXjjx
fLyL/J4T8/W/vzg/nOifJbLPifl3i3zTifPnyetHcf4/5JRRXX/1LLliFPP5
T7JrFPf/nfz3KO4/RV7rQr5/ISe54Od1cqkLz4sfycMu6P89ecal/O/Hr5JX
uzEfviEnuJGny+Sjbug1Tra6Ua+H/Jsb9brIoWOYB3byjjHkz0bOH0O/95N7
xvTz2N1HnhzD87iH/IAH+naQlQd5bSHnejDvz5PbPMjXWfJPHtyvjhxs4H5m
8uMG7ldD3mIgj5XkNw3Mx3JyloH+MpGLDfRDMbnBwPP3KHnQgB4F5AkDehwm
/2Ggfw6SbxvIWzY5zIu87ydHe+F3FjneC/0yyOle5DONXOhFf7xLNnuRj13k
Pi/+/0wmX/JC7yTyr17o/QZ50Ys8vUZ+yIf/T+PIUT7kfzt5uw/+KHKqD/l7
kZznw/M9hlzlw7x9jtzpg5/PkI3A+k3k64H1UeT5wPr15PvH4f8T5Ihx9OMa
cuw41j9GTg6sDyNnB9aHkssC6x/08//EAAfz
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1HUcxqlZbfTicrbMTaOyImdl0Rxbo36ZM3WskDXTRW+U5ksFWjgT
l2lSxFKgUHnzBQ4EeTmPuwOOl+Pu/peKdVKUipWrbGVOrTlLZ7a57vdcz+Nt
wD67/+/l+/0+z/Pnjty87IVXJyUlHYj/2L/8JI+4znafvv+JBM022YGJRT3i
Baa6quq2PnI41xxfPdbdr++XmMKx7qcGyCbPxPF4SM+vMHFcHSH/XGBmxTeI
av27Ji0tzfc5OWWNub3o9Nx92m+tsffbT566zlxIzSk9oP3XmzNzA9u/IGdt
sDzxS51XhPuK8z/C/jGd/7Gt95qD5LISW89+ccon9r4VQ2TPRhNvz7KvdL9S
czAWy/yavLjMxLdPH9Z9y+35D3xDvlhuSp3zqd/q/p+CD5GLP7P9SDuseirM
iCs/4wh53Gbcf0T1bTaL4p+j5OYtmIfW5281Gckjd+n89Eo7j0uqJ6nK3j+m
/gxW2XlXDaof1Xaer+wlz6/Bfo76U2vPP6H5n6y137ukF882rA+QV22HnjrV
vx04v4M8aqeJ/37frX7uRP9aybGdZnn8gCb1tw56bSBX1KGfdep3ne3X8DZy
Tr3JKXUKqtX/evt8cw15kgv76fliF/q7g3zGZe7LKZ2u/bMa0A8X2d9g75/U
qHk1muj51GO7yGsa7TyDzZpfI/rdQp6xC35p0zx32XqfUz9uaIK+PJpvE/zk
JR9qgl98mncz6le/a5vhhyt+3w0/ye+v7Ya+Nb/B3dB3kDylBf2Vv8taTEN+
RrL8/XcL9CB9zG+1/XLk7/5W6EP+TmnDvKW3DW3Qi/x8sg36l18z2+HvK35s
h57lx7Fu5I/8u8qN/mm/Y27o7Uq+7ME8lUcNe5BHqm+UB/Uq76Z5MC/pebEH
9au/1R7UIz3HPJhHO/myB/Vp3lM7MB/pI7cD9UpPFR2Yl/S3rwP110rfHfb8
kkryZC/6USG9e6HfcvImL87bKP17UX8J+ZwX530oP/jg1w/I83zwx1r5w4f6
Csm9PvR7lfziw31Xkif6sb5A/vFjXu+Q1/vhd7HfDz2+TT7hR96vkL86kdfL
yXM64bd8+a3Trj+dR3Yn+C35L/H8m+QxXdDrG/JjF+a9jLyyC/1cKn92QR9L
yN93IZ9el1+7oYdF5Me60c+F8m838udVcj04NVd+7ka9L5OvDeB99ZL8HcB9
XiAvDdh8CDwvvweghwXkIXyfPl/+78H6eeSHe5AHzyoPenC/bPKWHuyfpXzo
QZ49Tb6U4EzlRS/0NIf8Yi/ep7OUH73I45lkpxd5M0N50ot+TSff04d5Pa58
6cN+GeSSPrz/HlXe9Nn9z6eT/0w8P0350w+9PULO7sf8H1Ie9eM+D5K7+uGf
KcqnxPeTyeODWH+v8iqI9/nd5PeCmOedyq+gwTXIvwRtfTkTlGcD6N948swB
PD9O+TaAem8htwxgfmOUdwPIu9Hkm0LQz43KvxDyJpm8IgS/Xac8DKFfo8hH
Qpj/VcrHMOZx+dT/PCGMfv9Lnha29xn9D/mZMN6XF8iLw+jPX+R1YdznLLk6
jPr+IPsSfIocS/Dv5N8S/Cv5cmK/4+RbIzjvR/LUCO7zA3l2BO/To+TcCPp9
mFwYwfttmFwRQX+HyO2RxP+b5H0R5PMg+SesX7SXfDGC/HXINzvQe4g82UFe
9ZGfdOCvADnHwbw7yQUO9OMlb3JQ3x5yU2K/VnLYwfuumfydAz82ks85yIt6
8vVRzHc7eVIU62vIGVH7PsivJM+LIs82k/OiyPtycnEU+toU5/8AtPQnzg==

       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg9M1HUYxm+ObEOXy7EyNwkXNXJWLrdybbhvZhnNFrBmtG61qJzZFuhG
I2WlJpOoAA2pIzT+CvLnOLjj/sEdvzumQZ1OF4l/KECTCIiUxIjMuu/z6302
b2O3z+57933f533e58fyzKz0t+ZZLJa+6J9+l1e5zWaLTDz0pEkp6kFrcfg7
8svqepJ1EdnIVPYNIzu+5edvq9rs5FiyylL5E2nePp7frtK98fnk4RwVO1CT
Tba8j98jJ+SpyTTvYbL6UPXMJA2SV+1Wq6Mv3mfsUSM74h5mfal71b35E6fZ
z3A+7jspnL1PPRv9wine/7GKfhw4LVxSqOLsG17/nvV8quu/7Qdhx2f6PvsZ
1lestiXHvnRWeEuJ0m/nWe9+VRyeabggPLtf15f2I+s/gPNDwgWf4/ww+ynV
9Zb+JLzkoD6/i783fFBtjr54f0MZPj/Hfr9Qer6sZ82X6Jfft9ig76Bwrw31
8L6ScpUcO3Af68v4Sp2IRDayvoQK6DsiPFaB+y5Sr0Pw0yXh3MMqaoeJn6nf
15jHqHBMpfbPml+oZyXmMSYcqdR+K/yV+lZhHuPCpVWY/wT1rlLR62cmha3V
ur57pqh/Ne77XTixBvO8wnnU6O/nXBWerNH7UDzN+dRiXn8Iu2qh7zXOqw71
zAjn1el+Rq5zfnVavyt/Cq8/ovdhbpbzPIJ5zAkvrIcf/+Z8Tb4h3F+P8/9w
3g3on1zRAP1vcv5HUT9/701wEu/vParnX8N+VjbCD9SjpBH7+pvwtUboy3lk
NMG/nG9XE/KEfkhoxjzpr73N6Id+HGtGPtDfG1vQTz/91aL7eYf7G2fX8xsg
59qRR9znQTvq4T6rVsx3QLi2FfvJ/YlxIG+4L485UD/3d4sD8+O+lDv0fkS4
HxEH9OU+3HSgX/p/VRv2l/pktqmdUYPQ76Vt0Jt6Hm+DPvTzbBv8RP1XtGPf
6GdrO+bDeRW1Q0/61WjX+2+lP6fbsQ/0Y6IT8/xLeJMT+tOPBU7oTf/5nVov
J/016YTelsn/Od6FvJgnnOpCnsQI73Ehz+cLu8zPyaMu/D6/v6QD+fGv3Pdc
B/qjn/M6oA/7sXdofdbRz8Md8Df3fbEbzzPqud4NfzFv3nNjvpe5n274g/M9
7741rxd6oBfzd60H+UK/ZXtu9We1B3rz+dTvQT98ns33Iq97ud9ezOuY8FYv
8jfEffciTwLCJ/F9q5/778P9buFHfbjfyTzwYT9ahct8mHcT88GH/huE53zo
v5Z54cd+VAq/6sc8DzE//Mhvm3DYD/3LmCd+7McB4Qc64e8i5kun9nf8J8KF
ndBrH/OmE/V+JDzVCb12MX+6UG+ecHoX8jGXedSFfcwRdnfBL9uYT11Kv70r
vDQAfbcyrwLQd7PwBwHkxxvMrwD89ZrwxYC+75tXmGdB9Jch/EwQ/b3IfAui
v1ThxiD253nmXRB5kyJ8Rzf24WnmX7d+XiWvE97eDT3WMg+7occTwme6ocfj
zEcD+bJaeJkBvz/CvDSQpyuFXzCQh0nMTwP63S+828B+LGeeGtj3ZcJOA/5Y
ynw18P/BXcKXDei9mHlrQO9FwneH4KcFzN8Qnte3C6eEkCcxzOMQ5mMR3hmC
/26MSz6HzHwUbgkh32aEj5vnrwoPmeenhGfN8+PCd4Yx/1HhFWHM/5LwU2Gc
HxK2mucvCOeY588KF4Wxv/3C9eb5U8KGef6E8Dnz9/uEp83zx4QX9OB8WDix
B+eDwsk9OO8X3tSDfj3CWeZ5p3BBD/RpjfJ/ke47HQ==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdln9M1HUYxy9DKyQtR4vaIpqsoaNisTH649ondZqOFrCm1q5WjIpsjcuG
M6VCg0JmggYmiMSPAw6E4+AOOI47uB9NcbvcXE7K0QRLsyAzQiMq6j7v63k3
ZAP22vfzfT7P87zfn8/zfSgnP/vVRQaD4VT4V/+Xn+jRpms/TT7yVIQ2KovZ
WDZFfl4Zo0dXXhX25ajRJrP3Fz5/QwWvJ5l+FVb5ylQeuD7N9dvVjSRT+Yzw
eIEKP066wfffRbzfhRMK1dvG6C1/MN4HSuc3J5yyR2W74kv+Yvy9airLFT8v
nFmsUlNTHf9wvxL19MSuSsPUf2z+WNcXzfWGfSoc7s0/hSvKkM8s89mv91vM
fO2fqJLJrPTfmF+5ei38c004rwL5/cx8D6qa6upq9nf2oO5n0w/M/xD4e+HS
T3U9dROspxL9uCgcV4V8uH68CvVeErYeVrG2Da8wvvkzXX/sj8LpR9SqsED/
612t9Sqg3iPV0Id6V9To/Uep99aj8Af1TqjV8dawH1dqoT/1th/T8azs3846
5Mf+qs+RH/WNqldfhkIh6pFXj37+LRyqR/+pb0oD/EF9KxtUOJxtkfBsA/SJ
EjY1wi9LhH2NqO824cQm+OUO4dIm9WB4w6XCU03wz53CmRa1O9Z2cpmw04J8
7xKOa0Z/VggXNiv9L1Z4vBl+u0d4XQv6wefWFviH8WJakT/3N7fCP8z3LHgl
60u34jn7UWuFvuyfoU2f3zFybhvqYT9H2tDPW4ST23GeGa+iHefnVuGZdtTL
fm89jnoWC3uOa/0nyAkd8AfzLe5APOpxpQP13C6c0Yl8yfZO9Jv1x9p0vo9G
C++0wU/kMRv8QD1VF/xKtnRpfYpihKPs0Iv9TrPjvJDz7DreZXKNXe+XQT+E
7OgfeT4Sb7lwSjfWk3O60V9yZTf0IJ/oht/Js93oL/2xugf1k009OC/kAzex
76b10z3ab/eREx3oD/fb7FiYT6kD9wHZ7YD+5CkH8mX98U7UR850Qj/2b68T
/aSeTifOG/W+7NT+mOTzuF7kQ/029cIv5MJe3DfU39aL/fn+eC/0YfwVfbgf
6b91fYhPf+7ow3mlf619OF/0+/k+Fbb3Lp6HmH79/gaelyf7cX/zPJn7F86r
xn7cN5xPZ/vRD867Ja6F8yrdhfPEebnNBT/xfq11Lbx/T7t0fnO8nw0Duh4j
7+/HB+Bv3u+5A5hHvP8PY72X821kAOdrUnhuAPcp502yW9dzhvPoJTf6y3lV
4Ub/vhMOuFX4bxHn3wzez7og/PAg/Pkt59Eg4p8XLhuEn74W9gzC3+eEr0bW
f8X55cF9cEY42wO/nxYu9kDPkHAfeO4U551H+9t8Uvh+L/T4QjjDC/0Dwu97
occw56NX12vwCl/0ol63cOwQ+t8vvH4I8Z2cp0Pwe49w+xC+x7qEx4bg9w7h
ZcPQr43zdxj+ahHePozzZhG2DCN+g/A5vG+s47z2Id+jwg/4cN6OCKf54Ncq
4Wd96Nchzncf/FYuvCfyfL9wTeT9fcKOSPyP+D0Q2f9D4Us+3D9FwvM+6P+e
8L1+3Je7+P3gh547hDf6MV/eEc7x6/vSZRbe7Uc/3xKu9CO/bcKdfvTndeET
WL88V/hCJP7L/B70ww8vCt8dQD9eEF4dQLwtwmsD8MtzwqYAzlOmcEEA/n9G
+ACer9kk3BpAvev5/RnA/bNW+JsA6lHC0wHobxReGsT5fkI4MYj90oSNQR0v
NVV4cxB+fUw4P4j+JfN7N4h5tCrM/wIrfgsR
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg9MlWUUxm+mtpA0jRItEZMMCY20iFXYa5qoYwtYM1p3tcic2RZXN5oi
K3UwiUpQiYKQ+CsXhOuFC/cP9w8f926kG7a5sazGJtQyF8w1Jo1cc933+TqP
826M/fad777nPOc5572rCgrz3p9jsVguRv/0f/lEZpKt8VPrNpu0Q2XGXGlZ
Sn5TrbVWhh8RNgrURHGc42E+/0BFHxfFCatC9XeyddFDjD+g8rwJZYuFx4vU
yrLJy4v4/iHlyJq49YBwYomOnxfL7/tURdP5637htKPqSosteB+//5h+bpsn
nFOK8+/leWXqcJwj6x5h23EVrXdsDs//TEXT+3CucFWF0v/mM58v9PdV8jzn
l2oq15vAfFSlqgzP2GOE91apssncDOafdhL6sb7Zk+rSyEg26zdOqf1RwR8U
Lj+t87MuYT3VKpr+BPWM/0rzu9R/HDzB/thr8Jz9tH2N58uEM77B9z/K+mvR
j8eEL9QivwTqUQe9Vwrnf6v7v34V9anXejQ8Lny9XrXaMmOSqNcZ+OMJ4YMN
0H8N9ftO6/NKsvDcRvhvLfVsRD+eEh5p1Hq9kUp9m+DHdcLVTYh/mno36fpy
04Stzcj3GerfDH02CCe1oF6+X94CPXjeVAv6xXxzWtWe6If19bXCr9Qnvk37
u5h6lrTB39R/vE3rVcF523oW8WT7WfiJ/Yttx7wsZ3/b9XMv+zfaDr15XoYd
7ycK19vxPvOzdOD91cK7O3A+67nQofXIfFI4tRP6sj9VnfB3ivDNTsw79co/
h/lbLxw4B3+wH4ldWt8R9qO0S22fKK7eSD91od/PCWd3Y/6ep7+60b8M4TgH
5vEF+s2B+X5JeMyhNkY/m+i/81qvmZeFW8+j/5vpRyfq2SKc7oQfXqU/nTrf
uCzhOif8vZ1+dcLPO4VvO7FPyGk96Mc24YIe+InnVfdgPpnfcA/6wXpme1Av
60/pxf6jXtZe9JP6nuiFXpwXoxf1sH/TvVofF+czyaXqamuX0R+7XNCD+6Dc
pfWdpJ8HXJg37p8pF/zF+yGhD/3jfZBj8kLhY+AG7su+PuhLvtaHerhf4/sx
jwuEd/ZDD8aX9CNf7ltHP/S9cx/1Y/9wvy5xIx/u161upf9xHj92o7+sz+6G
XziPv7i1XrWcx1jP3fO/yQM/cx5tHswn92ezB/Vyf4564E/O43wv/MB5zPBi
/3Ee93nhL+7Lei/8z37/4EW/ud8sPq1XMv2xwYf55Pzt9mm9rj0rXOPT8/x9
OveDD/6m/275tF5HOH+pA7iP6Ne3B+6exyqTXxQOD6A/fP/mAPYH532NH+cx
v3w/+sN9UuHH/cb9E/DDf9zXN/zQl3omBvD7gfswL4D6VnAfBfR5q9lfdwD1
8b69HoD/eF8vD2K/0G/ZQfSD/vwkCD3v/J4Iwn/8/fFrEP6xcJ+F0P9/J//n
bSH07x/hgyHoMSPcGYIe08JjIfjthvDCQfjlT2E1iH7/IXxgEP36Tbh1EPpd
Ff5xEPtlTHiugf79JLzCwH0wKpxuYH9cFn7NgN6XhPca0Pui8FED8zcsXGfg
PgsLuwzcFyHhEQP98Qv/bmDePMK3DcyLS3jpEPzuFE4bQj+7hHcMId4uXGDG
twkfNuObhKuH0P8zwt1D+H1UJzxsxtcIXzXjTwnPmvGVwovDiP9cOCWM+OPC
W8KILxW2mvFHhIvM+BLhE2Hkf0i43YwvEjbCqHe/8M9m/EfC02HouU94QQTx
e4STItD/PeHMCOLfEd4VQb/eEi404/OFyyPo7+tR/g8fddqD
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdln9M1GUcx5nT1tBZudvUmoiTHJEWRRn9OHtUEjVKoEJcNxuEhvUH5EYz
ZKVOFrESLNQgIn7K8es87gfcHQf3vbuluF01m9PZ2AS3mA1WjUkj16x73tfn
7YgN2Gvf7/M8n1/v9/NdU1iSu29BXFzcxeiv/i8/h022C+nTGzbHaIf6PhLJ
eo68R62unLr0vLBRqN43x+828/kBZbJlTmwSViXKk1D5nuL7B5WlJjS7WXi8
TEX/HtnK9R+qP5Mt970knFihpnM8Tdu438dqotz02Hbh1KPqalvp8A7ufwzx
viycfRzxZPG8ShUfXfCqcOknKteTsCib53+qGurr63OEa6tx3muM5zP1SDSB
14XtnyP/PMZXo/Od2i1cXKv3r9zDeE/q/Ve+KTx3Uu9vszD+L1S0/pl7hau+
VOHZ5LG3mE8d4i8QXnEK8b/N/E4h/iJh62nEv5/5nkH87winf4X4DzD/el3v
BPJoPfq9j/VoQL8KhfO/xv6ML7ER8TK/m414P5/1+kZF25/8hvChJp3vBdZb
fYt5YX8WNqv2UnM8+1ncrMzRAmQKR5p1/80ZrG+Lzucq562uBfXifM61oF6c
Z0sr6rWR9W9FfGnCSW36vLVPsR9tan/052nh6TbMJ9dnt6Nezwi72nHes+xX
B+rF8ys69Ps51NN4h9ZH2QvCGWe1HmoYv/Us8qe+lnSqtLQ054vsb6eKbudh
/pc7oQ/qLd2K51uEG606X+td/XWhHqxnURf6Rz2Odun+WqjH9d36/DT2o7Zb
vx9Hfd7qRn/J+T3QA/Xq70H/dnJ+eqEf8vFe5M/+3+xFf6jnrD7kQ7b36fne
8oqwyYZ5Jx+y6ffTOV9jNtSTrM5h3nYJt5/T/lFAXmhHvckb7SpqL7fJxXbs
Tz9psGOeyRE75onn3Yk9Z/yp/agnnxf2z9+/rl/P3yT3O/8/nuuH/sgpDu2H
EbLFgXqRTzjQb7LhQP7kGQf2YzxJTqxnPfOcWM/4q5x6fTX75XOi3+zndOw5
+5/gUtsnyus4H9ku+CHn6ZgL8XPeXC7Ug/M46UK9yCvc0Dvnd6cb88/5rnDr
80xkmxt6ox7G3ciXelk2AH2SM8CXqK8PBuCfZOsA5pd6/HkA+ZKXDEL/5E2D
8+/L0kHUk9yK5wXky7H15Hs88BdyugfzQL9414N4yY0e6JH8gwf6uHt/e1Fv
8pNe1INc5NX1/YN82ot68vxRL/RMvu2FHsnrffAPrt/rm/9+rQ/zQA75cB79
8pYP9aafrhuC3vi9kj+E7wf6b/UQ7gP6tX8I9aWf/zaE+5Z+n+hH/54QzvVj
flPpR37o43HhgdjzDfQnP75vHhV+cBjzk0K/GobfJAt/NIzz1tG/hnH/Pix8
YxjxraWfjWAe1ghvG4F/rKa/xXiVcPcI6v0Q/W4E/VgpvDSA75Hl9L8A5sck
fDCA+2EZ/TCA/e4XvhLA/C2lPxoq+vfIYuFVBvR1L/3SwP25SHiXgfosoH8a
mId/pv7jowb88m/hBgPn/SXsxH6Ts8IRA/M8I/yLgfv5d+E7sXimhZcH8b34
q3BqEOdNCu8IYv5uCBcGsf914cNB3E9jwnVBzOc14b4g+nlF+HwQev9J+HoQ
9f1ReC6I+kSEHwjhvrsonBJCvt8Jbw0hv5CwJYTzA8JlIejBL3wiBP17hDtD
2k/L3cJG7DyH8LUQ9G8TngnBz3qEF4ehP6twUhj5tQubw3i/RTgvDL9uEi4J
Y/8G4aow5udMlP8FIYLx/g==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1GUcx69GbmHT2dg0N4kmc+isKFqxtrPHl0SMUmgpbZclmflScVIU
ASkQpLESLLSOiHiVA+Q87gXujrvjf3+W0iI3NxfL2YJarAZz5bTMNeue7+33
9Ta4ffbwf35v39/3z31FxQWv3G6xWL6J/+hv+dTN5me/OHf/2gTlqrFrGbYd
5OeVNXmy8wVho0htmi5PIVv2qji6bMKqWAVS6/aTjRJ1bzwAeapUHbAmbydb
3lWunOlyclqlWmlrMG/dd0jHX854mdWq2eFw3MqnRsd/gPlurdXxzpOn6lRB
PCHWZz+svpuYyHuJ8T/E/TuFG+tVl92aXMR8PlLxdK6R3R+reDv+eJn5NeB8
l/CeRqW/djPfY+jXq8LXjyHfPcz/E+SzV/jIp/p++z7W04R69wsvOY7+vMb6
jiP+68LOEyqOGcWs9zPMh5z9udod//B5i0PzDOONO/R9pTxvbNb9u+MN4cIv
dD1NvC+tRed3zwHh31qglxL260vk85ZwWatmZyn79xX6/45wUpuayw+0lrGf
beqvDNvCcuGJNuilgv1t13q9VCnc1K60ng+y3+2Y/yFhW4eqSHGdrWL/O/R9
N6qF0zt1/NT3OY9O5F8rPJc4r+N8utB/sq8L9X3AeXUjn8PCld2YJ3mqW89/
grzhJPIjO0/q+hvId/UgPtneg3kx3gWctzKfbCeY+bc48fesz9KL+mqEd/VC
X+zPeK/OJ4f9W92nsrKyvO9RH32YP/t/tQ/7z3kV9qu4nCOcZ7gfeuK8007h
fuqh9hTm9Sb1hPOz1FfeAPbTTn0N4HnqM8WFflG/ZS7d/wD1fckFvXEf1Wno
mfvcdRr50R+S3NhH+tGjbhUPN11Ifbqxv88JN7sRL596deP+rcI3E+fkzEH4
FbloEPeTmwYxD953ZlDXX/8s9T0IPTD+Kg/6xXObR8V/VxUIH/XoeVh5n+FB
fYx3xaPjrSOne+Ff5G1e7d+TW7gfXuiZHML5dvKcF/tLTvWhnme4Pz7EJ9f4
oCeyzwf9PC0849P92Ule4sf+5glv9qPf5Eo//Jbs8iP+U9w/P95P5LuH4Ceb
uY9D8Evy20Pw/1zuJ9hOvpg438R9HcY+kNcMw29zuL/D6Be5Yxjz28h9Htb7
lkWeF0C/n+R+B1D/BuF9AdxHbgnA/9cLnwtoPVjIliD2Z53ww0Hoay39IIh+
KeETQfjdE/SHIPRHvhFEvWvoFyH4IXlHSJ/PkhtDqI/PmyHsP/lqCPtAXjEC
fTKfwhHcT64fgX6Yf3gEfkC+DF7IetPC0Au5IAx/I9eGMU/GHwrDL630pzD0
+Ljw0gjiPUa/ikC/jwgfjGD+D9G/IvCzB4V/juD+1fSzKOpdKbwxiv/PVtDf
ouj3cuG+KN6PafS7KOa5THjBKPJbSv8bRf2LhUsSnEI/TPAi4e9Hcd8C+qOB
98t84WUG5nkn/dKA380T3pI4T6J/GpjfbcLVBvzmv1nxUwP79a+w18B+/CM8
YWDefwv/aqA/V4Vv4tzxp/DiGPz2snBmTOmvOeHcGPr/u3BRDPsxI1wRw7x/
EW6K4X06JTwQg35/FD4TQ78uCv8UQ/8nha8nzi8ILzJ1PlXnhVeZqP+c8HoT
8b8VtpnIb1y41ITffS181IS+TOEeE/qLChsm9Dki/IOJ/ALCVxLx/MLzx3C/
Rzh9DH7gEraO4b5+4W1j0KNTuBjn1m7hI4nn2+P8PxiyBss=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1M1HUYx29O2zIWy9GiWqSLFblsLDdGW9RPJRGjQlaIdVkSWtoLJ4Uh
kAJBIikvCughGXAgL8J5cMdxd9zB//63pW3U1mbRi5viprPBqrF05lp1vy97
vpu3ifvs/r/n9zzf5/s8/1uRX5izfZHFYvkm+k//Lx9nxkxpzdyqNQuUqXan
LZ3+nLxFrY5+aoWNfHUjydpwkN/vVEunHX/WCatCfX7zIT5fpKYdttBh4UvF
Khr+kQae34t4jcLLy1U0n1tNjLdf7Yh+jgonVyK/ZsavUt9OTWW1CmdX475j
vK8G+duFbQdUg3m9r433H9ScdEK4sU6VxTkzjjOfQ6inRdh1WEWuJ1mPML8G
MOt5txH5sP7kJlUzuymVet1sUm12+/3U1ziirNEEqoRrj+rzU/tZT7Oa2+Q7
WS4c3wI99rK+FjVTGvfkHuG+VvSjiPUeQ3424dTjasNMafNu1m/HfXz+nF3l
+BKWfEw92tTj1oa1xcJ5J1T0bwXvW94OvT8RvtaO/pVQry9Rf6lwyUldb3EZ
9ftK98fN+hZ3KF9Czeyn1LMD/aEeUx2ov4L6dkKfSuHmTviDet7s1P6KrRa2
dqG/9LvRpfMtZT8SHVpP5wH2w6Gij8/Q/3MOxKPfs7t1/WlfCHu6kR/7H98D
f9P/5T2ot57960G+9E/6KfiB89B3Svcrjn6L6UW/OQ+2XtTDeTjfi37Tr6l9
Ws/3OB/tfdCf82HpRz/p94J+ff4C+Vy/ejjaQMZ7YkDfd5bz2TiA+lnPXwOo
j/rknUb/qGfwtPa//TP6ZxB6sp/Vg8iHfrg2CD/TT1lD0Jd+dA1BP/o5zgk9
PqTfnDr/73cJX3BqvyTspP/OQJ93hLvPaL+b2+lHF+a1QDjFBb/k058u+OMt
4TYX5v9N+tWFeG8I/+uCXlb6dxjz85pw/jDy30I/D6Mfm4W/Hsb9ufT3MPbT
q8IrR1Afn7eOaL2u5gnXj6A/vM8YQTzmMz+C+7dyHtzoD+vLdSOfbZwPN/bp
28IBt+6XjfrNuVEv9U3wqG5b2lLqn+25vT9VHszz+5wnD/rDfl71YJ9wn8WP
Yl9xf20cRbyPOG+jiEe/OEcRj/vq0ijicZ8u8yIe91O6F/Hoxz1exNvH+fQi
Hv37ixf1cv/EjGGeub+eHcM8MZ5tDP2gv7vGMO/M9/wY9KS/7/Ahnw843z7s
A+q3y4d9s4Pz7sM+pV+/893uT4sf/Xtd+Ck/6qdfCvyYt1eEW/3wczb3gx9+
e1H4lh9+yuS+CGA+nxfeGsD7eC33RwDnlbAZwPtjDfdJAH5bJ/zouO6Xj/Hy
xrFPMoTrxrHfeH9wHPdvFP59HL8/NnD/BKEv4+UEkQ/vqw6iP2RvEPqlcz8F
oS/5gRD0Z7ysEPywXnhfCM+TXSGdj4P5Xw7pfbKN+cVNIF/Ws34C58klE9CD
9Q1M4P4XuO8m0L8s4bsn8T5nv9Qk4r8kXDSJevl99yTuY/wfJ6EP81tsYF+w
3ocM6Mn+phj4vfGc8MsG3q/PcH/i/NmnhSsN9DuF+9TA/auF3QbmKZn71YBf
VglfWeCV3LcL/JjwfWGcT+T+DSP+CuHMMO5P4D4O4/fRg8JlYegTz/0cxj64
V3gorKJ/K5ZxX4fRz1jhi2HoH8P9Hcb75U7he0y875Zwn5vQZ5HwOhN+/29W
9ruJ/fOPcLGJffa3cL2p87HcEO5diDcvbJjwyx/CP5vYT3PC8/g+9jfhuyLQ
44pwYkTv87rLwmkR+OGicG4E+v8qXBiBfj8J10bgzx+i/D81thDx
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVln9I3GUcx49Y/WFRFAdZkBmNsFEhCcN/Lp5qZCtjarW5ulbZttxWebNc
m8rSpWxJm7rd3M45p975W8/75Xl33p3f7/diLbAgiKQQ0qAxUCJGxtgfI5/3
8XmDgo4Xz/P9PM/n/fl83s+eqKqp2HeXzWb7Yf1X/ys//pLl+o7VZ1/M0naV
s+D9p5O8W9n9JR+eEzaq1OOtKz+7uX5APe1sf6lLWNWo5Xq7/wL316rV8lie
R3ipTlXE8lq7+f0xnHdJOL9RHXbk7LrMeF+pBa8r1Stc2Ix4fYx/Qq3/beoX
LmtRmbWCxQGe16oa7P7vud91Uu+3MZ7tG+XIWXiyR7ijTcfv5fn536puj+eR
K8KB0+rV5Xo346l2zXaeV92BdS/v24nvB4VvdSL+EO9/FuePCJ86p9qttZFR
5uPWej43Lpx7XrWulMcmmN956O8XHulSP87Pz08x3wtaD2dQuPiiWpd/JcT8
PUrXPyJ8zaN8LkdOlHp06/t7ZoQrL+E+cerTo8+3EsI3elC/JPW6jPNSwkd7
Uf856ncF9TSFN/WpoqKisEU9+6Dvd8LzfbpfXOTCfuTP/e5+xDOodz/ySQs7
B1B/3s8YwDrvv9mLesRYDy/yoR6rXtSHepX5UN+wcMSH/qfeuYM6/0MB4cZB
1IP1WRrU92li/bYNoX8nWc8h5Eu+bxj5kl3D+H5M+JdhXc/b7K/iEbVenjr2
Y88I6sF+to2q/es/7P+9o4jHeb2WZc7rM2NgzmvHGOLz+3/HEI/zUzkO/Thv
yXE9zw6enz8BvTlPLROoD+f5xoT+foFcOgl9OW+BSfQv87P7Ed/HfvMjHudv
0Y/5Iasp1Id6+aZQz2H2YwD+Q94aQP04r9UB+Be5OwB9OL/zAd3vd7M+d8Ct
5MIg6kWuCkI/zrs7CP8iXw2ivzn/t4LoD/KW0EZ/cIZwP/KZEPRm/xgh7Rel
5JshnE/eHN4Yf2cYevC+p8LQl/kmsO6gXqvZ76l3XgT+x3qVRZAf63sios+/
zv6IRBCf/XM9Aj9gv+VOIx/252vTej4LLnLessz3yZ9lvl9L09DzrPBDUfgB
38NtUd3fa6eFj0Tx/rVxPqPar4pOCv8ehf9/zXmdQbwW4RdmsJ/rrhnk1yw8
MAM/Pc55xnpTo/A9MV3f4nrOdwzz/KXwwRj8uo7zHkM9Phf+Kabf82UX5z+O
+J8JPx+Hvp/QD+LwuwPCXXHc/2P6Qxz9tlf4dhznVdEvElh/X3hPAu/He/SP
BPrhHWErAb0q6ScJ9M/bwk/NQv8K+sss4pUJt81ivt6g38zCf14X/nsW9+d6
flL9V+B8YIdwRRLzwngtSbynPC+ahP+8RX9K6vu27RR+NAU/4f1LU7q/S5jf
8RT6z0n/SsEf9gj/mUL/Uy97GvX5QPiVNOpH/Y6m8R68KzyWRv15/mIa8ajf
/XPI/0363xz8m/nWzkF/6uHD+hr51znE4/5NBt6rcuHHjI312Zplnrcjy9Sv
2oC/837NBvKjnt0G+nuXcNjQeth2018N9Cv1/ctAP1CPOwb0p94Pm/A36ldo
on7Uf7uJ/39Q/yoT+VH/BhP1Yn+7TczjR8KTJurPebhqor/3Cf9hIt/99G8T
968WftDS+pRz3rZY8JODwi9b+P4Q/d2Cf30qXGchP87zGQv51AgPW9DvMP3f
gv/XCv+GeL30i5sW6v+F8L0Z7D/C9yGj/ddL/3FkEP8Y34sM3kv6VU0G70cD
348M3j+9/39GwwFx
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVVn1o1GUcP8L6Y0lRHKRBa9GIFRVHgeyfxdMLLUPI7Q8zGIFLa2q2czRZ
m+VmDufS7aa32Z1T9/5y2273/rZ7+f1+V3PGFQSSFEIuSARHhLgQ/5Du+Yzv
R3awjQ+/5/c8z/fzdnuuvrF2z0M2m+1y8Uf/lc+znbdqFlZeeXMNbVX/VdT1
pog/Uu8tt7qTgo16ZfdX70rw+V6lf8cFq0aVKO3cH+X6JtVrrU6FBV9vVsXj
EkG+/5WqKrk6Oi+47LAqQucc9zuivB7P5hnBjg6sn+L+R/F8QvD2Y8pfvdw6
yvM69XmVY4KdxzHPOM8/oe97i++7ulXx+CruX3YSfEwLDpxS+dWKaz7er1ff
5/lZwQ0uzM/7O/rUcqvd7xd8t0/P9y/nNU5rfirIR9cZ8BviPG49n4f8bepX
bXb/pQjn68d+5HtqAHxQD+dZzE+9Kr9XB6tKPqSeNg/4pt5LHq1nO/3g8mL+
tOCd58BfhvwMAmcF3xzE+hz5Oq9qi4QYglsuqLpeq9kkfxc1n3WW4A1DuG+e
fA6pnwuFbT8ILgxpfpaJHcPw14+C3cPgf5F8D0OfS4LrRlTR778SGyPwy5Lg
8lE9j/0y9RjF/sQro3q+x3+iPmOYn+dFgO28/6ZxPCcfh4Ht5PP6OPiiPu9M
YP8Hek6oMWdVN/2xcVLz+TD95JwEP/TblUnsR1w5tX794BTyQ2ybVp8WP/Tj
7mnsF6AfpjVfNTz/ZR/8Qn+6fGqlJnGB/rzjgz70584Z9XrxExOcngEf9GfZ
rPabjX48NrvejzdnkU/6cdscntN/gTmt3z36z+4HXw/85tf3K6W/rvnRP9RH
zeu8Z+insXn1YtGgfL4hgOd8f0sAfqB/GwLrz/MGkF/qXcD6Ct7vfkDzfYP6
O4LIN+erD+rz3+L87iD6hv5YDGJ+8nc3iPnpl5dC8DP5rwuhH6hXTwh5o55G
CPNS/9sh9Af9UR7GfvTTjrDWq524K4w8E6fC8BPxSlj3VTVxaQR6EG+PgA/2
59EI/EkciYBP9v+NCPpvkvmKgl/2+/tR6DHEvEXhn0HB/ij87WH+oujnfsFP
xpC/08xjDHz3CD4Ugx7fMZ8x+OmE4D9i8Pdx5jUOPjoFvxHX/XuV2BmHn7h+
JA4+ud+VOPzA8x5JoD9OMd8J5I3325fAPC7mPQG9OM8vCczvZv6T0GNA8GtJ
zE+8O4n5uX4gCb9wv6Wk5rukT/C9JPTuZV+kMA/v+3EKfuc8rhTuy3mtFPJG
Pu6sYfL1wgLWf8t+WcB+HYK7F+DXI+ybBcz7teB/sH5zG/snDT1bBNemod8h
9lEa/H8pOJaGXw+yn9Lgt1Hw0xnoc4B9lUE/7hP8TQbfRw3sr7XnewT/lQH/
n7DPsuB7l+B3s1jP5y1ZnM/3fVnk+zP2XRb/z+wV/FgO8+9n/+XQH58LbsrB
n1+wD3Pwt1Pwbznw08R+NKAv+XnGwPcF+dtiaL1eJb8fGJivlf1pIJ/Uo8PQ
ehWol9dAPqhn2EC+qXfBQL7oh78N+I9+uW+Ab/rpKRPfh/Sbw0R+ugVvNcH3
SfaxCb6ZrzYT/mK+3Cb4Zh7mTPz/wrwsmuCbefrT1HytnmV/m+CbffSEpb8v
w+fY5xb4Pi/4bQt5vMh+t8AP+67Zgh+4vseCHl7BkxbyzvMNC/yfEfy7Bb05
3+21/ZjfR/PIA/kqz4NP8luVRz9Tjx143tkuuDEPP1Lfrjzuo/H/hZA07w==

       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlltoXFUYhQeJPsSiKAGrYIwYJJYqxUDJS8r2glop2OTBRhgEQw2pPmQs
RHoJakuDMdhmqtPWmaZpkplkJpNkMvf75ZwzNU3ttLVaGlujbYqN0QQRaSX0
oXj2CnuVsVDCxzln77X/f/1rz9OtHc3v32exWM6Y/+Vf9e+jxsptxeXnX1ql
zaIq8Pr8KfI7Ilnd/eG0Yq1VmI/vnObzHcJja+w9o1h0CJfT+fhZvr9T9Bm3
fSXF1ztF91JTw3l+v1ucK5VKFxTXdMn937vI9T4VlbPuv39QvGGfaDYFXeL6
+7HfZcVbD4j6+vrILPfrFnvNBa8otn0uirfr5q5y/y/k+rY5xfZeeZ7KX6nn
S7HclBy4pjh4EPrnqa8P+m8obrdD/2/Ue1hYzQLcVLxyGPX6nfq/kutX/6G4
52vo/5Pnccjz3r+keO0RYfZrdpHnOwJ9C4p9R8v3tx0T5uvPUF/DNzg/z2Nx
in/rrH2/KJ5xiuesfS//zHq4oP8nxS3H5Xpu1rumX+rZxn4s9kMv+xU8IeuV
ZH93DcBP51i/k9BHv1QMwn8zrOcg9qP/SoPy+6VvWd8h+IF+dAxhPfpxZUie
x/hOsXUY9aEftWEh/9CPtW7Uk3p73KgP9S67ZX/qud5Wj5jfUxUgRz3l51k7
gu/JXSPQT74+Ikz7NVLPq6M4D9k3Cv3kNV7MA9nmFW+YAqjvklfOWx25wQe9
5H6f1PsC2TIG/5G3j6Ee5Jkx8VT30kXut94v581Jtvvl8ybyLT/ygedrGcf7
5Ow49JFrJpAPrN+BCcwzeXFC6vmM/dwyCf/TH8FJ6CdXBaS/rfTDrgDmjf6Z
C2A/+kdMQT/ZM4X68v2KoKyvg+tvDKJf1NcehF95Hlew3C+l1ffpp7tB9P97
+jeE+nBeWkMyT7Zwnhwh9IPzNh3CPDHfVkLIL+bbujDyjvlmDcOf/P5QGH75
kf4Py/nupL5/wsgHnqc2gjzg+d+OoH68H3oiyEtdcToCPTnOSwT9SimujiI/
45yfKOYtrHh/FOed4jxF0Z8JxQtR9Gec8xXDvJDfjMn6P0zuiqH/fsWBGPJs
jPMXw/rkR+PQ4+M8xtFfr+KP46gf2RfHeUYVX41jvRHOawL56FG8KYHnbs5v
Av4YVjycgP+HOM8J+OWk4geSqP8A5zsJv59Q/EES+dvPeU/CXy7F55PIJyfn
P4XzHlP8Ygr1JW9PSX05vn80BX8fZz6kyve/k0K+UO/6NPrJ87ybxn3J89rT
2J/1MdLwD+t5Kw3/sR/PZlB/9rMlg/6w370Z3J+TzJsM/EE//ZVBP0LMnyzy
KKK4OYv8ijKPstBLv8az0JtkPmWhN634iRz0ZplXOejNK/4kJ9ra2hYKzK8c
5pnzcyMHv/L3WFUe9WU+vZZHfe/lWx79Zj7685g35tNcvvz310MF5Pm9+7eA
5+SdBeQd2VMoz7PL/3teoZV//6Qm8+c0eaOGeSO/peE+4n3brsl67yHv01Bv
sgvr1zGfIhr2J5c05A/z9KaG3wv8/q6G/GOePabDH8yzDTrqz/puXn1uMI91
fM9+7dWxPvvr0KGH+Tapw2/0y7QOf9Bf13T4L8j8xv4N9OsjBuaf/l5nwI+c
h1cM9I/5YQU3cb46DfiDzw8ZyEPmkddAnnA9zYB/OH9XDOT/IO8DrBfgfD9Y
xPmYJ7VF7M+8aCziPnbwvihiP7vijiLqe5D3RxH97zX5Pwz1ShA=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{1182.5242718458123`, 980600.}, {1200., 980599.64}, {1250., 
       980598.58}, {1300., 980598.14}, {1350., 980598.92}, {1400., 
       980599.7}, {1419.2307692330653`, 980600.}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQPXGZZvYpn/kOQCbDhze6jiCagWWBQ7XIuuNvYPyM
BQ7yra8DX8L4ZxY4iKxzf/gUxjdY6LBDrjX7EYw/ZaED1/XFH+7B+D8WOgCV
V92G8WMWge27AeMfWOQQBDTgCoyvsthhSYEt10UYv2Oxg2ZMvxOc/2Yx2P5L
MH7AElT9W5Y49B/6qnENxpdY6nD2zJkz12H8mqUg9xXchPEfLHWYNXOmJNx9
LsscgNJ778D4K5Y5pAEB3D88yx2+acTwP4DxC5Y7AINnx0MY/8pykPsSH8P4
FivA/oGH15wVDsbGxpufwfgMK8HqX8D4KSvB5r+C8U+sBJv/GsbXWQV2z1sY
f8IqB4+HVSLvgXzFnQY8h4+tgscnALkRpN4=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/eiwUobF9w0OQCbDhze6jiCa4d8Gh0JbruvvYXyD
jQ7XFxfYvoHxkzY69B/6uuIFjD9lo8M3jRj+pzD+sY0OMf2HSh/C+D82Ohz+
qnHnLoyvtckBaLzybRg/ZpODyDr3h3dg/L5NDrNmzpx5D8Y/sAnknvAHMP6n
TWD7HsH4Kpsdzp45c+YxjB+22WFJgW0X3D0dYHmf5zD+LrA810sY/w1E/ysY
X24LWD/cvwFbwPrfAfnpm18s8m7YAg8vACwfeEA=
       "]], LineBox[CompressedData["
1:eJxV009oE0EUBvBF9BJBEQKiYFUUjaIiBsRL4KlgFQvaHMRDEAwqgodWQZEU
RMGA9GA9VDEVCtJAS6GlEAjZJJvdnUWtGKv1T2M1UlNpqaRWESviQdx54Xtg
IGx+zGbmvW9mNsbbomeXGIZx1P/qZ/b41ivxpznyfxrf53fu109jLEfB4eba
N9gw9fj1BXiPSen2SOArfMakaK4pWYfvmRTrUotf4FFTz3d6Dv5j0vpkfXwW
3pGnSl97ZAY+ladwOJz5DN/Jkz9daBpWeaolgsOf4J95StZb903BWwr0vFwu
f4RPFijgL1CFOws035pr+gAXC3QxEqhMwgsF8tn3Dt5QJD+ORAWOFumc/5mA
bxbJWwzF3sLZxvgbeK7I+b2G11q6n4FXcIvFeY/D1yzd3y7xiKXz7nwJT1uc
7ws4WOL+xIdKvJ/iqyXqSaVSY/BgiTr8BcXVkt6/ZeIVNvcrJlvn2SLrX7J1
Ppuk/rTN9Uh/E7ae/4nksdTRefdKfuscrlfy3uvQtljXAdmPY46ud43s33mH
8xDfcLie93CPQ/7xuyDzZxw+j5J/2aHDtUS35Dnj/J/nX4d+hWIrZXy1y/sv
3u1yfdLvEZfPr4zHXb3/Vcmrw9X7P/sM7nZ1ffVReKjhR/DjxvsKnnL5PNjw
78Z6RXiV4nxNeLvi+5KFDyrOOwPHFOcxAl9WnNcQfJvnax6E+xXft37YUXyf
BuBJxfdV3v+h+LzL+8s9zjcNb/Y4z4dwxNP/t3rhEx7P/wBu87jf+/Atj+/n
Xd//ABJdppU=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{4419.444444437258, 980600.}, {4450., 980599.89}, {4500., 
       980599.74}, {4550., 980599.62}, {4600., 980599.52}, {4650., 
       980599.45}, {4700., 980599.41}, {4750., 980599.39}, {4800., 
       980599.4}, {4850., 980599.43}, {4900., 980599.49}, {4950., 
       980599.57}, {5000., 980599.67}, {5050., 980599.79}, {5100., 
       980599.93}, {5123.333333330746, 980600.}}], LineBox[CompressedData["
1:eJw90k8oBHEUB/DJn8sqpbbkQInkT0opt62HhFKyB6c5KZPbSrmsk8OWHOzF
Zffgslsku2TJprb5zW9EMoS0i+RfrcT6kyInmXnbd6am33z6/ea9N+9N/VjA
P16iKEqbfTtrU/Csr7pUJ/tR+Sy0dzurUqlTixqWHzDpVBhJL73DUzp5crHJ
NziuU6d9FeCsTpqmPb3AZYLPP8O1gsLyeyUPdwkyv5tvHuFhQf50Xfk9PCEo
XRd6vYVnBdnhMu5+VJDPk2twneJ4qnve4nihGzjP52PX8J+gh6A3eQlXG+ws
3GFQNBKJXMCDBiX7H4Ln8JhBx5Y1dArPGDRgBziBF3nfOoITxfcP4X2OX3MA
3xXz78G/BvdXwlXScUqHWyV/fwbulfTTrIZ3YVVy/3bgaenMt2cbXpAUn/TN
b8LLkutdhwXvexLwleT5rcJfkvu7BleYzvy1JNxocr4N2GdyvW6+UZP/vy04
YJLXbpBb35zJ83bq/wd/L/Ch
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw90j9IAlEcB/AjarEpEKIhIWq4giAIouXgFw0WCKFDLU5C4qYNLQpFgxAN
ubjo0JJQiy4tbvf+QC3X0h/NssxKKzSIwAiC7L0nv3dwvPvAu/v9ft93Y6Fo
YL3PMAxT3HKN/Ha721s2iEfjsz29IFcjZ0MwxTof6JINyZZ/voXuJ5CLWXvv
6FECbX/R84aeI2C5yodN9AqBbCYz0kBHCASKnuQzeocA75jVOjpLYKkeTz+h
T9T3xvV+h8C54/ge0Q0ColzsHv1H4NsMpm7RwxTEOMdl9AyFSTHgFXqZQjgc
bl6gQ1TVv0QnKCTcBa/en6Zyftc1Ok9lP472KZV5HJTQNar60/V/1H7fDXqI
way4KugppvLS/S8yVe8OHWQyv4EqepOp89Pz7/f8gD7qvV9DEybnc+v8Kkzm
Y+r8vxiIdi2d/yCHDcu1pvOf4FDw1uMvaIurefX5rnKZ15k+/yhX/9Mreper
evL/+QflwuVo
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{8318.978102190526, 980600.}, {8350., 980599.15}, {8400., 
       980597.77}, {8450., 980596.39}, {8500., 980594.98}, {8550., 
       980594.2}, {8600., 980595.12}, {8650., 980596.03}, {8700., 
       980596.95}, {8750., 980597.86}, {8800., 980598.77}, {8850., 
       980599.69}, {8866.847826089226, 980600.}}]}}, {}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        GraphicsBox[
         {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          CircleBox[{0, 0}]},
         ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{0., 980384.25}}, {{
       1132.31414, 980195.52}}, {{1035.258643, 980199.3}}, {{2264.628281, 
       980159.5}}, {{2264.628281, 980424.34}}, {{3396.942421, 980122.72}}, {{
       4852.774887, 980076.04}}, {{4852.774887, 980477.26}}, {{8087.958145, 
       979953.}}}]}, {}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{795., Automatic},
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6897582819249187`*^9, 3.689766954561593*^9, 3.6897670054188423`*^9, 
   3.689775193414773*^9, 3.6897775979500437`*^9, 3.689779174524036*^9, 
   3.6898620778029575`*^9, 3.6898622113551245`*^9, 3.6898627765411787`*^9, 
   3.689863117573105*^9, 3.689863193589672*^9, 3.6898712746233644`*^9, 
   3.689964133975129*^9, 3.690015752134195*^9, 3.690015816408946*^9, 
   3.690022344305127*^9, 3.690022453694267*^9, 3.690026886731268*^9, 
   3.6900279200655456`*^9, 3.6900347365579576`*^9, 3.690746395681652*^9, 
   3.69074644734879*^9, {3.6907477170819874`*^9, 3.6907477375244737`*^9}, 
   3.690827332474595*^9, 3.69083046619516*^9, 3.690830797894628*^9, 
   3.6936011676986027`*^9, 3.6936017497346087`*^9, 3.693602673400728*^9, 
   3.6936029763345647`*^9, 3.693773068586505*^9, 3.693773591223937*^9, 
   3.6973112085664177`*^9, 3.697311257301487*^9, 3.6973115884697447`*^9, 
   3.7591700325419073`*^9, 3.7591705702588634`*^9, 3.7591712593821383`*^9, 
   3.7593495919047723`*^9, 3.759410240078637*^9, 3.7594110047342777`*^9, 
   3.7594190368729897`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "Reading", " ", "the", " ", "transition", " ", "dipole", " ", "moments"}],
     " ", "*)"}],
   FontFamily->"DejaVu Serif"], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"dipsp", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Import", "[", "\"\<dmjp1.dat\>\"", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dipsm", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Import", "[", "\"\<dmjm1.dat\>\"", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dippi", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Import", "[", "\"\<dmj0.dat\>\"", "]"}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6897592221440983`*^9, 3.6897592413914747`*^9}, {
   3.68975954032098*^9, 3.689759548367297*^9}, {3.689764112346964*^9, 
   3.689764115230762*^9}, 3.689774888878646*^9, 3.6897749367364206`*^9, {
   3.6899640179244328`*^9, 3.689964031089351*^9}, {3.689964066721018*^9, 
   3.6899641013962336`*^9}, {3.69002244193467*^9, 3.6900224435811825`*^9}, {
   3.6907454330874147`*^9, 3.6907454382989826`*^9}, {3.690747682584258*^9, 
   3.6907476899205484`*^9}, {3.6908273080090957`*^9, 3.690827314859447*^9}, {
   3.690830426408503*^9, 3.6908304322346735`*^9}, {3.693600307513239*^9, 
   3.6936003135252028`*^9}, {3.6936010332555923`*^9, 3.6936010656688967`*^9}, 
   3.6936015844264574`*^9, 3.693602565062847*^9, {3.697309662718015*^9, 
   3.6973096734027777`*^9}, {3.6973108096281304`*^9, 
   3.6973108286040792`*^9}, {3.697311240130667*^9, 3.697311252319934*^9}, {
   3.759171303032524*^9, 3.7591713483048463`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Defining", " ", "the", " ", "transition", " ", "dipole", " ", "moments", 
    " ", "for", " ", "parallel", " ", "and", " ", "perpendicular", " ", 
    "polarizations", " ", "of", " ", "the", " ", "magnetic", " ", "and", " ", 
    "microwave", " ", "fields"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dippsp", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dipsp", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nl", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dippsm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dipsm", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nl", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dipppi", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dippi", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nl", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}]}], ";"}], 
   " "}]}]], "Input",
 CellChangeTimes->{{3.689861501031513*^9, 3.689861519598536*^9}, {
  3.6898615849604497`*^9, 3.689861655790004*^9}, {3.6898619343171005`*^9, 
  3.689862039326576*^9}, {3.6898620856502132`*^9, 3.6898620917303567`*^9}, {
  3.6898627666458206`*^9, 3.6898627707020783`*^9}, {3.689863069023759*^9, 
  3.689863071424223*^9}, {3.689964108403802*^9, 3.689964115417404*^9}, {
  3.6936010737843122`*^9, 3.693601089437233*^9}, {3.697309679390211*^9, 
  3.6973096962263947`*^9}, {3.6973108471173515`*^9, 3.697310889202569*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", 
   RowBox[{
   "Rescaling", " ", "the", " ", "transition", " ", "dipole", " ", "moment", 
    " ", "so", " ", "as", " ", "to", " ", "make", " ", "its", " ", "small", 
    " ", "values", " ", "easier", " ", "to", " ", "appreciate", " ", "in", 
    " ", "the", " ", "plot"}], " ", "*)"}],
  FontFamily->"DejaVu Serif"]], "Input",
 CellChangeTimes->{{3.689778129989788*^9, 3.6897781934657187`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Log", "[", "x", "]"}]}], "+", "1"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"dippar", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "==", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"dippar", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "=", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"dippar", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "j", "]"}], "]"}], "=", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Log", "[", 
                RowBox[{
                 RowBox[{"dippar", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", "1"}], 
             ")"}]}]}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dipper", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "==", "0"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"dipper", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", "0"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"dipper", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "[", 
           RowBox[{"[", "j", "]"}], "]"}], "=", 
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"dipper", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "+", "1"}], 
            ")"}]}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "ni"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.689773813616861*^9, 3.689773853850999*^9}, {
  3.689777120649235*^9, 3.689777151997178*^9}, {3.6897772145737605`*^9, 
  3.6897772506990986`*^9}, {3.6897773507014713`*^9, 3.6897773635452323`*^9}, {
  3.6897774176814575`*^9, 3.689777481993497*^9}, {3.689777542089142*^9, 
  3.6897775700610666`*^9}, {3.6897781992553186`*^9, 3.6897782603028364`*^9}, {
  3.689778328488655*^9, 3.6897783294853973`*^9}, {3.6898621077171373`*^9, 
  3.6898621428792686`*^9}, {3.689863075186725*^9, 3.6898630795651646`*^9}, {
  3.6898709573414035`*^9, 3.689870959555177*^9}, {3.689964119927258*^9, 
  3.6899641251592093`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Plotting", " ", "some", " ", "the", " ", "theoretical", " ", "data", " ", 
   "with", " ", "a", " ", "shading", " ", "proportional", " ", "to", " ", 
   "the", " ", "transition", " ", "dipole", " ", "moment", " ", 
   RowBox[{"(", 
    RowBox[{
    "the", " ", "larger", " ", "the", " ", "dipole", " ", "the", " ", "more", 
     " ", "intense", " ", "the", " ", "color"}], ")"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.689778283700467*^9, 3.689778292090191*^9}, {
  3.6897785965540504`*^9, 3.6897786684251847`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"P3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"Linesmt", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "Large", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"1", ",", "1", ",", "1", ",", 
            RowBox[{
             RowBox[{"dippsp", "[", 
              RowBox[{"[", "j", "]"}], "]"}], "[", 
             RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "10000"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ni"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2", ",", 
       RowBox[{"nl", "+", "1"}]}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.689765442976636*^9, 3.689765482363874*^9}, {
   3.689765758476636*^9, 3.6897657802485404`*^9}, {3.689765865502999*^9, 
   3.6897658671462183`*^9}, {3.6897659408154545`*^9, 
   3.6897659823164263`*^9}, {3.6897661125561743`*^9, 
   3.6897661517897444`*^9}, {3.6897663388946514`*^9, 3.689766375055061*^9}, {
   3.689766410129312*^9, 3.6897664251633506`*^9}, {3.689767019465727*^9, 
   3.6897670485743003`*^9}, 3.689775158755275*^9, {3.6897758729539986`*^9, 
   3.6897758936783495`*^9}, {3.6897759287794333`*^9, 
   3.6897759541271763`*^9}, {3.689776681404955*^9, 3.6897766820303097`*^9}, {
   3.6897767615147*^9, 3.6897768002217093`*^9}, 3.689776838045933*^9, 
   3.6897770379006095`*^9, 3.689777589197672*^9, {3.6898621550612965`*^9, 
   3.6898621561497765`*^9}, {3.690015800845811*^9, 3.6900158011354685`*^9}, {
   3.690025848382267*^9, 3.6900258484990807`*^9}, {3.690746382962504*^9, 
   3.6907463891885943`*^9}, {3.6936011149898386`*^9, 
   3.6936011164132757`*^9}, {3.693773573433371*^9, 3.693773574334342*^9}, {
   3.697309706995324*^9, 3.69730970933099*^9}, 3.6973108531540985`*^9, {
   3.7591713736244164`*^9, 3.7591713831950502`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P4", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.000000", ",", "980231.540"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.000000", ",", "980384.250"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1132.314140", ",", "980195.520"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1035.258643", ",", "980199.300"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2264.628281", ",", "980159.500"}], " ", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2264.628281", ",", "980424.340"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3396.942421", ",", "980122.720"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4852.774887", ",", "980076.040"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4852.774887", ",", "980477.260"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8087.958145", ",", "979953.000"}], " ", "}"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"PointSize", "[", "0.01", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10000"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"979800", ",", "980600"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "10"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.690745482406515*^9, 3.6907454824075174`*^9}, {
   3.6907455276637845`*^9, 3.690745748047203*^9}, {3.6907459744814377`*^9, 
   3.690746085269845*^9}, {3.690746129904201*^9, 3.6907462273336515`*^9}, 
   3.6907463743074493`*^9, 3.697309649120573*^9, 3.697309930336913*^9, {
   3.6973102169768295`*^9, 3.6973102669898157`*^9}, {3.697310329541659*^9, 
   3.697310343859923*^9}, {3.697310562069584*^9, 3.6973106164171777`*^9}, {
   3.6973115625457244`*^9, 3.697311562708366*^9}, 3.7591714978802547`*^9, 
   3.759171541383729*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {
    {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox[
       GraphicsBox[
        {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
         CircleBox[{0, 0}]},
        ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{0., 980384.25}}, {{
      1132.31414, 980195.52}}, {{1035.258643, 980199.3}}, {{2264.628281, 
      980159.5}}, {{2264.628281, 980424.34}}, {{3396.942421, 980122.72}}, {{
      4852.774887, 980076.04}}, {{4852.774887, 980477.26}}, {{8087.958145, 
      979953.}}}]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 979804.},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10000}, {979800, 980600}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6907460679870567`*^9, 3.6907460804769535`*^9}, {
   3.690746210672284*^9, 3.6907462277703514`*^9}, 3.6907463748069315`*^9, 
   3.6907466006179295`*^9, 3.6907479337498693`*^9, 3.6908278175538297`*^9, 
   3.6908306161020575`*^9, 3.690831182003217*^9, 3.6936013215992575`*^9, 
   3.6936022541279864`*^9, 3.6936028615299077`*^9, 3.693603258370516*^9, 
   3.69377320732211*^9, 3.693773740540694*^9, 3.6973099316463456`*^9, {
   3.6973102187921534`*^9, 3.6973102683821354`*^9}, {3.6973103325792255`*^9, 
   3.6973103445117445`*^9}, {3.697310563753291*^9, 3.6973106167327533`*^9}, 
   3.697311410488013*^9, 3.6973117388921847`*^9, 3.75917161305005*^9, 
   3.759349766960122*^9, 3.75941039322648*^9, 3.7594111628839417`*^9, 
   3.7594195575191374`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  SuperscriptBox["\[Sigma]", "+"], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.697311101221385*^9, 3.6973111038859215`*^9}, {
  3.6973111400141726`*^9, 3.6973111567567396`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"P1", ",", "P4", ",", "P3"}], "]"}]], "Input",
 CellChangeTimes->{{3.6897662670344133`*^9, 3.689766320858626*^9}, {
   3.6897756833393536`*^9, 3.689775684090374*^9}, {3.689777005257166*^9, 
   3.6897770103794265`*^9}, {3.6936011255754614`*^9, 3.693601132503233*^9}, {
   3.6937730601264687`*^9, 3.6937730606205654`*^9}, {3.6973107292470455`*^9, 
   3.6973107303162956`*^9}, 3.6973115663829412`*^9, {3.759172328471125*^9, 
   3.7591723290636673`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw91g9M1GUYB3B02Bw4WcZM3SRdVMTIUS5jLezVTKPRRNzEjNhgwDDdIItM
YZgkBSwE8xRBROD4L5zAHXfH/ePud+W/nS7LYjotqBQSSqfCkKV17/f2fW9j
7LPf3fs+7/M873O3PCM3OWt2UFDQef+f/M9XfMjQs/Nvv7QmoASx0v8KVX5f
vJhauXYu7c4QF32+xDnq+XbxTMn4ptm0yBUfx4ek/PcX378L/pcezsf7H9JB
e7DeFL2sEPvdp8U+4X973F06dr+o1Caj/lbrF4t3RvaG36aTDgj5b1TtVyKy
s7Nv/UHnfS338w2r/cvkeY036KpyMRWVWnlNxfONCBnS5w3RPRWI94qKr1LI
/F2mc6qEYcPIzEUV7yHsd4GePiQmNlnrz6r4v8X639Glh4Wf8R51Hp1ozosP
cdGLjsj8Xbap8x0RtTU1NRa6/agIN2xIN6nzViO+XjruGPLRrc5fI5/rO+lz
Nfh8m8pHrYw3opneelzWc6hB5acO+TpBj9WJAv8CtSpfJ1CPavrzeuT7sMrf
SexXRQc3oJ4VKp8Nsh+0MtrXgHx9pfLbiPi+pHWNcv+z+1S+G/H+Qjq1SeZr
8R6V/yaZb2c+HalHPLtUPfQi2RoxJ5ee0Mv+a9+h6tOMfsihTc3CGlEynqnq
1SLrV55OF7agf9NU/Vpwvm30ulbsn6Lq2Yp+2kzPa5P50SWp+rZhvffoK21Y
L0HVux33bz1d14741qr6d8j6fPEmndmB/L+h+qED/RFHx3TiPr6q+qMT+X6Z
ftCJ/VaofjmFfoumHadQjxdU/3ShPyLpA13I1zLVT12IZymd2I37s1j1VzfO
v5AONwj/2w0LVL8ZEG8Yfd2Aeoeq/jsdmG9082mcJ1j1Yw/qO4te1YP792iM
/QlvmqFre3A/pmgfnHKffhx4foeO7cXzCToDHhqjdYHnN+kzgecj9HQv9v+V
ju5DfNfo1D7EP0Qf7MP5fqLdfTj/D/S9PuTHR0cakb/z9BYj7u/3dKlR5nuF
RtuM6BcXPWHE/bTTESb0r4VOMmG+mehiE/qxhzaZhL+dJ7voWybZvzs66EX9
8r6MtNDv9iNfTXRhP85bTxv6MV+P08P96JdqeoEZ81JHrzMj3ir6MzPmQQXd
bpbx5ZfR18zo9xJ6ngXxFNOrLYiniM6zIL8FdJMF+dtNX7Gg/z+ln7AiP3l0
nFXep7s76Y+swjsZlbqdrrNivyz6khX7ZdBBA9gvjX5lQM7zsA/ozAE5f/am
0EcHcL7N9LkB9F8SPTMg17cm0jE25DOBTrPh++JtusqG+q6hNRvm32r6gQ3x
v04/b8fvk9forXZ8/62ky+0yP0GxtMOOfomh/7HjfkTRyxzIx3N0sgPzZTl9
wIF6R9BmB9ZbQo85sN5CeokT6z1FJzoRXxhd5ER88+gep8xn9lz6d2dg/tDh
LtyvWfR6F/L3aJTzzYX8PaQ7Xei3Kfq6C/W4R88fxH28Q4tB9NM4vWsQ92mU
bh7EfPiT/mUQ/TJMB7uRnxv0UjfOc5Ve5cZ5fqY3ujGvf6Rz3Jj3l+j9bnw/
XaBr3ZhfZ2mjG/fVS/vw+RA3fROf3+GgH+PzPiv9tAf799OxHuzfSyd4Ar+P
6AwPfs900gUenL+V1nlQTz3d7UH/nqTPeDBPj9O/efD74xg97cH90tFPapjv
VXS0hn6voN/SUP8yOlVDvkrofA3xFtMHNcRbRLdpiLeAdmuYF7vpqxr65RP6
nob5k0eHevH9vZOO9CK/OXS8F/c9i97iRX+l07leud/1D+lSL863ze//AQED
/1A=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw91Q9MlGUcB/ArKbezLB3lnyXidIZEaDqNubDHSEWHU8kpTtJ5qQOd83Ka
Jk6RQSHTwEQUREXvFEQ47zoO7i93997mn3a5XCZmNDEXEBpLJ0XMXO/zpe9z
m7jP3vd93uf3e36/3zvBtDVzw/MGg+Ga/k/+z5+xzfLn5p635w5qofguGo1u
Ul4lrObUklw6ZBKlWl9CjrqeK123kRZb5f3GDer+beLTVOPKT+iOHSLTHVe0
Tj3/uaiqrKxcS8fvgT9W6+3D/avpafux3iq1foG8f8xKemkh9r9cva9I6I9v
zqTNXwrbgnsDS9T7Dwj9T/5iuqxEZOsBLVL7OSgifQnZ6bT9kCh6sMw9T+2v
FPGm0TllYrx+g1D7PSz+SsguTaX7D4sp+gtmq/1/LWT+36WLj4j0e7tjZ6p4
ysUM/TedHn1U5MXaFkxV8R1FPpLougqhX143RcV7DJ5MpxyHJ6r4K/F8PH21
UuYvY5zKR5Vos5hTx9JZJ0SqsW3iKJWfasQfS3dXy3w/eFXl6yTO42V61yn5
vMWo8ndansfuoXRMDfIXo/JZIx4uc8c9R0drsP6/vzO/Z3AeA3T5GZzn33T/
GZnvD57Q2WdlPb3wiA6dxXn8QU+y4Pkeutgi10/poh9acF736aVW1H8H3WRF
vfxCjz6H/Nyh95yT+QzcojvOoT5/oD88j/P/nq47j/uj9Eu1YqP+u0aba2V9
vXKZvlkr68Wp0Sl1ON8gXV2H+vbRhgvoNze9/gLiddFXL8jzuOGgk+pl/GYb
XVaP+C7ST+pxvrV01kWsZ6X9F7FeDR3fgHhO0oUN6M9KursB/VNBZzSiHo7Q
9kahp8tWSsfaUK8H6V021F8x3W7D+RTR4pJ8f+d+2npJ5mfHXjrGLuvBkEfP
smMe7qRz7Mj/drrKjnya6agd+91CP7MjP7mqfh2YpxtpkwPxmFQ9O9D/a+nL
sHO1qm8H8ptFJ36Dfliu6h1OWUZ/NXh9sar/weuL6MeD1+erfnDi/Wn0Ctj5
vuoPp9xv8nu014l+SFH94sS8mEnHNcl8nHpH9U8T5ncyXdCE805U/dSE+nqT
7myS55E/UfWXC/Uynl7kQn2+ofrNhfMdTdtcOP/XVP+5UI8j6JHNmK/DVT82
Ix9G+rNmxDtU9Wcz4hlC32lG/xpUv7bg+/W0+3/PaUH/9dPmFtR/H322RfZr
2yP6Zgv200u/6MZ+eugUN+qni97klu8vv09XuzHvOujrbtR3O23wyO/Bvdv0
dA/m/4/0eg/mzw26woP3XaevevC+b+kBjzwfwxU6yYv5FqHXeBFfkC7zYj77
ac2L+nHTT7zIp4ue7MP5O+gsH863kS7x4ftRT/t9yNd5uteHfrTQ8X7082k6
04/5foIu9GN+Hqeb/chHOd3tR30fpscGsN4hOiOA9Q7QewNY7wvaHsB6BfSv
AexvHx3bivrJo+e34vu3k97VivPaTte3oj/NdHsr8reFHh7E9zaXFkHZD+0b
6G1BzE8TbQ1iXq2hbwVRT6vpmBDqdyU9LiTr9cpH9KwQ6mUpvSSE/GTQOSHE
k07vDyGeeXRVCPNwLu0MYd7OoaN4fvNs+jc8H51FP8PzyTPoUWHMl6n0tDDe
/xa9MIz3J9CmMOpxEp0XxjyaQJeHEf84ujGM+MfQl8Ooj9fpu2Gh/80fSfeH
0X/D6REa8j+MTtTwPRlKp2mYH0PobA31bqB3aMjX0y7Oew35+oeu1ZCvPjqk
Yb+P6J807LeXfqyhXnroYRH0byc9KYLvw306NYL83qVXRJDfn+mtEcyz23Rx
BPPzpu7/AFQHCXg=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxV1g1M1GUcB3CWxhZpZaNJb2hJRYyIYjHdoj0lyzRmwspwXdYIibQJsuF8
oUQGgWiCBOQRKC+HnLwcJ3fcG3fc/+4UdV2uGsUsVmiLUMilk8asafd88fuw
2OD22cP/eZ7fy/P877GsvIxNd4SFhZ0N/cpP/uiq/NPa5WdentVqkeGILpvz
BnFhV2SCspYl5P971fhHYknZ5HfKIk/sjjSdVtYK/j8+VigiRtr+mnt+pwhN
F6vmX1okx/OVxR7Mp5y4F/vxqflLREroAeV1pZjPr9YrE2WT6Q7l/HK5n/SA
Wn8f4lGursR8J9V+DohtKRFvn6LNn4vXQhsYUvurkuMjyrnVIikpyaKeTzwk
83mnWn/mkIxn1Vx+apBvN13xBfbrVPHUitC/X7DRUXVCflhVfHWiQa9/8ARt
rEf8JhXvl3I/SV308sNy/uVGFb8ebqfP6JHfVpWPBjGV7og+Smd+Jf6O1d3b
qPLTiPwdpicaRWA6drRO5asJ8dTQO47I/NVWqfwdFaHwtxyg5zeLp3VVr+xT
+WzGep/RwWbMX6Ly2yLjNe6ha1swX5HKdwvi2UnrWtF/hSr/rXLcVEDHtOH5
PFWPNtkPyz6mp9pQ71xVH4Mw5KdUbqKtBhFq35QsVa92Od/kRrqoXdZL/46q
Xzv6IZNOPYb9vanqeQz5SqcXdGD+taq+HeiPNfRwh+yP4lWq3kbsP5VuNMr8
+oWq/3GZT10KnX1chKa7sUL1w3Gsn0zHdyKfSao/OnE+n6Wvd2K+eNUvXYgn
lnZ3od+fUP3TjfP0OF3ajXpGq37qRn8+TKf1YL3Fqr96cD4j6UgT8nGf6jcT
6rmQHjWhX+9S/deLfIXThl5Zz4h5qh/Nsv+qbl267WQzztu/dK5Zno8jM3SD
GfmepoNmxHOVvgnHXqETT6D/LtNZcMIfdO3s+G/00Oz4GD0zOz5Kx/Vh/Dyt
g00/0Af7sP73tNaH++4cfa0P5/1rOsaC+E7T6y2o10m6woL8aLTLgvx56CkL
8uuko63or356nRX3fR9dYhU5OTnjJtpqRT910eNWvE866Kh+nB8DvaZfng9P
M13Uj/uviTb1I149PdaPetbT99twnmvoVBv2e5DebkM/7aeNNtxH5fRPNvFN
MJhWSi+wYz/F9Et21OcTOt+O/O6kW+3I33Z62C7X31VAhzuQn630cgf6fwu9
2YHz/SHd6MB62fQ5B+6f9+kwJ95P79LPO1GPDXS2E/G9Rdc7ke8M+owT/bWW
vuFEPl+n410476vojS7chyvpahf2L2i/C/l6kb7uwnlaQT85gH57gc4cwHl+
jq4cQL8k0O4B5COOvjKA/n+KXurGfMvoDDfmW0KXujHfI7TNjf1F0RNu7O8B
+iEP+mcRneZBvAvpTz34/hFBmz34vhBOX/Qgf/PoyEHU/9bEbb86iPvtH3rH
IN6XM3TnIPr7Oj06iPpepe/xyv7J+ZMWXtynl+gCL/IzThu8iOci/aMX8fxC
z9fQ7z/Tj2rohxE6WcP7e5h+Q0N/fUvn4vlgkN6L5xPO0g0a1j9FWzSs76OD
s+sP0r9ruG9d9E08H2GnF/sQv4VO9KE/eunVPtSzm87yidDfYiO924fzYKBr
fXg/tdA9PpyvJnrIh37S07/6UP96esaHfNXQi/zYbxUd58d+99Mr/dhvOa3z
474upQv96Jdi+qAf92UR3eGf/T5Ea1ivspA+j/XGt9HX/Pi+sZW+O4D4NtMx
AcSXQ6cEUI8P6PUB1OM9Oi+AftTRFQGcr8yQ/wO1PSFN
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw9lg9MlHUYxy+nrsjK6jbNFpKZQ6eNyjk2R/7Spul0iSuldesPmWmuuFiU
ihk6WGomqKhBSPyVA/H4c8dxHHfw3nulUKdpmqSSAgmCWDmHxmxZ9/va93k3
jn32vu/veZ7v831+v/fx5JRl74ywWCztkT/9n5c3Omvt4JUZz9+hhap7g9V5
RfhVdSwcDg+QjWRwv9xfo7LNG47LZJWiVkWuPnk+VS3zRo/qJXelqchvxm/y
/npldS7o7ibHbFQJUR1PdMl6n+l4iy+Q4zar0I1YW6esv0VNzBpMPEdemqme
jVy/SLwsHc9yhmz/XEUe956S+Nuw3klyznYV1VF67bjks0PZss20MLn2S9xv
l/yy1YcJUSuOklfn6PxLheN26eftbeThXWqqLXuuvG/sVvl5eY98T966B+sL
L82F3j+Qx+9FfySfrr2qzJ6w/RjZsQ/xJH/7fujzIzn+K11//AmpPw/xpf62
POj1k+iRr/vZJ5z0tUq3Oo+KfjEFyOc0ub9A3Yy1Zf8seh1APqL/ukLk0yH6
faPff0r6NbJIv//AWdGzCPGFw0VaP1P6HVes8887T84tVtrP4o/hYhUJn/Ar
2Vai9YoSPxklun8dwpNLsd5F6Uep9udb4serpepqojda/Lq0TPunU9hdpl7s
3pDbI/0q13otEL9vLFcRu98S7iqHXy6RXzgI/eW+46COVyj5jKlAPVKfvQL5
i36nK1C/6B/vwPxJ/wocqE/8YamE/uKvlZXQV/zbVol+fUueXoV+GOKPKsxH
gDxUhfx94pdD8IOH7D8Ev7nEP9Wov4acWY18qsVP1ZhXB3nxYcxPufjrMPxY
TLY6sV8Uit+cOv+T+eROJ+Z1v/ivBvrtIZfVYD/IET/Wor87yLPAtm3izzv3
s8j5d+5vEb/WYv1N5NvgFeni3zrk9wk5uQ75fyR+rkN9dvKROtT/vvi7Tvsh
sIY8rR7zvUr8Xo/5TCbvrNf7dewb4v96+Os18vV67V9rksyDC/vLy+TlLvQ3
UebDhf4vIftc2n+DC2VeXNBjPjnajXrnyvy4Uc8c8hY3+j1b5smNfOPJfW74
d6bMVwPm+WnyogY9XxtmyLw1IJ+pZGcD9J8i89cAfSeRH/JAv4kyjx7481Hy
xx7sT+NlPj1ajwwr+ZwH8cbKvDYi3n3k5xoxX/fI/DbC76PJJY2ob4TMcyPm
99+B/3m0F/vp3+R4L/z1F/k9L/QcIhd4cT5fIx/3or+/ky1N0GuA/EwTzuNe
8som+LGHvK9Jn6+uC+S2JszzefKtJujRQZ7uw35xivy6D+udIOf4sF6YbPqw
Xjt5yIf8viNPaUZ+QXJSM/bXFvL2ZtTrI/ub0a9G8h/N0M9FjvFDvxryMj/6
X03O9KMfDrLHr+uzlJP7/TgfiskTAujvAfLiAL5n8smbArqfWfvItQHos5vc
E0A92WRrC+r5gjy/BX7fSl7Xgu+tTHJVC/ycQe7E+7Gfku9vxTyvJ6tWxE8j
p7Yifiq5rBX+/4B8phV+XEseaaD+d8mPGaj/bfIsA+flm+SXDPTTRl5tYP9M
Im82oP8r5HwD52ki2WXg+2gJOWzAT4vIvQb2u/nk2wb0mkceF4Rec8hxQeQ7
m7wwiHzjyclB7G8zyelB7F9x5Nwg5ncG+XAQ+k4lH0G8vifJF4M4vyeRh4Pw
VzT5QVPHuzGBPM3E+TuOPM+EHx4m20z0Yyw5zcR+O4a808R+eje5wsQ8jCIb
Jr4X7iKfNaHHP/08D0zocYt8bwh63CRPDuH79Do5IQS//UleHlKR34xBckoI
83aZvDUE/S5F+D8Qdh/S
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1MlHUcx7FpLXWWjU3LRVrMoaXTcsZa6N+XfJsrcctsu7WiIsstiI1S
NFMH86UUtNME8YUXBVHPg4PjOO7gueea2rpsvUyns4KWhkLlNM2x5br/t32/
BRuDz+55nv/v9/39vt/nxuXkLX3zrpSUlC+Sv/bv/37Wm95Js/79d6GZ4Cl1
Z4pfNllDzz0mdnIs18zQ52+bczX5WWKTZ5K338zS9QXmq0QiIe4qNCW92SFx
ymqcJx671qT65neLzUemorz8QT1/ygb7+WtiZyPuFy8pNk8lf1RvVwnOE+dv
MmuSD/iv3y0mNzf3srhsq1nQXeSdpXo+sfUvnk32bzO3Mjz3zVF9pahXvKLM
nh+Yq3p34HnPkW/vsPoUzlP9O9HPfPLmT80jyYIXqB8v6tf1o3ehX53Xtcv2
c0r11+8GS7/8z+x8os+QM/eY7qJU39Pqv9zqWz6NfLrc2H2YKj0qUN9k8vK9
mPfj0qcS88kg91SaUFpJb7r02ofzx5FX7TdLkxekSb8D6HcMefBBq1fqaOl5
0LyXXLhUcgKfe0dK3yrcP4LsrTK1+VlDh0nvKuh1D9lTDf0HS/9q7PcgcnoN
zvv7KudRAz36yX01Vr/Jf5GX1OL6G+TmWpNch6Jr5NGHTF92KO038tpDqOcK
uesQ9L1MnnsY+3aJXH8YeoqH19n+tur6/DrU/yv5+zrsnziz3p43u4dcWY/9
EKccgR9UzxtHBtZ3+ojdv8yr5CcaTNLe9eKyBvihl/xng0nGQ754+VH4Xxw5
Cj36yGOP2f5WiouPoX5xzzH7vGvixcft+RnS03/c6v+SONUH/cWrfNhv8UUf
9l9sTmA/xbUn0L94sH/g59P9qE+8wm/72S+u8GNfxAn/wPru+DEv8ZRGzFf9
5TQiX8XeRtwvPtlosIbk2404X/pObMJ+ij1NyA/Na3vTwHk6uN6neV9vgv/E
6QH4RfuyLID5aR83B+z8S7vJ4QDq+1F+CWC+F8hpzSZ+M+PiWfmnGfv3HXlj
M+r9Wn5qhl4J8uVmnHda/mqx8+7/nLyoxeZ5bkx+a7H58E2U7GtBfoXlvxbs
c5D8QBD7HJAfg9inE+T3g3hfHJU/g/BrPflCEPtRK7+2Qq8q8oxW5N8++bcV
8y8nV7ciz3bLz63QYyf57hCeVyp/h/C8j8nvhPC8TfJ7CM8rJp8J4Xnr5f82
5PeH5Cfb7PzWr1YetKHfQvLuNsyrQPnQhv15l9zfBv1WKi/CyIO3yK+EkZev
Kz/C2MdXyW4YfvUoT8KY73Ly+Ha7P54XlS/t8Gc2eWs79HleedOOfhaRf2/H
+3qe8ieCfJxDXhqB/2YqjyJW3yHPkoMR5HWm8gn3u9PID0Wxr1OVV1GcP4m8
LorzJyi/otjH8eSfo/Dzo8qzDvSfRp7XgTwYo3zrwDxHkRs64N9U5V0H9L+f
PKITeTxc+deJvLiXXNCJ98sQ5WEn5j+IfLYTet25wnx0UG8/+WEH9d4iT3dQ
7w3yCw788Qd5hYP3dR95gwP/9pArHOj7CzmA89K6yQmcV/QD+ZIDv58n33HQ
31nyqBj6+5Y8JYZ5nCEvjGEeX5JzYvi+cYq8Job3UZzsjcEPDvl4DPsTIZ+M
QY8Q+acY/NhCvh2DfxrJI13sm4880cW+N5DnuJj3YbLHhd9qyIUu9DtA3u7C
H3vJdS72Yw/ZcZHPXvJ5F98PysjXXei9jTwsjvfBFnJ6HPtUQs6KY/83kpfF
MZ915Lw45lNE3hzH+/yDJP8DJJoYkg==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxF1n9MlHUcB/CzSXPIdBYV2SRcrCh/RNKIudG+pEkYJVIq5kWKP0JrA12W
IUtlOI1ZQBF1iMZP+WGeB3ccx3HAc881xUUuF5MySrAkSlatxDn+YN33fb0/
3cbYa8893+f7+fH9PLcwJy9z+x0Wi+VC8E//58daak6m3FiSElKa2p0cPrRC
vFElJCQ4n6WNHHUrzlqaKtd3qvCh+vw0WuWprwcG0p+X7+9RowWRS1+gR/aq
hvzk8DVy/7vKE334RgYdU6j2R9rPZ8p6B1RwO/Uv0/GHVGbwhvWyfpGKtKdu
yaIzitWj1tJnXpHnHVYTaz3RVjr/iNL/suX576vAZNzwa3RZid5fiTjmmLKn
jk7J/Y4P9Petsr4q1fHZN9C5ZUrn8//9liN+ied2OfYr8RsfIZ50+ujHiFfy
mVGh85EqjvoE8a2W+EKWfDdXwrJe/qe4X/Kf9Jl68PCNtS9K/DbEI/vpt6kd
wY/Uo6wK9V1LZx3X+Tso8cRUox9eoserdb5PSvyOEyqYjuZ19L6TKvh4j9RP
fY56S/5m1qD/pJ65NTpfoxvpgRq9n78k//G1qM8muqJW5zPsVcl3LfpN6m2t
0/udK/U16tRzwQJtpmPr4S1Sj5Bz6ImQt0p9GrD+NtrVgOdvl3o1oh/EhY06
v2M7pH6Nuh6XXqdXnlLBdPfkSj1PIZ876Ygm5H+X1LcJ9XuDHmzCeZXrSc16
vWRZv7oZ+Zb9W1rQDxL/thacB+n3/hb0g+R/cSvOq9SzrBX9If1wsxXxSn9l
ndb1KZD+9MFTMj9ivkA8K+li2CLzaDx0PZlOP4Pry6W/zmD9RDrSjvWXSb/Z
9X72Pk4Pw5OLpP/OYv9xdMNZxBcr/ehA/AvpRAfys0D606H7dcN8usqh59/A
vdKvDpy/u+lpB+o7V/q3TdcrIYLOacN5mSX93Ib5FUafa8N5myH93YZ+m/79
Pz/WjninaGs74rlFf9iOfvmHNtqx3z/pv9vRLxN0rBPzbZxe78T3f6WPOnEe
xF4n8jFGTzgxT6/T0S705y90hgv9/zNd5ML5uEa7XDjvo/RYyCN0VAfmw1V6
dQf29xNd2IF8/kjbO9BPw/RIB+rzA32XG/m8Qq90Y159R7/txvweopvd6MfL
9BW3zkfFIB3Rifp9Sz/dqapsNtslOr8T8+gbuq4T/XyRHuxEvw3Qd3rQL1/R
SR7Ec4He5dHz3zxPV+O65Rx90YP30Ze0pQv1MullXegfg97Whfr10pVd2L+P
7g/ZS091IX4PvdiL+910thfru+gyL57fTpte7M9B3/SiHnb64W7U9zSd1Y3z
0EKX4Hp6E+3rRvyN9B/d6Oc6OsaH+VdDZ/rQXyfoYh/2f5x2+3S899vocR/e
15X0/B7db3EVdDrcXE6/16O//1Ap7ehBvo7R13qw3xI6shfz5wi9qhfzu5je
14v1iujWXvTPAXq4F/kqpOf0Yf8FtOpDP79D7+lDPG/RDbg+upu+HLo/j55p
IN9v0gsMPH8nnWgg/h30GgPnfSudayDfm+lDBs5DNl1loB820U4Dv2+y6AED
/bOOvm4gX5n0NNbPX0Pf58f+0ul4v873wTQ6LeRVdE7IK+j9ofsVXeHH+sn0
GT+ev5w+58f+nqKv+jFvnqRv+3Gen6DnmZgXS2Wem+j/RfQKE/PxEZnvJvoh
lt5ron4LZd6b2H803WRi/j8g89/E86Po70PPu0feByZ+j82jZwdQzznyfgjg
PM+mkwOozyx5XwTw+yiMzgug/jPk/RFA/0//tiTlX3rl87s=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1M1GUcx6lRa+SyFzbMFmqRQ6aNchlb4Z60SRQVska4qAYh4UuBGIpA
KsQlMALUEwJJeX8TzuPl4O644/53bGqN3GqVs9GCVsaCVWPiGFuue763789x
G8c+3HPP83u+3+/v92ddenbS7ruDgoK+9v/o33y9Ml1gLprd9FKA4lVmZuaN
QuFdyv95qLCRrhrq6x8tkM/3KEvc9FI+WWUr0+xO+2FZn6vW+P9wiDyVpwpD
LZc/ke8fUXM77eEHyWuL1IHYkLcPyH7HVMi11pxscnSxsoeb9n0k+5dg/33k
xFLst0fOM+n9rmWSc07oegsy5Pxy1ZYTG5JOrqlA/WlST6W+b/0HZOsXKrXa
l7db6qtGvR+Ss2rUZv9Lzo8+Cf2kvsWT+j7/7pf6T6lvJyYmPiaXnVb+5ZYc
uY9Z11eRS151BvcX/abOaD3jRN+uWlXtW4gUP3LqVJI9/B7xK+ZL5V8+fcff
erXBf6FPyVfqtX7njokeDcr/fryYnHJWjS9Epn4m+jQqvz2xJvJMI/JxQvT6
Suu1UEbOPwc/KkS/81qvwUpycJPWy1wlejbB/xryRBP8PiX6Nmu9njaTzc3w
s1b0btZ6zdaRU1uQv3rRvwX+yOcRrajntPjRivPk/LlW+Cf1JrbBn3LyUJvy
X+/Jz8WvduSphFzUrv1OEH2n2pf78XIH8iX+dXXAvzzyik7oI/2R04nzJD8/
dOrzYiRfMV3QQ/qlsQv6Cwd16++3yvczunX/Z0q/XelGniSPG3tQr3BNz/J6
bvboPG2TvKZcgP7CrgvQ606/96J+yXNpL/QSnulFvuX+CX3oF2Fr3/L8h1qQ
Z+F8C/Ih82jSgnqF1UXkU7jtIvYT/YOtWC+8xarzPymchc9Dj5AbrPi+8IQV
/Sp824r7C0f3o9+E0/u13l3C5n74I3ypH/NIeLFf58MkHDWg/UkTTh3APBKu
Glg+r40B6C08PwD/hSMGkR/h5EHUI3qVDS7X1wm2iP5zg/BD/AwfwnrJS+IQ
9JU8lgwp/Wuv9NMQ6pH5fWMI/su8XmVD3t8nv2qDnu9Iv9nQPylkiw1+vCX9
Z9P9/V0i+eFh7Pe69OMw9osnHxrGfjukP4dR3zbyz8Oob6v06wj0f4G8dQT3
fV76dwR+bCa3jGC+Rks/j0C/jeR77eiXDdLfdvj/FHmvHf22TvrdjnkTTr5q
hz+rpf8d6lZk6sow8rMOzNtHZB44oM9Kcq0D91kh88GB+9xHXnKgn4JlXjjx
fLyL/J4T8/W/vzg/nOifJbLPifl3i3zTifPnyetHcf4/5JRRXX/1LLliFPP5
T7JrFPf/nfz3KO4/RV7rQr5/ISe54Od1cqkLz4sfycMu6P89ecal/O/Hr5JX
uzEfviEnuJGny+Sjbug1Tra6Ua+H/Jsb9brIoWOYB3byjjHkz0bOH0O/95N7
xvTz2N1HnhzD87iH/IAH+naQlQd5bSHnejDvz5PbPMjXWfJPHtyvjhxs4H5m
8uMG7ldD3mIgj5XkNw3Mx3JyloH+MpGLDfRDMbnBwPP3KHnQgB4F5AkDehwm
/2Ggfw6SbxvIWzY5zIu87ydHe+F3FjneC/0yyOle5DONXOhFf7xLNnuRj13k
Pi/+/0wmX/JC7yTyr17o/QZ50Ys8vUZ+yIf/T+PIUT7kfzt5uw/+KHKqD/l7
kZznw/M9hlzlw7x9jtzpg5/PkI3A+k3k64H1UeT5wPr15PvH4f8T5Ihx9OMa
cuw41j9GTg6sDyNnB9aHkssC6x/08//EAAfz
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1HUcxqlZbfTicrbMTaOyImdl0Rxbo36ZM3WskDXTRW+U5ksFWjgT
l2lSxFKgUHnzBQ4EeTmPuwOOl+Pu/peKdVKUipWrbGVOrTlLZ7a57vdcz+Nt
wD67/+/l+/0+z/Pnjty87IVXJyUlHYj/2L/8JI+4znafvv+JBM022YGJRT3i
Baa6quq2PnI41xxfPdbdr++XmMKx7qcGyCbPxPF4SM+vMHFcHSH/XGBmxTeI
av27Ji0tzfc5OWWNub3o9Nx92m+tsffbT566zlxIzSk9oP3XmzNzA9u/IGdt
sDzxS51XhPuK8z/C/jGd/7Gt95qD5LISW89+ccon9r4VQ2TPRhNvz7KvdL9S
czAWy/yavLjMxLdPH9Z9y+35D3xDvlhuSp3zqd/q/p+CD5GLP7P9SDuseirM
iCs/4wh53Gbcf0T1bTaL4p+j5OYtmIfW5281Gckjd+n89Eo7j0uqJ6nK3j+m
/gxW2XlXDaof1Xaer+wlz6/Bfo76U2vPP6H5n6y137ukF882rA+QV22HnjrV
vx04v4M8aqeJ/37frX7uRP9aybGdZnn8gCb1tw56bSBX1KGfdep3ne3X8DZy
Tr3JKXUKqtX/evt8cw15kgv76fliF/q7g3zGZe7LKZ2u/bMa0A8X2d9g75/U
qHk1muj51GO7yGsa7TyDzZpfI/rdQp6xC35p0zx32XqfUz9uaIK+PJpvE/zk
JR9qgl98mncz6le/a5vhhyt+3w0/ye+v7Ya+Nb/B3dB3kDylBf2Vv8taTEN+
RrL8/XcL9CB9zG+1/XLk7/5W6EP+TmnDvKW3DW3Qi/x8sg36l18z2+HvK35s
h57lx7Fu5I/8u8qN/mm/Y27o7Uq+7ME8lUcNe5BHqm+UB/Uq76Z5MC/pebEH
9au/1R7UIz3HPJhHO/myB/Vp3lM7MB/pI7cD9UpPFR2Yl/S3rwP110rfHfb8
kkryZC/6USG9e6HfcvImL87bKP17UX8J+ZwX530oP/jg1w/I83zwx1r5w4f6
Csm9PvR7lfziw31Xkif6sb5A/vFjXu+Q1/vhd7HfDz2+TT7hR96vkL86kdfL
yXM64bd8+a3Trj+dR3Yn+C35L/H8m+QxXdDrG/JjF+a9jLyyC/1cKn92QR9L
yN93IZ9el1+7oYdF5Me60c+F8m838udVcj04NVd+7ka9L5OvDeB99ZL8HcB9
XiAvDdh8CDwvvweghwXkIXyfPl/+78H6eeSHe5AHzyoPenC/bPKWHuyfpXzo
QZ49Tb6U4EzlRS/0NIf8Yi/ep7OUH73I45lkpxd5M0N50ot+TSff04d5Pa58
6cN+GeSSPrz/HlXe9Nn9z6eT/0w8P0350w+9PULO7sf8H1Ie9eM+D5K7+uGf
KcqnxPeTyeODWH+v8iqI9/nd5PeCmOedyq+gwTXIvwRtfTkTlGcD6N948swB
PD9O+TaAem8htwxgfmOUdwPIu9Hkm0LQz43KvxDyJpm8IgS/Xac8DKFfo8hH
Qpj/VcrHMOZx+dT/PCGMfv9Lnha29xn9D/mZMN6XF8iLw+jPX+R1YdznLLk6
jPr+IPsSfIocS/Dv5N8S/Cv5cmK/4+RbIzjvR/LUCO7zA3l2BO/To+TcCPp9
mFwYwfttmFwRQX+HyO2RxP+b5H0R5PMg+SesX7SXfDGC/HXINzvQe4g82UFe
9ZGfdOCvADnHwbw7yQUO9OMlb3JQ3x5yU2K/VnLYwfuumfydAz82ks85yIt6
8vVRzHc7eVIU62vIGVH7PsivJM+LIs82k/OiyPtycnEU+toU5/8AtPQnzg==

       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg9M1HUYxm+ObEOXy7EyNwkXNXJWLrdybbhvZhnNFrBmtG61qJzZFuhG
I2WlJpOoAA2pIzT+CvLnOLjj/sEdvzumQZ1OF4l/KECTCIiUxIjMuu/z6302
b2O3z+57933f533e58fyzKz0t+ZZLJa+6J9+l1e5zWaLTDz0pEkp6kFrcfg7
8svqepJ1EdnIVPYNIzu+5edvq9rs5FiyylL5E2nePp7frtK98fnk4RwVO1CT
Tba8j98jJ+SpyTTvYbL6UPXMJA2SV+1Wq6Mv3mfsUSM74h5mfal71b35E6fZ
z3A+7jspnL1PPRv9wine/7GKfhw4LVxSqOLsG17/nvV8quu/7Qdhx2f6PvsZ
1lestiXHvnRWeEuJ0m/nWe9+VRyeabggPLtf15f2I+s/gPNDwgWf4/ww+ynV
9Zb+JLzkoD6/i783fFBtjr54f0MZPj/Hfr9Qer6sZ82X6Jfft9ig76Bwrw31
8L6ScpUcO3Af68v4Sp2IRDayvoQK6DsiPFaB+y5Sr0Pw0yXh3MMqaoeJn6nf
15jHqHBMpfbPml+oZyXmMSYcqdR+K/yV+lZhHuPCpVWY/wT1rlLR62cmha3V
ur57pqh/Ne77XTixBvO8wnnU6O/nXBWerNH7UDzN+dRiXn8Iu2qh7zXOqw71
zAjn1el+Rq5zfnVavyt/Cq8/ovdhbpbzPIJ5zAkvrIcf/+Z8Tb4h3F+P8/9w
3g3on1zRAP1vcv5HUT9/701wEu/vParnX8N+VjbCD9SjpBH7+pvwtUboy3lk
NMG/nG9XE/KEfkhoxjzpr73N6Id+HGtGPtDfG1vQTz/91aL7eYf7G2fX8xsg
59qRR9znQTvq4T6rVsx3QLi2FfvJ/YlxIG+4L485UD/3d4sD8+O+lDv0fkS4
HxEH9OU+3HSgX/p/VRv2l/pktqmdUYPQ76Vt0Jt6Hm+DPvTzbBv8RP1XtGPf
6GdrO+bDeRW1Q0/61WjX+2+lP6fbsQ/0Y6IT8/xLeJMT+tOPBU7oTf/5nVov
J/016YTelsn/Od6FvJgnnOpCnsQI73Ehz+cLu8zPyaMu/D6/v6QD+fGv3Pdc
B/qjn/M6oA/7sXdofdbRz8Md8Df3fbEbzzPqud4NfzFv3nNjvpe5n274g/M9
7741rxd6oBfzd60H+UK/ZXtu9We1B3rz+dTvQT98ns33Iq97ud9ezOuY8FYv
8jfEffciTwLCJ/F9q5/778P9buFHfbjfyTzwYT9ahct8mHcT88GH/huE53zo
v5Z54cd+VAq/6sc8DzE//Mhvm3DYD/3LmCd+7McB4Qc64e8i5kun9nf8J8KF
ndBrH/OmE/V+JDzVCb12MX+6UG+ecHoX8jGXedSFfcwRdnfBL9uYT11Kv70r
vDQAfbcyrwLQd7PwBwHkxxvMrwD89ZrwxYC+75tXmGdB9Jch/EwQ/b3IfAui
v1ThxiD253nmXRB5kyJ8Rzf24WnmX7d+XiWvE97eDT3WMg+7occTwme6ocfj
zEcD+bJaeJkBvz/CvDSQpyuFXzCQh0nMTwP63S+828B+LGeeGtj3ZcJOA/5Y
ynw18P/BXcKXDei9mHlrQO9FwneH4KcFzN8Qnte3C6eEkCcxzOMQ5mMR3hmC
/26MSz6HzHwUbgkh32aEj5vnrwoPmeenhGfN8+PCd4Yx/1HhFWHM/5LwU2Gc
HxK2mucvCOeY588KF4Wxv/3C9eb5U8KGef6E8Dnz9/uEp83zx4QX9OB8WDix
B+eDwsk9OO8X3tSDfj3CWeZ5p3BBD/RpjfJ/ke47HQ==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdln9M1HUYxy9DKyQtR4vaIpqsoaNisTH649ondZqOFrCm1q5WjIpsjcuG
M6VCg0JmggYmiMSPAw6E4+AOOI47uB9NcbvcXE7K0QRLsyAzQiMq6j7v63k3
ZAP22vfzfT7P87zfn8/zfSgnP/vVRQaD4VT4V/+Xn+jRpms/TT7yVIQ2KovZ
WDZFfl4Zo0dXXhX25ajRJrP3Fz5/QwWvJ5l+FVb5ylQeuD7N9dvVjSRT+Yzw
eIEKP066wfffRbzfhRMK1dvG6C1/MN4HSuc3J5yyR2W74kv+Yvy9airLFT8v
nFmsUlNTHf9wvxL19MSuSsPUf2z+WNcXzfWGfSoc7s0/hSvKkM8s89mv91vM
fO2fqJLJrPTfmF+5ei38c004rwL5/cx8D6qa6upq9nf2oO5n0w/M/xD4e+HS
T3U9dROspxL9uCgcV4V8uH68CvVeErYeVrG2Da8wvvkzXX/sj8LpR9SqsED/
612t9Sqg3iPV0Id6V9To/Uep99aj8Af1TqjV8dawH1dqoT/1th/T8azs3846
5Mf+qs+RH/WNqldfhkIh6pFXj37+LRyqR/+pb0oD/EF9KxtUOJxtkfBsA/SJ
EjY1wi9LhH2NqO824cQm+OUO4dIm9WB4w6XCU03wz53CmRa1O9Z2cpmw04J8
7xKOa0Z/VggXNiv9L1Z4vBl+u0d4XQv6wefWFviH8WJakT/3N7fCP8z3LHgl
60u34jn7UWuFvuyfoU2f3zFybhvqYT9H2tDPW4ST23GeGa+iHefnVuGZdtTL
fm89jnoWC3uOa/0nyAkd8AfzLe5APOpxpQP13C6c0Yl8yfZO9Jv1x9p0vo9G
C++0wU/kMRv8QD1VF/xKtnRpfYpihKPs0Iv9TrPjvJDz7DreZXKNXe+XQT+E
7OgfeT4Sb7lwSjfWk3O60V9yZTf0IJ/oht/Js93oL/2xugf1k009OC/kAzex
76b10z3ab/eREx3oD/fb7FiYT6kD9wHZ7YD+5CkH8mX98U7UR850Qj/2b68T
/aSeTifOG/W+7NT+mOTzuF7kQ/029cIv5MJe3DfU39aL/fn+eC/0YfwVfbgf
6b91fYhPf+7ow3mlf619OF/0+/k+Fbb3Lp6HmH79/gaelyf7cX/zPJn7F86r
xn7cN5xPZ/vRD867Ja6F8yrdhfPEebnNBT/xfq11Lbx/T7t0fnO8nw0Duh4j
7+/HB+Bv3u+5A5hHvP8PY72X821kAOdrUnhuAPcp502yW9dzhvPoJTf6y3lV
4Ub/vhMOuFX4bxHn3wzez7og/PAg/Pkt59Eg4p8XLhuEn74W9gzC3+eEr0bW
f8X55cF9cEY42wO/nxYu9kDPkHAfeO4U551H+9t8Uvh+L/T4QjjDC/0Dwu97
occw56NX12vwCl/0ol63cOwQ+t8vvH4I8Z2cp0Pwe49w+xC+x7qEx4bg9w7h
ZcPQr43zdxj+ahHePozzZhG2DCN+g/A5vG+s47z2Id+jwg/4cN6OCKf54Ncq
4Wd96Nchzncf/FYuvCfyfL9wTeT9fcKOSPyP+D0Q2f9D4Us+3D9FwvM+6P+e
8L1+3Je7+P3gh547hDf6MV/eEc7x6/vSZRbe7Uc/3xKu9CO/bcKdfvTndeET
WL88V/hCJP7L/B70ww8vCt8dQD9eEF4dQLwtwmsD8MtzwqYAzlOmcEEA/n9G
+ACer9kk3BpAvev5/RnA/bNW+JsA6lHC0wHobxReGsT5fkI4MYj90oSNQR0v
NVV4cxB+fUw4P4j+JfN7N4h5tCrM/wIrfgsR
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg9MlWUUxm+mtpA0jRItEZMMCY20iFXYa5qoYwtYM1p3tcic2RZXN5oi
K3UwiUpQiYKQ+CsXhOuFC/cP9w8f926kG7a5sazGJtQyF8w1Jo1cc933+TqP
826M/fad777nPOc5572rCgrz3p9jsVguRv/0f/lEZpKt8VPrNpu0Q2XGXGlZ
Sn5TrbVWhh8RNgrURHGc42E+/0BFHxfFCatC9XeyddFDjD+g8rwJZYuFx4vU
yrLJy4v4/iHlyJq49YBwYomOnxfL7/tURdP5637htKPqSosteB+//5h+bpsn
nFOK8+/leWXqcJwj6x5h23EVrXdsDs//TEXT+3CucFWF0v/mM58v9PdV8jzn
l2oq15vAfFSlqgzP2GOE91apssncDOafdhL6sb7Zk+rSyEg26zdOqf1RwR8U
Lj+t87MuYT3VKpr+BPWM/0rzu9R/HDzB/thr8Jz9tH2N58uEM77B9z/K+mvR
j8eEL9QivwTqUQe9Vwrnf6v7v34V9anXejQ8Lny9XrXaMmOSqNcZ+OMJ4YMN
0H8N9ftO6/NKsvDcRvhvLfVsRD+eEh5p1Hq9kUp9m+DHdcLVTYh/mno36fpy
04Stzcj3GerfDH02CCe1oF6+X94CPXjeVAv6xXxzWtWe6If19bXCr9Qnvk37
u5h6lrTB39R/vE3rVcF523oW8WT7WfiJ/Yttx7wsZ3/b9XMv+zfaDr15XoYd
7ycK19vxPvOzdOD91cK7O3A+67nQofXIfFI4tRP6sj9VnfB3ivDNTsw79co/
h/lbLxw4B3+wH4ldWt8R9qO0S22fKK7eSD91od/PCWd3Y/6ep7+60b8M4TgH
5vEF+s2B+X5JeMyhNkY/m+i/81qvmZeFW8+j/5vpRyfq2SKc7oQfXqU/nTrf
uCzhOif8vZ1+dcLPO4VvO7FPyGk96Mc24YIe+InnVfdgPpnfcA/6wXpme1Av
60/pxf6jXtZe9JP6nuiFXpwXoxf1sH/TvVofF+czyaXqamuX0R+7XNCD+6Dc
pfWdpJ8HXJg37p8pF/zF+yGhD/3jfZBj8kLhY+AG7su+PuhLvtaHerhf4/sx
jwuEd/ZDD8aX9CNf7ltHP/S9cx/1Y/9wvy5xIx/u161upf9xHj92o7+sz+6G
XziPv7i1XrWcx1jP3fO/yQM/cx5tHswn92ezB/Vyf4564E/O43wv/MB5zPBi
/3Ee93nhL+7Lei/8z37/4EW/ud8sPq1XMv2xwYf55Pzt9mm9rj0rXOPT8/x9
OveDD/6m/275tF5HOH+pA7iP6Ne3B+6exyqTXxQOD6A/fP/mAPYH532NH+cx
v3w/+sN9UuHH/cb9E/DDf9zXN/zQl3omBvD7gfswL4D6VnAfBfR5q9lfdwD1
8b69HoD/eF8vD2K/0G/ZQfSD/vwkCD3v/J4Iwn/8/fFrEP6xcJ+F0P9/J//n
bSH07x/hgyHoMSPcGYIe08JjIfjthvDCQfjlT2E1iH7/IXxgEP36Tbh1EPpd
Ff5xEPtlTHiugf79JLzCwH0wKpxuYH9cFn7NgN6XhPca0Pui8FED8zcsXGfg
PgsLuwzcFyHhEQP98Qv/bmDePMK3DcyLS3jpEPzuFE4bQj+7hHcMId4uXGDG
twkfNuObhKuH0P8zwt1D+H1UJzxsxtcIXzXjTwnPmvGVwovDiP9cOCWM+OPC
W8KILxW2mvFHhIvM+BLhE2Hkf0i43YwvEjbCqHe/8M9m/EfC02HouU94QQTx
e4STItD/PeHMCOLfEd4VQb/eEi404/OFyyPo7+tR/g8fddqD
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdln9M1GUcx5nT1tBZudvUmoiTHJEWRRn9OHtUEjVKoEJcNxuEhvUH5EYz
ZKVOFrESLNQgIn7K8es87gfcHQf3vbuluF01m9PZ2AS3mA1WjUkj16x73tfn
7YgN2Gvf7/M8n1/v9/NdU1iSu29BXFzcxeiv/i8/h022C+nTGzbHaIf6PhLJ
eo68R62unLr0vLBRqN43x+828/kBZbJlTmwSViXKk1D5nuL7B5WlJjS7WXi8
TEX/HtnK9R+qP5Mt970knFihpnM8Tdu438dqotz02Hbh1KPqalvp8A7ufwzx
viycfRzxZPG8ShUfXfCqcOknKteTsCib53+qGurr63OEa6tx3muM5zP1SDSB
14XtnyP/PMZXo/Od2i1cXKv3r9zDeE/q/Ve+KTx3Uu9vszD+L1S0/pl7hau+
VOHZ5LG3mE8d4i8QXnEK8b/N/E4h/iJh62nEv5/5nkH87winf4X4DzD/el3v
BPJoPfq9j/VoQL8KhfO/xv6ML7ER8TK/m414P5/1+kZF25/8hvChJp3vBdZb
fYt5YX8WNqv2UnM8+1ncrMzRAmQKR5p1/80ZrG+Lzucq562uBfXifM61oF6c
Z0sr6rWR9W9FfGnCSW36vLVPsR9tan/052nh6TbMJ9dnt6Nezwi72nHes+xX
B+rF8ys69Ps51NN4h9ZH2QvCGWe1HmoYv/Us8qe+lnSqtLQ054vsb6eKbudh
/pc7oQ/qLd2K51uEG606X+td/XWhHqxnURf6Rz2Odun+WqjH9d36/DT2o7Zb
vx9Hfd7qRn/J+T3QA/Xq70H/dnJ+eqEf8vFe5M/+3+xFf6jnrD7kQ7b36fne
8oqwyYZ5Jx+y6ffTOV9jNtSTrM5h3nYJt5/T/lFAXmhHvckb7SpqL7fJxXbs
Tz9psGOeyRE75onn3Yk9Z/yp/agnnxf2z9+/rl/P3yT3O/8/nuuH/sgpDu2H
EbLFgXqRTzjQb7LhQP7kGQf2YzxJTqxnPfOcWM/4q5x6fTX75XOi3+zndOw5
+5/gUtsnyus4H9ku+CHn6ZgL8XPeXC7Ug/M46UK9yCvc0Dvnd6cb88/5rnDr
80xkmxt6ox7G3ciXelk2AH2SM8CXqK8PBuCfZOsA5pd6/HkA+ZKXDEL/5E2D
8+/L0kHUk9yK5wXky7H15Hs88BdyugfzQL9414N4yY0e6JH8gwf6uHt/e1Fv
8pNe1INc5NX1/YN82ot68vxRL/RMvu2FHsnrffAPrt/rm/9+rQ/zQA75cB79
8pYP9aafrhuC3vi9kj+E7wf6b/UQ7gP6tX8I9aWf/zaE+5Z+n+hH/54QzvVj
flPpR37o43HhgdjzDfQnP75vHhV+cBjzk0K/GobfJAt/NIzz1tG/hnH/Pix8
YxjxraWfjWAe1ghvG4F/rKa/xXiVcPcI6v0Q/W4E/VgpvDSA75Hl9L8A5sck
fDCA+2EZ/TCA/e4XvhLA/C2lPxoq+vfIYuFVBvR1L/3SwP25SHiXgfosoH8a
mId/pv7jowb88m/hBgPn/SXsxH6Ts8IRA/M8I/yLgfv5d+E7sXimhZcH8b34
q3BqEOdNCu8IYv5uCBcGsf914cNB3E9jwnVBzOc14b4g+nlF+HwQev9J+HoQ
9f1ReC6I+kSEHwjhvrsonBJCvt8Jbw0hv5CwJYTzA8JlIejBL3wiBP17hDtD
2k/L3cJG7DyH8LUQ9G8TngnBz3qEF4ehP6twUhj5tQubw3i/RTgvDL9uEi4J
Y/8G4aow5udMlP8FIYLx/g==
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxFlg1M1GUcx69GbmHT2dg0N4kmc+isKFqxtrPHl0SMUmgpbZclmflScVIU
ASkQpLESLLSOiHiVA+Q87gXujrvjf3+W0iI3NxfL2YJarAZz5bTMNeue7+33
9Ta4ffbwf35v39/3z31FxQWv3G6xWL6J/+hv+dTN5me/OHf/2gTlqrFrGbYd
5OeVNXmy8wVho0htmi5PIVv2qji6bMKqWAVS6/aTjRJ1bzwAeapUHbAmbydb
3lWunOlyclqlWmlrMG/dd0jHX854mdWq2eFw3MqnRsd/gPlurdXxzpOn6lRB
PCHWZz+svpuYyHuJ8T/E/TuFG+tVl92aXMR8PlLxdK6R3R+reDv+eJn5NeB8
l/CeRqW/djPfY+jXq8LXjyHfPcz/E+SzV/jIp/p++z7W04R69wsvOY7+vMb6
jiP+68LOEyqOGcWs9zPMh5z9udod//B5i0PzDOONO/R9pTxvbNb9u+MN4cIv
dD1NvC+tRed3zwHh31qglxL260vk85ZwWatmZyn79xX6/45wUpuayw+0lrGf
beqvDNvCcuGJNuilgv1t13q9VCnc1K60ng+y3+2Y/yFhW4eqSHGdrWL/O/R9
N6qF0zt1/NT3OY9O5F8rPJc4r+N8utB/sq8L9X3AeXUjn8PCld2YJ3mqW89/
grzhJPIjO0/q+hvId/UgPtneg3kx3gWctzKfbCeY+bc48fesz9KL+mqEd/VC
X+zPeK/OJ4f9W92nsrKyvO9RH32YP/t/tQ/7z3kV9qu4nCOcZ7gfeuK8007h
fuqh9hTm9Sb1hPOz1FfeAPbTTn0N4HnqM8WFflG/ZS7d/wD1fckFvXEf1Wno
mfvcdRr50R+S3NhH+tGjbhUPN11Ifbqxv88JN7sRL596deP+rcI3E+fkzEH4
FbloEPeTmwYxD953ZlDXX/8s9T0IPTD+Kg/6xXObR8V/VxUIH/XoeVh5n+FB
fYx3xaPjrSOne+Ff5G1e7d+TW7gfXuiZHML5dvKcF/tLTvWhnme4Pz7EJ9f4
oCeyzwf9PC0849P92Ule4sf+5glv9qPf5Eo//Jbs8iP+U9w/P95P5LuH4Ceb
uY9D8Evy20Pw/1zuJ9hOvpg438R9HcY+kNcMw29zuL/D6Be5Yxjz28h9Htb7
lkWeF0C/n+R+B1D/BuF9AdxHbgnA/9cLnwtoPVjIliD2Z53ww0Hoay39IIh+
KeETQfjdE/SHIPRHvhFEvWvoFyH4IXlHSJ/PkhtDqI/PmyHsP/lqCPtAXjEC
fTKfwhHcT64fgX6Yf3gEfkC+DF7IetPC0Au5IAx/I9eGMU/GHwrDL630pzD0
+Ljw0gjiPUa/ikC/jwgfjGD+D9G/IvCzB4V/juD+1fSzKOpdKbwxiv/PVtDf
ouj3cuG+KN6PafS7KOa5THjBKPJbSv8bRf2LhUsSnEI/TPAi4e9Hcd8C+qOB
98t84WUG5nkn/dKA380T3pI4T6J/GpjfbcLVBvzmv1nxUwP79a+w18B+/CM8
YWDefwv/aqA/V4Vv4tzxp/DiGPz2snBmTOmvOeHcGPr/u3BRDPsxI1wRw7x/
EW6K4X06JTwQg35/FD4TQ78uCv8UQ/8nha8nzi8ILzJ1PlXnhVeZqP+c8HoT
8b8VtpnIb1y41ITffS181IS+TOEeE/qLChsm9Dki/IOJ/ALCVxLx/MLzx3C/
Rzh9DH7gEraO4b5+4W1j0KNTuBjn1m7hI4nn2+P8PxiyBss=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVlg1M1HUYx29O2zIWy9GiWqSLFblsLDdGW9RPJRGjQlaIdVkSWtoLJ4Uh
kAJBIikvCughGXAgL8J5cMdxd9zB//63pW3U1mbRi5viprPBqrF05lp1vy97
vpu3ifvs/r/n9zzf5/s8/1uRX5izfZHFYvkm+k//Lx9nxkxpzdyqNQuUqXan
LZ3+nLxFrY5+aoWNfHUjydpwkN/vVEunHX/WCatCfX7zIT5fpKYdttBh4UvF
Khr+kQae34t4jcLLy1U0n1tNjLdf7Yh+jgonVyK/ZsavUt9OTWW1CmdX475j
vK8G+duFbQdUg3m9r433H9ScdEK4sU6VxTkzjjOfQ6inRdh1WEWuJ1mPML8G
MOt5txH5sP7kJlUzuymVet1sUm12+/3U1ziirNEEqoRrj+rzU/tZT7Oa2+Q7
WS4c3wI99rK+FjVTGvfkHuG+VvSjiPUeQ3424dTjasNMafNu1m/HfXz+nF3l
+BKWfEw92tTj1oa1xcJ5J1T0bwXvW94OvT8RvtaO/pVQry9Rf6lwyUldb3EZ
9ftK98fN+hZ3KF9Czeyn1LMD/aEeUx2ov4L6dkKfSuHmTviDet7s1P6KrRa2
dqG/9LvRpfMtZT8SHVpP5wH2w6Gij8/Q/3MOxKPfs7t1/WlfCHu6kR/7H98D
f9P/5T2ot57960G+9E/6KfiB89B3Svcrjn6L6UW/OQ+2XtTDeTjfi37Tr6l9
Ws/3OB/tfdCf82HpRz/p94J+ff4C+Vy/ejjaQMZ7YkDfd5bz2TiA+lnPXwOo
j/rknUb/qGfwtPa//TP6ZxB6sp/Vg8iHfrg2CD/TT1lD0Jd+dA1BP/o5zgk9
PqTfnDr/73cJX3BqvyTspP/OQJ93hLvPaL+b2+lHF+a1QDjFBb/k058u+OMt
4TYX5v9N+tWFeG8I/+uCXlb6dxjz85pw/jDy30I/D6Mfm4W/Hsb9ufT3MPbT
q8IrR1Afn7eOaL2u5gnXj6A/vM8YQTzmMz+C+7dyHtzoD+vLdSOfbZwPN/bp
28IBt+6XjfrNuVEv9U3wqG5b2lLqn+25vT9VHszz+5wnD/rDfl71YJ9wn8WP
Yl9xf20cRbyPOG+jiEe/OEcRj/vq0ijicZ8u8yIe91O6F/Hoxz1exNvH+fQi
Hv37ixf1cv/EjGGeub+eHcM8MZ5tDP2gv7vGMO/M9/wY9KS/7/Ahnw843z7s
A+q3y4d9s4Pz7sM+pV+/893uT4sf/Xtd+Ck/6qdfCvyYt1eEW/3wczb3gx9+
e1H4lh9+yuS+CGA+nxfeGsD7eC33RwDnlbAZwPtjDfdJAH5bJ/zouO6Xj/Hy
xrFPMoTrxrHfeH9wHPdvFP59HL8/NnD/BKEv4+UEkQ/vqw6iP2RvEPqlcz8F
oS/5gRD0Z7ysEPywXnhfCM+TXSGdj4P5Xw7pfbKN+cVNIF/Ws34C58klE9CD
9Q1M4P4XuO8m0L8s4bsn8T5nv9Qk4r8kXDSJevl99yTuY/wfJ6EP81tsYF+w
3ocM6Mn+phj4vfGc8MsG3q/PcH/i/NmnhSsN9DuF+9TA/auF3QbmKZn71YBf
VglfWeCV3LcL/JjwfWGcT+T+DSP+CuHMMO5P4D4O4/fRg8JlYegTz/0cxj64
V3gorKJ/K5ZxX4fRz1jhi2HoH8P9Hcb75U7he0y875Zwn5vQZ5HwOhN+/29W
9ruJ/fOPcLGJffa3cL2p87HcEO5diDcvbJjwyx/CP5vYT3PC8/g+9jfhuyLQ
44pwYkTv87rLwmkR+OGicG4E+v8qXBiBfj8J10bgzx+i/D81thDx
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVln9I3GUcx49Y/WFRFAdZkBmNsFEhCcN/Lp5qZCtjarW5ulbZttxWebNc
m8rSpWxJm7rd3M45p975W8/75Xl33p3f7/diLbAgiKQQ0qAxUCJGxtgfI5/3
8XmDgo4Xz/P9PM/n/fl83s+eqKqp2HeXzWb7Yf1X/ys//pLl+o7VZ1/M0naV
s+D9p5O8W9n9JR+eEzaq1OOtKz+7uX5APe1sf6lLWNWo5Xq7/wL316rV8lie
R3ipTlXE8lq7+f0xnHdJOL9RHXbk7LrMeF+pBa8r1Stc2Ix4fYx/Qq3/beoX
LmtRmbWCxQGe16oa7P7vud91Uu+3MZ7tG+XIWXiyR7ijTcfv5fn536puj+eR
K8KB0+rV5Xo346l2zXaeV92BdS/v24nvB4VvdSL+EO9/FuePCJ86p9qttZFR
5uPWej43Lpx7XrWulMcmmN956O8XHulSP87Pz08x3wtaD2dQuPiiWpd/JcT8
PUrXPyJ8zaN8LkdOlHp06/t7ZoQrL+E+cerTo8+3EsI3elC/JPW6jPNSwkd7
Uf856ncF9TSFN/WpoqKisEU9+6Dvd8LzfbpfXOTCfuTP/e5+xDOodz/ySQs7
B1B/3s8YwDrvv9mLesRYDy/yoR6rXtSHepX5UN+wcMSH/qfeuYM6/0MB4cZB
1IP1WRrU92li/bYNoX8nWc8h5Eu+bxj5kl3D+H5M+JdhXc/b7K/iEbVenjr2
Y88I6sF+to2q/es/7P+9o4jHeb2WZc7rM2NgzmvHGOLz+3/HEI/zUzkO/Thv
yXE9zw6enz8BvTlPLROoD+f5xoT+foFcOgl9OW+BSfQv87P7Ed/HfvMjHudv
0Y/5Iasp1Id6+aZQz2H2YwD+Q94aQP04r9UB+Be5OwB9OL/zAd3vd7M+d8Ct
5MIg6kWuCkI/zrs7CP8iXw2ivzn/t4LoD/KW0EZ/cIZwP/KZEPRm/xgh7Rel
5JshnE/eHN4Yf2cYevC+p8LQl/kmsO6gXqvZ76l3XgT+x3qVRZAf63sios+/
zv6IRBCf/XM9Aj9gv+VOIx/252vTej4LLnLessz3yZ9lvl9L09DzrPBDUfgB
38NtUd3fa6eFj0Tx/rVxPqPar4pOCv8ehf9/zXmdQbwW4RdmsJ/rrhnk1yw8
MAM/Pc55xnpTo/A9MV3f4nrOdwzz/KXwwRj8uo7zHkM9Phf+Kabf82UX5z+O
+J8JPx+Hvp/QD+LwuwPCXXHc/2P6Qxz9tlf4dhznVdEvElh/X3hPAu/He/SP
BPrhHWErAb0q6ScJ9M/bwk/NQv8K+sss4pUJt81ivt6g38zCf14X/nsW9+d6
flL9V+B8YIdwRRLzwngtSbynPC+ahP+8RX9K6vu27RR+NAU/4f1LU7q/S5jf
8RT6z0n/SsEf9gj/mUL/Uy97GvX5QPiVNOpH/Y6m8R68KzyWRv15/mIa8ajf
/XPI/0363xz8m/nWzkF/6uHD+hr51znE4/5NBt6rcuHHjI312Zplnrcjy9Sv
2oC/837NBvKjnt0G+nuXcNjQeth2018N9Cv1/ctAP1CPOwb0p94Pm/A36ldo
on7Uf7uJ/39Q/yoT+VH/BhP1Yn+7TczjR8KTJurPebhqor/3Cf9hIt/99G8T
968WftDS+pRz3rZY8JODwi9b+P4Q/d2Cf30qXGchP87zGQv51AgPW9DvMP3f
gv/XCv+GeL30i5sW6v+F8L0Z7D/C9yGj/ddL/3FkEP8Y34sM3kv6VU0G70cD
348M3j+9/39GwwFx
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxVVn1o1GUcP8L6Y0lRHKRBa9GIFRVHgeyfxdMLLUPI7Q8zGIFLa2q2czRZ
m+VmDufS7aa32Z1T9/5y2273/rZ7+f1+V3PGFQSSFEIuSARHhLgQ/5Du+Yzv
R3awjQ+/5/c8z/fzdnuuvrF2z0M2m+1y8Uf/lc+znbdqFlZeeXMNbVX/VdT1
pog/Uu8tt7qTgo16ZfdX70rw+V6lf8cFq0aVKO3cH+X6JtVrrU6FBV9vVsXj
EkG+/5WqKrk6Oi+47LAqQucc9zuivB7P5hnBjg6sn+L+R/F8QvD2Y8pfvdw6
yvM69XmVY4KdxzHPOM8/oe97i++7ulXx+CruX3YSfEwLDpxS+dWKaz7er1ff
5/lZwQ0uzM/7O/rUcqvd7xd8t0/P9y/nNU5rfirIR9cZ8BviPG49n4f8bepX
bXb/pQjn68d+5HtqAHxQD+dZzE+9Kr9XB6tKPqSeNg/4pt5LHq1nO/3g8mL+
tOCd58BfhvwMAmcF3xzE+hz5Oq9qi4QYglsuqLpeq9kkfxc1n3WW4A1DuG+e
fA6pnwuFbT8ILgxpfpaJHcPw14+C3cPgf5F8D0OfS4LrRlTR778SGyPwy5Lg
8lE9j/0y9RjF/sQro3q+x3+iPmOYn+dFgO28/6ZxPCcfh4Ht5PP6OPiiPu9M
YP8Hek6oMWdVN/2xcVLz+TD95JwEP/TblUnsR1w5tX794BTyQ2ybVp8WP/Tj
7mnsF6AfpjVfNTz/ZR/8Qn+6fGqlJnGB/rzjgz70584Z9XrxExOcngEf9GfZ
rPabjX48NrvejzdnkU/6cdscntN/gTmt3z36z+4HXw/85tf3K6W/rvnRP9RH
zeu8Z+insXn1YtGgfL4hgOd8f0sAfqB/GwLrz/MGkF/qXcD6Ct7vfkDzfYP6
O4LIN+erD+rz3+L87iD6hv5YDGJ+8nc3iPnpl5dC8DP5rwuhH6hXTwh5o55G
CPNS/9sh9Af9UR7GfvTTjrDWq524K4w8E6fC8BPxSlj3VTVxaQR6EG+PgA/2
59EI/EkciYBP9v+NCPpvkvmKgl/2+/tR6DHEvEXhn0HB/ij87WH+oujnfsFP
xpC/08xjDHz3CD4Ugx7fMZ8x+OmE4D9i8Pdx5jUOPjoFvxHX/XuV2BmHn7h+
JA4+ud+VOPzA8x5JoD9OMd8J5I3325fAPC7mPQG9OM8vCczvZv6T0GNA8GtJ
zE+8O4n5uX4gCb9wv6Wk5rukT/C9JPTuZV+kMA/v+3EKfuc8rhTuy3mtFPJG
Pu6sYfL1wgLWf8t+WcB+HYK7F+DXI+ybBcz7teB/sH5zG/snDT1bBNemod8h
9lEa/H8pOJaGXw+yn9Lgt1Hw0xnoc4B9lUE/7hP8TQbfRw3sr7XnewT/lQH/
n7DPsuB7l+B3s1jP5y1ZnM/3fVnk+zP2XRb/z+wV/FgO8+9n/+XQH58LbsrB
n1+wD3Pwt1Pwbznw08R+NKAv+XnGwPcF+dtiaL1eJb8fGJivlf1pIJ/Uo8PQ
ehWol9dAPqhn2EC+qXfBQL7oh78N+I9+uW+Ab/rpKRPfh/Sbw0R+ugVvNcH3
SfaxCb6ZrzYT/mK+3Cb4Zh7mTPz/wrwsmuCbefrT1HytnmV/m+CbffSEpb8v
w+fY5xb4Pi/4bQt5vMh+t8AP+67Zgh+4vseCHl7BkxbyzvMNC/yfEfy7Bb05
3+21/ZjfR/PIA/kqz4NP8luVRz9Tjx143tkuuDEPP1Lfrjzuo/H/hZA07w==

       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJxdlltoXFUYhQeJPsSiKAGrYIwYJJYqxUDJS8r2glop2OTBRhgEQw2pPmQs
RHoJakuDMdhmqtPWmaZpkplkJpNkMvf75ZwzNU3ttLVaGlujbYqN0QQRaSX0
oXj2CnuVsVDCxzln77X/f/1rz9OtHc3v32exWM6Y/+Vf9e+jxsptxeXnX1ql
zaIq8Pr8KfI7Ilnd/eG0Yq1VmI/vnObzHcJja+w9o1h0CJfT+fhZvr9T9Bm3
fSXF1ztF91JTw3l+v1ucK5VKFxTXdMn937vI9T4VlbPuv39QvGGfaDYFXeL6
+7HfZcVbD4j6+vrILPfrFnvNBa8otn0uirfr5q5y/y/k+rY5xfZeeZ7KX6nn
S7HclBy4pjh4EPrnqa8P+m8obrdD/2/Ue1hYzQLcVLxyGPX6nfq/kutX/6G4
52vo/5Pnccjz3r+keO0RYfZrdpHnOwJ9C4p9R8v3tx0T5uvPUF/DNzg/z2Nx
in/rrH2/KJ5xiuesfS//zHq4oP8nxS3H5Xpu1rumX+rZxn4s9kMv+xU8IeuV
ZH93DcBP51i/k9BHv1QMwn8zrOcg9qP/SoPy+6VvWd8h+IF+dAxhPfpxZUie
x/hOsXUY9aEftWEh/9CPtW7Uk3p73KgP9S67ZX/qud5Wj5jfUxUgRz3l51k7
gu/JXSPQT74+Ikz7NVLPq6M4D9k3Cv3kNV7MA9nmFW+YAqjvklfOWx25wQe9
5H6f1PsC2TIG/5G3j6Ee5Jkx8VT30kXut94v581Jtvvl8ybyLT/ygedrGcf7
5Ow49JFrJpAPrN+BCcwzeXFC6vmM/dwyCf/TH8FJ6CdXBaS/rfTDrgDmjf6Z
C2A/+kdMQT/ZM4X68v2KoKyvg+tvDKJf1NcehF95Hlew3C+l1ffpp7tB9P97
+jeE+nBeWkMyT7Zwnhwh9IPzNh3CPDHfVkLIL+bbujDyjvlmDcOf/P5QGH75
kf4Py/nupL5/wsgHnqc2gjzg+d+OoH68H3oiyEtdcToCPTnOSwT9SimujiI/
45yfKOYtrHh/FOed4jxF0Z8JxQtR9Gec8xXDvJDfjMn6P0zuiqH/fsWBGPJs
jPMXw/rkR+PQ4+M8xtFfr+KP46gf2RfHeUYVX41jvRHOawL56FG8KYHnbs5v
Av4YVjycgP+HOM8J+OWk4geSqP8A5zsJv59Q/EES+dvPeU/CXy7F55PIJyfn
P4XzHlP8Ygr1JW9PSX05vn80BX8fZz6kyve/k0K+UO/6NPrJ87ybxn3J89rT
2J/1MdLwD+t5Kw3/sR/PZlB/9rMlg/6w370Z3J+TzJsM/EE//ZVBP0LMnyzy
KKK4OYv8ijKPstBLv8az0JtkPmWhN634iRz0ZplXOejNK/4kJ9ra2hYKzK8c
5pnzcyMHv/L3WFUe9WU+vZZHfe/lWx79Zj7685g35tNcvvz310MF5Pm9+7eA
5+SdBeQd2VMoz7PL/3teoZV//6Qm8+c0eaOGeSO/peE+4n3brsl67yHv01Bv
sgvr1zGfIhr2J5c05A/z9KaG3wv8/q6G/GOePabDH8yzDTrqz/puXn1uMI91
fM9+7dWxPvvr0KGH+Tapw2/0y7QOf9Bf13T4L8j8xv4N9OsjBuaf/l5nwI+c
h1cM9I/5YQU3cb46DfiDzw8ZyEPmkddAnnA9zYB/OH9XDOT/IO8DrBfgfD9Y
xPmYJ7VF7M+8aCziPnbwvihiP7vijiLqe5D3RxH97zX5Pwz1ShA=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{1182.5242718458123`, 980600.}, {1200., 980599.64}, {1250., 
       980598.58}, {1300., 980598.14}, {1350., 980598.92}, {1400., 
       980599.7}, {1419.2307692330653`, 980600.}}], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQPXGZZvYpn/kOQCbDhze6jiCagWWBQ7XIuuNvYPyM
BQ7yra8DX8L4ZxY4iKxzf/gUxjdY6LBDrjX7EYw/ZaED1/XFH+7B+D8WOgCV
V92G8WMWge27AeMfWOQQBDTgCoyvsthhSYEt10UYv2Oxg2ZMvxOc/2Yx2P5L
MH7AElT9W5Y49B/6qnENxpdY6nD2zJkz12H8mqUg9xXchPEfLHWYNXOmJNx9
LsscgNJ778D4K5Y5pAEB3D88yx2+acTwP4DxC5Y7AINnx0MY/8pykPsSH8P4
FivA/oGH15wVDsbGxpufwfgMK8HqX8D4KSvB5r+C8U+sBJv/GsbXWQV2z1sY
f8IqB4+HVSLvgXzFnQY8h4+tgscnALkRpN4=
       "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/eiwUobF9w0OQCbDhze6jiCa4d8Gh0JbruvvYXyD
jQ7XFxfYvoHxkzY69B/6uuIFjD9lo8M3jRj+pzD+sY0OMf2HSh/C+D82Ohz+
qnHnLoyvtckBaLzybRg/ZpODyDr3h3dg/L5NDrNmzpx5D8Y/sAnknvAHMP6n
TWD7HsH4Kpsdzp45c+YxjB+22WFJgW0X3D0dYHmf5zD+LrA810sY/w1E/ysY
X24LWD/cvwFbwPrfAfnpm18s8m7YAg8vACwfeEA=
       "]], LineBox[CompressedData["
1:eJxV009oE0EUBvBF9BJBEQKiYFUUjaIiBsRL4KlgFQvaHMRDEAwqgodWQZEU
RMGA9GA9VDEVCtJAS6GlEAjZJJvdnUWtGKv1T2M1UlNpqaRWESviQdx54Xtg
IGx+zGbmvW9mNsbbomeXGIZx1P/qZ/b41ivxpznyfxrf53fu109jLEfB4eba
N9gw9fj1BXiPSen2SOArfMakaK4pWYfvmRTrUotf4FFTz3d6Dv5j0vpkfXwW
3pGnSl97ZAY+ladwOJz5DN/Jkz9daBpWeaolgsOf4J95StZb903BWwr0vFwu
f4RPFijgL1CFOws035pr+gAXC3QxEqhMwgsF8tn3Dt5QJD+ORAWOFumc/5mA
bxbJWwzF3sLZxvgbeK7I+b2G11q6n4FXcIvFeY/D1yzd3y7xiKXz7nwJT1uc
7ws4WOL+xIdKvJ/iqyXqSaVSY/BgiTr8BcXVkt6/ZeIVNvcrJlvn2SLrX7J1
Ppuk/rTN9Uh/E7ae/4nksdTRefdKfuscrlfy3uvQtljXAdmPY46ud43s33mH
8xDfcLie93CPQ/7xuyDzZxw+j5J/2aHDtUS35Dnj/J/nX4d+hWIrZXy1y/sv
3u1yfdLvEZfPr4zHXb3/Vcmrw9X7P/sM7nZ1ffVReKjhR/DjxvsKnnL5PNjw
78Z6RXiV4nxNeLvi+5KFDyrOOwPHFOcxAl9WnNcQfJvnax6E+xXft37YUXyf
BuBJxfdV3v+h+LzL+8s9zjcNb/Y4z4dwxNP/t3rhEx7P/wBu87jf+/Atj+/n
Xd//ABJdppU=
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{4419.444444437258, 980600.}, {4450., 980599.89}, {4500., 
       980599.74}, {4550., 980599.62}, {4600., 980599.52}, {4650., 
       980599.45}, {4700., 980599.41}, {4750., 980599.39}, {4800., 
       980599.4}, {4850., 980599.43}, {4900., 980599.49}, {4950., 
       980599.57}, {5000., 980599.67}, {5050., 980599.79}, {5100., 
       980599.93}, {5123.333333330746, 980600.}}], LineBox[CompressedData["
1:eJw90k8oBHEUB/DJn8sqpbbkQInkT0opt62HhFKyB6c5KZPbSrmsk8OWHOzF
Zffgslsku2TJprb5zW9EMoS0i+RfrcT6kyInmXnbd6am33z6/ea9N+9N/VjA
P16iKEqbfTtrU/Csr7pUJ/tR+Sy0dzurUqlTixqWHzDpVBhJL73DUzp5crHJ
NziuU6d9FeCsTpqmPb3AZYLPP8O1gsLyeyUPdwkyv5tvHuFhQf50Xfk9PCEo
XRd6vYVnBdnhMu5+VJDPk2twneJ4qnve4nihGzjP52PX8J+gh6A3eQlXG+ws
3GFQNBKJXMCDBiX7H4Ln8JhBx5Y1dArPGDRgBziBF3nfOoITxfcP4X2OX3MA
3xXz78G/BvdXwlXScUqHWyV/fwbulfTTrIZ3YVVy/3bgaenMt2cbXpAUn/TN
b8LLkutdhwXvexLwleT5rcJfkvu7BleYzvy1JNxocr4N2GdyvW6+UZP/vy04
YJLXbpBb35zJ83bq/wd/L/Ch
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[CompressedData["
1:eJw90j9IAlEcB/AjarEpEKIhIWq4giAIouXgFw0WCKFDLU5C4qYNLQpFgxAN
ubjo0JJQiy4tbvf+QC3X0h/NssxKKzSIwAiC7L0nv3dwvPvAu/v9ft93Y6Fo
YL3PMAxT3HKN/Ha721s2iEfjsz29IFcjZ0MwxTof6JINyZZ/voXuJ5CLWXvv
6FECbX/R84aeI2C5yodN9AqBbCYz0kBHCASKnuQzeocA75jVOjpLYKkeTz+h
T9T3xvV+h8C54/ge0Q0ColzsHv1H4NsMpm7RwxTEOMdl9AyFSTHgFXqZQjgc
bl6gQ1TVv0QnKCTcBa/en6Zyftc1Ok9lP472KZV5HJTQNar60/V/1H7fDXqI
way4KugppvLS/S8yVe8OHWQyv4EqepOp89Pz7/f8gD7qvV9DEybnc+v8Kkzm
Y+r8vxiIdi2d/yCHDcu1pvOf4FDw1uMvaIurefX5rnKZ15k+/yhX/9Mreper
evL/+QflwuVo
       "]]}, 
     {GrayLevel[0], PointSize[0.002777777777777778], AbsoluteThickness[1.6], 
      LineBox[{{8318.978102190526, 980600.}, {8350., 980599.15}, {8400., 
       980597.77}, {8450., 980596.39}, {8500., 980594.98}, {8550., 
       980594.2}, {8600., 980595.12}, {8650., 980596.03}, {8700., 
       980596.95}, {8750., 980597.86}, {8800., 980598.77}, {8850., 
       980599.69}, {8866.847826089226, 980600.}}]}}, {}}, {{}, {
     {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        GraphicsBox[
         {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          CircleBox[{0, 0}]},
         ImageSize->10], {0., 0.}], {{{0., 980231.54}}, {{0., 980384.25}}, {{
       1132.31414, 980195.52}}, {{1035.258643, 980199.3}}, {{2264.628281, 
       980159.5}}, {{2264.628281, 980424.34}}, {{3396.942421, 980122.72}}, {{
       4852.774887, 980076.04}}, {{4852.774887, 980477.26}}, {{8087.958145, 
       979953.}}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980231.07}, {0., 980231.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980277.97}, {0., 980277.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980320.48}, {0., 980320.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980341.71}, {0., 980341.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980384.25}, {0., 980384.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[1.], 
      PointBox[{{0., 980384.98}, {0., 980384.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980414.29}, {0., 980414.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980443.97}, {0., 980443.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980454.3}, {0., 980454.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980469.47}, {0., 980469.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980492.18}, {0., 980492.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980508.39}, {0., 980508.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980527.61}, {0., 980527.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980546.74}, {0., 980546.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980552.24}, {0., 980552.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980573.66}, {0., 980573.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980577.67}, {0., 980577.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980602.98}, {0., 980602.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980613.24}, {0., 980613.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980640.74}, {0., 980640.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980649.82}, {0., 980649.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980650.56}, {0., 980650.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980657.77}, {0., 980657.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980661.37}, {0., 980661.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980679.88}, {0., 980679.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980684.45}, {0., 980684.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980726.06}, {0., 980726.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980730.85}, {0., 980730.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980736.}, {0., 980736.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980743.88}, {0., 980743.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980758.07}, {0., 980758.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980758.66}, {0., 980758.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980763.59}, {0., 980763.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980766.6}, {0., 980766.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980801.98}, {0., 980801.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980803.48}, {0., 980803.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980819.25}, {0., 980819.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980821.74}, {0., 980821.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980831.13}, {0., 980831.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980849.63}, {0., 980849.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980861.81}, {0., 980861.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980869.92}, {0., 980869.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980879.3}, {0., 980879.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980882.31}, {0., 980882.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980907.99}, {0., 980907.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980913.09}, {0., 980913.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980935.83}, {0., 980935.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980940.43}, {0., 980940.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980941.81}, {0., 980941.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980968.97}, {0., 980968.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980987.17}, {0., 980987.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980989.59}, {0., 980989.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 980999.52}, {0., 980999.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981004.75}, {0., 981004.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981034.69}, {0., 981034.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981036.51}, {0., 981036.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981058.12}, {0., 981058.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981065.06}, {0., 981065.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981079.53}, {0., 981079.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981090.66}, {0., 981090.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981096.65}, {0., 981096.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981098.24}, {0., 981098.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981107.64}, {0., 981107.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981132.08}, {0., 981132.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981169.64}, {0., 981169.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981170.7}, {0., 981170.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981180.92}, {0., 981180.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981183.99}, {0., 981183.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981195.02}, {0., 981195.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981205.65}, {0., 981205.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981231.22}, {0., 981231.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981269.18}, {0., 981269.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981277.87}, {0., 981277.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981298.49}, {0., 981298.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981301.02}, {0., 981301.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981312.1}, {0., 981312.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981312.37}, {0., 981312.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981356.05}, {0., 981356.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981382.68}, {0., 981382.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981417.75}, {0., 981417.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981418.17}, {0., 981418.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981424.34}, {0., 981424.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981429.16}, {0., 981429.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981478.84}, {0., 981478.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981487.54}, {0., 981487.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981537.63}, {0., 981537.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981544.98}, {0., 981544.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981547.92}, {0., 981547.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981607.92}, {0., 981607.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981659.91}, {0., 981659.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981669.66}, {0., 981669.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981732.13}, {0., 981732.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981774.1}, {0., 981774.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981789.86}, {0., 981789.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981855.98}, {0., 981855.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{0., 981908.75}, {0., 981908.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980229.6}, {50., 980229.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980277.4}, {50., 980277.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980320.26}, {50., 980320.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980341.34}, {50., 980341.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980383.88}, {50., 980383.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999936], 
      PointBox[{{50., 980385.92}, {50., 980385.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980413.95}, {50., 980413.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980444.76}, {50., 980444.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980453.88}, {50., 980453.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980470.27}, {50., 980470.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980491.82}, {50., 980491.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980509.15}, {50., 980509.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980527.18}, {50., 980527.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980547.42}, {50., 980547.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980552.97}, {50., 980552.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980573.28}, {50., 980573.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980578.44}, {50., 980578.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980602.54}, {50., 980602.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980613.25}, {50., 980613.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980641.48}, {50., 980641.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980650.24}, {50., 980650.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980651.36}, {50., 980651.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980657.4}, {50., 980657.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980660.66}, {50., 980660.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980679.39}, {50., 980679.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980683.95}, {50., 980683.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980726.91}, {50., 980726.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980731.62}, {50., 980731.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980735.77}, {50., 980735.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980743.67}, {50., 980743.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980757.4}, {50., 980757.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980759.4}, {50., 980759.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980762.91}, {50., 980762.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980767.08}, {50., 980767.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980800.57}, {50., 980800.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980804.36}, {50., 980804.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980819.12}, {50., 980819.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980822.54}, {50., 980822.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980831.94}, {50., 980831.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980848.97}, {50., 980848.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980862.62}, {50., 980862.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980868.62}, {50., 980868.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980879.81}, {50., 980879.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980883.22}, {50., 980883.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980907.87}, {50., 980907.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980913.93}, {50., 980913.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980934.62}, {50., 980934.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980939.87}, {50., 980939.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980942.08}, {50., 980942.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980969.64}, {50., 980969.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980986.34}, {50., 980986.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980990.14}, {50., 980990.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 980999.27}, {50., 980999.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981005.63}, {50., 981005.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981034.33}, {50., 981034.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981037.}, {50., 981037.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981057.61}, {50., 981057.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981064.57}, {50., 981064.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981079.56}, {50., 981079.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981090.18}, {50., 981090.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981097.57}, {50., 981097.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981098.82}, {50., 981098.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981107.46}, {50., 981107.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981132.07}, {50., 981132.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981170.17}, {50., 981170.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981171.09}, {50., 981171.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981180.06}, {50., 981180.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981182.96}, {50., 981182.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981194.17}, {50., 981194.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981206.27}, {50., 981206.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981231.5}, {50., 981231.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981267.52}, {50., 981267.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981278.59}, {50., 981278.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981299.06}, {50., 981299.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981299.72}, {50., 981299.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981311.19}, {50., 981311.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981312.74}, {50., 981312.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981356.57}, {50., 981356.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981383.47}, {50., 981383.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981416.74}, {50., 981416.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981418.44}, {50., 981418.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981424.95}, {50., 981424.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981427.89}, {50., 981427.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981479.56}, {50., 981479.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981488.24}, {50., 981488.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981536.06}, {50., 981536.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981543.67}, {50., 981543.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981548.56}, {50., 981548.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981608.58}, {50., 981608.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981658.56}, {50., 981658.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981670.32}, {50., 981670.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981732.87}, {50., 981732.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981772.67}, {50., 981772.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981790.55}, {50., 981790.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981856.91}, {50., 981856.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{50., 981909.45}, {50., 981909.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980228.13}, {100., 980228.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980276.77}, {100., 980276.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980320.09}, {100., 980320.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980340.9}, {100., 980340.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980383.57}, {100., 980383.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999873], 
      PointBox[{{100., 980386.85}, {100., 980386.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980413.54}, {100., 980413.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980445.55}, {100., 980445.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980453.53}, {100., 980453.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980471.07}, {100., 980471.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980491.38}, {100., 980491.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980509.91}, {100., 980509.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980526.82}, {100., 980526.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980548.1}, {100., 980548.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980553.69}, {100., 980553.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980572.79}, {100., 980572.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980579.21}, {100., 980579.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980602.19}, {100., 980602.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980613.22}, {100., 980613.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980642.22}, {100., 980642.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980650.64}, {100., 980650.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980652.17}, {100., 980652.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980656.89}, {100., 980656.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980659.99}, {100., 980659.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980679.04}, {100., 980679.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980683.4}, {100., 980683.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980727.75}, {100., 980727.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980732.39}, {100., 980732.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980735.59}, {100., 980735.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980743.23}, {100., 980743.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980756.96}, {100., 980756.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980760.14}, {100., 980760.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980762.2}, {100., 980762.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980767.55}, {100., 980767.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980799.15}, {100., 980799.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980805.24}, {100., 980805.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980819.04}, {100., 980819.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980823.34}, {100., 980823.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980832.75}, {100., 980832.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980848.26}, {100., 980848.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980863.43}, {100., 980863.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980867.33}, {100., 980867.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980880.32}, {100., 980880.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980884.13}, {100., 980884.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980907.79}, {100., 980907.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980914.76}, {100., 980914.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980933.38}, {100., 980933.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980939.27}, {100., 980939.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980942.31}, {100., 980942.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980970.33}, {100., 980970.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980985.55}, {100., 980985.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980990.68}, {100., 980990.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 980999.07}, {100., 980999.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981006.51}, {100., 981006.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981033.93}, {100., 981033.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981037.5}, {100., 981037.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981056.99}, {100., 981056.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981064.03}, {100., 981064.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981079.69}, {100., 981079.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981089.75}, {100., 981089.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981098.49}, {100., 981098.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981099.39}, {100., 981099.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981107.32}, {100., 981107.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981132.01}, {100., 981132.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981170.71}, {100., 981170.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981171.41}, {100., 981171.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981179.25}, {100., 981179.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981181.9}, {100., 981181.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981193.4}, {100., 981193.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981206.87}, {100., 981206.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981231.8}, {100., 981231.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981265.86}, {100., 981265.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981279.31}, {100., 981279.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981298.4}, {100., 981298.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981299.64}, {100., 981299.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981310.04}, {100., 981310.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981313.39}, {100., 981313.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981357.08}, {100., 981357.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981384.26}, {100., 981384.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981415.31}, {100., 981415.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981419.13}, {100., 981419.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981425.56}, {100., 981425.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981426.63}, {100., 981426.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981480.26}, {100., 981480.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981488.95}, {100., 981488.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981534.49}, {100., 981534.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981542.38}, {100., 981542.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981549.2}, {100., 981549.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981609.21}, {100., 981609.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981657.23}, {100., 981657.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981670.99}, {100., 981670.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981733.6}, {100., 981733.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981771.26}, {100., 981771.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981791.24}, {100., 981791.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981857.85}, {100., 981857.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{100., 981910.15}, {100., 981910.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980226.65}, {150., 980226.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980276.08}, {150., 980276.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980319.98}, {150., 980319.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980340.4}, {150., 980340.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980383.32}, {150., 980383.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999809], 
      PointBox[{{150., 980387.78}, {150., 980387.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980413.05}, {150., 980413.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980446.34}, {150., 980446.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980453.24}, {150., 980453.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980471.87}, {150., 980471.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980490.84}, {150., 980490.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980510.67}, {150., 980510.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980526.54}, {150., 980526.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980548.78}, {150., 980548.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980554.41}, {150., 980554.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980572.19}, {150., 980572.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980579.99}, {150., 980579.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980601.94}, {150., 980601.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980613.13}, {150., 980613.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980642.95}, {150., 980642.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980651.04}, {150., 980651.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980652.98}, {150., 980652.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980656.24}, {150., 980656.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980659.37}, {150., 980659.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980678.82}, {150., 980678.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980682.81}, {150., 980682.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980728.59}, {150., 980728.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980733.15}, {150., 980733.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980735.46}, {150., 980735.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980742.56}, {150., 980742.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980756.74}, {150., 980756.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980760.89}, {150., 980760.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980761.44}, {150., 980761.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980768.}, {150., 980768.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980797.74}, {150., 980797.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980806.12}, {150., 980806.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980818.99}, {150., 980818.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980824.14}, {150., 980824.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980833.55}, {150., 980833.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980847.51}, {150., 980847.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980864.25}, {150., 980864.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980866.05}, {150., 980866.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980880.82}, {150., 980880.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980885.04}, {150., 980885.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980907.75}, {150., 980907.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980915.6}, {150., 980915.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980932.13}, {150., 980932.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980938.63}, {150., 980938.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980942.5}, {150., 980942.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980971.04}, {150., 980971.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980984.82}, {150., 980984.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980991.21}, {150., 980991.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 980998.91}, {150., 980998.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981007.38}, {150., 981007.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981033.48}, {150., 981033.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981038.01}, {150., 981038.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981056.28}, {150., 981056.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981063.44}, {150., 981063.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981079.92}, {150., 981079.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981089.38}, {150., 981089.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981099.41}, {150., 981099.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981099.96}, {150., 981099.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981107.24}, {150., 981107.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981131.9}, {150., 981131.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981171.26}, {150., 981171.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981171.64}, {150., 981171.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981178.5}, {150., 981178.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981180.82}, {150., 981180.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981192.72}, {150., 981192.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981207.47}, {150., 981207.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981232.12}, {150., 981232.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981264.2}, {150., 981264.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981280.}, {150., 981280.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981297.08}, {150., 981297.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981300.22}, {150., 981300.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981308.91}, {150., 981308.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981314.03}, {150., 981314.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981357.58}, {150., 981357.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981385.06}, {150., 981385.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981413.87}, {150., 981413.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981419.81}, {150., 981419.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981425.39}, {150., 981425.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981426.18}, {150., 981426.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981480.94}, {150., 981480.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981489.66}, {150., 981489.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981532.92}, {150., 981532.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981541.11}, {150., 981541.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981549.85}, {150., 981549.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981609.82}, {150., 981609.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981655.93}, {150., 981655.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981671.66}, {150., 981671.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981734.3}, {150., 981734.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981769.88}, {150., 981769.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981791.93}, {150., 981791.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981858.78}, {150., 981858.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{150., 981910.86}, {150., 981910.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980225.16}, {200., 980225.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980275.33}, {200., 980275.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980319.91}, {200., 980319.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980339.83}, {200., 980339.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980383.12}, {200., 980383.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999746], 
      PointBox[{{200., 980388.72}, {200., 980388.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980412.49}, {200., 980412.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980447.14}, {200., 980447.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980453.02}, {200., 980453.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980472.68}, {200., 980472.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980490.23}, {200., 980490.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980511.44}, {200., 980511.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980526.34}, {200., 980526.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980549.47}, {200., 980549.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980555.13}, {200., 980555.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980571.5}, {200., 980571.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980580.77}, {200., 980580.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980601.79}, {200., 980601.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980612.99}, {200., 980612.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980643.69}, {200., 980643.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980651.42}, {200., 980651.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980653.78}, {200., 980653.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980655.46}, {200., 980655.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980658.8}, {200., 980658.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980678.73}, {200., 980678.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980682.17}, {200., 980682.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980729.44}, {200., 980729.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980733.91}, {200., 980733.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980735.36}, {200., 980735.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980741.69}, {200., 980741.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980756.73}, {200., 980756.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980760.65}, {200., 980760.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980761.65}, {200., 980761.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980768.45}, {200., 980768.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980796.32}, {200., 980796.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980807.}, {200., 980807.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980818.97}, {200., 980818.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980824.93}, {200., 980824.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980834.36}, {200., 980834.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980846.73}, {200., 980846.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980864.79}, {200., 980864.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980865.07}, {200., 980865.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980881.31}, {200., 980881.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980885.95}, {200., 980885.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980907.75}, {200., 980907.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980916.43}, {200., 980916.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980930.85}, {200., 980930.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980937.94}, {200., 980937.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980942.65}, {200., 980942.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980971.77}, {200., 980971.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980984.13}, {200., 980984.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980991.74}, {200., 980991.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 980998.79}, {200., 980998.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981008.26}, {200., 981008.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981032.98}, {200., 981032.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981038.52}, {200., 981038.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981055.49}, {200., 981055.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981062.8}, {200., 981062.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981080.23}, {200., 981080.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981089.05}, {200., 981089.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981100.33}, {200., 981100.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981100.51}, {200., 981100.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981107.2}, {200., 981107.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981131.73}, {200., 981131.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981171.79}, {200., 981171.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981171.81}, {200., 981171.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981177.81}, {200., 981177.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981179.71}, {200., 981179.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981192.14}, {200., 981192.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981208.07}, {200., 981208.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981232.45}, {200., 981232.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981262.55}, {200., 981262.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981280.68}, {200., 981280.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981295.75}, {200., 981295.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981300.81}, {200., 981300.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981307.82}, {200., 981307.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981314.66}, {200., 981314.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981358.07}, {200., 981358.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981385.87}, {200., 981385.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981412.42}, {200., 981412.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981420.49}, {200., 981420.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981424.18}, {200., 981424.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981426.81}, {200., 981426.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981481.6}, {200., 981481.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981490.38}, {200., 981490.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981531.35}, {200., 981531.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981539.87}, {200., 981539.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981550.5}, {200., 981550.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981610.4}, {200., 981610.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981654.66}, {200., 981654.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981672.34}, {200., 981672.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981734.96}, {200., 981734.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981768.53}, {200., 981768.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981792.62}, {200., 981792.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981859.72}, {200., 981859.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{200., 981911.57}, {200., 981911.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980223.67}, {250., 980223.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980274.52}, {250., 980274.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980319.89}, {250., 980319.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980339.2}, {250., 980339.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980382.98}, {250., 980382.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999682], 
      PointBox[{{250., 980389.65}, {250., 980389.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980411.86}, {250., 980411.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980447.94}, {250., 980447.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980452.86}, {250., 980452.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980473.48}, {250., 980473.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980489.53}, {250., 980489.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980512.21}, {250., 980512.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980526.21}, {250., 980526.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980550.17}, {250., 980550.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980555.84}, {250., 980555.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980570.71}, {250., 980570.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980581.55}, {250., 980581.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980601.72}, {250., 980601.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980612.8}, {250., 980612.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980644.42}, {250., 980644.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980651.8}, {250., 980651.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980654.55}, {250., 980654.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980654.6}, {250., 980654.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980658.29}, {250., 980658.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980678.76}, {250., 980678.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980681.49}, {250., 980681.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980730.29}, {250., 980730.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980734.67}, {250., 980734.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980735.32}, {250., 980735.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980740.65}, {250., 980740.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980756.88}, {250., 980756.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980759.82}, {250., 980759.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980762.41}, {250., 980762.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980768.89}, {250., 980768.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980794.89}, {250., 980794.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980807.88}, {250., 980807.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980818.99}, {250., 980818.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980825.72}, {250., 980825.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980835.17}, {250., 980835.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980845.92}, {250., 980845.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980863.54}, {250., 980863.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980865.89}, {250., 980865.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980881.79}, {250., 980881.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980886.87}, {250., 980886.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980907.77}, {250., 980907.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980917.26}, {250., 980917.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980929.57}, {250., 980929.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980937.22}, {250., 980937.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980942.76}, {250., 980942.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980972.51}, {250., 980972.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980983.5}, {250., 980983.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980992.25}, {250., 980992.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 980998.72}, {250., 980998.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981009.13}, {250., 981009.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981032.43}, {250., 981032.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981039.05}, {250., 981039.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981054.63}, {250., 981054.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981062.12}, {250., 981062.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981080.61}, {250., 981080.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981088.78}, {250., 981088.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981101.06}, {250., 981101.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981101.25}, {250., 981101.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981107.21}, {250., 981107.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981131.5}, {250., 981131.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981171.84}, {250., 981171.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981172.37}, {250., 981172.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981177.18}, {250., 981177.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981178.58}, {250., 981178.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981191.66}, {250., 981191.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981208.65}, {250., 981208.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981232.79}, {250., 981232.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981260.89}, {250., 981260.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981281.34}, {250., 981281.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981294.41}, {250., 981294.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981301.41}, {250., 981301.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981306.77}, {250., 981306.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981315.29}, {250., 981315.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981358.55}, {250., 981358.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981386.67}, {250., 981386.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981410.97}, {250., 981410.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981421.17}, {250., 981421.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981422.98}, {250., 981422.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981427.44}, {250., 981427.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981482.23}, {250., 981482.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981491.1}, {250., 981491.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981529.77}, {250., 981529.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981538.65}, {250., 981538.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981551.16}, {250., 981551.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981610.95}, {250., 981610.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981653.43}, {250., 981653.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981673.02}, {250., 981673.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981735.59}, {250., 981735.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981767.23}, {250., 981767.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981793.32}, {250., 981793.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981860.65}, {250., 981860.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{250., 981912.28}, {250., 981912.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980222.17}, {300., 980222.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980273.67}, {300., 980273.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980319.91}, {300., 980319.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980338.51}, {300., 980338.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980382.9}, {300., 980382.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999619], 
      PointBox[{{300., 980390.59}, {300., 980390.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980411.16}, {300., 980411.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980448.74}, {300., 980448.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980452.76}, {300., 980452.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980474.28}, {300., 980474.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980488.76}, {300., 980488.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980512.98}, {300., 980512.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980526.16}, {300., 980526.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980550.87}, {300., 980550.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980556.56}, {300., 980556.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980569.83}, {300., 980569.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980582.33}, {300., 980582.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980601.75}, {300., 980601.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980612.55}, {300., 980612.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980645.14}, {300., 980645.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980652.16}, {300., 980652.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980653.54}, {300., 980653.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980655.41}, {300., 980655.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980657.83}, {300., 980657.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980678.89}, {300., 980678.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980680.77}, {300., 980680.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980731.14}, {300., 980731.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980735.31}, {300., 980735.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980735.43}, {300., 980735.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980739.46}, {300., 980739.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980757.17}, {300., 980757.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980758.96}, {300., 980758.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980763.18}, {300., 980763.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980769.32}, {300., 980769.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980793.47}, {300., 980793.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980808.76}, {300., 980808.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980819.04}, {300., 980819.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980826.51}, {300., 980826.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980835.97}, {300., 980835.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980845.07}, {300., 980845.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980862.31}, {300., 980862.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980866.71}, {300., 980866.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980882.26}, {300., 980882.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980887.78}, {300., 980887.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980907.83}, {300., 980907.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980918.09}, {300., 980918.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980928.27}, {300., 980928.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980936.46}, {300., 980936.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980942.82}, {300., 980942.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980973.26}, {300., 980973.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980982.93}, {300., 980982.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980992.76}, {300., 980992.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 980998.69}, {300., 980998.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981010.}, {300., 981010.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981031.84}, {300., 981031.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981039.58}, {300., 981039.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981053.72}, {300., 981053.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981061.39}, {300., 981061.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981081.06}, {300., 981081.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981088.56}, {300., 981088.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981101.61}, {300., 981101.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981102.17}, {300., 981102.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981107.25}, {300., 981107.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981131.22}, {300., 981131.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981171.78}, {300., 981171.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981172.94}, {300., 981172.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981176.62}, {300., 981176.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981177.44}, {300., 981177.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981191.31}, {300., 981191.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981209.23}, {300., 981209.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981233.14}, {300., 981233.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981259.24}, {300., 981259.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981281.97}, {300., 981281.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981293.06}, {300., 981293.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981302.02}, {300., 981302.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981305.76}, {300., 981305.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981315.91}, {300., 981315.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981359.01}, {300., 981359.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981387.48}, {300., 981387.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981409.52}, {300., 981409.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981421.82}, {300., 981421.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981421.84}, {300., 981421.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981428.07}, {300., 981428.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981482.84}, {300., 981482.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981491.83}, {300., 981491.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981528.19}, {300., 981528.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981537.46}, {300., 981537.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981551.82}, {300., 981551.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981611.45}, {300., 981611.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981652.24}, {300., 981652.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981673.71}, {300., 981673.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981736.17}, {300., 981736.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981765.98}, {300., 981765.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981794.03}, {300., 981794.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981861.58}, {300., 981861.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{300., 981912.99}, {300., 981912.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980220.66}, {350., 980220.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980272.76}, {350., 980272.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980319.97}, {350., 980319.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980337.75}, {350., 980337.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980382.86}, {350., 980382.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999555], 
      PointBox[{{350., 980391.52}, {350., 980391.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980410.39}, {350., 980410.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980449.54}, {350., 980449.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980452.72}, {350., 980452.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980475.08}, {350., 980475.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980487.91}, {350., 980487.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980513.75}, {350., 980513.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980526.17}, {350., 980526.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980551.57}, {350., 980551.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980557.26}, {350., 980557.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980568.86}, {350., 980568.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980583.11}, {350., 980583.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980601.85}, {350., 980601.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980612.25}, {350., 980612.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980645.87}, {350., 980645.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980652.44}, {350., 980652.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980652.51}, {350., 980652.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980656.22}, {350., 980656.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980657.43}, {350., 980657.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980679.11}, {350., 980679.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980680.}, {350., 980680.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980731.99}, {350., 980731.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980735.34}, {350., 980735.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980736.18}, {350., 980736.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980738.16}, {350., 980738.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980757.56}, {350., 980757.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980758.07}, {350., 980758.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980763.96}, {350., 980763.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980769.74}, {350., 980769.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980792.04}, {350., 980792.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980809.65}, {350., 980809.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980819.11}, {350., 980819.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980827.3}, {350., 980827.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980836.77}, {350., 980836.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980844.19}, {350., 980844.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980861.1}, {350., 980861.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980867.54}, {350., 980867.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980882.72}, {350., 980882.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980888.69}, {350., 980888.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980907.92}, {350., 980907.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980918.92}, {350., 980918.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980926.96}, {350., 980926.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980935.67}, {350., 980935.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980942.83}, {350., 980942.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980974.02}, {350., 980974.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980982.41}, {350., 980982.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980993.26}, {350., 980993.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 980998.69}, {350., 980998.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981010.87}, {350., 981010.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981031.2}, {350., 981031.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981040.12}, {350., 981040.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981052.75}, {350., 981052.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981060.63}, {350., 981060.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981081.56}, {350., 981081.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981088.39}, {350., 981088.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981102.14}, {350., 981102.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981103.1}, {350., 981103.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981107.33}, {350., 981107.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981130.88}, {350., 981130.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981171.61}, {350., 981171.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981173.51}, {350., 981173.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981176.12}, {350., 981176.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981176.28}, {350., 981176.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981191.08}, {350., 981191.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981209.81}, {350., 981209.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981233.48}, {350., 981233.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981257.59}, {350., 981257.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981282.57}, {350., 981282.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981291.71}, {350., 981291.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981302.63}, {350., 981302.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981304.8}, {350., 981304.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981316.53}, {350., 981316.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981359.45}, {350., 981359.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981388.29}, {350., 981388.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981408.06}, {350., 981408.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981420.68}, {350., 981420.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981422.5}, {350., 981422.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981428.72}, {350., 981428.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981483.42}, {350., 981483.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981492.56}, {350., 981492.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981526.61}, {350., 981526.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981536.31}, {350., 981536.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981552.49}, {350., 981552.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981611.92}, {350., 981611.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981651.09}, {350., 981651.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981674.4}, {350., 981674.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981736.7}, {350., 981736.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981764.78}, {350., 981764.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981794.73}, {350., 981794.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981862.52}, {350., 981862.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{350., 981913.71}, {350., 981913.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980219.15}, {400., 980219.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980271.8}, {400., 980271.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980320.08}, {400., 980320.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980336.94}, {400., 980336.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980382.88}, {400., 980382.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999492], 
      PointBox[{{400., 980392.46}, {400., 980392.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980409.56}, {400., 980409.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980450.35}, {400., 980450.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980452.74}, {400., 980452.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980475.87}, {400., 980475.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980486.99}, {400., 980486.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980514.53}, {400., 980514.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980526.24}, {400., 980526.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980552.28}, {400., 980552.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980557.97}, {400., 980557.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980567.82}, {400., 980567.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980583.9}, {400., 980583.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980602.02}, {400., 980602.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980611.89}, {400., 980611.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980646.59}, {400., 980646.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980651.25}, {400., 980651.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980652.86}, {400., 980652.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980657.04}, {400., 980657.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980657.08}, {400., 980657.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980679.21}, {400., 980679.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980679.41}, {400., 980679.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980732.84}, {400., 980732.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980735.41}, {400., 980735.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980736.79}, {400., 980736.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980736.93}, {400., 980736.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980757.15}, {400., 980757.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980758.04}, {400., 980758.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980764.74}, {400., 980764.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980770.14}, {400., 980770.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980790.61}, {400., 980790.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980810.53}, {400., 980810.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980819.2}, {400., 980819.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980828.08}, {400., 980828.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980837.57}, {400., 980837.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980843.28}, {400., 980843.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980859.91}, {400., 980859.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980868.37}, {400., 980868.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980883.18}, {400., 980883.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980889.6}, {400., 980889.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980908.03}, {400., 980908.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980919.74}, {400., 980919.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980925.63}, {400., 980925.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980934.84}, {400., 980934.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980942.79}, {400., 980942.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980974.79}, {400., 980974.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980981.95}, {400., 980981.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980993.75}, {400., 980993.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 980998.74}, {400., 980998.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981011.74}, {400., 981011.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981030.52}, {400., 981030.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981040.66}, {400., 981040.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981051.75}, {400., 981051.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981059.84}, {400., 981059.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981082.1}, {400., 981082.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981088.27}, {400., 981088.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981102.67}, {400., 981102.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981104.02}, {400., 981104.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981107.43}, {400., 981107.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981130.47}, {400., 981130.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981171.33}, {400., 981171.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981174.1}, {400., 981174.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981175.11}, {400., 981175.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981175.68}, {400., 981175.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981190.97}, {400., 981190.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981210.37}, {400., 981210.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981233.83}, {400., 981233.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981255.94}, {400., 981255.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981283.13}, {400., 981283.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981290.36}, {400., 981290.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981303.24}, {400., 981303.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981303.91}, {400., 981303.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981317.14}, {400., 981317.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981359.87}, {400., 981359.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981389.1}, {400., 981389.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981406.6}, {400., 981406.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981419.57}, {400., 981419.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981423.17}, {400., 981423.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981429.36}, {400., 981429.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981483.96}, {400., 981483.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981493.3}, {400., 981493.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981525.03}, {400., 981525.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981535.2}, {400., 981535.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981553.16}, {400., 981553.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981612.34}, {400., 981612.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981650.}, {400., 981650.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981675.09}, {400., 981675.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981737.16}, {400., 981737.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981763.65}, {400., 981763.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981795.44}, {400., 981795.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981863.45}, {400., 981863.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{400., 981914.43}, {400., 981914.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980217.63}, {450., 980217.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980270.8}, {450., 980270.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980320.22}, {450., 980320.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980336.07}, {450., 980336.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980382.94}, {450., 980382.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999428], 
      PointBox[{{450., 980393.39}, {450., 980393.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980408.67}, {450., 980408.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980451.16}, {450., 980451.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980452.81}, {450., 980452.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980476.67}, {450., 980476.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980486.01}, {450., 980486.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980515.31}, {450., 980515.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980526.38}, {450., 980526.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980552.99}, {450., 980552.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980558.67}, {450., 980558.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980566.72}, {450., 980566.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980584.69}, {450., 980584.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980602.25}, {450., 980602.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980611.48}, {450., 980611.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980647.3}, {450., 980647.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980649.99}, {450., 980649.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980653.19}, {450., 980653.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980656.8}, {450., 980656.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980657.85}, {450., 980657.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980678.37}, {450., 980678.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980679.77}, {450., 980679.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980733.69}, {450., 980733.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980735.35}, {450., 980735.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980735.51}, {450., 980735.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980737.67}, {450., 980737.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980756.21}, {450., 980756.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980758.57}, {450., 980758.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980765.52}, {450., 980765.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980770.54}, {450., 980770.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980789.18}, {450., 980789.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980811.42}, {450., 980811.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980819.32}, {450., 980819.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980828.86}, {450., 980828.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980838.37}, {450., 980838.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980842.35}, {450., 980842.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980858.74}, {450., 980858.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980869.2}, {450., 980869.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980883.62}, {450., 980883.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980890.52}, {450., 980890.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980908.18}, {450., 980908.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980920.56}, {450., 980920.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980924.3}, {450., 980924.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980933.98}, {450., 980933.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980942.71}, {450., 980942.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980975.58}, {450., 980975.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980981.54}, {450., 980981.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980994.23}, {450., 980994.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 980998.82}, {450., 980998.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981012.61}, {450., 981012.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981029.8}, {450., 981029.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981041.21}, {450., 981041.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981050.71}, {450., 981050.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981059.02}, {450., 981059.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981082.69}, {450., 981082.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981088.19}, {450., 981088.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981103.19}, {450., 981103.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981104.94}, {450., 981104.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981107.57}, {450., 981107.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981130.01}, {450., 981130.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981170.95}, {450., 981170.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981173.92}, {450., 981173.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981174.68}, {450., 981174.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981175.31}, {450., 981175.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981190.98}, {450., 981190.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981210.93}, {450., 981210.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981234.17}, {450., 981234.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981254.29}, {450., 981254.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981283.65}, {450., 981283.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981289.}, {450., 981289.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981303.08}, {450., 981303.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981303.86}, {450., 981303.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981317.75}, {450., 981317.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981360.27}, {450., 981360.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981389.91}, {450., 981389.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981405.13}, {450., 981405.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981418.49}, {450., 981418.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981423.83}, {450., 981423.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981430.01}, {450., 981430.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981484.47}, {450., 981484.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981494.04}, {450., 981494.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981523.45}, {450., 981523.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981534.13}, {450., 981534.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981553.84}, {450., 981553.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981612.7}, {450., 981612.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981648.97}, {450., 981648.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981675.79}, {450., 981675.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981737.54}, {450., 981737.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981762.61}, {450., 981762.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981796.16}, {450., 981796.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981864.39}, {450., 981864.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{450., 981915.16}, {450., 981915.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980216.11}, {500., 980216.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980269.76}, {500., 980269.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980320.39}, {500., 980320.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980335.15}, {500., 980335.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980383.05}, {500., 980383.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999365], 
      PointBox[{{500., 980394.32}, {500., 980394.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980407.72}, {500., 980407.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980451.97}, {500., 980451.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980452.93}, {500., 980452.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980477.47}, {500., 980477.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980484.97}, {500., 980484.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980516.09}, {500., 980516.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980526.57}, {500., 980526.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980553.7}, {500., 980553.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980559.37}, {500., 980559.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980565.55}, {500., 980565.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980585.47}, {500., 980585.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980602.54}, {500., 980602.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980611.01}, {500., 980611.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980648.01}, {500., 980648.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980648.67}, {500., 980648.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980653.51}, {500., 980653.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980656.57}, {500., 980656.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980658.67}, {500., 980658.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980677.51}, {500., 980677.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980680.19}, {500., 980680.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980733.86}, {500., 980733.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980734.54}, {500., 980734.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980735.64}, {500., 980735.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980738.41}, {500., 980738.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980755.24}, {500., 980755.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980759.15}, {500., 980759.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980766.31}, {500., 980766.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980770.92}, {500., 980770.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980787.75}, {500., 980787.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980812.3}, {500., 980812.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980819.46}, {500., 980819.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980829.64}, {500., 980829.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980839.16}, {500., 980839.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980841.39}, {500., 980841.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980857.59}, {500., 980857.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980870.04}, {500., 980870.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980884.05}, {500., 980884.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980891.43}, {500., 980891.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980908.34}, {500., 980908.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980921.38}, {500., 980921.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980922.97}, {500., 980922.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980933.09}, {500., 980933.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980942.58}, {500., 980942.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980976.36}, {500., 980976.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980981.19}, {500., 980981.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980994.7}, {500., 980994.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 980998.93}, {500., 980998.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981013.48}, {500., 981013.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981029.04}, {500., 981029.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981041.77}, {500., 981041.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981049.64}, {500., 981049.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981058.16}, {500., 981058.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981083.31}, {500., 981083.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981088.16}, {500., 981088.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981103.69}, {500., 981103.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981105.86}, {500., 981105.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981107.72}, {500., 981107.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981129.48}, {500., 981129.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981170.47}, {500., 981170.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981172.73}, {500., 981172.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981175.}, {500., 981175.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981175.28}, {500., 981175.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981191.1}, {500., 981191.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981211.49}, {500., 981211.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981234.5}, {500., 981234.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981252.64}, {500., 981252.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981284.11}, {500., 981284.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981287.64}, {500., 981287.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981302.34}, {500., 981302.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981304.49}, {500., 981304.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981318.35}, {500., 981318.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981360.64}, {500., 981360.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981390.73}, {500., 981390.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981403.67}, {500., 981403.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981417.45}, {500., 981417.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981424.48}, {500., 981424.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981430.67}, {500., 981430.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981484.94}, {500., 981484.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981494.78}, {500., 981494.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981521.87}, {500., 981521.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981533.1}, {500., 981533.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981554.52}, {500., 981554.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981613.01}, {500., 981613.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981648.}, {500., 981648.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981676.49}, {500., 981676.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981737.84}, {500., 981737.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981761.66}, {500., 981761.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981796.87}, {500., 981796.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981865.32}, {500., 981865.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{500., 981915.88}, {500., 981915.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980214.58}, {550., 980214.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980268.67}, {550., 980268.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980320.59}, {550., 980320.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980334.18}, {550., 980334.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980383.19}, {550., 980383.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999301], 
      PointBox[{{550., 980395.26}, {550., 980395.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980406.71}, {550., 980406.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980452.78}, {550., 980452.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980453.1}, {550., 980453.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980478.26}, {550., 980478.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980483.87}, {550., 980483.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980516.87}, {550., 980516.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980526.8}, {550., 980526.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980554.42}, {550., 980554.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980560.06}, {550., 980560.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980564.32}, {550., 980564.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980586.26}, {550., 980586.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980602.88}, {550., 980602.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980610.48}, {550., 980610.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980647.31}, {550., 980647.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980648.72}, {550., 980648.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980653.82}, {550., 980653.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980656.4}, {550., 980656.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980659.49}, {550., 980659.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980676.61}, {550., 980676.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980680.66}, {550., 980680.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980732.33}, {550., 980732.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980735.39}, {550., 980735.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980735.81}, {550., 980735.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980739.15}, {550., 980739.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980754.25}, {550., 980754.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980759.76}, {550., 980759.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980767.11}, {550., 980767.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980771.3}, {550., 980771.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980786.32}, {550., 980786.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980813.19}, {550., 980813.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980819.61}, {550., 980819.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980830.42}, {550., 980830.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980839.96}, {550., 980839.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980840.41}, {550., 980840.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980856.46}, {550., 980856.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980870.87}, {550., 980870.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980884.46}, {550., 980884.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980892.34}, {550., 980892.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980908.53}, {550., 980908.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980921.62}, {550., 980921.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980922.2}, {550., 980922.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980932.17}, {550., 980932.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980942.41}, {550., 980942.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980977.16}, {550., 980977.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980980.9}, {550., 980980.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980995.16}, {550., 980995.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 980999.08}, {550., 980999.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981014.34}, {550., 981014.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981028.23}, {550., 981028.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981042.34}, {550., 981042.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981048.55}, {550., 981048.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981057.29}, {550., 981057.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981083.96}, {550., 981083.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981088.17}, {550., 981088.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981104.2}, {550., 981104.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981106.78}, {550., 981106.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981107.9}, {550., 981107.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981128.9}, {550., 981128.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981169.91}, {550., 981169.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981171.53}, {550., 981171.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981174.76}, {550., 981174.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981175.88}, {550., 981175.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981191.32}, {550., 981191.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981212.03}, {550., 981212.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981234.83}, {550., 981234.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981250.99}, {550., 981250.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981284.49}, {550., 981284.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981286.27}, {550., 981286.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981301.69}, {550., 981301.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981305.12}, {550., 981305.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981318.95}, {550., 981318.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981360.99}, {550., 981360.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981391.54}, {550., 981391.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981402.2}, {550., 981402.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981416.45}, {550., 981416.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981425.14}, {550., 981425.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981431.33}, {550., 981431.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981485.36}, {550., 981485.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981495.53}, {550., 981495.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981520.28}, {550., 981520.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981532.12}, {550., 981532.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981555.21}, {550., 981555.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981613.25}, {550., 981613.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981647.1}, {550., 981647.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981677.19}, {550., 981677.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981738.03}, {550., 981738.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981760.82}, {550., 981760.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981797.59}, {550., 981797.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981866.26}, {550., 981866.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{550., 981916.61}, {550., 981916.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980213.04}, {600., 980213.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980267.55}, {600., 980267.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980320.82}, {600., 980320.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980333.16}, {600., 980333.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980383.38}, {600., 980383.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999238], 
      PointBox[{{600., 980396.19}, {600., 980396.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980405.66}, {600., 980405.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980453.31}, {600., 980453.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980453.59}, {600., 980453.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980479.06}, {600., 980479.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980482.72}, {600., 980482.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980517.65}, {600., 980517.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980527.09}, {600., 980527.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980555.15}, {600., 980555.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980560.75}, {600., 980560.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980563.05}, {600., 980563.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980587.05}, {600., 980587.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980603.26}, {600., 980603.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980609.91}, {600., 980609.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980645.9}, {600., 980645.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980649.42}, {600., 980649.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980654.11}, {600., 980654.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980656.28}, {600., 980656.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980660.31}, {600., 980660.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980675.68}, {600., 980675.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980681.16}, {600., 980681.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980730.77}, {600., 980730.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980736.}, {600., 980736.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980736.25}, {600., 980736.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980739.88}, {600., 980739.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980753.23}, {600., 980753.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980760.4}, {600., 980760.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980767.91}, {600., 980767.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980771.66}, {600., 980771.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980784.9}, {600., 980784.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980814.08}, {600., 980814.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980819.77}, {600., 980819.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980831.19}, {600., 980831.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980839.4}, {600., 980839.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980840.75}, {600., 980840.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980855.36}, {600., 980855.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980871.71}, {600., 980871.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980884.87}, {600., 980884.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980893.26}, {600., 980893.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980908.73}, {600., 980908.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980920.27}, {600., 980920.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980923.01}, {600., 980923.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980931.22}, {600., 980931.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980942.19}, {600., 980942.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980977.96}, {600., 980977.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980980.66}, {600., 980980.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980995.61}, {600., 980995.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 980999.25}, {600., 980999.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981015.21}, {600., 981015.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981027.39}, {600., 981027.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981042.91}, {600., 981042.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981047.45}, {600., 981047.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981056.39}, {600., 981056.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981084.63}, {600., 981084.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981088.22}, {600., 981088.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981104.69}, {600., 981104.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981107.7}, {600., 981107.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981108.09}, {600., 981108.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981128.25}, {600., 981128.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981169.27}, {600., 981169.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981170.32}, {600., 981170.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981174.58}, {600., 981174.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981176.48}, {600., 981176.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981191.63}, {600., 981191.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981212.57}, {600., 981212.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981235.14}, {600., 981235.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981249.35}, {600., 981249.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981284.81}, {600., 981284.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981284.9}, {600., 981284.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981301.15}, {600., 981301.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981305.76}, {600., 981305.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981319.54}, {600., 981319.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981361.3}, {600., 981361.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981392.35}, {600., 981392.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981400.73}, {600., 981400.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981415.49}, {600., 981415.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981425.78}, {600., 981425.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981432.}, {600., 981432.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981485.73}, {600., 981485.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981496.28}, {600., 981496.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981518.7}, {600., 981518.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981531.19}, {600., 981531.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981555.9}, {600., 981555.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981613.41}, {600., 981613.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981646.28}, {600., 981646.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981677.9}, {600., 981677.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981738.1}, {600., 981738.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981760.1}, {600., 981760.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981798.32}, {600., 981798.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981867.19}, {600., 981867.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{600., 981917.35}, {600., 981917.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980211.5}, {650., 980211.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980266.4}, {650., 980266.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980321.08}, {650., 980321.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980332.1}, {650., 980332.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980383.6}, {650., 980383.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999174], 
      PointBox[{{650., 980397.13}, {650., 980397.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980404.56}, {650., 980404.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980453.56}, {650., 980453.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980454.41}, {650., 980454.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980479.85}, {650., 980479.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980481.53}, {650., 980481.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980518.44}, {650., 980518.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980527.41}, {650., 980527.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980555.87}, {650., 980555.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980561.43}, {650., 980561.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980561.74}, {650., 980561.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980587.85}, {650., 980587.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980603.68}, {650., 980603.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980609.28}, {650., 980609.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980644.45}, {650., 980644.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980650.12}, {650., 980650.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980654.4}, {650., 980654.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980656.22}, {650., 980656.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980661.12}, {650., 980661.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980674.73}, {650., 980674.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980681.69}, {650., 980681.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980729.18}, {650., 980729.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980736.21}, {650., 980736.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980737.1}, {650., 980737.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980740.61}, {650., 980740.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980752.2}, {650., 980752.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980761.06}, {650., 980761.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980768.71}, {650., 980768.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980772.01}, {650., 980772.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980783.47}, {650., 980783.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980814.96}, {650., 980814.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980819.94}, {650., 980819.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980831.96}, {650., 980831.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980838.38}, {650., 980838.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980841.54}, {650., 980841.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980854.29}, {650., 980854.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980872.55}, {650., 980872.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980885.27}, {650., 980885.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980894.17}, {650., 980894.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980908.96}, {650., 980908.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980918.91}, {650., 980918.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980923.83}, {650., 980923.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980930.25}, {650., 980930.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980941.93}, {650., 980941.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980978.77}, {650., 980978.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980980.47}, {650., 980980.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980996.05}, {650., 980996.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 980999.46}, {650., 980999.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981016.07}, {650., 981016.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981026.52}, {650., 981026.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981043.49}, {650., 981043.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981046.33}, {650., 981046.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981055.47}, {650., 981055.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981085.33}, {650., 981085.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981088.31}, {650., 981088.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981105.17}, {650., 981105.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981108.29}, {650., 981108.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981108.62}, {650., 981108.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981127.56}, {650., 981127.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981168.58}, {650., 981168.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981169.11}, {650., 981169.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981174.46}, {650., 981174.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981177.1}, {650., 981177.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981192.01}, {650., 981192.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981213.1}, {650., 981213.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981235.43}, {650., 981235.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981247.71}, {650., 981247.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981283.54}, {650., 981283.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981285.03}, {650., 981285.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981300.72}, {650., 981300.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981306.4}, {650., 981306.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981320.12}, {650., 981320.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981361.57}, {650., 981361.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981393.15}, {650., 981393.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981399.26}, {650., 981399.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981414.58}, {650., 981414.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981426.42}, {650., 981426.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981432.67}, {650., 981432.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981486.04}, {650., 981486.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981497.04}, {650., 981497.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981517.12}, {650., 981517.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981530.32}, {650., 981530.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981556.59}, {650., 981556.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981613.49}, {650., 981613.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981645.54}, {650., 981645.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981678.61}, {650., 981678.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981738.04}, {650., 981738.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981759.52}, {650., 981759.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981799.04}, {650., 981799.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981868.12}, {650., 981868.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{650., 981918.08}, {650., 981918.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980209.95}, {700., 980209.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980265.21}, {700., 980265.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980321.36}, {700., 980321.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980331.}, {700., 980331.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980383.86}, {700., 980383.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999111], 
      PointBox[{{700., 980398.06}, {700., 980398.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980403.42}, {700., 980403.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980453.84}, {700., 980453.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980455.22}, {700., 980455.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980480.29}, {700., 980480.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980480.64}, {700., 980480.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980519.22}, {700., 980519.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980527.76}, {700., 980527.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980556.6}, {700., 980556.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980560.39}, {700., 980560.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980562.11}, {700., 980562.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980588.64}, {700., 980588.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980604.13}, {700., 980604.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980608.6}, {700., 980608.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980642.97}, {700., 980642.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980650.81}, {700., 980650.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980654.67}, {700., 980654.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980656.21}, {700., 980656.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980661.94}, {700., 980661.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980673.75}, {700., 980673.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980682.26}, {700., 980682.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980727.58}, {700., 980727.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980736.45}, {700., 980736.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980737.95}, {700., 980737.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980741.34}, {700., 980741.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980751.15}, {700., 980751.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980761.74}, {700., 980761.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980769.52}, {700., 980769.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980772.34}, {700., 980772.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980782.05}, {700., 980782.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980815.85}, {700., 980815.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980820.11}, {700., 980820.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980832.72}, {700., 980832.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980837.34}, {700., 980837.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980842.33}, {700., 980842.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980853.24}, {700., 980853.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980873.4}, {700., 980873.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980885.65}, {700., 980885.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980895.09}, {700., 980895.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980909.19}, {700., 980909.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980917.55}, {700., 980917.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980924.64}, {700., 980924.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980929.25}, {700., 980929.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980941.63}, {700., 980941.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980979.59}, {700., 980979.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980980.34}, {700., 980980.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980996.47}, {700., 980996.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 980999.69}, {700., 980999.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981016.93}, {700., 981016.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981025.61}, {700., 981025.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981044.07}, {700., 981044.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981045.2}, {700., 981045.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981054.54}, {700., 981054.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981086.04}, {700., 981086.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981088.44}, {700., 981088.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981105.64}, {700., 981105.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981108.5}, {700., 981108.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981109.54}, {700., 981109.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981126.81}, {700., 981126.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981167.84}, {700., 981167.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981167.89}, {700., 981167.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981174.4}, {700., 981174.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981177.71}, {700., 981177.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981192.46}, {700., 981192.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981213.62}, {700., 981213.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981235.71}, {700., 981235.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981246.07}, {700., 981246.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981282.17}, {700., 981282.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981285.16}, {700., 981285.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981300.42}, {700., 981300.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981307.05}, {700., 981307.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981320.7}, {700., 981320.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981361.81}, {700., 981361.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981393.95}, {700., 981393.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981397.79}, {700., 981397.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981413.72}, {700., 981413.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981427.06}, {700., 981427.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981433.34}, {700., 981433.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981486.3}, {700., 981486.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981497.8}, {700., 981497.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981515.53}, {700., 981515.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981529.51}, {700., 981529.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981557.29}, {700., 981557.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981613.49}, {700., 981613.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981644.89}, {700., 981644.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981679.33}, {700., 981679.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981737.84}, {700., 981737.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981759.08}, {700., 981759.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981799.77}, {700., 981799.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981869.06}, {700., 981869.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{700., 981918.82}, {700., 981918.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980208.4}, {750., 980208.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980263.99}, {750., 980263.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980321.66}, {750., 980321.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980329.86}, {750., 980329.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980384.14}, {750., 980384.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99999047], 
      PointBox[{{750., 980399.}, {750., 980399.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980402.24}, {750., 980402.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980454.16}, {750., 980454.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980456.04}, {750., 980456.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980479.02}, {750., 980479.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980481.43}, {750., 980481.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980520.01}, {750., 980520.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980528.15}, {750., 980528.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980557.33}, {750., 980557.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980559.}, {750., 980559.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980562.79}, {750., 980562.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980589.43}, {750., 980589.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980604.62}, {750., 980604.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980607.87}, {750., 980607.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980641.46}, {750., 980641.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980651.5}, {750., 980651.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980654.93}, {750., 980654.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980656.26}, {750., 980656.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980662.76}, {750., 980662.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980672.75}, {750., 980672.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980682.84}, {750., 980682.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980725.96}, {750., 980725.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980736.71}, {750., 980736.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980738.81}, {750., 980738.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980742.06}, {750., 980742.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980750.09}, {750., 980750.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980762.43}, {750., 980762.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980770.34}, {750., 980770.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980772.67}, {750., 980772.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980780.63}, {750., 980780.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980816.74}, {750., 980816.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980820.29}, {750., 980820.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980833.48}, {750., 980833.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980836.28}, {750., 980836.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980843.12}, {750., 980843.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980852.23}, {750., 980852.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980874.24}, {750., 980874.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980886.03}, {750., 980886.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980896.}, {750., 980896.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980909.44}, {750., 980909.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980916.19}, {750., 980916.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980925.44}, {750., 980925.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980928.24}, {750., 980928.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980941.29}, {750., 980941.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980980.25}, {750., 980980.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980980.41}, {750., 980980.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980996.89}, {750., 980996.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 980999.95}, {750., 980999.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981017.79}, {750., 981017.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981024.68}, {750., 981024.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981044.06}, {750., 981044.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981044.67}, {750., 981044.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981053.59}, {750., 981053.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981086.78}, {750., 981086.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981088.61}, {750., 981088.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981106.11}, {750., 981106.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981108.72}, {750., 981108.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981110.46}, {750., 981110.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981126.}, {750., 981126.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981166.67}, {750., 981166.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981167.06}, {750., 981167.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981174.39}, {750., 981174.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981178.34}, {750., 981178.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981192.97}, {750., 981192.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981214.14}, {750., 981214.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981235.96}, {750., 981235.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981244.43}, {750., 981244.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981280.8}, {750., 981280.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981285.19}, {750., 981285.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981300.26}, {750., 981300.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981307.7}, {750., 981307.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981321.27}, {750., 981321.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981362.}, {750., 981362.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981394.75}, {750., 981394.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981396.32}, {750., 981396.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981412.91}, {750., 981412.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981427.7}, {750., 981427.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981434.02}, {750., 981434.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981486.49}, {750., 981486.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981498.57}, {750., 981498.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981513.95}, {750., 981513.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981528.76}, {750., 981528.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981557.99}, {750., 981557.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981613.39}, {750., 981613.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981644.34}, {750., 981644.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981680.05}, {750., 981680.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981737.5}, {750., 981737.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981758.79}, {750., 981758.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981800.5}, {750., 981800.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981869.99}, {750., 981869.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{750., 981919.56}, {750., 981919.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980206.85}, {800., 980206.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980262.75}, {800., 980262.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980321.98}, {800., 980321.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980328.68}, {800., 980328.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980384.45}, {800., 980384.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998983], 
      PointBox[{{800., 980399.93}, {800., 980399.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980401.02}, {800., 980401.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980454.51}, {800., 980454.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980456.87}, {800., 980456.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980477.71}, {800., 980477.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980482.21}, {800., 980482.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980520.8}, {800., 980520.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980528.57}, {800., 980528.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980557.58}, {800., 980557.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980558.07}, {800., 980558.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980563.46}, {800., 980563.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980590.22}, {800., 980590.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980605.12}, {800., 980605.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980607.1}, {800., 980607.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980639.94}, {800., 980639.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980652.19}, {800., 980652.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980655.18}, {800., 980655.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980656.35}, {800., 980656.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980663.58}, {800., 980663.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980671.72}, {800., 980671.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980683.45}, {800., 980683.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980724.32}, {800., 980724.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980736.98}, {800., 980736.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980739.66}, {800., 980739.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980742.78}, {800., 980742.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980749.01}, {800., 980749.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980763.13}, {800., 980763.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980771.15}, {800., 980771.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980772.98}, {800., 980772.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980779.22}, {800., 980779.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980817.63}, {800., 980817.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980820.46}, {800., 980820.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980834.24}, {800., 980834.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980835.2}, {800., 980835.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980843.9}, {800., 980843.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980851.25}, {800., 980851.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980875.09}, {800., 980875.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980886.39}, {800., 980886.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980896.92}, {800., 980896.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980909.7}, {800., 980909.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980914.82}, {800., 980914.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980926.25}, {800., 980926.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980927.2}, {800., 980927.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980940.93}, {800., 980940.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980980.2}, {800., 980980.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980981.23}, {800., 980981.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 980997.3}, {800., 980997.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981000.23}, {800., 981000.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981018.65}, {800., 981018.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981023.71}, {800., 981023.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981042.92}, {800., 981042.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981045.26}, {800., 981045.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981052.63}, {800., 981052.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981087.52}, {800., 981087.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981088.81}, {800., 981088.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981106.56}, {800., 981106.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981108.94}, {800., 981108.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981111.38}, {800., 981111.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981125.15}, {800., 981125.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981165.45}, {800., 981165.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981166.26}, {800., 981166.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981174.44}, {800., 981174.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981178.97}, {800., 981178.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981193.53}, {800., 981193.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981214.64}, {800., 981214.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981236.19}, {800., 981236.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981242.8}, {800., 981242.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981279.43}, {800., 981279.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981285.13}, {800., 981285.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981300.22}, {800., 981300.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981308.36}, {800., 981308.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981321.83}, {800., 981321.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981362.16}, {800., 981362.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981394.85}, {800., 981394.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981395.54}, {800., 981395.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981412.16}, {800., 981412.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981428.32}, {800., 981428.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981434.7}, {800., 981434.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981486.61}, {800., 981486.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981499.35}, {800., 981499.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981512.36}, {800., 981512.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981528.09}, {800., 981528.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981558.69}, {800., 981558.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981613.2}, {800., 981613.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981643.9}, {800., 981643.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981680.77}, {800., 981680.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981737.01}, {800., 981737.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981758.65}, {800., 981758.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981801.24}, {800., 981801.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981870.93}, {800., 981870.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{800., 981920.31}, {800., 981920.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980205.28}, {850., 980205.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980261.48}, {850., 980261.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980322.32}, {850., 980322.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980327.47}, {850., 980327.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980384.79}, {850., 980384.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980399.77}, {850., 980399.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.9999892], 
      PointBox[{{850., 980400.86}, {850., 980400.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980454.89}, {850., 980454.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980457.69}, {850., 980457.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980476.37}, {850., 980476.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980483.}, {850., 980483.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980521.59}, {850., 980521.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980529.02}, {850., 980529.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980556.14}, {850., 980556.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980558.81}, {850., 980558.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980564.12}, {850., 980564.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980591.02}, {850., 980591.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980605.65}, {850., 980605.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980606.29}, {850., 980606.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980638.39}, {850., 980638.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980652.87}, {850., 980652.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980655.42}, {850., 980655.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980656.49}, {850., 980656.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980664.4}, {850., 980664.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980670.68}, {850., 980670.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980684.07}, {850., 980684.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980722.68}, {850., 980722.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980737.27}, {850., 980737.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980740.52}, {850., 980740.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980743.49}, {850., 980743.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980747.92}, {850., 980747.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980763.84}, {850., 980763.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980771.97}, {850., 980771.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980773.28}, {850., 980773.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980777.82}, {850., 980777.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980818.52}, {850., 980818.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980820.62}, {850., 980820.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980834.12}, {850., 980834.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980834.99}, {850., 980834.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980844.69}, {850., 980844.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980850.31}, {850., 980850.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980875.94}, {850., 980875.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980886.73}, {850., 980886.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980897.83}, {850., 980897.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980909.97}, {850., 980909.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980913.45}, {850., 980913.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980926.15}, {850., 980926.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980927.05}, {850., 980927.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980940.53}, {850., 980940.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980980.2}, {850., 980980.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980982.06}, {850., 980982.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 980997.69}, {850., 980997.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981000.53}, {850., 981000.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981019.51}, {850., 981019.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981022.72}, {850., 981022.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981041.78}, {850., 981041.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981045.87}, {850., 981045.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981051.67}, {850., 981051.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981088.28}, {850., 981088.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981089.05}, {850., 981089.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981107.}, {850., 981107.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981109.15}, {850., 981109.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981112.3}, {850., 981112.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981124.26}, {850., 981124.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981164.22}, {850., 981164.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981165.45}, {850., 981165.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981174.53}, {850., 981174.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981179.6}, {850., 981179.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981194.13}, {850., 981194.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981215.14}, {850., 981215.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981236.39}, {850., 981236.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981241.17}, {850., 981241.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981278.07}, {850., 981278.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981284.98}, {850., 981284.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981300.31}, {850., 981300.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981309.02}, {850., 981309.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981322.39}, {850., 981322.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981362.26}, {850., 981362.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981393.38}, {850., 981393.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981396.32}, {850., 981396.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981411.48}, {850., 981411.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981428.95}, {850., 981428.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981435.39}, {850., 981435.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981486.66}, {850., 981486.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981500.13}, {850., 981500.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981510.78}, {850., 981510.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981527.48}, {850., 981527.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981559.4}, {850., 981559.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981612.91}, {850., 981612.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981643.55}, {850., 981643.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981681.5}, {850., 981681.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981736.38}, {850., 981736.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981758.65}, {850., 981758.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981801.98}, {850., 981801.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981871.86}, {850., 981871.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{850., 981921.05}, {850., 981921.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980203.72}, {900., 980203.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980260.18}, {900., 980260.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980322.67}, {900., 980322.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980326.23}, {900., 980326.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980385.15}, {900., 980385.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980398.49}, {900., 980398.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998856], 
      PointBox[{{900., 980401.8}, {900., 980401.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980455.29}, {900., 980455.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980458.51}, {900., 980458.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980475.01}, {900., 980475.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980483.78}, {900., 980483.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980522.38}, {900., 980522.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980529.48}, {900., 980529.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980554.67}, {900., 980554.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980559.55}, {900., 980559.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980564.78}, {900., 980564.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980591.81}, {900., 980591.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980605.43}, {900., 980605.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980606.2}, {900., 980606.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980636.82}, {900., 980636.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980653.54}, {900., 980653.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980655.64}, {900., 980655.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980656.67}, {900., 980656.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980665.23}, {900., 980665.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980669.62}, {900., 980669.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980684.7}, {900., 980684.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980721.02}, {900., 980721.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980737.56}, {900., 980737.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980741.38}, {900., 980741.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980744.19}, {900., 980744.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980746.81}, {900., 980746.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980764.55}, {900., 980764.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980772.79}, {900., 980772.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980773.56}, {900., 980773.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980776.43}, {900., 980776.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980819.4}, {900., 980819.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980820.78}, {900., 980820.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980833.02}, {900., 980833.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980835.74}, {900., 980835.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980845.47}, {900., 980845.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980849.41}, {900., 980849.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980876.79}, {900., 980876.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980887.07}, {900., 980887.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980898.75}, {900., 980898.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980910.24}, {900., 980910.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980912.08}, {900., 980912.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980925.07}, {900., 980925.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980927.85}, {900., 980927.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980940.11}, {900., 980940.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980980.23}, {900., 980980.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980982.89}, {900., 980982.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 980998.07}, {900., 980998.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981000.86}, {900., 981000.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981020.37}, {900., 981020.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981021.7}, {900., 981021.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981040.65}, {900., 981040.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981046.48}, {900., 981046.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981050.69}, {900., 981050.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981089.05}, {900., 981089.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981089.31}, {900., 981089.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981107.43}, {900., 981107.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981109.36}, {900., 981109.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981113.21}, {900., 981113.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981123.32}, {900., 981123.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981163.}, {900., 981163.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981164.62}, {900., 981164.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981174.68}, {900., 981174.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981180.24}, {900., 981180.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981194.77}, {900., 981194.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981215.63}, {900., 981215.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981236.56}, {900., 981236.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981239.54}, {900., 981239.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981276.7}, {900., 981276.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981284.76}, {900., 981284.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981300.52}, {900., 981300.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981309.69}, {900., 981309.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981322.94}, {900., 981322.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981362.31}, {900., 981362.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981391.91}, {900., 981391.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981397.09}, {900., 981397.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981410.86}, {900., 981410.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981429.57}, {900., 981429.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981436.08}, {900., 981436.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981486.63}, {900., 981486.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981500.92}, {900., 981500.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981509.19}, {900., 981509.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981526.96}, {900., 981526.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981560.11}, {900., 981560.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981612.53}, {900., 981612.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981643.3}, {900., 981643.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981682.23}, {900., 981682.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981735.64}, {900., 981735.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981758.78}, {900., 981758.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981802.72}, {900., 981802.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981872.8}, {900., 981872.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{900., 981921.8}, {900., 981921.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980202.15}, {950., 980202.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980258.86}, {950., 980258.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980323.04}, {950., 980323.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980324.97}, {950., 980324.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980385.53}, {950., 980385.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980397.18}, {950., 980397.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998793], 
      PointBox[{{950., 980402.73}, {950., 980402.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980455.71}, {950., 980455.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980459.34}, {950., 980459.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980473.61}, {950., 980473.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980484.56}, {950., 980484.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980523.17}, {950., 980523.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980529.97}, {950., 980529.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980553.18}, {950., 980553.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980560.29}, {950., 980560.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980565.43}, {950., 980565.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980592.61}, {950., 980592.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980604.54}, {950., 980604.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980606.77}, {950., 980606.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980635.24}, {950., 980635.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980654.21}, {950., 980654.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980655.85}, {950., 980655.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980656.89}, {950., 980656.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980666.05}, {950., 980666.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980668.55}, {950., 980668.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980685.35}, {950., 980685.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980719.35}, {950., 980719.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980737.86}, {950., 980737.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980742.23}, {950., 980742.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980744.9}, {950., 980744.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980745.7}, {950., 980745.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980765.27}, {950., 980765.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980773.62}, {950., 980773.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980773.83}, {950., 980773.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980775.05}, {950., 980775.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980820.29}, {950., 980820.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980820.91}, {950., 980820.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980831.91}, {950., 980831.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980836.49}, {950., 980836.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980846.25}, {950., 980846.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980848.56}, {950., 980848.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980877.64}, {950., 980877.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980887.39}, {950., 980887.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980899.66}, {950., 980899.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980910.51}, {950., 980910.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980910.7}, {950., 980910.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980923.99}, {950., 980923.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980928.65}, {950., 980928.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980939.68}, {950., 980939.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980980.3}, {950., 980980.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980983.72}, {950., 980983.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 980998.44}, {950., 980998.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981001.2}, {950., 981001.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981020.66}, {950., 981020.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981021.22}, {950., 981021.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981039.52}, {950., 981039.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981047.09}, {950., 981047.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981049.72}, {950., 981049.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981089.6}, {950., 981089.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981089.84}, {950., 981089.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981107.85}, {950., 981107.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981109.56}, {950., 981109.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981114.13}, {950., 981114.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981122.35}, {950., 981122.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981161.78}, {950., 981161.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981163.8}, {950., 981163.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981174.87}, {950., 981174.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981180.88}, {950., 981180.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981195.43}, {950., 981195.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981216.11}, {950., 981216.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981236.69}, {950., 981236.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981237.91}, {950., 981237.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981275.34}, {950., 981275.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981284.47}, {950., 981284.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981300.83}, {950., 981300.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981310.36}, {950., 981310.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981323.48}, {950., 981323.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981362.31}, {950., 981362.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981390.44}, {950., 981390.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981397.84}, {950., 981397.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981410.33}, {950., 981410.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981430.18}, {950., 981430.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981436.78}, {950., 981436.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981486.53}, {950., 981486.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981501.71}, {950., 981501.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981507.61}, {950., 981507.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981526.51}, {950., 981526.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981560.83}, {950., 981560.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981612.04}, {950., 981612.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981643.16}, {950., 981643.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981682.96}, {950., 981682.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981734.78}, {950., 981734.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981759.02}, {950., 981759.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981803.46}, {950., 981803.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981873.73}, {950., 981873.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{950., 981922.55}, {950., 981922.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980200.57}, {1000., 980200.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980257.52}, {1000., 980257.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980323.42}, {1000., 980323.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980323.67}, {1000., 980323.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980385.94}, {1000., 980385.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980395.84}, {1000., 980395.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998729], 
      PointBox[{{1000., 980403.67}, {1000., 980403.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980456.15}, {1000., 980456.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980460.17}, {1000., 980460.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980472.2}, {1000., 980472.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980485.33}, {1000., 980485.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980523.96}, {1000., 980523.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980530.48}, {1000., 980530.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980551.68}, {1000., 980551.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980561.04}, {1000., 980561.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980566.07}, {1000., 980566.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980593.4}, {1000., 980593.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980603.62}, {1000., 980603.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980607.35}, {1000., 980607.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980633.64}, {1000., 980633.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980654.87}, {1000., 980654.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980656.05}, {1000., 980656.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980657.16}, {1000., 980657.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980666.87}, {1000., 980666.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980667.46}, {1000., 980667.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980686.}, {1000., 980686.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980717.68}, {1000., 980717.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980738.17}, {1000., 980738.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980743.09}, {1000., 980743.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980744.58}, {1000., 980744.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980745.59}, {1000., 980745.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980765.99}, {1000., 980765.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980773.68}, {1000., 980773.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980774.09}, {1000., 980774.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980774.45}, {1000., 980774.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980821.03}, {1000., 980821.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980821.18}, {1000., 980821.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980830.79}, {1000., 980830.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980837.23}, {1000., 980837.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980847.02}, {1000., 980847.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980847.75}, {1000., 980847.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980878.49}, {1000., 980878.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980887.69}, {1000., 980887.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980900.58}, {1000., 980900.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980909.33}, {1000., 980909.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980910.78}, {1000., 980910.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980922.89}, {1000., 980922.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980929.44}, {1000., 980929.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980939.23}, {1000., 980939.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980980.4}, {1000., 980980.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980984.56}, {1000., 980984.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 980998.8}, {1000., 980998.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981001.56}, {1000., 981001.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981019.59}, {1000., 981019.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981022.07}, {1000., 981022.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981038.39}, {1000., 981038.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981047.71}, {1000., 981047.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981048.74}, {1000., 981048.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981089.92}, {1000., 981089.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981090.63}, {1000., 981090.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981108.26}, {1000., 981108.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981109.75}, {1000., 981109.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981115.05}, {1000., 981115.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981121.33}, {1000., 981121.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981160.56}, {1000., 981160.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981162.98}, {1000., 981162.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981175.1}, {1000., 981175.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981181.53}, {1000., 981181.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981196.12}, {1000., 981196.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981216.57}, {1000., 981216.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981236.29}, {1000., 981236.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981236.79}, {1000., 981236.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981273.98}, {1000., 981273.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981284.15}, {1000., 981284.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981301.23}, {1000., 981301.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981311.04}, {1000., 981311.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981324.02}, {1000., 981324.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981362.25}, {1000., 981362.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981388.98}, {1000., 981388.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981398.58}, {1000., 981398.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981409.87}, {1000., 981409.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981430.79}, {1000., 981430.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981437.48}, {1000., 981437.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981486.34}, {1000., 981486.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981502.51}, {1000., 981502.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981506.02}, {1000., 981506.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981526.14}, {1000., 981526.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981561.55}, {1000., 981561.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981611.47}, {1000., 981611.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981643.11}, {1000., 981643.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981683.69}, {1000., 981683.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981733.84}, {1000., 981733.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981759.36}, {1000., 981759.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981804.21}, {1000., 981804.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981874.66}, {1000., 981874.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1000., 981923.31}, {1000., 981923.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980198.99}, {1050., 980198.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980256.16}, {1050., 980256.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980322.35}, {1050., 980322.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980323.82}, {1050., 980323.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980386.35}, {1050., 980386.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980394.48}, {1050., 980394.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998666], 
      PointBox[{{1050., 980404.6}, {1050., 980404.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980456.61}, {1050., 980456.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980461.}, {1050., 980461.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980470.76}, {1050., 980470.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980486.11}, {1050., 980486.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980524.76}, {1050., 980524.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980531.}, {1050., 980531.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980550.15}, {1050., 980550.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980561.79}, {1050., 980561.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980566.71}, {1050., 980566.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980594.19}, {1050., 980594.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980602.66}, {1050., 980602.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980607.94}, {1050., 980607.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980632.03}, {1050., 980632.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980655.52}, {1050., 980655.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980656.23}, {1050., 980656.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980657.46}, {1050., 980657.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980666.36}, {1050., 980666.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980667.68}, {1050., 980667.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980686.67}, {1050., 980686.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980716.}, {1050., 980716.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980738.47}, {1050., 980738.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980743.45}, {1050., 980743.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980743.94}, {1050., 980743.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980746.28}, {1050., 980746.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980766.72}, {1050., 980766.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980772.34}, {1050., 980772.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980774.33}, {1050., 980774.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980775.28}, {1050., 980775.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980821.11}, {1050., 980821.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980822.07}, {1050., 980822.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980829.66}, {1050., 980829.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980837.97}, {1050., 980837.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980847.}, {1050., 980847.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980847.8}, {1050., 980847.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980879.35}, {1050., 980879.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980887.99}, {1050., 980887.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980901.49}, {1050., 980901.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980907.96}, {1050., 980907.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980911.05}, {1050., 980911.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980921.77}, {1050., 980921.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980930.23}, {1050., 980930.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980938.77}, {1050., 980938.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980980.52}, {1050., 980980.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980985.41}, {1050., 980985.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 980999.14}, {1050., 980999.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981001.93}, {1050., 981001.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981018.51}, {1050., 981018.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981022.92}, {1050., 981022.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981037.28}, {1050., 981037.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981047.76}, {1050., 981047.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981048.34}, {1050., 981048.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981090.27}, {1050., 981090.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981091.43}, {1050., 981091.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981108.66}, {1050., 981108.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981109.92}, {1050., 981109.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981115.97}, {1050., 981115.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981120.29}, {1050., 981120.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981159.34}, {1050., 981159.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981162.17}, {1050., 981162.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981175.37}, {1050., 981175.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981182.19}, {1050., 981182.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981196.83}, {1050., 981196.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981217.03}, {1050., 981217.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981234.67}, {1050., 981234.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981236.85}, {1050., 981236.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981272.63}, {1050., 981272.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981283.8}, {1050., 981283.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981301.7}, {1050., 981301.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981311.72}, {1050., 981311.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981324.54}, {1050., 981324.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981362.14}, {1050., 981362.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981387.51}, {1050., 981387.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981399.29}, {1050., 981399.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981409.5}, {1050., 981409.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981431.39}, {1050., 981431.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981438.18}, {1050., 981438.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981486.08}, {1050., 981486.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981503.31}, {1050., 981503.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981504.44}, {1050., 981504.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981525.85}, {1050., 981525.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981562.27}, {1050., 981562.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981610.8}, {1050., 981610.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981643.16}, {1050., 981643.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981684.43}, {1050., 981684.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981732.81}, {1050., 981732.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981759.79}, {1050., 981759.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981804.96}, {1050., 981804.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981875.6}, {1050., 981875.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1050., 981924.06}, {1050., 981924.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980197.4}, {1100., 980197.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980254.78}, {1100., 980254.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980321.01}, {1100., 980321.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980324.22}, {1100., 980324.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980386.79}, {1100., 980386.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980393.09}, {1100., 980393.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998602], 
      PointBox[{{1100., 980405.54}, {1100., 980405.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980457.09}, {1100., 980457.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980461.83}, {1100., 980461.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980469.3}, {1100., 980469.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980486.88}, {1100., 980486.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980525.55}, {1100., 980525.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980531.54}, {1100., 980531.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980548.61}, {1100., 980548.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980562.55}, {1100., 980562.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980567.34}, {1100., 980567.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980594.98}, {1100., 980594.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980601.68}, {1100., 980601.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980608.55}, {1100., 980608.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980630.41}, {1100., 980630.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980656.17}, {1100., 980656.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980656.4}, {1100., 980656.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980657.79}, {1100., 980657.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980665.25}, {1100., 980665.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980668.5}, {1100., 980668.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980687.34}, {1100., 980687.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980714.31}, {1100., 980714.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980738.76}, {1100., 980738.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980742.31}, {1100., 980742.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980744.8}, {1100., 980744.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980746.97}, {1100., 980746.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980767.45}, {1100., 980767.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980771.01}, {1100., 980771.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980774.56}, {1100., 980774.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980776.12}, {1100., 980776.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980821.17}, {1100., 980821.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980822.96}, {1100., 980822.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980828.52}, {1100., 980828.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980838.7}, {1100., 980838.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980846.31}, {1100., 980846.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980848.57}, {1100., 980848.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980880.21}, {1100., 980880.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980888.27}, {1100., 980888.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980902.41}, {1100., 980902.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980906.58}, {1100., 980906.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980911.31}, {1100., 980911.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980920.65}, {1100., 980920.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980931.02}, {1100., 980931.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980938.31}, {1100., 980938.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980980.66}, {1100., 980980.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980986.25}, {1100., 980986.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 980999.47}, {1100., 980999.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981002.32}, {1100., 981002.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981017.41}, {1100., 981017.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981023.77}, {1100., 981023.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981036.17}, {1100., 981036.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981046.78}, {1100., 981046.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981048.97}, {1100., 981048.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981090.64}, {1100., 981090.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981092.23}, {1100., 981092.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981109.05}, {1100., 981109.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981110.07}, {1100., 981110.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981116.89}, {1100., 981116.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981119.21}, {1100., 981119.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981158.13}, {1100., 981158.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981161.38}, {1100., 981161.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981175.67}, {1100., 981175.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981182.85}, {1100., 981182.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981197.57}, {1100., 981197.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981217.48}, {1100., 981217.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981233.05}, {1100., 981233.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981236.86}, {1100., 981236.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981271.27}, {1100., 981271.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981283.45}, {1100., 981283.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981302.24}, {1100., 981302.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981312.4}, {1100., 981312.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981325.06}, {1100., 981325.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981361.96}, {1100., 981361.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981386.05}, {1100., 981386.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981399.97}, {1100., 981399.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981409.23}, {1100., 981409.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981431.99}, {1100., 981431.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981438.89}, {1100., 981438.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981485.74}, {1100., 981485.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981502.86}, {1100., 981502.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981504.12}, {1100., 981504.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981525.65}, {1100., 981525.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981563.}, {1100., 981563.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981610.06}, {1100., 981610.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981643.29}, {1100., 981643.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981685.17}, {1100., 981685.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981731.72}, {1100., 981731.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981760.28}, {1100., 981760.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981805.71}, {1100., 981805.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981876.53}, {1100., 981876.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1100., 981924.82}, {1100., 981924.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980195.81}, {1150., 980195.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980253.38}, {1150., 980253.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980319.64}, {1150., 980319.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980324.63}, {1150., 980324.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980387.23}, {1150., 980387.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980391.69}, {1150., 980391.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998539], 
      PointBox[{{1150., 980406.47}, {1150., 980406.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980457.58}, {1150., 980457.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980462.66}, {1150., 980462.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980467.82}, {1150., 980467.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980487.65}, {1150., 980487.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980526.34}, {1150., 980526.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980532.09}, {1150., 980532.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980547.05}, {1150., 980547.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980563.31}, {1150., 980563.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980567.97}, {1150., 980567.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980595.77}, {1150., 980595.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980600.67}, {1150., 980600.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980609.16}, {1150., 980609.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980628.78}, {1150., 980628.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980656.56}, {1150., 980656.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980656.82}, {1150., 980656.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980658.16}, {1150., 980658.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980664.14}, {1150., 980664.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980669.32}, {1150., 980669.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980688.01}, {1150., 980688.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980712.62}, {1150., 980712.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980739.05}, {1150., 980739.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980741.17}, {1150., 980741.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980745.65}, {1150., 980745.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980747.65}, {1150., 980747.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980768.18}, {1150., 980768.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980769.71}, {1150., 980769.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980774.78}, {1150., 980774.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980776.95}, {1150., 980776.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980821.19}, {1150., 980821.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980823.85}, {1150., 980823.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980827.38}, {1150., 980827.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980839.43}, {1150., 980839.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980845.67}, {1150., 980845.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980849.34}, {1150., 980849.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980881.07}, {1150., 980881.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980888.53}, {1150., 980888.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980903.33}, {1150., 980903.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980905.21}, {1150., 980905.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980911.56}, {1150., 980911.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980919.51}, {1150., 980919.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980931.8}, {1150., 980931.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980937.85}, {1150., 980937.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980980.82}, {1150., 980980.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980987.1}, {1150., 980987.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 980999.79}, {1150., 980999.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981002.72}, {1150., 981002.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981016.3}, {1150., 981016.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981024.62}, {1150., 981024.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981035.08}, {1150., 981035.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981045.8}, {1150., 981045.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981049.6}, {1150., 981049.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981091.03}, {1150., 981091.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981093.04}, {1150., 981093.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981109.43}, {1150., 981109.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981110.2}, {1150., 981110.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981117.8}, {1150., 981117.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981118.11}, {1150., 981118.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981156.92}, {1150., 981156.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981160.62}, {1150., 981160.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981176.01}, {1150., 981176.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981183.51}, {1150., 981183.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981198.31}, {1150., 981198.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981217.92}, {1150., 981217.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981231.43}, {1150., 981231.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981236.83}, {1150., 981236.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981269.93}, {1150., 981269.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981283.09}, {1150., 981283.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981302.82}, {1150., 981302.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981313.09}, {1150., 981313.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981325.58}, {1150., 981325.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981361.73}, {1150., 981361.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981384.59}, {1150., 981384.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981400.61}, {1150., 981400.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981409.07}, {1150., 981409.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981432.58}, {1150., 981432.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981439.6}, {1150., 981439.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981485.31}, {1150., 981485.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981501.28}, {1150., 981501.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981504.94}, {1150., 981504.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981525.52}, {1150., 981525.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981563.73}, {1150., 981563.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981609.24}, {1150., 981609.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981643.5}, {1150., 981643.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981685.92}, {1150., 981685.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981730.57}, {1150., 981730.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981760.83}, {1150., 981760.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981806.46}, {1150., 981806.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981877.47}, {1150., 981877.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1150., 981925.58}, {1150., 981925.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980194.22}, {1200., 980194.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980251.97}, {1200., 980251.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980318.26}, {1200., 980318.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980325.05}, {1200., 980325.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980387.69}, {1200., 980387.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980390.26}, {1200., 980390.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998475], 
      PointBox[{{1200., 980407.4}, {1200., 980407.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980458.08}, {1200., 980458.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980463.5}, {1200., 980463.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980466.32}, {1200., 980466.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980488.42}, {1200., 980488.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980527.14}, {1200., 980527.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980532.65}, {1200., 980532.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980545.48}, {1200., 980545.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980564.07}, {1200., 980564.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980568.58}, {1200., 980568.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980596.56}, {1200., 980596.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980599.64}, {1200., 980599.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980609.78}, {1200., 980609.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980627.14}, {1200., 980627.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980656.7}, {1200., 980656.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980657.45}, {1200., 980657.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980658.55}, {1200., 980658.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980663.01}, {1200., 980663.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980670.14}, {1200., 980670.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980688.69}, {1200., 980688.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980710.92}, {1200., 980710.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980739.31}, {1200., 980739.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980740.03}, {1200., 980740.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980746.51}, {1200., 980746.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980748.32}, {1200., 980748.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980768.44}, {1200., 980768.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980768.91}, {1200., 980768.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980774.98}, {1200., 980774.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980777.79}, {1200., 980777.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980821.16}, {1200., 980821.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980824.74}, {1200., 980824.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980826.23}, {1200., 980826.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980840.15}, {1200., 980840.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980845.11}, {1200., 980845.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980850.11}, {1200., 980850.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980881.93}, {1200., 980881.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980888.78}, {1200., 980888.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980903.84}, {1200., 980903.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980904.24}, {1200., 980904.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980911.79}, {1200., 980911.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980918.37}, {1200., 980918.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980932.58}, {1200., 980932.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980937.4}, {1200., 980937.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980980.99}, {1200., 980980.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 980987.95}, {1200., 980987.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981000.09}, {1200., 981000.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981003.13}, {1200., 981003.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981015.16}, {1200., 981015.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981025.46}, {1200., 981025.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981034.01}, {1200., 981034.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981044.83}, {1200., 981044.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981050.24}, {1200., 981050.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981091.44}, {1200., 981091.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981093.86}, {1200., 981093.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981109.79}, {1200., 981109.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981110.31}, {1200., 981110.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981116.98}, {1200., 981116.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981118.72}, {1200., 981118.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981155.72}, {1200., 981155.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981159.88}, {1200., 981159.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981176.38}, {1200., 981176.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981184.18}, {1200., 981184.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981199.08}, {1200., 981199.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981218.35}, {1200., 981218.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981229.82}, {1200., 981229.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981236.75}, {1200., 981236.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981268.58}, {1200., 981268.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981282.75}, {1200., 981282.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981303.45}, {1200., 981303.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981313.78}, {1200., 981313.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981326.08}, {1200., 981326.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981361.43}, {1200., 981361.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981383.14}, {1200., 981383.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981401.21}, {1200., 981401.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981409.01}, {1200., 981409.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981433.17}, {1200., 981433.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981440.31}, {1200., 981440.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981484.82}, {1200., 981484.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981499.69}, {1200., 981499.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981505.76}, {1200., 981505.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981525.46}, {1200., 981525.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981564.46}, {1200., 981564.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981608.36}, {1200., 981608.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981643.78}, {1200., 981643.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981686.66}, {1200., 981686.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981729.38}, {1200., 981729.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981761.44}, {1200., 981761.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981807.22}, {1200., 981807.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981878.4}, {1200., 981878.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1200., 981926.35}, {1200., 981926.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980192.62}, {1250., 980192.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980250.54}, {1250., 980250.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980316.86}, {1250., 980316.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980325.47}, {1250., 980325.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980388.16}, {1250., 980388.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980388.82}, {1250., 980388.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998412], 
      PointBox[{{1250., 980408.34}, {1250., 980408.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980458.6}, {1250., 980458.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980464.33}, {1250., 980464.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980464.81}, {1250., 980464.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980489.18}, {1250., 980489.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980527.93}, {1250., 980527.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980533.22}, {1250., 980533.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980543.9}, {1250., 980543.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980564.83}, {1250., 980564.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980569.19}, {1250., 980569.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980597.35}, {1250., 980597.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980598.58}, {1250., 980598.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980610.41}, {1250., 980610.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980625.49}, {1250., 980625.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980656.83}, {1250., 980656.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980658.08}, {1250., 980658.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980658.98}, {1250., 980658.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980661.88}, {1250., 980661.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980670.95}, {1250., 980670.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980689.38}, {1250., 980689.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980709.22}, {1250., 980709.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980738.89}, {1250., 980738.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980739.55}, {1250., 980739.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980747.36}, {1250., 980747.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980748.99}, {1250., 980748.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980767.21}, {1250., 980767.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980769.64}, {1250., 980769.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980775.16}, {1250., 980775.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980778.64}, {1250., 980778.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980821.09}, {1250., 980821.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980825.08}, {1250., 980825.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980825.63}, {1250., 980825.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980840.87}, {1250., 980840.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980844.61}, {1250., 980844.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980850.87}, {1250., 980850.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980882.79}, {1250., 980882.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980889.01}, {1250., 980889.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980902.46}, {1250., 980902.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980905.16}, {1250., 980905.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980912.01}, {1250., 980912.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980917.22}, {1250., 980917.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980933.36}, {1250., 980933.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980936.96}, {1250., 980936.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980981.16}, {1250., 980981.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 980988.8}, {1250., 980988.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981000.38}, {1250., 981000.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981003.55}, {1250., 981003.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981014.02}, {1250., 981014.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981026.31}, {1250., 981026.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981032.96}, {1250., 981032.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981043.87}, {1250., 981043.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981050.89}, {1250., 981050.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981091.87}, {1250., 981091.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981094.69}, {1250., 981094.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981110.14}, {1250., 981110.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981110.38}, {1250., 981110.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981115.83}, {1250., 981115.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981119.64}, {1250., 981119.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981154.52}, {1250., 981154.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981159.17}, {1250., 981159.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981176.78}, {1250., 981176.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981184.85}, {1250., 981184.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981199.85}, {1250., 981199.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981218.77}, {1250., 981218.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981228.21}, {1250., 981228.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981236.63}, {1250., 981236.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981267.24}, {1250., 981267.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981282.43}, {1250., 981282.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981304.12}, {1250., 981304.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981314.48}, {1250., 981314.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981326.58}, {1250., 981326.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981361.08}, {1250., 981361.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981381.68}, {1250., 981381.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981401.76}, {1250., 981401.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981409.07}, {1250., 981409.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981433.75}, {1250., 981433.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981441.03}, {1250., 981441.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981484.25}, {1250., 981484.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981498.11}, {1250., 981498.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981506.58}, {1250., 981506.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981525.48}, {1250., 981525.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981565.19}, {1250., 981565.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981607.41}, {1250., 981607.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981644.13}, {1250., 981644.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981687.41}, {1250., 981687.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981728.15}, {1250., 981728.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981762.09}, {1250., 981762.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981807.98}, {1250., 981807.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981879.34}, {1250., 981879.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1250., 981927.11}, {1250., 981927.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980191.02}, {1300., 980191.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980249.1}, {1300., 980249.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980315.44}, {1300., 980315.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980325.9}, {1300., 980325.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980387.36}, {1300., 980387.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980388.64}, {1300., 980388.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998348], 
      PointBox[{{1300., 980409.27}, {1300., 980409.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980459.12}, {1300., 980459.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980463.29}, {1300., 980463.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980465.17}, {1300., 980465.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980489.94}, {1300., 980489.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980528.72}, {1300., 980528.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980533.8}, {1300., 980533.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980542.31}, {1300., 980542.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980565.59}, {1300., 980565.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980569.8}, {1300., 980569.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980597.51}, {1300., 980597.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980598.14}, {1300., 980598.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980611.05}, {1300., 980611.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980623.84}, {1300., 980623.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980656.94}, {1300., 980656.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980658.7}, {1300., 980658.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980659.43}, {1300., 980659.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980660.74}, {1300., 980660.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980671.77}, {1300., 980671.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980690.06}, {1300., 980690.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980707.51}, {1300., 980707.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980737.74}, {1300., 980737.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980739.75}, {1300., 980739.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980748.22}, {1300., 980748.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980749.65}, {1300., 980749.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980766.02}, {1300., 980766.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980770.37}, {1300., 980770.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980775.33}, {1300., 980775.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980779.48}, {1300., 980779.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980820.97}, {1300., 980820.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980823.93}, {1300., 980823.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980826.52}, {1300., 980826.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980841.58}, {1300., 980841.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980844.19}, {1300., 980844.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980851.64}, {1300., 980851.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980883.65}, {1300., 980883.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980889.23}, {1300., 980889.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980901.1}, {1300., 980901.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980906.08}, {1300., 980906.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980912.2}, {1300., 980912.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980916.07}, {1300., 980916.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980934.13}, {1300., 980934.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980936.55}, {1300., 980936.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980981.35}, {1300., 980981.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 980989.66}, {1300., 980989.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981000.65}, {1300., 981000.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981003.98}, {1300., 981003.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981012.87}, {1300., 981012.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981027.15}, {1300., 981027.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981031.93}, {1300., 981031.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981042.91}, {1300., 981042.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981051.54}, {1300., 981051.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981092.32}, {1300., 981092.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981095.52}, {1300., 981095.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981110.42}, {1300., 981110.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981110.47}, {1300., 981110.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981114.65}, {1300., 981114.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981120.56}, {1300., 981120.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981153.32}, {1300., 981153.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981158.49}, {1300., 981158.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981177.21}, {1300., 981177.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981185.53}, {1300., 981185.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981200.64}, {1300., 981200.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981219.18}, {1300., 981219.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981226.61}, {1300., 981226.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981236.45}, {1300., 981236.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981265.91}, {1300., 981265.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981282.14}, {1300., 981282.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981304.82}, {1300., 981304.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981315.18}, {1300., 981315.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981327.06}, {1300., 981327.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981360.66}, {1300., 981360.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981380.23}, {1300., 981380.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981402.27}, {1300., 981402.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981409.24}, {1300., 981409.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981434.32}, {1300., 981434.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981441.75}, {1300., 981441.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981483.61}, {1300., 981483.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981496.54}, {1300., 981496.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981507.41}, {1300., 981507.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981525.57}, {1300., 981525.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981565.93}, {1300., 981565.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981606.42}, {1300., 981606.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981644.53}, {1300., 981644.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981688.16}, {1300., 981688.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981726.9}, {1300., 981726.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981762.77}, {1300., 981762.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981808.74}, {1300., 981808.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981880.27}, {1300., 981880.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1300., 981927.88}, {1300., 981927.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980189.41}, {1350., 980189.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980247.64}, {1350., 980247.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980314.}, {1350., 980314.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980326.34}, {1350., 980326.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980385.88}, {1350., 980385.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980389.13}, {1350., 980389.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998285], 
      PointBox[{{1350., 980410.21}, {1350., 980410.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980459.66}, {1350., 980459.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980461.75}, {1350., 980461.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980466.01}, {1350., 980466.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980490.69}, {1350., 980490.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980529.51}, {1350., 980529.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980534.38}, {1350., 980534.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980540.7}, {1350., 980540.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980566.36}, {1350., 980566.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980570.39}, {1350., 980570.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980596.42}, {1350., 980596.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980598.92}, {1350., 980598.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980611.69}, {1350., 980611.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980622.17}, {1350., 980622.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980657.04}, {1350., 980657.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980659.31}, {1350., 980659.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980659.6}, {1350., 980659.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980659.9}, {1350., 980659.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980672.58}, {1350., 980672.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980690.75}, {1350., 980690.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980705.8}, {1350., 980705.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980736.6}, {1350., 980736.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980739.92}, {1350., 980739.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980749.07}, {1350., 980749.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980750.31}, {1350., 980750.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980764.89}, {1350., 980764.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980771.1}, {1350., 980771.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980775.48}, {1350., 980775.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980780.33}, {1350., 980780.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980820.79}, {1350., 980820.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980822.78}, {1350., 980822.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980827.41}, {1350., 980827.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980842.29}, {1350., 980842.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980843.85}, {1350., 980843.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980852.4}, {1350., 980852.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980884.52}, {1350., 980884.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980889.43}, {1350., 980889.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980899.73}, {1350., 980899.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980906.99}, {1350., 980906.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980912.37}, {1350., 980912.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980914.9}, {1350., 980914.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980934.9}, {1350., 980934.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980936.15}, {1350., 980936.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980981.53}, {1350., 980981.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 980990.51}, {1350., 980990.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981000.91}, {1350., 981000.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981004.41}, {1350., 981004.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981011.7}, {1350., 981011.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981027.99}, {1350., 981027.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981030.92}, {1350., 981030.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981041.97}, {1350., 981041.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981052.2}, {1350., 981052.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981092.78}, {1350., 981092.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981096.35}, {1350., 981096.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981110.43}, {1350., 981110.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981110.8}, {1350., 981110.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981113.46}, {1350., 981113.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981121.47}, {1350., 981121.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981152.14}, {1350., 981152.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981157.86}, {1350., 981157.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981177.66}, {1350., 981177.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981186.21}, {1350., 981186.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981201.43}, {1350., 981201.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981219.58}, {1350., 981219.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981225.01}, {1350., 981225.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981236.22}, {1350., 981236.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981264.58}, {1350., 981264.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981281.88}, {1350., 981281.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981305.54}, {1350., 981305.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981315.89}, {1350., 981315.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981327.54}, {1350., 981327.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981360.19}, {1350., 981360.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981378.78}, {1350., 981378.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981402.72}, {1350., 981402.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981409.53}, {1350., 981409.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981434.89}, {1350., 981434.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981442.47}, {1350., 981442.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981482.91}, {1350., 981482.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981494.96}, {1350., 981494.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981508.25}, {1350., 981508.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981525.73}, {1350., 981525.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981566.67}, {1350., 981566.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981605.37}, {1350., 981605.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981644.99}, {1350., 981644.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981688.92}, {1350., 981688.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981725.62}, {1350., 981725.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981763.48}, {1350., 981763.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981809.51}, {1350., 981809.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981881.2}, {1350., 981881.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1350., 981928.65}, {1350., 981928.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980187.8}, {1400., 980187.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980246.17}, {1400., 980246.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980312.55}, {1400., 980312.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980326.77}, {1400., 980326.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980384.39}, {1400., 980384.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980389.63}, {1400., 980389.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998221], 
      PointBox[{{1400., 980411.14}, {1400., 980411.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980460.2}, {1400., 980460.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980460.2}, {1400., 980460.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980466.85}, {1400., 980466.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980491.44}, {1400., 980491.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980530.3}, {1400., 980530.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980534.98}, {1400., 980534.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980539.09}, {1400., 980539.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980567.13}, {1400., 980567.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980570.97}, {1400., 980570.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980595.31}, {1400., 980595.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980599.7}, {1400., 980599.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980612.33}, {1400., 980612.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980620.5}, {1400., 980620.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980657.13}, {1400., 980657.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980658.46}, {1400., 980658.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980659.92}, {1400., 980659.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980660.4}, {1400., 980660.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980673.39}, {1400., 980673.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980691.45}, {1400., 980691.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980704.09}, {1400., 980704.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980735.45}, {1400., 980735.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980740.02}, {1400., 980740.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980749.92}, {1400., 980749.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980750.96}, {1400., 980750.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980763.82}, {1400., 980763.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980771.83}, {1400., 980771.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980775.62}, {1400., 980775.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980781.18}, {1400., 980781.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980820.56}, {1400., 980820.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980821.62}, {1400., 980821.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980828.3}, {1400., 980828.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980842.99}, {1400., 980842.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980843.58}, {1400., 980843.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980853.16}, {1400., 980853.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980885.38}, {1400., 980885.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980889.62}, {1400., 980889.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980898.37}, {1400., 980898.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980907.91}, {1400., 980907.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980912.5}, {1400., 980912.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980913.74}, {1400., 980913.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980935.66}, {1400., 980935.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980935.79}, {1400., 980935.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980981.71}, {1400., 980981.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 980991.37}, {1400., 980991.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981001.16}, {1400., 981001.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981004.84}, {1400., 981004.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981010.53}, {1400., 981010.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981028.82}, {1400., 981028.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981029.94}, {1400., 981029.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981041.04}, {1400., 981041.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981052.85}, {1400., 981052.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981093.26}, {1400., 981093.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981097.19}, {1400., 981097.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981110.4}, {1400., 981110.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981111.11}, {1400., 981111.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981112.25}, {1400., 981112.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981122.39}, {1400., 981122.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981150.96}, {1400., 981150.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981157.27}, {1400., 981157.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981178.13}, {1400., 981178.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981186.89}, {1400., 981186.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981202.24}, {1400., 981202.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981219.96}, {1400., 981219.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981223.41}, {1400., 981223.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981235.94}, {1400., 981235.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981263.25}, {1400., 981263.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981281.67}, {1400., 981281.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981306.28}, {1400., 981306.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981316.59}, {1400., 981316.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981328.01}, {1400., 981328.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981359.65}, {1400., 981359.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981377.34}, {1400., 981377.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981403.14}, {1400., 981403.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981409.92}, {1400., 981409.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981435.46}, {1400., 981435.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981443.2}, {1400., 981443.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981482.15}, {1400., 981482.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981493.38}, {1400., 981493.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981509.09}, {1400., 981509.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981525.95}, {1400., 981525.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981567.42}, {1400., 981567.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981604.29}, {1400., 981604.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981645.49}, {1400., 981645.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981689.67}, {1400., 981689.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981724.32}, {1400., 981724.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981764.22}, {1400., 981764.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981810.27}, {1400., 981810.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981882.14}, {1400., 981882.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1400., 981929.42}, {1400., 981929.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980186.19}, {1450., 980186.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980244.69}, {1450., 980244.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980311.08}, {1450., 980311.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980327.22}, {1450., 980327.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980382.89}, {1450., 980382.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980390.13}, {1450., 980390.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998158], 
      PointBox[{{1450., 980412.08}, {1450., 980412.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980458.64}, {1450., 980458.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980460.75}, {1450., 980460.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980467.69}, {1450., 980467.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980492.19}, {1450., 980492.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980531.09}, {1450., 980531.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980535.58}, {1450., 980535.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980537.47}, {1450., 980537.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980567.9}, {1450., 980567.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980571.55}, {1450., 980571.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980594.19}, {1450., 980594.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980600.48}, {1450., 980600.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980612.98}, {1450., 980612.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980618.83}, {1450., 980618.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980657.2}, {1450., 980657.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980657.32}, {1450., 980657.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980660.52}, {1450., 980660.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980660.92}, {1450., 980660.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980674.2}, {1450., 980674.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980692.14}, {1450., 980692.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980702.37}, {1450., 980702.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980734.31}, {1450., 980734.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980740.06}, {1450., 980740.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980750.77}, {1450., 980750.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980751.6}, {1450., 980751.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980762.83}, {1450., 980762.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980772.56}, {1450., 980772.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980775.73}, {1450., 980775.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980782.03}, {1450., 980782.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980820.27}, {1450., 980820.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980820.47}, {1450., 980820.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980829.19}, {1450., 980829.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980843.38}, {1450., 980843.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980843.69}, {1450., 980843.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980853.91}, {1450., 980853.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980886.25}, {1450., 980886.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980889.79}, {1450., 980889.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980897.01}, {1450., 980897.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980908.83}, {1450., 980908.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980912.57}, {1450., 980912.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980912.6}, {1450., 980912.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980935.47}, {1450., 980935.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980936.43}, {1450., 980936.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980981.88}, {1450., 980981.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 980992.23}, {1450., 980992.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981001.38}, {1450., 981001.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981005.28}, {1450., 981005.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981009.34}, {1450., 981009.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981028.99}, {1450., 981028.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981029.66}, {1450., 981029.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981040.12}, {1450., 981040.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981053.52}, {1450., 981053.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981093.76}, {1450., 981093.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981098.03}, {1450., 981098.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981110.33}, {1450., 981110.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981111.03}, {1450., 981111.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981111.41}, {1450., 981111.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981123.31}, {1450., 981123.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981149.79}, {1450., 981149.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981156.72}, {1450., 981156.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981178.63}, {1450., 981178.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981187.58}, {1450., 981187.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981203.05}, {1450., 981203.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981220.34}, {1450., 981220.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981221.81}, {1450., 981221.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981235.6}, {1450., 981235.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981261.94}, {1450., 981261.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981281.5}, {1450., 981281.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981307.04}, {1450., 981307.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981317.31}, {1450., 981317.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981328.47}, {1450., 981328.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981359.06}, {1450., 981359.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981375.9}, {1450., 981375.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981403.53}, {1450., 981403.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981410.4}, {1450., 981410.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981436.01}, {1450., 981436.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981443.93}, {1450., 981443.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981481.33}, {1450., 981481.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981491.81}, {1450., 981491.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981509.93}, {1450., 981509.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981526.22}, {1450., 981526.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981568.16}, {1450., 981568.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981603.17}, {1450., 981603.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981646.03}, {1450., 981646.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981690.43}, {1450., 981690.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981723.}, {1450., 981723.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981764.97}, {1450., 981764.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981811.04}, {1450., 981811.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981883.07}, {1450., 981883.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1450., 981930.2}, {1450., 981930.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980184.57}, {1500., 980184.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980243.19}, {1500., 980243.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980309.6}, {1500., 980309.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980327.66}, {1500., 980327.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980381.37}, {1500., 980381.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980390.64}, {1500., 980390.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99998094], 
      PointBox[{{1500., 980413.01}, {1500., 980413.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980457.07}, {1500., 980457.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980461.3}, {1500., 980461.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980468.54}, {1500., 980468.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980492.94}, {1500., 980492.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980531.88}, {1500., 980531.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980535.84}, {1500., 980535.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980536.18}, {1500., 980536.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980568.68}, {1500., 980568.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980572.11}, {1500., 980572.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980593.07}, {1500., 980593.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980601.25}, {1500., 980601.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980613.63}, {1500., 980613.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980617.15}, {1500., 980617.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980656.18}, {1500., 980656.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980657.25}, {1500., 980657.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980661.1}, {1500., 980661.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980661.46}, {1500., 980661.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980675.}, {1500., 980675.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980692.83}, {1500., 980692.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980700.65}, {1500., 980700.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980733.17}, {1500., 980733.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980740.03}, {1500., 980740.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980751.62}, {1500., 980751.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980752.23}, {1500., 980752.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980761.93}, {1500., 980761.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980773.29}, {1500., 980773.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980775.84}, {1500., 980775.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980782.88}, {1500., 980782.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980819.32}, {1500., 980819.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980819.93}, {1500., 980819.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980830.08}, {1500., 980830.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980843.27}, {1500., 980843.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980844.38}, {1500., 980844.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980854.67}, {1500., 980854.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980887.12}, {1500., 980887.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980889.94}, {1500., 980889.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980895.65}, {1500., 980895.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980909.74}, {1500., 980909.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980911.4}, {1500., 980911.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980912.67}, {1500., 980912.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980935.18}, {1500., 980935.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980937.18}, {1500., 980937.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980982.04}, {1500., 980982.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 980993.1}, {1500., 980993.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981001.6}, {1500., 981001.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981005.71}, {1500., 981005.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981008.15}, {1500., 981008.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981028.08}, {1500., 981028.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981030.49}, {1500., 981030.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981039.22}, {1500., 981039.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981054.19}, {1500., 981054.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981094.27}, {1500., 981094.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981098.88}, {1500., 981098.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981109.8}, {1500., 981109.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981110.22}, {1500., 981110.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981111.69}, {1500., 981111.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981124.22}, {1500., 981124.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981148.63}, {1500., 981148.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981156.22}, {1500., 981156.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981179.14}, {1500., 981179.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981188.28}, {1500., 981188.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981203.87}, {1500., 981203.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981220.22}, {1500., 981220.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981220.7}, {1500., 981220.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981235.22}, {1500., 981235.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981260.63}, {1500., 981260.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981281.37}, {1500., 981281.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981307.81}, {1500., 981307.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981318.02}, {1500., 981318.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981328.92}, {1500., 981328.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981358.42}, {1500., 981358.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981374.46}, {1500., 981374.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981403.9}, {1500., 981403.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981410.96}, {1500., 981410.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981436.56}, {1500., 981436.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981444.67}, {1500., 981444.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981480.47}, {1500., 981480.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981490.24}, {1500., 981490.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981510.78}, {1500., 981510.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981526.55}, {1500., 981526.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981568.91}, {1500., 981568.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981602.02}, {1500., 981602.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981646.61}, {1500., 981646.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981691.2}, {1500., 981691.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981721.68}, {1500., 981721.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981765.75}, {1500., 981765.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981811.81}, {1500., 981811.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981884.01}, {1500., 981884.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1500., 981930.97}, {1500., 981930.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980182.95}, {1550., 980182.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980241.69}, {1550., 980241.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980308.11}, {1550., 980308.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980328.11}, {1550., 980328.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980379.84}, {1550., 980379.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980391.16}, {1550., 980391.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.9999803], 
      PointBox[{{1550., 980413.94}, {1550., 980413.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980455.49}, {1550., 980455.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980461.87}, {1550., 980461.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980469.38}, {1550., 980469.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980493.68}, {1550., 980493.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980532.67}, {1550., 980532.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980534.2}, {1550., 980534.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980536.79}, {1550., 980536.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980569.46}, {1550., 980569.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980572.67}, {1550., 980572.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980591.93}, {1550., 980591.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980602.02}, {1550., 980602.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980614.28}, {1550., 980614.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980615.46}, {1550., 980615.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980655.04}, {1550., 980655.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980657.29}, {1550., 980657.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980661.68}, {1550., 980661.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980662.01}, {1550., 980662.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980675.8}, {1550., 980675.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980693.53}, {1550., 980693.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980698.93}, {1550., 980698.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980732.04}, {1550., 980732.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980739.9}, {1550., 980739.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980752.47}, {1550., 980752.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980752.86}, {1550., 980752.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980761.12}, {1550., 980761.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980774.02}, {1550., 980774.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980775.92}, {1550., 980775.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980783.74}, {1550., 980783.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980818.17}, {1550., 980818.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980819.53}, {1550., 980819.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980830.97}, {1550., 980830.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980843.22}, {1550., 980843.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980845.06}, {1550., 980845.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980855.42}, {1550., 980855.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980887.99}, {1550., 980887.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980890.08}, {1550., 980890.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980894.3}, {1550., 980894.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980910.23}, {1550., 980910.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980910.66}, {1550., 980910.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980912.69}, {1550., 980912.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980934.94}, {1550., 980934.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980937.93}, {1550., 980937.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980982.18}, {1550., 980982.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 980993.96}, {1550., 980993.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981001.79}, {1550., 981001.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981006.15}, {1550., 981006.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981006.96}, {1550., 981006.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981027.2}, {1550., 981027.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981031.32}, {1550., 981031.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981038.34}, {1550., 981038.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981054.86}, {1550., 981054.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981094.79}, {1550., 981094.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981099.73}, {1550., 981099.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981108.55}, {1550., 981108.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981110.06}, {1550., 981110.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981111.95}, {1550., 981111.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981125.14}, {1550., 981125.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981147.48}, {1550., 981147.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981155.77}, {1550., 981155.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981179.67}, {1550., 981179.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981188.97}, {1550., 981188.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981204.69}, {1550., 981204.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981218.63}, {1550., 981218.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981221.05}, {1550., 981221.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981234.78}, {1550., 981234.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981259.32}, {1550., 981259.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981281.3}, {1550., 981281.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981308.6}, {1550., 981308.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981318.74}, {1550., 981318.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981329.36}, {1550., 981329.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981357.73}, {1550., 981357.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981373.03}, {1550., 981373.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981404.27}, {1550., 981404.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981411.59}, {1550., 981411.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981437.11}, {1550., 981437.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981445.4}, {1550., 981445.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981479.56}, {1550., 981479.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981488.66}, {1550., 981488.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981511.63}, {1550., 981511.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981526.93}, {1550., 981526.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981569.66}, {1550., 981569.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981600.85}, {1550., 981600.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981647.22}, {1550., 981647.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981691.96}, {1550., 981691.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981720.34}, {1550., 981720.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981766.54}, {1550., 981766.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981812.59}, {1550., 981812.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981884.94}, {1550., 981884.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1550., 981931.75}, {1550., 981931.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980181.32}, {1600., 980181.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980240.17}, {1600., 980240.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980306.61}, {1600., 980306.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980328.55}, {1600., 980328.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980378.3}, {1600., 980378.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980391.68}, {1600., 980391.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997967], 
      PointBox[{{1600., 980414.88}, {1600., 980414.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980453.9}, {1600., 980453.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980462.43}, {1600., 980462.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980470.23}, {1600., 980470.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980494.41}, {1600., 980494.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980532.56}, {1600., 980532.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980533.45}, {1600., 980533.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980537.4}, {1600., 980537.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980570.24}, {1600., 980570.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980573.22}, {1600., 980573.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980590.78}, {1600., 980590.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980602.79}, {1600., 980602.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980613.77}, {1600., 980613.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980614.94}, {1600., 980614.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980653.9}, {1600., 980653.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980657.32}, {1600., 980657.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980662.26}, {1600., 980662.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980662.58}, {1600., 980662.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980676.6}, {1600., 980676.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980694.22}, {1600., 980694.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980697.2}, {1600., 980697.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980730.91}, {1600., 980730.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980739.66}, {1600., 980739.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980753.32}, {1600., 980753.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980753.47}, {1600., 980753.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980760.43}, {1600., 980760.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980774.75}, {1600., 980774.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980775.99}, {1600., 980775.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980784.6}, {1600., 980784.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980817.02}, {1600., 980817.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980819.08}, {1600., 980819.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980831.85}, {1600., 980831.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980843.25}, {1600., 980843.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980845.74}, {1600., 980845.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980856.16}, {1600., 980856.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980888.86}, {1600., 980888.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980890.19}, {1600., 980890.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980892.96}, {1600., 980892.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980909.06}, {1600., 980909.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980911.58}, {1600., 980911.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980912.67}, {1600., 980912.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980934.75}, {1600., 980934.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980938.68}, {1600., 980938.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980982.3}, {1600., 980982.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 980994.83}, {1600., 980994.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981001.97}, {1600., 981001.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981005.76}, {1600., 981005.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981006.57}, {1600., 981006.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981026.36}, {1600., 981026.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981032.15}, {1600., 981032.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981037.48}, {1600., 981037.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981055.54}, {1600., 981055.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981095.32}, {1600., 981095.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981100.58}, {1600., 981100.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981107.29}, {1600., 981107.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981109.86}, {1600., 981109.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981112.2}, {1600., 981112.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981126.05}, {1600., 981126.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981146.34}, {1600., 981146.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981155.37}, {1600., 981155.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981180.22}, {1600., 981180.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981189.67}, {1600., 981189.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981205.52}, {1600., 981205.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981217.05}, {1600., 981217.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981221.38}, {1600., 981221.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981234.28}, {1600., 981234.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981258.03}, {1600., 981258.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981281.27}, {1600., 981281.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981309.4}, {1600., 981309.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981319.46}, {1600., 981319.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981329.8}, {1600., 981329.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981356.99}, {1600., 981356.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981371.61}, {1600., 981371.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981404.64}, {1600., 981404.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981412.26}, {1600., 981412.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981437.64}, {1600., 981437.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981446.14}, {1600., 981446.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981478.6}, {1600., 981478.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981487.1}, {1600., 981487.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981512.49}, {1600., 981512.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981527.35}, {1600., 981527.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981570.42}, {1600., 981570.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981599.65}, {1600., 981599.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981647.86}, {1600., 981647.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981692.73}, {1600., 981692.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981719.}, {1600., 981719.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981767.35}, {1600., 981767.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981813.36}, {1600., 981813.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981885.88}, {1600., 981885.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1600., 981932.53}, {1600., 981932.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980179.69}, {1650., 980179.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980238.65}, {1650., 980238.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980305.09}, {1650., 980305.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980329.}, {1650., 980329.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980376.75}, {1650., 980376.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980392.2}, {1650., 980392.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997903], 
      PointBox[{{1650., 980415.81}, {1650., 980415.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980452.3}, {1650., 980452.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980463.}, {1650., 980463.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980471.08}, {1650., 980471.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980495.15}, {1650., 980495.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980530.91}, {1650., 980530.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980534.23}, {1650., 980534.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980538.01}, {1650., 980538.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980571.02}, {1650., 980571.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980573.75}, {1650., 980573.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980589.63}, {1650., 980589.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980603.55}, {1650., 980603.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980612.08}, {1650., 980612.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980615.6}, {1650., 980615.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980652.77}, {1650., 980652.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980657.33}, {1650., 980657.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980662.82}, {1650., 980662.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980663.17}, {1650., 980663.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980677.39}, {1650., 980677.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980694.92}, {1650., 980694.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980695.48}, {1650., 980695.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980729.79}, {1650., 980729.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980739.32}, {1650., 980739.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980754.08}, {1650., 980754.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980754.16}, {1650., 980754.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980759.85}, {1650., 980759.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980775.47}, {1650., 980775.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980776.05}, {1650., 980776.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980785.46}, {1650., 980785.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980815.88}, {1650., 980815.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980818.59}, {1650., 980818.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980832.74}, {1650., 980832.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980843.34}, {1650., 980843.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980846.41}, {1650., 980846.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980856.91}, {1650., 980856.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980889.73}, {1650., 980889.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980890.29}, {1650., 980890.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980891.62}, {1650., 980891.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980907.89}, {1650., 980907.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980912.49}, {1650., 980912.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980912.6}, {1650., 980912.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980934.62}, {1650., 980934.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980939.43}, {1650., 980939.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980982.39}, {1650., 980982.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 980995.7}, {1650., 980995.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981002.12}, {1650., 981002.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981004.57}, {1650., 981004.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981006.99}, {1650., 981006.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981025.56}, {1650., 981025.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981032.97}, {1650., 981032.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981036.65}, {1650., 981036.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981056.22}, {1650., 981056.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981095.86}, {1650., 981095.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981101.44}, {1650., 981101.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981106.03}, {1650., 981106.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981109.61}, {1650., 981109.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981112.44}, {1650., 981112.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981126.97}, {1650., 981126.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981145.21}, {1650., 981145.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981155.03}, {1650., 981155.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981180.79}, {1650., 981180.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981190.38}, {1650., 981190.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981206.36}, {1650., 981206.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981215.47}, {1650., 981215.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981221.71}, {1650., 981221.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981233.74}, {1650., 981233.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981256.74}, {1650., 981256.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981281.28}, {1650., 981281.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981310.21}, {1650., 981310.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981320.18}, {1650., 981320.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981330.22}, {1650., 981330.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981356.21}, {1650., 981356.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981370.18}, {1650., 981370.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981405.02}, {1650., 981405.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981412.97}, {1650., 981412.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981438.17}, {1650., 981438.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981446.89}, {1650., 981446.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981477.62}, {1650., 981477.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981485.53}, {1650., 981485.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981513.35}, {1650., 981513.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981527.81}, {1650., 981527.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981571.18}, {1650., 981571.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981598.43}, {1650., 981598.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981648.53}, {1650., 981648.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981693.5}, {1650., 981693.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981717.65}, {1650., 981717.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981768.17}, {1650., 981768.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981814.14}, {1650., 981814.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981886.81}, {1650., 981886.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1650., 981933.31}, {1650., 981933.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980178.06}, {1700., 980178.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980237.12}, {1700., 980237.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980303.56}, {1700., 980303.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980329.45}, {1700., 980329.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980375.19}, {1700., 980375.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980392.72}, {1700., 980392.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.9999784], 
      PointBox[{{1700., 980416.75}, {1700., 980416.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980450.69}, {1700., 980450.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980463.57}, {1700., 980463.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980471.92}, {1700., 980471.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980495.87}, {1700., 980495.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980529.25}, {1700., 980529.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980535.01}, {1700., 980535.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980538.63}, {1700., 980538.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980571.8}, {1700., 980571.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980574.28}, {1700., 980574.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980588.48}, {1700., 980588.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980604.3}, {1700., 980604.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980610.38}, {1700., 980610.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980616.25}, {1700., 980616.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980651.65}, {1700., 980651.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980657.33}, {1700., 980657.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980663.37}, {1700., 980663.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980663.78}, {1700., 980663.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980678.18}, {1700., 980678.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980693.74}, {1700., 980693.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980695.61}, {1700., 980695.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980728.68}, {1700., 980728.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980738.85}, {1700., 980738.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980754.68}, {1700., 980754.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980755.}, {1700., 980755.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980759.4}, {1700., 980759.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980776.08}, {1700., 980776.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980776.19}, {1700., 980776.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980786.32}, {1700., 980786.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980814.74}, {1700., 980814.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980818.05}, {1700., 980818.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980833.63}, {1700., 980833.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980843.49}, {1700., 980843.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980847.07}, {1700., 980847.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980857.65}, {1700., 980857.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980890.28}, {1700., 980890.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980890.37}, {1700., 980890.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980890.61}, {1700., 980890.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980906.73}, {1700., 980906.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980912.48}, {1700., 980912.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980913.41}, {1700., 980913.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980934.54}, {1700., 980934.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980940.16}, {1700., 980940.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980982.46}, {1700., 980982.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 980996.57}, {1700., 980996.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981002.24}, {1700., 981002.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981003.38}, {1700., 981003.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981007.4}, {1700., 981007.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981024.81}, {1700., 981024.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981033.8}, {1700., 981033.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981035.84}, {1700., 981035.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981056.9}, {1700., 981056.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981096.42}, {1700., 981096.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981102.29}, {1700., 981102.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981104.76}, {1700., 981104.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981109.31}, {1700., 981109.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981112.66}, {1700., 981112.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981127.88}, {1700., 981127.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981144.09}, {1700., 981144.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981154.74}, {1700., 981154.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981181.37}, {1700., 981181.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981191.09}, {1700., 981191.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981207.2}, {1700., 981207.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981213.9}, {1700., 981213.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981222.02}, {1700., 981222.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981233.15}, {1700., 981233.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981255.46}, {1700., 981255.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981281.35}, {1700., 981281.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981311.03}, {1700., 981311.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981320.91}, {1700., 981320.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981330.63}, {1700., 981330.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981355.39}, {1700., 981355.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981368.77}, {1700., 981368.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981405.42}, {1700., 981405.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981413.71}, {1700., 981413.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981438.7}, {1700., 981438.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981447.63}, {1700., 981447.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981476.6}, {1700., 981476.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981483.96}, {1700., 981483.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981514.21}, {1700., 981514.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981528.31}, {1700., 981528.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981571.94}, {1700., 981571.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981597.2}, {1700., 981597.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981649.22}, {1700., 981649.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981694.27}, {1700., 981694.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981716.3}, {1700., 981716.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981768.99}, {1700., 981768.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981814.92}, {1700., 981814.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981887.74}, {1700., 981887.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1700., 981934.1}, {1700., 981934.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980176.42}, {1750., 980176.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980235.57}, {1750., 980235.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980302.03}, {1750., 980302.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980329.89}, {1750., 980329.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980373.62}, {1750., 980373.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980393.25}, {1750., 980393.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997776], 
      PointBox[{{1750., 980417.68}, {1750., 980417.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980449.07}, {1750., 980449.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980464.15}, {1750., 980464.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980472.77}, {1750., 980472.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980496.59}, {1750., 980496.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980527.59}, {1750., 980527.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980535.79}, {1750., 980535.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980539.25}, {1750., 980539.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980572.59}, {1750., 980572.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980574.79}, {1750., 980574.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980587.32}, {1750., 980587.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980605.05}, {1750., 980605.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980608.68}, {1750., 980608.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980616.91}, {1750., 980616.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980650.54}, {1750., 980650.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980657.31}, {1750., 980657.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980663.91}, {1750., 980663.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980664.39}, {1750., 980664.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980678.96}, {1750., 980678.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980692.01}, {1750., 980692.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980696.3}, {1750., 980696.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980727.58}, {1750., 980727.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980738.26}, {1750., 980738.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980755.27}, {1750., 980755.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980755.84}, {1750., 980755.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980759.08}, {1750., 980759.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980776.1}, {1750., 980776.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980776.92}, {1750., 980776.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980787.18}, {1750., 980787.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980813.61}, {1750., 980813.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980817.47}, {1750., 980817.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980834.51}, {1750., 980834.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980843.7}, {1750., 980843.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980847.73}, {1750., 980847.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980858.39}, {1750., 980858.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980888.96}, {1750., 980888.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980890.43}, {1750., 980890.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980891.48}, {1750., 980891.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980905.56}, {1750., 980905.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980912.31}, {1750., 980912.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980914.33}, {1750., 980914.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980934.51}, {1750., 980934.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980940.9}, {1750., 980940.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980982.5}, {1750., 980982.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 980997.44}, {1750., 980997.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981002.03}, {1750., 981002.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981002.52}, {1750., 981002.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981007.79}, {1750., 981007.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981024.1}, {1750., 981024.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981034.61}, {1750., 981034.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981035.06}, {1750., 981035.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981057.59}, {1750., 981057.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981096.97}, {1750., 981096.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981103.15}, {1750., 981103.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981103.48}, {1750., 981103.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981108.96}, {1750., 981108.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981112.86}, {1750., 981112.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981128.79}, {1750., 981128.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981142.98}, {1750., 981142.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981154.5}, {1750., 981154.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981181.96}, {1750., 981181.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981191.8}, {1750., 981191.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981208.05}, {1750., 981208.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981212.33}, {1750., 981212.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981222.31}, {1750., 981222.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981232.52}, {1750., 981232.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981254.18}, {1750., 981254.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981281.46}, {1750., 981281.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981311.85}, {1750., 981311.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981321.64}, {1750., 981321.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981331.03}, {1750., 981331.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981354.52}, {1750., 981354.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981367.35}, {1750., 981367.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981405.84}, {1750., 981405.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981414.48}, {1750., 981414.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981439.21}, {1750., 981439.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981448.38}, {1750., 981448.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981475.55}, {1750., 981475.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981482.4}, {1750., 981482.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981515.08}, {1750., 981515.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981528.84}, {1750., 981528.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981572.7}, {1750., 981572.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981595.96}, {1750., 981595.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981649.92}, {1750., 981649.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981695.04}, {1750., 981695.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981714.95}, {1750., 981714.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981769.83}, {1750., 981769.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981815.7}, {1750., 981815.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981888.68}, {1750., 981888.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1750., 981934.88}, {1750., 981934.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980174.78}, {1800., 980174.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980234.02}, {1800., 980234.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980300.48}, {1800., 980300.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980330.34}, {1800., 980330.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980372.05}, {1800., 980372.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980393.78}, {1800., 980393.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997713], 
      PointBox[{{1800., 980418.62}, {1800., 980418.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980447.45}, {1800., 980447.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980464.72}, {1800., 980464.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980473.63}, {1800., 980473.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980497.31}, {1800., 980497.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980525.93}, {1800., 980525.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980536.55}, {1800., 980536.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980539.87}, {1800., 980539.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980573.38}, {1800., 980573.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980575.29}, {1800., 980575.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980586.17}, {1800., 980586.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980605.78}, {1800., 980605.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980606.97}, {1800., 980606.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980617.57}, {1800., 980617.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980649.44}, {1800., 980649.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980657.28}, {1800., 980657.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980664.44}, {1800., 980664.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980665.02}, {1800., 980665.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980679.74}, {1800., 980679.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980690.28}, {1800., 980690.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980696.99}, {1800., 980696.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980726.49}, {1800., 980726.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980737.56}, {1800., 980737.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980755.86}, {1800., 980755.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980756.68}, {1800., 980756.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980758.89}, {1800., 980758.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980776.1}, {1800., 980776.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980777.63}, {1800., 980777.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980788.04}, {1800., 980788.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980812.49}, {1800., 980812.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980816.85}, {1800., 980816.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980835.4}, {1800., 980835.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980843.97}, {1800., 980843.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980848.38}, {1800., 980848.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980859.13}, {1800., 980859.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980887.64}, {1800., 980887.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980890.48}, {1800., 980890.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980892.36}, {1800., 980892.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980904.4}, {1800., 980904.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980912.1}, {1800., 980912.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980915.24}, {1800., 980915.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980934.54}, {1800., 980934.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980941.62}, {1800., 980941.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980982.5}, {1800., 980982.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 980998.31}, {1800., 980998.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981000.91}, {1800., 981000.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981002.54}, {1800., 981002.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981008.17}, {1800., 981008.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981023.45}, {1800., 981023.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981034.32}, {1800., 981034.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981035.43}, {1800., 981035.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981058.29}, {1800., 981058.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981097.54}, {1800., 981097.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981102.2}, {1800., 981102.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981104.02}, {1800., 981104.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981108.57}, {1800., 981108.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981113.05}, {1800., 981113.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981129.71}, {1800., 981129.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981141.89}, {1800., 981141.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981154.32}, {1800., 981154.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981182.57}, {1800., 981182.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981192.51}, {1800., 981192.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981208.89}, {1800., 981208.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981210.77}, {1800., 981210.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981222.59}, {1800., 981222.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981231.84}, {1800., 981231.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981252.92}, {1800., 981252.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981281.62}, {1800., 981281.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981312.69}, {1800., 981312.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981322.38}, {1800., 981322.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981331.42}, {1800., 981331.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981353.63}, {1800., 981353.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981365.95}, {1800., 981365.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981406.29}, {1800., 981406.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981415.27}, {1800., 981415.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981439.72}, {1800., 981439.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981449.13}, {1800., 981449.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981474.47}, {1800., 981474.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981480.84}, {1800., 981480.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981515.94}, {1800., 981515.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981529.4}, {1800., 981529.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981573.46}, {1800., 981573.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981594.7}, {1800., 981594.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981650.65}, {1800., 981650.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981695.82}, {1800., 981695.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981713.59}, {1800., 981713.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981770.68}, {1800., 981770.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981816.48}, {1800., 981816.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981889.61}, {1800., 981889.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1800., 981935.67}, {1800., 981935.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980173.14}, {1850., 980173.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980232.46}, {1850., 980232.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980298.93}, {1850., 980298.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980330.78}, {1850., 980330.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980370.46}, {1850., 980370.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980394.31}, {1850., 980394.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997649], 
      PointBox[{{1850., 980419.55}, {1850., 980419.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980445.82}, {1850., 980445.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980465.3}, {1850., 980465.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980474.48}, {1850., 980474.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980498.02}, {1850., 980498.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980524.25}, {1850., 980524.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980537.32}, {1850., 980537.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980540.49}, {1850., 980540.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980574.17}, {1850., 980574.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980575.78}, {1850., 980575.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980585.01}, {1850., 980585.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980605.26}, {1850., 980605.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980606.51}, {1850., 980606.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980618.23}, {1850., 980618.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980648.35}, {1850., 980648.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980657.23}, {1850., 980657.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980664.96}, {1850., 980664.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980665.66}, {1850., 980665.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980680.5}, {1850., 980680.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980688.54}, {1850., 980688.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980697.69}, {1850., 980697.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980725.41}, {1850., 980725.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980736.74}, {1850., 980736.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980756.43}, {1850., 980756.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980757.51}, {1850., 980757.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980758.81}, {1850., 980758.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980776.08}, {1850., 980776.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980778.35}, {1850., 980778.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980788.91}, {1850., 980788.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980811.38}, {1850., 980811.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980816.21}, {1850., 980816.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980836.28}, {1850., 980836.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980844.27}, {1850., 980844.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980849.02}, {1850., 980849.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980859.86}, {1850., 980859.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980886.33}, {1850., 980886.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980890.5}, {1850., 980890.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980893.23}, {1850., 980893.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980903.25}, {1850., 980903.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980911.84}, {1850., 980911.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980916.16}, {1850., 980916.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980934.62}, {1850., 980934.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980942.35}, {1850., 980942.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980982.46}, {1850., 980982.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980999.18}, {1850., 980999.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 980999.71}, {1850., 980999.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981002.62}, {1850., 981002.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981008.52}, {1850., 981008.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981022.85}, {1850., 981022.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981033.62}, {1850., 981033.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981036.24}, {1850., 981036.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981058.98}, {1850., 981058.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981098.11}, {1850., 981098.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981100.91}, {1850., 981100.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981104.88}, {1850., 981104.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981108.13}, {1850., 981108.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981113.22}, {1850., 981113.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981130.62}, {1850., 981130.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981140.8}, {1850., 981140.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981154.2}, {1850., 981154.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981183.19}, {1850., 981183.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981193.23}, {1850., 981193.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981209.21}, {1850., 981209.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981209.75}, {1850., 981209.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981222.86}, {1850., 981222.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981231.13}, {1850., 981231.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981251.66}, {1850., 981251.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981281.82}, {1850., 981281.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981313.52}, {1850., 981313.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981323.12}, {1850., 981323.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981331.8}, {1850., 981331.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981352.7}, {1850., 981352.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981364.55}, {1850., 981364.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981406.75}, {1850., 981406.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981416.08}, {1850., 981416.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981440.23}, {1850., 981440.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981449.88}, {1850., 981449.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981473.37}, {1850., 981473.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981479.28}, {1850., 981479.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981516.82}, {1850., 981516.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981529.99}, {1850., 981529.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981574.23}, {1850., 981574.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981593.44}, {1850., 981593.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981651.39}, {1850., 981651.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981696.59}, {1850., 981696.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981712.24}, {1850., 981712.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981771.53}, {1850., 981771.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981817.27}, {1850., 981817.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981890.55}, {1850., 981890.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1850., 981936.46}, {1850., 981936.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980171.5}, {1900., 980171.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980230.9}, {1900., 980230.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980297.36}, {1900., 980297.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980331.22}, {1900., 980331.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980368.87}, {1900., 980368.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980394.83}, {1900., 980394.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997586], 
      PointBox[{{1900., 980420.48}, {1900., 980420.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980444.19}, {1900., 980444.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980465.88}, {1900., 980465.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980475.33}, {1900., 980475.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980498.73}, {1900., 980498.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980522.58}, {1900., 980522.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980538.08}, {1900., 980538.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980541.11}, {1900., 980541.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980574.96}, {1900., 980574.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980576.26}, {1900., 980576.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980583.86}, {1900., 980583.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980603.55}, {1900., 980603.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980607.23}, {1900., 980607.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980618.88}, {1900., 980618.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980647.27}, {1900., 980647.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980657.17}, {1900., 980657.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980665.47}, {1900., 980665.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980666.32}, {1900., 980666.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980681.27}, {1900., 980681.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980686.8}, {1900., 980686.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980698.37}, {1900., 980698.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980724.34}, {1900., 980724.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980735.83}, {1900., 980735.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980756.99}, {1900., 980756.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980758.34}, {1900., 980758.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980758.84}, {1900., 980758.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980776.04}, {1900., 980776.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980779.06}, {1900., 980779.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980789.78}, {1900., 980789.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980810.28}, {1900., 980810.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980815.53}, {1900., 980815.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980837.17}, {1900., 980837.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980844.63}, {1900., 980844.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980849.65}, {1900., 980849.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980860.59}, {1900., 980860.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980885.03}, {1900., 980885.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980890.5}, {1900., 980890.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980894.11}, {1900., 980894.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980902.1}, {1900., 980902.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980911.53}, {1900., 980911.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980917.07}, {1900., 980917.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980934.76}, {1900., 980934.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980943.06}, {1900., 980943.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980982.38}, {1900., 980982.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 980998.51}, {1900., 980998.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981000.06}, {1900., 981000.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981002.69}, {1900., 981002.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981008.85}, {1900., 981008.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981022.31}, {1900., 981022.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981032.96}, {1900., 981032.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981037.05}, {1900., 981037.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981059.68}, {1900., 981059.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981098.69}, {1900., 981098.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981099.62}, {1900., 981099.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981105.75}, {1900., 981105.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981107.64}, {1900., 981107.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981113.38}, {1900., 981113.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981131.54}, {1900., 981131.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981139.74}, {1900., 981139.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981154.13}, {1900., 981154.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981183.81}, {1900., 981183.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981193.95}, {1900., 981193.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981207.65}, {1900., 981207.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981210.6}, {1900., 981210.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981223.11}, {1900., 981223.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981230.37}, {1900., 981230.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981250.41}, {1900., 981250.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981282.07}, {1900., 981282.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981314.37}, {1900., 981314.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981323.86}, {1900., 981323.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981332.16}, {1900., 981332.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981351.74}, {1900., 981351.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981363.15}, {1900., 981363.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981407.24}, {1900., 981407.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981416.89}, {1900., 981416.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981440.72}, {1900., 981440.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981450.64}, {1900., 981450.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981472.25}, {1900., 981472.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981477.73}, {1900., 981477.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981517.69}, {1900., 981517.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981530.6}, {1900., 981530.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981575.}, {1900., 981575.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981592.17}, {1900., 981592.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981652.15}, {1900., 981652.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981697.37}, {1900., 981697.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981710.89}, {1900., 981710.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981772.39}, {1900., 981772.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981818.05}, {1900., 981818.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981891.48}, {1900., 981891.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1900., 981937.25}, {1900., 981937.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980169.85}, {1950., 980169.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980229.32}, {1950., 980229.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980295.79}, {1950., 980295.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980331.66}, {1950., 980331.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980367.26}, {1950., 980367.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980395.36}, {1950., 980395.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997522], 
      PointBox[{{1950., 980421.42}, {1950., 980421.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980442.55}, {1950., 980442.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980466.46}, {1950., 980466.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980476.19}, {1950., 980476.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980499.43}, {1950., 980499.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980520.89}, {1950., 980520.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980538.83}, {1950., 980538.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980541.73}, {1950., 980541.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980575.76}, {1950., 980575.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980576.73}, {1950., 980576.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980582.71}, {1950., 980582.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980601.83}, {1950., 980601.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980607.93}, {1950., 980607.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980619.54}, {1950., 980619.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980646.22}, {1950., 980646.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980657.09}, {1950., 980657.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980665.96}, {1950., 980665.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980666.98}, {1950., 980666.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980682.02}, {1950., 980682.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980685.06}, {1950., 980685.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980699.06}, {1950., 980699.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980723.3}, {1950., 980723.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980734.82}, {1950., 980734.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980757.55}, {1950., 980757.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980758.96}, {1950., 980758.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980759.17}, {1950., 980759.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980775.99}, {1950., 980775.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980779.78}, {1950., 980779.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980790.65}, {1950., 980790.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980809.18}, {1950., 980809.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980814.83}, {1950., 980814.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980838.05}, {1950., 980838.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980845.01}, {1950., 980845.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980850.28}, {1950., 980850.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980861.32}, {1950., 980861.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980883.73}, {1950., 980883.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980890.49}, {1950., 980890.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980894.99}, {1950., 980894.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980900.95}, {1950., 980900.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980911.19}, {1950., 980911.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980917.99}, {1950., 980917.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980934.95}, {1950., 980934.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980943.77}, {1950., 980943.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980982.25}, {1950., 980982.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 980997.31}, {1950., 980997.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981000.94}, {1950., 981000.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981002.74}, {1950., 981002.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981009.15}, {1950., 981009.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981021.83}, {1950., 981021.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981032.34}, {1950., 981032.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981037.86}, {1950., 981037.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981060.39}, {1950., 981060.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981098.33}, {1950., 981098.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981099.27}, {1950., 981099.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981106.62}, {1950., 981106.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981107.11}, {1950., 981107.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981113.51}, {1950., 981113.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981132.45}, {1950., 981132.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981138.68}, {1950., 981138.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981154.11}, {1950., 981154.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981184.45}, {1950., 981184.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981194.68}, {1950., 981194.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981206.1}, {1950., 981206.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981211.46}, {1950., 981211.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981223.35}, {1950., 981223.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981229.58}, {1950., 981229.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981249.17}, {1950., 981249.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981282.35}, {1950., 981282.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981315.22}, {1950., 981315.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981324.6}, {1950., 981324.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981332.52}, {1950., 981332.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981350.76}, {1950., 981350.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981361.76}, {1950., 981361.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981407.75}, {1950., 981407.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981417.72}, {1950., 981417.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981441.21}, {1950., 981441.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981451.4}, {1950., 981451.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981471.12}, {1950., 981471.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981476.18}, {1950., 981476.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981518.56}, {1950., 981518.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981531.24}, {1950., 981531.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981575.77}, {1950., 981575.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981590.89}, {1950., 981590.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981652.91}, {1950., 981652.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981698.16}, {1950., 981698.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981709.54}, {1950., 981709.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981773.25}, {1950., 981773.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981818.84}, {1950., 981818.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981892.42}, {1950., 981892.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{1950., 981938.04}, {1950., 981938.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980168.19}, {2000., 980168.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980227.74}, {2000., 980227.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980294.21}, {2000., 980294.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980332.09}, {2000., 980332.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980365.66}, {2000., 980365.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980395.89}, {2000., 980395.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997459], 
      PointBox[{{2000., 980422.35}, {2000., 980422.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980440.9}, {2000., 980440.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980467.04}, {2000., 980467.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980477.04}, {2000., 980477.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980500.13}, {2000., 980500.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980519.21}, {2000., 980519.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980539.57}, {2000., 980539.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980542.35}, {2000., 980542.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980576.56}, {2000., 980576.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980577.18}, {2000., 980577.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980581.57}, {2000., 980581.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980600.11}, {2000., 980600.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980608.62}, {2000., 980608.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980620.2}, {2000., 980620.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980645.18}, {2000., 980645.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980657.}, {2000., 980657.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980666.45}, {2000., 980666.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980667.65}, {2000., 980667.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980682.76}, {2000., 980682.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980683.31}, {2000., 980683.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980699.75}, {2000., 980699.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980722.27}, {2000., 980722.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980733.73}, {2000., 980733.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980758.09}, {2000., 980758.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980759.17}, {2000., 980759.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980759.99}, {2000., 980759.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980775.91}, {2000., 980775.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980780.48}, {2000., 980780.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980791.52}, {2000., 980791.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980808.1}, {2000., 980808.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980814.12}, {2000., 980814.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980838.93}, {2000., 980838.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980845.44}, {2000., 980845.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980850.9}, {2000., 980850.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980862.05}, {2000., 980862.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980882.45}, {2000., 980882.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980890.45}, {2000., 980890.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980895.87}, {2000., 980895.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980899.82}, {2000., 980899.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980910.8}, {2000., 980910.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980918.91}, {2000., 980918.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980935.19}, {2000., 980935.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980944.48}, {2000., 980944.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980982.08}, {2000., 980982.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 980996.11}, {2000., 980996.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981001.81}, {2000., 981001.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981002.77}, {2000., 981002.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981009.41}, {2000., 981009.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981021.42}, {2000., 981021.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981031.78}, {2000., 981031.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981038.67}, {2000., 981038.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981061.1}, {2000., 981061.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981097.04}, {2000., 981097.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981099.86}, {2000., 981099.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981106.53}, {2000., 981106.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981107.49}, {2000., 981107.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981113.63}, {2000., 981113.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981133.36}, {2000., 981133.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981137.65}, {2000., 981137.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981154.15}, {2000., 981154.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981185.1}, {2000., 981185.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981195.41}, {2000., 981195.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981204.56}, {2000., 981204.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981212.33}, {2000., 981212.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981223.57}, {2000., 981223.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981228.75}, {2000., 981228.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981247.95}, {2000., 981247.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981282.67}, {2000., 981282.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981316.07}, {2000., 981316.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981325.35}, {2000., 981325.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981332.86}, {2000., 981332.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981349.76}, {2000., 981349.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981360.38}, {2000., 981360.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981408.29}, {2000., 981408.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981418.56}, {2000., 981418.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981441.69}, {2000., 981441.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981452.16}, {2000., 981452.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981469.97}, {2000., 981469.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981474.63}, {2000., 981474.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981519.44}, {2000., 981519.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981531.89}, {2000., 981531.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981576.55}, {2000., 981576.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981589.61}, {2000., 981589.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981653.69}, {2000., 981653.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981698.94}, {2000., 981698.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981708.19}, {2000., 981708.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981774.12}, {2000., 981774.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981819.63}, {2000., 981819.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981893.35}, {2000., 981893.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2000., 981938.84}, {2000., 981938.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980166.54}, {2050., 980166.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980226.16}, {2050., 980226.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980292.63}, {2050., 980292.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980332.53}, {2050., 980332.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980364.04}, {2050., 980364.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980396.42}, {2050., 980396.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997395], 
      PointBox[{{2050., 980423.29}, {2050., 980423.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980439.25}, {2050., 980439.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980467.61}, {2050., 980467.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980477.9}, {2050., 980477.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980500.82}, {2050., 980500.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980517.52}, {2050., 980517.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980540.31}, {2050., 980540.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980542.96}, {2050., 980542.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980577.35}, {2050., 980577.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980577.61}, {2050., 980577.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980580.44}, {2050., 980580.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980598.39}, {2050., 980598.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980609.29}, {2050., 980609.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980620.85}, {2050., 980620.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980644.16}, {2050., 980644.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980656.89}, {2050., 980656.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980666.92}, {2050., 980666.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980668.34}, {2050., 980668.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980681.57}, {2050., 980681.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980683.49}, {2050., 980683.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980700.43}, {2050., 980700.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980721.26}, {2050., 980721.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980732.57}, {2050., 980732.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980758.62}, {2050., 980758.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980759.45}, {2050., 980759.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980760.81}, {2050., 980760.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980775.82}, {2050., 980775.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980781.19}, {2050., 980781.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980792.39}, {2050., 980792.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980807.03}, {2050., 980807.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980813.38}, {2050., 980813.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980839.81}, {2050., 980839.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980845.89}, {2050., 980845.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980851.5}, {2050., 980851.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980862.77}, {2050., 980862.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980881.18}, {2050., 980881.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980890.4}, {2050., 980890.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980896.75}, {2050., 980896.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980898.69}, {2050., 980898.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980910.38}, {2050., 980910.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980919.82}, {2050., 980919.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980935.47}, {2050., 980935.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980945.18}, {2050., 980945.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980981.86}, {2050., 980981.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 980994.91}, {2050., 980994.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981002.69}, {2050., 981002.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981002.78}, {2050., 981002.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981009.63}, {2050., 981009.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981021.06}, {2050., 981021.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981031.27}, {2050., 981031.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981039.47}, {2050., 981039.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981061.81}, {2050., 981061.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981095.75}, {2050., 981095.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981100.45}, {2050., 981100.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981105.91}, {2050., 981105.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981108.36}, {2050., 981108.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981113.73}, {2050., 981113.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981134.27}, {2050., 981134.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981136.63}, {2050., 981136.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981154.23}, {2050., 981154.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981185.76}, {2050., 981185.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981196.14}, {2050., 981196.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981203.02}, {2050., 981203.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981213.19}, {2050., 981213.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981223.78}, {2050., 981223.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981227.9}, {2050., 981227.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981246.73}, {2050., 981246.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981283.03}, {2050., 981283.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981316.93}, {2050., 981316.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981326.09}, {2050., 981326.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981333.19}, {2050., 981333.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981348.73}, {2050., 981348.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981359.01}, {2050., 981359.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981408.85}, {2050., 981408.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981419.41}, {2050., 981419.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981442.16}, {2050., 981442.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981452.92}, {2050., 981452.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981468.81}, {2050., 981468.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981473.08}, {2050., 981473.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981520.32}, {2050., 981520.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981532.57}, {2050., 981532.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981577.32}, {2050., 981577.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981588.33}, {2050., 981588.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981654.48}, {2050., 981654.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981699.73}, {2050., 981699.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981706.85}, {2050., 981706.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981774.99}, {2050., 981774.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981820.43}, {2050., 981820.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981894.28}, {2050., 981894.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2050., 981939.63}, {2050., 981939.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980164.88}, {2100., 980164.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980224.56}, {2100., 980224.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980291.03}, {2100., 980291.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980332.95}, {2100., 980332.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980362.42}, {2100., 980362.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980396.94}, {2100., 980396.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997332], 
      PointBox[{{2100., 980424.22}, {2100., 980424.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980437.59}, {2100., 980437.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980468.19}, {2100., 980468.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980478.76}, {2100., 980478.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980501.5}, {2100., 980501.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980515.82}, {2100., 980515.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980541.03}, {2100., 980541.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980543.58}, {2100., 980543.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980578.04}, {2100., 980578.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980578.15}, {2100., 980578.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980579.32}, {2100., 980579.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980596.66}, {2100., 980596.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980609.94}, {2100., 980609.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980621.5}, {2100., 980621.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980643.17}, {2100., 980643.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980656.77}, {2100., 980656.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980667.38}, {2100., 980667.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980669.03}, {2100., 980669.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980679.82}, {2100., 980679.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980684.2}, {2100., 980684.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980701.11}, {2100., 980701.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980720.27}, {2100., 980720.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980731.36}, {2100., 980731.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980759.14}, {2100., 980759.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980759.8}, {2100., 980759.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980761.62}, {2100., 980761.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980775.71}, {2100., 980775.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980781.89}, {2100., 980781.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980793.26}, {2100., 980793.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980805.98}, {2100., 980805.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980812.63}, {2100., 980812.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980840.69}, {2100., 980840.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980846.37}, {2100., 980846.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980852.1}, {2100., 980852.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980863.49}, {2100., 980863.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980879.92}, {2100., 980879.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980890.32}, {2100., 980890.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980897.57}, {2100., 980897.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980897.63}, {2100., 980897.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980909.92}, {2100., 980909.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980920.74}, {2100., 980920.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980935.8}, {2100., 980935.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980945.87}, {2100., 980945.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980981.6}, {2100., 980981.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 980993.72}, {2100., 980993.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981002.77}, {2100., 981002.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981003.57}, {2100., 981003.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981009.81}, {2100., 981009.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981020.77}, {2100., 981020.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981030.83}, {2100., 981030.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981040.26}, {2100., 981040.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981062.52}, {2100., 981062.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981094.46}, {2100., 981094.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981101.03}, {2100., 981101.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981105.26}, {2100., 981105.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981109.24}, {2100., 981109.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981113.81}, {2100., 981113.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981135.18}, {2100., 981135.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981135.63}, {2100., 981135.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981154.37}, {2100., 981154.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981186.42}, {2100., 981186.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981196.87}, {2100., 981196.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981201.49}, {2100., 981201.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981214.06}, {2100., 981214.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981223.97}, {2100., 981223.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981227.02}, {2100., 981227.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981245.52}, {2100., 981245.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981283.42}, {2100., 981283.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981317.79}, {2100., 981317.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981326.85}, {2100., 981326.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981333.51}, {2100., 981333.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981347.69}, {2100., 981347.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981357.64}, {2100., 981357.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981409.42}, {2100., 981409.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981420.26}, {2100., 981420.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981442.62}, {2100., 981442.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981453.69}, {2100., 981453.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981467.64}, {2100., 981467.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981471.54}, {2100., 981471.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981521.2}, {2100., 981521.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981533.26}, {2100., 981533.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981578.1}, {2100., 981578.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981587.05}, {2100., 981587.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981655.28}, {2100., 981655.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981700.51}, {2100., 981700.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981705.51}, {2100., 981705.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981775.87}, {2100., 981775.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981821.22}, {2100., 981821.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981895.22}, {2100., 981895.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2100., 981940.43}, {2100., 981940.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980163.22}, {2150., 980163.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980222.96}, {2150., 980222.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980289.43}, {2150., 980289.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980333.38}, {2150., 980333.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980360.79}, {2150., 980360.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980397.47}, {2150., 980397.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997268], 
      PointBox[{{2150., 980425.16}, {2150., 980425.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980435.92}, {2150., 980435.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980468.77}, {2150., 980468.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980479.61}, {2150., 980479.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980502.17}, {2150., 980502.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980514.12}, {2150., 980514.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980541.74}, {2150., 980541.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980544.2}, {2150., 980544.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980578.22}, {2150., 980578.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980578.44}, {2150., 980578.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980578.96}, {2150., 980578.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980594.94}, {2150., 980594.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980610.57}, {2150., 980610.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980622.15}, {2150., 980622.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980642.21}, {2150., 980642.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980656.63}, {2150., 980656.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980667.82}, {2150., 980667.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980669.73}, {2150., 980669.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980678.07}, {2150., 980678.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980684.9}, {2150., 980684.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980701.79}, {2150., 980701.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980719.31}, {2150., 980719.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980730.09}, {2150., 980730.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980759.65}, {2150., 980759.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980760.2}, {2150., 980760.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980762.42}, {2150., 980762.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980775.58}, {2150., 980775.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980782.59}, {2150., 980782.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980794.13}, {2150., 980794.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980804.94}, {2150., 980804.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980811.86}, {2150., 980811.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980841.56}, {2150., 980841.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980846.88}, {2150., 980846.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980852.69}, {2150., 980852.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980864.2}, {2150., 980864.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980878.67}, {2150., 980878.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980890.22}, {2150., 980890.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980896.46}, {2150., 980896.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980898.51}, {2150., 980898.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980909.43}, {2150., 980909.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980921.65}, {2150., 980921.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980936.17}, {2150., 980936.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980946.55}, {2150., 980946.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980981.28}, {2150., 980981.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 980992.53}, {2150., 980992.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981002.74}, {2150., 981002.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981004.45}, {2150., 981004.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981009.94}, {2150., 981009.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981020.54}, {2150., 981020.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981030.45}, {2150., 981030.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981041.06}, {2150., 981041.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981063.24}, {2150., 981063.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981093.18}, {2150., 981093.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981101.62}, {2150., 981101.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981104.57}, {2150., 981104.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981110.11}, {2150., 981110.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981113.87}, {2150., 981113.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981134.65}, {2150., 981134.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981136.09}, {2150., 981136.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981154.55}, {2150., 981154.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981187.09}, {2150., 981187.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981197.61}, {2150., 981197.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981199.96}, {2150., 981199.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981214.93}, {2150., 981214.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981224.14}, {2150., 981224.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981226.11}, {2150., 981226.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981244.32}, {2150., 981244.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981283.84}, {2150., 981283.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981318.65}, {2150., 981318.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981327.6}, {2150., 981327.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981333.82}, {2150., 981333.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981346.63}, {2150., 981346.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981356.27}, {2150., 981356.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981410.02}, {2150., 981410.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981421.12}, {2150., 981421.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981443.07}, {2150., 981443.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981454.46}, {2150., 981454.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981466.46}, {2150., 981466.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981470.}, {2150., 981470.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981522.09}, {2150., 981522.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981533.97}, {2150., 981533.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981578.88}, {2150., 981578.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981585.76}, {2150., 981585.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981656.09}, {2150., 981656.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981701.3}, {2150., 981701.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981704.17}, {2150., 981704.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981776.75}, {2150., 981776.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981822.02}, {2150., 981822.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981896.15}, {2150., 981896.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2150., 981941.23}, {2150., 981941.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980161.56}, {2200., 980161.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980221.36}, {2200., 980221.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980287.83}, {2200., 980287.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980333.8}, {2200., 980333.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980359.16}, {2200., 980359.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980397.99}, {2200., 980397.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997204], 
      PointBox[{{2200., 980426.09}, {2200., 980426.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980434.26}, {2200., 980434.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980469.34}, {2200., 980469.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980480.47}, {2200., 980480.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980502.84}, {2200., 980502.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980512.42}, {2200., 980512.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980542.43}, {2200., 980542.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980544.81}, {2200., 980544.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980577.13}, {2200., 980577.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980578.83}, {2200., 980578.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980579.76}, {2200., 980579.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980593.21}, {2200., 980593.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980611.18}, {2200., 980611.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980622.8}, {2200., 980622.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980641.28}, {2200., 980641.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980656.48}, {2200., 980656.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980668.25}, {2200., 980668.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980670.44}, {2200., 980670.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980676.32}, {2200., 980676.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980685.58}, {2200., 980685.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980702.46}, {2200., 980702.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980718.38}, {2200., 980718.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980728.78}, {2200., 980728.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980760.15}, {2200., 980760.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980760.64}, {2200., 980760.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980763.21}, {2200., 980763.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980775.44}, {2200., 980775.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980783.29}, {2200., 980783.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980795.01}, {2200., 980795.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980803.92}, {2200., 980803.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980811.09}, {2200., 980811.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980842.44}, {2200., 980842.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980847.41}, {2200., 980847.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980853.27}, {2200., 980853.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980864.91}, {2200., 980864.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980877.44}, {2200., 980877.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980890.1}, {2200., 980890.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980895.37}, {2200., 980895.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980899.4}, {2200., 980899.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980908.92}, {2200., 980908.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980922.57}, {2200., 980922.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980936.57}, {2200., 980936.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980947.23}, {2200., 980947.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980980.92}, {2200., 980980.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 980991.35}, {2200., 980991.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981002.69}, {2200., 981002.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981005.34}, {2200., 981005.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981010.01}, {2200., 981010.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981020.37}, {2200., 981020.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981030.14}, {2200., 981030.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981041.85}, {2200., 981041.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981063.96}, {2200., 981063.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981091.89}, {2200., 981091.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981102.2}, {2200., 981102.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981103.84}, {2200., 981103.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981110.99}, {2200., 981110.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981113.91}, {2200., 981113.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981133.68}, {2200., 981133.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981137.01}, {2200., 981137.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981154.77}, {2200., 981154.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981187.77}, {2200., 981187.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981198.35}, {2200., 981198.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981198.44}, {2200., 981198.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981215.8}, {2200., 981215.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981224.3}, {2200., 981224.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981225.18}, {2200., 981225.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981243.13}, {2200., 981243.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981284.29}, {2200., 981284.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981319.52}, {2200., 981319.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981328.36}, {2200., 981328.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981334.11}, {2200., 981334.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981345.56}, {2200., 981345.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981354.92}, {2200., 981354.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981410.63}, {2200., 981410.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981421.98}, {2200., 981421.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981443.52}, {2200., 981443.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981455.23}, {2200., 981455.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981465.27}, {2200., 981465.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981468.47}, {2200., 981468.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981522.97}, {2200., 981522.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981534.7}, {2200., 981534.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981579.67}, {2200., 981579.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981584.48}, {2200., 981584.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981656.91}, {2200., 981656.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981702.1}, {2200., 981702.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981702.84}, {2200., 981702.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981777.64}, {2200., 981777.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981822.82}, {2200., 981822.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981897.09}, {2200., 981897.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2200., 981942.03}, {2200., 981942.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980159.89}, {2250., 980159.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980219.75}, {2250., 980219.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980286.21}, {2250., 980286.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980334.21}, {2250., 980334.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980357.52}, {2250., 980357.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980398.51}, {2250., 980398.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997141], 
      PointBox[{{2250., 980427.02}, {2250., 980427.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980432.58}, {2250., 980432.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980469.91}, {2250., 980469.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980481.34}, {2250., 980481.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980503.5}, {2250., 980503.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980510.72}, {2250., 980510.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980543.11}, {2250., 980543.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980545.42}, {2250., 980545.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980576.06}, {2250., 980576.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980579.21}, {2250., 980579.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980580.57}, {2250., 980580.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980591.47}, {2250., 980591.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980611.75}, {2250., 980611.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980623.44}, {2250., 980623.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980640.4}, {2250., 980640.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980656.31}, {2250., 980656.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980668.67}, {2250., 980668.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980671.15}, {2250., 980671.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980674.57}, {2250., 980674.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980686.24}, {2250., 980686.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980703.13}, {2250., 980703.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980717.48}, {2250., 980717.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980727.44}, {2250., 980727.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980760.63}, {2250., 980760.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980761.13}, {2250., 980761.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980764.}, {2250., 980764.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980775.27}, {2250., 980775.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980783.98}, {2250., 980783.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980795.89}, {2250., 980795.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980802.92}, {2250., 980802.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980810.3}, {2250., 980810.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980843.31}, {2250., 980843.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980847.95}, {2250., 980847.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980853.84}, {2250., 980853.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980865.62}, {2250., 980865.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980876.22}, {2250., 980876.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980889.95}, {2250., 980889.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980894.29}, {2250., 980894.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980900.28}, {2250., 980900.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980908.39}, {2250., 980908.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980923.48}, {2250., 980923.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980937.}, {2250., 980937.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980947.9}, {2250., 980947.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980980.51}, {2250., 980980.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 980990.18}, {2250., 980990.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981002.62}, {2250., 981002.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981006.22}, {2250., 981006.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981010.02}, {2250., 981010.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981020.27}, {2250., 981020.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981029.9}, {2250., 981029.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981042.63}, {2250., 981042.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981064.68}, {2250., 981064.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981090.61}, {2250., 981090.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981102.78}, {2250., 981102.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981103.09}, {2250., 981103.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981111.87}, {2250., 981111.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981113.93}, {2250., 981113.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981132.74}, {2250., 981132.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981137.92}, {2250., 981137.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981155.03}, {2250., 981155.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981188.46}, {2250., 981188.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981196.93}, {2250., 981196.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981199.09}, {2250., 981199.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981216.67}, {2250., 981216.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981224.23}, {2250., 981224.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981224.44}, {2250., 981224.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981241.95}, {2250., 981241.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981284.77}, {2250., 981284.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981320.39}, {2250., 981320.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981329.12}, {2250., 981329.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981334.39}, {2250., 981334.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981344.47}, {2250., 981344.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981353.57}, {2250., 981353.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981411.27}, {2250., 981411.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981422.85}, {2250., 981422.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981443.96}, {2250., 981443.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981456.}, {2250., 981456.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981464.08}, {2250., 981464.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981466.94}, {2250., 981466.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981523.86}, {2250., 981523.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981535.43}, {2250., 981535.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981580.45}, {2250., 981580.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981583.2}, {2250., 981583.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981657.73}, {2250., 981657.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981701.52}, {2250., 981701.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981702.89}, {2250., 981702.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981778.53}, {2250., 981778.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981823.62}, {2250., 981823.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981898.02}, {2250., 981898.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2250., 981942.84}, {2250., 981942.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980158.22}, {2300., 980158.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980218.13}, {2300., 980218.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980284.59}, {2300., 980284.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980334.62}, {2300., 980334.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980355.88}, {2300., 980355.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980399.02}, {2300., 980399.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997077], 
      PointBox[{{2300., 980427.96}, {2300., 980427.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980430.91}, {2300., 980430.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980470.48}, {2300., 980470.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980482.2}, {2300., 980482.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980504.16}, {2300., 980504.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980509.01}, {2300., 980509.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980543.76}, {2300., 980543.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980546.03}, {2300., 980546.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980575.02}, {2300., 980575.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980579.57}, {2300., 980579.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980581.38}, {2300., 980581.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980589.74}, {2300., 980589.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980612.29}, {2300., 980612.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980624.08}, {2300., 980624.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980639.55}, {2300., 980639.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980656.13}, {2300., 980656.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980669.07}, {2300., 980669.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980671.87}, {2300., 980671.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980672.81}, {2300., 980672.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980686.87}, {2300., 980686.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980703.8}, {2300., 980703.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980716.61}, {2300., 980716.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980726.06}, {2300., 980726.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980761.1}, {2300., 980761.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980761.65}, {2300., 980761.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980764.78}, {2300., 980764.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980775.09}, {2300., 980775.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980784.67}, {2300., 980784.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980796.76}, {2300., 980796.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980801.94}, {2300., 980801.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980809.51}, {2300., 980809.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980844.18}, {2300., 980844.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980848.51}, {2300., 980848.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980854.4}, {2300., 980854.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980866.32}, {2300., 980866.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980875.02}, {2300., 980875.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980889.78}, {2300., 980889.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980893.22}, {2300., 980893.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980901.17}, {2300., 980901.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980907.83}, {2300., 980907.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980924.4}, {2300., 980924.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980937.47}, {2300., 980937.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980948.57}, {2300., 980948.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980980.06}, {2300., 980980.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 980989.01}, {2300., 980989.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981002.53}, {2300., 981002.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981007.1}, {2300., 981007.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981009.98}, {2300., 981009.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981020.23}, {2300., 981020.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981029.74}, {2300., 981029.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981043.41}, {2300., 981043.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981065.41}, {2300., 981065.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981089.33}, {2300., 981089.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981102.3}, {2300., 981102.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981103.35}, {2300., 981103.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981112.75}, {2300., 981112.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981113.93}, {2300., 981113.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981131.83}, {2300., 981131.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981138.83}, {2300., 981138.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981155.33}, {2300., 981155.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981189.15}, {2300., 981189.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981195.42}, {2300., 981195.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981199.84}, {2300., 981199.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981217.55}, {2300., 981217.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981223.27}, {2300., 981223.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981224.56}, {2300., 981224.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981240.79}, {2300., 981240.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981285.28}, {2300., 981285.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981321.26}, {2300., 981321.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981329.88}, {2300., 981329.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981334.65}, {2300., 981334.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981343.38}, {2300., 981343.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981352.23}, {2300., 981352.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981411.92}, {2300., 981411.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981423.72}, {2300., 981423.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981444.38}, {2300., 981444.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981456.78}, {2300., 981456.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981462.88}, {2300., 981462.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981465.41}, {2300., 981465.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981524.75}, {2300., 981524.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981536.18}, {2300., 981536.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981581.24}, {2300., 981581.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981581.92}, {2300., 981581.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981658.56}, {2300., 981658.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981700.2}, {2300., 981700.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981703.68}, {2300., 981703.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981779.42}, {2300., 981779.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981824.42}, {2300., 981824.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981898.96}, {2300., 981898.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2300., 981943.64}, {2300., 981943.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980156.55}, {2350., 980156.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980216.51}, {2350., 980216.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980282.97}, {2350., 980282.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980335.02}, {2350., 980335.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980354.23}, {2350., 980354.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980399.53}, {2350., 980399.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99997014], 
      PointBox[{{2350., 980428.89}, {2350., 980428.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980429.23}, {2350., 980429.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980471.05}, {2350., 980471.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980483.06}, {2350., 980483.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980504.81}, {2350., 980504.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980507.3}, {2350., 980507.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980544.39}, {2350., 980544.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980546.64}, {2350., 980546.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980574.}, {2350., 980574.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980579.91}, {2350., 980579.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980582.19}, {2350., 980582.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980588.}, {2350., 980588.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980612.78}, {2350., 980612.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980624.72}, {2350., 980624.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980638.76}, {2350., 980638.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980655.93}, {2350., 980655.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980669.46}, {2350., 980669.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980671.06}, {2350., 980671.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980672.6}, {2350., 980672.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980687.48}, {2350., 980687.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980704.47}, {2350., 980704.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980715.78}, {2350., 980715.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980724.66}, {2350., 980724.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980761.56}, {2350., 980761.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980762.21}, {2350., 980762.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980765.54}, {2350., 980765.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980774.88}, {2350., 980774.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980785.36}, {2350., 980785.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980797.64}, {2350., 980797.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980800.98}, {2350., 980800.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980808.71}, {2350., 980808.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980845.04}, {2350., 980845.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980849.09}, {2350., 980849.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980854.95}, {2350., 980854.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980867.02}, {2350., 980867.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980873.83}, {2350., 980873.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980889.58}, {2350., 980889.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980892.18}, {2350., 980892.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980902.05}, {2350., 980902.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980907.26}, {2350., 980907.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980925.31}, {2350., 980925.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980937.96}, {2350., 980937.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980949.22}, {2350., 980949.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980979.56}, {2350., 980979.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 980987.86}, {2350., 980987.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981002.41}, {2350., 981002.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981007.99}, {2350., 981007.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981009.87}, {2350., 981009.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981020.24}, {2350., 981020.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981029.66}, {2350., 981029.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981044.19}, {2350., 981044.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981066.14}, {2350., 981066.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981088.06}, {2350., 981088.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981101.49}, {2350., 981101.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981103.92}, {2350., 981103.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981113.63}, {2350., 981113.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981113.92}, {2350., 981113.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981130.94}, {2350., 981130.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981139.74}, {2350., 981139.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981155.67}, {2350., 981155.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981189.85}, {2350., 981189.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981193.92}, {2350., 981193.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981200.59}, {2350., 981200.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981218.43}, {2350., 981218.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981222.29}, {2350., 981222.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981224.66}, {2350., 981224.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981239.63}, {2350., 981239.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981285.8}, {2350., 981285.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981322.13}, {2350., 981322.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981330.64}, {2350., 981330.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981334.9}, {2350., 981334.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981342.27}, {2350., 981342.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981350.9}, {2350., 981350.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981412.58}, {2350., 981412.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981424.59}, {2350., 981424.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981444.8}, {2350., 981444.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981457.56}, {2350., 981457.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981461.69}, {2350., 981461.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981463.88}, {2350., 981463.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981525.64}, {2350., 981525.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981536.94}, {2350., 981536.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981580.64}, {2350., 981580.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981582.03}, {2350., 981582.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981659.4}, {2350., 981659.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981698.89}, {2350., 981698.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981704.48}, {2350., 981704.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981780.31}, {2350., 981780.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981825.22}, {2350., 981825.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981899.89}, {2350., 981899.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2350., 981944.45}, {2350., 981944.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980154.87}, {2400., 980154.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980214.88}, {2400., 980214.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980281.34}, {2400., 980281.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980335.42}, {2400., 980335.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980352.57}, {2400., 980352.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980400.04}, {2400., 980400.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980427.54}, {2400., 980427.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.9999695], 
      PointBox[{{2400., 980429.83}, {2400., 980429.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980471.61}, {2400., 980471.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980483.92}, {2400., 980483.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980505.44}, {2400., 980505.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980505.58}, {2400., 980505.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980544.99}, {2400., 980544.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980547.24}, {2400., 980547.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980573.02}, {2400., 980573.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980580.24}, {2400., 980580.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980583.}, {2400., 980583.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980586.26}, {2400., 980586.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980613.23}, {2400., 980613.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980625.36}, {2400., 980625.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980638.02}, {2400., 980638.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980655.72}, {2400., 980655.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980669.3}, {2400., 980669.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980669.83}, {2400., 980669.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980673.34}, {2400., 980673.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980688.06}, {2400., 980688.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980705.13}, {2400., 980705.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980715.}, {2400., 980715.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980723.23}, {2400., 980723.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980762.}, {2400., 980762.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980762.79}, {2400., 980762.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980766.29}, {2400., 980766.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980774.66}, {2400., 980774.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980786.04}, {2400., 980786.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980798.52}, {2400., 980798.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980800.05}, {2400., 980800.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980807.9}, {2400., 980807.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980845.9}, {2400., 980845.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980849.68}, {2400., 980849.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980855.49}, {2400., 980855.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980867.72}, {2400., 980867.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980872.67}, {2400., 980872.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980889.34}, {2400., 980889.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980891.17}, {2400., 980891.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980902.94}, {2400., 980902.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980906.67}, {2400., 980906.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980926.22}, {2400., 980926.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980938.48}, {2400., 980938.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980949.87}, {2400., 980949.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980979.02}, {2400., 980979.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 980986.71}, {2400., 980986.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981002.28}, {2400., 981002.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981008.87}, {2400., 981008.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981009.71}, {2400., 981009.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981020.31}, {2400., 981020.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981029.65}, {2400., 981029.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981044.96}, {2400., 981044.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981066.88}, {2400., 981066.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981086.79}, {2400., 981086.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981100.66}, {2400., 981100.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981104.47}, {2400., 981104.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981113.88}, {2400., 981113.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981114.51}, {2400., 981114.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981130.07}, {2400., 981130.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981140.64}, {2400., 981140.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981156.05}, {2400., 981156.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981190.55}, {2400., 981190.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981192.43}, {2400., 981192.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981201.34}, {2400., 981201.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981219.3}, {2400., 981219.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981221.29}, {2400., 981221.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981224.75}, {2400., 981224.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981238.49}, {2400., 981238.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981286.36}, {2400., 981286.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981323.01}, {2400., 981323.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981331.41}, {2400., 981331.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981335.14}, {2400., 981335.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981341.16}, {2400., 981341.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981349.58}, {2400., 981349.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981413.26}, {2400., 981413.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981425.47}, {2400., 981425.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981445.21}, {2400., 981445.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981458.34}, {2400., 981458.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981460.49}, {2400., 981460.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981462.36}, {2400., 981462.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981526.53}, {2400., 981526.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981537.71}, {2400., 981537.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981579.37}, {2400., 981579.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981582.82}, {2400., 981582.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981660.24}, {2400., 981660.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981697.59}, {2400., 981697.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981705.28}, {2400., 981705.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981781.2}, {2400., 981781.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981826.02}, {2400., 981826.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981900.82}, {2400., 981900.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2400., 981945.25}, {2400., 981945.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980153.19}, {2450., 980153.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980213.25}, {2450., 980213.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980279.71}, {2450., 980279.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980335.8}, {2450., 980335.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980350.92}, {2450., 980350.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980400.54}, {2450., 980400.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980425.85}, {2450., 980425.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996887], 
      PointBox[{{2450., 980430.76}, {2450., 980430.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980472.17}, {2450., 980472.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980484.79}, {2450., 980484.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980503.87}, {2450., 980503.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980506.07}, {2450., 980506.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980545.56}, {2450., 980545.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980547.84}, {2450., 980547.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980572.07}, {2450., 980572.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980580.54}, {2450., 980580.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980583.81}, {2450., 980583.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980584.52}, {2450., 980584.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980613.63}, {2450., 980613.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980625.99}, {2450., 980625.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980637.34}, {2450., 980637.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980655.5}, {2450., 980655.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980667.54}, {2450., 980667.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980670.18}, {2450., 980670.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980674.08}, {2450., 980674.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980688.6}, {2450., 980688.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980705.79}, {2450., 980705.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980714.27}, {2450., 980714.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980721.79}, {2450., 980721.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980762.43}, {2450., 980762.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980763.39}, {2450., 980763.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980767.03}, {2450., 980767.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980774.43}, {2450., 980774.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980786.72}, {2450., 980786.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980799.15}, {2450., 980799.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980799.4}, {2450., 980799.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980807.08}, {2450., 980807.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980846.76}, {2450., 980846.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980850.28}, {2450., 980850.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980856.01}, {2450., 980856.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980868.41}, {2450., 980868.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980871.52}, {2450., 980871.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980889.04}, {2450., 980889.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980890.22}, {2450., 980890.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980903.82}, {2450., 980903.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980906.07}, {2450., 980906.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980927.14}, {2450., 980927.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980939.02}, {2450., 980939.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980950.51}, {2450., 980950.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980978.44}, {2450., 980978.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 980985.57}, {2450., 980985.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981002.12}, {2450., 981002.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981009.48}, {2450., 981009.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981009.76}, {2450., 981009.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981020.44}, {2450., 981020.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981029.71}, {2450., 981029.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981045.73}, {2450., 981045.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981067.61}, {2450., 981067.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981085.53}, {2450., 981085.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981099.81}, {2450., 981099.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981105.01}, {2450., 981105.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981113.81}, {2450., 981113.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981115.4}, {2450., 981115.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981129.24}, {2450., 981129.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981141.55}, {2450., 981141.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981156.45}, {2450., 981156.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981190.94}, {2450., 981190.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981191.26}, {2450., 981191.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981202.09}, {2450., 981202.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981220.19}, {2450., 981220.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981220.29}, {2450., 981220.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981224.81}, {2450., 981224.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981237.36}, {2450., 981237.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981286.93}, {2450., 981286.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981323.89}, {2450., 981323.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981332.18}, {2450., 981332.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981335.36}, {2450., 981335.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981340.05}, {2450., 981340.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981348.26}, {2450., 981348.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981413.95}, {2450., 981413.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981426.35}, {2450., 981426.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981445.61}, {2450., 981445.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981459.12}, {2450., 981459.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981459.29}, {2450., 981459.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981460.85}, {2450., 981460.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981527.43}, {2450., 981527.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981538.48}, {2450., 981538.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981578.1}, {2450., 981578.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981583.61}, {2450., 981583.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981661.09}, {2450., 981661.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981696.29}, {2450., 981696.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981706.08}, {2450., 981706.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981782.1}, {2450., 981782.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981826.83}, {2450., 981826.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981901.76}, {2450., 981901.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2450., 981946.06}, {2450., 981946.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980151.51}, {2500., 980151.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980211.61}, {2500., 980211.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980278.07}, {2500., 980278.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980336.19}, {2500., 980336.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980349.25}, {2500., 980349.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980401.04}, {2500., 980401.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980424.16}, {2500., 980424.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996823], 
      PointBox[{{2500., 980431.7}, {2500., 980431.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980472.73}, {2500., 980472.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980485.66}, {2500., 980485.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980502.15}, {2500., 980502.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980506.7}, {2500., 980506.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980546.08}, {2500., 980546.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980548.44}, {2500., 980548.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980571.17}, {2500., 980571.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980580.83}, {2500., 980580.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980582.78}, {2500., 980582.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980584.63}, {2500., 980584.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980613.97}, {2500., 980613.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980626.62}, {2500., 980626.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980636.74}, {2500., 980636.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980655.26}, {2500., 980655.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980665.78}, {2500., 980665.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980670.52}, {2500., 980670.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980674.83}, {2500., 980674.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980689.09}, {2500., 980689.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980706.44}, {2500., 980706.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980713.59}, {2500., 980713.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980720.33}, {2500., 980720.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980762.84}, {2500., 980762.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980764.01}, {2500., 980764.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980767.75}, {2500., 980767.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980774.17}, {2500., 980774.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980787.39}, {2500., 980787.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980798.27}, {2500., 980798.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980800.29}, {2500., 980800.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980806.26}, {2500., 980806.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980847.62}, {2500., 980847.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980850.89}, {2500., 980850.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980856.52}, {2500., 980856.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980869.1}, {2500., 980869.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980870.39}, {2500., 980870.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980888.56}, {2500., 980888.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980889.44}, {2500., 980889.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980904.71}, {2500., 980904.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980905.46}, {2500., 980905.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980928.05}, {2500., 980928.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980939.59}, {2500., 980939.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980951.14}, {2500., 980951.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980977.83}, {2500., 980977.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 980984.44}, {2500., 980984.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981001.94}, {2500., 981001.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981009.21}, {2500., 981009.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981010.65}, {2500., 981010.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981020.62}, {2500., 981020.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981029.84}, {2500., 981029.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981046.49}, {2500., 981046.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981068.35}, {2500., 981068.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981084.27}, {2500., 981084.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981098.94}, {2500., 981098.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981105.53}, {2500., 981105.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981113.73}, {2500., 981113.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981116.28}, {2500., 981116.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981128.45}, {2500., 981128.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981142.46}, {2500., 981142.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981156.89}, {2500., 981156.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981189.47}, {2500., 981189.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981191.97}, {2500., 981191.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981202.85}, {2500., 981202.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981219.27}, {2500., 981219.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981221.07}, {2500., 981221.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981224.86}, {2500., 981224.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981236.24}, {2500., 981236.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981287.52}, {2500., 981287.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981324.77}, {2500., 981324.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981332.95}, {2500., 981332.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981335.56}, {2500., 981335.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981338.93}, {2500., 981338.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981346.95}, {2500., 981346.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981414.65}, {2500., 981414.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981427.23}, {2500., 981427.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981446.}, {2500., 981446.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981458.09}, {2500., 981458.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981459.34}, {2500., 981459.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981459.9}, {2500., 981459.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981528.32}, {2500., 981528.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981539.27}, {2500., 981539.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981576.84}, {2500., 981576.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981584.4}, {2500., 981584.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981661.94}, {2500., 981661.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981695.}, {2500., 981695.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981706.88}, {2500., 981706.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981783.}, {2500., 981783.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981827.64}, {2500., 981827.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981902.69}, {2500., 981902.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2500., 981946.87}, {2500., 981946.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980149.83}, {2550., 980149.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980209.97}, {2550., 980209.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980276.42}, {2550., 980276.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980336.56}, {2550., 980336.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980347.59}, {2550., 980347.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980401.54}, {2550., 980401.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980422.47}, {2550., 980422.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.9999676], 
      PointBox[{{2550., 980432.63}, {2550., 980432.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980473.28}, {2550., 980473.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980486.52}, {2550., 980486.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980500.42}, {2550., 980500.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980507.31}, {2550., 980507.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980546.56}, {2550., 980546.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980549.03}, {2550., 980549.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980570.33}, {2550., 980570.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980581.03}, {2550., 980581.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980581.1}, {2550., 980581.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980585.44}, {2550., 980585.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980614.24}, {2550., 980614.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980627.24}, {2550., 980627.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980636.21}, {2550., 980636.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980655.01}, {2550., 980655.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980664.02}, {2550., 980664.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980670.84}, {2550., 980670.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980675.58}, {2550., 980675.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980689.55}, {2550., 980689.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980707.09}, {2550., 980707.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980712.98}, {2550., 980712.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980718.85}, {2550., 980718.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980763.24}, {2550., 980763.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980764.65}, {2550., 980764.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980768.44}, {2550., 980768.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980773.9}, {2550., 980773.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980788.06}, {2550., 980788.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980797.43}, {2550., 980797.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980801.17}, {2550., 980801.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980805.44}, {2550., 980805.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980848.47}, {2550., 980848.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980851.5}, {2550., 980851.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980857.02}, {2550., 980857.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980869.29}, {2550., 980869.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980869.79}, {2550., 980869.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980887.8}, {2550., 980887.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980888.94}, {2550., 980888.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980904.84}, {2550., 980904.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980905.6}, {2550., 980905.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980928.96}, {2550., 980928.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980940.17}, {2550., 980940.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980951.76}, {2550., 980951.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980977.19}, {2550., 980977.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 980983.32}, {2550., 980983.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981001.73}, {2550., 981001.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981008.88}, {2550., 981008.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981011.54}, {2550., 981011.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981020.84}, {2550., 981020.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981030.04}, {2550., 981030.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981047.25}, {2550., 981047.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981069.09}, {2550., 981069.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981083.03}, {2550., 981083.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981098.05}, {2550., 981098.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981106.03}, {2550., 981106.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981113.63}, {2550., 981113.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981117.17}, {2550., 981117.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981127.69}, {2550., 981127.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981143.37}, {2550., 981143.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981157.35}, {2550., 981157.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981188.}, {2550., 981188.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981192.68}, {2550., 981192.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981203.61}, {2550., 981203.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981218.25}, {2550., 981218.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981221.95}, {2550., 981221.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981224.89}, {2550., 981224.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981235.13}, {2550., 981235.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981288.13}, {2550., 981288.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981325.65}, {2550., 981325.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981333.72}, {2550., 981333.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981335.75}, {2550., 981335.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981337.81}, {2550., 981337.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981345.65}, {2550., 981345.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981415.37}, {2550., 981415.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981428.12}, {2550., 981428.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981446.38}, {2550., 981446.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981456.89}, {2550., 981456.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981457.83}, {2550., 981457.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981460.69}, {2550., 981460.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981529.21}, {2550., 981529.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981540.07}, {2550., 981540.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981575.59}, {2550., 981575.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981585.2}, {2550., 981585.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981662.79}, {2550., 981662.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981693.72}, {2550., 981693.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981707.69}, {2550., 981707.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981783.9}, {2550., 981783.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981828.45}, {2550., 981828.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981903.63}, {2550., 981903.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2550., 981947.68}, {2550., 981947.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980148.15}, {2600., 980148.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980208.33}, {2600., 980208.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980274.77}, {2600., 980274.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980336.93}, {2600., 980336.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980345.92}, {2600., 980345.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980402.02}, {2600., 980402.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980420.77}, {2600., 980420.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996696], 
      PointBox[{{2600., 980433.57}, {2600., 980433.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980473.83}, {2600., 980473.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980487.39}, {2600., 980487.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980498.7}, {2600., 980498.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980507.91}, {2600., 980507.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980546.98}, {2600., 980546.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980549.62}, {2600., 980549.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980569.55}, {2600., 980569.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980579.29}, {2600., 980579.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980581.34}, {2600., 980581.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980586.26}, {2600., 980586.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980614.44}, {2600., 980614.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980627.86}, {2600., 980627.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980635.77}, {2600., 980635.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980654.74}, {2600., 980654.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980662.26}, {2600., 980662.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980671.14}, {2600., 980671.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980676.33}, {2600., 980676.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980689.94}, {2600., 980689.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980707.74}, {2600., 980707.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980712.43}, {2600., 980712.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980717.36}, {2600., 980717.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980763.63}, {2600., 980763.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980765.31}, {2600., 980765.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980769.11}, {2600., 980769.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980773.62}, {2600., 980773.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980788.73}, {2600., 980788.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980796.63}, {2600., 980796.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980802.05}, {2600., 980802.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980804.61}, {2600., 980804.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980849.31}, {2600., 980849.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980852.11}, {2600., 980852.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980857.51}, {2600., 980857.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980868.22}, {2600., 980868.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980870.47}, {2600., 980870.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980886.9}, {2600., 980886.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980888.57}, {2600., 980888.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980904.2}, {2600., 980904.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980906.49}, {2600., 980906.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980929.87}, {2600., 980929.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980940.76}, {2600., 980940.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980952.37}, {2600., 980952.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980976.51}, {2600., 980976.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 980982.22}, {2600., 980982.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981001.51}, {2600., 981001.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981008.5}, {2600., 981008.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981012.43}, {2600., 981012.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981021.12}, {2600., 981021.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981030.3}, {2600., 981030.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981048.}, {2600., 981048.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981069.84}, {2600., 981069.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981081.79}, {2600., 981081.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981097.15}, {2600., 981097.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981106.5}, {2600., 981106.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981113.5}, {2600., 981113.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981118.06}, {2600., 981118.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981126.98}, {2600., 981126.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981144.28}, {2600., 981144.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981157.84}, {2600., 981157.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981186.53}, {2600., 981186.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981193.4}, {2600., 981193.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981204.37}, {2600., 981204.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981217.22}, {2600., 981217.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981222.84}, {2600., 981222.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981224.89}, {2600., 981224.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981234.03}, {2600., 981234.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981288.76}, {2600., 981288.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981326.53}, {2600., 981326.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981334.5}, {2600., 981334.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981335.92}, {2600., 981335.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981336.69}, {2600., 981336.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981344.36}, {2600., 981344.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981416.09}, {2600., 981416.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981429.01}, {2600., 981429.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981446.75}, {2600., 981446.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981455.7}, {2600., 981455.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981456.33}, {2600., 981456.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981461.48}, {2600., 981461.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981530.11}, {2600., 981530.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981540.87}, {2600., 981540.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981574.34}, {2600., 981574.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981586.}, {2600., 981586.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981663.65}, {2600., 981663.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981692.45}, {2600., 981692.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981708.49}, {2600., 981708.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981784.81}, {2600., 981784.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981829.26}, {2600., 981829.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981904.56}, {2600., 981904.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2600., 981948.5}, {2600., 981948.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980146.46}, {2650., 980146.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980206.68}, {2650., 980206.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980273.12}, {2650., 980273.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980337.29}, {2650., 980337.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980344.24}, {2650., 980344.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980402.51}, {2650., 980402.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980419.07}, {2650., 980419.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996633], 
      PointBox[{{2650., 980434.5}, {2650., 980434.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980474.37}, {2650., 980474.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980488.26}, {2650., 980488.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980496.97}, {2650., 980496.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980508.51}, {2650., 980508.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980547.33}, {2650., 980547.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980550.2}, {2650., 980550.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980568.84}, {2650., 980568.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980577.54}, {2650., 980577.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980581.57}, {2650., 980581.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980587.08}, {2650., 980587.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980614.56}, {2650., 980614.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980628.48}, {2650., 980628.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980635.42}, {2650., 980635.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980654.47}, {2650., 980654.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980660.49}, {2650., 980660.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980671.42}, {2650., 980671.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980677.1}, {2650., 980677.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980690.28}, {2650., 980690.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980708.38}, {2650., 980708.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980711.96}, {2650., 980711.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980715.86}, {2650., 980715.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980763.99}, {2650., 980763.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980765.98}, {2650., 980765.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980769.74}, {2650., 980769.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980773.33}, {2650., 980773.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980789.39}, {2650., 980789.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980795.87}, {2650., 980795.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980802.94}, {2650., 980802.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980803.77}, {2650., 980803.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980850.15}, {2650., 980850.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980852.71}, {2650., 980852.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980857.98}, {2650., 980857.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980867.18}, {2650., 980867.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980871.15}, {2650., 980871.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980885.98}, {2650., 980885.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980888.23}, {2650., 980888.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980903.56}, {2650., 980903.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980907.38}, {2650., 980907.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980930.78}, {2650., 980930.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980941.38}, {2650., 980941.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980952.97}, {2650., 980952.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980975.82}, {2650., 980975.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 980981.13}, {2650., 980981.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981001.26}, {2650., 981001.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981008.08}, {2650., 981008.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981013.32}, {2650., 981013.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981021.43}, {2650., 981021.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981030.61}, {2650., 981030.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981048.75}, {2650., 981048.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981070.58}, {2650., 981070.58}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981080.56}, {2650., 981080.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981096.24}, {2650., 981096.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981106.93}, {2650., 981106.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981113.35}, {2650., 981113.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981118.95}, {2650., 981118.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981126.31}, {2650., 981126.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981145.18}, {2650., 981145.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981158.35}, {2650., 981158.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981185.08}, {2650., 981185.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981194.12}, {2650., 981194.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981205.13}, {2650., 981205.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981216.19}, {2650., 981216.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981223.72}, {2650., 981223.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981224.88}, {2650., 981224.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981232.95}, {2650., 981232.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981289.4}, {2650., 981289.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981327.42}, {2650., 981327.42}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981335.28}, {2650., 981335.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981335.57}, {2650., 981335.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981336.08}, {2650., 981336.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981343.08}, {2650., 981343.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981416.83}, {2650., 981416.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981429.89}, {2650., 981429.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981447.11}, {2650., 981447.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981454.51}, {2650., 981454.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981454.83}, {2650., 981454.83}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981462.27}, {2650., 981462.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981531.01}, {2650., 981531.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981541.68}, {2650., 981541.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981573.09}, {2650., 981573.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981586.8}, {2650., 981586.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981664.52}, {2650., 981664.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981691.18}, {2650., 981691.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981709.3}, {2650., 981709.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981785.71}, {2650., 981785.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981830.07}, {2650., 981830.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981905.5}, {2650., 981905.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2650., 981949.31}, {2650., 981949.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980144.77}, {2700., 980144.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980205.02}, {2700., 980205.02}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980271.46}, {2700., 980271.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980337.64}, {2700., 980337.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980342.56}, {2700., 980342.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980402.98}, {2700., 980402.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980417.36}, {2700., 980417.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996569], 
      PointBox[{{2700., 980435.43}, {2700., 980435.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980474.91}, {2700., 980474.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980489.13}, {2700., 980489.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980495.24}, {2700., 980495.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980509.09}, {2700., 980509.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980547.61}, {2700., 980547.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980550.78}, {2700., 980550.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980568.21}, {2700., 980568.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980575.79}, {2700., 980575.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980581.78}, {2700., 980581.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980587.9}, {2700., 980587.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980614.6}, {2700., 980614.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980629.09}, {2700., 980629.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980635.16}, {2700., 980635.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980654.17}, {2700., 980654.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980658.73}, {2700., 980658.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980671.69}, {2700., 980671.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980677.86}, {2700., 980677.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980690.56}, {2700., 980690.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980709.01}, {2700., 980709.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980711.56}, {2700., 980711.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980714.35}, {2700., 980714.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980764.34}, {2700., 980764.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980766.66}, {2700., 980766.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980770.32}, {2700., 980770.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980773.04}, {2700., 980773.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980790.05}, {2700., 980790.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980795.15}, {2700., 980795.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980802.93}, {2700., 980802.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980803.82}, {2700., 980803.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980850.98}, {2700., 980850.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980853.31}, {2700., 980853.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980858.44}, {2700., 980858.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980866.18}, {2700., 980866.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980871.82}, {2700., 980871.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980885.07}, {2700., 980885.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980887.88}, {2700., 980887.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980902.92}, {2700., 980902.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980908.27}, {2700., 980908.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980931.69}, {2700., 980931.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980942.01}, {2700., 980942.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980953.56}, {2700., 980953.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980975.1}, {2700., 980975.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 980980.05}, {2700., 980980.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981000.99}, {2700., 981000.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981007.63}, {2700., 981007.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981014.21}, {2700., 981014.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981021.78}, {2700., 981021.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981030.97}, {2700., 981030.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981049.49}, {2700., 981049.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981071.33}, {2700., 981071.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981079.34}, {2700., 981079.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981095.32}, {2700., 981095.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981107.33}, {2700., 981107.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981113.18}, {2700., 981113.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981119.84}, {2700., 981119.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981125.7}, {2700., 981125.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981146.09}, {2700., 981146.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981158.89}, {2700., 981158.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981183.64}, {2700., 981183.64}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981194.84}, {2700., 981194.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981205.9}, {2700., 981205.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981215.16}, {2700., 981215.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981224.61}, {2700., 981224.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981224.85}, {2700., 981224.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981231.88}, {2700., 981231.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981290.05}, {2700., 981290.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981328.31}, {2700., 981328.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981334.45}, {2700., 981334.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981336.06}, {2700., 981336.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981336.22}, {2700., 981336.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981341.8}, {2700., 981341.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981417.57}, {2700., 981417.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981430.78}, {2700., 981430.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981447.46}, {2700., 981447.46}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981453.33}, {2700., 981453.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981453.34}, {2700., 981453.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981463.06}, {2700., 981463.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981531.91}, {2700., 981531.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981542.49}, {2700., 981542.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981571.86}, {2700., 981571.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981587.6}, {2700., 981587.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981665.38}, {2700., 981665.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981689.93}, {2700., 981689.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981710.11}, {2700., 981710.11}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981786.62}, {2700., 981786.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981830.88}, {2700., 981830.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981906.43}, {2700., 981906.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2700., 981950.13}, {2700., 981950.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980143.08}, {2750., 980143.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980203.37}, {2750., 980203.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980269.8}, {2750., 980269.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980337.99}, {2750., 980337.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980340.88}, {2750., 980340.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980403.45}, {2750., 980403.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980415.65}, {2750., 980415.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996506], 
      PointBox[{{2750., 980436.37}, {2750., 980436.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980475.44}, {2750., 980475.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980490.}, {2750., 980490.}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980493.51}, {2750., 980493.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980509.66}, {2750., 980509.66}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980547.8}, {2750., 980547.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980551.35}, {2750., 980551.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980567.68}, {2750., 980567.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980574.04}, {2750., 980574.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980581.96}, {2750., 980581.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980588.72}, {2750., 980588.72}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980614.56}, {2750., 980614.56}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980629.69}, {2750., 980629.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980635.01}, {2750., 980635.01}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980653.87}, {2750., 980653.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980656.96}, {2750., 980656.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980671.94}, {2750., 980671.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980678.63}, {2750., 980678.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980690.77}, {2750., 980690.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980709.65}, {2750., 980709.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980711.26}, {2750., 980711.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980712.84}, {2750., 980712.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980764.68}, {2750., 980764.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980767.36}, {2750., 980767.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980770.82}, {2750., 980770.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980772.78}, {2750., 980772.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980790.7}, {2750., 980790.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980794.49}, {2750., 980794.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980802.08}, {2750., 980802.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980804.71}, {2750., 980804.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980851.8}, {2750., 980851.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980853.89}, {2750., 980853.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980858.89}, {2750., 980858.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980865.23}, {2750., 980865.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980872.49}, {2750., 980872.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980884.17}, {2750., 980884.17}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980887.52}, {2750., 980887.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980902.26}, {2750., 980902.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980909.16}, {2750., 980909.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980932.59}, {2750., 980932.59}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980942.65}, {2750., 980942.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980954.14}, {2750., 980954.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980974.36}, {2750., 980974.36}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 980978.99}, {2750., 980978.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981000.7}, {2750., 981000.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981007.14}, {2750., 981007.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981015.1}, {2750., 981015.1}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981022.18}, {2750., 981022.18}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981031.37}, {2750., 981031.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981050.22}, {2750., 981050.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981072.09}, {2750., 981072.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981078.13}, {2750., 981078.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981094.4}, {2750., 981094.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981107.67}, {2750., 981107.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981112.98}, {2750., 981112.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981120.73}, {2750., 981120.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981125.16}, {2750., 981125.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981146.99}, {2750., 981146.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981159.45}, {2750., 981159.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981182.2}, {2750., 981182.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981195.57}, {2750., 981195.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981206.67}, {2750., 981206.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981214.12}, {2750., 981214.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981224.79}, {2750., 981224.79}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981225.5}, {2750., 981225.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981230.82}, {2750., 981230.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981290.73}, {2750., 981290.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981329.2}, {2750., 981329.2}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981333.34}, {2750., 981333.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981336.34}, {2750., 981336.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981336.84}, {2750., 981336.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981340.53}, {2750., 981340.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981418.33}, {2750., 981418.33}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981431.68}, {2750., 981431.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981447.8}, {2750., 981447.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981451.86}, {2750., 981451.86}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981452.15}, {2750., 981452.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981463.85}, {2750., 981463.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981532.81}, {2750., 981532.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981543.31}, {2750., 981543.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981570.63}, {2750., 981570.63}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981588.4}, {2750., 981588.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981666.25}, {2750., 981666.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981688.68}, {2750., 981688.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981710.92}, {2750., 981710.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981787.52}, {2750., 981787.52}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981831.7}, {2750., 981831.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981907.37}, {2750., 981907.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2750., 981950.94}, {2750., 981950.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980141.38}, {2800., 980141.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980201.71}, {2800., 980201.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980268.14}, {2800., 980268.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980338.32}, {2800., 980338.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980339.19}, {2800., 980339.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980403.91}, {2800., 980403.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980413.94}, {2800., 980413.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996442], 
      PointBox[{{2800., 980437.3}, {2800., 980437.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980475.97}, {2800., 980475.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980490.87}, {2800., 980490.87}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980491.77}, {2800., 980491.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980510.23}, {2800., 980510.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980547.9}, {2800., 980547.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980551.92}, {2800., 980551.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980567.25}, {2800., 980567.25}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980572.28}, {2800., 980572.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980582.12}, {2800., 980582.12}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980589.55}, {2800., 980589.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980614.43}, {2800., 980614.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980630.3}, {2800., 980630.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980634.95}, {2800., 980634.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980653.55}, {2800., 980653.55}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980655.19}, {2800., 980655.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980672.16}, {2800., 980672.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980679.41}, {2800., 980679.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980690.9}, {2800., 980690.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980710.27}, {2800., 980710.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980711.04}, {2800., 980711.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980711.31}, {2800., 980711.31}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980764.99}, {2800., 980764.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980768.07}, {2800., 980768.07}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980771.16}, {2800., 980771.16}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980772.62}, {2800., 980772.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980791.35}, {2800., 980791.35}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980793.88}, {2800., 980793.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980801.23}, {2800., 980801.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980805.6}, {2800., 980805.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980852.61}, {2800., 980852.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980854.44}, {2800., 980854.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980859.32}, {2800., 980859.32}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980864.34}, {2800., 980864.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980873.15}, {2800., 980873.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980883.29}, {2800., 980883.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980887.15}, {2800., 980887.15}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980901.6}, {2800., 980901.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980910.05}, {2800., 980910.05}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980933.5}, {2800., 980933.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980943.3}, {2800., 980943.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980954.71}, {2800., 980954.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980973.61}, {2800., 980973.61}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 980977.94}, {2800., 980977.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981000.38}, {2800., 981000.38}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981006.62}, {2800., 981006.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981015.99}, {2800., 981015.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981022.6}, {2800., 981022.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981031.82}, {2800., 981031.82}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981050.95}, {2800., 981050.95}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981072.84}, {2800., 981072.84}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981076.93}, {2800., 981076.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981093.47}, {2800., 981093.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981107.96}, {2800., 981107.96}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981112.77}, {2800., 981112.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981121.62}, {2800., 981121.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981124.68}, {2800., 981124.68}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981147.9}, {2800., 981147.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981160.03}, {2800., 981160.03}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981180.77}, {2800., 981180.77}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981196.29}, {2800., 981196.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981207.44}, {2800., 981207.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981213.09}, {2800., 981213.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981224.71}, {2800., 981224.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981226.39}, {2800., 981226.39}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981229.78}, {2800., 981229.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981291.41}, {2800., 981291.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981330.08}, {2800., 981330.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981332.22}, {2800., 981332.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981336.45}, {2800., 981336.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981337.62}, {2800., 981337.62}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981339.28}, {2800., 981339.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981419.09}, {2800., 981419.09}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981432.57}, {2800., 981432.57}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981448.13}, {2800., 981448.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981450.37}, {2800., 981450.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981450.98}, {2800., 981450.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981464.65}, {2800., 981464.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981533.71}, {2800., 981533.71}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981544.14}, {2800., 981544.14}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981569.41}, {2800., 981569.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981589.21}, {2800., 981589.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981667.13}, {2800., 981667.13}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981687.45}, {2800., 981687.45}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981711.73}, {2800., 981711.73}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981788.43}, {2800., 981788.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981832.51}, {2800., 981832.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981908.3}, {2800., 981908.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2800., 981951.76}, {2800., 981951.76}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980139.69}, {2850., 980139.69}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980200.04}, {2850., 980200.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980266.47}, {2850., 980266.47}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980337.5}, {2850., 980337.5}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980338.65}, {2850., 980338.65}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980404.37}, {2850., 980404.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980412.23}, {2850., 980412.23}}]}, {}}, {}}, {{}, {{}, 
     {Hue[1, 1, 1], PointSize[Large], AbsoluteThickness[1.6], Opacity[
      0.99996379], 
      PointBox[{{2850., 980438.24}, {2850., 980438.24}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980476.49}, {2850., 980476.49}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980490.04}, {2850., 980490.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980491.74}, {2850., 980491.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980510.78}, {2850., 980510.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980547.89}, {2850., 980547.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980552.48}, {2850., 980552.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980566.93}, {2850., 980566.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980570.53}, {2850., 980570.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980582.26}, {2850., 980582.26}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980590.37}, {2850., 980590.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980614.22}, {2850., 980614.22}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980630.89}, {2850., 980630.89}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980634.98}, {2850., 980634.98}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980653.21}, {2850., 980653.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980653.43}, {2850., 980653.43}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980672.37}, {2850., 980672.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980680.19}, {2850., 980680.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980690.97}, {2850., 980690.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980709.78}, {2850., 980709.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980710.9}, {2850., 980710.9}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980710.92}, {2850., 980710.92}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980765.29}, {2850., 980765.29}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980768.78}, {2850., 980768.78}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980771.21}, {2850., 980771.21}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980772.7}, {2850., 980772.7}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980791.99}, {2850., 980791.99}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980793.34}, {2850., 980793.34}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980800.37}, {2850., 980800.37}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980806.48}, {2850., 980806.48}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980853.41}, {2850., 980853.41}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980854.93}, {2850., 980854.93}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980859.74}, {2850., 980859.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980863.53}, {2850., 980863.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980873.81}, {2850., 980873.81}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980882.44}, {2850., 980882.44}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980886.75}, {2850., 980886.75}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980900.94}, {2850., 980900.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980910.94}, {2850., 980910.94}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980934.4}, {2850., 980934.4}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980943.97}, {2850., 980943.97}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980955.27}, {2850., 980955.27}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980972.85}, {2850., 980972.85}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 980976.91}, {2850., 980976.91}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981000.04}, {2850., 981000.04}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981006.08}, {2850., 981006.08}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981016.88}, {2850., 981016.88}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981023.06}, {2850., 981023.06}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981032.3}, {2850., 981032.3}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981051.67}, {2850., 981051.67}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981073.6}, {2850., 981073.6}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981075.74}, {2850., 981075.74}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981092.54}, {2850., 981092.54}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981108.19}, {2850., 981108.19}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981112.53}, {2850., 981112.53}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981122.51}, {2850., 981122.51}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981124.28}, {2850., 981124.28}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981148.8}, {2850., 981148.8}}]}, {}}, {}}, {{}, {{}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.], 
      PointBox[{{2850., 981160.63}, {2850., 981160.63}}]}, {}}, {}}, {